#ifndef _DATA_TPMS_H_
#define _DATA_TPMS_H_

#include "common.h"
typedef struct __attribute__((aligned(4)))
{
	uint32_t  Front_Press_Value;
    uint32_t  Rear_Press_Value;	
	uint8_t   Front_TPMS_Valid;
    uint8_t   Rear_TPMS_Valid;
    uint8_t   TPMS_Warning;
    uint8_t   TPMS_Unit;
    uint32_t  TPMS_Front_Learn;
    uint32_t  TPMS_Rear_Learn;
  
}_TPMS_Display;
typedef enum
{
    Unstudied = 0,
    Learning,
    LearningCompletion,
    LearningFailure,
} TPMSLearning;
void Data_TPMS_KL30_Init ( void );
void Data_TPMS_Processing_Service ( void );
uint32_t Data_Bar_To_Psi (uint32_t bar);
uint8_t Get_Led_TPMS_Waring (void);
uint8_t Get_Front_TPMS_Sig_Vaild (void);
uint8_t Get_Rear_TPMS_Sig_Vaild (void);
uint16_t Get_Front_TPMS_Sig_Value (void);
uint16_t Get_Rear_TPMS_Sig_Value (void);
uint16_t Get_Rear_TPMS_TX (void);
uint16_t Get_Front_TPMS_TX (void);
void Data_TPMS_KL15_WAKE_UP_Init ( void );
#endif
