#include "FaultCode\FaultCode.h"
#include "Application.h"

uint8_t DTC_Amnt_Number = 0;            
uint8_t DTC_Amnt_Number_Count = 0;      
uint8_t FaultCode_Number = 0;          

uint32_t DTC_Data[FualtCodeMax] = {0};           
uint32_t DTC_Data_Count[FualtCodeMax] = {0};     
uint32_t FaultCode_Data[FualtCodeMax] = {0};    
uint32_t u32Countbuf = 0UL;
void Fault_Code_Receive(uint8_t CopyData[])
{
    uint8_t i = 0;
    
    ECU_FaultCode_Processing_Service();
}
uint8_t FaultCode_Compare(uint32_t FaultCode, uint32_t* CodeList, uint8_t len)
{
    uint8_t i = 0;
    uint8_t result = 0;  
    for(i = 0; i < len; i++)
    {
        if(FaultCode == CodeList[i])
        {
            result = 1;
        }
    }
    return result;
}
static void Fault_Code_App_Swap(uint32_t *pData1, uint32_t *pData2)
{
    uint32_t psw;
    if ((*pData1) > (*pData2))
    {
        psw = (*pData2);
        (*pData2) = (*pData1);
        (*pData1) = psw;
    }
}
static void Fault_Code_App_SortNByte(uint32_t *SortData, uint8_t len)
{
    uint8_t n = 0, m;

    for (; n < len - 1; n++)
    {
        for (m = n + 1; m < len; m++)
        {
            Fault_Code_App_Swap((SortData + n), (SortData + m));
        }
    }
}
void ECU_FaultCode_Processing_Service ( void )
{
    uint8_t DTCH1 = 0;
    uint8_t DTCM1 = 0;
    uint8_t DTCH2 = 0;
    uint8_t DTCM2 = 0;
    uint32_t DTC1 = 0;
    uint32_t DTC2 = 0;
    uint32_t i    = 0;
    if ( Common_Get_IG_Sts() == COMMON_POWER_ON )
    {
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CAN_0x402_Msg_Count) == CAN_SIG_LOST)
        {
            memset (FaultCode_Data, 0, FaultCode_Number);
            FaultCode_Number = 0;
        }
        else
        {
            DTCH1 =  Get_CAN_CH0_ID_402_Sig_ECU_DTCH1();
            DTCM1 =  Get_CAN_CH0_ID_402_Sig_ECU_DTCM1();
            DTCH2 =  Get_CAN_CH0_ID_402_Sig_ECU_DTCH2();
            DTCM2 =  Get_CAN_CH0_ID_402_Sig_ECU_DTCM2();
            DTC_Amnt_Number = Get_CAN_CH0_ID_402_Sig_ECU_DTCAmnt();

            if (((DTCH1 & 0xF0) >> 4) >= 0xA)
            {
                DTC1 |= ((DTCH1 & 0xF0) >> 4) + 3;
            }
            else
            {
                DTC1 |= (DTCH1 & 0xF0) >> 4 ;
            }
            DTC1 <<= 8;
            if ((DTCH1 & 0xF) >= 0xA)
            {
                DTC1 |= (DTCH1 & 0xF) + 3;
            }
            else
            {
                DTC1 |= DTCH1 & 0xF ;
            }
            DTC1 <<= 8;
            
            if (((DTCM1 & 0xF0) >> 4) >= 0xA)
            {
                DTC1 |= ((DTCM1 & 0xF0) >> 4) + 3;
            }
            else
            {
                DTC1 |= (DTCM1 & 0xF0) >> 4 ;
            }
            DTC1 <<= 8;
            if ((DTCM1 & 0xF) >= 0xA)
            {
                DTC1 |= (DTCM1 & 0xF) + 3;
            }
            else
            {
                DTC1 |= DTCM1 & 0xF ;
            }

            if (((DTCH2 & 0xF0) >> 4) >= 0xA)
            {
                DTC2 |= ((DTCH2 & 0xF0) >> 4) + 3;
            }
            else
            {
                DTC2 |= (DTCH2 & 0xF0) >> 4 ;
            }
            DTC2 <<= 8;
            if ((DTCH2 & 0xF) >= 0xA)
            {
                DTC2 |= (DTCH2 & 0xF) + 3;
            }
            else
            {
                DTC2 |= DTCH2 & 0xF ;
            }
            DTC2 <<= 8;
            
            if (((DTCM2 & 0xF0) >> 4) >= 0xA)
            {
                DTC2 |= ((DTCM2 & 0xF0) >> 4) + 3;
            }
            else
            {
                DTC2 |= (DTCM2 & 0xF0) >> 4 ;
            }
            DTC2 <<= 8;
            if ((DTCM2 & 0xF) >= 0xA)
            {
                DTC2 |= (DTCM2 & 0xF) + 3;
            }
            else
            {
                DTC2 |= DTCM2 & 0xF ;
            }

            
            if (DTC_Amnt_Number == 0)
            {
                for (i = 0; i < FualtCodeMax; i++)
                {
                    FaultCode_Data[i] = 0;
                    DTC_Data_Count[i] = 0;
                    DTC_Data[i] = 0;
                }
                DTC_Amnt_Number_Count = 0;
            }
            if(DTC_Amnt_Number_Count < DTC_Amnt_Number)
            {
                if ((DTC1 != 0) && (FaultCode_Compare(DTC1, &DTC_Data_Count[0], DTC_Amnt_Number_Count) == 0))
                {
                    DTC_Data_Count[DTC_Amnt_Number_Count] = DTC1;
                    DTC_Amnt_Number_Count ++;
                    Fault_Code_App_SortNByte(DTC_Data_Count, DTC_Amnt_Number_Count);
                }
            }
            if(DTC_Amnt_Number_Count < DTC_Amnt_Number)
            {
                if ((DTC2 != 0) && (FaultCode_Compare(DTC2, &DTC_Data_Count[0], DTC_Amnt_Number_Count) == 0))
                {
                    DTC_Data_Count[DTC_Amnt_Number_Count] = DTC2;
                    DTC_Amnt_Number_Count ++;
                    Fault_Code_App_SortNByte(DTC_Data_Count, DTC_Amnt_Number_Count);
                }
            }
            if(DTC_Amnt_Number_Count > DTC_Amnt_Number)
            {
                for (i = 0; i < FualtCodeMax; i++)
                {
                    //FaultCode_Data[i] = 0;
                    DTC_Data_Count[i] = 0;
                    DTC_Data[i] = 0;
                }
                DTC_Amnt_Number_Count = 0;
            }
            if (DTC_Amnt_Number_Count == DTC_Amnt_Number)
            {
                for(i = 0; i < DTC_Amnt_Number_Count; i++)
                {
                    DTC_Data[i] = DTC_Data_Count[i];
                    DTC_Data_Count[i] = 0;
                    Fault_Code_App_SortNByte(DTC_Data, FaultCode_Number);
                }
                FaultCode_Number = DTC_Amnt_Number;
                DTC_Amnt_Number_Count = 0;

                for(i = 0; i < FaultCode_Number; i++)
                {
                    if(FaultCode_Data[i] != DTC_Data[i])
                    {
                        FaultCode_Data[i] = DTC_Data[i];
                        Fault_Code_App_SortNByte(FaultCode_Data, FaultCode_Number);
                    }
                }
            }

        }
    }
    else
    {
        memset (FaultCode_Data, 0, FaultCode_Number);
        FaultCode_Number = 0;
    }
}
