#include "Maintenance.h"


/*** 保养里程 ***/
uint32_t DataServiceInterval = 0xFFFFu;
uint32_t NVM_User_Settings_Service; /***********临时接口*********/
/******************************************************************************
Data_Maintenance_Interval_Set
功  能: 写入保养
参  数: 无
返回值：无
******************************************************************************/
void Data_Maintenance_Interval_Set(uint32_t u32Data)
{
    uint32_t u32Data1[1u] = {0};
    u32Data1[0u] = u32Data;
    Data_User_EEPROM_Write(EM_Maintenance_BLOCK, u32Data1, 1u);
}

/******************************************************************************
Data_Maintenance_Interval_Set_Flag
功  能: 写入保养标志
参  数: 无
返回值：无
******************************************************************************/
void Data_Maintenance_Interval_Set_Flag(uint32_t u32Data)
{
    uint32_t u32Data1[1u] = {0};
    u32Data1[0u] = u32Data;
    Data_User_EEPROM_Write(EM_Maintenance_Firstflg, u32Data1, 1u);
}
/******************************************************************************
函数名：Data_Service_Interval_Processing
功  能: 剩余保养里程处理
参  数: 无
返回值：无
******************************************************************************/
uint32_t Get_Data_Maintenace_Interval_Processing(void)
{
    uint32_t MileageDev = 0;
    uint32_t Servicekm = 0;
    uint32_t ODO_Data = 0;
    
    ODO_Data = Data_ODO_Read() / 10;
    
    if (ODO_Data >= NVM_User_Settings_Service)
    {
        Servicekm = 0u;
    }
    else
    {
        MileageDev = NVM_User_Settings_Service - ODO_Data;
        Servicekm  = MileageDev;
    }

    if (Servicekm >= 2000u)
    {
        Servicekm = 2000u;
    }      
    
    DataServiceInterval = Servicekm;

    return DataServiceInterval;
}
/******************************************************************************
函数名：Data_Service_Interval_Reset
功  能: 重置保养里程
参  数: 无
返回值：无
******************************************************************************/
void Data_Maintenance_Interval_Reset(void)
{
    uint32_t ODO_Data = 0;
    uint32_t u32Data[1u] = {0};
    uint32_t Maintenance_Firstflg[1u] = {0};
    
    ODO_Data = Data_ODO_Read() / 10u;
    Data_User_EEPROM_Read(EM_Maintenance_Firstflg, Maintenance_Firstflg, 1u);
    if (Maintenance_Firstflg[0u] == 0xFFFFFFFF)
    {
        NVM_User_Settings_Service = ODO_Data + 1000;
        u32Data[0u] = NVM_User_Settings_Service;
        Data_User_EEPROM_Write(EM_Maintenance_BLOCK, u32Data, 1u);  

        Maintenance_Firstflg[0u] = 1;
        Data_User_EEPROM_Write(EM_Maintenance_Firstflg, Maintenance_Firstflg, 1u);
    }
    else if (Maintenance_Firstflg[0u] == 1)
    {
        NVM_User_Settings_Service = ODO_Data + 2000;
        u32Data[0u] = NVM_User_Settings_Service;
        Data_User_EEPROM_Write(EM_Maintenance_BLOCK, u32Data, 1u);  
    }
}





