#ifndef _COMMON_INTERFACE_H_
#define _COMMON_INTERFACE_H_
#include "Components.h"

#define TY200_080000b     0
#define TY200_080000b_ty  1

#define IC_Current        TY200_080000b //选择当前程序为哪个零件号的仪表

/*COMMON INTERFACE*/
typedef enum
{
    CAN_SIG_NORMAL = 0u,
    CAN_SIG_LOST = 0x55U,
} CAN_MSG_Status_t;

typedef enum
{
    EX_OK = 0u,
    EX_ERR,
} _Fun_Res;

typedef enum
{
    COMMON_POWER_OFF = 0x00u,
    COMMON_POWER_ON = 0x01u,
    COMMON_POWER_UNKNOW = 0xFFu,
} COMMON_PowerStatus_t;

typedef enum
{
    COMMON_InValid = 0X00U,
    COMMON_Valid = 0X01U,
    COMMON_Valid_UNKNOW = 0XFFU,
} DataValid_t;

typedef enum
{
    CAN_MSG_TX_CYCLE = 0u,
    CAN_MSG_TX_CYCKE_EVENT,
} CAN_TX_Type_t;

typedef enum
{
    MSG_STD = 0u,
    MSG_EXT,
} CAN_MSG_FORMAT_t;

/*COMMON INTERFACE END*/

typedef enum
{
    Bus_Sleep_Mode,
    Pre_Bus_Sleep_Mode,
    Network_Mode,
} NM_Mode_t;

extern void Common_DataInit(void);
extern void Common_Input_Para(void);
extern uint8_t Common_Get_IG_Sts(void);
extern DataValid_t Common_Get_IG_Sts_Valid(void);
extern void Common_Set_IG_Sts(COMMON_PowerStatus_t Val);
extern void Common_Set_IG_Sts_Valid(DataValid_t Val);
extern uint16_t Common_Get_Act_V_Speed(void);
extern uint16_t Common_Get_Act_V_Speed_ODO(void);
extern uint16_t Common_Get_Disp_V_Speed(void);
extern DataValid_t Common_Get_Act_V_Speed_Valid(void);
extern DataValid_t Common_Get_Disp_V_Speed_Valid(void);
extern void Common_Set_Act_V_Speed(uint16_t Val);
extern void Common_Set_Disp_V_Speed(uint16_t Val);
extern uint16_t Common_Get_TireSize(void);
extern void Common_Set_Act_V_Speed_Valid(DataValid_t Val);
extern void Common_Set_Disp_V_Speed_Valid(DataValid_t Val);
extern uint16_t Common_Get_DispSpeed(void);
extern uint32_t Common_GetIgnOnTime(void);  /*ms*/
extern uint32_t Common_GetIgnOffTime(void); /*ms*/


extern uint32_t Data_Km_To_Mile(uint32_t Km);
extern uint32_t Data_Mile_To_Km(uint32_t Mile);


#endif
