#include "Application.h"
#include "Data_TPMS\Data_TPMS.h"

_TPMS_Display TPMS;

void Data_TPMS_KL30_Init ( void )
{
    uint32_t TPMS_L[2] = {0,0};
    Data_User_EEPROM_Read(EM_MenuData_TPMS_LEARN, TPMS_L, 2u);
    MenuData.TPMS_Front_Learn = TPMS_L[0];
    MenuData.TPMS_Rear_Learn  = TPMS_L[1];
    TPMS.Front_Press_Value = 0;
    TPMS.Rear_Press_Value  = 0;
    TPMS.Front_TPMS_Valid  = 0;
    TPMS.Rear_TPMS_Valid   = 0;
    TPMS.TPMS_Warning      = 0;
    TPMS.TPMS_Unit         = Get_Dis_Tpms_Unit();
    TPMS.TPMS_Front_Learn  = MenuData.TPMS_Front_Learn;
    TPMS.TPMS_Rear_Learn   = MenuData.TPMS_Rear_Learn;
}
void Data_TPMS_KL15_WAKE_UP_Init ( void )
{
    uint32_t TPMS_L[2] = {0,0};
    Data_User_EEPROM_Read(EM_MenuData_TPMS_LEARN, TPMS_L, 2u);
    MenuData.TPMS_Front_Learn = TPMS_L[0];
    MenuData.TPMS_Rear_Learn  = TPMS_L[1];
    TPMS.TPMS_Front_Learn     = MenuData.TPMS_Front_Learn;
    TPMS.TPMS_Rear_Learn      = MenuData.TPMS_Rear_Learn;
}

void Data_TPMS_Processing_Service ( void )
{
    uint16_t Front_TPMS = 0;
    uint16_t Rear_TPMS  = 0;
    uint32_t TPMS_L[2] = {0,0};
    TPMS.TPMS_Front_Learn = Get_CAN_CH0_ID_341_Sig_Front_LearningStatus();
    TPMS.TPMS_Rear_Learn  = Get_CAN_CH0_ID_341_Sig_Rear_LearningStatus();
    if((TPMS.TPMS_Front_Learn != MenuData.TPMS_Front_Learn) || (TPMS.TPMS_Rear_Learn != MenuData.TPMS_Rear_Learn))
    {
        TPMS_L[0] = TPMS.TPMS_Front_Learn;
        TPMS_L[1] = TPMS.TPMS_Rear_Learn;
        Data_User_EEPROM_Write(EM_MenuData_TPMS_LEARN, TPMS_L, 2u);  
        MenuData.TPMS_Front_Learn = TPMS.TPMS_Front_Learn;
        MenuData.TPMS_Rear_Learn  = TPMS.TPMS_Rear_Learn;
    }
    TPMS.TPMS_Unit      = Get_Dis_Tpms_Unit();
    Front_TPMS          = Get_CAN_CH0_ID_341_Sig_Front_Pressure();
    Rear_TPMS           = Get_CAN_CH0_ID_341_Sig_Rear_Pressure();

    if ( Common_Get_IG_Sts() == COMMON_POWER_ON )
    {
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CAN_0x341_Msg_Count) == CAN_SIG_LOST)
        {
            TPMS.Front_TPMS_Valid  = 0;  //信号掉线，显示--
            TPMS.Rear_TPMS_Valid   = 0;  //信号掉线，显示--
            TPMS.Front_Press_Value = 0;
            TPMS.Rear_Press_Value  = 0;
            TPMS.TPMS_Warning      = 0;  //白灯
        }
        else
        {            
            if((Front_TPMS == 0xFF) || (Rear_TPMS == 0xFF))
            {
                if((Front_TPMS == 0xFF) && (Rear_TPMS != 0xFF))
                {
                    TPMS.Front_TPMS_Valid  = 0;
                    TPMS.Rear_TPMS_Valid   = 2;
                    TPMS.Front_Press_Value = 990;
                    TPMS.Rear_Press_Value  = Rear_TPMS * 275;
                    TPMS.Rear_Press_Value  /= 102 ;
                    if(TPMS.Rear_Press_Value > 990)
                    {
                        TPMS.Rear_Press_Value = 990;
                    }
                    if((TPMS.Rear_Press_Value < 170) || (TPMS.Rear_Press_Value > 250))
                    {
                        TPMS.TPMS_Warning = 1;
                    }
                    else
                    {
                        TPMS.TPMS_Warning = 0;
                    }
                }
                else if ((Front_TPMS != 0xFF) && (Rear_TPMS == 0xFF))
                {
                    TPMS.Front_TPMS_Valid  = 2;
                    TPMS.Rear_TPMS_Valid   = 0;
                    TPMS.Rear_Press_Value  = 990;
                    TPMS.Front_Press_Value = Front_TPMS *275 ;
                    TPMS.Front_Press_Value  /= 102 ;
                    if(TPMS.Front_Press_Value > 990)
                    {
                        TPMS.Front_Press_Value = 990;
                    }
                    if((TPMS.Front_Press_Value < 170) || (TPMS.Front_Press_Value > 230))
                    {
                        TPMS.TPMS_Warning = 1;
                    }
                    else
                    {
                        TPMS.TPMS_Warning = 0;
                    }
                }
                else
                {
                    TPMS.Front_Press_Value = 990;
                    TPMS.Rear_Press_Value = 990;
                    TPMS.TPMS_Warning = 0;
                    TPMS.Front_TPMS_Valid  = 0;
                    TPMS.Rear_TPMS_Valid   = 0;
                }
            }
            else
            {
                TPMS.Front_TPMS_Valid  = 2;
                TPMS.Rear_TPMS_Valid   = 2;
                TPMS.Front_Press_Value = Front_TPMS * 275 ;                
                TPMS.Front_Press_Value  /= 102 ;
                if(TPMS.Front_Press_Value > 990)
                {
                    TPMS.Front_Press_Value = 990;
                }

                TPMS.Rear_Press_Value  = Rear_TPMS * 275;                
                TPMS.Rear_Press_Value  /= 102 ;
                if(TPMS.Rear_Press_Value > 990)
                {
                    TPMS.Rear_Press_Value = 990;
                }
                if ((TPMS.Front_Press_Value < 170) || (TPMS.Front_Press_Value > 230) || (TPMS.Rear_Press_Value < 170) || (TPMS.Rear_Press_Value > 250))
                {
                    TPMS.TPMS_Warning = 1;
                }
                else
                {
                    TPMS.TPMS_Warning = 0;
                }
            }
            
        }
        if(MenuData.TPMS_Front_Learn == Unstudied)
        {
            TPMS.Front_TPMS_Valid = Unstudied;            
        }
        else if(MenuData.TPMS_Front_Learn == Learning)
        {
            TPMS.Front_TPMS_Valid = Learning;            
        }
        else if(MenuData.TPMS_Front_Learn == LearningCompletion)
        {
            TPMS.Front_TPMS_Valid = LearningCompletion;
            TPMS.Rear_Press_Value = 990;
        }
        else if(MenuData.TPMS_Front_Learn == LearningFailure)
        {
            TPMS.Front_TPMS_Valid = LearningFailure;
        }
        else
        {
            ;
        }

        if(MenuData.TPMS_Rear_Learn == Unstudied)
        {
            TPMS.Rear_TPMS_Valid = Unstudied;
        }
        else if(MenuData.TPMS_Rear_Learn == Learning)
        {
            TPMS.Rear_TPMS_Valid = Learning;
        }
        else if(MenuData.TPMS_Rear_Learn == LearningCompletion)
        {
            TPMS.Rear_TPMS_Valid = LearningCompletion;
            TPMS.Front_Press_Value = 990;
        }
        else if(MenuData.TPMS_Rear_Learn == LearningFailure)
        {
            TPMS.Rear_TPMS_Valid = LearningFailure;
        }
        else
        {
            ;
        }

        if ((MenuData.TPMS_Rear_Learn != LearningCompletion) && (MenuData.TPMS_Front_Learn != LearningCompletion))
        {
            TPMS.TPMS_Warning = 0;
        }

    }
    else
    {
        TPMS.Front_TPMS_Valid  = 0;
        TPMS.Rear_TPMS_Valid   = 0; 
        TPMS.Front_Press_Value = 0;
        TPMS.Rear_Press_Value  = 0;
        TPMS.TPMS_Warning      = 0; 
    }
}
uint32_t Data_Bar_To_Psi (uint32_t bar)
{
    uint32_t Bar = 0;
    Bar = bar * 145;
    Bar /= 10;
    Bar += 5;
    // bar *= 145;
    // bar /= 10;
    // bar += 5;    
    return Bar;
}

/*指示灯报警信号  0：白色常亮   1：黄色常亮*/
uint8_t Get_Led_TPMS_Waring (void)
{
    return TPMS.TPMS_Warning;
}

/*0：未学习，无效，常显--  1：学习中，无效，闪烁--   2：学习完成，有效，按实际胎压数值显示  3：学习失败，无效，最大值闪烁显示*/
uint8_t Get_Front_TPMS_Sig_Vaild (void)
{
    return TPMS.Front_TPMS_Valid;
}
uint8_t Get_Rear_TPMS_Sig_Vaild (void)
{
    return TPMS.Rear_TPMS_Valid;
}
//10倍
uint16_t Get_Front_TPMS_Sig_Value (void)
{
    uint16_t value = 0;
    if (TPMS.TPMS_Unit == 1)
    {
        value = (Data_Bar_To_Psi(TPMS.Front_Press_Value) + 50) / 100;
        if(value > 99)
        {
            value = 99;
        }
    }
    else
    {        
        value = TPMS.Front_Press_Value + 5;        
        value = value / 10;
    }
    return value;
}
uint16_t Get_Rear_TPMS_Sig_Value (void)
{
    uint16_t value = 0;
    if (TPMS.TPMS_Unit == 1)
    {
        value = (Data_Bar_To_Psi(TPMS.Rear_Press_Value) + 50) / 100;
        if(value > 99)
        {
            value = 99;
        }
        
    }
    else
    {        
        value = TPMS.Rear_Press_Value + 5;        
        value = value / 10;        
    }
    return value;    
}
uint16_t Get_Rear_TPMS_TX (void)
{
    uint16_t value = 0;
    value = Data_Bar_To_Psi(TPMS.Rear_Press_Value) / 10;
    if(value > 990)
    {
        value = 990;
    }
    return value;
}
uint16_t Get_Front_TPMS_TX (void)
{
    uint16_t value = 0;
    value = Data_Bar_To_Psi(TPMS.Front_Press_Value) / 10;
    if(value > 990)
    {
        value = 990;
    }
    return value;
}
