#include "Application.h"
#include "Data_TPMS\Data_TPMS.h"

_TPMS_Display TPMS;

void Data_TPMS_KL30_Init ( void )
{
    TPMS.Front_Press_Value = 0;
    TPMS.Rear_Press_Value  = 0;
    TPMS.Front_TPMS_Valid  = 0;
    TPMS.Rear_TPMS_Valid   = 0;
    TPMS.TPMS_Warning      = 0;
    TPMS.TPMS_Unit         = Get_Dis_Tpms_Unit();
}

void Data_TPMS_Processing_Service ( void )
{
    uint16_t Front_TPMS = 0;
    uint16_t Rear_TPMS  = 0;
    TPMS.TPMS_Unit      = Get_Dis_Tpms_Unit();
    Front_TPMS          = Get_CAN_CH0_ID_341_Sig_Front_Pressure();
    Rear_TPMS           = Get_CAN_CH0_ID_341_Sig_Rear_Pressure();
    if ( Common_Get_IG_Sts() == COMMON_POWER_ON )
    {
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CAN_0x341_Msg_Count) == CAN_SIG_LOST)
        {
            TPMS.Front_TPMS_Valid  = 0;  //信号掉线，显示--
            TPMS.Rear_TPMS_Valid   = 0;  //信号掉线，显示--
            TPMS.Front_Press_Value = 0;
            TPMS.Rear_Press_Value  = 0;
            TPMS.TPMS_Warning      = 0;  //白灯
        }
        else
        {            
            if((Front_TPMS == 0xFF) || (Rear_TPMS == 0xFF))
            {
                if((Front_TPMS == 0xFF) && (Rear_TPMS != 0xFF))
                {
                    TPMS.Front_TPMS_Valid  = 0;
                    TPMS.Rear_TPMS_Valid   = 1;
                    TPMS.Front_Press_Value = 99;
                    TPMS.Rear_Press_Value  = Rear_TPMS * 275;
                    TPMS.Rear_Press_Value  /= 10 ;
                    if(TPMS.Rear_Press_Value > 99)
                    {
                        TPMS.Rear_Press_Value = 99;
                    }
                    if((TPMS.Rear_Press_Value < 17) || (TPMS.Rear_Press_Value > 25))
                    {
                        TPMS.TPMS_Warning = 1;
                    }
                    else
                    {
                        TPMS.TPMS_Warning = 0;
                    }
                }
                else if ((Front_TPMS != 0xFF) || (Rear_TPMS == 0xFF))
                {
                    TPMS.Front_TPMS_Valid  = 1;
                    TPMS.Rear_TPMS_Valid   = 0;
                    TPMS.Rear_Press_Value  = 99;
                    TPMS.Front_Press_Value = Front_TPMS *275 ;
                    TPMS.Front_Press_Value  /= 10 ;
                    if(TPMS.Front_Press_Value > 99)
                    {
                        TPMS.Front_Press_Value = 99;
                    }
                    if((TPMS.Front_Press_Value < 17) || (TPMS.Front_Press_Value > 23))
                    {
                        TPMS.TPMS_Warning = 1;
                    }
                    else
                    {
                        TPMS.TPMS_Warning = 0;
                    }
                }
                else
                {
                    TPMS.Front_Press_Value = 99;
                    TPMS.Rear_Press_Value = 99;
                    TPMS.TPMS_Warning = 0;
                    TPMS.Front_TPMS_Valid  = 0;
                    TPMS.Rear_TPMS_Valid   = 0;
                }
            }
            else
            {
                TPMS.Front_TPMS_Valid  = 1;
                TPMS.Rear_TPMS_Valid   = 1;
                TPMS.Front_Press_Value = Front_TPMS * 275 ;
                TPMS.Front_Press_Value  /= 10 ;
                if(TPMS.Front_Press_Value > 99)
                {
                    TPMS.Front_Press_Value = 99;
                }

                TPMS.Rear_Press_Value  = Rear_TPMS * 275;
                TPMS.Rear_Press_Value  /= 10 ;
                if(TPMS.Rear_Press_Value > 99)
                {
                    TPMS.Rear_Press_Value = 99;
                }
                if ((TPMS.Front_Press_Value < 17) || (TPMS.Front_Press_Value > 23) || (TPMS.Rear_Press_Value < 17) || (TPMS.Rear_Press_Value > 25))
                {
                    TPMS.TPMS_Warning = 1;
                }
                else
                {
                    TPMS.TPMS_Warning = 0;
                }
            }
            
        }
    }
    else
    {
        TPMS.Front_TPMS_Valid  = 0;
        TPMS.Rear_TPMS_Valid   = 0; 
        TPMS.Front_Press_Value = 0;
        TPMS.Rear_Press_Value  = 0;
        TPMS.TPMS_Warning      = 0; 
    }
}
uint16_t Data_Bar_To_Psi (uint16_t bar)
{
    bar *= 145;
    bar /= 10;
    if((bar % 5) >= 5)
    {
        bar += 5;
    }
    return bar;
}
uint8_t Get_Led_TPMS_Waring (void)
{
    return TPMS.TPMS_Warning;
}
uint8_t Get_Front_TPMS_Sig_Vaild (void)
{
    return TPMS.Front_TPMS_Valid;
}
uint8_t Get_Rear_TPMS_Sig_Vaild (void)
{
    return TPMS.Rear_TPMS_Valid;
}
//10倍
uint16_t Get_Front_TPMS_Sig_Value (void)
{
    uint16_t value = 0;
    if (TPMS.TPMS_Unit == 1)
    {
        value = Data_Bar_To_Psi(TPMS.Front_Press_Value) / 10;
        if(value > 99)
        {
            value = 99;
        }
    }
    else
    {
        value = TPMS.Front_Press_Value;
    }
    return value;
}
uint16_t Get_Rear_TPMS_Sig_Value (void)
{
    uint16_t value = 0;
    if (TPMS.TPMS_Unit == 1)
    {
        value = Data_Bar_To_Psi(TPMS.Rear_Press_Value) / 10;
        if(value > 99)
        {
            value = 99;
        }
        
    }
    else
    {
        value = TPMS.Rear_Press_Value;
    }
    return value;    
}
uint16_t Get_Rear_TPMS_TX (void)
{
    return TPMS.Rear_Press_Value;
}
uint16_t Get_Front_TPMS_TX (void)
{
    return TPMS.Front_Press_Value;
}