#include "stddef.h"
#include "BAT32A239.h"
#include "core_cm0plus.h"
#include "RTE_CLOCK_Select.h"
#include "cgc.h"

#define USED_FX_FCLK
//#define USED_FHOCO_FCLK

void RTE_CLOCK_Select_Start(void)
{
	// uint32_t msCnt; 

#ifdef USED_FX_FCLK
	CGC_Osc_Setting(OSC_OSCILLATOR,OSC_UNDER_10M,OSC_OSCILLATOR,OSC_NORMAL_POWER);
	CGC_PLL_Setting(PLL_SR_fMX,PLL_DIV_2,PLL_MUL_16);
	CGC_PLL_CFG_AS_FCLK(); 
	delay_init(64000000);
	SystemCoreClock = 64000000UL;
#endif

#ifdef USED_FHOCO_FCLK	
	SystemCoreClockUpdate();
  msCnt = SystemCoreClock / 1000;
  SysTick_Config(msCnt);
  delay_init(SystemCoreClock);
#endif
}

void RTE_CLOCK_Select_Stop(void)
{

}


