
#ifndef _BU98R10_H_
#define _BU98R10_H_

#include "RTE.h"
#define   USE_BU98R10_CHIP_0                1

/* #ifndef   BU98R10_0_SD
#define   BU98R10_0_SD                      //PIN_9_P
#define   SEG_LCD_SD_Dir0                   //PIN_9_D

#endif


#ifndef   BU98R10_0_SCL
#define   BU98R10_0_SCL                   // PIN_10_P
#endif


#ifndef   BU98R10_0_CSB
#define   BU98R10_0_CSB                    // PIN_11_P
#endif
 */


#define   USE_BU98R10_CHIP_1                1


/* #ifndef   BU98R10_1_SD
#define   BU98R10_1_SD                    //PIN_16_P
#define   SEG_LCD_SD_Dir1                 // PIN_16_D
#endif


#ifndef   BU98R10_1_SCL
#define   BU98R10_1_SCL                  //PIN_17_P
#endif


#ifndef   BU98R10_1_CSB
#define   BU98R10_1_CSB                 //PIN_18_P
#endif */


#define   BU98R10_SD_SCL_MULTIPLEX          0     //0 - ?????? 1 - ????



#define   BU98R10_COLORFUL_LCD_MODE         1     //0 - ????? 1 - ?????
#define   BU98R10_FRAME_FREQ                BU98R10_FRAME_FREQ_120_0_Hz //BU98R10_FRAME_FREQ_180_0_Hz
#define   BU98R10_DEFAULT_SEG               0     //???????????????????


#define   BU98R10_SRR                       7
#define   BU98R10_SRF                       0
#define   BU98R10_SGR                       7
#define   BU98R10_SGF                       0
#define   BU98R10_SBR                       7
#define   BU98R10_SBF                       0

#define   BU98R10_LRS                       0
#define   BU98R10_LRW                       47   //63
#define   BU98R10_LGS                       0    //57
#define   BU98R10_LGW                       47   //6
#define   BU98R10_LBS                       0    //23
#define   BU98R10_LBW                       47   //40


#define   BU98R10_FRAME_FREQ_50_0_Hz        0x00
#define   BU98R10_FRAME_FREQ_60_0_Hz        0x01
#define   BU98R10_FRAME_FREQ_69_3_Hz        0x02
#define   BU98R10_FRAME_FREQ_75_0_Hz        0x03
#define   BU98R10_FRAME_FREQ_81_8_Hz        0x04
#define   BU98R10_FRAME_FREQ_90_0_Hz        0x05
#define   BU98R10_FRAME_FREQ_100_0_Hz       0x06
#define   BU98R10_FRAME_FREQ_112_5_Hz       0x07
#define   BU98R10_FRAME_FREQ_120_0_Hz       0x08
#define   BU98R10_FRAME_FREQ_128_6_Hz       0x09
#define   BU98R10_FRAME_FREQ_138_5_Hz       0x0A
#define   BU98R10_FRAME_FREQ_150_0_Hz       0x0B
#define   BU98R10_FRAME_FREQ_163_6_Hz       0x0C
#define   BU98R10_FRAME_FREQ_180_0_Hz       0x0E
#define   BU98R10_FRAME_FREQ_200_0_Hz       0x0F


#if   ((USE_BU98R10_CHIP_0) && (USE_BU98R10_CHIP_1) && (BU98R10_SD_SCL_MULTIPLEX == 0))
  #define BU98R10_WRITE_AT_SAME_TIME        1
#else
  #define BU98R10_WRITE_AT_SAME_TIME        0
#endif


#define   BU98R10_REG_SEG_R                 ((uint8_t)BU98R10_SRR << 4 | (uint8_t)BU98R10_SRF)        // 0
#define   BU98R10_REG_SEG_G                 ((uint8_t)BU98R10_SGR << 4 | (uint8_t)BU98R10_SGF)       // 0XEE
#define   BU98R10_REG_SEG_B                 ((uint8_t)BU98R10_SBR << 4 | (uint8_t)BU98R10_SBF)       // 0X55

#if   BU98R10_COLORFUL_LCD_MODE
  #define   BU98R10_DEFAULT_BYTE            ((uint8_t)BU98R10_DEFAULT_SEG << 4 | (uint8_t)BU98R10_DEFAULT_SEG)
#else
  #if BU98R10_DEFAULT_SEG
    #define BU98R10_DEFAULT_BYTE            ((uint8_t)0xFF)
  #else
    #define BU98R10_DEFAULT_BYTE            ((uint8_t)0x00)
  #endif
#endif


#define   BU98R10_CMD_DATRD                 ((uint8_t)0x09)
#define   BU98R10_CMD_DATWR                 ((uint8_t)0x0A)
#define   BU98R10_CMD_ADSET                 ((uint8_t)0x40)

#define   BU98R10_CMD_DISPOFF               ((uint8_t)0x80)
#define   BU98R10_CMD_DISPON                ((uint8_t)0x81)
#define   BU98R10_CMD_ICSET                 ((uint8_t)0x88)
#define   BU98R10_CMD_DRVCTRL               ((uint8_t)0x90)
#define   BU98R10_CMD_FREQ                  ((uint8_t)0x98)
#define   BU98R10_CMD_SEG_R                 ((uint8_t)0xA0)
#define   BU98R10_CMD_SEG_G                 ((uint8_t)0xA8)
#define   BU98R10_CMD_SEG_B                 ((uint8_t)0xB0)
#define   BU98R10_CMD_LED_STARTR            ((uint8_t)0xB8)
#define   BU98R10_CMD_LED_STARTG            ((uint8_t)0xC0)
#define   BU98R10_CMD_LED_STARTB            ((uint8_t)0xC8)
#define   BU98R10_CMD_LED_WIDTHR            ((uint8_t)0xD0)
#define   BU98R10_CMD_LED_WIDTHG            ((uint8_t)0xD8)
#define   BU98R10_CMD_LED_WIDTHB            ((uint8_t)0xE0)
#define   BU98R10_CMD_LED_CTRL              ((uint8_t)0xE8)
#define   BU98R10_CMD_TEST                  ((uint8_t)0xF0)
#define   BU98R10_CMD_SWRST                 ((uint8_t)0xF9)


#define   BU98R10_PAR_ICSET_RGB             ((uint8_t)0x00) 
#define   BU98R10_PAR_ICSET_MONO            ((uint8_t)0x01)
#define   BU98R10_PAR_ICSET_INTOSC          ((uint8_t)0x00)
#define   BU98R10_PAR_ICSET_EXTCLK          ((uint8_t)0x02)

#define   BU98R10_PAR_DRVCTRL_NORMAL        ((uint8_t)0x00)
#define   BU98R10_PAR_DRVCTRL_AP_OFF        ((uint8_t)0x01)
#define   BU98R10_PAR_DRVCTRL_AP_ON         ((uint8_t)0x02)
#define   BU98R10_PAR_DRVCTRL_INVERSE       ((uint8_t)0x03)


typedef struct
{
  uint8_t En;
  uint8_t Chip;
  uint8_t Step;
  uint8_t Cont;
  uint8_t Addr;
}BU98R10UpdateCtrlStruct;


#if BU98R10_COLORFUL_LCD_MODE

#define   BU98R10_DDRAM_SIZE                90 

typedef union
{
  uint8_t    Byte[BU98R10_DDRAM_SIZE];
  
  struct
  {
    uint8_t  Seg1   : 4;
    uint8_t  Seg2   : 4;
    uint8_t  Seg3   : 4;
    uint8_t  Seg4   : 4;
    uint8_t  Seg5   : 4;
    uint8_t  Seg6   : 4;
    uint8_t  Seg7   : 4;
    uint8_t  Seg8   : 4;
    uint8_t  Seg9   : 4;
    uint8_t  Seg10  : 4;
    uint8_t  Seg11  : 4;
    uint8_t  Seg12  : 4;
    uint8_t  Seg13  : 4;
    uint8_t  Seg14  : 4;
    uint8_t  Seg15  : 4;
    uint8_t  Seg16  : 4;
    uint8_t  Seg17  : 4;
    uint8_t  Seg18  : 4;
    uint8_t  Seg19  : 4;
    uint8_t  Seg20  : 4;
    uint8_t  Seg21  : 4;
    uint8_t  Seg22  : 4;
    uint8_t  Seg23  : 4;
    uint8_t  Seg24  : 4;
    uint8_t  Seg25  : 4;
    uint8_t  Seg26  : 4;
    uint8_t  Seg27  : 4;
    uint8_t  Seg28  : 4;
    uint8_t  Seg29  : 4;
    uint8_t  Seg30  : 4;
    uint8_t  Seg31  : 4;
    uint8_t  Seg32  : 4;
    uint8_t  Seg33  : 4;
    uint8_t  Seg34  : 4;
    uint8_t  Seg35  : 4;
    uint8_t  Seg36  : 4;
    uint8_t  Seg37  : 4;
    uint8_t  Seg38  : 4;
    uint8_t  Seg39  : 4;
    uint8_t  Seg40  : 4;
    uint8_t  Seg41  : 4;
    uint8_t  Seg42  : 4;
    uint8_t  Seg43  : 4;
    uint8_t  Seg44  : 4;
    uint8_t  Seg45  : 4;
    uint8_t  Seg46  : 4;
    uint8_t  Seg47  : 4;
    uint8_t  Seg48  : 4;
    uint8_t  Seg49  : 4;
    uint8_t  Seg50  : 4;
    uint8_t  Seg51  : 4;
    uint8_t  Seg52  : 4;
    uint8_t  Seg53  : 4;
    uint8_t  Seg54  : 4;
    uint8_t  Seg55  : 4;
    uint8_t  Seg56  : 4;
    uint8_t  Seg57  : 4;
    uint8_t  Seg58  : 4;
    uint8_t  Seg59  : 4;
    uint8_t  Seg60  : 4;
    uint8_t  Seg61  : 4;
    uint8_t  Seg62  : 4;
    uint8_t  Seg63  : 4;
    uint8_t  Seg64  : 4;
    uint8_t  Seg65  : 4;
    uint8_t  Seg66  : 4;
    uint8_t  Seg67  : 4;
    uint8_t  Seg68  : 4;
    uint8_t  Seg69  : 4;
    uint8_t  Seg70  : 4;
    uint8_t  Seg71  : 4;
    uint8_t  Seg72  : 4;
    uint8_t  Seg73  : 4;
    uint8_t  Seg74  : 4;
    uint8_t  Seg75  : 4;
    uint8_t  Seg76  : 4;
    uint8_t  Seg77  : 4;
    uint8_t  Seg78  : 4;
    uint8_t  Seg79  : 4;
    uint8_t  Seg80  : 4;
    uint8_t  Seg81  : 4;
    uint8_t  Seg82  : 4;
    uint8_t  Seg83  : 4;
    uint8_t  Seg84  : 4;
    uint8_t  Seg85  : 4;
    uint8_t  Seg86  : 4;
    uint8_t  Seg87  : 4;
    uint8_t  Seg88  : 4;
    uint8_t  Seg89  : 4;
    uint8_t  Seg90  : 4;
    uint8_t  Seg91  : 4;
    uint8_t  Seg92  : 4;
    uint8_t  Seg93  : 4;
    uint8_t  Seg94  : 4;
    uint8_t  Seg95  : 4;
    uint8_t  Seg96  : 4;
    uint8_t  Seg97  : 4;
    uint8_t  Seg98  : 4;
    uint8_t  Seg99  : 4;
    uint8_t  Seg100 : 4;
    uint8_t  Seg101 : 4;
    uint8_t  Seg102 : 4;
    uint8_t  Seg103 : 4;
    uint8_t  Seg104 : 4;
    uint8_t  Seg105 : 4;
    uint8_t  Seg106 : 4;
    uint8_t  Seg107 : 4;
    uint8_t  Seg108 : 4;
    uint8_t  Seg109 : 4;
    uint8_t  Seg110 : 4;
    uint8_t  Seg111 : 4;
    uint8_t  Seg112 : 4;
    uint8_t  Seg113 : 4;
    uint8_t  Seg114 : 4;
    uint8_t  Seg115 : 4;
    uint8_t  Seg116 : 4;
    uint8_t  Seg117 : 4;
    uint8_t  Seg118 : 4;
    uint8_t  Seg119 : 4;
    uint8_t  Seg120 : 4;
    uint8_t  Seg121 : 4;
    uint8_t  Seg122 : 4;
    uint8_t  Seg123 : 4;
    uint8_t  Seg124 : 4;
    uint8_t  Seg125 : 4;
    uint8_t  Seg126 : 4;
    uint8_t  Seg127 : 4;
    uint8_t  Seg128 : 4;
    uint8_t  Seg129 : 4;
    uint8_t  Seg130 : 4;
    uint8_t  Seg131 : 4;
    uint8_t  Seg132 : 4;
    uint8_t  Seg133 : 4;
    uint8_t  Seg134 : 4;
    uint8_t  Seg135 : 4;
    uint8_t  Seg136 : 4;
    uint8_t  Seg137 : 4;
    uint8_t  Seg138 : 4;
    uint8_t  Seg139 : 4;
    uint8_t  Seg140 : 4;
    uint8_t  Seg141 : 4;
    uint8_t  Seg142 : 4;
    uint8_t  Seg143 : 4;
    uint8_t  Seg144 : 4;
    uint8_t  Seg145 : 4;
    uint8_t  Seg146 : 4;
    uint8_t  Seg147 : 4;
    uint8_t  Seg148 : 4;
    uint8_t  Seg149 : 4;
    uint8_t  Seg150 : 4;
    uint8_t  Seg151 : 4;
    uint8_t  Seg152 : 4;
    uint8_t  Seg153 : 4;
    uint8_t  Seg154 : 4;
    uint8_t  Seg155 : 4;
    uint8_t  Seg156 : 4;
    uint8_t  Seg157 : 4;
    uint8_t  Seg158 : 4;
    uint8_t  Seg159 : 4;
    uint8_t  Seg160 : 4;
    uint8_t  Seg161 : 4;
    uint8_t  Seg162 : 4;
    uint8_t  Seg163 : 4;
    uint8_t  Seg164 : 4;
    uint8_t  Seg165 : 4;
    uint8_t  Seg166 : 4;
    uint8_t  Seg167 : 4;
    uint8_t  Seg168 : 4;
    uint8_t  Seg169 : 4;
    uint8_t  Seg170 : 4;
    uint8_t  Seg171 : 4;
    uint8_t  Seg172 : 4;
    uint8_t  Seg173 : 4;
    uint8_t  Seg174 : 4;
    uint8_t  Seg175 : 4;
    uint8_t  Seg176 : 4;
    uint8_t  Seg177 : 4;
    uint8_t  Seg178 : 4;
    uint8_t  Seg179 : 4;
    uint8_t  Seg180 : 4;
  }Bit;
}BU98R10DDRAMUnion;

#else

#define   BU98R10_DDRAM_SIZE                23 

typedef union
{
  uint8_t    Byte[BU98R10_DDRAM_SIZE];
  
  struct
  {
    uint8_t  Seg1   : 1;
    uint8_t  Seg2   : 1;
    uint8_t  Seg3   : 1;
    uint8_t  Seg4   : 1;
    uint8_t  Seg5   : 1;
    uint8_t  Seg6   : 1;
    uint8_t  Seg7   : 1;
    uint8_t  Seg8   : 1;
    uint8_t  Seg9   : 1;
    uint8_t  Seg10  : 1;
    uint8_t  Seg11  : 1;
    uint8_t  Seg12  : 1;
    uint8_t  Seg13  : 1;
    uint8_t  Seg14  : 1;
    uint8_t  Seg15  : 1;
    uint8_t  Seg16  : 1;
    uint8_t  Seg17  : 1;
    uint8_t  Seg18  : 1;
    uint8_t  Seg19  : 1;
    uint8_t  Seg20  : 1;
    uint8_t  Seg21  : 1;
    uint8_t  Seg22  : 1;
    uint8_t  Seg23  : 1;
    uint8_t  Seg24  : 1;
    uint8_t  Seg25  : 1;
    uint8_t  Seg26  : 1;
    uint8_t  Seg27  : 1;
    uint8_t  Seg28  : 1;
    uint8_t  Seg29  : 1;
    uint8_t  Seg30  : 1;
    uint8_t  Seg31  : 1;
    uint8_t  Seg32  : 1;
    uint8_t  Seg33  : 1;
    uint8_t  Seg34  : 1;
    uint8_t  Seg35  : 1;
    uint8_t  Seg36  : 1;
    uint8_t  Seg37  : 1;
    uint8_t  Seg38  : 1;
    uint8_t  Seg39  : 1;
    uint8_t  Seg40  : 1;
    uint8_t  Seg41  : 1;
    uint8_t  Seg42  : 1;
    uint8_t  Seg43  : 1;
    uint8_t  Seg44  : 1;
    uint8_t  Seg45  : 1;
    uint8_t  Seg46  : 1;
    uint8_t  Seg47  : 1;
    uint8_t  Seg48  : 1;
    uint8_t  Seg49  : 1;
    uint8_t  Seg50  : 1;
    uint8_t  Seg51  : 1;
    uint8_t  Seg52  : 1;
    uint8_t  Seg53  : 1;
    uint8_t  Seg54  : 1;
    uint8_t  Seg55  : 1;
    uint8_t  Seg56  : 1;
    uint8_t  Seg57  : 1;
    uint8_t  Seg58  : 1;
    uint8_t  Seg59  : 1;
    uint8_t  Seg60  : 1;
    uint8_t  Seg61  : 1;
    uint8_t  Seg62  : 1;
    uint8_t  Seg63  : 1;
    uint8_t  Seg64  : 1;
    uint8_t  Seg65  : 1;
    uint8_t  Seg66  : 1;
    uint8_t  Seg67  : 1;
    uint8_t  Seg68  : 1;
    uint8_t  Seg69  : 1;
    uint8_t  Seg70  : 1;
    uint8_t  Seg71  : 1;
    uint8_t  Seg72  : 1;
    uint8_t  Seg73  : 1;
    uint8_t  Seg74  : 1;
    uint8_t  Seg75  : 1;
    uint8_t  Seg76  : 1;
    uint8_t  Seg77  : 1;
    uint8_t  Seg78  : 1;
    uint8_t  Seg79  : 1;
    uint8_t  Seg80  : 1;
    uint8_t  Seg81  : 1;
    uint8_t  Seg82  : 1;
    uint8_t  Seg83  : 1;
    uint8_t  Seg84  : 1;
    uint8_t  Seg85  : 1;
    uint8_t  Seg86  : 1;
    uint8_t  Seg87  : 1;
    uint8_t  Seg88  : 1;
    uint8_t  Seg89  : 1;
    uint8_t  Seg90  : 1;
    uint8_t  Seg91  : 1;
    uint8_t  Seg92  : 1;
    uint8_t  Seg93  : 1;
    uint8_t  Seg94  : 1;
    uint8_t  Seg95  : 1;
    uint8_t  Seg96  : 1;
    uint8_t  Seg97  : 1;
    uint8_t  Seg98  : 1;
    uint8_t  Seg99  : 1;
    uint8_t  Seg100 : 1;
    uint8_t  Seg101 : 1;
    uint8_t  Seg102 : 1;
    uint8_t  Seg103 : 1;
    uint8_t  Seg104 : 1;
    uint8_t  Seg105 : 1;
    uint8_t  Seg106 : 1;
    uint8_t  Seg107 : 1;
    uint8_t  Seg108 : 1;
    uint8_t  Seg109 : 1;
    uint8_t  Seg110 : 1;
    uint8_t  Seg111 : 1;
    uint8_t  Seg112 : 1;
    uint8_t  Seg113 : 1;
    uint8_t  Seg114 : 1;
    uint8_t  Seg115 : 1;
    uint8_t  Seg116 : 1;
    uint8_t  Seg117 : 1;
    uint8_t  Seg118 : 1;
    uint8_t  Seg119 : 1;
    uint8_t  Seg120 : 1;
    uint8_t  Seg121 : 1;
    uint8_t  Seg122 : 1;
    uint8_t  Seg123 : 1;
    uint8_t  Seg124 : 1;
    uint8_t  Seg125 : 1;
    uint8_t  Seg126 : 1;
    uint8_t  Seg127 : 1;
    uint8_t  Seg128 : 1;
    uint8_t  Seg129 : 1;
    uint8_t  Seg130 : 1;
    uint8_t  Seg131 : 1;
    uint8_t  Seg132 : 1;
    uint8_t  Seg133 : 1;
    uint8_t  Seg134 : 1;
    uint8_t  Seg135 : 1;
    uint8_t  Seg136 : 1;
    uint8_t  Seg137 : 1;
    uint8_t  Seg138 : 1;
    uint8_t  Seg139 : 1;
    uint8_t  Seg140 : 1;
    uint8_t  Seg141 : 1;
    uint8_t  Seg142 : 1;
    uint8_t  Seg143 : 1;
    uint8_t  Seg144 : 1;
    uint8_t  Seg145 : 1;
    uint8_t  Seg146 : 1;
    uint8_t  Seg147 : 1;
    uint8_t  Seg148 : 1;
    uint8_t  Seg149 : 1;
    uint8_t  Seg150 : 1;
    uint8_t  Seg151 : 1;
    uint8_t  Seg152 : 1;
    uint8_t  Seg153 : 1;
    uint8_t  Seg154 : 1;
    uint8_t  Seg155 : 1;
    uint8_t  Seg156 : 1;
    uint8_t  Seg157 : 1;
    uint8_t  Seg158 : 1;
    uint8_t  Seg159 : 1;
    uint8_t  Seg160 : 1;
    uint8_t  Seg161 : 1;
    uint8_t  Seg162 : 1;
    uint8_t  Seg163 : 1;
    uint8_t  Seg164 : 1;
    uint8_t  Seg165 : 1;
    uint8_t  Seg166 : 1;
    uint8_t  Seg167 : 1;
    uint8_t  Seg168 : 1;
    uint8_t  Seg169 : 1;
    uint8_t  Seg170 : 1;
    uint8_t  Seg171 : 1;
    uint8_t  Seg172 : 1;
    uint8_t  Seg173 : 1;
    uint8_t  Seg174 : 1;
    uint8_t  Seg175 : 1;
    uint8_t  Seg176 : 1;
    uint8_t  Seg177 : 1;
    uint8_t  Seg178 : 1;
    uint8_t  Seg179 : 1;
    uint8_t  Seg180 : 1;
    uint8_t         : 4;
  }Bit;
}BU98R10DDRAMUnion;
#endif


#if   USE_BU98R10_CHIP_0

extern volatile BU98R10DDRAMUnion BU98R10Chip0DDRAM;

#define   BU98R10_0_DDRAM                   BU98R10Chip0DDRAM.Byte

#define   BU98R10_0_SEG1                    BU98R10Chip0DDRAM.Bit.Seg1
#define   BU98R10_0_SEG2                    BU98R10Chip0DDRAM.Bit.Seg2
#define   BU98R10_0_SEG3                    BU98R10Chip0DDRAM.Bit.Seg3
#define   BU98R10_0_SEG4                    BU98R10Chip0DDRAM.Bit.Seg4
#define   BU98R10_0_SEG5                    BU98R10Chip0DDRAM.Bit.Seg5
#define   BU98R10_0_SEG6                    BU98R10Chip0DDRAM.Bit.Seg6
#define   BU98R10_0_SEG7                    BU98R10Chip0DDRAM.Bit.Seg7
#define   BU98R10_0_SEG8                    BU98R10Chip0DDRAM.Bit.Seg8
#define   BU98R10_0_SEG9                    BU98R10Chip0DDRAM.Bit.Seg9
#define   BU98R10_0_SEG10                   BU98R10Chip0DDRAM.Bit.Seg10
#define   BU98R10_0_SEG11                   BU98R10Chip0DDRAM.Bit.Seg11
#define   BU98R10_0_SEG12                   BU98R10Chip0DDRAM.Bit.Seg12
#define   BU98R10_0_SEG13                   BU98R10Chip0DDRAM.Bit.Seg13
#define   BU98R10_0_SEG14                   BU98R10Chip0DDRAM.Bit.Seg14
#define   BU98R10_0_SEG15                   BU98R10Chip0DDRAM.Bit.Seg15
#define   BU98R10_0_SEG16                   BU98R10Chip0DDRAM.Bit.Seg16
#define   BU98R10_0_SEG17                   BU98R10Chip0DDRAM.Bit.Seg17
#define   BU98R10_0_SEG18                   BU98R10Chip0DDRAM.Bit.Seg18
#define   BU98R10_0_SEG19                   BU98R10Chip0DDRAM.Bit.Seg19
#define   BU98R10_0_SEG20                   BU98R10Chip0DDRAM.Bit.Seg20
#define   BU98R10_0_SEG21                   BU98R10Chip0DDRAM.Bit.Seg21
#define   BU98R10_0_SEG22                   BU98R10Chip0DDRAM.Bit.Seg22
#define   BU98R10_0_SEG23                   BU98R10Chip0DDRAM.Bit.Seg23
#define   BU98R10_0_SEG24                   BU98R10Chip0DDRAM.Bit.Seg24
#define   BU98R10_0_SEG25                   BU98R10Chip0DDRAM.Bit.Seg25
#define   BU98R10_0_SEG26                   BU98R10Chip0DDRAM.Bit.Seg26
#define   BU98R10_0_SEG27                   BU98R10Chip0DDRAM.Bit.Seg27
#define   BU98R10_0_SEG28                   BU98R10Chip0DDRAM.Bit.Seg28
#define   BU98R10_0_SEG29                   BU98R10Chip0DDRAM.Bit.Seg29
#define   BU98R10_0_SEG30                   BU98R10Chip0DDRAM.Bit.Seg30
#define   BU98R10_0_SEG31                   BU98R10Chip0DDRAM.Bit.Seg31
#define   BU98R10_0_SEG32                   BU98R10Chip0DDRAM.Bit.Seg32
#define   BU98R10_0_SEG33                   BU98R10Chip0DDRAM.Bit.Seg33
#define   BU98R10_0_SEG34                   BU98R10Chip0DDRAM.Bit.Seg34
#define   BU98R10_0_SEG35                   BU98R10Chip0DDRAM.Bit.Seg35
#define   BU98R10_0_SEG36                   BU98R10Chip0DDRAM.Bit.Seg36
#define   BU98R10_0_SEG37                   BU98R10Chip0DDRAM.Bit.Seg37
#define   BU98R10_0_SEG38                   BU98R10Chip0DDRAM.Bit.Seg38
#define   BU98R10_0_SEG39                   BU98R10Chip0DDRAM.Bit.Seg39
#define   BU98R10_0_SEG40                   BU98R10Chip0DDRAM.Bit.Seg40
#define   BU98R10_0_SEG41                   BU98R10Chip0DDRAM.Bit.Seg41
#define   BU98R10_0_SEG42                   BU98R10Chip0DDRAM.Bit.Seg42
#define   BU98R10_0_SEG43                   BU98R10Chip0DDRAM.Bit.Seg43
#define   BU98R10_0_SEG44                   BU98R10Chip0DDRAM.Bit.Seg44
#define   BU98R10_0_SEG45                   BU98R10Chip0DDRAM.Bit.Seg45
#define   BU98R10_0_SEG46                   BU98R10Chip0DDRAM.Bit.Seg46
#define   BU98R10_0_SEG47                   BU98R10Chip0DDRAM.Bit.Seg47
#define   BU98R10_0_SEG48                   BU98R10Chip0DDRAM.Bit.Seg48
#define   BU98R10_0_SEG49                   BU98R10Chip0DDRAM.Bit.Seg49
#define   BU98R10_0_SEG50                   BU98R10Chip0DDRAM.Bit.Seg50
#define   BU98R10_0_SEG51                   BU98R10Chip0DDRAM.Bit.Seg51
#define   BU98R10_0_SEG52                   BU98R10Chip0DDRAM.Bit.Seg52
#define   BU98R10_0_SEG53                   BU98R10Chip0DDRAM.Bit.Seg53
#define   BU98R10_0_SEG54                   BU98R10Chip0DDRAM.Bit.Seg54
#define   BU98R10_0_SEG55                   BU98R10Chip0DDRAM.Bit.Seg55
#define   BU98R10_0_SEG56                   BU98R10Chip0DDRAM.Bit.Seg56
#define   BU98R10_0_SEG57                   BU98R10Chip0DDRAM.Bit.Seg57
#define   BU98R10_0_SEG58                   BU98R10Chip0DDRAM.Bit.Seg58
#define   BU98R10_0_SEG59                   BU98R10Chip0DDRAM.Bit.Seg59
#define   BU98R10_0_SEG60                   BU98R10Chip0DDRAM.Bit.Seg60
#define   BU98R10_0_SEG61                   BU98R10Chip0DDRAM.Bit.Seg61
#define   BU98R10_0_SEG62                   BU98R10Chip0DDRAM.Bit.Seg62
#define   BU98R10_0_SEG63                   BU98R10Chip0DDRAM.Bit.Seg63
#define   BU98R10_0_SEG64                   BU98R10Chip0DDRAM.Bit.Seg64
#define   BU98R10_0_SEG65                   BU98R10Chip0DDRAM.Bit.Seg65
#define   BU98R10_0_SEG66                   BU98R10Chip0DDRAM.Bit.Seg66
#define   BU98R10_0_SEG67                   BU98R10Chip0DDRAM.Bit.Seg67
#define   BU98R10_0_SEG68                   BU98R10Chip0DDRAM.Bit.Seg68
#define   BU98R10_0_SEG69                   BU98R10Chip0DDRAM.Bit.Seg69
#define   BU98R10_0_SEG70                   BU98R10Chip0DDRAM.Bit.Seg70
#define   BU98R10_0_SEG71                   BU98R10Chip0DDRAM.Bit.Seg71
#define   BU98R10_0_SEG72                   BU98R10Chip0DDRAM.Bit.Seg72
#define   BU98R10_0_SEG73                   BU98R10Chip0DDRAM.Bit.Seg73
#define   BU98R10_0_SEG74                   BU98R10Chip0DDRAM.Bit.Seg74
#define   BU98R10_0_SEG75                   BU98R10Chip0DDRAM.Bit.Seg75
#define   BU98R10_0_SEG76                   BU98R10Chip0DDRAM.Bit.Seg76
#define   BU98R10_0_SEG77                   BU98R10Chip0DDRAM.Bit.Seg77
#define   BU98R10_0_SEG78                   BU98R10Chip0DDRAM.Bit.Seg78
#define   BU98R10_0_SEG79                   BU98R10Chip0DDRAM.Bit.Seg79
#define   BU98R10_0_SEG80                   BU98R10Chip0DDRAM.Bit.Seg80
#define   BU98R10_0_SEG81                   BU98R10Chip0DDRAM.Bit.Seg81
#define   BU98R10_0_SEG82                   BU98R10Chip0DDRAM.Bit.Seg82
#define   BU98R10_0_SEG83                   BU98R10Chip0DDRAM.Bit.Seg83
#define   BU98R10_0_SEG84                   BU98R10Chip0DDRAM.Bit.Seg84
#define   BU98R10_0_SEG85                   BU98R10Chip0DDRAM.Bit.Seg85
#define   BU98R10_0_SEG86                   BU98R10Chip0DDRAM.Bit.Seg86
#define   BU98R10_0_SEG87                   BU98R10Chip0DDRAM.Bit.Seg87
#define   BU98R10_0_SEG88                   BU98R10Chip0DDRAM.Bit.Seg88
#define   BU98R10_0_SEG89                   BU98R10Chip0DDRAM.Bit.Seg89
#define   BU98R10_0_SEG90                   BU98R10Chip0DDRAM.Bit.Seg90
#define   BU98R10_0_SEG91                   BU98R10Chip0DDRAM.Bit.Seg91
#define   BU98R10_0_SEG92                   BU98R10Chip0DDRAM.Bit.Seg92
#define   BU98R10_0_SEG93                   BU98R10Chip0DDRAM.Bit.Seg93
#define   BU98R10_0_SEG94                   BU98R10Chip0DDRAM.Bit.Seg94
#define   BU98R10_0_SEG95                   BU98R10Chip0DDRAM.Bit.Seg95
#define   BU98R10_0_SEG96                   BU98R10Chip0DDRAM.Bit.Seg96
#define   BU98R10_0_SEG97                   BU98R10Chip0DDRAM.Bit.Seg97
#define   BU98R10_0_SEG98                   BU98R10Chip0DDRAM.Bit.Seg98
#define   BU98R10_0_SEG99                   BU98R10Chip0DDRAM.Bit.Seg99
#define   BU98R10_0_SEG100                  BU98R10Chip0DDRAM.Bit.Seg100
#define   BU98R10_0_SEG101                  BU98R10Chip0DDRAM.Bit.Seg101
#define   BU98R10_0_SEG102                  BU98R10Chip0DDRAM.Bit.Seg102
#define   BU98R10_0_SEG103                  BU98R10Chip0DDRAM.Bit.Seg103
#define   BU98R10_0_SEG104                  BU98R10Chip0DDRAM.Bit.Seg104
#define   BU98R10_0_SEG105                  BU98R10Chip0DDRAM.Bit.Seg105
#define   BU98R10_0_SEG106                  BU98R10Chip0DDRAM.Bit.Seg106
#define   BU98R10_0_SEG107                  BU98R10Chip0DDRAM.Bit.Seg107
#define   BU98R10_0_SEG108                  BU98R10Chip0DDRAM.Bit.Seg108
#define   BU98R10_0_SEG109                  BU98R10Chip0DDRAM.Bit.Seg109
#define   BU98R10_0_SEG110                  BU98R10Chip0DDRAM.Bit.Seg110
#define   BU98R10_0_SEG111                  BU98R10Chip0DDRAM.Bit.Seg111
#define   BU98R10_0_SEG112                  BU98R10Chip0DDRAM.Bit.Seg112
#define   BU98R10_0_SEG113                  BU98R10Chip0DDRAM.Bit.Seg113
#define   BU98R10_0_SEG114                  BU98R10Chip0DDRAM.Bit.Seg114
#define   BU98R10_0_SEG115                  BU98R10Chip0DDRAM.Bit.Seg115
#define   BU98R10_0_SEG116                  BU98R10Chip0DDRAM.Bit.Seg116
#define   BU98R10_0_SEG117                  BU98R10Chip0DDRAM.Bit.Seg117
#define   BU98R10_0_SEG118                  BU98R10Chip0DDRAM.Bit.Seg118
#define   BU98R10_0_SEG119                  BU98R10Chip0DDRAM.Bit.Seg119
#define   BU98R10_0_SEG120                  BU98R10Chip0DDRAM.Bit.Seg120
#define   BU98R10_0_SEG121                  BU98R10Chip0DDRAM.Bit.Seg121
#define   BU98R10_0_SEG122                  BU98R10Chip0DDRAM.Bit.Seg122
#define   BU98R10_0_SEG123                  BU98R10Chip0DDRAM.Bit.Seg123
#define   BU98R10_0_SEG124                  BU98R10Chip0DDRAM.Bit.Seg124
#define   BU98R10_0_SEG125                  BU98R10Chip0DDRAM.Bit.Seg125
#define   BU98R10_0_SEG126                  BU98R10Chip0DDRAM.Bit.Seg126
#define   BU98R10_0_SEG127                  BU98R10Chip0DDRAM.Bit.Seg127
#define   BU98R10_0_SEG128                  BU98R10Chip0DDRAM.Bit.Seg128
#define   BU98R10_0_SEG129                  BU98R10Chip0DDRAM.Bit.Seg129
#define   BU98R10_0_SEG130                  BU98R10Chip0DDRAM.Bit.Seg130
#define   BU98R10_0_SEG131                  BU98R10Chip0DDRAM.Bit.Seg131
#define   BU98R10_0_SEG132                  BU98R10Chip0DDRAM.Bit.Seg132
#define   BU98R10_0_SEG133                  BU98R10Chip0DDRAM.Bit.Seg133
#define   BU98R10_0_SEG134                  BU98R10Chip0DDRAM.Bit.Seg134
#define   BU98R10_0_SEG135                  BU98R10Chip0DDRAM.Bit.Seg135
#define   BU98R10_0_SEG136                  BU98R10Chip0DDRAM.Bit.Seg136
#define   BU98R10_0_SEG137                  BU98R10Chip0DDRAM.Bit.Seg137
#define   BU98R10_0_SEG138                  BU98R10Chip0DDRAM.Bit.Seg138
#define   BU98R10_0_SEG139                  BU98R10Chip0DDRAM.Bit.Seg139
#define   BU98R10_0_SEG140                  BU98R10Chip0DDRAM.Bit.Seg140
#define   BU98R10_0_SEG141                  BU98R10Chip0DDRAM.Bit.Seg141
#define   BU98R10_0_SEG142                  BU98R10Chip0DDRAM.Bit.Seg142
#define   BU98R10_0_SEG143                  BU98R10Chip0DDRAM.Bit.Seg143
#define   BU98R10_0_SEG144                  BU98R10Chip0DDRAM.Bit.Seg144
#define   BU98R10_0_SEG145                  BU98R10Chip0DDRAM.Bit.Seg145
#define   BU98R10_0_SEG146                  BU98R10Chip0DDRAM.Bit.Seg146
#define   BU98R10_0_SEG147                  BU98R10Chip0DDRAM.Bit.Seg147
#define   BU98R10_0_SEG148                  BU98R10Chip0DDRAM.Bit.Seg148
#define   BU98R10_0_SEG149                  BU98R10Chip0DDRAM.Bit.Seg149
#define   BU98R10_0_SEG150                  BU98R10Chip0DDRAM.Bit.Seg150
#define   BU98R10_0_SEG151                  BU98R10Chip0DDRAM.Bit.Seg151
#define   BU98R10_0_SEG152                  BU98R10Chip0DDRAM.Bit.Seg152
#define   BU98R10_0_SEG153                  BU98R10Chip0DDRAM.Bit.Seg153
#define   BU98R10_0_SEG154                  BU98R10Chip0DDRAM.Bit.Seg154
#define   BU98R10_0_SEG155                  BU98R10Chip0DDRAM.Bit.Seg155
#define   BU98R10_0_SEG156                  BU98R10Chip0DDRAM.Bit.Seg156
#define   BU98R10_0_SEG157                  BU98R10Chip0DDRAM.Bit.Seg157
#define   BU98R10_0_SEG158                  BU98R10Chip0DDRAM.Bit.Seg158
#define   BU98R10_0_SEG159                  BU98R10Chip0DDRAM.Bit.Seg159
#define   BU98R10_0_SEG160                  BU98R10Chip0DDRAM.Bit.Seg160
#define   BU98R10_0_SEG161                  BU98R10Chip0DDRAM.Bit.Seg161
#define   BU98R10_0_SEG162                  BU98R10Chip0DDRAM.Bit.Seg162
#define   BU98R10_0_SEG163                  BU98R10Chip0DDRAM.Bit.Seg163
#define   BU98R10_0_SEG164                  BU98R10Chip0DDRAM.Bit.Seg164
#define   BU98R10_0_SEG165                  BU98R10Chip0DDRAM.Bit.Seg165
#define   BU98R10_0_SEG166                  BU98R10Chip0DDRAM.Bit.Seg166
#define   BU98R10_0_SEG167                  BU98R10Chip0DDRAM.Bit.Seg167
#define   BU98R10_0_SEG168                  BU98R10Chip0DDRAM.Bit.Seg168
#define   BU98R10_0_SEG169                  BU98R10Chip0DDRAM.Bit.Seg169
#define   BU98R10_0_SEG170                  BU98R10Chip0DDRAM.Bit.Seg170
#define   BU98R10_0_SEG171                  BU98R10Chip0DDRAM.Bit.Seg171
#define   BU98R10_0_SEG172                  BU98R10Chip0DDRAM.Bit.Seg172
#define   BU98R10_0_SEG173                  BU98R10Chip0DDRAM.Bit.Seg173
#define   BU98R10_0_SEG174                  BU98R10Chip0DDRAM.Bit.Seg174
#define   BU98R10_0_SEG175                  BU98R10Chip0DDRAM.Bit.Seg175
#define   BU98R10_0_SEG176                  BU98R10Chip0DDRAM.Bit.Seg176
#define   BU98R10_0_SEG177                  BU98R10Chip0DDRAM.Bit.Seg177
#define   BU98R10_0_SEG178                  BU98R10Chip0DDRAM.Bit.Seg178
#define   BU98R10_0_SEG179                  BU98R10Chip0DDRAM.Bit.Seg179
#define   BU98R10_0_SEG180                  BU98R10Chip0DDRAM.Bit.Seg180

#endif

#if   USE_BU98R10_CHIP_1

extern volatile BU98R10DDRAMUnion BU98R10Chip1DDRAM;

#define   BU98R10_1_DDRAM                   BU98R10Chip1DDRAM.Byte

#define   BU98R10_1_SEG1                    BU98R10Chip1DDRAM.Bit.Seg1
#define   BU98R10_1_SEG2                    BU98R10Chip1DDRAM.Bit.Seg2
#define   BU98R10_1_SEG3                    BU98R10Chip1DDRAM.Bit.Seg3
#define   BU98R10_1_SEG4                    BU98R10Chip1DDRAM.Bit.Seg4
#define   BU98R10_1_SEG5                    BU98R10Chip1DDRAM.Bit.Seg5
#define   BU98R10_1_SEG6                    BU98R10Chip1DDRAM.Bit.Seg6
#define   BU98R10_1_SEG7                    BU98R10Chip1DDRAM.Bit.Seg7
#define   BU98R10_1_SEG8                    BU98R10Chip1DDRAM.Bit.Seg8
#define   BU98R10_1_SEG9                    BU98R10Chip1DDRAM.Bit.Seg9
#define   BU98R10_1_SEG10                   BU98R10Chip1DDRAM.Bit.Seg10
#define   BU98R10_1_SEG11                   BU98R10Chip1DDRAM.Bit.Seg11
#define   BU98R10_1_SEG12                   BU98R10Chip1DDRAM.Bit.Seg12
#define   BU98R10_1_SEG13                   BU98R10Chip1DDRAM.Bit.Seg13
#define   BU98R10_1_SEG14                   BU98R10Chip1DDRAM.Bit.Seg14
#define   BU98R10_1_SEG15                   BU98R10Chip1DDRAM.Bit.Seg15
#define   BU98R10_1_SEG16                   BU98R10Chip1DDRAM.Bit.Seg16
#define   BU98R10_1_SEG17                   BU98R10Chip1DDRAM.Bit.Seg17
#define   BU98R10_1_SEG18                   BU98R10Chip1DDRAM.Bit.Seg18
#define   BU98R10_1_SEG19                   BU98R10Chip1DDRAM.Bit.Seg19
#define   BU98R10_1_SEG20                   BU98R10Chip1DDRAM.Bit.Seg20
#define   BU98R10_1_SEG21                   BU98R10Chip1DDRAM.Bit.Seg21
#define   BU98R10_1_SEG22                   BU98R10Chip1DDRAM.Bit.Seg22
#define   BU98R10_1_SEG23                   BU98R10Chip1DDRAM.Bit.Seg23
#define   BU98R10_1_SEG24                   BU98R10Chip1DDRAM.Bit.Seg24
#define   BU98R10_1_SEG25                   BU98R10Chip1DDRAM.Bit.Seg25
#define   BU98R10_1_SEG26                   BU98R10Chip1DDRAM.Bit.Seg26
#define   BU98R10_1_SEG27                   BU98R10Chip1DDRAM.Bit.Seg27
#define   BU98R10_1_SEG28                   BU98R10Chip1DDRAM.Bit.Seg28
#define   BU98R10_1_SEG29                   BU98R10Chip1DDRAM.Bit.Seg29
#define   BU98R10_1_SEG30                   BU98R10Chip1DDRAM.Bit.Seg30
#define   BU98R10_1_SEG31                   BU98R10Chip1DDRAM.Bit.Seg31
#define   BU98R10_1_SEG32                   BU98R10Chip1DDRAM.Bit.Seg32
#define   BU98R10_1_SEG33                   BU98R10Chip1DDRAM.Bit.Seg33
#define   BU98R10_1_SEG34                   BU98R10Chip1DDRAM.Bit.Seg34
#define   BU98R10_1_SEG35                   BU98R10Chip1DDRAM.Bit.Seg35
#define   BU98R10_1_SEG36                   BU98R10Chip1DDRAM.Bit.Seg36
#define   BU98R10_1_SEG37                   BU98R10Chip1DDRAM.Bit.Seg37
#define   BU98R10_1_SEG38                   BU98R10Chip1DDRAM.Bit.Seg38
#define   BU98R10_1_SEG39                   BU98R10Chip1DDRAM.Bit.Seg39
#define   BU98R10_1_SEG40                   BU98R10Chip1DDRAM.Bit.Seg40
#define   BU98R10_1_SEG41                   BU98R10Chip1DDRAM.Bit.Seg41
#define   BU98R10_1_SEG42                   BU98R10Chip1DDRAM.Bit.Seg42
#define   BU98R10_1_SEG43                   BU98R10Chip1DDRAM.Bit.Seg43
#define   BU98R10_1_SEG44                   BU98R10Chip1DDRAM.Bit.Seg44
#define   BU98R10_1_SEG45                   BU98R10Chip1DDRAM.Bit.Seg45
#define   BU98R10_1_SEG46                   BU98R10Chip1DDRAM.Bit.Seg46
#define   BU98R10_1_SEG47                   BU98R10Chip1DDRAM.Bit.Seg47
#define   BU98R10_1_SEG48                   BU98R10Chip1DDRAM.Bit.Seg48
#define   BU98R10_1_SEG49                   BU98R10Chip1DDRAM.Bit.Seg49
#define   BU98R10_1_SEG50                   BU98R10Chip1DDRAM.Bit.Seg50
#define   BU98R10_1_SEG51                   BU98R10Chip1DDRAM.Bit.Seg51
#define   BU98R10_1_SEG52                   BU98R10Chip1DDRAM.Bit.Seg52
#define   BU98R10_1_SEG53                   BU98R10Chip1DDRAM.Bit.Seg53
#define   BU98R10_1_SEG54                   BU98R10Chip1DDRAM.Bit.Seg54
#define   BU98R10_1_SEG55                   BU98R10Chip1DDRAM.Bit.Seg55
#define   BU98R10_1_SEG56                   BU98R10Chip1DDRAM.Bit.Seg56
#define   BU98R10_1_SEG57                   BU98R10Chip1DDRAM.Bit.Seg57
#define   BU98R10_1_SEG58                   BU98R10Chip1DDRAM.Bit.Seg58
#define   BU98R10_1_SEG59                   BU98R10Chip1DDRAM.Bit.Seg59
#define   BU98R10_1_SEG60                   BU98R10Chip1DDRAM.Bit.Seg60
#define   BU98R10_1_SEG61                   BU98R10Chip1DDRAM.Bit.Seg61
#define   BU98R10_1_SEG62                   BU98R10Chip1DDRAM.Bit.Seg62
#define   BU98R10_1_SEG63                   BU98R10Chip1DDRAM.Bit.Seg63
#define   BU98R10_1_SEG64                   BU98R10Chip1DDRAM.Bit.Seg64
#define   BU98R10_1_SEG65                   BU98R10Chip1DDRAM.Bit.Seg65
#define   BU98R10_1_SEG66                   BU98R10Chip1DDRAM.Bit.Seg66
#define   BU98R10_1_SEG67                   BU98R10Chip1DDRAM.Bit.Seg67
#define   BU98R10_1_SEG68                   BU98R10Chip1DDRAM.Bit.Seg68
#define   BU98R10_1_SEG69                   BU98R10Chip1DDRAM.Bit.Seg69
#define   BU98R10_1_SEG70                   BU98R10Chip1DDRAM.Bit.Seg70
#define   BU98R10_1_SEG71                   BU98R10Chip1DDRAM.Bit.Seg71
#define   BU98R10_1_SEG72                   BU98R10Chip1DDRAM.Bit.Seg72
#define   BU98R10_1_SEG73                   BU98R10Chip1DDRAM.Bit.Seg73
#define   BU98R10_1_SEG74                   BU98R10Chip1DDRAM.Bit.Seg74
#define   BU98R10_1_SEG75                   BU98R10Chip1DDRAM.Bit.Seg75
#define   BU98R10_1_SEG76                   BU98R10Chip1DDRAM.Bit.Seg76
#define   BU98R10_1_SEG77                   BU98R10Chip1DDRAM.Bit.Seg77
#define   BU98R10_1_SEG78                   BU98R10Chip1DDRAM.Bit.Seg78
#define   BU98R10_1_SEG79                   BU98R10Chip1DDRAM.Bit.Seg79
#define   BU98R10_1_SEG80                   BU98R10Chip1DDRAM.Bit.Seg80
#define   BU98R10_1_SEG81                   BU98R10Chip1DDRAM.Bit.Seg81
#define   BU98R10_1_SEG82                   BU98R10Chip1DDRAM.Bit.Seg82
#define   BU98R10_1_SEG83                   BU98R10Chip1DDRAM.Bit.Seg83
#define   BU98R10_1_SEG84                   BU98R10Chip1DDRAM.Bit.Seg84
#define   BU98R10_1_SEG85                   BU98R10Chip1DDRAM.Bit.Seg85
#define   BU98R10_1_SEG86                   BU98R10Chip1DDRAM.Bit.Seg86
#define   BU98R10_1_SEG87                   BU98R10Chip1DDRAM.Bit.Seg87
#define   BU98R10_1_SEG88                   BU98R10Chip1DDRAM.Bit.Seg88
#define   BU98R10_1_SEG89                   BU98R10Chip1DDRAM.Bit.Seg89
#define   BU98R10_1_SEG90                   BU98R10Chip1DDRAM.Bit.Seg90
#define   BU98R10_1_SEG91                   BU98R10Chip1DDRAM.Bit.Seg91
#define   BU98R10_1_SEG92                   BU98R10Chip1DDRAM.Bit.Seg92
#define   BU98R10_1_SEG93                   BU98R10Chip1DDRAM.Bit.Seg93
#define   BU98R10_1_SEG94                   BU98R10Chip1DDRAM.Bit.Seg94
#define   BU98R10_1_SEG95                   BU98R10Chip1DDRAM.Bit.Seg95
#define   BU98R10_1_SEG96                   BU98R10Chip1DDRAM.Bit.Seg96
#define   BU98R10_1_SEG97                   BU98R10Chip1DDRAM.Bit.Seg97
#define   BU98R10_1_SEG98                   BU98R10Chip1DDRAM.Bit.Seg98
#define   BU98R10_1_SEG99                   BU98R10Chip1DDRAM.Bit.Seg99
#define   BU98R10_1_SEG100                  BU98R10Chip1DDRAM.Bit.Seg100
#define   BU98R10_1_SEG101                  BU98R10Chip1DDRAM.Bit.Seg101
#define   BU98R10_1_SEG102                  BU98R10Chip1DDRAM.Bit.Seg102
#define   BU98R10_1_SEG103                  BU98R10Chip1DDRAM.Bit.Seg103
#define   BU98R10_1_SEG104                  BU98R10Chip1DDRAM.Bit.Seg104
#define   BU98R10_1_SEG105                  BU98R10Chip1DDRAM.Bit.Seg105
#define   BU98R10_1_SEG106                  BU98R10Chip1DDRAM.Bit.Seg106
#define   BU98R10_1_SEG107                  BU98R10Chip1DDRAM.Bit.Seg107
#define   BU98R10_1_SEG108                  BU98R10Chip1DDRAM.Bit.Seg108
#define   BU98R10_1_SEG109                  BU98R10Chip1DDRAM.Bit.Seg109
#define   BU98R10_1_SEG110                  BU98R10Chip1DDRAM.Bit.Seg110
#define   BU98R10_1_SEG111                  BU98R10Chip1DDRAM.Bit.Seg111
#define   BU98R10_1_SEG112                  BU98R10Chip1DDRAM.Bit.Seg112
#define   BU98R10_1_SEG113                  BU98R10Chip1DDRAM.Bit.Seg113
#define   BU98R10_1_SEG114                  BU98R10Chip1DDRAM.Bit.Seg114
#define   BU98R10_1_SEG115                  BU98R10Chip1DDRAM.Bit.Seg115
#define   BU98R10_1_SEG116                  BU98R10Chip1DDRAM.Bit.Seg116
#define   BU98R10_1_SEG117                  BU98R10Chip1DDRAM.Bit.Seg117
#define   BU98R10_1_SEG118                  BU98R10Chip1DDRAM.Bit.Seg118
#define   BU98R10_1_SEG119                  BU98R10Chip1DDRAM.Bit.Seg119
#define   BU98R10_1_SEG120                  BU98R10Chip1DDRAM.Bit.Seg120
#define   BU98R10_1_SEG121                  BU98R10Chip1DDRAM.Bit.Seg121
#define   BU98R10_1_SEG122                  BU98R10Chip1DDRAM.Bit.Seg122
#define   BU98R10_1_SEG123                  BU98R10Chip1DDRAM.Bit.Seg123
#define   BU98R10_1_SEG124                  BU98R10Chip1DDRAM.Bit.Seg124
#define   BU98R10_1_SEG125                  BU98R10Chip1DDRAM.Bit.Seg125
#define   BU98R10_1_SEG126                  BU98R10Chip1DDRAM.Bit.Seg126
#define   BU98R10_1_SEG127                  BU98R10Chip1DDRAM.Bit.Seg127
#define   BU98R10_1_SEG128                  BU98R10Chip1DDRAM.Bit.Seg128
#define   BU98R10_1_SEG129                  BU98R10Chip1DDRAM.Bit.Seg129
#define   BU98R10_1_SEG130                  BU98R10Chip1DDRAM.Bit.Seg130
#define   BU98R10_1_SEG131                  BU98R10Chip1DDRAM.Bit.Seg131
#define   BU98R10_1_SEG132                  BU98R10Chip1DDRAM.Bit.Seg132
#define   BU98R10_1_SEG133                  BU98R10Chip1DDRAM.Bit.Seg133
#define   BU98R10_1_SEG134                  BU98R10Chip1DDRAM.Bit.Seg134
#define   BU98R10_1_SEG135                  BU98R10Chip1DDRAM.Bit.Seg135
#define   BU98R10_1_SEG136                  BU98R10Chip1DDRAM.Bit.Seg136
#define   BU98R10_1_SEG137                  BU98R10Chip1DDRAM.Bit.Seg137
#define   BU98R10_1_SEG138                  BU98R10Chip1DDRAM.Bit.Seg138
#define   BU98R10_1_SEG139                  BU98R10Chip1DDRAM.Bit.Seg139
#define   BU98R10_1_SEG140                  BU98R10Chip1DDRAM.Bit.Seg140
#define   BU98R10_1_SEG141                  BU98R10Chip1DDRAM.Bit.Seg141
#define   BU98R10_1_SEG142                  BU98R10Chip1DDRAM.Bit.Seg142
#define   BU98R10_1_SEG143                  BU98R10Chip1DDRAM.Bit.Seg143
#define   BU98R10_1_SEG144                  BU98R10Chip1DDRAM.Bit.Seg144
#define   BU98R10_1_SEG145                  BU98R10Chip1DDRAM.Bit.Seg145
#define   BU98R10_1_SEG146                  BU98R10Chip1DDRAM.Bit.Seg146
#define   BU98R10_1_SEG147                  BU98R10Chip1DDRAM.Bit.Seg147
#define   BU98R10_1_SEG148                  BU98R10Chip1DDRAM.Bit.Seg148
#define   BU98R10_1_SEG149                  BU98R10Chip1DDRAM.Bit.Seg149
#define   BU98R10_1_SEG150                  BU98R10Chip1DDRAM.Bit.Seg150
#define   BU98R10_1_SEG151                  BU98R10Chip1DDRAM.Bit.Seg151
#define   BU98R10_1_SEG152                  BU98R10Chip1DDRAM.Bit.Seg152
#define   BU98R10_1_SEG153                  BU98R10Chip1DDRAM.Bit.Seg153
#define   BU98R10_1_SEG154                  BU98R10Chip1DDRAM.Bit.Seg154
#define   BU98R10_1_SEG155                  BU98R10Chip1DDRAM.Bit.Seg155
#define   BU98R10_1_SEG156                  BU98R10Chip1DDRAM.Bit.Seg156
#define   BU98R10_1_SEG157                  BU98R10Chip1DDRAM.Bit.Seg157
#define   BU98R10_1_SEG158                  BU98R10Chip1DDRAM.Bit.Seg158
#define   BU98R10_1_SEG159                  BU98R10Chip1DDRAM.Bit.Seg159
#define   BU98R10_1_SEG160                  BU98R10Chip1DDRAM.Bit.Seg160
#define   BU98R10_1_SEG161                  BU98R10Chip1DDRAM.Bit.Seg161
#define   BU98R10_1_SEG162                  BU98R10Chip1DDRAM.Bit.Seg162
#define   BU98R10_1_SEG163                  BU98R10Chip1DDRAM.Bit.Seg163
#define   BU98R10_1_SEG164                  BU98R10Chip1DDRAM.Bit.Seg164
#define   BU98R10_1_SEG165                  BU98R10Chip1DDRAM.Bit.Seg165
#define   BU98R10_1_SEG166                  BU98R10Chip1DDRAM.Bit.Seg166
#define   BU98R10_1_SEG167                  BU98R10Chip1DDRAM.Bit.Seg167
#define   BU98R10_1_SEG168                  BU98R10Chip1DDRAM.Bit.Seg168
#define   BU98R10_1_SEG169                  BU98R10Chip1DDRAM.Bit.Seg169
#define   BU98R10_1_SEG170                  BU98R10Chip1DDRAM.Bit.Seg170
#define   BU98R10_1_SEG171                  BU98R10Chip1DDRAM.Bit.Seg171
#define   BU98R10_1_SEG172                  BU98R10Chip1DDRAM.Bit.Seg172
#define   BU98R10_1_SEG173                  BU98R10Chip1DDRAM.Bit.Seg173
#define   BU98R10_1_SEG174                  BU98R10Chip1DDRAM.Bit.Seg174
#define   BU98R10_1_SEG175                  BU98R10Chip1DDRAM.Bit.Seg175
#define   BU98R10_1_SEG176                  BU98R10Chip1DDRAM.Bit.Seg176
#define   BU98R10_1_SEG177                  BU98R10Chip1DDRAM.Bit.Seg177
#define   BU98R10_1_SEG178                  BU98R10Chip1DDRAM.Bit.Seg178
#define   BU98R10_1_SEG179                  BU98R10Chip1DDRAM.Bit.Seg179
#define   BU98R10_1_SEG180                  BU98R10Chip1DDRAM.Bit.Seg180

#endif


void BU98R10_Init(void);
void BU98R10_Shutdown(void);
void BU98R10_Update_Request(void);
void BU98R10_Update_Service(void);

#if   USE_BU98R10_CHIP_0
void BU98R10_0_Command_Write(uint8_t Cmd);
void BU98R10_0_Data_Write(uint8_t Dat);
#endif

#if   USE_BU98R10_CHIP_1
void BU98R10_1_Command_Write(uint8_t Cmd);
void BU98R10_1_Data_Write(uint8_t Dat);
#endif

#if   BU98R10_WRITE_AT_SAME_TIME
void BU98R10_All_Command_Write(uint8_t Cmd);
void BU98R10_All_Data_Write(uint8_t Dat0, uint8_t Dat1);
extern void checkSegTftState(void);
#endif




#endif
