#include "GpioUser.h"
#include "Components.h"

#define Gpio_Max 59 /* 64Pin */

#define GpioOut_High RTE_GPIO_DIR_OUT | RTE_GPIO_LEVEL_HIGH
#define GpioOut_Low RTE_GPIO_DIR_OUT | RTE_GPIO_LEVEL_LOW



/**
 * @brief 注意事项
 * 1. PWM引脚需要配置成输入模式，不可配置成输出低，否则会出现闪烁现象；
 * 2. CANstb需要配置成输出高，防止首次上电出现错误帧
 */
const RTE_GPIO_Config_st_t KL30_Init_GpioConfig[Gpio_Max] =
    {

        
        /* PORT0_PIN01 */ {RTE_GPIO_PORT00_PIN01, RTE_GPIO_DIR_IN},
        /* PORT0_PIN02 */ {RTE_GPIO_PORT00_PIN02, GpioOut_Low},
        /* PORT0_PIN03 */ {RTE_GPIO_PORT00_PIN03, GpioOut_Low},
        /* PORT0_PIN04 */ {RTE_GPIO_PORT00_PIN04, GpioOut_Low},
        /* PORT0_PIN05 */ {RTE_GPIO_PORT00_PIN05, RTE_GPIO_DIR_IN},
        /* PORT0_PIN06 */ {RTE_GPIO_PORT00_PIN06, RTE_GPIO_DIR_IN},

        /* PORT1_PIN10 */ {RTE_GPIO_PORT01_PIN00, RTE_GPIO_DIR_IN},
        /* PORT1_PIN11 */ {RTE_GPIO_PORT01_PIN01, GpioOut_Low},
        /* PORT1_PIN12 */ {RTE_GPIO_PORT01_PIN02, GpioOut_Low},        
        /* PORT1_PIN15 */ {RTE_GPIO_PORT01_PIN05, GpioOut_Low},
        /* PORT1_PIN16 */ {RTE_GPIO_PORT01_PIN06, GpioOut_Low},
        /* PORT1_PIN17 */ {RTE_GPIO_PORT01_PIN07, GpioOut_Low},

        /* PORT2_PIN20 */ {RTE_GPIO_PORT02_PIN00, RTE_GPIO_DIR_IN},
        /* PORT2_PIN21 */ {RTE_GPIO_PORT02_PIN01, RTE_GPIO_DIR_IN},
        /* PORT2_PIN22 */ {RTE_GPIO_PORT02_PIN02, RTE_GPIO_DIR_IN},
        /* PORT2_PIN23 */ {RTE_GPIO_PORT02_PIN03, RTE_GPIO_DIR_IN},       
        /* PORT2_PIN25 */ {RTE_GPIO_PORT02_PIN05, RTE_GPIO_DIR_IN},       
        /* PORT2_PIN27 */ {RTE_GPIO_PORT02_PIN07, RTE_GPIO_DIR_IN},
       
        /* PORT3_PIN31 */ {RTE_GPIO_PORT03_PIN01, GpioOut_Low},

        /* PORT4_PIN40 */ {RTE_GPIO_PORT04_PIN00, GpioOut_Low},        
        /* PORT4_PIN43 */ {RTE_GPIO_PORT04_PIN03, RTE_GPIO_DIR_IN},

        /* GPIO_PORT5_PIN50 */ {RTE_GPIO_PORT05_PIN00, RTE_GPIO_DIR_IN},
        /* GPIO_PORT5_PIN51 */ {RTE_GPIO_PORT05_PIN01, GpioOut_Low},
        /* GPIO_PORT5_PIN52 */ {RTE_GPIO_PORT05_PIN02, GpioOut_High},
        /* GPIO_PORT5_PIN53 */ {RTE_GPIO_PORT05_PIN03, RTE_GPIO_DIR_IN},
        /* GPIO_PORT5_PIN54 */ {RTE_GPIO_PORT05_PIN04, RTE_GPIO_DIR_IN},
        /* GPIO_PORT5_PIN55 */ {RTE_GPIO_PORT05_PIN05, GpioOut_Low},

        /* PORT6_PIN60 */ {RTE_GPIO_PORT06_PIN00, GpioOut_Low},
        /* PORT6_PIN61 */ {RTE_GPIO_PORT06_PIN01, GpioOut_Low},
        /* PORT6_PIN62 */ {RTE_GPIO_PORT06_PIN02, GpioOut_Low},
        /* PORT6_PIN63 */ {RTE_GPIO_PORT06_PIN03, GpioOut_Low},

        /* PORT7_PIN70 */ {RTE_GPIO_PORT07_PIN00, GpioOut_Low},
        /* PORT7_PIN71 */ {RTE_GPIO_PORT07_PIN01, GpioOut_Low},
        /* PORT7_PIN72 */ {RTE_GPIO_PORT07_PIN02, GpioOut_Low},
        /* PORT7_PIN73 */ {RTE_GPIO_PORT07_PIN03, RTE_GPIO_DIR_IN},
        /* PORT7_PIN74 */ {RTE_GPIO_PORT07_PIN04, RTE_GPIO_DIR_IN},
        /* PORT7_PIN75 */ {RTE_GPIO_PORT07_PIN05, RTE_GPIO_DIR_IN},
        /* PORT7_PIN76 */ {RTE_GPIO_PORT07_PIN06, RTE_GPIO_DIR_IN},
        /* PORT7_PIN77 */ {RTE_GPIO_PORT07_PIN07, RTE_GPIO_DIR_IN},

        /* PORT12_PIN120 */ {RTE_GPIO_PORT12_PIN00, GpioOut_High},
        /* PORT12_PIN121 */ {RTE_GPIO_PORT12_PIN01, GpioOut_Low},
        /* PORT12_PIN122 */ {RTE_GPIO_PORT12_PIN02, GpioOut_Low},
        /* PORT12_PIN123 */ {RTE_GPIO_PORT12_PIN03, GpioOut_Low},
        /* PORT12_PIN124 */ {RTE_GPIO_PORT12_PIN04, GpioOut_Low},
        
        /* PORT13_PIN137 */ {RTE_GPIO_PORT13_PIN07, GpioOut_Low},

        /* PORT14_PIN140 */ {RTE_GPIO_PORT14_PIN00, GpioOut_High},
        /* PORT14_PIN141 */ {RTE_GPIO_PORT14_PIN01, GpioOut_High},
        /* PORT14_PIN146 */ {RTE_GPIO_PORT14_PIN06, GpioOut_Low},
        

};

const RTE_GPIO_Config_st_t Sleep_Init_GpioConfig[Gpio_Max] =
    {
        
        /* PORT0_PIN01 */ {RTE_GPIO_PORT00_PIN01, RTE_GPIO_DIR_IN},
        /* PORT0_PIN02 */ {RTE_GPIO_PORT00_PIN02, GpioOut_Low},
        /* PORT0_PIN03 */ {RTE_GPIO_PORT00_PIN03, GpioOut_Low},
        /* PORT0_PIN04 */ {RTE_GPIO_PORT00_PIN04, GpioOut_Low},
        /* PORT0_PIN05 */ {RTE_GPIO_PORT00_PIN05, RTE_GPIO_DIR_IN},
        /* PORT0_PIN06 */ {RTE_GPIO_PORT00_PIN06, RTE_GPIO_DIR_IN},

        /* PORT1_PIN10 */ {RTE_GPIO_PORT01_PIN00, GpioOut_Low},
        /* PORT1_PIN11 */ {RTE_GPIO_PORT01_PIN01, GpioOut_Low},
        /* PORT1_PIN12 */ {RTE_GPIO_PORT01_PIN02, GpioOut_Low},      
        /* PORT1_PIN15 */ {RTE_GPIO_PORT01_PIN05, GpioOut_Low},
        /* PORT1_PIN16 */ {RTE_GPIO_PORT01_PIN06, GpioOut_Low},
        /* PORT1_PIN17 */ {RTE_GPIO_PORT01_PIN07, GpioOut_Low},

        /* PORT2_PIN20 */ {RTE_GPIO_PORT02_PIN00, GpioOut_High},
        /* PORT2_PIN21 */ {RTE_GPIO_PORT02_PIN01, GpioOut_Low},
        /* PORT2_PIN22 */ {RTE_GPIO_PORT02_PIN02, RTE_GPIO_DIR_IN},
        /* PORT2_PIN23 */ {RTE_GPIO_PORT02_PIN03, RTE_GPIO_DIR_IN},
        /* PORT2_PIN25 */ {RTE_GPIO_PORT02_PIN05, RTE_GPIO_DIR_IN},   
        /* PORT2_PIN27 */ {RTE_GPIO_PORT02_PIN07, RTE_GPIO_DIR_IN},

        
        /* PORT3_PIN31 */ {RTE_GPIO_PORT03_PIN01, GpioOut_Low},

        /* PORT4_PIN40 */ {RTE_GPIO_PORT04_PIN00, GpioOut_Low},
        
        /* PORT4_PIN43 */ {RTE_GPIO_PORT04_PIN03, RTE_GPIO_DIR_IN},

        /* GPIO_PORT5_PIN50 */ {RTE_GPIO_PORT05_PIN00, RTE_GPIO_DIR_IN},
        /* GPIO_PORT5_PIN51 */ {RTE_GPIO_PORT05_PIN01, GpioOut_High},
        /* GPIO_PORT5_PIN52 */ {RTE_GPIO_PORT05_PIN02, GpioOut_High},
        /* GPIO_PORT5_PIN53 */ {RTE_GPIO_PORT05_PIN03, RTE_GPIO_DIR_IN},
        /* GPIO_PORT5_PIN54 */ {RTE_GPIO_PORT05_PIN04, RTE_GPIO_DIR_IN},
        /* GPIO_PORT5_PIN55 */ {RTE_GPIO_PORT05_PIN05, GpioOut_Low},

        /* PORT6_PIN60 */ {RTE_GPIO_PORT06_PIN00, GpioOut_High},
        /* PORT6_PIN61 */ {RTE_GPIO_PORT06_PIN01, GpioOut_High},
        /* PORT6_PIN62 */ {RTE_GPIO_PORT06_PIN02, GpioOut_High},
        /* PORT6_PIN63 */ {RTE_GPIO_PORT06_PIN03, GpioOut_High},

        /* PORT7_PIN70 */ {RTE_GPIO_PORT07_PIN00, GpioOut_Low},
        /* PORT7_PIN71 */ {RTE_GPIO_PORT07_PIN01, GpioOut_Low},
        /* PORT7_PIN72 */ {RTE_GPIO_PORT07_PIN02, GpioOut_Low},
        /* PORT7_PIN73 */ {RTE_GPIO_PORT07_PIN03, RTE_GPIO_DIR_IN},
        /* PORT7_PIN74 */ {RTE_GPIO_PORT07_PIN04, RTE_GPIO_DIR_IN},
        /* PORT7_PIN75 */ {RTE_GPIO_PORT07_PIN05, RTE_GPIO_DIR_IN},
        /* PORT7_PIN76 */ {RTE_GPIO_PORT07_PIN06, RTE_GPIO_DIR_IN},
        /* PORT7_PIN77 */ {RTE_GPIO_PORT07_PIN07, RTE_GPIO_DIR_IN},

        /* PORT12_PIN120 */ {RTE_GPIO_PORT12_PIN00, RTE_GPIO_DIR_IN},
        /* PORT12_PIN121 */ {RTE_GPIO_PORT12_PIN01, GpioOut_Low},
        /* PORT12_PIN122 */ {RTE_GPIO_PORT12_PIN02, GpioOut_Low},
        /* PORT12_PIN123 */ {RTE_GPIO_PORT12_PIN03, GpioOut_Low},
        /* PORT12_PIN124 */ {RTE_GPIO_PORT12_PIN04, GpioOut_Low},
        
        /* PORT13_PIN137 */ {RTE_GPIO_PORT13_PIN07, GpioOut_Low},

        /* PORT14_PIN140 */ {RTE_GPIO_PORT14_PIN00, RTE_GPIO_DIR_IN},
        /* PORT14_PIN141 */ {RTE_GPIO_PORT14_PIN01, RTE_GPIO_DIR_IN},
        /* PORT14_PIN146 */ {RTE_GPIO_PORT14_PIN06, GpioOut_Low},
        


};




void Gpio_Init(_GpioUser_Enum InitMode)
{
    uint8_t i = 0;
    if (InitMode == Gpio_Uvalid)
    {
        return;
    }

    if ((InitMode == Gpio_KL30_Init) || (InitMode == Gpio_WakeUp_Init))
    {   
        /*为满足I2C时序要求*/
        RTE_GPIO_Config(RTE_GPIO_PORT12_PIN00, GpioOut_High);//5V切电
        RTE_GPIO_Config(RTE_GPIO_PORT06_PIN02, GpioOut_Low); //EE存储SCL
        Gen_TimeDelay(100 * 1000u, 50u);
        for (i = 0; i < Gpio_Max; i++)
        {
            RTE_GPIO_Config(KL30_Init_GpioConfig[i].u16PinNum, KL30_Init_GpioConfig[i].u16PinMode);
        }
    }
    else if (InitMode == Gpio_Sleep_Init)
    {
        for (i = 0; i < Gpio_Max; i++)
        {
            RTE_GPIO_Config(Sleep_Init_GpioConfig[i].u16PinNum, Sleep_Init_GpioConfig[i].u16PinMode);
        }
    }
    else
    {
        ;
    }
}
