

#ifndef TELLTALES_H
#define TELLTALES_H

/*
Platform_32Bit
Platform_16Bit
*/

#ifdef Platform_16Bit
    #define Tellib_uint8_t  unsigned char
    #define Tellib_uint16_t unsigned int
    #define Tellib_uint32_t unsigned long

#else
    #define Tellib_uint8_t  unsigned char
    #define Tellib_uint16_t unsigned short
    #define Tellib_uint32_t unsigned int
    #define Tellib_uint64_t unsigned long long

#endif

#define Tel_MEM_Block_Addition ((Tellib_uint8_t)16u)
#define Tel_MEM_Block_Size (((Tellib_uint8_t)2u))
/*
total size =Tel_MEM_Block_Size*LED_Max+Tel_MEM_Block_Addition
*/
//#define LED_OFF (Tellib_uint8_t)(0x00u)    /**< 指示灯点亮状态 */
//#define LED_ON  (Tellib_uint8_t)(0x01u)    /**< 指示灯熄灭状态 */

#define Diag_LED_OFF (Tellib_uint8_t)(0x10u) /**< 指示灯点亮状态,诊断控制 */
#define Diag_LED_ON  (Tellib_uint8_t)(0x11u) /**< 指示灯熄灭状态,诊断控制 */

#define NoSelfCheck (Tellib_uint8_t)(0x00u)  /**< 指示灯不需要执行内部自检 */
#define SelfCheck   (Tellib_uint8_t)(0x01u)  /**< 指示灯需要执行内部自检,即自检期间强制点亮 */

#define LED_Exist   (Tellib_uint8_t)(0x00u)
#define LED_NOExist (Tellib_uint8_t)(0x01u)

#define AllowBreak (Tellib_uint8_t)(0x00u)
#define NoBreak    (Tellib_uint8_t)(0x01u)

#define NoExterNalCheck (Tellib_uint8_t)(0x00u) /**< 指示灯自检期间,不响应外部信号 */
#define ExterNalCheck   (Tellib_uint8_t)(0x01u) /**< 指示灯自检期间,根据外部信号执行 */

#define LED_IGN_OFF    (Tellib_uint8_t)(0x00u)  /**< 指示灯工作在IG OFF下 */
#define LED_IGN_ON     (Tellib_uint8_t)(0x01u)  /**< 指示灯工作在IG ON下 */ 
#define LED_IGN_ON_OFF (Tellib_uint8_t)(0x02u)  /**< 指示灯工作在IG ON/OFF下 */

#define LED_PWR_OFF (Tellib_uint8_t)(0x00u) /**< 指示灯模块所获取的外部电源状态为IG OFF */
#define LED_PWR_ON  (Tellib_uint8_t)(0x01u) /**< 指示灯模块所获取的外部电源状态为IG ON */

#define LED_CheckNoFinish (Tellib_uint8_t)(0x00u) /**< 外部设置自检未结束 */
#define LED_CheckFinished (Tellib_uint8_t)(0x01u) /**< 外部设置自检结束,用于打断自检 */

#define LED_OFF_State (Tellib_uint8_t)(0x00u)  /**< 指示灯当前状态为OFF */
#define LED_ON_State  (Tellib_uint8_t)(0x01u)  /**< 指示灯当前状态为ON */

typedef Tellib_uint16_t (*LED_Judgment)(void);   /**< 指示灯逻辑判断回调函数原型 */
typedef void (*LED_Execution)(Tellib_uint16_t led_status); /**< 指示灯执行回调函数原型 */

typedef Tellib_uint8_t (*LED_PowerSts)(void);  /**< 指示灯电源获取函数 回调函数原型 */
typedef Tellib_uint32_t (*LED_PowerONTimer)(void); /**< 指示灯IG ON时间戳 回调函数原型 */
typedef Tellib_uint32_t (*LED_PowerOFFTimer)(void); /**< 指示灯IG OFF时间戳 回调函数原型 */
/**@struct TelExtPara
 * @brief 指示灯初始化结构体 \n
 * 定义指示灯初始化结构体属性
 */
typedef struct
{
    Tellib_uint32_t   TotalLength;              /**< 指示灯总数量 */
    LED_PowerOFFTimer LED_PowerOFF_TimerCbk;    /**< IG OFF下计时时间戳回调函数 */
    LED_PowerONTimer  LED_PowerON_TimerCbk;     /**< IG ON下计时时间戳回调函数 */
    LED_PowerSts      LED_PowerCbk;             /**< IG电源状态回调函数 */
} TelExtPara;
/**@struct LED_Attribute_st
 * @brief 指示灯属性结构体 \n
 * 定义指示灯结构体属性
 */
typedef struct
{
    Tellib_uint16_t LED_Index;       /**< 指示灯序号 */
    Tellib_uint16_t isSelfCheck;     /**< 指示灯是否执行自检 */
    Tellib_uint16_t isExCheck;       /**< 指示灯是否按内部信号强制自检 */
    Tellib_uint16_t WorkSts;        /**< 指示灯工作的电源状态 */

    Tellib_uint32_t CheckStart;  /**< 指示灯自检起始时间点,单位ms */
    Tellib_uint32_t CheckEnd;   /**< 指示灯自检结束时间点,单位ms */

    LED_Judgment  LED_Judgment_Cbk; /**< 指示灯工作条件判断函数 */
    LED_Execution LED_Execution_Cbk;/**< 指示灯工作条件执行函数 */
} LED_Attribute_st;

Tellib_uint16_t  Get_TelltalesLedSts(Tellib_uint32_t LedIdx);
Tellib_uint16_t Tel_VersionGet(void);

void Telltales_Management(void);
void Test_LED_AllLight(Tellib_uint16_t LedSts);
void Telltales_KL30_Wakeup_Init(Tellib_uint8_t *MemSpace, const LED_Attribute_st *Array, TelExtPara *para);
void Telltales_DiagCtrl(Tellib_uint32_t ledIdx, Tellib_uint8_t LED_Sts);
void Telltales_DiagRelease(Tellib_uint32_t ledIdx);

void Telltales_KL15_Init(void);
void Telltales_SetCheckFinish(Tellib_uint8_t CheckFinish);

#endif
