#ifndef CAN_CH0_CAN_COMMUNICATION_MATRIX_H_
#define CAN_CH0_CAN_COMMUNICATION_MATRIX_H_

#include "Components.h"

extern st_CanMsgOp CAN_CH0_CanMsgOp;
extern st_CanMsgTxOp CAN_CH0_CanMsgTxOp;

typedef enum
{
    CAN_CH0_ID_CAN_0x402_Msg_Count,
    CAN_CH0_ID_CAN_0x341_Msg_Count,
    CAN_CH0_ID_CAN_0x111_Msg_Count,
    CAN_CH0_ID_CAN_0x401_Msg_Count,    
    CAN_CH0_ID_CAN_0x120_Msg_Count,
    CAN_CH0_ID_CAN_0x101_Msg_Count,
    CAN_CH0_ID_CAN_0x373_Msg_Count,

    CAN_CH0_ID_TOTAL_MAX,
} CAN_CH0_CAN_MSG_ID_t;

typedef enum
{
    CAN_CH0_ID_CAN_0x220_Msg_Count,
    CAN_CH0_ID_CAN_0x6EE_Msg_Count,
    CAN_CH0_ID_CAN_0x6EF_Msg_Count,
    CAN_CH0_ID_CAN_0x450_Msg_Count,
#if (IC_Current == TY200_080000b_ty)
    CAN_CH0_ID_CAN_0x580_Msg_Count,
#endif
    CAN_CH0_ID_SEND_TOTAL,
} CAN_CH0_CAN_MSG_SEND_ID_t;

extern const st_CANMsgAttribute CAN_CH0_CAN_MSG_CONST_ARRAY[CAN_CH0_ID_TOTAL_MAX] ;
extern const st_CAN_SendAttribute    CAN_CH0_CANSendAttr[CAN_CH0_ID_SEND_TOTAL] ;

#define  CAN_CH0_ID_CAN_0x402_Msg    0x402ul
#define  CAN_CH0_ID_CAN_0x341_Msg    0x341ul
#define  CAN_CH0_ID_CAN_0x111_Msg    0x111ul
#define  CAN_CH0_ID_CAN_0x401_Msg    0x401ul
#define  CAN_CH0_ID_CAN_0x220_Msg    0x220ul
#define  CAN_CH0_ID_CAN_0x120_Msg    0x120ul
#define  CAN_CH0_ID_CAN_0x101_Msg    0x101ul
#define  CAN_CH0_ID_CAN_0x373_Msg    0x373ul

extern uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_Warning_Lamp(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCL2(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCM2(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCH2(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCAmnt(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCL1(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCM1(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCH1(void);
extern uint8_t  Get_CAN_CH0_ID_341_Sig_software_version(void);
extern uint8_t  Get_CAN_CH0_ID_341_Sig_Rear_LearningStatus(void);
extern uint8_t  Get_CAN_CH0_ID_341_Sig_Front_LearningStatus(void);
extern uint8_t  Get_CAN_CH0_ID_341_Sig_Rear_Pressure_Warning(void);
extern uint8_t  Get_CAN_CH0_ID_341_Sig_Front_Pressure_Warning(void);
extern uint8_t  Get_CAN_CH0_ID_341_Sig_Rear_TireTemperature(void);
extern uint8_t  Get_CAN_CH0_ID_341_Sig_Front_TireTemperature(void);
extern uint8_t  Get_CAN_CH0_ID_341_Sig_Rear_Pressure(void);
extern uint8_t  Get_CAN_CH0_ID_341_Sig_Front_Pressure(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_SideStand_State(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_SideStand(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Engine_InjIgn_Cutoff_State(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Engine_InjIgn_Cutoff(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Engine_Autostop_State(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Engine_Autostop(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_111_Livecounter(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_111_Checksum(void);
extern uint8_t  Get_CAN_CH0_ID_401_Sig_ECU_401_Checksum(void);
extern uint8_t  Get_CAN_CH0_ID_401_Sig_ECU_401_Livecounter(void);
extern uint8_t  Get_CAN_CH0_ID_401_Sig_ECU_Gear_State(void);
extern uint16_t Get_CAN_CH0_ID_401_Sig_ECU_Fuel_Consumption(void);
extern uint8_t  Get_CAN_CH0_ID_401_Sig_ECU_Battery_Voltage(void);
extern uint16_t Get_CAN_CH0_ID_401_Sig_ECU_Environment_Presure(void);
extern uint8_t  Get_CAN_CH0_ID_220_Sig_CheckSum(void);
extern uint8_t  Get_CAN_CH0_ID_220_Sig_AliveCounter(void);
extern uint8_t  Get_CAN_CH0_ID_220_Sig_TCS_Switch(void);
extern uint8_t  Get_CAN_CH0_ID_120_Sig_TCSStatus(void);
extern uint8_t  Get_CAN_CH0_ID_120_Sig_RearWheelSpeedValidity(void);
extern uint16_t Get_CAN_CH0_ID_120_Sig_RearWheelSpeed(void);
extern uint8_t  Get_CAN_CH0_ID_120_Sig_Rear_ABS_control_status(void);
extern uint8_t  Get_CAN_CH0_ID_120_Sig_FrontWheelSpeedValidity(void);
extern uint16_t Get_CAN_CH0_ID_120_Sig_FrontWheelSpeed(void);
extern uint8_t  Get_CAN_CH0_ID_120_Sig_Front_ABS_control_status(void);
extern uint8_t  Get_CAN_CH0_ID_120_Sig_CheckSum(void);
extern uint8_t  Get_CAN_CH0_ID_120_Sig_AliveCounter(void);
extern uint8_t  Get_CAN_CH0_ID_120_Sig_ABS_Warning_lamp(void);
extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Vehicle_Speed_State(void);
extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Vehicle_Speed(void);
extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Throttle_Position_State(void);
extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Throttle_Position(void);
extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Engine_Temperature_State(void);
extern uint16_t Get_CAN_CH0_ID_101_Sig_ECU_Engine_Temperature(void);
extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Engine_Speed_State(void);
extern uint16_t Get_CAN_CH0_ID_101_Sig_ECU_Engine_Speed(void);
extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_101_Livecounter(void);
extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_101_Checksum(void);
extern uint32_t Get_CAN_CH0_ID_373_Sig_Front_id(void);
extern uint32_t Get_CAN_CH0_ID_373_Sig_Rear_id(void);

extern uint8_t  Co_Can_ConvertSubID_CAN_CH0(uint32_t MsgID);

#endif
