
#ifndef RTE_GPIO_BAT32A239_H__
#define RTE_GPIO_BAT32A239_H__

#include "stdint.h"

#define RTE_GPIO_PORT_MAX 15
#define RTE_GPIO_PORT_PIN_MAX 8

#define RTE_GPIO_IRQ_MAX 12

typedef struct
{
    uint16_t  u16Pin;
    uint16_t  u16Type;
    int32_t   i32Flag;
    void     *pvHandler;
}RTE_GPIO_IRQ_Desc_st_t;

#define   RTE_GPIO_PORT_GROUP_00             (0U)
#define   RTE_GPIO_PORT_GROUP_01             (1U)
#define   RTE_GPIO_PORT_GROUP_02             (2U)
#define   RTE_GPIO_PORT_GROUP_03             (3U)
#define   RTE_GPIO_PORT_GROUP_04             (4U)
#define   RTE_GPIO_PORT_GROUP_05             (5U)
#define   RTE_GPIO_PORT_GROUP_06             (6U)
#define   RTE_GPIO_PORT_GROUP_07             (7U)
#define   RTE_GPIO_PORT_GROUP_12             (12U)
#define   RTE_GPIO_PORT_GROUP_13             (13U)
#define   RTE_GPIO_PORT_GROUP_14             (14U)

#define   RTE_GPIO_PIN_NUM_00               (0x00U)
#define   RTE_GPIO_PIN_NUM_01               (0x01U)
#define   RTE_GPIO_PIN_NUM_02               (0x02U)
#define   RTE_GPIO_PIN_NUM_03               (0x03U)
#define   RTE_GPIO_PIN_NUM_04               (0x04U)
#define   RTE_GPIO_PIN_NUM_05               (0x05U)
#define   RTE_GPIO_PIN_NUM_06               (0x06U)
#define   RTE_GPIO_PIN_NUM_07               (0x07U)

#define   RTE_GPIO_PORT00_PIN00             (((uint16_t)RTE_GPIO_PORT_GROUP_00 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_00)
#define   RTE_GPIO_PORT00_PIN01             (((uint16_t)RTE_GPIO_PORT_GROUP_00 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_01)
#define   RTE_GPIO_PORT00_PIN02             (((uint16_t)RTE_GPIO_PORT_GROUP_00 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_02)
#define   RTE_GPIO_PORT00_PIN03             (((uint16_t)RTE_GPIO_PORT_GROUP_00 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_03)
#define   RTE_GPIO_PORT00_PIN04             (((uint16_t)RTE_GPIO_PORT_GROUP_00 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_04)
#define   RTE_GPIO_PORT00_PIN05             (((uint16_t)RTE_GPIO_PORT_GROUP_00 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_05)
#define   RTE_GPIO_PORT00_PIN06             (((uint16_t)RTE_GPIO_PORT_GROUP_00 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_06)

#define   RTE_GPIO_PORT01_PIN00             (((uint16_t)RTE_GPIO_PORT_GROUP_01 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_00)
#define   RTE_GPIO_PORT01_PIN01             (((uint16_t)RTE_GPIO_PORT_GROUP_01 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_01)
#define   RTE_GPIO_PORT01_PIN02             (((uint16_t)RTE_GPIO_PORT_GROUP_01 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_02)
#define   RTE_GPIO_PORT01_PIN03             (((uint16_t)RTE_GPIO_PORT_GROUP_01 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_03)
#define   RTE_GPIO_PORT01_PIN04             (((uint16_t)RTE_GPIO_PORT_GROUP_01 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_04)
#define   RTE_GPIO_PORT01_PIN05             (((uint16_t)RTE_GPIO_PORT_GROUP_01 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_05)
#define   RTE_GPIO_PORT01_PIN06             (((uint16_t)RTE_GPIO_PORT_GROUP_01 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_06)
#define   RTE_GPIO_PORT01_PIN07             (((uint16_t)RTE_GPIO_PORT_GROUP_01 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_07)

#define   RTE_GPIO_PORT02_PIN00              (((uint16_t)RTE_GPIO_PORT_GROUP_02 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_00)
#define   RTE_GPIO_PORT02_PIN01              (((uint16_t)RTE_GPIO_PORT_GROUP_02 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_01)
#define   RTE_GPIO_PORT02_PIN02              (((uint16_t)RTE_GPIO_PORT_GROUP_02 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_02)
#define   RTE_GPIO_PORT02_PIN03              (((uint16_t)RTE_GPIO_PORT_GROUP_02 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_03)
#define   RTE_GPIO_PORT02_PIN04              (((uint16_t)RTE_GPIO_PORT_GROUP_02 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_04)
#define   RTE_GPIO_PORT02_PIN05              (((uint16_t)RTE_GPIO_PORT_GROUP_02 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_05)
#define   RTE_GPIO_PORT02_PIN06              (((uint16_t)RTE_GPIO_PORT_GROUP_02 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_06)
#define   RTE_GPIO_PORT02_PIN07              (((uint16_t)RTE_GPIO_PORT_GROUP_02 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_07)

#define   RTE_GPIO_PORT03_PIN00              (((uint16_t)RTE_GPIO_PORT_GROUP_03 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_00)
#define   RTE_GPIO_PORT03_PIN01              (((uint16_t)RTE_GPIO_PORT_GROUP_03 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_01)

#define   RTE_GPIO_PORT04_PIN00              (((uint16_t)RTE_GPIO_PORT_GROUP_04 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_00)
#define   RTE_GPIO_PORT04_PIN01              (((uint16_t)RTE_GPIO_PORT_GROUP_04 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_01)
#define   RTE_GPIO_PORT04_PIN02              (((uint16_t)RTE_GPIO_PORT_GROUP_04 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_02)
#define   RTE_GPIO_PORT04_PIN03              (((uint16_t)RTE_GPIO_PORT_GROUP_04 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_03)

#define   RTE_GPIO_PORT05_PIN00              (((uint16_t)RTE_GPIO_PORT_GROUP_05 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_00)
#define   RTE_GPIO_PORT05_PIN01              (((uint16_t)RTE_GPIO_PORT_GROUP_05 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_01)
#define   RTE_GPIO_PORT05_PIN02              (((uint16_t)RTE_GPIO_PORT_GROUP_05 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_02)
#define   RTE_GPIO_PORT05_PIN03              (((uint16_t)RTE_GPIO_PORT_GROUP_05 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_03)
#define   RTE_GPIO_PORT05_PIN04              (((uint16_t)RTE_GPIO_PORT_GROUP_05 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_04)
#define   RTE_GPIO_PORT05_PIN05              (((uint16_t)RTE_GPIO_PORT_GROUP_05 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_05)

#define   RTE_GPIO_PORT06_PIN00              (((uint16_t)RTE_GPIO_PORT_GROUP_06 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_00)
#define   RTE_GPIO_PORT06_PIN01              (((uint16_t)RTE_GPIO_PORT_GROUP_06 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_01)
#define   RTE_GPIO_PORT06_PIN02              (((uint16_t)RTE_GPIO_PORT_GROUP_06 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_02)
#define   RTE_GPIO_PORT06_PIN03              (((uint16_t)RTE_GPIO_PORT_GROUP_06 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_03)

#define   RTE_GPIO_PORT07_PIN00              (((uint16_t)RTE_GPIO_PORT_GROUP_07 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_00)
#define   RTE_GPIO_PORT07_PIN01              (((uint16_t)RTE_GPIO_PORT_GROUP_07 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_01)
#define   RTE_GPIO_PORT07_PIN02              (((uint16_t)RTE_GPIO_PORT_GROUP_07 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_02)
#define   RTE_GPIO_PORT07_PIN03              (((uint16_t)RTE_GPIO_PORT_GROUP_07 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_03)
#define   RTE_GPIO_PORT07_PIN04              (((uint16_t)RTE_GPIO_PORT_GROUP_07 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_04)
#define   RTE_GPIO_PORT07_PIN05              (((uint16_t)RTE_GPIO_PORT_GROUP_07 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_05)
#define   RTE_GPIO_PORT07_PIN06              (((uint16_t)RTE_GPIO_PORT_GROUP_07 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_06)
#define   RTE_GPIO_PORT07_PIN07              (((uint16_t)RTE_GPIO_PORT_GROUP_07 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_07)

#define   RTE_GPIO_PORT12_PIN00              (((uint16_t)RTE_GPIO_PORT_GROUP_12 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_00)
#define   RTE_GPIO_PORT12_PIN01              (((uint16_t)RTE_GPIO_PORT_GROUP_12 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_01)
#define   RTE_GPIO_PORT12_PIN02              (((uint16_t)RTE_GPIO_PORT_GROUP_12 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_02)
#define   RTE_GPIO_PORT12_PIN03              (((uint16_t)RTE_GPIO_PORT_GROUP_12 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_03)
#define   RTE_GPIO_PORT12_PIN04              (((uint16_t)RTE_GPIO_PORT_GROUP_12 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_04)

#define   RTE_GPIO_PORT13_PIN00              (((uint16_t)RTE_GPIO_PORT_GROUP_13 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_00)
#define   RTE_GPIO_PORT13_PIN06              (((uint16_t)RTE_GPIO_PORT_GROUP_13 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_06)
#define   RTE_GPIO_PORT13_PIN07              (((uint16_t)RTE_GPIO_PORT_GROUP_13 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_07)

#define   RTE_GPIO_PORT14_PIN00              (((uint16_t)RTE_GPIO_PORT_GROUP_14 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_00)
#define   RTE_GPIO_PORT14_PIN01              (((uint16_t)RTE_GPIO_PORT_GROUP_14 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_01)
#define   RTE_GPIO_PORT14_PIN06              (((uint16_t)RTE_GPIO_PORT_GROUP_14 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_06)
#define   RTE_GPIO_PORT14_PIN07              (((uint16_t)RTE_GPIO_PORT_GROUP_14 << 8) | (uint16_t)RTE_GPIO_PIN_NUM_07)


#endif /* RTE_GPIO_BAT32A239_H__ */
