#ifndef _GUI_DISPLAY_H_
#define _GUI_DISPLAY_H_

#include "Components.h"



typedef struct 
{
    uint16_t value;
    uint8_t  segNum;
}PowerSegMap_st_t;

typedef struct 
{
    uint16_t value;
    uint8_t  segNum;
}BatterySegMap_st_t;



typedef struct
{
    uint16_t  Year;
    uint8_t   Month;
    uint8_t   Date;
    uint8_t   Hour;
    uint8_t   Minute;
    uint8_t   Second;
    uint8_t   Rsvd;
} RTC_Time_Setting_st_t;


#define POSITIVE_POWER_SEG_MAP_MAX (sizeof(PositivePowerSegMap)/sizeof(PowerSegMap_st_t))
#define NEGATIVE_POWER_SEG_MAP_MAX (sizeof(NegativePowerSegMap)/sizeof(PowerSegMap_st_t))
#define BATTERY_SEG_MAP_MAX (sizeof(batterySegMap)/sizeof(BatterySegMap_st_t))

#define POWERON_SCAN_TIMER   3000ul

void Gauge_VSpeed_Display(void);
void Gauge_Power_Display(void);
void Gauge_Battery_Display(void);


void Gauge_Clock_Display(void);
void Gauge_DrivingRange_Display(void);
void Gauge_Trip_Display(void);
void Gauge_ODO_Display(void);
//void Gauge_Gear_Display(void);
void Gauge_FuelDial_Display(void);
void Gauge_EspeedDial_Display(void);
void Gauge_Frame_Display(void);
void Gauge_MaintenanceMileage_Display(void);
void Gauge_EnergyRecoveryLevel_Display(void);


void Gauge_KL30_Init(void);
void Gauge_KL15_Init(void);
void Gauge_Service(void);

void Temp_Calc_Init(void);
void Temp_Calc_Send(void);
uint32_t Get_Temp_Calc(void);

#endif
