#ifndef __SERVICE_ODO_USER_H__
#define __SERVICE_ODO_USER_H__



//#define  ONLY_CLEAR_ODO_MIL    0x01u        /*仅根据距离信息进行ODO清除*/
//#define  ONLY_CLEAR_ODO_NUM    0x01u        /*仅根据次数信息进行ODO清除*/
#define CLEAR_ODO_NUM_MIL 0x01u /*以距离信息以及次数信息进行ODO清除*/

#define ODO_CLEAR_NUM 5u     /*清除次数上限值 */
#define ODO_CLEAR_MIL 50000u /*清除距离上限值 单位0.1KM*/

#define EEPROM_BLOCK_00 0x00
#define EEPROM_BLOCK_01 0x20
#define EEPROM_BLOCK_02 0x40
#define EEPROM_BLOCK_03 0x60
#define EEPROM_BLOCK_04 0x80
#define EEPROM_BLOCK_05 0xC0
#define EEPROM_BLOCK_06 0xE0
#define EEPROM_BLOCK_07 0x100
#define EEPROM_BLOCK_08 0x120
#define EEPROM_BLOCK_09 0x140

extern uint8_t ODO_Clear_Num_Value;

void Data_User_Mileage_KL30Init(void);
void Data_User_Mileage_WakeupInit(void);
void Services_Mileage_Callback(void);
void Data_ODO_KM_TO_MILE(void);
void Data_TRIP_KM_TO_MILE(void);
uint32_t Get_MileageInit_Status(void);
extern uint32_t Get_ODO_Value(void);
extern uint32_t Get_Trip_Value(void);
extern void Trip_Clear_Km_Service(void);
extern void Unit_Convert_Service(void);
 uint32_t Data_User_EEPROM_Read(uint16_t u16BlockID, uint32_t u32Data[], uint16_t u16Len);
 void Data_User_EEPROM_Write(Data_EEPROM_Enum_t BlockID, uint32_t u32Data[], uint16_t u16Len);
#endif
