

#include "Telltales_Lib.h"
#include "Telltales_user.h"
#include "Line_In\Line_In_user.h"
#include "Application.h"
#include "CAN_APP\CAN_CH0_CAN_Communication_Matrix.h"
#include "Components.h"
#include "LED_Driver_Interface.h"


static Tellib_uint16_t LED_High_Beam_Judgement(void);
static void            LED_High_Beam_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_FAULT_ELECTROSPRAY_Judgement(void);
static void            LED_FAULT_ELECTROSPRAY_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_ABS_Judgement(void);
static void            LED_ABS_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Oil_Pressure_Judgement(void);
static void            LED_Oil_Pressure_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Fuel_Judgement(void);
static void            LED_Fuel_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Coolant_Judgement(void);
static void            LED_Coolant_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Bluetooth_Judgement(void);
static void            LED_Bluetooth_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_TCS_Judgement(void);
static void            LED_TCS_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Auto_Start_Judgement(void);
static void            LED_Auto_Start_Execution(Tellib_uint16_t led_status);
//static Tellib_uint16_t LED_Keys_Judgement(void);
//static void            LED_Keys_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Maintain_Judgement(void);
static void            LED_Maintain_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Low_Batt_Judgement(void);
static void            LED_Low_Batt_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Lateral_Strut_Judgement(void);
static void            LED_Lateral_Strut_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Tire_Pressure_Judgement(void);
static void            LED_Tire_Pressure_Execution(Tellib_uint16_t led_status);
//static Tellib_uint16_t LED_Navigato_Judgement(void);
//static void            LED_Navigato_Execution(Tellib_uint16_t led_status);


Led_HighBeam_Count HighBeam_Timer;
Tellib_uint16_t LED_Battery_Voltage = 0;
Tellib_uint16_t Battery_Voltage_valid = 0;
const LED_Attribute_st LED_Attribute [ LED_Max ] = {
    /*  指示灯索引                  是否自检          外部信号自检           工作电源状态       自检开始时间    自检持续时间       指示灯点亮条件                           指示灯执行函数               */
    
    {em_LED_High_Beam,              SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_High_Beam_Judgement,            LED_High_Beam_Execution},
    {em_LED_FAULT_ELECTROSPRAY,     SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_FAULT_ELECTROSPRAY_Judgement,   LED_FAULT_ELECTROSPRAY_Execution},
    {em_LED_ABS,                    SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_ABS_Judgement,                  LED_ABS_Execution},
    {em_LED_Oil_Pressure,           SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Oil_Pressure_Judgement,         LED_Oil_Pressure_Execution},
    {em_LED_Fuel,                   SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Fuel_Judgement,                 LED_Fuel_Execution},
    {em_LED_Coolant,                SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Coolant_Judgement,              LED_Coolant_Execution},
    {em_LED_Bluetooth,              SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Bluetooth_Judgement,            LED_Bluetooth_Execution},
    {em_LED_TCS,                    SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_TCS_Judgement,                  LED_TCS_Execution},
    {em_LED_Auto_Start_Stop,        SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Auto_Start_Judgement,           LED_Auto_Start_Execution},
    //{em_LED_Keys,                   SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Keys_Judgement,                 LED_Keys_Execution},
    {em_LED_Maintain,               SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Maintain_Judgement,             LED_Maintain_Execution},
    {em_LED_Low_Batt_Vol,           SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Low_Batt_Judgement,             LED_Low_Batt_Execution},
    {em_LED_Lateral_Strut,          SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Lateral_Strut_Judgement,        LED_Lateral_Strut_Execution},
#if(IC_Current == TY200_080000b_ty)
    {em_LED_Tire_Pressure_Alarm,    SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Tire_Pressure_Judgement,        LED_Tire_Pressure_Execution},
#endif
    //{em_LED_Navigator,              SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Navigato_Judgement,             LED_Navigato_Execution},

};


Tellib_uint8_t Tel_Mem [ Tel_MEM_Block_Size * LED_Max + Tel_MEM_Block_Addition ];

void Telltales_Init(void)
{
    TelExtPara m_ExtPara;
    m_ExtPara.TotalLength           = LED_Max;
    m_ExtPara.LED_PowerOFF_TimerCbk = Common_GetIgnOffTime;
    m_ExtPara.LED_PowerON_TimerCbk  = Common_GetIgnOnTime;
    m_ExtPara.LED_PowerCbk          = Common_Get_IG_Sts;    
    Telltales_KL30_Wakeup_Init(Tel_Mem, LED_Attribute, &m_ExtPara);
    
}
void Telltales_UserInit(void)
{
    HighBeam_Timer.LED_Turnon       = 0;
    HighBeam_Timer.LED_Turnoff      = 0;
    LED_Battery_Voltage             = 0;
    Battery_Voltage_valid           = 0;
}
  
static Tellib_uint16_t LED_High_Beam_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (Line_In_Get_Status(LINE_IN_HighBeam))
    {
        LED_STATE = 1;
        //if(HighBeam_Timer.LED_Turnon < 10 )
        //{
        //    HighBeam_Timer.LED_Turnon ++;
        //}
        //else 
        //{
        //    HighBeam_Timer.LED_Turnon = 10;
        //    HighBeam_Timer.LED_Turnoff = 0;
        //}
        
    }
    else
    {
        LED_STATE = 0;
        //if(HighBeam_Timer.LED_Turnoff < 10 )
        //{
        //    HighBeam_Timer.LED_Turnoff ++;
        //}
        //else 
        //{
        //    HighBeam_Timer.LED_Turnoff = 10;
        //    HighBeam_Timer.LED_Turnon = 0;
        //}
        
    }
    return LED_STATE;
}
static void LED_High_Beam_Execution(Tellib_uint16_t led_status)
{
    if ( led_status == 1u )
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_29_High_Beam, LED_ON);
        SEG_SET_LED_STS(em_SEG_High_Beam, 1);
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_29_High_Beam, LED_OFF);
        SEG_SET_LED_STS(em_SEG_High_Beam, 0);
    }
}
static Tellib_uint16_t LED_FAULT_ELECTROSPRAY_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (Line_In_Get_Status(LINE_IN_FAULT_ELECTROSPRAY))
    {
        LED_STATE = 1;
    }
    else
    {
        LED_STATE = 0;
    }
    return LED_STATE;
}
static void LED_FAULT_ELECTROSPRAY_Execution(Tellib_uint16_t led_status)
{
    if (led_status == 1u)
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_32_Fault_Diagnosis, LED_ON);
        SEG_SET_LED_STS(em_SEG_FAULT_ELECTROSPRAY, 1);
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_32_Fault_Diagnosis, LED_OFF);
        SEG_SET_LED_STS(em_SEG_FAULT_ELECTROSPRAY, 0);
    }
}
static Tellib_uint16_t LED_ABS_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CAN_0x120_Msg_Count) == CAN_SIG_LOST) )
    {
        LED_STATE = 1;
    }
    else
    {
        if (Line_In_Get_Status(LINE_IN_Fault_ABS))
        {
            LED_STATE = 0;
        }
        else
        {
            LED_STATE = 1;
        }
    }
    
    return LED_STATE;
}
static void LED_ABS_Execution(Tellib_uint16_t led_status)
{
    if (led_status == 1u)
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_12_ABS_Alarm, LED_ON);
        SEG_SET_LED_STS(em_SEG_ABS, 1);
    }    
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_12_ABS_Alarm, LED_OFF);
        SEG_SET_LED_STS(em_SEG_ABS, 0);
    }
}
static Tellib_uint16_t LED_Oil_Pressure_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (Line_In_Get_Status(LINE_IN_Oil_Pressure))
    {
        LED_STATE = 1;
    }
    else
    {
        LED_STATE = 0;
    }
    return LED_STATE;
}
static void LED_Oil_Pressure_Execution(Tellib_uint16_t led_status)
{
    if (led_status == 1u)
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_22_Oil_Pressure, LED_ON);
        SEG_SET_LED_STS(em_SEG_Oil_Pressure, 1);
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_22_Oil_Pressure, LED_OFF);
        SEG_SET_LED_STS(em_SEG_Oil_Pressure, 0);
    }
}
static Tellib_uint16_t LED_Fuel_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (Common_GetIgnOnTime() >= 3000)
    {
        if(Get_Fuel_Sensor_State() == FuelSensorNormal)
        {
            if(Get_CurFuelSetp() > 1)
            {
                LED_STATE = 3;//白灯
            }
            else 
            {
                LED_STATE = 2;//格小于等于1，黄灯闪
            }
        }
        else
        {
            LED_STATE = 2;//开路，黄灯闪
        }
    }
    else
    {
        LED_STATE = 1;   //黄灯常亮
    }
    return LED_STATE;
}
static void LED_Fuel_Execution(Tellib_uint16_t led_status)
{
    if ( led_status == 3u )
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_21_Fuel_W, LED_ON);  
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_20_Fuel_Y, LED_OFF);  
        SEG_SET_LED_STS(em_SEG_Fuel,1);      
    }
    else if ( led_status == 2u )
    {
        if (FLASH_SYNC_1Hz)
        {
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_20_Fuel_Y, LED_ON);
            SEG_SET_LED_STS(em_SEG_Fuel,1);
        }
        else
        {
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_20_Fuel_Y, LED_OFF);
            SEG_SET_LED_STS(em_SEG_Fuel,0);
        }
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_21_Fuel_W, LED_OFF);  
        
    }
    else if ( led_status == 1u )
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_20_Fuel_Y, LED_ON);
        SEG_SET_LED_STS(em_SEG_Fuel,1);
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_21_Fuel_W, LED_OFF);  
    }
    else 
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_21_Fuel_W, LED_OFF); 
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_20_Fuel_Y, LED_OFF);
        //SEG_SET_LED_STS(em_SEG_Fuel,0);
    }
}
static Tellib_uint16_t LED_Coolant_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if(GET_DataCollantTempWarnflg() == 2)
    {
        LED_STATE = 2;
    }
    else if (GET_DataCollantTempWarnflg() == 1)
    {
        LED_STATE = 3;
    }
    else
    {
        LED_STATE = 4;
    }
    return LED_STATE;
}
static void LED_Coolant_Execution(Tellib_uint16_t led_status)
{
    if ( led_status == 2u )
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_13_Temp_AlarmW, LED_OFF);
        if (FLASH_SYNC_1Hz)
        {
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_11_Temp_AlarmR, LED_ON);
            SEG_SET_LED_STS(em_SEG_Coolant, 1);
        }
        else
        {
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_11_Temp_AlarmR, LED_OFF);
            SEG_SET_LED_STS(em_SEG_Coolant, 0);
        }
    }
    else if ( led_status == 3u )
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_11_Temp_AlarmR, LED_OFF);
        if (FLASH_SYNC_1Hz)
        {
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_13_Temp_AlarmW, LED_ON);
            SEG_SET_LED_STS(em_SEG_Coolant, 1);
        }
        else
        {
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_13_Temp_AlarmW, LED_OFF);
            SEG_SET_LED_STS(em_SEG_Coolant, 0);
        }
    }
    else if ( led_status == 4u )
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_13_Temp_AlarmW, LED_ON);
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_11_Temp_AlarmR, LED_OFF);
        SEG_SET_LED_STS(em_SEG_Coolant, 1);
    } 
    else if ( led_status == 1u )
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_13_Temp_AlarmW, LED_OFF);
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_11_Temp_AlarmR, LED_ON);
        SEG_SET_LED_STS(em_SEG_Coolant, 1);
    }  
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_13_Temp_AlarmW, LED_OFF);
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_11_Temp_AlarmR, LED_OFF);
        SEG_SET_LED_STS(em_SEG_Coolant, 0);
    }
}
static Tellib_uint16_t LED_Bluetooth_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (BlueTooth.BLE_St)
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}
static void LED_Bluetooth_Execution(Tellib_uint16_t led_status)
{
    if ( led_status == 1u )
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_23_Bluetooth, LED_ON);
        SEG_SET_LED_STS(em_SEG_Bluetooth, 1);
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_23_Bluetooth, LED_OFF);
        SEG_SET_LED_STS(em_SEG_Bluetooth, 0);
    }

}
static Tellib_uint16_t LED_TCS_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (Get_Dis_Tcs_Val() == 1)
    {
        if((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CAN_0x120_Msg_Count) == CAN_SIG_LOST) )
        {
            LED_STATE = 1; 
        }
        else
        {
            
            if((Get_CAN_CH0_ID_120_Sig_TCSStatus() == 1) || (Get_CAN_CH0_ID_120_Sig_TCSStatus() == 2) || (Get_CAN_CH0_ID_120_Sig_TCSStatus() == 3) || (Get_CAN_CH0_ID_120_Sig_TCSStatus() == 5))
            {
               LED_STATE = 1; 
            }
            else if (Get_CAN_CH0_ID_120_Sig_TCSStatus() == 4)
            {
                LED_STATE = 2;  //1HZ闪烁
            }
            else if (Get_CAN_CH0_ID_120_Sig_TCSStatus() == 6)
            {
                LED_STATE = 3;  //2HZ闪烁
            }
            else if ((Get_CAN_CH0_ID_120_Sig_TCSStatus() == 0) || (Get_CAN_CH0_ID_120_Sig_TCSStatus() == 7))
            {
                LED_STATE = 0;
            }
            
        }
    }
    else
    {
        LED_STATE = 0;
    }
    
    
    return LED_STATE;
}
static void LED_TCS_Execution(Tellib_uint16_t led_status)
{
    if ( led_status == 1u )
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_25_TCS_Alarm, LED_ON);
        SEG_SET_LED_STS(em_SEG_TCS, 1);
    }
    else if ( led_status == 2u )
    {
        if (FLASH_SYNC_1Hz)
        {
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_25_TCS_Alarm, LED_ON);
            SEG_SET_LED_STS(em_SEG_TCS, 1);
        }
        else
        {
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_25_TCS_Alarm, LED_OFF);
            SEG_SET_LED_STS(em_SEG_TCS, 0);
        }
    }
    else if ( led_status == 3u )
    {
        if (FLASH_SYNC_2Hz)
        {
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_25_TCS_Alarm, LED_ON);
            SEG_SET_LED_STS(em_SEG_TCS, 1);
        }
        else
        {
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_25_TCS_Alarm, LED_OFF);
            SEG_SET_LED_STS(em_SEG_TCS, 0);
        }
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_25_TCS_Alarm, LED_OFF);
        SEG_SET_LED_STS(em_SEG_TCS, 0);
    }
}
static Tellib_uint16_t LED_Auto_Start_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (Line_In_Get_Status(LINE_IN_Auto_Start_Stop))
    {
        LED_STATE = 1;
    }
    else
    {
        LED_STATE = 0;
    }
    return LED_STATE;
}
static void LED_Auto_Start_Execution(Tellib_uint16_t led_status)
{
    if ( led_status == 1u )
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_28_Auto_Star_Stop, LED_ON);
        SEG_SET_LED_STS(em_SEG_Auto_Start_Stop, 1);
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_28_Auto_Star_Stop, LED_OFF);
        SEG_SET_LED_STS(em_SEG_Auto_Start_Stop, 0);
    }
}
//static Tellib_uint16_t LED_Keys_Judgement(void)
//{
//    Tellib_uint16_t LED_STATE = 0u;
//    return LED_STATE;
//}
//static void LED_Keys_Execution(Tellib_uint16_t led_status)
//{
//    ;
//}
static Tellib_uint16_t LED_Maintain_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if(Get_Data_Maintenace_Interval_Processing() == 0)
    {
        LED_STATE = 1;
    }
    else
    {
        LED_STATE = 0;
    }
    return LED_STATE;
}
static void LED_Maintain_Execution(Tellib_uint16_t led_status)
{
    if ( led_status == 1u )
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_33_Upkeep, LED_ON);
        SEG_SET_LED_STS(em_SEG_Upkeep, 1);
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_33_Upkeep, LED_OFF);
        SEG_SET_LED_STS(em_SEG_Upkeep, 0);
    }
}
static Tellib_uint16_t LED_Low_Batt_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    Tellib_uint16_t Battery_Voltage = 0u;
    
    Battery_Voltage = Get_CAN_CH0_ID_401_Sig_ECU_Battery_Voltage();
    if((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CAN_0x401_Msg_Count) == CAN_SIG_LOST) )
    {
        LED_Battery_Voltage = 1; 
        Battery_Voltage_valid = 0;
    }
    else
    {
        if(Battery_Voltage_valid == 1)
        {
            Battery_Voltage_valid = 1;
            if (Get_Battery_Voltage() < 118)
            {
                LED_Battery_Voltage = 1; 
            }
            else if (Get_Battery_Voltage() >= 120)
            {
                LED_Battery_Voltage = 0;
            }
            else
            {
                ;
            }
        }
        else
        {
            Battery_Voltage_valid = 1;
            if (Get_Battery_Voltage() < 118)
            {
                LED_Battery_Voltage = 1; 
            }
            else
            {
                LED_Battery_Voltage = 0; 
            }
        }
        
    }
    LED_STATE = LED_Battery_Voltage;
    return LED_STATE;
}
static void LED_Low_Batt_Execution(Tellib_uint16_t led_status)
{
    if ( led_status == 1u )
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_31_Low_Voltage, LED_ON);
        SEG_SET_LED_STS(em_SEG_Low_Batt_Vol, 1);
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_31_Low_Voltage, LED_OFF);
        SEG_SET_LED_STS(em_SEG_Low_Batt_Vol, 0);
    }
}
static Tellib_uint16_t LED_Lateral_Strut_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    Tellib_uint16_t SideStand = 0u;
    Tellib_uint16_t SideStand_State = 0u;
    SideStand = Get_CAN_CH0_ID_111_Sig_ISG_SideStand();
    SideStand_State = Get_CAN_CH0_ID_111_Sig_ISG_SideStand_State();
    if((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CAN_0x111_Msg_Count) == CAN_SIG_LOST) )
    {
        LED_STATE = 0; 
    }
    else
    {
        if ( SideStand_State == 1)
        {
            LED_STATE = 0;
        }
        else
        {
            if (SideStand == 1)
            {
                LED_STATE = 1;
            }
            else
            {
                LED_STATE = 0;
            }
        }
    }
    return LED_STATE;
}
static void LED_Lateral_Strut_Execution(Tellib_uint16_t led_status)
{
    if ( led_status == 1u )
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_30_Lateral_Support, LED_ON);
        SEG_SET_LED_STS(em_SEG_Lateral_Strut, 1);
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_30_Lateral_Support, LED_OFF);
        SEG_SET_LED_STS(em_SEG_Lateral_Strut, 0);
    }
}
static Tellib_uint16_t LED_Tire_Pressure_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if((Get_Front_FirstLearn_Flag() == 2) || (Get_Rear_FirstLearn_Flag() == 2))
    {
        if(Get_Led_TPMS_Waring() == 1)
        {
            LED_STATE = 1;
        }
        else
        {
            LED_STATE = 2;
        }
    }
    else
    {
        LED_STATE = 2;
    }
    
    return LED_STATE;
}
static void LED_Tire_Pressure_Execution(Tellib_uint16_t led_status)
{
    if ( led_status == 1u )
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_27_Tire_PressureY, LED_ON);
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_26_Tire_PressureW, LED_OFF);
        SEG_SET_LED_STS(em_SEG_Tire_Pressure_Alarm, 1);
    }
    else if ( led_status == 2u )
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_26_Tire_PressureW, LED_ON);
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_27_Tire_PressureY, LED_OFF);
        SEG_SET_LED_STS(em_SEG_Tire_Pressure_Alarm, 1);
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_26_Tire_PressureW, LED_OFF);
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_27_Tire_PressureY, LED_OFF);
        SEG_SET_LED_STS(em_SEG_Tire_Pressure_Alarm, 0);
    }

}
static Tellib_uint16_t LED_Navigato_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    return LED_STATE;
}
static void LED_Navigato_Execution(Tellib_uint16_t led_status)
{
    ;
}



void Turn_Left_Right_Lamp(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if ((Common_GetIgnOnTime() >= 3000) && (ClearODO_Flag == 0))
        {
            if (Line_In_Get_Status(LINE_IN_TurnLeft))
            {
                LED_Driver_Channel_Set(LampChannel_0, LampCh0_06_Turn_Left, LED_ON);
                SEG_SET_LED_STS(em_SEG_Turn_Left, 1);
            }
            else
            {
                LED_Driver_Channel_Set(LampChannel_0, LampCh0_06_Turn_Left, LED_OFF);
                SEG_SET_LED_STS(em_SEG_Turn_Left, 0);
            }
            if (Line_In_Get_Status(LINE_IN_TurnRight))
            {
                LED_Driver_Channel_Set(LampChannel_0, LampCh0_05_Turn_Right, LED_ON);
                SEG_SET_LED_STS(em_SEG_Turn_Right, 1);
            }
            else
            {
                LED_Driver_Channel_Set(LampChannel_0, LampCh0_05_Turn_Right, LED_OFF);
                SEG_SET_LED_STS(em_SEG_Turn_Right, 0);
            }
        }
        else
        {
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_06_Turn_Left, LED_ON);
            SEG_SET_LED_STS(em_SEG_Turn_Left, 1);
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_05_Turn_Right, LED_ON);
            SEG_SET_LED_STS(em_SEG_Turn_Right, 1);
        }
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_06_Turn_Left, LED_OFF);
        SEG_SET_LED_STS(em_SEG_Turn_Left, 0);
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_05_Turn_Right, LED_OFF);
        SEG_SET_LED_STS(em_SEG_Turn_Right, 0);
    }
} 
