/*
 * TrmerM.h
 *
 *  Created on: 2024年2月21日
 */

#ifndef RTE_CAN_H_
#define RTE_CAN_H_

#include <stdint.h>
#include "can.h"


typedef void (* can_rx_callback)(CanTxRxMsg*);

typedef enum
{
    CAN_500Kbps = 4,
    CAN_250Kbps = 8,
    CAN_125Kbps = 16,
    //CAN_100Kbps = 20, //测试有BUG
} CAN_freq;

/**
 * @brief CAN
 * 
 */
typedef enum
{
    CAN_CH_0 = 0,
} CAN_CH;

#pragma pack(4)
typedef struct
{
    CAN_CH ch;
    CAN_freq freq;
    uint32_t MASK[4];
    can_rx_callback rx_callback;
} can_config_st_t;
#pragma pack()
extern CanTxRxMsg CAN_RecvMsg;
extern uint8_t rte_can_init(can_config_st_t *config);
extern uint8_t rte_can_deinit(CAN_CH ch);
extern uint8_t get_can_busoff(CAN_CH ch);
extern uint8_t reset_busoff(CAN_CH ch);

#endif /* RTE_CAN_H_ */
