

#include "Telltales_Lib.h"
#include "Telltales_user.h"
#include "Line_In\Line_In_user.h"
#include "Application.h"
#include "CAN_APP\CAN_CH0_CAN_Communication_Matrix.h"
#include "Components.h"

static Tellib_uint16_t LED_High_Beam_Judgement(void);
static void            LED_High_Beam_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Efi_Fault_Judgement(void);
static void            LED_Efi_Fault_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Auto_Start_Stop_Judgement(void);
static void            LED_Auto_Start_Stop_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Voltage_Judgement(void);
static void            LED_Voltage_Execution(Tellib_uint16_t led_status);

static Tellib_uint16_t LED_Fuel_Judgement(void);
static void            LED_Fuel_Execution(Tellib_uint16_t led_status);

static Tellib_uint16_t LED_Atmosphere_Judgement(void);
static void            LED_Atmosphere_Execution(Tellib_uint16_t led_status);
uint8_t u8CanId401Flag = 0;
const LED_Attribute_st LED_Attribute [ LED_Max ] = {
    /*  指示灯索引                  是否自检          外部信号自检           工作电源状态       自检开始时间    自检持续时间       指示灯点亮条件                           指示灯执行函数               */
    
    {em_LED_High_Beam,            SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_High_Beam_Judgement,            LED_High_Beam_Execution },
    {em_LED_Efi_Fault,            SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Efi_Fault_Judgement,            LED_Efi_Fault_Execution },
    {em_LED_Auto_Start_Stop,      SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Auto_Start_Stop_Judgement,      LED_Auto_Start_Stop_Execution },
    {em_LED_Voltage,              SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Voltage_Judgement,              LED_Voltage_Execution },    
    {em_LED_Fuel,                 SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Fuel_Judgement,                 LED_Fuel_Execution },
    {em_LED_Atmosphere,           SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Atmosphere_Judgement,           LED_Atmosphere_Execution},
};


Tellib_uint8_t Tel_Mem [ Tel_MEM_Block_Size * LED_Max + Tel_MEM_Block_Addition ];

void Telltales_Init(void)
{
    TelExtPara m_ExtPara;
    m_ExtPara.TotalLength           = LED_Max;
    m_ExtPara.LED_PowerOFF_TimerCbk = Common_GetIgnOffTime;
    m_ExtPara.LED_PowerON_TimerCbk  = Common_GetIgnOnTime;
    m_ExtPara.LED_PowerCbk          = Common_Get_IG_Sts;
    u8CanId401Flag = 0;
    Telltales_KL30_Wakeup_Init(Tel_Mem, LED_Attribute, &m_ExtPara);
}


void Can_ID_401(uint8_t CopyData [])
{
    u8CanId401Flag = 1;
}

  
static Tellib_uint16_t LED_High_Beam_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (Line_In_Get_Status(LINE_IN_HighBeam))
    {
        LED_STATE = 1;
    }
    else
    {
        LED_STATE = 0;
    }
    return LED_STATE;
}
static void LED_High_Beam_Execution(Tellib_uint16_t led_status)
{
    if ( led_status == 1u )
    {
        RTE_GPIO_Set_Level(HighBeam_MUC_OUT, LED_LINEOUT_High);
    }
    else
    {
        RTE_GPIO_Set_Level(HighBeam_MUC_OUT, LED_LINEOUT_Low);
    }
}
static Tellib_uint16_t LED_Efi_Fault_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CAN_0x402_Msg_Count) == CAN_SIG_LOST)
    {
        LED_STATE = 0u;
    }
    else
    {
        if(Get_CAN_CH0_ID_402_Sig_ECU_Warning_Lamp() == 1)
        {
            LED_STATE = 1u;
        }
        else
        {
            LED_STATE = 0u;
        }
    }
    return LED_STATE;
}
static void LED_Efi_Fault_Execution(Tellib_uint16_t led_status)
{
    if ( led_status == 1u )
    {
        RTE_GPIO_Set_Level(EFI_FAULT_OUT, LED_LINEOUT_High);
    }
    else
    {
        RTE_GPIO_Set_Level(EFI_FAULT_OUT, LED_LINEOUT_Low);
    }
}

Tellib_uint8_t Auto_Start_Stop      = 0u;
Tellib_uint8_t Key_ISTOP            = 0u;
void Telltales_Auto_Start_Stop(void)
{
    Auto_Start_Stop = 0;
    
}
void Telltales_Auto_Start_Stop_Setting(void)
{
    if (Auto_Start_Stop == 0)
    {
        Auto_Start_Stop = 1;
    }
    else if (Auto_Start_Stop == 1)
    {
        Auto_Start_Stop = 0;
    }
    else
    {
        ;
    }
}
static Tellib_uint16_t LED_Auto_Start_Stop_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    
    if (Auto_Start_Stop == 1)
    {
        if (Line_In_Get_Status(LINE_IN_Auto_Start_Stop))
        {
            LED_STATE = 1;            
        }
        else
        {
            LED_STATE = 0;            
        }
    }
    else 
    {
        LED_STATE = 0;        
    }
    
    return LED_STATE;
}
static void LED_Auto_Start_Stop_Execution(Tellib_uint16_t led_status)
{
    if ( led_status == 1u )
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_07_Key_ISTOP, LED_ON);        
        SEG_SET_LED_STS(1,1);  
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_07_Key_ISTOP, LED_OFF); 
        SEG_SET_LED_STS(1,0);   
    }
}

Tellib_uint8_t Telltales_Voltage_Date(void)
{
    Tellib_uint8_t Voltage = 0;
    Voltage = Get_CAN_CH0_ID_401_Sig_ECU_Battery_Voltage();    
    return Voltage;
} 
static Tellib_uint16_t LED_Voltage_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    Tellib_uint16_t Voltage    = 0u;
    Voltage = Telltales_Voltage_Date();
    if ((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CAN_0x401_Msg_Count) == CAN_SIG_LOST) || (u8CanId401Flag != 1))
    {
        u8CanId401Flag = 0;
        LED_STATE = 0u;
    }
    else
    {
        if ((Voltage < 120) || (Voltage > 150)) 
        {
            LED_STATE = 1u;
        }
        else 
        {
            LED_STATE = 2u;
        }
    }
    return LED_STATE;
}
static void LED_Voltage_Execution(Tellib_uint16_t led_status)
{
    if ( led_status == 1u )
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_03_High_Low_Voltage, LED_ON);  
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_02_Normal_Voltage, LED_OFF); 
        SEG_SET_LED_STS(0,1);        
    }
    else if ( led_status == 2u )
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_02_Normal_Voltage, LED_ON); 
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_03_High_Low_Voltage, LED_OFF); 
        SEG_SET_LED_STS(0,1);
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_03_High_Low_Voltage, LED_OFF);  
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_02_Normal_Voltage, LED_OFF); 
        SEG_SET_LED_STS(0,0);  
    }
}

static Tellib_uint16_t LED_Fuel_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (Common_GetIgnOnTime() >= 3000)
    {
        if(Get_Fuel_Sensor_State() == FuelSensorNormal)
        {
            if(Get_CurFuelSetp() > 1)
            {
                LED_STATE = 3;//白灯
            }
            else 
            {
                LED_STATE = 2;//格小于等于1
            }
        }
        else
        {
            LED_STATE = 2;//开路
        }
    }
    else
    {
        LED_STATE = 1;//自检只亮黄
    }
    return LED_STATE;
}
static void LED_Fuel_Execution(Tellib_uint16_t led_status)
{
    if ( led_status == 3u )
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_04_Fuel_W, LED_ON);  
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_05_Fuel_Y, LED_OFF);  
        SEG_SET_LED_STS(2,1);      
    }
    else if ( led_status == 2u )
    {
        if (FLASH_SYNC_1Hz)
        {
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_05_Fuel_Y, LED_ON);
            SEG_SET_LED_STS(2,1);
        }
        else
        {
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_05_Fuel_Y, LED_OFF);
            SEG_SET_LED_STS(2,0);
        }
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_04_Fuel_W, LED_OFF);  
        
    }
    else if ( led_status == 1u )
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_05_Fuel_Y, LED_ON);
        SEG_SET_LED_STS(2,1);
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_04_Fuel_W, LED_OFF);  
    }
    else 
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_04_Fuel_W, LED_OFF); 
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_05_Fuel_Y, LED_OFF);
        SEG_SET_LED_STS(2,0);
    }
}

static Tellib_uint16_t LED_Atmosphere_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    LED_STATE = 1;
    return LED_STATE;
}
static void LED_Atmosphere_Execution(Tellib_uint16_t led_status)
{
    if (led_status == 1)
    {
        RTE_GPIO_Set_Level(AMBIENT_LIGHT_B, LED_LINEOUT_High);        
    }
    else
    {
        RTE_GPIO_Set_Level(AMBIENT_LIGHT_B, LED_LINEOUT_Low);        
    }
}

void Turn_Left_Right_Lamp(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if (Common_GetIgnOnTime() >= 3000)
        {
            if (Line_In_Get_Status(LINE_IN_TurnLeft))
            {
                RTE_GPIO_Set_Level(LeftTurn_MUC_OUT, LED_LINEOUT_High);
            }
            else
            {
                RTE_GPIO_Set_Level(LeftTurn_MUC_OUT, LED_LINEOUT_Low);
            }
            if (Line_In_Get_Status(LINE_IN_TurnRight))
            {
                RTE_GPIO_Set_Level(RightTurn_MUC_OUT, LED_LINEOUT_High);
            }
            else
            {
                RTE_GPIO_Set_Level(RightTurn_MUC_OUT, LED_LINEOUT_Low);
            }
        }
        else
        {
            RTE_GPIO_Set_Level(RightTurn_MUC_OUT, LED_LINEOUT_High);
            RTE_GPIO_Set_Level(LeftTurn_MUC_OUT, LED_LINEOUT_High);
        }
    }
    else
    {
        RTE_GPIO_Set_Level(RightTurn_MUC_OUT, LED_LINEOUT_Low);
        RTE_GPIO_Set_Level(LeftTurn_MUC_OUT, LED_LINEOUT_Low);
    }
} 
