#include "Service_Interval.h"
#include "Service_Interval_User.h"


uint8_t __attribute__((aligned(4))) DataMaintainBuf [ Data_MEM_Block_Maintain ];

static void Service_Interval_Write_EEProm(uint32_t u32Data [], uint16_t u16Len);
static void Service_Interval_Read_EEProm(uint32_t u32Data [], uint16_t u16Len);

void Service_Interval_User_KL30Init(void)
{
    Maintain_Init_t InitData;
    Maintain_Func_t Func;

    InitData.IntervalDayEnable = 0;
    //默认值
    InitData.IntervalDay = 90;
    InitData.IntervalKm  = 500;
    //回调函数
    Func.PowerSts_Cbk    = Common_Get_IG_Sts;
    Func.ReadODO_Cbk     = Data_ODO_Read;
    Func.EEPromWrite_Cbk = Service_Interval_Write_EEProm;
    Func.EEPromRead_Cbk  = Service_Interval_Read_EEProm;

    Service_Interval_KL30_Init(DataMaintainBuf, &InitData, &Func);
}

void Service_Interval_User_WakeupInit(void)
{
    Maintain_Func_t Func;

    //回调函数
    Func.PowerSts_Cbk    = Common_Get_IG_Sts;
    Func.ReadODO_Cbk     = Data_ODO_Read;
    Func.EEPromWrite_Cbk = Service_Interval_Write_EEProm;
    Func.EEPromRead_Cbk  = Service_Interval_Read_EEProm;

    Service_Interval_Wakeup_Init(DataMaintainBuf, &Func);
}

void Service_Interval_First_Reset(void)
{
    Service_Interval_SetKm(500);    // 500km
}

void Service_Interval_Second_Reset(void)
{
    Service_Interval_SetKm(1000);    // 1000km
}

static void Service_Interval_Write_EEProm(uint32_t u32Data [], uint16_t u16Len)
{
    ee_uint16_t tmpWritestatus = 0;
    ee_uint16_t Cnt = 0;
    tmpWritestatus = eeprom_WriteRecord(EEPROM_BLOCK_05, (uint8_t *)u32Data, u16Len * 4);
    while(tmpWritestatus == WRITING)
    {
        tmpWritestatus = eeprom_WriteRecord(EEPROM_BLOCK_05, (uint8_t *)u32Data, u16Len * 4);
        Cnt++;
        if(Cnt >= 1000)
        {
            break;
        }
    }
}

static void Service_Interval_Read_EEProm(uint32_t u32Data [], uint16_t u16Len)
{
    ee_uint16_t tmpReadstatus = 0;
    ee_uint16_t Cnt = 0;
    tmpReadstatus = eeprom_ReadRecord(EEPROM_BLOCK_05, (uint8_t *)u32Data, u16Len * 4);
    while(tmpReadstatus == READING)
    {
        tmpReadstatus = eeprom_ReadRecord(EEPROM_BLOCK_05, (uint8_t *)u32Data, u16Len * 4);
        Cnt++;
        if(Cnt >= 1000)
        {
            break;
        }
    }
}

uint32_t g_ServiceMil100m = 0;
uint8_t Get_SERVICE_WARNING_ForCan(void)
{
    uint8_t  Res;
    uint32_t m_Condition_1;

    m_Condition_1 = Service_Interval_GetMil100m();
    g_ServiceMil100m = Service_Interval_GetMil100m();
    if (m_Condition_1 <= 0u)
    {
        Res = 1u; /*87606-4*/
    }
    else
    {
        Res = 0u; /*87606-5*/
    }
    
    return Res;
}


