#include  "CAN_CH0_CAN_Communication_Matrix.h"
#include "Components.h"
#include "Application.h"
/* 2024/04/26 10:01:26 */
st_CanMsgOp CAN_CH0_CanMsgOp;
st_CanMsgTxOp CAN_CH0_CanMsgTxOp;
#define CAN_CH0 &CAN_CH0_CanMsgOp

const st_CAN_SendAttribute    CAN_CH0_CANSendAttr[CAN_CH0_ID_SEND_TOTAL] =
{
    {0x220ul, 50ul * 1000ul,  7ul * 1000ul,    0u,  MSG_STD, 1u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_220, (void *)0},
    {0x6EEul, 100ul * 1000ul,  7ul * 1000ul,    0u,  MSG_STD, 1u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_6EE, (void *)0},
    {0x6EFul, 100ul * 1000ul,  7ul * 1000ul,    0u,  MSG_STD, 1u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_6EF, (void *)0},
    {0x450ul, 100ul * 1000ul,  7ul * 1000ul,    0u,  MSG_STD, 1u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_450, (void *)0},
#if (IC_Current == TY200_080000b_ty)
    {0x580ul, 10ul * 1000ul,  7ul * 1000ul,    0u,  MSG_STD, 1u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_580, (void *)0},
#endif
};

const st_CANMsgAttribute CAN_CH0_CAN_MSG_CONST_ARRAY[CAN_CH0_ID_TOTAL_MAX] =
{
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x402ul,
        (( void * )0),
        (Fault_Code_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x341ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x111ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x401ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },    
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x120ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        2000ul,
        0x101ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        2000ul,
        0x373ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
};

uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_Warning_Lamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x402_Msg_Count, 7u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCL2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x402_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCM2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x402_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCH2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x402_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCAmnt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x402_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCL1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x402_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCM1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x402_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCH1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x402_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_341_Sig_software_version(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x341_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_341_Sig_Rear_LearningStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x341_Msg_Count, 5u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_341_Sig_Front_LearningStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x341_Msg_Count, 4u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_341_Sig_Rear_Pressure_Warning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x341_Msg_Count, 4u) >> 3u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_341_Sig_Front_Pressure_Warning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x341_Msg_Count, 4u) >> 0u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_341_Sig_Rear_TireTemperature(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x341_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_341_Sig_Front_TireTemperature(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x341_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_341_Sig_Rear_Pressure(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x341_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_341_Sig_Front_Pressure(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x341_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_SideStand_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x111_Msg_Count, 5u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_SideStand(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x111_Msg_Count, 4u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Engine_InjIgn_Cutoff_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x111_Msg_Count, 2u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Engine_InjIgn_Cutoff(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x111_Msg_Count, 0u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Engine_Autostop_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x111_Msg_Count, 3u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Engine_Autostop(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x111_Msg_Count, 1u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_111_Livecounter(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x111_Msg_Count, 6u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_111_Checksum(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x111_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_401_Sig_ECU_401_Checksum(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x401_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_401_Sig_ECU_401_Livecounter(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x401_Msg_Count, 6u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_401_Sig_ECU_Gear_State(void)
{
    return (((uint8_t)((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x401_Msg_Count, 5u) >> 0u) & 0x0Fu) << 4u) + \
    ((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x401_Msg_Count, 6u) >> 4u) & 0x0Fu));
}

uint16_t Get_CAN_CH0_ID_401_Sig_ECU_Fuel_Consumption(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x401_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x401_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_401_Sig_ECU_Battery_Voltage(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x401_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_401_Sig_ECU_Environment_Presure(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x401_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x401_Msg_Count, 1u) >> 0u) & 0xFFu));
}

// uint8_t  Get_CAN_CH0_ID_220_Sig_CheckSum(void)
// {
//     return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x220_Msg_Count, 7u) >> 0u) & 0x1Fu));
// }

// uint8_t  Get_CAN_CH0_ID_220_Sig_AliveCounter(void)
// {
//     return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x220_Msg_Count, 7u) >> 5u) & 0x07u));
// }

// uint8_t  Get_CAN_CH0_ID_220_Sig_TCS_Switch(void)
// {
//     return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x220_Msg_Count, 0u) >> 3u) & 0x01u));
// }

uint8_t  Get_CAN_CH0_ID_120_Sig_TCSStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x120_Msg_Count, 0u) >> 4u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_120_Sig_RearWheelSpeedValidity(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x120_Msg_Count, 6u) >> 1u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_120_Sig_RearWheelSpeed(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x120_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x120_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_120_Sig_Rear_ABS_control_status(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x120_Msg_Count, 6u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_120_Sig_FrontWheelSpeedValidity(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x120_Msg_Count, 6u) >> 0u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_120_Sig_FrontWheelSpeed(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x120_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x120_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_120_Sig_Front_ABS_control_status(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x120_Msg_Count, 6u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_120_Sig_CheckSum(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x120_Msg_Count, 7u) >> 0u) & 0x1Fu));
}

uint8_t  Get_CAN_CH0_ID_120_Sig_AliveCounter(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x120_Msg_Count, 7u) >> 5u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_120_Sig_ABS_Warning_lamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x120_Msg_Count, 6u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Vehicle_Speed_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x101_Msg_Count, 6u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Vehicle_Speed(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x101_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Throttle_Position_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x101_Msg_Count, 6u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Throttle_Position(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x101_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Engine_Temperature_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x101_Msg_Count, 6u) >> 7u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_101_Sig_ECU_Engine_Temperature(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x101_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x101_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Engine_Speed_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x101_Msg_Count, 6u) >> 4u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_101_Sig_ECU_Engine_Speed(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x101_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x101_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_101_Livecounter(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x101_Msg_Count, 6u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_101_Checksum(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x101_Msg_Count, 7u) >> 0u) & 0xFFu));
}
uint32_t Get_CAN_CH0_ID_373_Sig_Front_id(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x373_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x373_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x373_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x373_Msg_Count, 3u) >> 0u) & 0xFFu));
}
uint32_t Get_CAN_CH0_ID_373_Sig_Rear_id(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x373_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x373_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x373_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x373_Msg_Count, 7u) >> 0u) & 0xFFu));
}
uint8_t  Co_Can_ConvertSubID_CAN_CH0(uint32_t MsgID)
{
    uint8_t u8Result = CAN_CH0_ID_TOTAL_MAX;
    switch (MsgID)
    {
    case CAN_CH0_ID_CAN_0x402_Msg:
        u8Result = CAN_CH0_ID_CAN_0x402_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x341_Msg:
        u8Result = CAN_CH0_ID_CAN_0x341_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x111_Msg:
        u8Result = CAN_CH0_ID_CAN_0x111_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x401_Msg:
        u8Result = CAN_CH0_ID_CAN_0x401_Msg_Count;
        break;    
    case CAN_CH0_ID_CAN_0x120_Msg:
        u8Result = CAN_CH0_ID_CAN_0x120_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x101_Msg:
        u8Result = CAN_CH0_ID_CAN_0x101_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x373_Msg:
        u8Result = CAN_CH0_ID_CAN_0x373_Msg_Count;
        break;
    default :
        u8Result = CAN_CH0_ID_TOTAL_MAX;
        break;
    }
    return u8Result;
}

