#ifndef _GPIOUSER_H_
#define _GPIOUSER_H_

/* GPIO映射 */
#define VSPEED_PWM_IN           RTE_GPIO_PORT00_PIN00   
#define WAKEUP_KL15_In          RTE_GPIO_PORT00_PIN01   
#define SEG1_SD                 RTE_GPIO_PORT00_PIN02   
#define SEG1_CSB                RTE_GPIO_PORT00_PIN03   
#define SEG1_SCL                RTE_GPIO_PORT00_PIN04   
#define HighBeam_P_In           RTE_GPIO_PORT00_PIN05   
#define VSPEED_TEN_OUT          RTE_GPIO_PORT00_PIN06   

#define BACKLIGHT_PWM           RTE_GPIO_PORT01_PIN00   
#define LIN_RXD_ESP             RTE_GPIO_PORT01_PIN01   
#define LIN_TXD_ESP             RTE_GPIO_PORT01_PIN02   
#define EFI_FAULT_OUT           RTE_GPIO_PORT01_PIN03   
#define AMBIENT_LIGHT_R         RTE_GPIO_PORT01_PIN04   
#define RESEVER1_OUT_LOW        RTE_GPIO_PORT01_PIN05   
#define AMBIENT_LIGHT_B         RTE_GPIO_PORT01_PIN06   
#define AMBIENT_LIGHT_G         RTE_GPIO_PORT01_PIN07   

#define AVDD_OUT_LOW            RTE_GPIO_PORT02_PIN00   
#define GND_OUT_LOW             RTE_GPIO_PORT02_PIN01   
#define POWER_KL30_In           RTE_GPIO_PORT02_PIN02   
#define POWER_KL15_In           RTE_GPIO_PORT02_PIN03   
#define RESEVER2_OUT_LOW        RTE_GPIO_PORT02_PIN04   
#define FUEL_MCU_IN             RTE_GPIO_PORT02_PIN05   
#define VERSION_T_OUT_LOW       RTE_GPIO_PORT02_PIN06   
#define FUEL_POWER_IN           RTE_GPIO_PORT02_PIN07   

#define MAINTENANCE_LAMP_OUT    RTE_GPIO_PORT03_PIN00   
#define RESEVER3_OUT_LOW        RTE_GPIO_PORT03_PIN01   

#define SWDIO                   RTE_GPIO_PORT04_PIN00   
#define RESEVER4_OUT_LOW        RTE_GPIO_PORT04_PIN01   
#define LeftTurn_P_In           RTE_GPIO_PORT04_PIN02   
#define RightTurn_P_In          RTE_GPIO_PORT04_PIN03   

#define CAN_MCU_RXD             RTE_GPIO_PORT05_PIN00   
#define CAN_MCU_TXD             RTE_GPIO_PORT05_PIN01   
#define CAN_STB_MCU             RTE_GPIO_PORT05_PIN02   
#define MODE_P_IN               RTE_GPIO_PORT05_PIN03   
#define SET_P_IN                RTE_GPIO_PORT05_PIN04   
#define START_STOP_P_IN         RTE_GPIO_PORT05_PIN05   

#define IIC_SCL_24G16           RTE_GPIO_PORT06_PIN00   
#define IIC_SDA_24G16           RTE_GPIO_PORT06_PIN01   
#define IIC_SCL_27030           RTE_GPIO_PORT06_PIN02   
#define IIC_SDA_27030           RTE_GPIO_PORT06_PIN03   

#define SEG2_SCL                RTE_GPIO_PORT07_PIN00   
#define SEG2_CSB                RTE_GPIO_PORT07_PIN01   
#define SEG2_SD                 RTE_GPIO_PORT07_PIN02   
#define SDB_LED_DRIVER          RTE_GPIO_PORT07_PIN03   
#define HighBeam_MUC_OUT        RTE_GPIO_PORT07_PIN04   
#define TPMS_MUC_OUT            RTE_GPIO_PORT07_PIN05   
#define RightTurn_MUC_OUT       RTE_GPIO_PORT07_PIN06   
#define LeftTurn_MUC_OUT        RTE_GPIO_PORT07_PIN07   

#define POWER_5V_MCU            RTE_GPIO_PORT12_PIN00 
#define MCU_XI                  RTE_GPIO_PORT12_PIN01 
#define MCU_XO                  RTE_GPIO_PORT12_PIN02 
#define X32768_IN               RTE_GPIO_PORT12_PIN03 
#define X32768_OUT              RTE_GPIO_PORT12_PIN04 

#define VSPEED_HUNDREDS_OUT     RTE_GPIO_PORT13_PIN00 
#define RESEVER5_OUT_LOW        RTE_GPIO_PORT13_PIN06 
#define SWCLK                   RTE_GPIO_PORT13_PIN07 

#define L_BD433Ctrl_OUT         RTE_GPIO_PORT14_PIN00 
#define FUEL_POWER_MCU_OUT      RTE_GPIO_PORT14_PIN01 
#define VERSION_F_OUT_LOW       RTE_GPIO_PORT14_PIN06 
#define VERSION_S_OUT_LOW       RTE_GPIO_PORT14_PIN07 

typedef enum
{
    Gpio_KL30_Init = 0,
    Gpio_WakeUp_Init,
    Gpio_Sleep_Init,
    Gpio_Uvalid,
}_GpioUser_Enum;

extern void Gpio_Init(_GpioUser_Enum InitMode);

#endif
