#ifndef SIMULATED_IIC_MASTER_H__
#define SIMULATED_IIC_MASTER_H__

#include "stdint.h"

typedef struct stRTESIICMasterHandler
{
    uint16_t u16SCLPinNum;
    uint16_t u16SDAPinNum;
    uint32_t u32SpeedTrim;
    uint8_t  u8Busy;
    uint8_t  u8ReceivedACK;
    uint16_t u16Rsvd;
}SIIC_M_Handler_st_t;

typedef enum
{
    SIIC_M_PASS = 0U,
    SIIC_M_FAIL,
}SIIC_M_Result_en_t;

typedef enum
{
    SIIC_M_IDLE = 0U,    /**< IIC master is idle  */
    SIIC_M_BUSY,         /**< IIC master is busy  */
    SIIC_M_INVALID,      /**< The handle of IIC master is illegal */
}SIIC_M_Status_en_t;

typedef enum
{
    SIIC_M_GPIO_IN_HiZ = 0U,
    SIIC_M_GPIO_OUT_LOW,
}SIIC_M_GPIO_Mode_en_t;

#if defined(TARGET_N32A455VE_100PIN)
    #define SIIC_M_DEFAULT_SPEED_TRIM       (40UL)
#else
    #define SIIC_M_DEFAULT_SPEED_TRIM       (100UL)
#endif

#define   SIIC_M_ACK                        (0U)
#define   SIIC_M_NAK                        (1U)
#define   SIIC_M_ACK_INVALID                (2U)

#define   SIIC_M_WR                         (0x00U)
#define   SIIC_M_RD                         (0x01U)

extern SIIC_M_Result_en_t SIIC_Master_Init(SIIC_M_Handler_st_t *pHandler, uint16_t u16SCLPin, uint16_t u16SDAPin, uint32_t u32SpeedTrim);
extern SIIC_M_Result_en_t SIIC_Master_DeInit(SIIC_M_Handler_st_t *pHandler);
extern SIIC_M_Status_en_t SIIC_Master_Get_Status(SIIC_M_Handler_st_t *pHandler);

extern SIIC_M_Result_en_t SIIC_Master_Start(SIIC_M_Handler_st_t *pHandler);
extern SIIC_M_Result_en_t SIIC_Master_Stop(SIIC_M_Handler_st_t *pHandler);
extern SIIC_M_Result_en_t SIIC_Master_Write_Data(SIIC_M_Handler_st_t *pHandler, uint8_t u8Data);
extern SIIC_M_Result_en_t SIIC_Master_Read_Data(SIIC_M_Handler_st_t *pHandler, uint8_t *pu8Data);
extern SIIC_M_Result_en_t SIIC_Master_Write_ACK(SIIC_M_Handler_st_t *pHandler, uint8_t u8ACK);
extern SIIC_M_Result_en_t SIIC_Master_Read_ACK(SIIC_M_Handler_st_t *pHandler, uint8_t *pu8ACK);

/* The following functions are used for simulated IIC master library porting, 
 * DO NOT call them !!! */
extern int32_t SIIC_Master_Set_GPIO(uint16_t u16GPIOPin, SIIC_M_GPIO_Mode_en_t enMode);
extern uint8_t SIIC_Master_Get_GPIO(uint16_t u16GPIOPin);

#endif /* SIMULATED_IIC_MASTER_H__ */
