#include "Data_Fuel.h"
#include "Application.h"

#define FUEL_DATA_TIME 25u /*这里填写多长时间采集一个数据，单位ms*/
#define FUEL_DATA_NUM 20u  /*燃油电阻采集数据总数 最大255*/
#define FUEL_CAL_START 5u  /*数据排序后取中间部分计算平均：起始*/
#define FUEL_CAL_END 15u   /*数据排序后取中间部分计算平均：结束*/

#define RETURN_DIFFERENCE 25u /*判断上升或下降的回差，精度0.1*/

#define FUEL_SEG_UP 0u
#define FUEL_SEG_DOWN 1u

uint16_t FuelData[FUEL_DATA_NUM];
uint8_t FuelDataCount = 0u;

uint16_t FuelR = 0u; /*滤波后的燃油电阻，精度0.1*/
static uint16_t FuelRBak = 0;

uint8_t DesFuelSetp = 0u;
uint8_t CurFuelSetp = 0u;
uint8_t FuelInitFlag = 0u;
uint8_t FuelStateInitFlag = 0u;
uint8_t FuelDir = FUEL_SEG_UP;
FuelSensorSts_t FuelSensorState = FuelSensorNormal;
uint16_t FuelSensorNormalTime = 0u;
uint16_t FuelSensorShortTime = 0u;
uint16_t FuelSensorOpenTime = 0u;
uint8_t FuelADCompleteFlg = 0u;

void Fuel_KL30_Init(void)
{
    DesFuelSetp = 0u;
    CurFuelSetp = 0u;
    FuelInitFlag = 1u;
    FuelStateInitFlag = 1u;
    FuelDir = FUEL_SEG_UP;
    FuelSensorState = FuelSensorNormal;
    FuelSensorNormalTime = 0u;
    FuelSensorShortTime = 0u;
    FuelSensorOpenTime = 0u;
    FuelADCompleteFlg = 0u;
    // PORT_ClrBit(Fuel_Vcc_en);
}

void Fuel_KL15_Init(void)
{
    // PORT_SetBit(Fuel_Vcc_en);
    DesFuelSetp = 0u;
    CurFuelSetp = 0u;
    FuelInitFlag = 1u;
    FuelStateInitFlag = 1u;
    FuelDir = FUEL_SEG_UP;
    FuelSensorState = FuelSensorNormal;
    FuelSensorNormalTime = 0u;
    FuelSensorShortTime = 0u;
    FuelSensorOpenTime = 0u;
    FuelADCompleteFlg = 0u;
}

uint16_t TestFuelR = 1100u;
void Fuel_R_Cal(uint8_t deltaTime)
{
    uint16_t FuelRes = 0;
    uint8_t i, j;
    uint32_t temp32;
    static uint16_t timeCount = 0;


    if(FuelStateInitFlag)
    {
        FuelR = ADC_Read_Signal(ADC_CH_FUEL1);
    }

    if (timeCount >= FUEL_DATA_TIME)
    {
        timeCount = 0;
        if (FuelDataCount < FUEL_DATA_NUM)
        {
            /*获取燃油电阻*/
            FuelRes = ADC_Read_Signal(ADC_CH_FUEL1);; // ADC_Read_Signal(ADC_CH_FUEL1);

            /*四舍五入*/
            //if (FuelRes < 32000)
            //{
                if (FuelRes % 10 >= 5)
                {
                    FuelRes += 5;
                }
            //}
            //else
            //{
            //    FuelRes = 32000;
            //}
            /*由小到大插入数据*/
            for (i = 0; i < FuelDataCount; i++)
            {
                if (FuelRes < FuelData[i])
                {
                    break;
                }
            }
            for (j = FuelDataCount; j > i; j--)
            {
                FuelData[j] = FuelData[j - 1];
            }
            FuelData[i] = FuelRes;
            FuelDataCount++;
        }
        else
        {
            /*一组数据采集完毕，取中间部分计算平均值*/
            temp32 = 0;
            for (i = FUEL_CAL_START; i < FUEL_CAL_END; i++)
            {
                temp32 += FuelData[i];
            }
            FuelR = temp32 / (FUEL_CAL_END - FUEL_CAL_START);
            FuelDataCount = 0;
            FuelADCompleteFlg = 1;
        }
    }
    timeCount += deltaTime;
}

void Fuel_State_Check(uint8_t deltaTime)
{

    // if (FuelR < 20)
    //{ /*短路 1*/
    //     FuelSensorOpenTime = 0;
    //     FuelSensorNormalTime = 0;
    //     if ((FuelSensorShortTime > 3000) || ((FuelStateInitFlag) && (FuelSensorShortTime > 3000)))
    //     {
    //         FuelSensorState = FuelSensorShortCircuit;
    //         DesFuelSetp = 0;
    //         CurFuelSetp = 0;
    //         FuelStateInitFlag = 0;
    //         FuelInitFlag = 1;
    //         FuelDir = FUEL_SEG_UP;
    //     }
    //     else
    //     {
    //         FuelSensorShortTime += deltaTime;
    //     }
    // }
    // else

    if (FuelR >= 1100)
    { /*断路 320*/
        FuelSensorShortTime = 0;
        FuelSensorNormalTime = 0;
        if ((FuelSensorOpenTime > 2800) || ((FuelStateInitFlag) && (FuelSensorOpenTime > 2800)))
        {
            FuelSensorState = FuelSensorOpenCircuit;
            DesFuelSetp = 0;
            CurFuelSetp = 5;
            FuelStateInitFlag = 0;
            FuelInitFlag = 1;
            FuelDir = FUEL_SEG_UP;
        }
        else
        {

            FuelSensorOpenTime += deltaTime;
        }
    }
    else
    {
        FuelSensorShortTime = 0;
        FuelSensorOpenTime = 0;
        if (FuelSensorNormalTime > 3000)
        {
            FuelSensorState = FuelSensorNormal;
            FuelStateInitFlag = 0;
        }
        else
        {
            FuelSensorNormalTime += deltaTime;
        }
    }
}

void Fuel_Gauges_Cal(uint8_t deltaTime)
{

    static uint16_t time = 0;
    if ((FuelSensorState == FuelSensorNormal) && (FuelR < 1100))
    { // 32000  //FuelR >10 change FuelR >20
        /*采集完第一组数据后，开始计算燃油格数*/
        if (FuelADCompleteFlg)
        {

            if (FuelInitFlag)
            {
                FuelRBak = FuelR;
            }

            /*根据回差计算走动方向*/
            if (FuelDir == FUEL_SEG_UP)
            {

                if (FuelR >= FuelRBak + RETURN_DIFFERENCE)
                {
                    FuelDir = FUEL_SEG_DOWN;
                    FuelRBak = FuelR;
                }
                if (FuelR < FuelRBak)
                {
                    FuelRBak = FuelR;
                }
            }
            else
            {
                if (FuelRBak >= FuelR + RETURN_DIFFERENCE)
                {
                    FuelDir = FUEL_SEG_UP;
                    FuelRBak = FuelR;
                }
                if (FuelR > FuelRBak)
                {
                    FuelRBak = FuelR;
                }
            }

            /*计算目标格数*/
            if (FuelDir == FUEL_SEG_UP)
            {
                if (((DesFuelSetp == 4) || FuelInitFlag) && (FuelR < 240))
                {
                    DesFuelSetp = 5;
                }
                else if (((DesFuelSetp == 3) || FuelInitFlag) && (FuelR < 430))
                {
                    DesFuelSetp = 4;
                }
                else if (((DesFuelSetp == 2) || FuelInitFlag) && (FuelR < 610))
                {
                    DesFuelSetp = 3;
                }
                else if (((DesFuelSetp == 1) || FuelInitFlag) && (FuelR < 790))
                {
                    DesFuelSetp = 2;
                }
                else if (((DesFuelSetp == 0) || FuelInitFlag) && (FuelR < 970))
                {
                    DesFuelSetp = 1;
                }
            }
            else if (FuelDir == FUEL_SEG_DOWN)
            {
                if (((DesFuelSetp == 1) || FuelInitFlag) && (FuelR >= 970))
                {
                    DesFuelSetp = 0;
                }
                else if (((DesFuelSetp == 2) || FuelInitFlag) && (FuelR >= 790))
                {
                    DesFuelSetp = 1;
                }
                else if (((DesFuelSetp == 3) || FuelInitFlag) && (FuelR >= 610))
                {
                    DesFuelSetp = 2;
                }
                else if (((DesFuelSetp == 4) || FuelInitFlag) && (FuelR >= 430))
                {
                    DesFuelSetp = 3;
                }
                else if (((DesFuelSetp == 5) || FuelInitFlag) && (FuelR >= 240))
                {
                    DesFuelSetp = 4;
                }
            }
        }

        /*IGN ON 1秒/故障恢复后，开始走格  立即指向当前格 20220704*/
        if (Common_GetIgnOnTime() >= 3000)
        {
            time += deltaTime;
            if (FuelInitFlag)
            {
                FuelInitFlag = 0;
                time = 0;
                CurFuelSetp = DesFuelSetp;
            }
            if (time >= 10000)
            { /* 10S变化一格 */

                time = 0;

                if (CurFuelSetp < DesFuelSetp)
                {

                    CurFuelSetp++;
                }
                else if (CurFuelSetp > DesFuelSetp)
                {

                    CurFuelSetp--;
                }
            }
            if (CurFuelSetp == DesFuelSetp)
            {
                time = 0;
            }
        }
    }
}

uint8_t Get_Fuel_Disp_Byte(void)
{
    uint8_t FuelDispByte = 0u;
    FuelDispByte = CurFuelSetp;
    // if (FuelSensorState == FuelSensorShortCircuit)
    //{
    //     //Short
    //     FuelDispByte = FLASH_SYNC_1Hz ? 7 : 0;
    // }
    // else if (FuelSensorState == FuelSensorOpenCircuit)
    //{
    //     //Open
    //     FuelDispByte = FLASH_SYNC_1Hz ? 6 : 0;
    // }

    // else if (CurFuelSetp == 1)
    //{
    //     FuelDispByte = FLASH_SYNC_1Hz ? 1 : 0;
    // }
    //
    // else if(CurFuelSetp == 0)
    //{
    //	FuelDispByte = 0;
    // }

    return FuelDispByte;
}





void Fuel_Cal_Sevice(uint8_t deltaTime)
{



    /*检测燃油电阻状态*/
    Fuel_State_Check(deltaTime);

    /*显示燃油格*/
    Fuel_Gauges_Cal(deltaTime);
}

uint8_t Get_CurFuelSetp(void)
{
    return CurFuelSetp;
}

FuelSensorSts_t Get_Fuel_Sensor_State(void)
{
    return FuelSensorState;
}
