#include "SEG_DISPLAY\SEG_DISPLAY.h"
#include "GPIO_USER\GpioUser.h"
#include "Application.h"

#define Clr_Bit(p, b) (p) &= (~(1u << (b)))
#define Set_Bit(p, b) (p) |= (1u << (b))
#define Bit_Is_Set(p, b) ((p) & (1u << (b)))
#define Bit_Is_Clr(p, b) (!((p) & (1u << (b))))

uint8_t  DTC_DISCount = 0;
uint32_t Current_DTC_CODE = 0;
uint8_t  DTC_DISTimer = 0;
/*数字显示数组*/                           /*0,     1     2    3      4        5     6      7      8     9       null   -    P     A     b     C    d      E     F*/
const uint8_t SEG_DISPLAY_NUMBER0[]   = {0x3Fu, 0x06u, 0x5Bu, 0x4Fu, 0x66u, 0x6Du, 0x7Du, 0x07u, 0x7Fu, 0x6Fu, 0x00, 0x40, 0x73, 0x77, 0x7C, 0x39, 0x5E, 0x79, 0x71};
const uint8_t SEG_UNDISPLAY_NUMBER0[] = {0x00u, 0x06u, 0x5Bu, 0x4Fu, 0x66u, 0x6Du, 0x7Du, 0x07u, 0x7Fu, 0x6Fu};

void SEG_SET_DTC_NUM(uint32_t num)
{
    uint32_t Num = 0;
    uint8_t  m8 = 0;
    Num = (num  & 0xFF000000) >> 24;              
    m8 = SEG_DISPLAY_NUMBER0[Num];
    
    if (Bit_Is_Set(m8, 0))
    {
        IC1_SEG064 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG064 = IC_SEG_OFF;
    }
    if (Bit_Is_Set(m8, 1))
    {
        IC1_SEG063 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG063 = IC_SEG_OFF;
    }
    if (Bit_Is_Set(m8, 2))
    {
        IC1_SEG061 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG061 = IC_SEG_OFF;
    }
    if (Bit_Is_Set(m8, 3))
    {
        IC1_SEG067 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG067 = IC_SEG_OFF;
    }
    if (Bit_Is_Set(m8, 4))
    {
        IC1_SEG066 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG066 = IC_SEG_OFF;
    }
    if (Bit_Is_Set(m8, 5))
    {
        IC1_SEG065 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG065 = IC_SEG_OFF;
    }
    if (Bit_Is_Set(m8, 6))
    {
        IC1_SEG062 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG062 = IC_SEG_OFF;
    }
    Num = (num  & 0xFF0000) >> 16;       
    m8 = SEG_DISPLAY_NUMBER0[Num];
    
    if (Bit_Is_Set(m8, 0))
    {
        IC1_SEG057 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG057 = IC_SEG_OFF;
    }
    if (Bit_Is_Set(m8, 1))
    {
        IC1_SEG056 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG056 = IC_SEG_OFF;
    }
    if (Bit_Is_Set(m8, 2))
    {
        IC1_SEG054 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG054 = IC_SEG_OFF;
    }
    if (Bit_Is_Set(m8, 3))
    {
        IC1_SEG060 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG060 = IC_SEG_OFF;
    }
    if (Bit_Is_Set(m8, 4))
    {
        IC1_SEG059 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG059 = IC_SEG_OFF;
    }
    if (Bit_Is_Set(m8, 5))
    {
        IC1_SEG058 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG058 = IC_SEG_OFF;
    }
    if (Bit_Is_Set(m8, 6))
    {
        IC1_SEG055 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG055 = IC_SEG_OFF;
    }
    Num = (num  & 0xFF00) >> 8;     
    m8 = SEG_DISPLAY_NUMBER0[Num];
    
    if (Bit_Is_Set(m8, 0))
    {
        IC1_SEG050 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG050 = IC_SEG_OFF;
    }
    if (Bit_Is_Set(m8, 1))
    {
        IC1_SEG049 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG049 = IC_SEG_OFF;
    }
    if (Bit_Is_Set(m8, 2))
    {
        IC1_SEG047 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG047 = IC_SEG_OFF;
    }
    if (Bit_Is_Set(m8, 3))
    {
        IC1_SEG053 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG053 = IC_SEG_OFF;
    }
    if (Bit_Is_Set(m8, 4))
    {
        IC1_SEG052 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG052 = IC_SEG_OFF;
    }
    if (Bit_Is_Set(m8, 5))
    {
        IC1_SEG051 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG051 = IC_SEG_OFF;
    }
    if (Bit_Is_Set(m8, 6))
    {
        IC1_SEG048 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG048 = IC_SEG_OFF;
    }
    Num = num  & 0xFF;       
    m8 = SEG_DISPLAY_NUMBER0[Num];
    
    if (Bit_Is_Set(m8, 0))
    {
        IC1_SEG042 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG042 = IC_SEG_OFF;
    }
    if (Bit_Is_Set(m8, 1))
    {
        IC1_SEG041 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG041 = IC_SEG_OFF;
    }
    if (Bit_Is_Set(m8, 2))
    {
        IC1_SEG039 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG039 = IC_SEG_OFF;
    }
    if (Bit_Is_Set(m8, 3))
    {
        IC1_SEG038 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG038 = IC_SEG_OFF;
    }
    if (Bit_Is_Set(m8, 4))
    {
        IC1_SEG044 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG044 = IC_SEG_OFF;
    }
    if (Bit_Is_Set(m8, 5))
    {
        IC1_SEG043 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG043 = IC_SEG_OFF;
    }
    if (Bit_Is_Set(m8, 6))
    {
        IC1_SEG040 = IC_SEG_ON;
    }
    else
    {
        IC1_SEG040 = IC_SEG_OFF;
    }
}
/**@brief 指示灯显示函数
 * @param[in]  m_Flag           是否显示     -1 显示 -0 不显示 
 */

void SEG_SET_LED_STS(uint8_t LED_NUM, uint8_t m_Flag)
{    
    uint8_t Flag;
    uint8_t Num;    
    
    if (m_Flag == 0u)
    {
        Flag = IC_SEG_OFF;
    }
    else
    {
        Flag = IC_SEG_ON;
    }

    switch (LED_NUM)
    {
    case em_SEG_High_Beam:
        IC2_SEG052 = Flag;
        break; 
    case em_SEG_FAULT_ELECTROSPRAY:
        IC1_SEG078 = Flag;
        break; 
    case em_SEG_ABS:
        IC1_SEG143 = Flag;
        break; 
    case em_SEG_Oil_Pressure:
        IC2_SEG103 = Flag;
        break; 
    case em_SEG_Bluetooth:
        IC2_SEG129 = Flag;
        break; 
    case em_SEG_TCS:
        IC2_SEG128 = Flag;
        break; 
    case em_SEG_Auto_Start_Stop:
        IC2_SEG092 = Flag;
        break; 
    //case em_SEG_Keys:
    //    IC2_SEG130 = Flag;
    //    break; 
    case em_SEG_Upkeep:
        IC1_SEG077 = Flag;
        break; 
    case em_SEG_Low_Batt_Vol:
        IC1_SEG102 = Flag;
        break; 
    case em_SEG_Lateral_Strut:
        IC1_SEG119 = Flag;
        break; 
    case em_SEG_Tire_Pressure_Alarm:
        IC2_SEG127 = Flag;
        break; 
    case em_SEG_Turn_Left:
        IC2_SEG053 = Flag;
        break; 
    case em_SEG_Turn_Right:
        IC1_SEG142 = Flag;
        break; 
    case em_SEG_Coolant:
        IC1_SEG111 = Flag;
        break; 
    case em_SEG_Fuel:
        IC2_SEG099 = Flag;
        break; 
    default:
        break;
    }
}


/**@brief 燃油表显示函数
 * @param[in]  m_Flag            段与数字是否显示     -1 显示 -0 不显示
 * @param[in]  m_SEG             燃油表盘段数0<=m_SEG<=5
 */
void SEG_SET_FuelDial(uint8_t m_Flag, uint8_t m_SEG)
{        
    if (m_Flag == 1u)
    {
        IC2_SEG107 = IC_SEG_ON;

        IC2_SEG106 = IC_SEG_GREY;
        IC2_SEG105 = IC_SEG_GREY;
        IC2_SEG104 = IC_SEG_GREY;
        IC2_SEG102 = IC_SEG_GREY;
        IC2_SEG101 = IC_SEG_GREY;
        
        if ((Get_Fuel_Sensor_State() == 2) && (ClearODO_Flag != 1))
        {
            if (FLASH_SYNC_1Hz)
            {
                IC2_SEG106 = IC_SEG_ON;
                IC2_SEG105 = IC_SEG_ON;
                IC2_SEG104 = IC_SEG_ON;
                IC2_SEG102 = IC_SEG_ON;
                IC2_SEG101 = IC_SEG_ON;

                IC2_SEG108 = IC_SEG_ON;
                IC2_SEG100 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG106 = IC_SEG_GREY;
                IC2_SEG105 = IC_SEG_GREY;
                IC2_SEG104 = IC_SEG_GREY;
                IC2_SEG102 = IC_SEG_GREY;
                IC2_SEG101 = IC_SEG_GREY;

                IC2_SEG108 = IC_SEG_GREY;
                IC2_SEG100 = IC_SEG_GREY;
            }
        }
        else
        {
            if(Get_CurFuelSetp() == 0)
            {
                if (FLASH_SYNC_1Hz)
                {
                    IC2_SEG108 = IC_SEG_ON;
                    IC2_SEG100 = IC_SEG_ON;
                }
                else
                {
                    IC2_SEG108 = IC_SEG_GREY;
                    IC2_SEG100 = IC_SEG_GREY;
                }
            }
            if ((Get_CurFuelSetp() == 1) && (ClearODO_Flag != 1) && (Common_GetIgnOnTime() >= 3000))
            {
                IC2_SEG108 = IC_SEG_ON;
                IC2_SEG100 = IC_SEG_ON;
                if (FLASH_SYNC_1Hz)
                {
                    IC2_SEG106 = IC_SEG_ON;
                }
                else
                {
                    IC2_SEG106 = IC_SEG_GREY;
                }
            }
            else
            {
                switch (m_SEG)
                {
                case 5u:
                    IC2_SEG101 = IC_SEG_ON;
                case 4u:
                    IC2_SEG102 = IC_SEG_ON;
                case 3u:
                    IC2_SEG104 = IC_SEG_ON;
                case 2u:
                    IC2_SEG105 = IC_SEG_ON;
                case 1u:
                    IC2_SEG106 = IC_SEG_ON;
                case 0u:
                    break;
                default:
                    break;
                }
            }
            
        }
    }
    else
    {
        IC2_SEG108 = IC_SEG_OFF;
        IC2_SEG106 = IC_SEG_OFF;
        IC2_SEG105 = IC_SEG_OFF;
        IC2_SEG104 = IC_SEG_OFF;
        IC2_SEG102 = IC_SEG_OFF;
        IC2_SEG101 = IC_SEG_OFF;
        IC2_SEG107 = IC_SEG_OFF;
        IC2_SEG100 = IC_SEG_OFF;
    }    

}

/**@brief 转速表盘显示函数
 * @param[in]  m_Flag            段与数字是否显示     -1 显示 -0 不显示
 * @param[in]  m_SEG             转速表盘段数0<=m_SEG<=24 
 */
void SEG_SET_EspeedDial(uint8_t m_Flag, uint8_t m_SEG)
{

    if (m_Flag == 1u)
    {
        IC2_SEG072 = IC_SEG_ON;
        IC2_SEG073 = IC_SEG_ON;
        IC2_SEG074 = IC_SEG_ON;
        IC2_SEG075 = IC_SEG_ON;
        IC2_SEG076 = IC_SEG_ON;
        IC2_SEG079 = IC_SEG_ON;
        IC2_SEG080 = IC_SEG_ON;
        IC2_SEG083 = IC_SEG_ON;
        IC2_SEG084 = IC_SEG_ON;
        IC2_SEG086 = IC_SEG_ON;
        IC2_SEG070 = IC_SEG_ON;
        IC2_SEG087 = IC_SEG_ON;
        IC2_SEG067 = IC_SEG_ON;
        IC2_SEG088 = IC_SEG_ON;
        IC2_SEG064 = IC_SEG_ON;
        IC2_SEG089 = IC_SEG_ON;
        IC2_SEG061 = IC_SEG_ON;
        IC2_SEG090 = IC_SEG_ON;
        IC2_SEG058 = IC_SEG_ON;
        IC2_SEG091 = IC_SEG_ON;
        IC2_SEG055 = IC_SEG_ON;
        IC1_SEG136 = IC_SEG_ON;
        IC1_SEG153 = IC_SEG_ON;
        IC1_SEG137 = IC_SEG_ON;
        IC1_SEG150 = IC_SEG_ON;
        IC1_SEG138 = IC_SEG_ON;
        IC1_SEG139 = IC_SEG_ON;
        IC1_SEG141 = IC_SEG_ON;
        IC1_SEG145 = IC_SEG_ON;
        IC1_SEG146 = IC_SEG_ON;
        IC1_SEG147 = IC_SEG_ON;

        IC2_SEG077 = IC_SEG_GREY;
        IC2_SEG078 = IC_SEG_GREY;
        IC2_SEG081 = IC_SEG_GREY;
        IC2_SEG082 = IC_SEG_GREY;
        IC2_SEG085 = IC_SEG_GREY;
        IC2_SEG071 = IC_SEG_GREY;
        IC2_SEG069 = IC_SEG_GREY;
        IC2_SEG068 = IC_SEG_GREY;
        IC2_SEG066 = IC_SEG_GREY;
        IC2_SEG065 = IC_SEG_GREY;
        IC2_SEG063 = IC_SEG_GREY;
        IC2_SEG062 = IC_SEG_GREY;
        IC2_SEG060 = IC_SEG_GREY;
        IC2_SEG059 = IC_SEG_GREY;
        IC2_SEG057 = IC_SEG_GREY;
        IC2_SEG056 = IC_SEG_GREY;
        IC2_SEG054 = IC_SEG_GREY;
        IC1_SEG154 = IC_SEG_GREY;
        IC1_SEG152 = IC_SEG_GREY;
        IC1_SEG151 = IC_SEG_GREY;
        IC1_SEG149 = IC_SEG_GREY;
        IC1_SEG148 = IC_SEG_GREY;
        IC1_SEG140 = IC_SEG_GREY;
        IC1_SEG144 = IC_SEG_GREY;
        switch (m_SEG)
        {
        case 24u:
            IC1_SEG144 = IC_SEG_ON;
        case 23u:
            IC1_SEG140 = IC_SEG_ON;
        case 22u:
            IC1_SEG148 = IC_SEG_ON;
        case 21u:
            IC1_SEG149 = IC_SEG_ON;
        case 20u:
            IC1_SEG151 = IC_SEG_ON;
        case 19u:
            IC1_SEG152 = IC_SEG_ON;
        case 18u:
            IC1_SEG154 = IC_SEG_ON;
        case 17u:
            IC2_SEG054 = IC_SEG_ON;
        case 16u:
            IC2_SEG056 = IC_SEG_ON;
        case 15u:
            IC2_SEG057 = IC_SEG_ON;
        case 14u:
            IC2_SEG059 = IC_SEG_ON;
        case 13u:
            IC2_SEG060 = IC_SEG_ON;
        case 12u:
            IC2_SEG062 = IC_SEG_ON;
        case 11u:
            IC2_SEG063 = IC_SEG_ON;
        case 10u:
            IC2_SEG065 = IC_SEG_ON;
        case 9u:
            IC2_SEG066 = IC_SEG_ON;
        case 8u:
            IC2_SEG068 = IC_SEG_ON;
        case 7u:
            IC2_SEG069 = IC_SEG_ON;
        case 6u:
            IC2_SEG071 = IC_SEG_ON;
        case 5u:
            IC2_SEG085 = IC_SEG_ON;
        case 4u:
            IC2_SEG082 = IC_SEG_ON;
        case 3u:
            IC2_SEG081 = IC_SEG_ON;
        case 2u:
            IC2_SEG078 = IC_SEG_ON;
        case 1u:
            IC2_SEG077 = IC_SEG_ON;
        case 0u:
            break;
        default:
            break;
        }

            
    }
    else
    {
        IC2_SEG072 = IC_SEG_OFF;
        IC2_SEG073 = IC_SEG_OFF;
        IC2_SEG074 = IC_SEG_OFF;
        IC2_SEG075 = IC_SEG_OFF;
        IC2_SEG076 = IC_SEG_OFF;
        IC2_SEG079 = IC_SEG_OFF;
        IC2_SEG080 = IC_SEG_OFF;
        IC2_SEG083 = IC_SEG_OFF;
        IC2_SEG084 = IC_SEG_OFF;
        IC2_SEG086 = IC_SEG_OFF;
        IC2_SEG070 = IC_SEG_OFF;
        IC2_SEG087 = IC_SEG_OFF;
        IC2_SEG067 = IC_SEG_OFF;
        IC2_SEG088 = IC_SEG_OFF;
        IC2_SEG064 = IC_SEG_OFF;
        IC2_SEG089 = IC_SEG_OFF;
        IC2_SEG061 = IC_SEG_OFF;
        IC2_SEG090 = IC_SEG_OFF;
        IC2_SEG058 = IC_SEG_OFF;
        IC2_SEG091 = IC_SEG_OFF;
        IC2_SEG055 = IC_SEG_OFF;
        IC1_SEG136 = IC_SEG_OFF;
        IC1_SEG153 = IC_SEG_OFF;
        IC1_SEG137 = IC_SEG_OFF;
        IC1_SEG150 = IC_SEG_OFF;
        IC1_SEG138 = IC_SEG_OFF;
        IC1_SEG139 = IC_SEG_OFF;
        IC1_SEG141 = IC_SEG_OFF;
        IC1_SEG145 = IC_SEG_OFF;
        IC1_SEG146 = IC_SEG_OFF;
        IC1_SEG147 = IC_SEG_OFF;
        IC2_SEG077 = IC_SEG_OFF;
        IC2_SEG078 = IC_SEG_OFF;
        IC2_SEG081 = IC_SEG_OFF;
        IC2_SEG082 = IC_SEG_OFF;
        IC2_SEG085 = IC_SEG_OFF;
        IC2_SEG071 = IC_SEG_OFF;
        IC2_SEG069 = IC_SEG_OFF;
        IC2_SEG068 = IC_SEG_OFF;
        IC2_SEG066 = IC_SEG_OFF;
        IC2_SEG065 = IC_SEG_OFF;
        IC2_SEG063 = IC_SEG_OFF;
        IC2_SEG062 = IC_SEG_OFF;
        IC2_SEG060 = IC_SEG_OFF;
        IC2_SEG059 = IC_SEG_OFF;
        IC2_SEG057 = IC_SEG_OFF;
        IC2_SEG056 = IC_SEG_OFF;
        IC2_SEG054 = IC_SEG_OFF;
        IC1_SEG154 = IC_SEG_OFF;
        IC1_SEG152 = IC_SEG_OFF;
        IC1_SEG151 = IC_SEG_OFF;
        IC1_SEG149 = IC_SEG_OFF;
        IC1_SEG148 = IC_SEG_OFF;
        IC1_SEG140 = IC_SEG_OFF;
        IC1_SEG144 = IC_SEG_OFF;
    }
  
}
/**@brief 水温表显示函数
 * @param[in]  m_Flag            段与数字是否显示     -1 显示 -0 不显示
 * @param[in]  m_SEG             水温表盘段数0<=m_SEG<=5
 * @param[in]  m_num             水温表盘数字显示  
 * @param[in]  m_flash           水温表CH闪烁标志 显示--
 */
void SEG_SET_CoolantDial(uint8_t m_Flag, uint8_t m_SEG, uint16_t m_Num, uint8_t m_flash)
{ 
    uint16_t Num;  
    uint8_t m8;
    if (m_Flag == 1u)
    {
        if((m_flash == 0) && (ClearODO_Flag != 1) && (Common_GetIgnOnTime() >= 3000))
        {
            if (FLASH_SYNC_1Hz)
            {
                IC1_SEG110 = IC_SEG_ON;
                IC1_SEG103 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG110 = IC_SEG_GREY;
                IC1_SEG103 = IC_SEG_GREY;
            }
        }
        else
        {
            IC1_SEG110 = IC_SEG_ON;
            IC1_SEG103 = IC_SEG_ON;
        }

        IC1_SEG104 = IC_SEG_ON;
        IC1_SEG114 = IC_SEG_ON;

        IC1_SEG109 = IC_SEG_GREY;
        IC1_SEG108 = IC_SEG_GREY;
        IC1_SEG107 = IC_SEG_GREY;
        IC1_SEG106 = IC_SEG_GREY;
        IC1_SEG105 = IC_SEG_GREY;       
        
        switch (m_SEG)
        {
        case 5u:
            IC1_SEG105 = IC_SEG_ON;
        case 4u:
            IC1_SEG106 = IC_SEG_ON;
        case 3u:
            IC1_SEG107 = IC_SEG_ON;
        case 2u:
            IC1_SEG108 = IC_SEG_ON;
        case 1u:
            IC1_SEG109 = IC_SEG_ON;
        case 0u:
            break;
        default:
            break;
        }
        if((m_flash == 0) && (ClearODO_Flag != 1) && (Common_GetIgnOnTime() >= 3000))
        {
            IC1_SEG128 = IC_SEG_OFF;
            IC1_SEG125 = IC_SEG_OFF;
            IC1_SEG124 = IC_SEG_OFF;
            IC1_SEG122 = IC_SEG_OFF;
            IC1_SEG112 = IC_SEG_OFF;
            IC1_SEG127 = IC_SEG_OFF;
            IC1_SEG126 = IC_SEG_OFF;
            IC1_SEG123 = IC_SEG_ON;
            IC1_SEG118 = IC_SEG_OFF;
            IC1_SEG117 = IC_SEG_OFF;
            IC1_SEG115 = IC_SEG_OFF;
            IC1_SEG113 = IC_SEG_OFF;
            IC1_SEG121 = IC_SEG_OFF;
            IC1_SEG120 = IC_SEG_OFF;
            IC1_SEG116 = IC_SEG_ON;
        }
        else
        {
            Num = m_Num / 100u;
            if (Num == 1u)
            {
                IC1_SEG128 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG128 = IC_SEG_OFF;
            }
            Num = (m_Num / 10u) % 10u;
            if (m_Num >= 100u)
            {
                m8 = SEG_DISPLAY_NUMBER0[Num];
            }
            else
            {
                m8 = SEG_UNDISPLAY_NUMBER0[Num];
            }
            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG125 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG125 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG124 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG124 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG122 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG122 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG112 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG112 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG127 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG127 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG126 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG126 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG123 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG123 = IC_SEG_OFF;
            }
            Num = m_Num % 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG118 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG118 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG117 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG117 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG115 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG115 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG113 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG113 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG121 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG121 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG120 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG120 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG116 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG116 = IC_SEG_OFF;
            }
        }
            
       
    }
    else
    {
        IC1_SEG109 = IC_SEG_OFF;
        IC1_SEG108 = IC_SEG_OFF;
        IC1_SEG107 = IC_SEG_OFF;
        IC1_SEG106 = IC_SEG_OFF;
        IC1_SEG105 = IC_SEG_OFF;
        IC1_SEG103 = IC_SEG_OFF;
        IC1_SEG110 = IC_SEG_OFF;
        IC1_SEG104 = IC_SEG_OFF;

        IC1_SEG114 = IC_SEG_OFF;
        IC1_SEG128 = IC_SEG_OFF;
        IC1_SEG125 = IC_SEG_OFF;
        IC1_SEG124 = IC_SEG_OFF;
        IC1_SEG122 = IC_SEG_OFF;
        IC1_SEG112 = IC_SEG_OFF;
        IC1_SEG127 = IC_SEG_OFF;
        IC1_SEG126 = IC_SEG_OFF;
        IC1_SEG123 = IC_SEG_OFF;
        IC1_SEG118 = IC_SEG_OFF;
        IC1_SEG117 = IC_SEG_OFF;
        IC1_SEG115 = IC_SEG_OFF;
        IC1_SEG113 = IC_SEG_OFF;
        IC1_SEG121 = IC_SEG_OFF;
        IC1_SEG120 = IC_SEG_OFF;
        IC1_SEG116 = IC_SEG_OFF;
    }    

}


/**@brief 车速数字显示函数
* @param[in]  m_Flag           车速是否显示     -1 显示  -0 不显示
* @param[in]  m_NUM            车速数值 
* @param[in]  m_Unit           车速单位         -0 Km   -1 mile
*/
void SEG_SET_VSpeed_NUM(uint8_t m_Flag, uint16_t m_NUM, uint8_t m_Unit)
{
    uint16_t Num = 0;
    uint8_t m8;
    
    if (m_Flag == 1)
    {
        if ((ClearODO_Flag != 1) && (Common_GetIgnOnTime() >= 3000))
        {
            if (Get_Current_PageType() == Page_Km_Unit)
            {
                if(FLASH_SYNC_1Hz)
                {
                    IC2_SEG156 = IC_SEG_ON;
                    IC2_SEG159 = IC_SEG_ON;
                    LED_Driver_Channel_Set(LampChannel_0, LampCh0_08_KMH, LED_ON);
                    LED_Driver_Channel_Set(LampChannel_0, LampCh0_09_MPH, LED_ON);
                }
                else
                {
                    IC2_SEG156 = IC_SEG_OFF;
                    IC2_SEG159 = IC_SEG_OFF;
                    LED_Driver_Channel_Set(LampChannel_0, LampCh0_08_KMH, LED_OFF);
                    LED_Driver_Channel_Set(LampChannel_0, LampCh0_09_MPH, LED_OFF);
                }
            }
            else
            {
                if (m_Unit == 0)
                {
                    IC2_SEG156 = IC_SEG_OFF;
                    IC2_SEG159 = IC_SEG_ON;
                    LED_Driver_Channel_Set(LampChannel_0, LampCh0_08_KMH, LED_ON);
                    LED_Driver_Channel_Set(LampChannel_0, LampCh0_09_MPH, LED_OFF);
                }
                else
                {
                    IC2_SEG156 = IC_SEG_ON;
                    IC2_SEG159 = IC_SEG_OFF;
                    LED_Driver_Channel_Set(LampChannel_0, LampCh0_08_KMH, LED_OFF);
                    LED_Driver_Channel_Set(LampChannel_0, LampCh0_09_MPH, LED_ON);
                }
            }
            
        }
        else
        {
            IC2_SEG156 = IC_SEG_ON;
            IC2_SEG159 = IC_SEG_ON;
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_08_KMH, LED_ON);
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_09_MPH, LED_ON);
        }

        Num = m_NUM / 100u;
        if (Num == 1u)
        {
            IC2_SEG093 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG093 = IC_SEG_OFF;
        }
        Num = (m_NUM / 10u) % 10u;
        if (m_NUM >= 100u)
        {
            m8 = SEG_DISPLAY_NUMBER0[Num];
        }
        else
        {
            m8 = SEG_UNDISPLAY_NUMBER0[Num];
        }
        if (Bit_Is_Set(m8, 0))
        {
            IC2_SEG148 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG148 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            IC2_SEG147 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG147 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            IC2_SEG098 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG098 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            IC2_SEG097 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG097 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            IC2_SEG096 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG096 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            IC2_SEG094 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG094 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            IC2_SEG095 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG095 = IC_SEG_OFF;
        }
        Num = m_NUM % 10u;
        m8 = SEG_DISPLAY_NUMBER0[Num];
        if (Bit_Is_Set(m8, 0))
        {
            IC2_SEG155 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG155 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            IC2_SEG154 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG154 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            IC2_SEG153 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG153 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            IC2_SEG152 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG152 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            IC2_SEG151 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG151 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            IC2_SEG149 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG149 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            IC2_SEG150 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG150 = IC_SEG_OFF;
        }
        
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_08_KMH, LED_OFF);
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_09_MPH, LED_OFF);
        IC2_SEG156 = IC_SEG_OFF;
        IC2_SEG159 = IC_SEG_OFF;
        IC2_SEG093 = IC_SEG_OFF;

        IC2_SEG148 = IC_SEG_OFF;
        IC2_SEG147 = IC_SEG_OFF;
        IC2_SEG098 = IC_SEG_OFF;
        IC2_SEG097 = IC_SEG_OFF;
        IC2_SEG096 = IC_SEG_OFF;
        IC2_SEG094 = IC_SEG_OFF;
        IC2_SEG095 = IC_SEG_OFF;

        IC2_SEG155 = IC_SEG_OFF;
        IC2_SEG154 = IC_SEG_OFF;
        IC2_SEG153 = IC_SEG_OFF;
        IC2_SEG152 = IC_SEG_OFF;
        IC2_SEG151 = IC_SEG_OFF;
        IC2_SEG150 = IC_SEG_OFF;
        IC2_SEG149 = IC_SEG_OFF;
    }
}
/**@brief 电压数字显示函数
* @param[in]  m_Flag           电压是否显示     -1 显示  -0 不显示
* @param[in]  m_NUM            电压数值
*/
void SEG_SET_Voltage_NUM(uint8_t m_Flag, uint16_t m_NUM)
{
    uint16_t Num = 0;
    uint8_t m8;
    if(m_Flag)
    {
        IC1_SEG079 = IC_SEG_ON;
        IC1_SEG086 = IC_SEG_ON;        
        
        Num = m_NUM / 100;
        m8 = SEG_UNDISPLAY_NUMBER0[Num];
        
        if (Bit_Is_Set(m8, 0))
        {
            IC1_SEG096 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG096 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            IC1_SEG095 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG095 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            IC1_SEG093 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG093 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            IC1_SEG099 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG099 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            IC1_SEG098 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG098 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            IC1_SEG097 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG097 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            IC1_SEG094 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG094 = IC_SEG_OFF;
        }
        /*十位*/
        Num = (m_NUM / 10u) % 10u;
        if ((m_NUM >= 100u) || (m_NUM == 0))
        {
            m8 = SEG_DISPLAY_NUMBER0[Num];
        }
        else
        {
            m8 = SEG_UNDISPLAY_NUMBER0[Num];
        }
        if (Bit_Is_Set(m8, 0))
        {
            IC1_SEG090 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG090 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            IC1_SEG089 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG089 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            IC1_SEG087 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG087 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            IC1_SEG100 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG100 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            IC1_SEG092 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG092 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            IC1_SEG091 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG091 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            IC1_SEG088 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG088 = IC_SEG_OFF;
        }
        /*个位*/
        Num = m_NUM % 10u;
        m8 = SEG_DISPLAY_NUMBER0[Num];
        if (Bit_Is_Set(m8, 0))
        {
            IC1_SEG083 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG083 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            IC1_SEG082 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG082 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            IC1_SEG080 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG080 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            IC1_SEG101 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG101 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            IC1_SEG085 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG085 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            IC1_SEG084 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG084 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            IC1_SEG081 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG081 = IC_SEG_OFF;
        }
        
    }
}

/**@brief 胎压数字显示函数
* @param[in]  m_Flag           胎压是否显示     -1 显示  -0 不显示
* @param[in]  m_NUM1           前轮胎压数值
* @param[in]  m_NUM2           后轮胎压数值
* @param[in]  m_Unit           胎压单位        -1 Psi   -0 Bar
* @param[in]  m_valid1         前轮有效标志     -0 无效，显示--
* @param[in]  m_valid2         后轮有效标志     -0 无效，显示--
*/
void SEG_SET_TPMS_NUM(uint8_t m_Flag, uint16_t m_NUM1, uint16_t m_NUM2, uint8_t m_Unit, uint8_t m_valid1, uint8_t m_valid2)
{
    uint16_t Num1 = 0;
    uint16_t Num2 = 0;
    uint8_t m8;
    if(m_Flag)
    {        
        IC2_SEG142 = IC_SEG_ON;
        IC2_SEG122 = IC_SEG_ON;
        if ((ClearODO_Flag != 1) && (Common_GetIgnOnTime() >= 3000)) 
        {
            if (Get_Current_PageType() == Page_Tpms_Unit)
            {
                if(FLASH_SYNC_1Hz)
                {
                    IC2_SEG109 = IC_SEG_ON;
                    IC2_SEG110 = IC_SEG_ON;
                }
                else
                {
                    IC2_SEG109 = IC_SEG_OFF;
                    IC2_SEG110 = IC_SEG_OFF;
                }
            }
            else
            {
                if (m_Unit == 0)
                {
                    IC2_SEG109 = IC_SEG_OFF;
                    IC2_SEG110 = IC_SEG_ON;

                    IC2_SEG118 = IC_SEG_ON;
                    IC2_SEG138 = IC_SEG_ON;  
                }
                else
                {
                    IC2_SEG109 = IC_SEG_ON;
                    IC2_SEG110 = IC_SEG_OFF;   

                    IC2_SEG118 = IC_SEG_OFF;
                    IC2_SEG138 = IC_SEG_OFF;             
                }
            }
            
        }
        else
        {
            IC2_SEG109 = IC_SEG_ON;
            IC2_SEG110 = IC_SEG_ON;
            IC2_SEG118 = IC_SEG_ON;
            IC2_SEG138 = IC_SEG_ON; 
        }
        if (m_valid1 == 1)
        {
            Num1 = m_NUM1 / 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num1];
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG143 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG143 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG141 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG141 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG139 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG139 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG146 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG146 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG145 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG145 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG144 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG144 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG140 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG140 = IC_SEG_OFF;
            }

            Num1 = m_NUM1 % 10u;     
            m8 = SEG_DISPLAY_NUMBER0[Num1];   
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG135 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG135 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG134 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG134 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG132 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG132 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG131 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG131 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG137 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG137 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG136 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG136 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG133 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG133 = IC_SEG_OFF;
            }
        }
        else
        {
            IC2_SEG140 = IC_SEG_ON;
            IC2_SEG133 = IC_SEG_ON;

            IC2_SEG143 = IC_SEG_OFF;
            IC2_SEG141 = IC_SEG_OFF;
            IC2_SEG139 = IC_SEG_OFF;
            IC2_SEG146 = IC_SEG_OFF;
            IC2_SEG145 = IC_SEG_OFF;
            IC2_SEG144 = IC_SEG_OFF;

            IC2_SEG135 = IC_SEG_OFF;
            IC2_SEG134 = IC_SEG_OFF;
            IC2_SEG132 = IC_SEG_OFF;
            IC2_SEG131 = IC_SEG_OFF;
            IC2_SEG137 = IC_SEG_OFF;
            IC2_SEG136 = IC_SEG_OFF;
        }
        if (m_valid2 == 1)
        {
            Num2 = m_NUM2 / 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num2];
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG123 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG123 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG121 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG121 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG119 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG119 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG126 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG126 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG125 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG125 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG124 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG124 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG120 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG120 = IC_SEG_OFF;
            }

            Num2 = m_NUM2 % 10u;     
            m8 = SEG_DISPLAY_NUMBER0[Num2];   
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG115 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG115 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG114 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG114 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG112 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG112 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG111 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG111 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG117 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG117 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG116 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG116 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG113 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG113 = IC_SEG_OFF;
            }
        }
        else
        {
            IC2_SEG120 = IC_SEG_ON;
            IC2_SEG113 = IC_SEG_ON;

            IC2_SEG123 = IC_SEG_OFF;
            IC2_SEG121 = IC_SEG_OFF;
            IC2_SEG119 = IC_SEG_OFF;
            IC2_SEG126 = IC_SEG_OFF;
            IC2_SEG125 = IC_SEG_OFF;
            IC2_SEG124 = IC_SEG_OFF;

            IC2_SEG115 = IC_SEG_OFF;
            IC2_SEG114 = IC_SEG_OFF;
            IC2_SEG112 = IC_SEG_OFF;
            IC2_SEG111 = IC_SEG_OFF;
            IC2_SEG117 = IC_SEG_OFF;
            IC2_SEG116 = IC_SEG_OFF;
        }
    }
    else
    {
        IC2_SEG120 = IC_SEG_OFF;
        IC2_SEG113 = IC_SEG_OFF;
        IC2_SEG123 = IC_SEG_OFF;
        IC2_SEG121 = IC_SEG_OFF;
        IC2_SEG119 = IC_SEG_OFF;
        IC2_SEG126 = IC_SEG_OFF;
        IC2_SEG125 = IC_SEG_OFF;
        IC2_SEG124 = IC_SEG_OFF;
        IC2_SEG115 = IC_SEG_OFF;
        IC2_SEG114 = IC_SEG_OFF;
        IC2_SEG112 = IC_SEG_OFF;
        IC2_SEG111 = IC_SEG_OFF;
        IC2_SEG117 = IC_SEG_OFF;
        IC2_SEG116 = IC_SEG_OFF;
        IC2_SEG140 = IC_SEG_OFF;
        IC2_SEG133 = IC_SEG_OFF;
        IC2_SEG143 = IC_SEG_OFF;
        IC2_SEG141 = IC_SEG_OFF;
        IC2_SEG139 = IC_SEG_OFF;
        IC2_SEG146 = IC_SEG_OFF;
        IC2_SEG145 = IC_SEG_OFF;
        IC2_SEG144 = IC_SEG_OFF;
        IC2_SEG135 = IC_SEG_OFF;
        IC2_SEG134 = IC_SEG_OFF;
        IC2_SEG132 = IC_SEG_OFF;
        IC2_SEG131 = IC_SEG_OFF;
        IC2_SEG137 = IC_SEG_OFF;
        IC2_SEG136 = IC_SEG_OFF;

        IC2_SEG109 = IC_SEG_OFF;
        IC2_SEG110 = IC_SEG_OFF;
        IC2_SEG118 = IC_SEG_OFF;
        IC2_SEG122 = IC_SEG_OFF;
        IC2_SEG138 = IC_SEG_OFF;
        IC2_SEG142 = IC_SEG_OFF;
        
    }
}


/**@brief 总计里程显示函数
 
 * @param[in]  m_NUM_ODO         显示ODO数值  0 < m_NUM <= 199999
 * @param[in]  m_Uint            距离单位     -0 KM   -1 MILE 
 */
void SEG_SET_ODO_TRIP_FAULTCODE_TCS_DIS(uint8_t m_Uint, uint32_t m_NUM_ODO, uint32_t m_NUM_TRIP)
{

    uint32_t Num;
    uint8_t m8;
    if ((ClearODO_Flag != 1) && (Common_GetIgnOnTime() >= 3000))
    {
        if (Get_Current_PageType() == Page_Km_Unit)
        {
            if(FLASH_SYNC_1Hz)
            {
                IC1_SEG036 = IC_SEG_ON;
                IC1_SEG037 = IC_SEG_ON;                    
            }
            else
            {
                IC1_SEG036 = IC_SEG_OFF;
                IC1_SEG037 = IC_SEG_OFF;                    
            }
        }
        else
        {
            if((Get_Current_PageType() == Page_Odo) || (Get_Current_PageType() == Page_Trip))
            {
                if (m_Uint == 0)
                {
                    IC1_SEG036 = IC_SEG_OFF;
                    IC1_SEG037 = IC_SEG_ON;                        
                }
                else
                {
                    IC1_SEG036 = IC_SEG_ON;
                    IC1_SEG037 = IC_SEG_OFF;                        
                }

                if(Get_Current_PageType() == Page_Odo)
                {
                    IC1_SEG072 = IC_SEG_ON;
                    IC1_SEG045 = IC_SEG_OFF;
                    IC1_SEG046 = IC_SEG_OFF;
                    LED_Driver_Channel_Set(LampChannel_0, LampCh0_35_ODO, LED_ON);
                    LED_Driver_Channel_Set(LampChannel_0, LampCh0_34_TRIP, LED_OFF);
                }
                else if (Get_Current_PageType() == Page_Trip)
                {
                    IC1_SEG072 = IC_SEG_OFF;
                    IC1_SEG045 = IC_SEG_ON;
                    IC1_SEG046 = IC_SEG_ON;
                    LED_Driver_Channel_Set(LampChannel_0, LampCh0_35_ODO, LED_OFF);
                    LED_Driver_Channel_Set(LampChannel_0, LampCh0_34_TRIP, LED_ON);
                }
                else
                {
                    ;
                }
            }
            else
            {
                IC1_SEG036 = IC_SEG_OFF;
                IC1_SEG037 = IC_SEG_OFF;
                IC1_SEG072 = IC_SEG_OFF;
                IC1_SEG045 = IC_SEG_OFF;
                IC1_SEG046 = IC_SEG_OFF;
                LED_Driver_Channel_Set(LampChannel_0, LampCh0_35_ODO, LED_OFF);
                LED_Driver_Channel_Set(LampChannel_0, LampCh0_34_TRIP, LED_OFF);
            }
            
        }
        
    }
    else
    {
        IC1_SEG036 = IC_SEG_ON;
        IC1_SEG037 = IC_SEG_ON;        
        IC1_SEG072 = IC_SEG_ON;
        IC1_SEG045 = IC_SEG_ON;
        IC1_SEG046 = IC_SEG_ON;
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_35_ODO, LED_ON);
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_34_TRIP, LED_ON);
    }
    
    if((Get_Current_PageType() == Page_Odo) || (ClearODO_Flag == 1) || (Common_GetIgnOnTime() < 3000))   
    {
        if(m_NUM_ODO > 99999)
        {
            IC1_SEG076 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG076 = IC_SEG_OFF;
        }
        Num = (m_NUM_ODO / 10000) % 10;
        if (m_NUM_ODO >= 100000)
        {
            m8 = SEG_DISPLAY_NUMBER0[Num];
        }
        else
        {
            m8 = SEG_UNDISPLAY_NUMBER0[Num];
        }
        if (Bit_Is_Set(m8, 0))
        {
            IC1_SEG071 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG071 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            IC1_SEG070 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG070 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            IC1_SEG068 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG068 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            IC1_SEG075 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG075 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            IC1_SEG074 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG074 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            IC1_SEG073 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG073 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            IC1_SEG069 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG069 = IC_SEG_OFF;
        }
        Num = (m_NUM_ODO / 1000) % 10;
        if (m_NUM_ODO >= 10000)
        {
            m8 = SEG_DISPLAY_NUMBER0[Num];
        }
        else
        {
            m8 = SEG_UNDISPLAY_NUMBER0[Num];
        }
        if (Bit_Is_Set(m8, 0))
        {
            IC1_SEG064 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG064 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            IC1_SEG063 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG063 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            IC1_SEG061 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG061 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            IC1_SEG067 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG067 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            IC1_SEG066 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG066 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            IC1_SEG065 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG065 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            IC1_SEG062 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG062 = IC_SEG_OFF;
        }
        Num = (m_NUM_ODO / 100) % 10;
        if (m_NUM_ODO >= 1000)
        {
            m8 = SEG_DISPLAY_NUMBER0[Num];
        }
        else
        {
            m8 = SEG_UNDISPLAY_NUMBER0[Num];
        }
        if (Bit_Is_Set(m8, 0))
        {
            IC1_SEG057 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG057 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            IC1_SEG056 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG056 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            IC1_SEG054 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG054 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            IC1_SEG060 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG060 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            IC1_SEG059 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG059 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            IC1_SEG058 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG058 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            IC1_SEG055 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG055 = IC_SEG_OFF;
        }
        Num = (m_NUM_ODO / 10) % 10;
        if (m_NUM_ODO >= 100)
        {
            m8 = SEG_DISPLAY_NUMBER0[Num];
        }
        else
        {
            m8 = SEG_UNDISPLAY_NUMBER0[Num];
        }
        if (Bit_Is_Set(m8, 0))
        {
            IC1_SEG050 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG050 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            IC1_SEG049 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG049 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            IC1_SEG047 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG047 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            IC1_SEG053 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG053 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            IC1_SEG052 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG052 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            IC1_SEG051 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG051 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            IC1_SEG048 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG048 = IC_SEG_OFF;
        }
        Num = m_NUM_ODO  % 10;        
        m8 = SEG_DISPLAY_NUMBER0[Num];
        
        if (Bit_Is_Set(m8, 0))
        {
            IC1_SEG042 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG042 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            IC1_SEG041 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG041 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            IC1_SEG039 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG039 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            IC1_SEG038 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG038 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            IC1_SEG044 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG044 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            IC1_SEG043 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG043 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            IC1_SEG040 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG040 = IC_SEG_OFF;
        }
    }
    else if (Get_Current_PageType() == Page_Trip)
    {
        IC1_SEG076 = IC_SEG_OFF;
        IC1_SEG071 = IC_SEG_OFF;
        IC1_SEG070 = IC_SEG_OFF;
        IC1_SEG068 = IC_SEG_OFF;
        IC1_SEG075 = IC_SEG_OFF;
        IC1_SEG074 = IC_SEG_OFF;
        IC1_SEG073 = IC_SEG_OFF;
        IC1_SEG069 = IC_SEG_OFF;

        Num = m_NUM_TRIP  / 1000;              
        m8 = SEG_UNDISPLAY_NUMBER0[Num];
        
        if (Bit_Is_Set(m8, 0))
        {
            IC1_SEG064 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG064 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            IC1_SEG063 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG063 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            IC1_SEG061 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG061 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            IC1_SEG067 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG067 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            IC1_SEG066 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG066 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            IC1_SEG065 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG065 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            IC1_SEG062 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG062 = IC_SEG_OFF;
        }
        Num = (m_NUM_TRIP / 100) % 10;
        if (m_NUM_TRIP >= 1000)
        {
            m8 = SEG_DISPLAY_NUMBER0[Num];
        }
        else
        {
            m8 = SEG_UNDISPLAY_NUMBER0[Num];
        }
        if (Bit_Is_Set(m8, 0))
        {
            IC1_SEG057 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG057 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            IC1_SEG056 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG056 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            IC1_SEG054 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG054 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            IC1_SEG060 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG060 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            IC1_SEG059 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG059 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            IC1_SEG058 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG058 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            IC1_SEG055 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG055 = IC_SEG_OFF;
        }
        Num = (m_NUM_TRIP / 10) % 10;
        if ((m_NUM_TRIP >= 100) || (m_NUM_TRIP == 0))
        {
            m8 = SEG_DISPLAY_NUMBER0[Num];
        }
        else
        {
            m8 = SEG_UNDISPLAY_NUMBER0[Num];
        }
        if (Bit_Is_Set(m8, 0))
        {
            IC1_SEG050 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG050 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            IC1_SEG049 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG049 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            IC1_SEG047 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG047 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            IC1_SEG053 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG053 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            IC1_SEG052 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG052 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            IC1_SEG051 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG051 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            IC1_SEG048 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG048 = IC_SEG_OFF;
        }
        Num = m_NUM_TRIP  % 10;        
        m8 = SEG_DISPLAY_NUMBER0[Num];
        
        if (Bit_Is_Set(m8, 0))
        {
            IC1_SEG042 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG042 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            IC1_SEG041 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG041 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            IC1_SEG039 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG039 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            IC1_SEG038 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG038 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            IC1_SEG044 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG044 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            IC1_SEG043 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG043 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            IC1_SEG040 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG040 = IC_SEG_OFF;
        }
    }    
    else if (Get_Current_PageType() == Page_DTC)
    {
        IC1_SEG076 = IC_SEG_OFF;
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CAN_0x402_Msg_Count) == CAN_SIG_LOST)
        {
            SEG_SET_DTC_NUM(0x0B0B0B0B);
            IC1_SEG071 = IC_SEG_OFF;
            IC1_SEG070 = IC_SEG_OFF;
            IC1_SEG068 = IC_SEG_OFF;
            IC1_SEG075 = IC_SEG_OFF;
            IC1_SEG074 = IC_SEG_OFF;
            IC1_SEG073 = IC_SEG_OFF;
            IC1_SEG069 = IC_SEG_ON;
        }
        else
        {
            DTC_DISTimer ++;
            IC1_SEG071 = IC_SEG_ON;
            IC1_SEG070 = IC_SEG_ON;
            IC1_SEG068 = IC_SEG_OFF;
            IC1_SEG075 = IC_SEG_OFF;
            IC1_SEG074 = IC_SEG_ON;
            IC1_SEG073 = IC_SEG_ON;
            IC1_SEG069 = IC_SEG_ON;
            if(FaultCode_Number == 0)
            {
                SEG_SET_DTC_NUM(0);   
                DTC_DISTimer = 0; 
                Current_DTC_CODE = 0;            
            }
            else
            {
                if(DTC_DISTimer < 100)
                {
                    if (DTC_DISCount >= FaultCode_Number)
                    {
                        DTC_DISCount = FaultCode_Number -1;
                    }
                    if((FaultCode_Compare(Current_DTC_CODE, &FaultCode_Data[0], FaultCode_Number) == 0) && (FaultCode_Data[DTC_DISCount] != 0))
                    {
                        Current_DTC_CODE = FaultCode_Data[DTC_DISCount] ;
                        DTC_DISTimer = 0;
                    }
                }
                else if (DTC_DISTimer >= 100)
                {
                    DTC_DISCount ++ ;
                    if (DTC_DISCount >= FaultCode_Number)
                    {
                        DTC_DISCount = 0;
                    }
                    Current_DTC_CODE = FaultCode_Data[DTC_DISCount] ;
                    DTC_DISTimer = 0;
                }
                SEG_SET_DTC_NUM(Current_DTC_CODE);
            }
        }
    }
    else if (Get_Current_PageType() == Page_TCS)
    {
        IC1_SEG076 = IC_SEG_OFF;

        IC1_SEG071 = IC_SEG_ON;
        IC1_SEG070 = IC_SEG_OFF;
        IC1_SEG068 = IC_SEG_ON;
        IC1_SEG075 = IC_SEG_ON;
        IC1_SEG074 = IC_SEG_OFF;
        IC1_SEG073 = IC_SEG_ON;
        IC1_SEG069 = IC_SEG_ON;

        IC1_SEG064 = IC_SEG_OFF;
        IC1_SEG063 = IC_SEG_OFF;
        IC1_SEG061 = IC_SEG_OFF;
        IC1_SEG067 = IC_SEG_OFF;
        IC1_SEG066 = IC_SEG_OFF;
        IC1_SEG065 = IC_SEG_OFF;
        IC1_SEG062 = IC_SEG_OFF;

        IC1_SEG057 = IC_SEG_ON;
        IC1_SEG056 = IC_SEG_ON;
        IC1_SEG054 = IC_SEG_ON;
        IC1_SEG060 = IC_SEG_ON;
        IC1_SEG059 = IC_SEG_ON;
        IC1_SEG058 = IC_SEG_ON;
        IC1_SEG055 = IC_SEG_OFF;


        
        if(Get_Dis_Tcs_Val() == 0)
        {
            IC1_SEG050 = IC_SEG_ON;
            IC1_SEG049 = IC_SEG_OFF;
            IC1_SEG047 = IC_SEG_OFF;
            IC1_SEG053 = IC_SEG_OFF;
            IC1_SEG052 = IC_SEG_ON;
            IC1_SEG051 = IC_SEG_ON;
            IC1_SEG048 = IC_SEG_ON;

            IC1_SEG042 = IC_SEG_ON;
            IC1_SEG041 = IC_SEG_OFF;
            IC1_SEG039 = IC_SEG_OFF;
            IC1_SEG038 = IC_SEG_OFF;
            IC1_SEG044 = IC_SEG_ON;
            IC1_SEG043 = IC_SEG_ON;
            IC1_SEG040 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG050 = IC_SEG_ON;
            IC1_SEG049 = IC_SEG_ON;
            IC1_SEG047 = IC_SEG_ON;
            IC1_SEG053 = IC_SEG_OFF;
            IC1_SEG052 = IC_SEG_ON;
            IC1_SEG051 = IC_SEG_ON;
            IC1_SEG048 = IC_SEG_OFF;

            IC1_SEG042 = IC_SEG_OFF;
            IC1_SEG041 = IC_SEG_OFF;
            IC1_SEG039 = IC_SEG_OFF;
            IC1_SEG038 = IC_SEG_OFF;
            IC1_SEG044 = IC_SEG_OFF;
            IC1_SEG043 = IC_SEG_OFF;
            IC1_SEG040 = IC_SEG_OFF;
        }
    }
    else{;}

}


/**@brief 时间显示函数
 * @param[in]  m_hour            小时
 * @param[in]  m_minute          分钟
 * @param[in]  m_icon            中间冒号是否显示 -1 显示 -0 不显示
 * @param[in]  m_Flag1           小时是否显示     -1 显示 -0 不显示
 * @param[in]  m_Flag2           分钟是否显示     -1 显示 -0 不显示 
 */
void SEG_SET_Clock(uint8_t m_hour, uint8_t m_minute, uint8_t m_icon, uint8_t m_Flag1, uint8_t m_Flag2)
{
    
    uint8_t Num;
    uint8_t m8;   
    if (m_icon == 1u)
    {
        IC2_SEG043 = IC_SEG_ON;
    }
    else
    {
        IC2_SEG043 = IC_SEG_OFF;
    }
    if (m_Flag1 == 1u)
    {
        Num = m_hour / 10u; /*86104-11*/
        m8 = SEG_DISPLAY_NUMBER0[Num];
        if (Bit_Is_Set(m8, 0))
        {
            IC2_SEG033 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG033 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            IC2_SEG032 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG032 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            IC2_SEG037 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG037 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            IC2_SEG036 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG036 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            IC2_SEG035 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG035 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            IC2_SEG034 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG034 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            IC2_SEG038 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG038 = IC_SEG_OFF;
        }
        Num = m_hour % 10u;
        m8 = SEG_DISPLAY_NUMBER0[Num];
        if (Bit_Is_Set(m8, 0))
        {
            IC2_SEG030 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG030 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            IC2_SEG029 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG029 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            IC2_SEG042 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG042 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            IC2_SEG041 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG041 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            IC2_SEG040 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG040 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            IC2_SEG031 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG031 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            IC2_SEG039 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG039 = IC_SEG_OFF;
        }
    }
    else
    {
        IC2_SEG033 = IC_SEG_OFF;
        IC2_SEG032 = IC_SEG_OFF;
        IC2_SEG037 = IC_SEG_OFF;
        IC2_SEG036 = IC_SEG_OFF;
        IC2_SEG035 = IC_SEG_OFF;
        IC2_SEG034 = IC_SEG_OFF;
        IC2_SEG038 = IC_SEG_OFF;
        IC2_SEG030 = IC_SEG_OFF;
        IC2_SEG029 = IC_SEG_OFF;
        IC2_SEG042 = IC_SEG_OFF;
        IC2_SEG041 = IC_SEG_OFF;
        IC2_SEG040 = IC_SEG_OFF;
        IC2_SEG031 = IC_SEG_OFF;
        IC2_SEG039 = IC_SEG_OFF;
    }
    if (m_Flag2 == 1u)
    {
        Num = m_minute / 10u;
        m8 = SEG_DISPLAY_NUMBER0[Num];
        if (Bit_Is_Set(m8, 0))
        {
            IC2_SEG027 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG027 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            IC2_SEG026 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG026 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            IC2_SEG046 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG046 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            IC2_SEG045 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG045 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            IC2_SEG044 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG044 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            IC2_SEG028 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG028 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            IC2_SEG047 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG047 = IC_SEG_OFF;
        }
        Num = m_minute % 10u;
        m8 = SEG_DISPLAY_NUMBER0[Num];
        if (Bit_Is_Set(m8, 0))
        {
            IC2_SEG024 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG024 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            IC2_SEG023 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG023 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            IC2_SEG051 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG051 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            IC2_SEG050 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG050 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            IC2_SEG049 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG049 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            IC2_SEG025 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG025 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            IC2_SEG048 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG048 = IC_SEG_OFF;
        }
    }
    else
    {
        IC2_SEG027 = IC_SEG_OFF;
        IC2_SEG026 = IC_SEG_OFF;
        IC2_SEG046 = IC_SEG_OFF;
        IC2_SEG045 = IC_SEG_OFF;
        IC2_SEG044 = IC_SEG_OFF;
        IC2_SEG028 = IC_SEG_OFF;
        IC2_SEG047 = IC_SEG_OFF;
        IC2_SEG024 = IC_SEG_OFF;
        IC2_SEG023 = IC_SEG_OFF;
        IC2_SEG051 = IC_SEG_OFF;
        IC2_SEG050 = IC_SEG_OFF;
        IC2_SEG049 = IC_SEG_OFF;
        IC2_SEG025 = IC_SEG_OFF;
        IC2_SEG048 = IC_SEG_OFF;
    }
   
}

uint8_t fuel_check_SEG_step = 0;
void SEG_Scan_SET_Fuel_Coolant_Dial(uint8_t coolant)
{
    uint8_t a = 0;
    a = fuel_check_SEG_step / 10u;
    SEG_SET_FuelDial(1, a);
    SEG_SET_CoolantDial(1, a, coolant, 1);
    if (fuel_check_SEG_step < 59)
    {
        fuel_check_SEG_step++;
    }
    else
    {
        fuel_check_SEG_step = 0;
    }
}


uint8_t Espeed_check_SEG_step = 0;
void SEG_Scan_SET_EspeedDial(void)
{
    uint16_t a = 0;
    a = (Espeed_check_SEG_step / 10) * 500;

    SEG_SET_EspeedDial(1, a / 500);
}


uint8_t check_SEG_step = 0;

/*仪表段码扫描函数*/
void Check_SEG_Display(void)
{
    uint32_t a;
    uint8_t i = 0;

    a = check_SEG_step / 25u;

    SEG_SET_ODO_TRIP_FAULTCODE_TCS_DIS(1, ((a * 11111) + 100000), 0);    
    SEG_SET_VSpeed_NUM(1u, (100u + (a * 10u) + a), 0);
    SEG_SET_Clock(((a * 10u) + a), ((a * 10u) + a), 1u, 1u, 1u);
    SEG_SET_TPMS_NUM(1, a * 11, a * 11, 0, 1, 1);
    SEG_SET_Voltage_NUM(1, a * 111);
    
    for (i = 0;  i < SEG_LED_MAX; i++)
    {
       SEG_SET_LED_STS(i, 1); 
    }
   

    SEG_Scan_SET_Fuel_Coolant_Dial((a*11) + 100);
    SEG_Scan_SET_EspeedDial();
    
}

uint8_t Checkself_SEG_step = 0;
uint8_t Checkself_SEG_step_count = 0;
void Checkself_Init(void)
{
    Checkself_SEG_step = 0;
    Checkself_SEG_step_count = 0;
    check_SEG_step = 0;
    Espeed_check_SEG_step = 0;
    fuel_check_SEG_step = 0;
}

void Checkself_SEG_Display(void)
{
    uint16_t Vspeed = 0;
    uint16_t Espeed = 0;
    uint16_t Fuel = 0;
    uint16_t collant = 0;
    uint16_t TPMS = 0;
    uint16_t voltage = 0;
    uint16_t hour = 0;
    uint16_t min = 0;
    uint32_t ODO = 0;
    //uint32_t i = 0;

    //for(i = 0; i < BU98R10_DDRAM_SIZE; i ++)
    //{
    //    BU98R10Chip0DDRAM.Byte[i] = 1;
    //    BU98R10Chip1DDRAM.Byte[i] = 1;
    //}

    Fuel = Checkself_SEG_step / 5u;
    SEG_SET_FuelDial(1, Fuel);
    collant = 100 + ((Checkself_SEG_step / 3) * 11);
    SEG_SET_CoolantDial(1, Fuel, collant, 1);

    Espeed = (Checkself_SEG_step * 5 / 6) * 500;
    SEG_SET_EspeedDial(1, Espeed / 500);

    Vspeed = ((Checkself_SEG_step / 3) * 11) + 100;    
    SEG_SET_VSpeed_NUM(1, Vspeed, 0);    

    ODO = ((Checkself_SEG_step / 3) * 11111) + 100000;
    SEG_SET_ODO_TRIP_FAULTCODE_TCS_DIS(1, ODO, 0);

    hour = (Checkself_SEG_step / 3) * 11;
    min = (Checkself_SEG_step / 3) * 11;
    SEG_SET_Clock(hour, min, 1, 1, 1);

    TPMS = (Checkself_SEG_step / 3) * 11;
    SEG_SET_TPMS_NUM(1, TPMS, TPMS, 0, 1, 1);

    voltage = (Checkself_SEG_step / 3) * 111;
    SEG_SET_Voltage_NUM(1, voltage);

    if (Checkself_SEG_step_count < 60)
    {
        Checkself_SEG_step_count++;
    }
    else
    {
        Checkself_SEG_step_count = 60;
    }

    if (Checkself_SEG_step_count <= 30)
    {
        Checkself_SEG_step++;
    }
    else
    {
        if (Checkself_SEG_step == 0)
        {
            Checkself_SEG_step = 0;
        }
        else
        {
            Checkself_SEG_step--;
        }
    }
}

void TYW_Check_Count(void)
{
    if ((ClearODO_Flag == 1)&&( Common_Get_IG_Sts( ) == COMMON_POWER_ON ))
    {
        if (check_SEG_step < 249u)
        {
            check_SEG_step++;
        }
        else
        {
            check_SEG_step = 0u;
        }

        if (Espeed_check_SEG_step < 249)
        {
            Espeed_check_SEG_step++;
        }
        else
        {
            Espeed_check_SEG_step = 0;
        }
    }
}
