#include "stddef.h"
#include "BAT32A239.h"
#include "core_cm0plus.h"
#include "RTE_WDT.h"
#include "wdt.h"

/**
 * @brief WDT Control BYTE
 * Please refer to the user manual for details.
 *     7   |    6    |    5    |   4   |   3   |   2   |   1   |   0
 * --------|---------|---------|-------|-------|-------|-------|----------
 *  WDTINT | WINDOW1 | WINDOW0 | WDTON | WDCS2 | WDCS1 | WDCS0 | WDSTBYON
 * --------|---------|---------|-------|-------|-------|-------|----------
 */
/* <h> WDT Control Option Byte (C0H)
   <e.4> Enable WDT (WDTON)
     <o.5..6> Watchdog timer window open period setting      <2=> 75%        <3=> 100%
     <o.1..3> Watchdog timer overflow time setting           <0=> 2^6/fIL    <1=> 2^7/fIL
                                                             <2=> 2^8/fIL    <3=> 2^9/fIL
                                                             <4=> 2^11/fIL   <5=> 2^13/fIL
                                                             <6=> 2^14/fIL   <7=> 2^16/fIL
     <e.0>    Operation in Standby mode setting (WDSTBYON)
              <i> WDT Operaton in SLEEP/DEEPSLEEP mode.
     </e>
     <e.7>    interrupt enable
              <i> interval interrupt is generated when 75% + 1/2 fIL of the overflow time is reached.
     </e>
   </e>
 </h>
*/

uint32_t *pu8WDTCtrByte =(uint32_t*) 0x000000C0;

void RTE_WDT_Enable(void)
{
	CGC->WDTCFG0 = 0x1AU;
	CGC->WDTCFG1 = 0x2BU;
	CGC->WDTCFG2 = 0x3CU;
	CGC->WDTCFG3 = 0x4DU;
	
	*pu8WDTCtrByte = 0x7FU;   /* WDT ON */
	
	WDT->WDTE = 0xACU; 
}

void RTE_WDT_Disable(void)
{	
	*pu8WDTCtrByte = 0x6FU;   /* WDT OFF */
	
	WDT->WDTE = 0xACU; 
}

void RTE_WDT_Clear(void)
{
    WDT_Restart();     /* restart watchdog timer */
}
