
#include "Sys_Scheduler_Lib.h"
#include "Application.h"
#include "Components.h"
#include "RTE.h"
#include "UDS_ISO14229_Server.h"
void Sys_Pseudo_Real_Time_Tasks(void)
{
    Power_Management_Service();
    DoCAN_Communication_Service();              
    UDS_Server_Application_Service();
    BU98R10_Update_Service();
    LED_Driver_Service();
    
}

void Sys_2ms_Tasks(void)
{
    Common_Input_Para();
    Can_Write_Fun(&CAN_CH0_CanMsgTxOp, 2000u);
    Sys_Status_Update_Service();
    Analog_Signal_Conv_Service();
    CanMSg_XMS_Analysis(&CAN_CH0_CanMsgOp,2u);

    // if (RTE_GPIO_Get_Level(VSPEED_TEN_OUT))
    // {
    //     RTE_GPIO_Config(VSPEED_TEN_OUT, RTE_GPIO_DIR_OUT|RTE_GPIO_LEVEL_LOW);
    // }
    // else
    // {
    //     RTE_GPIO_Config(VSPEED_TEN_OUT, RTE_GPIO_DIR_OUT|RTE_GPIO_LEVEL_HIGH);
    // }
}

void Sys_5ms_Tasks(void)
{
    Flash_Sync_Signal_Generation_Service();
}


void Sys_10ms_Tasks(void)
{
    Line_In_Debounce_Service(10u);
    Key_Service();
    Data_Mileage_Write_EEPROM();
    Can_BusOff_Recover(10u);
    Turn_Left_Right_Lamp();
    Fuel_R_Cal(10u);
    TYW_Check_Count();
}

void Sys_20ms_Tasks(void)
{
    Key_Clear_Time();
    Key_Auto_Save();
    Data_Vehicle_Speed_Processing_Service();
    Data_Engine_Speed_Processing_Service();
    Data_Coolant_Temp_Processing_Service();
}

void Sys_50ms_Tasks(void)
{
    BU98R10_Update_Request();
    LED_Driver_Scan_Refresh();
    Telltales_Management();
    Gauge_Service();
    Key_Check_Service();
}

uint8_t u8LEDDriverCheckCount = 0U;
void Sys_100ms_Tasks(void)
{
    // if((PageType != Page_Time_Hour)&&(PageType != Page_Time_Minute))
    // {
    //     RTE_RTC_Get_CounterValue(&counter_val);
    //     counter_val.time.RTC_Hours = RTC_Bcd2ToByte(counter_val.time.RTC_Hours);
	// 	counter_val.time.RTC_Minutes = RTC_Bcd2ToByte(counter_val.time.RTC_Minutes);
    // }
    Fuel_Cal_Sevice(100u);
    BackLight_Process();
    Services_Mileage_Callback();
	S3_ServerCNTT();

    if (u8LEDDriverCheckCount >= 10U)
    {
        u8LEDDriverCheckCount = 0U;
        LED_Driver_Work_Check();
        LED_Driver_Service_Immediate();//注意顺序1
        //ALS_Service();//注意顺序2
    }
    else
    {
        u8LEDDriverCheckCount++;
    }    
}


/**
 * @brief 50us中断服务 尽可能的减少中断使用
 * 
 */
void Sys_Exact_50us_Tasks(void)
{
    static uint32_t task_1ms = 0u;
    DoCAN_Timer_Update(50u);
    GenDelay_Tick();
    task_1ms++;
    if ( task_1ms >=20U )   
    {
        task_1ms =0U;
        eeprom_1ms_timeCount( );
    }
}
