
#include "Data_Coolant\Data_Coolant.h"
#include "Application.h"


DataCoolantTempStruct DataCoolantTemp ;
DataCoolantTempDisStruct DataCoolantTemp_Dis;




void Data_Coolant_Temp_KL30_Init ( void )
{
    DataCoolantTemp.Value = 0; 
    DataCoolantTemp.Valid = 0;      

    DataCoolantTemp_Dis.u8_CurSeg = 0;
    DataCoolantTemp_Dis.u8_DestSeg = 0;
    DataCoolantTemp_Dis.u8_UpFlashtimer = CoolantFlashtimer; 
    DataCoolantTemp_Dis.u8_DownFlashtimer = CoolantFlashtimer; 
    
      

    DataCoolantTemp_Dis.u8_Warnflg = 0;
    DataCoolantTemp_Dis.u8_Flg = 0;    

}

void Data_Coolant_Temp_KL15_Init ( void )
{
    DataCoolantTemp_Dis.u8_CurSeg = 0;
    DataCoolantTemp_Dis.u8_DestSeg = 0;
    DataCoolantTemp_Dis.u8_UpFlashtimer = 0; 
    DataCoolantTemp_Dis.u8_DownFlashtimer = 0; 

    
    DataCoolantTemp_Dis.u8_Warnflg = 0;
    DataCoolantTemp_Dis.u8_Flg = 0;   
}


#define COOLANT_NUM_TIME 5 // 数显多久变化一次，暂定100ms

typedef struct
{
    /*该段的下限值*/
    uint16_t u16HYSSegLow;
    /*该段的上限值*/
    uint16_t u16HYSSegHigh;
} HYS_Seg_Table_st_t;
const HYS_Seg_Table_st_t stHYSSegTableTemp[7] =
    {
        {0U, 4700U},    // 0
        {5000U, 5900U},   // 1
        {6200U, 7700U},   // 2
        {8000U, 9500U},   // 3
        {9800U, 11200U},  // 4
        {11500U, 19900U}, // 5
        {19900U, 20000U}, // 6
};
uint32_t u32CoolantDataTimeCount = 0UL;
uint32_t u32ColCurNum = 0UL; /*阻尼数显*/
    uint32_t u32CoolantNum = 0UL;/*当前实际数据，与显示数值不完全一致*/
/*
u32CoolantDir：0：下行，1：上行 2：无变化

*/
uint32_t Data_Coolant_Cal_Num(uint32_t u32CoolantCurSeg, uint32_t u32CoolantDir, uint32_t u32CoolantRemTime, uint32_t u32CoolantCurNum, uint32_t u32CoolantDesNum)
{
    uint32_t u32CoolantNumMax = 0UL;
    uint32_t u32CoolantNumMin = 0UL;
    uint32_t u32CoolantSegDesNum = 0UL;
    uint32_t u32CoolantCalBuf = 0UL;
    uint32_t u32CoolantCalBuf1 = 0UL;
    uint32_t u32CoolantCalResult = u32CoolantCurNum;

    /*计算当前格对应的目标数值*/
    /*当前格数对应的数值范围，目标数值是否在这个范围内，如果在就直接用目标值。如果不在就根据上下行选择该范围内的极大和极小值。*/
    /*这样就找到了当前格对应的目标数值*/
    u32CoolantNumMax = stHYSSegTableTemp[u32CoolantCurSeg + 1].u16HYSSegLow;
    if (u32CoolantCurSeg)
    {
        u32CoolantNumMin = stHYSSegTableTemp[u32CoolantCurSeg - 1].u16HYSSegHigh;
    }
    else
    {
        u32CoolantNumMin = stHYSSegTableTemp[u32CoolantCurSeg].u16HYSSegLow;
    }

    if ((u32CoolantDesNum >= u32CoolantNumMin) && (u32CoolantDesNum <= u32CoolantNumMax))
    {
        u32CoolantSegDesNum = u32CoolantDesNum;
    }
    else
    {
        if (u32CoolantDir == 1) // UP
        {
            u32CoolantSegDesNum = u32CoolantNumMax;
        }
        else if (u32CoolantDir == 0) // down
        {
            u32CoolantSegDesNum = u32CoolantNumMin;
        }
        else
        {
            u32CoolantSegDesNum = u32CoolantDesNum;
        }
    }

    if (u32CoolantDataTimeCount < COOLANT_NUM_TIME)
    {
        u32CoolantDataTimeCount++;
    }
    else
    {
        u32CoolantDataTimeCount = 0UL;

        u32CoolantCalBuf = u32CoolantRemTime / COOLANT_NUM_TIME;
        if (u32CoolantCalBuf)
        {

            if (u32CoolantNum < u32CoolantSegDesNum)
            {
                u32CoolantCalBuf1 = u32CoolantSegDesNum - u32CoolantNum;
                u32CoolantCalBuf1 = u32CoolantCalBuf1 / u32CoolantCalBuf;
                u32CoolantNum += u32CoolantCalBuf1;
                if (u32CoolantNum > u32CoolantSegDesNum)
                {
                    u32CoolantNum = u32CoolantSegDesNum;
                }
            }
            else
            {
                u32CoolantCalBuf1 = u32CoolantNum - u32CoolantSegDesNum;
                u32CoolantCalBuf1 = u32CoolantCalBuf1 / u32CoolantCalBuf;
                u32CoolantNum -= u32CoolantCalBuf1;
                if (u32CoolantNum < u32CoolantSegDesNum)
                {
                    u32CoolantNum = u32CoolantSegDesNum;
                }
            }
        u32CoolantCalResult = u32CoolantNum;
        if (u32CoolantDir == 0) // down
        {
                // uint32_t u32CoolantCalBuf2 = 0UL;
                //             if (u32CoolantNum>u32CoolantCurNum)
                //             {
                //                u32CoolantCalBuf2 =  u32CoolantNum-u32CoolantCurNum;
                //             }
                //             else
                //             {
                //                u32CoolantCalBuf2 =  u32CoolantCurNum-u32CoolantNum;
                                
                //             }
                //             if (u32CoolantCalBuf2>=100)
                //             {
                                
                //            u32CoolantNum+=99UL;
                //             }

             if ((u32CoolantNum+99)>=u32CoolantCurNum)
             {
             u32CoolantCalResult= u32CoolantCurNum;
             }
             else
             {
                
             u32CoolantCalResult= ((u32CoolantNum+99)/100*100);
             }
             
            
        }
        

        }
        else // 0
        {
            u32CoolantNum = u32CoolantSegDesNum;
            u32CoolantCalResult = u32CoolantNum;
        }
    }

    /*根据目标数值计算每个变化周期内数值变化的大小，*/
    /*根据目标数值以及剩余时间，修改当前显示值*/

   // return u32CoolantNum;
    return u32CoolantCalResult;
}

void Data_Coolant_Temp_Processing_Service(void)
{
    uint16_t  Coolant_Temperature = 0;
    uint8_t   Coolant_Temperature_State = 0;
    uint32_t  Temp = 0;
    uint8_t   i = 0;

    Coolant_Temperature = Get_CAN_CH0_ID_101_Sig_ECU_Engine_Temperature();
    Coolant_Temperature_State = Get_CAN_CH0_ID_101_Sig_ECU_Engine_Temperature_State();

    if (Common_Get_IG_Sts( ) == COMMON_POWER_ON )
    {       
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CAN_0x101_Msg_Count) == CAN_SIG_LOST)
        {
            DataCoolantTemp.Valid = 0;
            DataCoolantTemp.Value = 0;                       
        }
        else
        {
            if(Coolant_Temperature_State == 1)
            {
                DataCoolantTemp.Valid = 0;
                DataCoolantTemp.Value = 0; 
            }
            else
            {
                DataCoolantTemp.Valid = 1;
                if(Coolant_Temperature >= 2730)
                {
                    Coolant_Temperature -= 2730;                   
                }
                else
                {                    
                    Coolant_Temperature   = 0;  
                }

                if ((Coolant_Temperature % 10) >= 5)
                {
                    Coolant_Temperature += 5;
                }

                if(Coolant_Temperature > 1990) 
                {
                    Coolant_Temperature = 1990 ;    
                } 

                DataCoolantTemp.Value = Coolant_Temperature / 10;
            }
            
            
        }
    }
    else
    {
        DataCoolantTemp.Valid = 0;
        DataCoolantTemp.Value = 0;       
    }   

    //显示   
    Data_Coolant_Temp_Display();        

}


void Data_Coolant_Temp_Display ( void )
{    
    if(Common_Get_IG_Sts( ) == COMMON_POWER_ON)
    {                
        if (Common_GetIgnOnTime() < 3030)
        {   
            DataCoolantTemp_Dis.u8_Uptimer = CoolantSelfCheckFlashtimer; 
            DataCoolantTemp_Dis.u8_Downtimer = CoolantSelfCheckFlashtimer; 
 
            if(DataCoolantTemp_Dis.u8_CurSeg == 0)
            {
                DataCoolantTemp_Dis.u8_DestSeg = 5;    
            }
            if(DataCoolantTemp_Dis.u8_CurSeg == 5)
            {
                DataCoolantTemp_Dis.u8_DestSeg = 0;    
            }
            DataCoolantTemp_Dis.u8_Warnflg = 0; 
            DataCoolantTemp_Dis.u8_Flg = 0;
            DataCoolantTemp_Dis.Dis_Valid = 0; 
        }
        else
        {
            DataCoolantTemp_Dis.u8_Uptimer = CoolantFlashtimer; 
            DataCoolantTemp_Dis.u8_Downtimer = CoolantFlashtimer;

            Get_Coolant_Temp_Seg(DataCoolantTemp.Value);

            if(DataCoolantTemp.Valid == 0)       
            {
                DataCoolantTemp_Dis.Dis_Valid = 0; 
                DataCoolantTemp_Dis.u8_UpFlashtimer = DataCoolantTemp_Dis.u8_Uptimer; 
                DataCoolantTemp_Dis.u8_DownFlashtimer = DataCoolantTemp_Dis.u8_Downtimer; 
                DataCoolantTemp_Dis.u8_CurSeg = 0;
                DataCoolantTemp_Dis.u8_DestSeg = 0 ;                            
                DataCoolantTemp_Dis.u8_Flg = 0;  
                u32ColCurNum = DataCoolantTemp.Value * 100 ;
                DataCoolantTemp_Dis.u8_Holdtimer = CoolantFlashtimer;          
            } 
            else
            {  
                DataCoolantTemp_Dis.Dis_Valid = 1; 
                if (DataCoolantTemp_Dis.u8_Flg == 2)
                {
                    DataCoolantTemp_Dis.u8_Flg = 1;
                    DataCoolantTemp_Dis.u8_UpFlashtimer = 0; 
                    DataCoolantTemp_Dis.u8_DownFlashtimer = 0; 
                }  
                else if(DataCoolantTemp_Dis.u8_Flg == 0)
                {
                    DataCoolantTemp_Dis.u8_Flg = 2;  
                    DataCoolantTemp_Dis.u8_CurSeg =  DataCoolantTemp_Dis.u8_DestSeg; 
                    DataCoolantTemp_Dis.u8_UpFlashtimer = DataCoolantTemp_Dis.u8_Uptimer; 
                    DataCoolantTemp_Dis.u8_DownFlashtimer = DataCoolantTemp_Dis.u8_Downtimer; 
                    u32ColCurNum = DataCoolantTemp.Value * 100;                    
                    DataCoolantTemp_Dis.u8_Holdtimer = CoolantFlashtimer;
                } 
                else
                {
                    ;
                }
                
            }
        }
        if (Common_GetIgnOnTime() >= 3030)
        {
            if(DataCoolantTemp_Dis.u8_CurSeg > DataCoolantTemp_Dis.u8_DestSeg )
            {
                u32ColCurNum = Data_Coolant_Cal_Num(DataCoolantTemp_Dis.u8_CurSeg, 0, (DataCoolantTemp_Dis.u8_Downtimer - DataCoolantTemp_Dis.u8_DownFlashtimer), u32ColCurNum, DataCoolantTemp.Value*100);
                DataCoolantTemp_Dis.u8_UpFlashtimer = 0; 
                DataCoolantTemp_Dis.u8_Holdtimer = 0; 
                DataCoolantTemp_Dis.u8_DownFlashtimer++;
                if(DataCoolantTemp_Dis.u8_DownFlashtimer >= DataCoolantTemp_Dis.u8_Downtimer)
                {
                    DataCoolantTemp_Dis.u8_DownFlashtimer = 0;
                    DataCoolantTemp_Dis.u8_CurSeg--;
                }
            }
            else if (DataCoolantTemp_Dis.u8_CurSeg < DataCoolantTemp_Dis.u8_DestSeg)
            {
                u32ColCurNum = Data_Coolant_Cal_Num(DataCoolantTemp_Dis.u8_CurSeg, 1, (DataCoolantTemp_Dis.u8_Uptimer - DataCoolantTemp_Dis.u8_UpFlashtimer), u32ColCurNum, DataCoolantTemp.Value*100);
                DataCoolantTemp_Dis.u8_DownFlashtimer = 0;
                DataCoolantTemp_Dis.u8_Holdtimer = 0;
                DataCoolantTemp_Dis.u8_UpFlashtimer++;
                if (DataCoolantTemp_Dis.u8_UpFlashtimer >= DataCoolantTemp_Dis.u8_Uptimer)
                {
                    DataCoolantTemp_Dis.u8_UpFlashtimer = 0;
                    DataCoolantTemp_Dis.u8_CurSeg++;
                }
            }
            else
            {
                   DataCoolantTemp_Dis.u8_DownFlashtimer = 0;
                DataCoolantTemp_Dis.u8_UpFlashtimer = 0;
                DataCoolantTemp_Dis.u8_Holdtimer =  CoolantFlashtimer;//++;
                // if (DataCoolantTemp_Dis.u8_Holdtimer >= CoolantFlashtimer)
                // {
                //     DataCoolantTemp_Dis.u8_Holdtimer = CoolantFlashtimer;
                // }
                /*目标格和当前格一致时，数显如何处理*/
                /*5S后更新为目标数值*/
                u32ColCurNum = Data_Coolant_Cal_Num(DataCoolantTemp_Dis.u8_CurSeg, 2, (CoolantFlashtimer-DataCoolantTemp_Dis.u8_Holdtimer ), u32ColCurNum, DataCoolantTemp.Value*100);
                // if(u32ColCurNum < DataCoolantTemp.Value*100)
                // {
                //     u32ColCurNum += 100;
                // }
                // else if (u32ColCurNum > DataCoolantTemp.Value*100)
                // {
                //     u32ColCurNum -= 100;
                // }
                // else
                // {
                //     u32ColCurNum = DataCoolantTemp.Value*100;
                // }
   
            }
        }
        else
        {
            u32ColCurNum = DataCoolantTemp.Value * 100;
        }
        

        // warning

        if (DataCoolantTemp.Valid == 0)
        {
            DataCoolantTemp_Dis.u8_Warnflg = 1;
        }
        else
        {
            if (GET_DataCoolantSegValue() >= 115)
            {
                DataCoolantTemp_Dis.u8_Warnflg = 2;
            }
            else if (GET_DataCoolantSegValue() <= 112)
            {
                DataCoolantTemp_Dis.u8_Warnflg = 0;
            }
            else
            {
                if(DataCoolantTemp_Dis.u8_Warnflg == 1)
                {
                    DataCoolantTemp_Dis.u8_Warnflg = 0;
                }
            }
        }
    }
    else
    {
        DataCoolantTemp_Dis.Dis_Valid = 0;
        DataCoolantTemp_Dis.u8_UpFlashtimer = DataCoolantTemp_Dis.u8_Uptimer;
        DataCoolantTemp_Dis.u8_DownFlashtimer = DataCoolantTemp_Dis.u8_Downtimer;
        DataCoolantTemp_Dis.u8_Warnflg = 0;
        DataCoolantTemp_Dis.u8_Flg = 0;
    }
}

uint8_t Get_Coolant_Temp_Seg(uint16_t Temp_Value)
{
    // uint8_t CurTempSeg;

    if (Temp_Value < 50)
    {
        if (DataCoolantTemp_Dis.u8_CurSeg > 1)
        {
            DataCoolantTemp_Dis.u8_DestSeg = 1;
        }
        else if (DataCoolantTemp_Dis.u8_CurSeg > 0)
        {
            if (Temp_Value <= 47)
            {
                DataCoolantTemp_Dis.u8_DestSeg = 0;
            }
        }
        else
        {
            DataCoolantTemp_Dis.u8_DestSeg = 0;
        }
    }
    else if ((Temp_Value < 62) && (Temp_Value >= 50))
    {
        if (DataCoolantTemp_Dis.u8_CurSeg > 2)
        {
            DataCoolantTemp_Dis.u8_DestSeg = 2;
        }
        else if (DataCoolantTemp_Dis.u8_CurSeg > 1)
        {
            if (Temp_Value <= 59)
            {
                DataCoolantTemp_Dis.u8_DestSeg = 1;
            }
        }
        else
        {
            DataCoolantTemp_Dis.u8_DestSeg = 1;
        }
    }
    else if ((Temp_Value < 80) && (Temp_Value >= 62))
    {
        if (DataCoolantTemp_Dis.u8_CurSeg > 3)
        {
            DataCoolantTemp_Dis.u8_DestSeg = 3;
        }
        else if (DataCoolantTemp_Dis.u8_CurSeg > 2)
        {
            if (Temp_Value <= 77)
            {
                DataCoolantTemp_Dis.u8_DestSeg = 2;
            }
        }
        else
        {
            DataCoolantTemp_Dis.u8_DestSeg = 2;
        }
    }
    else if ((Temp_Value < 98) && (Temp_Value >= 80))
    {
        if (DataCoolantTemp_Dis.u8_CurSeg > 4)
        {
            DataCoolantTemp_Dis.u8_DestSeg = 4;
        }
        else if (DataCoolantTemp_Dis.u8_CurSeg > 3)
        {
            if (Temp_Value <= 95)
            {
                DataCoolantTemp_Dis.u8_DestSeg = 3;
            }
        }
        else
        {
            DataCoolantTemp_Dis.u8_DestSeg = 3;
        }
    }
    else if ((Temp_Value < 115) && (Temp_Value >= 98))
    {
        if (DataCoolantTemp_Dis.u8_CurSeg > 4)
        {
            if (Temp_Value <= 112)
            {
                DataCoolantTemp_Dis.u8_DestSeg = 4;
            }
        }
        else
        {
            DataCoolantTemp_Dis.u8_DestSeg = 4;
        }
    }
    else
    {
        DataCoolantTemp_Dis.u8_DestSeg = 5;
    }
    return DataCoolantTemp_Dis.u8_DestSeg;
}

// 水温显示格数
uint8_t GET_DataCoolantTempSegDisp(void)
{
    return DataCoolantTemp_Dis.u8_CurSeg;
}

// 水温显示有效标志
uint8_t GET_DataCollantTempSegValid(void)
{
    return DataCoolantTemp_Dis.Dis_Valid;
}

// 水温数显。作为外发使用的时候+40
uint16_t GET_DataCoolantTempValueDisp(void)
{
    return DataCoolantTemp.Value;
}
uint16_t GET_DataCoolantSegValue(void)
{
    return (uint16_t)((u32ColCurNum)/100);
}
uint8_t GET_DataCollantTempValueValid(void)
{
    return DataCoolantTemp.Valid;
}

// 水温灯及显示的报警信号  0:无报警，正常显示   1：掉线或者state无效，白色闪烁  2：高温，红色闪烁
uint8_t GET_DataCollantTempWarnflg(void)
{
    return DataCoolantTemp_Dis.u8_Warnflg;
}
