#include "PowerManagement.h"
#include "PowerManag_user.h"
#include "Components.h"
#include "Application.h"
#include "RTE.h"


RTC_Information_st_t g_stRTCInformation;

static void Power_KL30_Init(void);
static void Power_Wakeup_Init(void);
static void Power_LVP_Init(void);
static void Power_OVP_Init(void);
static void Power_IG_OFF_Init(void);
static void Power_IG_ON_Init(void);
static void Power_Sleep_Init(void);

static Power_Status_em Power_Stay_ON(void);
static Power_Status_em Power_Stay_OFF(void);
static Power_Status_em Power_Stay_Protect(void);
static Power_Status_em Power_Stay_Sleep(void);

extern uint8_t u8LEDDriverCheckCount;

static const st_PowerGroup g_stPwrTasks = {
    Power_KL30_Init,
    Power_IG_OFF_Init,
    Power_Stay_OFF,
    Power_Sleep_Init,
    Power_Stay_Sleep,
    Power_Wakeup_Init,
    Power_IG_ON_Init,
    Power_Stay_ON,
    Power_LVP_Init,
    Power_OVP_Init,
    Power_Stay_Protect,
};

void PwrMemInit(void)
{
    PowerMemInit(&g_stPwrTasks);
}

static void Power_KL30_Init(void)
{
    ClearODO_Flag = 0;
    Simulated_IIC_2_Init();
    Gpio_Init(Gpio_KL30_Init);
    eeprom_StoreInfo_Init();
    Can_Init();
    CAN_TX_SetEnable(&CAN_CH0_CanMsgTxOp, CAN_N_TX_Enable);
    DFlash_init();
    Analog_Signal_Conv_Init();
    BU98R10_Init();   
    Uart0_Init(115200);
    Protocol_KL30_Wakeup_Init();
    BlueTooth_KL30_KL15_Wakeup_Init();
    Sys_KL30_Init();
    Checkself_Init();
    Data_Vehicle_Speed_KL30_Init();
    Data_Engine_Speed_KL30_Wakeup_Init();
    Data_Coolant_Temp_KL30_Init();
    LINE_IN_Init();
    Key_KL30_Init_EXample();
    //Light_Sensor_Init_Example();//注意顺序1
    LED_Driver_Init_Example();//注意顺序2
    Data_User_Mileage_KL30Init();
    Fuel_KL30_Init();
    Data_Voltage_Init();
    TimerM_PWM_counter_Output_Init(TIMERM_COUNTER0, 400, 64000000);
    TimerM_PWM_counter_Output_Init(TIMERM_COUNTER1, 400, 64000000);
//    TimerM_PWM_counter_Output_Init(TIMERM_COUNTER0, 400);
//    TimerM_PWM_counter_Output_Init(TIMERM_COUNTER1, 400);
    TimerM_PWM_CH_Output_init(TIMERM_COUNTER0, TIMERM_CHB, ActiveLevel_High);
    TimerM_PWM_CH_Output_init(TIMERM_COUNTER0, TIMERM_CHC, ActiveLevel_High);
    TimerM_PWM_CH_Output_init(TIMERM_COUNTER0, TIMERM_CHD, ActiveLevel_High);
    TimerM_PWM_CH_Output_init(TIMERM_COUNTER1, TIMERM_CHB, ActiveLevel_High);
    
    Telltales_Init();
    Telltales_UserInit();
    MenuData_Unit_Init();
    Data_TPMS_KL30_Init ();
    g_stRTCInformation.u8RTCSecond = 0;
	g_stRTCInformation.u8RTCMinute = 0;
	g_stRTCInformation.u8RTCHour = 0;          
	g_stRTCInformation.u8RTCDayOfMonth = 1;
	g_stRTCInformation.u8RTCMonth = 1;   
	g_stRTCInformation.u8RTCYear = 20; 
    RTE_RTC_Init(g_stRTCInformation);
    RTE_DEEPSLEEP_GPIO_Interrupt_Enable(WAKEUP_KL15_In,Trigger_Rising);

}
extern uint32_t PowerIgnOffTimeLine;
static void Power_Wakeup_Init(void)
{
    PowerIgnOffTimeLine = 0;
    Simulated_IIC_2_Init();
    Gpio_Init(Gpio_WakeUp_Init);
    Can_Init();
    CAN_TX_SetEnable(&CAN_CH0_CanMsgTxOp, CAN_N_TX_Enable);
    eeprom_StoreInfo_Init();
    Analog_Signal_Conv_Init();
    Data_User_Mileage_WakeupInit();
    BU98R10_Init();    
    Sys_WakeUp_Init();
    Data_Vehicle_Speed_KL30_Init();
    Data_Vehicle_Speed_Wakeup_Init();
    Data_Engine_Speed_KL30_Wakeup_Init();
    LINE_IN_Init();
    Key_KL30_Init_EXample();
    Line_In_KL15_ON_Init();
    MenuData_TCS_Init();
    //Light_Sensor_Init_Example();//注意顺序1
    LED_Driver_Init_Example();//注意顺序2
    Protocol_KL30_Wakeup_Init();
    Uart0_Init(115200);
    BlueTooth_KL30_KL15_Wakeup_Init();
    Fuel_KL30_Init();
    Data_Voltage_Init();
    TimerM_PWM_counter_Output_Init(TIMERM_COUNTER0, 400, 64000000);
    TimerM_PWM_counter_Output_Init(TIMERM_COUNTER1, 400, 64000000);
//	  TimerM_PWM_counter_Output_Init(TIMERM_COUNTER0, 400);
//    TimerM_PWM_counter_Output_Init(TIMERM_COUNTER1, 400);
    TimerM_PWM_CH_Output_init(TIMERM_COUNTER0, TIMERM_CHB, ActiveLevel_High);
    TimerM_PWM_CH_Output_init(TIMERM_COUNTER0, TIMERM_CHC, ActiveLevel_High);
    TimerM_PWM_CH_Output_init(TIMERM_COUNTER0, TIMERM_CHD, ActiveLevel_High);
    TimerM_PWM_CH_Output_init(TIMERM_COUNTER1, TIMERM_CHB, ActiveLevel_High);
    Telltales_Init();
    Telltales_UserInit();
    RTE_DEEPSLEEP_GPIO_Interrupt_Enable(WAKEUP_KL15_In,Trigger_Rising);
}

static void Power_LVP_Init(void)
{
    
}
static void Power_OVP_Init(void)
{
    
}

static void Power_IG_OFF_Init(void)
{
    Line_In_KL15_OFF_Init();
    Checkself_Init();
    CAN_TX_SetEnable(&CAN_CH0_CanMsgTxOp, CAN_N_TX_Disable);
}

static void Power_IG_ON_Init(void)
{       
    Checkself_Init();
    Line_In_KL15_ON_Init();
    Telltales_KL15_Init();
    Telltales_UserInit();
    Fuel_KL15_Init();
    Data_Voltage_Init();
    MenuData_TCS_Init();
    Data_Coolant_Temp_KL15_Init();
    BlueTooth_KL30_KL15_Wakeup_Init();    
    CAN_TX_SetEnable(&CAN_CH0_CanMsgTxOp, CAN_N_TX_Enable);
}

static void Power_Sleep_Init(void)
{
    TimerM_PWM_counter_Output_Init(TIMERM_COUNTER0, 400, 0);
    TimerM_PWM_counter_Output_Init(TIMERM_COUNTER1, 400, 0);
	//TimerM_PWM_CH_Output_init(TIMERM_COUNTER0, TIMERM_CHB, ActiveLevel_High);
    //TimerM_PWM_CH_Output_init(TIMERM_COUNTER0, TIMERM_CHC, ActiveLevel_High);
    //TimerM_PWM_CH_Output_init(TIMERM_COUNTER0, TIMERM_CHD, ActiveLevel_High);
    //TimerM_PWM_CH_Output_init(TIMERM_COUNTER1, TIMERM_CHB, ActiveLevel_High);
	//RTC_Stop();
	rte_can_deinit(CAN_CH_0);
	TMM0_Stop();
	TMM1_Stop();
    TMM_All_Stop();
    RTE_ADC_DeInit();
	//CGC->CSC = 1 ;   //HIOSTOP = 1
	BU98R10_Shutdown();
    Gpio_Init(Gpio_Sleep_Init);
    u8LEDDriverCheckCount = 0;
    LED_Driver_Service_Immediate();
    LED_Driver_Init_Sleep();
    LED_Driver_Service();
    Analog_Signal_Conv_Stop();
    RTE_DEEPSLEEP_Enable();
}

static Power_Status_em Power_Stay_ON(void)
{
    Power_Status_em u8PowerSts;
    u8PowerSts = EM_IGN_ON;

    if (SYS_OPR_STAT_IGN_OFF)
    {
        u8PowerSts = EM_IGN_OFF_Init;
    }

    if (SYS_OPR_STAT_HALT)
    {
        u8PowerSts = EM_IGN_LIMIT;
    }

    return u8PowerSts;
}
static Power_Status_em Power_Stay_OFF(void)
{
    Power_Status_em u8PowerSts;
    u8PowerSts = EM_IGN_OFF;

    if (SYS_OPR_STAT_IGN_ON)
    {
        u8PowerSts = EM_IGN_ON_Init;
    }
    else
    {
        if ((Common_GetIgnOffTime() < 20000))
        {
            u8PowerSts = EM_IGN_OFF;
        }
        else
        {
            u8PowerSts = EM_IGN_Sleep_Init;
        }
    }

    return u8PowerSts;
}

static Power_Status_em Power_Stay_Protect(void)
{
    Power_Status_em u8PowerSts;
    static uint8_t  i;
    static uint8_t  Delaycnt;
    static uint8_t LED;
    static uint8_t LEDDriverCheckCount = 0U;
    /* 关闭所有外设，坪保留AD采集，电溝状思切�? */
    {
        BU98R10_Shutdown( );
        TimerM_PWM_set_duty(TIMERM_COUNTER1, TIMERM_CHB, 0);
        CAN_TX_SetEnable(&CAN_CH0_CanMsgTxOp, CAN_N_TX_Disable);
    }
    u8PowerSts = EM_IGN_OFF_Init;
    /* 电溝模弝正常 */
    for ( ;; )
    {
        RTE_WDT_Clear();
        Gen_TimeDelay(2000u, 50u);
        for(LED = 0u; LED < LampCh0_MAX; LED++)
        {
            LED_Driver_Channel_Set(0u, LED, 0u);
        }

        for ( i = 0; i < LED_Max; i++ )
        {
            Telltales_DiagCtrl(i, 0x00u);
        }
        LED_Driver_Service( );
        Analog_Signal_Conv_Service();
        Sys_Status_Update_Service();

        Delaycnt++;
        if ( Delaycnt >= 5u )
        {
            Delaycnt = 0u;
            LED_Driver_Scan_Refresh( );
            if ( LEDDriverCheckCount >= 10U )
            {
                LEDDriverCheckCount = 0U;
                LED_Driver_Work_Check( );
            }
            else
            {
                LEDDriverCheckCount++;
            }
        }

        if ( SYS_OPR_STAT_RUN )
        {
            for ( i = 0; i < LED_Max; i++ )
            {
                Telltales_DiagRelease(i);
            }
            BU98R10_Init( );
            CAN_TX_SetEnable(&CAN_CH0_CanMsgTxOp, CAN_N_TX_Enable);
            return u8PowerSts;
        }
    }
}

static Power_Status_em Power_Stay_Sleep(void)
{
    Power_Status_em u8PowerSts = EM_IGN_Sleep;

    while (1)
    {
        RTE_WDT_Clear();
        if (RTE_GPIO_Get_Level(WAKEUP_KL15_In))/* KL15 */
        {
            u8PowerSts = EM_IGN_Wakeup;
            break;
        }
    }

    return u8PowerSts;
}


void Sys_Startup_Init(void)
{
    uint8_t u8StartuoMode = 0;
    PwrMemInit( );
    Power_Management_Init(u8StartuoMode);
}

