
#include "Key\Key_user.h"
#include "Application.h"
#include "Components.h"
__align(4)

#define BACK_MENU_TIME		1500
_Menu_Infor MenuInfor;
_Menu_Data MenuData;
uint8_t PageType = 0;
uint8_t PageMenu = 0;


RTC_TimeTypeDef RTC_TimeStruct;
RTC_DateTypeDef RTC_DateStruct;
RTC_CounterTypeDef counter_val;

void Key_Operation_Left(Key_Event_en_t enKeyEvent)//Mode
{
	switch (enKeyEvent)
	{
	case KEY_EVENT_SHORT_PRESS_1://1s
		if (Common_GetIgnOnTime() >= 3000)
		{
			Key_Left_Short_Press();
		}
		
		break;
	case KEY_EVENT_SHORT_PRESS_2://3-5s	
		if (Common_GetIgnOnTime() >= 3000)
		{
			Key_Left_Long_Press();
		}
		
		break;
	case KEY_EVENT_LONG_PRESS_1:	//7
		break;
	case KEY_EVENT_LONG_PRESS_2:	//8
		break;
	case KEY_EVENT_LONG_PRESS_3:	//9s
		break;
	case KEY_EVENT_LONG_PRESS_4:	//10s
		if (Common_GetIgnOnTime() >= 3000)
		{
			Maintain_Reset_Service();

			if((PageMenu == Page_TCS) && (PageType == Page_Menu))
			{
				if(Get_Dis_Tcs_Val() == 0)
				{
					MenuData.Tcs_Val = 1;//on
				}
				else
				{
					MenuData.Tcs_Val = 0;//off
				}
			}
	
			if((PageMenu == Page_Trip) && (PageType == Page_Menu))
			{
				Data_Clear_Trip_All();
			}
	
			TYW_RESET_ODO();
		}
		
		break;
	case KEY_EVENT_OFF_TO_ON:		
		break;
	case KEY_EVENT_ON_TO_OFF:
		break;
	case KEY_EVENT_NONE:
	    KEY_LEFT_EVENT_NONE_Service();
		break;
	default:
		break;
	}
}
void Key_Operation_Right(Key_Event_en_t enKeyEvent)//Set
{
	switch (enKeyEvent)
	{
	case KEY_EVENT_SHORT_PRESS_1:	
		break;
	case KEY_EVENT_SHORT_PRESS_2:		
		break;
	case KEY_EVENT_LONG_PRESS_1:	
		break;
	case KEY_EVENT_LONG_PRESS_2:	
		break;
	case KEY_EVENT_LONG_PRESS_3:	
		break;
	case KEY_EVENT_LONG_PRESS_4:	
		break;
	case KEY_EVENT_OFF_TO_ON:		
		break;
	case KEY_EVENT_ON_TO_OFF:
		break;
	case KEY_EVENT_NONE:
		break;
	default:		
		break;
	}
}


/*---------------------------------------------------------------------------------------*/
Key_Status_en_t Key_Status_Read_Left(void)
{
	Key_Status_en_t enKeyReal = KEY_REALTIME_LOOSEN;
	if (RTE_GPIO_Get_Level(Key_MCU_IN))
	{
		enKeyReal = KEY_REALTIME_LOOSEN;
	}
	else
	{
		enKeyReal = KEY_REALTIME_PRESS;
	}
	return enKeyReal;
}
Key_Status_en_t Key_Status_Read_Right(void)
{
	Key_Status_en_t enKeyReal = KEY_REALTIME_LOOSEN;
	// if (SYS_OPR_STAT_IGN_ON)
	// {
	// 	if (RTE_GPIO_Get_Level(SET_P_IN))
	// 	{
	// 		enKeyReal = KEY_REALTIME_LOOSEN;
	// 	}
	// 	else
	// 	{
	// 		enKeyReal = KEY_REALTIME_PRESS;
	// 	}
	// }
	return enKeyReal;
}


/*---------------------------------------------------------------------------------------*/
const Key_Attribute_st_t stKeyAttribute[KEY_NUM_MAX] =
{
	{KEY_NEED_DEBOUNCE_NORMAL, Key_Status_Read_Left, Key_Operation_Left},
	//{KEY_NEED_DEBOUNCE_NORMAL, Key_Status_Read_Right, Key_Operation_Right},
	//{KEY_NEED_DEBOUNCE_NORMAL, Key_Status_Read_FLIP, Key_Operation_FLIP},
	//{KEY_NEED_DEBOUNCE_NORMAL, Key_Status_Read_ADJUST, Key_Operation_ADJUST},
};

/*---------------------------------------------------------------------------------------*/

Key_uint8_t u8KeyRamData[KEY_RAM_DATA_LEN];
void Key_KL30_Init_EXample(void)
{
	Key_Init_st_t stKeyInitTem;
	Key_uint16_t i;
	for (i = 0; i < KEY_RAM_DATA_LEN; i++)
	{
		u8KeyRamData[i] = 0;
	}

	stKeyInitTem.u8KeyNum = KEY_NUM_MAX;
	stKeyInitTem.enKeyIGNRealStatus = KEY_IG_OFF;
	Key_KL30_Init(&u8KeyRamData[0], stKeyAttribute, &stKeyInitTem);

	Key_Parameter_Set_Short_Press_1_Time(50U,1000U);
	Key_Parameter_Set_Short_Press_2_Time(3000U,9000U);

	Key_Parameter_Set_Long_Press_1_Time(9100U);
	Key_Parameter_Set_Long_Press_2_Time(9200U);
	Key_Parameter_Set_Long_Press_3_Time(9300U);
	Key_Parameter_Set_Long_Press_4_Time(10000U);	
}
void Key_Wakeup_Init_EXample(void)
{
	Key_Init_st_t stKeyInitTem;

	stKeyInitTem.u8KeyNum = KEY_NUM_MAX;
	stKeyInitTem.enKeyIGNRealStatus = KEY_IG_OFF; 
	Key_Wakeup_Init(&u8KeyRamData[0], stKeyAttribute, &stKeyInitTem);

	Key_Parameter_Set_Short_Press_1_Time(50U,1000U);
	Key_Parameter_Set_Short_Press_2_Time(3000U,9000U);
	
	//Key_Parameter_Set_Long_Press_1_Time(7000U);
	//Key_Parameter_Set_Long_Press_2_Time(8000U);
	//Key_Parameter_Set_Long_Press_3_Time(9000U);
	Key_Parameter_Set_Long_Press_4_Time(10000U);
}


void KEY_LEFT_EVENT_NONE_Service(void)	
{
	MenuInfor.Back_Time_Left++;
	if((MenuInfor.Back_Time_Left > BACK_MENU_TIME) &&(PageType != Page_Menu))
	{
		MenuInfor.Back_Time_Left = BACK_MENU_TIME;
		MenuInfor.Back_Time_Left_Flag = 1;
	}
}



void Key_Clear_Time(void)
{
	if(Key_Status_Read_Left() == KEY_REALTIME_PRESS)
	{
		MenuInfor.Back_Time_Left = 0;
		MenuInfor.Back_Time_Left_Flag = 0;
	}
}

void Key_Check_Service(void)
{

}

void Key_Left_Short_Press(void)
{
	uint8_t updataDir = 0u;
	uint8_t datmax = 0u;
	uint8_t datmin = 0u;


	if(PageType == Page_Menu)
	{
		if(PageMenu == Page_Odo)
		{
			PageMenu = Page_Trip;
		}
		else if(PageMenu == Page_Trip)
		{
			PageMenu = Page_DTC;
		}
		else if(PageMenu == Page_DTC)
		{
			PageMenu = Page_TCS;
		}
		else if(PageMenu == Page_TCS)
		{
			PageMenu = Page_Odo;
		}
	}
	

	if(PageType == Page_Time_Hour)
	{
		updataDir = 1;
		datmax = 23u;
    	datmin = 0u; 
		Menu_u8Data_Updata_Process(updataDir, datmax, datmin, 1u, (uint8_t*)&(counter_val.time.RTC_Hours));
		//RTC_SetTime(&counter_val.time);
	}
	else if(PageType == Page_Time_Minute)
	{
		updataDir = 1;
		datmax = 59u;
    	datmin = 0u; 
		Menu_u8Data_Updata_Process(updataDir, datmax, datmin, 1u, (uint8_t*)&(counter_val.time.RTC_Minutes));
		//RTC_SetTime(&counter_val.time);
		
	}
	else if(PageType == Page_Km_Unit)
	{	
		
		if(Get_Dis_KM_Unit() == 0)
		{
			MenuData.KM_Unit = 1;//mile
		}
		else
		{
			MenuData.KM_Unit = 0;//km
		}
		Unit_Convert_Service();
	}
	else if(PageType == Page_Tpms_Unit)
	{
		if(Get_Dis_Tpms_Unit() == 0)
		{
			MenuData.Tpms_Unit = 1;//psi
		}
		else
		{
			MenuData.Tpms_Unit = 0;//bar
		}
		Unit_Convert_Service();
	}
	else
	{
		;
	}
}

void Key_Auto_Save(void)
{
	if((MenuInfor.Back_Time_Left_Flag == 1))
	{
		if(PageType == Page_Time_Hour)
		{
			RTC_SetTime(&counter_val.time);
		}

		if(PageType == Page_Time_Minute)
		{
			RTC_SetTime(&counter_val.time);
		}
		PageType = Page_Menu ;
	}
}


void Key_Left_Long_Press(void)
{
	if((PageType == Page_Menu) )
	{
		PageType = Page_Time_Hour;
	}
	else if(PageType == Page_Time_Hour)
	{
		RTC_SetTime(&counter_val.time);
		PageType = Page_Time_Minute;
	}
	else if(PageType == Page_Time_Minute)
	{
		RTC_SetTime(&counter_val.time);
		PageType = Page_Km_Unit;
	}
	else if(PageType == Page_Km_Unit)
	{
		PageType = Page_Tpms_Unit;
	}
	else if(PageType == Page_Tpms_Unit)
	{
		PageType = Page_Menu;
	}
	else
	{
		;
	}

	
}



void Menu_u8Data_Updata_Process(uint8_t updateDir , uint8_t datMax, uint8_t datMin, uint8_t datStep, uint8_t *dat)
{
	uint8_t temp = *dat;
    if(datMax > datMin)
    {
        if(updateDir == 1u)
        {
            if(temp < datMax)
            {
                if((temp) <= (255u-datStep))
                {
                    temp += datStep;
                }
            } 
            else
            {
                temp = datMin;
            }        
        }
        else if(updateDir == 2u)
        {
            if(temp > datMin)
            {
                if(temp >= datStep)
                {
                    temp -= datStep;
                }
            } 
            else
            {
                temp = datMax;
            }
        }
        else
        {
        }
    }
    else
    {
    }

	*dat = temp;
}

void MenuData_Unit_Init(void)
{
	MenuData.KM_Unit = 0;
	MenuData.Tpms_Unit = 0;
	MenuData.Tcs_Val = 1;
	
}
void MenuData_TCS_Init(void)
{	
	MenuData.Tcs_Val = 1;	
	PageType = Page_Menu;
}

uint8_t ClearODO_Flag = 0;
void TYW_RESET_ODO(void)
{
	uint8_t Clear_EE[1] = {0xff};
	uint32_t EE_Count = 0U;
	if(SYS_OPR_STAT_IGN_ON)
    {
        if(ClearODO_Flag < 1)
        {
            if((Get_DispVechileSpeed() >= 1990)&&(Get_DispEngineSpeed() >= 12000))
            {
                ClearODO_Flag = 1;
                Data_Mileage_Clear();
				for(EE_Count = 0 ; EE_Count < 255; EE_Count++)
      			{
      			    eeprom_WriteRecord(EE_Count, ( uint8_t * )&Clear_EE, 1);
      			}
            }
        }
    }
    
}

void Maintain_Reset_Service(void)
{
	if((Get_Data_Maintenace_Interval_Processing() == 0) && (PageMenu == Page_TCS) && (PageType == Page_Menu))
	{
		Data_Maintenance_Interval_Reset();
	}
}

uint8_t Get_Dis_Hour_Time(void)
{
	return counter_val.time.RTC_Hours;
}

uint8_t Get_Dis_Minute_Time(void)
{
	return counter_val.time.RTC_Minutes;
}

uint8_t Get_Current_PageType(void)
{
	return PageType;
}
uint8_t Get_Current_PageMenu(void)
{
	return PageMenu;
}

uint8_t Get_Dis_KM_Unit(void)
{
	return MenuData.KM_Unit; //0km,1mile
}

uint8_t Get_Dis_Tpms_Unit(void)
{
	return MenuData.Tpms_Unit; //0bar,1psi
}

uint8_t Get_Dis_Tcs_Val(void)
{
	return MenuData.Tcs_Val; // 0 off, 1 on
}