
#include "Components.h"
#include "BAT32A239.h"
#include <string.h>
#include <stdio.h>


#define BU98R10_CHIP0_SD  RTE_GPIO_PORT00_PIN02
#define BU98R10_CHIP0_CSB RTE_GPIO_PORT00_PIN03
#define BU98R10_CHIP0_SCL RTE_GPIO_PORT00_PIN04
#define BU98R10_CHIP1_SD  RTE_GPIO_PORT07_PIN02
#define BU98R10_CHIP1_CSB RTE_GPIO_PORT07_PIN01
#define BU98R10_CHIP1_SCL RTE_GPIO_PORT07_PIN00

#define BU98R10_NOP_TIME  5U

uint8_t BU98R10_CHIP0_GET_SD_LEVEL(void);
uint8_t BU98R10_CHIP0_GET_SD_LEVEL(void)
{
	return RTE_GPIO_Get_Level(BU98R10_CHIP0_SD);
}
uint8_t BU98R10_CHIP1_GET_SD_LEVEL(void);
uint8_t BU98R10_CHIP1_GET_SD_LEVEL(void)
{
	return RTE_GPIO_Get_Level(BU98R10_CHIP1_SD);
}

void NOP_DelayTime(uint8_t timer)
{
	// uint8_t i = 0;
	// for(i = 0;i < timer;i++)
	// {
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
		__NOP();
	// }
}

void BU98R10_CHIP0_SET_SD_LEVEL(uint8_t Level);
void BU98R10_CHIP0_SET_SD_LEVEL(uint8_t Level)
{
	if (Level)
	{
		//RTE_GPIO_Config(BU98R10_CHIP0_SD, RTE_GPIO_DIR_OUT | RTE_GPIO_LEVEL_HIGH);
		//RTE_GPIO_Set_Level(BU98R10_CHIP0_SD, RTE_GPIO_LEVEL_HIGH);
		//PORT->P0 |= (1<<2);
		//PORT->PM0 &= ~(1<<2);

		PORT->PM0 &= ~(1<<2);
		PORT->PSET0 = (1<<2);
		NOP_DelayTime(BU98R10_NOP_TIME);
	}
	else
	{
		//RTE_GPIO_Config(BU98R10_CHIP0_SD, RTE_GPIO_DIR_OUT | RTE_GPIO_LEVEL_LOW);
		//RTE_GPIO_Set_Level(BU98R10_CHIP0_SD, RTE_GPIO_LEVEL_LOW);
		// PORT->P0 &= ~(1<<2);//P02
		// PORT->PM0 &= ~(1<<2); 
		PORT->PM0 &= ~(1<<2);
		PORT->PCLR0 = (1<<2);
		NOP_DelayTime(BU98R10_NOP_TIME);
	}
}
void BU98R10_CHIP1_SET_SD_LEVEL(uint8_t Level);
void BU98R10_CHIP1_SET_SD_LEVEL(uint8_t Level)
{
	if (Level)
	{
		//RTE_GPIO_Config(BU98R10_CHIP1_SD, RTE_GPIO_DIR_OUT | RTE_GPIO_LEVEL_HIGH);
		//RTE_GPIO_Set_Level(BU98R10_CHIP1_SD, RTE_GPIO_LEVEL_HIGH);
		// PORT->P7 |= (1<<2);
		// PORT->PM7 &= ~(1<<2); 
		PORT->PM7 &= ~(1<<2);
		PORT->PSET7 = (1<<2);
		NOP_DelayTime(BU98R10_NOP_TIME);
	}
	else
	{
		//RTE_GPIO_Config(BU98R10_CHIP1_SD, RTE_GPIO_DIR_OUT | RTE_GPIO_LEVEL_LOW);
		//RTE_GPIO_Set_Level(BU98R10_CHIP1_SD, RTE_GPIO_LEVEL_LOW);
		// PORT->P7 &= ~(1<<2);//P72
		// PORT->PM7 &= ~(1<<2);
		PORT->PM7 &= ~(1<<2);
		PORT->PCLR7 = (1<<2);
		NOP_DelayTime(BU98R10_NOP_TIME);
	}
}
void BU98R10_CHIP0_SET_CSB_LEVEL(uint8_t Level);
void BU98R10_CHIP0_SET_CSB_LEVEL(uint8_t Level)
{
	if (Level)
	{
		// RTE_GPIO_Config(BU98R10_CHIP0_CSB, RTE_GPIO_DIR_OUT | RTE_GPIO_LEVEL_HIGH);
		//RTE_GPIO_Set_Level(BU98R10_CHIP0_CSB, RTE_GPIO_LEVEL_HIGH);
		// PORT->P0 |= (1<<3);
		// PORT->PM0 &= ~(1<<3); 
		PORT->PM0 &= ~(1<<3);
		PORT->PSET0 = (1<<3);
		NOP_DelayTime(BU98R10_NOP_TIME);
	}
	else
	{
		// RTE_GPIO_Config(BU98R10_CHIP0_CSB, RTE_GPIO_DIR_OUT | RTE_GPIO_LEVEL_LOW);
		//RTE_GPIO_Set_Level(BU98R10_CHIP0_CSB, RTE_GPIO_LEVEL_LOW);
		// PORT->P0 &= ~(1<<3);//P03
		// PORT->PM0 &= ~(1<<3); 
		PORT->PM0 &= ~(1<<3);
		PORT->PCLR0 = (1<<3);
		NOP_DelayTime(BU98R10_NOP_TIME);
	}
}
void BU98R10_CHIP1_SET_CSB_LEVEL(uint8_t Level);
void BU98R10_CHIP1_SET_CSB_LEVEL(uint8_t Level)
{
	if (Level)
	{
		// RTE_GPIO_Config(BU98R10_CHIP1_CSB, RTE_GPIO_DIR_OUT | RTE_GPIO_LEVEL_HIGH);
		//RTE_GPIO_Set_Level(BU98R10_CHIP1_CSB, RTE_GPIO_LEVEL_HIGH);
		// PORT->P7 |= (1<<1);
		// PORT->PM7 &= ~(1<<1);
		PORT->PM7 &= ~(1<<1);
		PORT->PSET7 = (1<<1);
		NOP_DelayTime(BU98R10_NOP_TIME);
	}
	else
	{
		//RTE_GPIO_Config(BU98R10_CHIP1_CSB, RTE_GPIO_DIR_OUT | RTE_GPIO_LEVEL_LOW);
		//RTE_GPIO_Set_Level(BU98R10_CHIP1_CSB, RTE_GPIO_LEVEL_LOW);
		// PORT->P7 &= ~(1<<1);//P71
		// PORT->PM7 &= ~(1<<1);
		PORT->PM7 &= ~(1<<1);
		PORT->PCLR7 = (1<<1);
		NOP_DelayTime(BU98R10_NOP_TIME);
	}
}
void BU98R10_CHIP0_SET_SCL_LEVEL(uint8_t Level);
void BU98R10_CHIP0_SET_SCL_LEVEL(uint8_t Level)
{
	if (Level)
	{
		//RTE_GPIO_Config(BU98R10_CHIP0_SCL, RTE_GPIO_DIR_OUT | RTE_GPIO_LEVEL_HIGH);
		//RTE_GPIO_Set_Level(BU98R10_CHIP0_SCL, RTE_GPIO_LEVEL_HIGH);
		// PORT->P0 |= (1<<4);
		// PORT->PM0 &= ~(1<<4); 
		PORT->PM0 &= ~(1<<4);
		PORT->PSET0 = (1<<4);
		NOP_DelayTime(BU98R10_NOP_TIME); 
	}
	else
	{
		//RTE_GPIO_Config(BU98R10_CHIP0_SCL, RTE_GPIO_DIR_OUT | RTE_GPIO_LEVEL_LOW);
		//RTE_GPIO_Set_Level(BU98R10_CHIP0_SCL, RTE_GPIO_LEVEL_LOW);
		// PORT->P0 &= ~(1<<4);//P04
		// PORT->PM0 &= ~(1<<4); 
		PORT->PM0 &= ~(1<<4);
		PORT->PCLR0 = (1<<4);
		NOP_DelayTime(BU98R10_NOP_TIME);
	}
}
void BU98R10_CHIP1_SET_SCL_LEVEL(uint8_t Level);
void BU98R10_CHIP1_SET_SCL_LEVEL(uint8_t Level)
{
	if (Level)
	{
		 //RTE_GPIO_Config(BU98R10_CHIP1_SCL, RTE_GPIO_DIR_OUT | RTE_GPIO_LEVEL_HIGH);
		//RTE_GPIO_Set_Level(BU98R10_CHIP1_SCL, RTE_GPIO_LEVEL_HIGH);
		// PORT->P7 |= (1<<0);
		// PORT->PM7 &= ~(1<<0); 
		PORT->PM7 &= ~(1<<0);
		PORT->PSET7 = (1<<0);
		NOP_DelayTime(BU98R10_NOP_TIME);
	}
	else
	{
		//RTE_GPIO_Config(BU98R10_CHIP1_SCL, RTE_GPIO_DIR_OUT | RTE_GPIO_LEVEL_LOW);
		//RTE_GPIO_Set_Level(BU98R10_CHIP1_SCL, RTE_GPIO_LEVEL_LOW);
		// PORT->P7 &= ~(1<<0);//P70
		// PORT->PM7 &= ~(1<<0); 
		PORT->PM7 &= ~(1<<0);
		PORT->PCLR7 = (1<<0);
		NOP_DelayTime(BU98R10_NOP_TIME);
	}
}
void BU98R10_CHIP0_SET_SD_DIR(uint8_t Dir);
void BU98R10_CHIP0_SET_SD_DIR(uint8_t Dir)
{
	if (Dir)
	{
		//RTE_GPIO_Set_Level(BU98R10_CHIP0_SD, RTE_GPIO_LEVEL_HIGH);
		// PORT->P0 |= (1<<2);
		// PORT->PM0 &= ~(1<<2); 
		// RTE_GPIO_Config(BU98R10_CHIP0_SD, RTE_GPIO_DIR_OUT | RTE_GPIO_LEVEL_HIGH);
		PORT->PSET0 = (1<<2);
		NOP_DelayTime(BU98R10_NOP_TIME);
	}
	else
	{
		//RTE_GPIO_Config(BU98R10_CHIP0_SD, RTE_GPIO_DIR_IN);
		// PORT->PM0 |= (1<<2);
		PORT->PCLR0 = (1<<2);
		NOP_DelayTime(BU98R10_NOP_TIME);
	}
}
void BU98R10_CHIP1_SET_SD_DIR(uint8_t Dir);
void BU98R10_CHIP1_SET_SD_DIR(uint8_t Dir)
{
	if (Dir)
	{
		//RTE_GPIO_Set_Level(BU98R10_CHIP1_SD, RTE_GPIO_LEVEL_HIGH);
		 //RTE_GPIO_Config(BU98R10_CHIP1_SD, RTE_GPIO_DIR_OUT | RTE_GPIO_LEVEL_HIGH);
		// PORT->P7 |= (1<<2);
		// PORT->PM7 &= ~(1<<2);
		PORT->PSET7 = (1<<2);
		NOP_DelayTime(BU98R10_NOP_TIME); 
	}
	else
	{
		//RTE_GPIO_Config(BU98R10_CHIP1_SD, RTE_GPIO_DIR_IN);
		// PORT->PM7 |= (1<<2); 
		PORT->PCLR7 = (1<<2);
		NOP_DelayTime(BU98R10_NOP_TIME);
	}
}

#if USE_BU98R10_CHIP_0
volatile BU98R10DDRAMUnion BU98R10Chip0DDRAM;
BU98R10DDRAMUnion BU98R10Chip0DDRAMBackup;
#endif

#if USE_BU98R10_CHIP_1
volatile BU98R10DDRAMUnion BU98R10Chip1DDRAM;
BU98R10DDRAMUnion BU98R10Chip1DDRAMBackup;
#endif

BU98R10UpdateCtrlStruct BU98R10Update;

void BU98R10_Init(void)
{
	uint8_t i;

#if BU98R10_WRITE_AT_SAME_TIME
#if BU98R10_COLORFUL_LCD_MODE

	BU98R10_All_Command_Write(BU98R10_CMD_SWRST);

	Gen_TimeDelay(20*1000, 50U);

	BU98R10_All_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_RGB);

	BU98R10_All_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);

	BU98R10_All_Command_Write(BU98R10_CMD_FREQ);
	BU98R10_All_Data_Write(BU98R10_FRAME_FREQ, BU98R10_FRAME_FREQ);

	BU98R10_All_Command_Write(BU98R10_CMD_LED_CTRL);
	BU98R10_All_Data_Write(0x12, 0x12);

	BU98R10_All_Command_Write(BU98R10_CMD_SEG_R);
	BU98R10_All_Data_Write(BU98R10_REG_SEG_R, BU98R10_REG_SEG_R);

	BU98R10_All_Command_Write(BU98R10_CMD_SEG_G);
	BU98R10_All_Data_Write(BU98R10_REG_SEG_G, BU98R10_REG_SEG_G);

	BU98R10_All_Command_Write(BU98R10_CMD_SEG_B);
	BU98R10_All_Data_Write(BU98R10_REG_SEG_B, BU98R10_REG_SEG_B);

	BU98R10_All_Command_Write(BU98R10_CMD_LED_STARTR);
	BU98R10_All_Data_Write(BU98R10_LRS, BU98R10_LRS);

	BU98R10_All_Command_Write(BU98R10_CMD_LED_STARTG);
	BU98R10_All_Data_Write(BU98R10_LGS, BU98R10_LGS);

	BU98R10_All_Command_Write(BU98R10_CMD_LED_STARTB);
	BU98R10_All_Data_Write(BU98R10_LBS, BU98R10_LBS);

	BU98R10_All_Command_Write(BU98R10_CMD_LED_WIDTHR);
	BU98R10_All_Data_Write(BU98R10_LRW, BU98R10_LRW);

	BU98R10_All_Command_Write(BU98R10_CMD_LED_WIDTHG);
	BU98R10_All_Data_Write(BU98R10_LGW, BU98R10_LGW);

	BU98R10_All_Command_Write(BU98R10_CMD_LED_WIDTHB);
	BU98R10_All_Data_Write(BU98R10_LBW, BU98R10_LBW);

	BU98R10_All_Command_Write(BU98R10_CMD_ADSET);
	BU98R10_All_Data_Write(0x00, 0x00);

	BU98R10_All_Command_Write(BU98R10_CMD_DATWR);
	for (i = 0; i < 90; i++)
		BU98R10_All_Data_Write(BU98R10_DEFAULT_BYTE, BU98R10_DEFAULT_BYTE);

	for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
	{
		BU98R10Chip0DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
		BU98R10Chip0DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;

		BU98R10Chip1DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
		BU98R10Chip1DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
	}

	BU98R10_All_Command_Write(BU98R10_CMD_DISPON);

#else

	BU98R10_All_Command_Write(BU98R10_CMD_SWRST);

	BU98R10_All_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_MONO);

	BU98R10_All_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);

	BU98R10_All_Command_Write(BU98R10_CMD_FREQ);
	BU98R10_All_Data_Write(BU98R10_FRAME_FREQ, BU98R10_FRAME_FREQ);

	BU98R10_All_Command_Write(BU98R10_CMD_ADSET);
	BU98R10_All_Data_Write(0x00, 0x00);

	BU98R10_All_Command_Write(BU98R10_CMD_DATWR);
	for (i = 0; i < 90; i++)
		BU98R10_All_Data_Write(BU98R10_DEFAULT_BYTE, BU98R10_DEFAULT_BYTE);

	for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
	{
		BU98R10Chip0DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
		BU98R10Chip0DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;

		BU98R10Chip1DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
		BU98R10Chip1DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
	}

	BU98R10_All_Command_Write(BU98R10_CMD_DISPON);

#endif
#else
#if BU98R10_COLORFUL_LCD_MODE
#if USE_BU98R10_CHIP_0

	BU98R10_0_Command_Write(BU98R10_CMD_SWRST);

	BU98R10_0_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_RGB);

	BU98R10_0_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);

	BU98R10_0_Command_Write(BU98R10_CMD_FREQ);
	BU98R10_0_Data_Write(BU98R10_FRAME_FREQ);

	BU98R10_0_Command_Write(BU98R10_CMD_LED_CTRL);
	BU98R10_0_Data_Write(0x12);

	BU98R10_0_Command_Write(BU98R10_CMD_SEG_R);
	BU98R10_0_Data_Write(BU98R10_REG_SEG_R);

	BU98R10_0_Command_Write(BU98R10_CMD_SEG_G);
	BU98R10_0_Data_Write(BU98R10_REG_SEG_G);

	BU98R10_0_Command_Write(BU98R10_CMD_SEG_B);
	BU98R10_0_Data_Write(BU98R10_REG_SEG_B);

	BU98R10_0_Command_Write(BU98R10_CMD_LED_STARTR);
	BU98R10_0_Data_Write(BU98R10_LRS);

	BU98R10_0_Command_Write(BU98R10_CMD_LED_STARTG);
	BU98R10_0_Data_Write(BU98R10_LGS);

	BU98R10_0_Command_Write(BU98R10_CMD_LED_STARTB);
	BU98R10_0_Data_Write(BU98R10_LBS);

	BU98R10_0_Command_Write(BU98R10_CMD_LED_WIDTHR);
	BU98R10_0_Data_Write(BU98R10_LRW);

	BU98R10_0_Command_Write(BU98R10_CMD_LED_WIDTHG);
	BU98R10_0_Data_Write(BU98R10_LGW);

	BU98R10_0_Command_Write(BU98R10_CMD_LED_WIDTHB);
	BU98R10_0_Data_Write(BU98R10_LBW);

	BU98R10_0_Command_Write(BU98R10_CMD_ADSET);
	BU98R10_0_Data_Write(0x00);

	BU98R10_0_Command_Write(BU98R10_CMD_DATWR);
	for (i = 0; i < 90; i++)
		BU98R10_0_Data_Write(BU98R10_DEFAULT_BYTE);

	for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
	{
		BU98R10Chip0DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
		BU98R10Chip0DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
	}

	BU98R10_0_Command_Write(BU98R10_CMD_DISPON);

#endif
#if USE_BU98R10_CHIP_1

	BU98R10_1_Command_Write(BU98R10_CMD_SWRST);

	BU98R10_1_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_RGB);

	BU98R10_1_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);

	BU98R10_1_Command_Write(BU98R10_CMD_FREQ);
	BU98R10_1_Data_Write(BU98R10_FRAME_FREQ);

	BU98R10_1_Command_Write(BU98R10_CMD_LED_CTRL);
	BU98R10_1_Data_Write(0x12);

	BU98R10_1_Command_Write(BU98R10_CMD_SEG_R);
	BU98R10_1_Data_Write(BU98R10_REG_SEG_R);

	BU98R10_1_Command_Write(BU98R10_CMD_SEG_G);
	BU98R10_1_Data_Write(BU98R10_REG_SEG_G);

	BU98R10_1_Command_Write(BU98R10_CMD_SEG_B);
	BU98R10_1_Data_Write(BU98R10_REG_SEG_B);

	BU98R10_1_Command_Write(BU98R10_CMD_LED_STARTR);
	BU98R10_1_Data_Write(BU98R10_LRS);

	BU98R10_1_Command_Write(BU98R10_CMD_LED_STARTG);
	BU98R10_1_Data_Write(BU98R10_LGS);

	BU98R10_1_Command_Write(BU98R10_CMD_LED_STARTB);
	BU98R10_1_Data_Write(BU98R10_LBS);

	BU98R10_1_Command_Write(BU98R10_CMD_LED_WIDTHR);
	BU98R10_1_Data_Write(BU98R10_LRW);

	BU98R10_1_Command_Write(BU98R10_CMD_LED_WIDTHG);
	BU98R10_1_Data_Write(BU98R10_LGW);

	BU98R10_1_Command_Write(BU98R10_CMD_LED_WIDTHB);
	BU98R10_1_Data_Write(BU98R10_LBW);

	BU98R10_1_Command_Write(BU98R10_CMD_ADSET);
	BU98R10_1_Data_Write(0x00);

	BU98R10_1_Command_Write(BU98R10_CMD_DATWR);
	for (i = 0; i < 90; i++)
		BU98R10_1_Data_Write(BU98R10_DEFAULT_BYTE);

	for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
	{
		BU98R10Chip1DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
		BU98R10Chip1DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
	}

	BU98R10_1_Command_Write(BU98R10_CMD_DISPON);

#endif
#else
#if USE_BU98R10_CHIP_0

	BU98R10_0_Command_Write(BU98R10_CMD_SWRST);

	BU98R10_0_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_MONO);

	BU98R10_0_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);

	BU98R10_0_Command_Write(BU98R10_CMD_FREQ);
	BU98R10_0_Data_Write(BU98R10_FRAME_FREQ);

	BU98R10_0_Command_Write(BU98R10_CMD_ADSET);
	BU98R10_0_Data_Write(0x00);

	BU98R10_0_Command_Write(BU98R10_CMD_DATWR);
	for (i = 0; i < 90; i++)
		BU98R10_0_Data_Write(BU98R10_DEFAULT_BYTE);

	for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
	{
		BU98R10Chip0DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
		BU98R10Chip0DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
	}

	BU98R10_0_Command_Write(BU98R10_CMD_DISPON);

#endif
#if USE_BU98R10_CHIP_1

	BU98R10_1_Command_Write(BU98R10_CMD_SWRST);

	BU98R10_1_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_MONO);

	BU98R10_1_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);

	BU98R10_1_Command_Write(BU98R10_CMD_FREQ);
	BU98R10_1_Data_Write(BU98R10_FRAME_FREQ);

	BU98R10_1_Command_Write(BU98R10_CMD_ADSET);
	BU98R10_1_Data_Write(0x00);

	BU98R10_1_Command_Write(BU98R10_CMD_DATWR);
	for (i = 0; i < 90; i++)
		BU98R10_1_Data_Write(BU98R10_DEFAULT_BYTE);

	for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
	{
		BU98R10Chip1DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
		BU98R10Chip1DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
	}

	BU98R10_1_Command_Write(BU98R10_CMD_DISPON);

#endif
#endif
#endif

	BU98R10Update.En = 0;
	BU98R10Update.Step = 0;
	BU98R10Update.Cont = 0;
	BU98R10Update.Addr = 0;

#if USE_BU98R10_CHIP_0
	BU98R10Update.Chip = 0;
#elif USE_BU98R10_CHIP_1
	BU98R10Update.Chip = 1;
#else
	BU98R10Update.Chip = 255;
#endif
}

void BU98R10_Shutdown(void)
{
#if BU98R10_WRITE_AT_SAME_TIME
	BU98R10_All_Command_Write(BU98R10_CMD_DISPOFF);
#else
#if USE_BU98R10_CHIP_0
	BU98R10_0_Command_Write(BU98R10_CMD_DISPOFF);
#endif

#if USE_BU98R10_CHIP_1
	BU98R10_1_Command_Write(BU98R10_CMD_DISPOFF);
#endif
#endif
}

uint8_t u8BU98R10CheckCount = 0;
void BU98R10_Update_Request(void)
{
	// if (g_sysFlag.Bits.AccSaveState)
	//{
	//	//if (u8BU98R10CheckCount < 20)
	//	//{
	//	//	BU98R10Update.En = 1;
	//	//	u8BU98R10CheckCount++;
	//	//}
	//	BU98R10Update.En = 1;
	// }
	// else
	{

		u8BU98R10CheckCount = 0;
		BU98R10Update.En = 1;
	}

#if USE_BU98R10_CHIP_0
	BU98R10Update.Chip = 0;
#elif USE_BU98R10_CHIP_1
	BU98R10Update.Chip = 1;
#else
	BU98R10Update.Chip = 255;
#endif
}

void BU98R10_Update_Service(void)
{
	if (BU98R10Update.En)
	{
#if BU98R10_WRITE_AT_SAME_TIME

		switch (BU98R10Update.Step)
		{
		case 0:
			if ((BU98R10Chip0DDRAM.Byte[BU98R10Update.Addr] != BU98R10Chip0DDRAMBackup.Byte[BU98R10Update.Addr]) ||
				(BU98R10Chip1DDRAM.Byte[BU98R10Update.Addr] != BU98R10Chip1DDRAMBackup.Byte[BU98R10Update.Addr]))
			{
				BU98R10Chip0DDRAMBackup.Byte[BU98R10Update.Addr] = BU98R10Chip0DDRAM.Byte[BU98R10Update.Addr];
				BU98R10Chip1DDRAMBackup.Byte[BU98R10Update.Addr] = BU98R10Chip1DDRAM.Byte[BU98R10Update.Addr];

				if (BU98R10Update.Cont)
					BU98R10Update.Step = 4;
				else
					BU98R10Update.Step = 1;
			}
			else
			{
				BU98R10Update.Cont = 0;
				BU98R10Update.Addr++;
				if (BU98R10Update.Addr >= BU98R10_DDRAM_SIZE)
				{
					BU98R10Update.Addr = 0;
					BU98R10Update.En = 0;
				}
			}
			break;

		case 1:
			BU98R10_All_Command_Write(BU98R10_CMD_ADSET);
			BU98R10Update.Step = 2;
			break;

		case 2:
#if BU98R10_COLORFUL_LCD_MODE
			BU98R10_All_Data_Write(BU98R10Update.Addr, BU98R10Update.Addr);
#else
			BU98R10_All_Data_Write(BU98R10Update.Addr * 4, BU98R10Update.Addr * 4);
#endif
			BU98R10Update.Step = 3;
			break;

		case 3:
			BU98R10_All_Command_Write(BU98R10_CMD_DATWR);
			BU98R10Update.Step = 4;
			break;

		case 4:
			BU98R10_All_Data_Write(BU98R10Chip0DDRAMBackup.Byte[BU98R10Update.Addr], BU98R10Chip1DDRAMBackup.Byte[BU98R10Update.Addr]);
			BU98R10Update.Step = 5;
			break;

		case 5:
			BU98R10Update.Addr++;
			if (BU98R10Update.Addr >= BU98R10_DDRAM_SIZE)
			{
				BU98R10Update.Addr = 0;
				BU98R10Update.En = 0;
				BU98R10Update.Cont = 0;
			}
			else
				BU98R10Update.Cont = 1;

			BU98R10Update.Step = 0;
			break;

		default:
			BU98R10Update.En = 0;
			BU98R10Update.Step = 0;
			BU98R10Update.Cont = 0;
			BU98R10Update.Addr = 0;
			break;
		}

#else

#if USE_BU98R10_CHIP_0

		if (BU98R10Update.Chip == 0)
		{
			switch (BU98R10Update.Step)
			{
			case 0:
				if (BU98R10Chip0DDRAM.Byte[BU98R10Update.Addr] != BU98R10Chip0DDRAMBackup.Byte[BU98R10Update.Addr])
				{
					BU98R10Chip0DDRAMBackup.Byte[BU98R10Update.Addr] = BU98R10Chip0DDRAM.Byte[BU98R10Update.Addr];

					if (BU98R10Update.Cont)
						BU98R10Update.Step = 4;
					else
						BU98R10Update.Step = 1;
				}
				else
				{
					BU98R10Update.Cont = 0;
					BU98R10Update.Addr++;
					if (BU98R10Update.Addr >= BU98R10_DDRAM_SIZE)
					{
						BU98R10Update.Addr = 0;

#if USE_BU98R10_CHIP_1
						BU98R10Update.Chip = 1;
#else
						BU98R10Update.En = 0;
#endif
					}
				}
				break;

			case 1:
				BU98R10_0_Command_Write(BU98R10_CMD_ADSET);
				BU98R10Update.Step = 2;
				break;

			case 2:
#if BU98R10_COLORFUL_LCD_MODE
				BU98R10_0_Data_Write(BU98R10Update.Addr);
#else
				BU98R10_0_Data_Write(BU98R10Update.Addr * 4);
#endif
				BU98R10Update.Step = 3;
				break;

			case 3:
				BU98R10_0_Command_Write(BU98R10_CMD_DATWR);
				BU98R10Update.Step = 4;
				break;

			case 4:
				BU98R10_0_Data_Write(BU98R10Chip0DDRAMBackup.Byte[BU98R10Update.Addr]);
				BU98R10Update.Step = 5;
				break;

			case 5:
				BU98R10Update.Addr++;
				if (BU98R10Update.Addr >= BU98R10_DDRAM_SIZE)
				{
					BU98R10Update.Addr = 0;
					BU98R10Update.Cont = 0;

#if USE_BU98R10_CHIP_1
					BU98R10Update.Chip = 1;
#else
					BU98R10Update.En = 0;
#endif
				}
				else
					BU98R10Update.Cont = 1;

				BU98R10Update.Step = 0;
				break;

			default:
				BU98R10Update.En = 0;
				BU98R10Update.Step = 0;
				BU98R10Update.Cont = 0;
				BU98R10Update.Addr = 0;
				break;
			}
		}

#if USE_BU98R10_CHIP_1
		else if (BU98R10Update.Chip == 1)
#endif

#elif USE_BU98R10_CHIP_1
		if (BU98R10Update.Chip == 1)
#endif

#if USE_BU98R10_CHIP_1
		{
			switch (BU98R10Update.Step)
			{
			case 0:
				if (BU98R10Chip1DDRAM.Byte[BU98R10Update.Addr] != BU98R10Chip1DDRAMBackup.Byte[BU98R10Update.Addr])
				{
					BU98R10Chip1DDRAMBackup.Byte[BU98R10Update.Addr] = BU98R10Chip1DDRAM.Byte[BU98R10Update.Addr];

					if (BU98R10Update.Cont)
						BU98R10Update.Step = 4;
					else
						BU98R10Update.Step = 1;
				}
				else
				{
					BU98R10Update.Cont = 0;
					BU98R10Update.Addr++;
					if (BU98R10Update.Addr >= BU98R10_DDRAM_SIZE)
					{
						BU98R10Update.Addr = 0;
						BU98R10Update.En = 0;
					}
				}
				break;

			case 1:
				BU98R10_0_Command_Write(BU98R10_CMD_ADSET);
				BU98R10Update.Step = 2;
				break;

			case 2:
#if BU98R10_COLORFUL_LCD_MODE
				BU98R10_0_Data_Write(BU98R10Update.Addr);
#else
				BU98R10_0_Data_Write(BU98R10Update.Addr * 4);
#endif
				BU98R10Update.Step = 3;
				break;

			case 3:
				BU98R10_0_Command_Write(BU98R10_CMD_DATWR);
				BU98R10Update.Step = 4;
				break;

			case 4:
				BU98R10_0_Data_Write(BU98R10Chip1DDRAMBackup.Byte[BU98R10Update.Addr]);
				BU98R10Update.Step = 5;
				break;

			case 5:
				BU98R10Update.Addr++;
				if (BU98R10Update.Addr >= BU98R10_DDRAM_SIZE)
				{
					BU98R10Update.Addr = 0;
					BU98R10Update.Cont = 0;
					BU98R10Update.En = 0;
				}
				else
					BU98R10Update.Cont = 1;

				BU98R10Update.Step = 0;
				break;

			default:
				BU98R10Update.En = 0;
				BU98R10Update.Step = 0;
				BU98R10Update.Cont = 0;
				BU98R10Update.Addr = 0;
				break;
			}
		}
#endif

#if ((USE_BU98R10_CHIP_0) || (USE_BU98R10_CHIP_1))
		else
#endif
			BU98R10Update.En = 0;

#endif
	}
}

#if USE_BU98R10_CHIP_0

void BU98R10_0_Command_Write(uint8_t Cmd)
{
	uint8_t i;

	BU98R10_CHIP0_SET_SD_LEVEL(0);
	BU98R10_CHIP0_SET_SCL_LEVEL(0);
	BU98R10_CHIP0_SET_CSB_LEVEL(0);

	__NOP();
	__NOP();
	__NOP();

	BU98R10_CHIP0_SET_SCL_LEVEL(1);

	for (i = 0; i < 8; i++)
	{
		BU98R10_CHIP0_SET_SCL_LEVEL(0);

		if (Cmd & 0x80)
			BU98R10_CHIP0_SET_SD_LEVEL(1);
		else
			BU98R10_CHIP0_SET_SD_LEVEL(0);

		__NOP();
		__NOP();
		__NOP();

		BU98R10_CHIP0_SET_SCL_LEVEL(1);

		Cmd <<= 1;
	}

	BU98R10_CHIP0_SET_CSB_LEVEL(1);
}

void BU98R10_0_Data_Write(uint8_t Dat)
{
	uint8_t i;

	BU98R10_CHIP0_SET_SD_LEVEL(1);
	BU98R10_CHIP0_SET_SCL_LEVEL(0);
	BU98R10_CHIP0_SET_CSB_LEVEL(0);

	__NOP();
	__NOP();
	__NOP();

	BU98R10_CHIP0_SET_SCL_LEVEL(1);

	for (i = 0; i < 8; i++)
	{
		BU98R10_CHIP0_SET_SCL_LEVEL(0);

		if (Dat & 0x80)
			BU98R10_CHIP0_SET_SD_LEVEL(1);
		else
			BU98R10_CHIP0_SET_SD_LEVEL(0);

		__NOP();
		__NOP();
		__NOP();

		BU98R10_CHIP0_SET_SCL_LEVEL(1);

		Dat <<= 1;
	}

	BU98R10_CHIP0_SET_CSB_LEVEL(1);
}
#endif

#if USE_BU98R10_CHIP_1

void BU98R10_1_Command_Write(uint8_t Cmd)
{
	uint8_t i;

	BU98R10_CHIP1_SET_SD_LEVEL(0);
	BU98R10_CHIP1_SET_SCL_LEVEL(0);
	BU98R10_CHIP1_SET_CSB_LEVEL(0);

	__NOP();
	__NOP();
	__NOP();

	BU98R10_CHIP1_SET_SCL_LEVEL(1);

	for (i = 0; i < 8; i++)
	{
		BU98R10_CHIP1_SET_SCL_LEVEL(0);

		if (Cmd & 0x80)
			BU98R10_CHIP1_SET_SD_LEVEL(1);
		else
			BU98R10_CHIP1_SET_SD_LEVEL(0);

		__NOP();
		__NOP();
		__NOP();

		BU98R10_CHIP1_SET_SCL_LEVEL(1);

		Cmd <<= 1;
	}

	BU98R10_CHIP1_SET_CSB_LEVEL(1);
}

void BU98R10_1_Data_Write(uint8_t Dat)
{
	uint8_t i;

	BU98R10_CHIP1_SET_SD_LEVEL(1);
	BU98R10_CHIP1_SET_SCL_LEVEL(0);
	BU98R10_CHIP1_SET_CSB_LEVEL(0);

	__NOP();
	__NOP();
	__NOP();

	BU98R10_CHIP1_SET_SCL_LEVEL(1);

	for (i = 0; i < 8; i++)
	{
		BU98R10_CHIP1_SET_SCL_LEVEL(0);

		if (Dat & 0x80)
			BU98R10_CHIP1_SET_SD_LEVEL(1);
		else
			BU98R10_CHIP1_SET_SD_LEVEL(0);

		__NOP();
		__NOP();
		__NOP();

		BU98R10_CHIP1_SET_SCL_LEVEL(1);

		Dat <<= 1;
	}

	BU98R10_CHIP1_SET_CSB_LEVEL(1);
}

#endif

#if BU98R10_WRITE_AT_SAME_TIME

void BU98R10_All_Command_Write(uint8_t Cmd)
{
	uint8_t i;

	BU98R10_CHIP0_SET_SD_LEVEL(0);
	BU98R10_CHIP1_SET_SD_LEVEL(0);

	BU98R10_CHIP0_SET_SCL_LEVEL(0);
	BU98R10_CHIP1_SET_SCL_LEVEL(0);

	BU98R10_CHIP0_SET_CSB_LEVEL(0);
	BU98R10_CHIP1_SET_CSB_LEVEL(0);

	__NOP();

	BU98R10_CHIP0_SET_SCL_LEVEL(1);
	BU98R10_CHIP1_SET_SCL_LEVEL(1);

	for (i = 0; i < 8; i++)
	{
		BU98R10_CHIP0_SET_SCL_LEVEL(0);
		BU98R10_CHIP1_SET_SCL_LEVEL(0);

		if (Cmd & 0x80)
		{
			BU98R10_CHIP0_SET_SD_LEVEL(1);
			BU98R10_CHIP1_SET_SD_LEVEL(1);
		}
		else
		{
			BU98R10_CHIP0_SET_SD_LEVEL(0);
			BU98R10_CHIP1_SET_SD_LEVEL(0);
		}

		__NOP();

		BU98R10_CHIP0_SET_SCL_LEVEL(1);
		BU98R10_CHIP1_SET_SCL_LEVEL(1);

		Cmd <<= 1;
	}

	BU98R10_CHIP0_SET_CSB_LEVEL(1);
	BU98R10_CHIP1_SET_CSB_LEVEL(1);
}

void BU98R10_All_Data_Write(uint8_t Dat0, uint8_t Dat1)
{
	uint8_t i;

	BU98R10_CHIP0_SET_SD_LEVEL(1);
	BU98R10_CHIP1_SET_SD_LEVEL(1);

	BU98R10_CHIP0_SET_SCL_LEVEL(0);
	BU98R10_CHIP1_SET_SCL_LEVEL(0);

	BU98R10_CHIP0_SET_CSB_LEVEL(0);
	BU98R10_CHIP1_SET_CSB_LEVEL(0);

	__NOP();

	BU98R10_CHIP0_SET_SCL_LEVEL(1);
	BU98R10_CHIP1_SET_SCL_LEVEL(1);

	for (i = 0; i < 8; i++)
	{
		BU98R10_CHIP0_SET_SCL_LEVEL(0);
		BU98R10_CHIP1_SET_SCL_LEVEL(0);

		if (Dat0 & 0x80)
			BU98R10_CHIP0_SET_SD_LEVEL(1);
		else
			BU98R10_CHIP0_SET_SD_LEVEL(0);

		if (Dat1 & 0x80)
			BU98R10_CHIP1_SET_SD_LEVEL(1);
		else
			BU98R10_CHIP1_SET_SD_LEVEL(0);

		__NOP();

		BU98R10_CHIP0_SET_SCL_LEVEL(1);
		BU98R10_CHIP1_SET_SCL_LEVEL(1);

		Dat0 <<= 1;
		Dat1 <<= 1;
	}

	BU98R10_CHIP0_SET_CSB_LEVEL(1);
	BU98R10_CHIP1_SET_CSB_LEVEL(1);
}
#endif

#if BU98R10_WRITE_AT_SAME_TIME
// static void BU98R10_All_ReadRam(uint8_t addr, uint8_t *data0, uint8_t *data1)
// {
// 	uint8_t i;
// 	uint8_t Cmd = 0x09;
// 	uint8_t wdata0 = 0;
// 	uint8_t wdata1 = 0;

// 	BU98R10_All_Command_Write(BU98R10_CMD_ADSET);
// 	BU98R10_All_Data_Write(addr, addr);

// 	Cmd = 0x09;
// 	// D/C = 0,表示发送命令
// 	BU98R10_CHIP0_SET_SD_LEVEL(0);
// 	BU98R10_CHIP1_SET_SD_LEVEL(0);

// 	BU98R10_CHIP0_SET_SCL_LEVEL(0);
// 	BU98R10_CHIP1_SET_SCL_LEVEL(0);

// 	BU98R10_CHIP0_SET_CSB_LEVEL(0);
// 	BU98R10_CHIP1_SET_CSB_LEVEL(0);

// 	__NOP();
// 	__NOP();
// 	__NOP();

// 	BU98R10_CHIP0_SET_SCL_LEVEL(1);
// 	BU98R10_CHIP1_SET_SCL_LEVEL(1);

// 	for (i = 0; i < 8; i++)
// 	{
// 		BU98R10_CHIP0_SET_SCL_LEVEL(0);
// 		BU98R10_CHIP1_SET_SCL_LEVEL(0);

// 		if (Cmd & 0x80)
// 		{
// 			BU98R10_CHIP0_SET_SD_LEVEL(1);
// 			BU98R10_CHIP1_SET_SD_LEVEL(1);
// 		}
// 		else
// 		{
// 			BU98R10_CHIP0_SET_SD_LEVEL(0);
// 			BU98R10_CHIP1_SET_SD_LEVEL(0);
// 		}

// 		__NOP();
// 		__NOP();
// 		__NOP();

// 		BU98R10_CHIP0_SET_SCL_LEVEL(1);
// 		BU98R10_CHIP1_SET_SCL_LEVEL(1);

// 		Cmd <<= 1;
// 	}

// 	BU98R10_CHIP0_SET_SD_DIR(1);
// 	BU98R10_CHIP1_SET_SD_DIR(1);

// 	BU98R10_CHIP0_SET_SCL_LEVEL(0);
// 	BU98R10_CHIP1_SET_SCL_LEVEL(0);
// 	__NOP();
// 	__NOP();
// 	__NOP();

// 	BU98R10_CHIP0_SET_SCL_LEVEL(1);
// 	BU98R10_CHIP1_SET_SCL_LEVEL(1);
// 	__NOP();
// 	__NOP();
// 	__NOP();

// 	for (i = 0; i < 8; i++)
// 	{
// 		BU98R10_CHIP0_SET_SCL_LEVEL(0);
// 		BU98R10_CHIP1_SET_SCL_LEVEL(0);
// 		wdata0 <<= 1;
// 		wdata1 <<= 1;
// 		BU98R10_CHIP0_SET_SCL_LEVEL(1);
// 		BU98R10_CHIP1_SET_SCL_LEVEL(1);

// 		if (BU98R10_CHIP0_GET_SD_LEVEL())
// 		{
// 			wdata0 |= BU98R10_CHIP0_GET_SD_LEVEL();
// 		}
// 		if (BU98R10_CHIP1_GET_SD_LEVEL())
// 		{
// 			wdata1 |= BU98R10_CHIP1_GET_SD_LEVEL();
// 		}
// 	}

// 	*data0 = wdata0;
// 	*data1 = wdata1;

// 	BU98R10_CHIP0_SET_SD_DIR(0);
// 	BU98R10_CHIP1_SET_SD_DIR(0);

// 	BU98R10_CHIP0_SET_CSB_LEVEL(1);
// 	BU98R10_CHIP1_SET_CSB_LEVEL(1);
// }

#endif
/*
uint8_t checkData[2];
void checkSegTftState(void)
{

if (g_curkeyinput == KeyON)
{
   if ((u8BU98R10CheckCount >= 20) && (BU98R10Update.En == 0))
   {
	   u8BU98R10CheckCount = 0;
	   checkData[0] = 0;
	   checkData[1] = 0;

	   BU98R10_All_ReadRam(48, &checkData[0], &checkData[1]);

	   if ((checkData[0] & 0xf0) != 0x70)
	   {
		   BU98R10_Init();
	   }
   }
}
else
{
   u8BU98R10CheckCount = 0;
}
}
*/
