#ifndef CAN_CH0_CAN_COMMUNICATION_MATRIX_H_
#define CAN_CH0_CAN_COMMUNICATION_MATRIX_H_

#include "Components.h"

#define CAN_CH0 &CAN_CH0_CanMsgOp
extern st_CanMsgOp CAN_CH0_CanMsgOp;
extern st_CanMsgTxOp CAN_CH0_CanMsgTxOp;

typedef enum
{    
    CAN_CH0_ID_CAN_0x402_Msg_Count,
    CAN_CH0_ID_CAN_0x401_Msg_Count,
    CAN_CH0_ID_CAN_0x101_Msg_Count,

    CAN_CH0_ID_TOTAL_MAX,
} CAN_CH0_CAN_MSG_ID_t;

typedef enum
{
    CAN_CH0_ID_CAN_0x500_Msg_Count,
    CAN_CH0_ID_SEND_TOTAL,
} CAN_CH0_CAN_MSG_SEND_ID_t;

extern const st_CANMsgAttribute CAN_CH0_CAN_MSG_CONST_ARRAY[CAN_CH0_ID_TOTAL_MAX] ;
extern const st_CAN_SendAttribute    CAN_CH0_CANSendAttr[CAN_CH0_ID_SEND_TOTAL] ;

#define  CAN_CH0_ID_CAN_0x500_Msg    0x500ul
#define  CAN_CH0_ID_CAN_0x402_Msg    0x402ul
#define  CAN_CH0_ID_CAN_0x401_Msg    0x401ul
#define  CAN_CH0_ID_CAN_0x101_Msg    0x101ul



//extern uint8_t  Get_CAN_CH0_ID_500_Sig_Key_ISTOP(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_Warning_Lamp(void);
extern uint8_t  Get_CAN_CH0_ID_401_Sig_ECU_Battery_Voltage(void);
extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Vehicle_Speed(void);
extern uint16_t Get_CAN_CH0_ID_101_Sig_ECU_Engine_Speed(void);

extern uint8_t  Co_Can_ConvertSubID_CAN_CH0(uint32_t MsgID);

void Can_Set_Buff_500(canlib_uint8_t CopyData[]);

#endif
