#ifndef _CAPTURE_MODULE_H
#define _CAPTURE_MODULE_H

#include "stdint.h"

#define CAPTURE_MAX_CHANNEL 4

typedef enum {
    CAPTURE_TRIGER_RISING,
    CAPTURE_TRIGER_FALING,
    CAPTURE_TRIGER_ONCE,
}CAPTURE_TRIGER_TYPE;

typedef struct {
    uint8_t MaxChannel;
    uint32_t TimerClk[CAPTURE_MAX_CHANNEL];
}CAPTURE_MODULE_INIT;

extern uint8_t* GetCaptureModuleVersion(void);
extern void CaptureModuleInit(CAPTURE_MODULE_INIT *Init);
extern void CaptureModuleService(uint32_t TimerMsCnts);
extern void CaptureModuleIsrDeal(CAPTURE_TRIGER_TYPE Type, uint8_t n, uint32_t Timer);
extern void CaptureModuleOverFlowIsrDeal(uint8_t n);

extern uint32_t GetCaptureModuleFreq(uint8_t n);
extern uint32_t GetCaptureModuleDuty(uint8_t n);


#endif
