/**
 * @file mwCapture.c
 * @brief 
 * @details 
 * @author zhoutie (tie.zhou@hljtyw.com)
 * @date 2023-10-15
 * @version 1.00
 * 
 * @copyright Copyright (c) 2023 HeiLongJiang TianYouWei Electronics Co., Ltd
 * 
 * @par Hardware version
 * 
 * @par SW component ID None
 * 
 * @par History
 * <table>
 * <tr><th>Data           <th>Version     <th>Author          <th>Description
 * <tr><th>2023-10-15     <th>1.0         <th>ZT              <th>Fist version
 * </table>
 */
/*! @{ */

/*add group code here*/

#include "Middleware\MiddlewareInclude.h"
#include "mwCapture.h"
#include "CaptureModule.h"
/**
 * @brief Capture interrupt call slave ch
 * @details calc capture input high timer and low timer, you must call it at interrupt function
 *          set H_TimerCnts and L_TimerCnts value
 * @param Type TIMER_TYPE, you can set Taub and TauD
 * @param ch    Timer Channel will be set, ch0~15
 * @param Timer  Reg count value 
 */
void CaptureEdgeIsrDeal(TIMER_TYPE Type, uint8_t ch, uint32_t Timer)
{
    for (uint32_t n = 0; n < CAPTURE_CH_NUM_TOTAL; n ++) {
        if ((CaptureMapData[n].TimerType == Type) && (CaptureMapData[n].Channel == ch)) {
            if (mwGpioGetVal(CaptureMapData[n].IoNum) != 0) {
                CaptureModuleIsrDeal(CAPTURE_TRIGER_RISING, n, Timer);
            } else {
                CaptureModuleIsrDeal(CAPTURE_TRIGER_FALING, n, Timer);
            }
            break;
        }
    }
}

/**
 * @brief Capture interrupt call master ch
 * @details Count overflow and add with CaptureCalcData[n].OverFlowTime
 * 
 * @param Type TIMER_TYPE, you can set Taub and TauD
 * @param ch Timer Channel will be set, ch0~15
 */
void CaptureOverFlowIsrDeal(TIMER_TYPE Type, uint8_t ch)
{
    for (uint32_t n = 0; n < CAPTURE_CH_NUM_TOTAL; n ++) {
        if ((CaptureMapData[n].TimerType == Type) && (CaptureMapData[n].Channel == (ch + 1))) {
            CaptureModuleOverFlowIsrDeal(n);
            break;
        }
    }
}

static CAPTURE_MODULE_INIT CaptureInit;
void mwCaptureChInit(CAPTURE_NUM_ENUM n)
{
    CaptureInit.MaxChannel = CAPTURE_CH_NUM_TOTAL;
    for (uint8_t i = 0; i < CAPTURE_CH_NUM_TOTAL; i ++) {
        CaptureInit.TimerClk[i] = CaptureMapData[i].TimerClk;
    }
    CaptureModuleInit(&CaptureInit);
    if (n < CAPTURE_CH_NUM_TOTAL) {
        CaptureInitTimer(CaptureMapData[n].TimerType, CaptureMapData[n].Channel, CaptureMapData[n].ChClkSrc, CaptureMapData[n].IrqType);
    }
}

void mwCaptureChStop(CAPTURE_NUM_ENUM n)
{
    if (n < CAPTURE_CH_NUM_TOTAL) {
        CaptureDeinitTimer(CaptureMapData[n].TimerType, CaptureMapData[n].Channel);
    }
}

void mwCaptureModuleInit(void)
{
    for (uint32_t n = 0; n < CAPTURE_CH_NUM_TOTAL; n ++) {
        mwCaptureChInit((CAPTURE_NUM_ENUM)n);
    }
}

void mwCaptureModuleDeinit(void)
{
    for (uint32_t n = 0; n < CAPTURE_CH_NUM_TOTAL; n ++) {
        mwCaptureChStop((CAPTURE_NUM_ENUM)n);
    }
}

void mwCaptureService(uint32_t TimerMsCnts)
{
    CaptureModuleService(TimerMsCnts);
}

uint32_t mwGetCaptureFreq(CAPTURE_NUM_ENUM n)
{
    return GetCaptureModuleFreq(n);
}

uint32_t mwGetCaptureDuty(CAPTURE_NUM_ENUM n)
{
    uint32_t TmpVal = GetCaptureModuleDuty(n);
    if (TmpVal == 0) {
        if (mwGpioGetVal(CaptureMapData[n].IoNum) != 0) {
            TmpVal = 100;
        }
    }
    return TmpVal;
}
/*! @} */



