#ifndef CHECK_Ctrl_H
#define CHECK_Ctrl_H

#include "TYW_stdint.h"

#define SV_DID 0xF195   // 诊断读 软件版本号的DID
#define HV_DID 0xF193   // 诊断读 硬件版本号的DID
#define PV_DID 0xF187   // 诊断读 零件号的DID
#define DATE_DID 0xF18B // 诊断读 制造日期的DID
#define CODE_DID 0xF18A // 诊断读 供应商代码的DID
#define FUEL_DID 0x5008 // 诊断读 燃油阻值的DID

uint8_t Get_DID_High_Byte(uint16_t Input_DID);
uint8_t Get_DID_Low_Byte(uint16_t Input_DID);
// uint8_t Seat_belt_send = 1;

extern unsigned char InterNal_Version[128];
extern unsigned char SW_Version[128];
extern unsigned char HW_Version[128];
extern unsigned char Part_Version[128];
extern unsigned char Trie[128];
extern unsigned char Speed_limit[128];
extern unsigned char AIR_BAG[128];
extern unsigned char ESC[128];
extern unsigned char Failure[128];
extern unsigned char Made_Date[128];
extern unsigned char SUPPLIER[128];
extern unsigned char Voltage_UDS[128];
extern unsigned char BCM_2014[128];
extern unsigned char Risk_Evade[128];
extern unsigned char Evade_ODO[128];
extern unsigned char Line_IN_St[128];
extern unsigned char Res_St[128];
extern unsigned int LINE_IN_CHECK_BEGIN;
extern unsigned int RES_CHECK_BEGIN;
extern unsigned int TFT_CHECN_BEGIN;
extern unsigned int LCD_CHECN_BEGIN;
extern unsigned int VOICE_BACK_BEGIN;
extern unsigned int VOICE_CHECK_BEGIN;
extern unsigned int VOICE_CHECN_BEGIN;
extern unsigned int MENU_CHECK_STEP;
extern unsigned int UnLock_Flag;
extern unsigned int Global_Session;
extern unsigned int loc_Step;
extern unsigned char KEYBUFFER[4];
extern unsigned int CAN_Msg_Tx_Enable;
extern uint8_t loc_Type_back;
extern uint8_t LED_Waring;
 extern uint8_t Seat_belt_send;
extern uint8_t Parking_brake_send;
extern uint8_t DoorOpenSw_send;
extern uint8_t ReverseSw_send;

void SET_IPK_NONE(void);
void Clear_IPK_NONE(void);
void CHECK_IPK_COUNT(void);
void HW_CHECK_IPK_EXIST(void);
unsigned int Get_IPK_Status(void);
void Diag_Info_Init(void);
void Total_Check(void);
void HW_CHECK_Ctrl(unsigned int cmd);
void MENU_CHECK_STEP_ADD(void);
void MENU_CHECK_STEP_SUB(void);
void HW_ODO_Clear(void);
void MENU_CHECK_Init(void);
void Req_To_Secure(void);
void Read_IPK_Session_Type(void);
void can_send_setup(uint8_t Get_can);


extern void Motor_Test_Display();
extern void Motor_Test_HALL_VDD(uint32_t VDD);
extern void Motor_Can_TX(uint32_t choose);
extern void Auto_run(uint8_t count1);//自适应运行
extern void Calibration_15s(void);//长按15s进行自动校准

void Hand_set_angle(int32_t hand_set);

extern void Hall_angle(int16_t hall_angle);

void Display_angle(int16_t Dis_Angle);

void Boot_v(void); 

void Flash_v(void);

void EEprom_v(void);

extern uint32_t Hall_sig_c;
extern uint32_t Hall_Sig_Duty_c;
extern uint32_t Hall_Sig_Hz_c;
extern uint32_t MOTOR1_c;
extern uint32_t MOTOR1_Duty_c ;
extern uint32_t MOTOR1_Hz_c;
extern uint32_t MOTOR2_c;
extern uint32_t MOTOR2_Duty_c;
extern uint32_t MOTOR2_Hz_c;

extern uint8_t Calibration_15s_lock;
extern uint8_t Auto_run_lock;

extern uint8_t Motor_test_choose;

extern void Button_server();


#endif
