
#include "FreIn.h"
#include "FreIn_User.h"
#include "r_typedefs.h"
#include "dr7f701684.dvf.h"
#include "GPIO.h"
#include "TimerB.h"
#include "RTE_GPIO.h"
#include "Display_Info.h"
#include "TFT_LCD.h"
#include "RTE_GPIO.h"
#include "../Appliciation/Check_Ctrl.h"

uint8_t VEHICLE_Status = 0;
uint8_t ENGINE_Status = 0;
uint32_t Hall_sig=0;
uint32_t Duty_VEHICLE = 0;
uint32_t Duty_ENGINE = 0;
uint32_t HZ_VEHICLE = 0;
uint32_t HZ_ENGINE = 0;
uint32_t MOTOR1_Duty=0;
uint32_t MOTOR1_Hz=0;
uint32_t MOTOR1=0;
uint32_t MOTOR2_Duty=0;
uint32_t MOTOR2_Hz=0;
uint32_t MOTOR2=0;

Fre_uint8_t Fre_Status_Read_0(void)
{
	Fre_uint8_t u8FrePin = 0 ;
	if(GPIO_IN_PORT10_PIN14)
	{
		u8FrePin = 1;	
	}
	return u8FrePin ;
}

Fre_uint8_t Fre_Status_Read_1(void)
{
	Fre_uint8_t u8FrePin = 0 ;
	if(GPIO_IN_PORT10_PIN13)
	{
		u8FrePin = 1;	
	}
	return u8FrePin;
}
Fre_uint8_t Fre_Status_Read_2(void)
{
	Fre_uint8_t u8FrePin = 0 ;
	if(GPIO_IN_PORT10_PIN12)
	{
		u8FrePin = 1;	
	}
	return u8FrePin;
}
Fre_uint8_t Fre_Status_Read_3(void)
{
	Fre_uint8_t u8FrePin = 0 ;
    // if(GPIO_IN_PORT10_PIN12)
	// {
	// 	u8FrePin = 1;	
	// }
	return u8FrePin;
}

/*在填完表格后，一定实测下所需采集信号的极大极小值，是否正确，精度是否满足需求！*/
/*在填完表格后，一定实测下所需采集信号的极大极小值，是否正确，精度是否满足需求！*/
/*在填完表格后，一定实测下所需采集信号的极大极小值，是否正确，精度是否满足需求！*/
const Fre_Attribute_st_t stFreAttribute[FRE_CHANNEL_MAX] =
{
	{  10U, 5000U, 100U,  1000U, 30000U, FRE_SAMP_CAPTURE_ROLL, Fre_Status_Read_0, 5000000UL},//车速 f= 5096*8(0~140km/h)/3600s
	{  10U, 500000U, 100U,  1000U, 30000U, FRE_SAMP_CAPTURE_ROLL, Fre_Status_Read_1, 5000000UL},//转速 f= (0~5000r/min)*4/60s
	{  10U, 500000U, 100U,  1000U, 30000U, FRE_SAMP_CAPTURE_ROLL, Fre_Status_Read_2, 5000000UL},//转速 f= (0~5000r/min)*4/60s
};

/************************************************/
Fre_uint8_t u8FreRamData[FRE_RAM_DATA_LEN];

void Fre_In_KL30_Wakeup_Init(void)
{
	Fre_In_Init(&u8FreRamData[0], &stFreAttribute[0], FRE_CHANNEL_MAX);
	TimerB_Input_Channel_Init(TIMERB_0_CH7, TIMERB_CLOCK_3, TIMERB_RISING_FALL);
	TimerB_Input_Channel_Start(TIMERB_0_CH7);
	
	TimerB_Input_Channel_Init(TIMERB_0_CH5, TIMERB_CLOCK_3, TIMERB_RISING_FALL);
	TimerB_Input_Channel_Start(TIMERB_0_CH5);

	TimerB_Input_Channel_Init(TIMERB_0_CH3, TIMERB_CLOCK_3, TIMERB_RISING_FALL);
	TimerB_Input_Channel_Start(TIMERB_0_CH3);
}



uint32_t Duty_VEHICLE_BackUp = 0;
uint32_t Duty_ENGINE_BackUp = 0;
uint32_t HZ_VEHICLE_BackUp = 0;
uint32_t HZ_ENGINE_BackUp = 0;
//uint32_t MOTOR1_count = 0 ;
//uint32_t MOTOR1_samp[10*1024];
void Freln_Duty_HZ_Service(void)
{
    Hall_sig = Fre_In_Get_Channel_Status(FRE_HALL_SIG);
    if(Fre_In_Get_Update_Flag(FRE_HALL_SIG)) 
    { 
       Fre_In_Reset_Update_Flag(FRE_HALL_SIG);
       Duty_VEHICLE = Fre_In_Get_Channel_Duty(FRE_HALL_SIG);  
       HZ_VEHICLE = Fre_In_Get_Channel_HZ(FRE_HALL_SIG);
	   Hall_Sig_Duty_c =  Duty_VEHICLE;
	   Hall_Sig_Hz_c = HZ_VEHICLE;
	   		//MOTOR1_samp[MOTOR1_count] = Hall_Sig_Duty_c ;
		//MOTOR1_count ++ ;
    }   

    MOTOR1 = Fre_In_Get_Channel_Status(FRE_MOTOR1);
    if(Fre_In_Get_Update_Flag(FRE_MOTOR1)) 
    {
        Fre_In_Reset_Update_Flag(FRE_MOTOR1);
        MOTOR1_Duty = Fre_In_Get_Channel_Duty(FRE_MOTOR1); 
        MOTOR1_Hz = Fre_In_Get_Channel_HZ(FRE_MOTOR1);  
		MOTOR1_Duty_c = MOTOR1_Duty;
		MOTOR1_Hz_c = MOTOR1_Hz;

    }   

	MOTOR2 = Fre_In_Get_Channel_Status(FRE_MOTOR2);
	if(Fre_In_Get_Update_Flag(FRE_MOTOR2)) 
    {
        Fre_In_Reset_Update_Flag(FRE_MOTOR2);
        MOTOR2_Duty = Fre_In_Get_Channel_Duty(FRE_MOTOR2); 
        MOTOR2_Hz = Fre_In_Get_Channel_HZ(FRE_MOTOR2);  
		MOTOR2_Duty_c = MOTOR2_Duty;
		MOTOR2_Hz = MOTOR2_Duty_c;


    }    
	
}


