#include "main.h"
#include "Task.h"
#include "TYW_stdint.h"
#include "GenDelay.h"
#include "COM_CAN.h"
#include "RTE_GPIO.h"
#include "DoCAN_ISO15765.h"
#include "Flash_synchronizer.h"
#include "RTE_ADC.h"
#include "init.h"
#include "CANFD_Lib.h"
#include "TFT_LCD.h"
#include "TM035HFZGZx.h"
#include "UDS_ISO14229_Server.h"
#include "Display_Info.h"
#include "Key.h"
#include "Check_Ctrl.h"
#include "FT_VehSpeedCalc.h"
#include "FreIn_User.h"
#include "../Appliciation/Motor_Angle_calculation.h"
#include "string.h"




void Sys_Run_Mode_Pseudo_Real_Time_Tasks(void)
{
    SD_FMQ = 1;
    DoCAN_Communication_Service();
    if (CAN_Msg_Tx_Enable != 0)
    {
        UDS_Server_Application_Service();
    }

    TFT_LCD_Display_Update_Service();
    Fre_In_Service(FRE_HALL_SIG);
    Fre_In_Service(FRE_MOTOR1);
    Fre_In_Service(FRE_MOTOR2);
}

void Sys_Run_Mode_2ms_Tasks_Group(void)
{
   
    COM_RX_Process();
    RTE_ADC_Services();
}

void Sys_Run_Mode_5ms_Tasks_Group(void)
{
}


void Sys_Run_Mode_10ms_Tasks_Group(void)
{
    BusOff_Service();

    Fre_In_Time_Out_Handle(10);
}


void Sys_Run_Mode_20ms_Tasks_Group0(void)
{
    static uint16_t timer = 0;

    timer++;
    if(timer==2)
    { 
        
            Button_server();
            timer = 0;
         
        
    }
}


void Sys_Run_Mode_50ms_Tasks_Group(void)
{
    
}


uint16_t u16LJSText;
void Sys_Run_Mode_100ms_Tasks_Group(void)
{
   
    Freln_Duty_HZ_Service();
    Motor_Test_Display();
    static uint32 lock1 = 1;
    static uint32 timer10s = 0;
    
    
    timer10s++;
    if(timer10s==20&&lock1==1)//上电第2s先发远程校准
    {
         Motor_Can_TX(1);
    }
    else if(timer10s==120&&lock1==1)//第12s后进行本地校准
    {
       Motor_Can_TX(3);
    }
    else if(timer10s==180&&lock1==1)//第18s进行占空比采集
    {
       Limiting_Duty_Conversion(Hall_Sig_Duty_c,1);
    }
    else if(timer10s==200&&lock1==1)//第20s进行本地校准
    {
       Motor_Can_TX(2);
    }
    else if(timer10s==260&&lock1==1)//第26s进行最后一次占空比采集
    {
       timer10s = 0;
       Limiting_Duty_Conversion(Hall_Sig_Duty_c,2);
       lock1 = 0;//再将按键功能解锁
       
    }
   
}

void Sys_Exact_50us_Tasks(void)
{
    GenDelay_Tick();
    DoCAN_Timer_Update(50u);
}

void Sys_Exact_100ms_Tasks(void)
{
    CHECK_IPK_COUNT();
}

void Sys_Enter_Sleep_Mode(void)
{
    
}
