#ifndef MW_CAPTURE_H
#define MW_CAPTURE_H

#include "Driver\TimerTauBD\TimerTauBD.h"
#include "Middleware\MiddlewareInclude.h"


typedef enum {
    CAPTURE_CH_NUM_SPEED,
    CAPTURE_CH_NUM_TOTAL,
} CAPTURE_NUM_ENUM;


typedef struct {
    CAPTURE_NUM_ENUM Num;
    TIMER_TYPE TimerType;
    uint8_t Channel;
    TIMKER_CLK_SEL ChClkSrc;
    TIMER_EDGE_EN_TYPE IrqType;
    IO_NUM_ENUM IoNum;
    uint32_t TimerClk;
    uint32_t PreroidLimit;//2000hz
} CAPTURE_MAP_DATA_ST;

static const CAPTURE_MAP_DATA_ST CaptureMapData[CAPTURE_CH_NUM_TOTAL] = {
    {CAPTURE_CH_NUM_SPEED,  TIMER_TYPE_TAUB, 13, TIMER_CLOCK_0, TIMERB_RISING_FALL, IO_NUM_MCU_VEHSPD_CAPTURE, 40000000u / 16, 2000},

};

extern void mwCaptureModuleInit(void);
extern void mwCaptureModuleDeinit(void);
extern void mwCaptureChInit(CAPTURE_NUM_ENUM n);
extern void mwCaptureService(uint32_t TimerMsCnts);
extern uint32_t mwGetCaptureFreq(CAPTURE_NUM_ENUM n);//x100
extern uint32_t mwGetCaptureDuty(CAPTURE_NUM_ENUM n);

#endif
