#ifndef CANFD_CH0_CANFD_COMMUNICATION_MATRIX_H_
#define CANFD_CH0_CANFD_COMMUNICATION_MATRIX_H_

#include "TYW_stdint.h"
#include "CANFD_Lib.h"

extern st_CanFDMsgOp CANFD_CH0_CanFDMsgOp;

extern st_CanFDMsgTxOp CANFD_CH0_CanFDMsgTxOp;

typedef enum
{
    CANFD_CH0_ID_New_Message_4_Msg_Count,
    CANFD_CH0_ID_New_Message_3_Msg_Count,
    CANFD_CH0_ID_HU_2DE_Msg_Count,
    CANFD_CH0_ID_HU_53C_Msg_Count,

    CANFD_CH0_ID_TOTAL_MAX,
} CANFD_CH0_CAN_MSG_ID_t;

typedef enum
{

    CANFD_CH0_ID_SEND_TOTAL,
} CANFD_CH0_CAN_MSG_SEND_ID_t;

extern const st_CANFDMsgAttribute CANFD_CH0_CAN_MSG_CONST_ARRAY[CANFD_CH0_ID_TOTAL_MAX] ;
//extern const st_CANFD_SendAttribute    CANFD_CH0_CANSendAttr[CANFD_CH0_ID_SEND_TOTAL] ;

#define  CANFD_CH0_ID_New_Message_4_Msg    0x549ul
#define  CANFD_CH0_ID_New_Message_3_Msg    0x559ul
#define  CANFD_CH0_ID_HU_2DE_Msg           0x2DEul
#define  CANFD_CH0_ID_HU_53C_Msg           0x53Cul

extern uint8_t  Get_CANFD_CH0_ID_549_Sig_MotorSwVers6(void);
extern uint8_t  Get_CANFD_CH0_ID_549_Sig_MotorSwVers5(void);
extern uint8_t  Get_CANFD_CH0_ID_549_Sig_MotorSwVers4(void);
extern uint8_t  Get_CANFD_CH0_ID_549_Sig_MotorSwVers3(void);
extern uint8_t  Get_CANFD_CH0_ID_549_Sig_MotorSwVers2(void);
extern uint8_t  Get_CANFD_CH0_ID_549_Sig_MotorSwVers1(void);
extern uint8_t  Get_CANFD_CH0_ID_549_Sig_MotorSwVers0(void);
extern uint8_t  Get_CANFD_CH0_ID_559_Sig_MotorHwVers6(void);
extern uint8_t  Get_CANFD_CH0_ID_559_Sig_MotorHwVers5(void);
extern uint8_t  Get_CANFD_CH0_ID_559_Sig_MotorHwVers4(void);
extern uint8_t  Get_CANFD_CH0_ID_559_Sig_MotorHwVers3(void);
extern uint8_t  Get_CANFD_CH0_ID_559_Sig_MotorHwVers2(void);
extern uint8_t  Get_CANFD_CH0_ID_559_Sig_MotorHwVers1(void);
extern uint8_t  Get_CANFD_CH0_ID_559_Sig_MotorHwVers0(void);
extern uint8_t  Get_CANFD_CH0_ID_2DE_Sig_CdcStsSyncReq(void);
extern uint8_t  Get_CANFD_CH0_ID_2DE_Sig_CdcCtrlTarAg(void);
extern uint8_t  Get_CANFD_CH0_ID_53C_Sig_MotorScreenStsSyncReq(void);
extern uint8_t  Get_CANFD_CH0_ID_53C_Sig_MotorScreenPrecisionCtrl(void);
extern uint8_t  Get_CANFD_CH0_ID_53C_Sig_MotorScreenPosAgCtrl(void);
extern uint8_t  Get_CANFD_CH0_ID_53C_Sig_MotorScreenNegAgCtrl(void);
extern uint8_t  Get_CANFD_CH0_ID_53C_Sig_MotorScreenAgFb(void);

extern uint8_t  Co_CanFD_ConvertSubID_CANFD_CH0(uint32_t MsgID);

#endif
