#include "Check_Ctrl.h"
#include "TYW_stdint.h"
#include "RTE_GPIO.h"
#include "UDS_ISO14229_Server.h"
#include "string.h"
#include "Display_Info.h"
#include "Analog_Signals.h"
#include "CANFD_CH0_CANFD_Communication_Matrix.h"
#include "COM_CAN.h"
#include "GenDelay.h"
#include "FT_VehSpeedCalc.h"
#include "../Driver/GPIO/TFT_LCD.h"
#include "../Driver/CAN/RSCAN.h"
#include "Motor_Angle_calculation.h"
#include "../Driver/GPIO/GPIO.h"
#include "stdlib.h"
//#include "CANFD_CH0_CANFD_Communication_Matrix.h"
static int32_t HAND_SET = 0;
uint32_t NO_IPK_EXIST_Status;
uint32_t NO_IPK_EXIST;
// uint32_t NO_IPK_EXIST_Back;
uint32_t NO_IPK_EXIST_TIMER;
uint8_t Seat_belt_send = 1;
uint8_t Parking_brake_send = 0;
uint8_t DoorOpenSw_send = 0;
uint8_t ReverseSw_send = 0;
uint8_t Motor_test_choose = 0;


uint32_t Hall_sig_c=0;
uint32_t Hall_Sig_Duty_c=0;
uint32_t Hall_Sig_Hz_c=0;
uint32_t MOTOR1_c=0;
uint32_t MOTOR1_Duty_c=0;
uint32_t MOTOR1_Hz_c=0;
uint32_t MOTOR2_c=0;
uint32_t MOTOR2_Duty_c=0;
uint32_t MOTOR2_Hz_c=0;

uint8_t Calibration_15s_lock=0;
uint8_t Auto_run_lock=0;


uint8_t InterNal_Version[128];
uint8_t SW_Version[128];
uint8_t HW_Version[128];
uint8_t Part_Version[128];
uint8_t Risk_Evade[128];
uint8_t Evade_ODO[128];
uint8_t Line_IN_St[128];
uint8_t Res_St[128];
uint8_t Trie[128];        // 胎压检测系统
uint8_t Speed_limit[128]; // 限速报警
uint8_t AIR_BAG[128];     // 安全气囊
uint8_t ESC[128];         // ESC
uint8_t Failure[128];     // 变速箱故障
uint8_t Made_Date[128];   // 制造日期
uint8_t SUPPLIER[128];    // 供应商代码
uint8_t Voltage_UDS[128];
uint8_t BCM_2014[128];
// uint8_t InterNal_Version [ 128 ];

uint32_t LCD_CHECN_BEGIN;
uint32_t LCD_CHECN_Retry;

uint32_t LINE_IN_CHECK_BEGIN;
uint32_t LINE_IN_CHECK_Retry;

uint32_t TFT_CHECN_BEGIN;
uint32_t TFT_CHECN_Retry;

uint32_t VOICE_BACK_BEGIN;
uint32_t VOICE_BACK_Retry;

uint32_t VOICE_CHECK_BEGIN;
uint32_t VOICE_CHECK_Retry;

uint32_t VOICE_CHECN_BEGIN;
uint32_t VOICE_CHECN_Retry;

uint32_t LINE_ODO_CLEAR_BEGIN;
uint32_t VOICE_ODO_CLEAR_Retry;

uint32_t RES_CHECK_BEGIN;
uint32_t RES_CHECK_Retry;

uint32_t UnLock_Flag = 0;
uint32_t UnLock_Retry;

uint8_t KEYBUFFER[4];

uint32_t CAN_Msg_Tx_Enable;

uint32_t MENU_CHECK_STEP;

uint32_t Global_Session = 0;
uint32_t loc_Step;

void Function_Check_Ctrl(uint32_t cmd);

void MENU_CHECK_STEP_ADD(void)
{
    MENU_CHECK_STEP++;
}
void MENU_CHECK_STEP_SUB(void)
{
    if (MENU_CHECK_STEP != 0)
        MENU_CHECK_STEP--;
}

void MENU_CHECK_Init(void)
{
    // MENU_CHECK_STEP = 0;
}

uint8_t Get_DID_High_Byte(uint16_t Input_DID)
{
    uint16_t Res = 0;

    Res = (Input_DID >> 8);

    return (uint8_t)(Res);
}

uint8_t Get_DID_Low_Byte(uint16_t Input_DID)
{
    uint16_t Res = 0;

    Res = (Input_DID & 0xFF);

    return (uint8_t)(Res);
}

void HW_CHECK_IPK_EXIST(void)
{

    uint8_t DIAG_BUFER[2];

    DIAG_BUFER[0] = 0x3E;
    DIAG_BUFER[1] = 0x00;
    UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 2);

    SET_IPK_NONE();
}

void SET_IPK_NONE(void)
{
    NO_IPK_EXIST_TIMER = 12;
    NO_IPK_EXIST = 12345678;
}
void Clear_IPK_NONE(void) // CAN在线
{
    NO_IPK_EXIST = 0;
    NO_IPK_EXIST_Status = 0x55667788;
}
uint8_t ClearFlag = 0;
uint8_t ClearFlagBack = 0;

void CHECK_IPK_COUNT(void)
{
    if (CAN_Msg_Tx_Enable == 1u)
    {
        if (NO_IPK_EXIST_TIMER != 0)
        {
            NO_IPK_EXIST_TIMER--;
        }
        else
        {
            if (NO_IPK_EXIST == 12345678)
            {
                NO_IPK_EXIST_Status = 0x11223344;
                memset(InterNal_Version, 0xFF, sizeof(InterNal_Version));
                memset(SW_Version, 0xFF, sizeof(SW_Version));
                memset(HW_Version, 0xFF, sizeof(HW_Version));
                memset(Part_Version, 0xFF, sizeof(Part_Version));
                // memset(Trie, 0xFF, sizeof(Trie));
                // memset(Speed_limit, 0xFF, sizeof(Speed_limit));
                // memset(AIR_BAG, 0xFF, sizeof(AIR_BAG));
                // memset(ESC, 0xFF, sizeof(ESC));
                // memset(Failure, 0xFF, sizeof(Failure));
                memset(Made_Date, 0xFF, sizeof(Made_Date));
                memset(SUPPLIER, 0xFF, sizeof(SUPPLIER));
                memset(Voltage_UDS, 0xFF, sizeof(Voltage_UDS));

                // Display_Menu_Type = 0;
                // Display_TFT_Clear( );
                // Send_Init();
                // MENU_CHECK_Init( );
                // Global_Session = 0;//掉线时，认为会话模式归零，重连CAN线后，重新将会话模式切到03扩展会话。
            }
            else
            {
                ClearFlag = 0;
            }
        }
    }
}

// 0x11223344 不在线
// 0x55667788 在线

uint32_t Get_IPK_Status(void)
{
    return NO_IPK_EXIST_Status;
}
void Diag_Info_Init(void)
{
    NO_IPK_EXIST_Status = 0x11223344;
    CAN_Msg_Tx_Enable = 1u;

    memset(InterNal_Version, 0xFF, sizeof(InterNal_Version));
    memset(SW_Version, 0xFF, sizeof(SW_Version));
    memset(HW_Version, 0xFF, sizeof(HW_Version));
    memset(Part_Version, 0xFF, sizeof(Part_Version));
    memset(Risk_Evade, 0xFF, sizeof(Risk_Evade));
    memset(Evade_ODO, 0xFF, sizeof(Evade_ODO));
    memset(Res_St, 0xFF, sizeof(Res_St));
    // memset(Trie, 0xFF, sizeof(Trie));
    // memset(Speed_limit, 0xFF, sizeof(Speed_limit));
    // memset(AIR_BAG, 0xFF, sizeof(AIR_BAG));
    // memset(ESC, 0xFF, sizeof(ESC));
    // memset(Failure, 0xFF, sizeof(Failure));
    memset(Made_Date, 0xFF, sizeof(Made_Date));
    memset(SUPPLIER, 0xFF, sizeof(SUPPLIER));
    // memset(Voltage_UDS, 0xFF, sizeof(Voltage_UDS));
}
uint8_t Type_Clear = 0;
extern uint8_t BCM_FLAG_2014 = 0;
uint8_t Flag_Turn = 0;
void Total_Check(void)
{
    uint32_t loc_Type = 0;
    loc_Type = Get_Display_Type();
    if (Type_Clear != loc_Type)
    {
        Type_Clear = loc_Type;
        Display_TFT_Clear();
    }

    POWER_CTRL_KL30_Current = 1u; // 静态电流电阻的远仪表端，永远接通总电源。B+~

    // BCM_FLAG_2014 = BCM_2014[1] & 0X40 ;

    if (loc_Type != 4)
    {
        HW_Static_Current_Check(0);
        Flag_Turn = 0;
    }

    switch (loc_Type)
    {
    case 0:
        POWER_CTRL_KL30 = 1u; // B+
        POWER_CTRL_KL15 = 1u; // KL15
        CAN_Msg_Tx_Enable = 1u;
        Diag_Info_Init();
        // Display_Init( );
       // Display_Version_Info(0);
        // Send_Init();
        Send_ODO_Init();
        // Buzzer_Init();
        Function_Check_Ctrl(1); // Excel表格发报文。硬线信号

        break;

    case 1:
        POWER_CTRL_KL30 = 1u; // B+
        POWER_CTRL_KL15 = 1u; // KL15
        CAN_Msg_Tx_Enable = 1u;
        //Display_Version_Info(1);
        // Send_Init();
        // Send_ODO_Init();
        HW_Voltage_Check(1);
        Function_Check_Ctrl(1); // Excel表格发报文。硬线信号
        // Buzzer_Warning();
        break;

    case 2:
        POWER_CTRL_KL30 = 1u; // B+
        POWER_CTRL_KL15 = 1u; // KL15
        CAN_Msg_Tx_Enable = 1u;
        Diag_Info_Init();
        // Display_Init( );
        // Display_Version_Info(0);
        // Send_Init();
        //Display_Send_ODO(0);
        Function_Check_Ctrl(1); // Excel表格发报文。硬线信号

        // Buzzer_Warning();

        break;

    case 3:
        // if ( BCM_FLAG_2014 == 0x40 )      //全CAN,不做外发，此页为静态电流测试
        // {
        //     POWER_CTRL_KL30   = 0u;  //B+
        //     POWER_CTRL_KL15   = 0u;  //KL15
        //     CAN_Msg_Tx_Enable = 0u;
        //     HW_Static_Current_Check(1);
        // }
        // else
        // {
        POWER_CTRL_KL30 = 1u; // B+
        POWER_CTRL_KL15 = 1u; // KL15
        CAN_Msg_Tx_Enable = 1u;
        // Diag_Info_Init();
        // Display_Init( );
        // Send_ODO_Init();
        Display_Configuration_Info(1);
        // Display_Set_Buff();
        Function_Check_Ctrl(1); // Excel表格发报文。硬线信号
        // Buzzer_Warning();
        // }

        break;

    case 4:

        POWER_CTRL_KL30 = 0u; // B+
        POWER_CTRL_KL15 = 0u; // KL15
        CAN_Msg_Tx_Enable = 0u;
        HW_Static_Current_Check(1);
        break;

    default:
        POWER_CTRL_KL30 = 1u;
        POWER_CTRL_KL15 = 1u;
        CAN_Msg_Tx_Enable = 1u;
        Display_Menu_Type = 0;
        Diag_Info_Init();
        Display_Init();
       // Display_Version_Info(0);
        Send_Init();
        Send_ODO_Init();
        Buzzer_Init();

        break;
    }
}

void Service11Reset(void)
{
    uint8_t DIAG_BUFER[10];

    DIAG_BUFER[0] = 0x11;
    DIAG_BUFER[1] = 0x01;
    UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 2); //
}

void Read_IPK_Session_Type(void) // 请求仪表发送 软硬件版本号 等数据。
{
    uint8_t DIAG_BUFER[10];

    switch (loc_Step)
    {
    case 0:
        loc_Step = 1;
        break;

    case 1:
        // if ( Global_Session != 3 )
        {
            DIAG_BUFER[0] = 0x10;
            DIAG_BUFER[1] = 0x03;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 2); // 让仪表进入 扩展会话 中。
        }
        break;
    case 2:
        //*******************************
        // UnLock_Flag == 0x00   //初始    阶段
        // UnLock_Flag == 0x01   //请求种子阶段
        // UnLock_Flag == 0x02   //得到种子阶段
        // UnLock_Flag == 0x03   //发送密钥阶段
        // UnLock_Flag == 0x55   //解锁成功阶段
        //*******************************
        if (UnLock_Flag == 0)
        {
            UnLock_Retry = 10;
            UnLock_Flag = 1; // 请求种子阶段
            DIAG_BUFER[0] = 0x27;
            DIAG_BUFER[1] = 0x01;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 2); //
        }
        if (UnLock_Flag == 0x55) // 解锁成功阶段
        {
            loc_Step = 3;
        }
        break;
    case 3:
        if (UnLock_Flag == 2) // 得到种子阶段
        {
            UnLock_Flag = 3; // 发送密钥阶段
            UnLock_Retry = 10;
            DIAG_BUFER[0] = 0x27;
            DIAG_BUFER[1] = 0x02;
            DIAG_BUFER[2] = KEYBUFFER[0];
            DIAG_BUFER[3] = KEYBUFFER[1];
            DIAG_BUFER[4] = KEYBUFFER[2];
            DIAG_BUFER[5] = KEYBUFFER[3];
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 6); //
        }
        if (UnLock_Flag == 0x55) // 解锁成功阶段
        {
            loc_Step = 4;
        }
        break;
    case 4:
        if (SW_Version[0] == 0xff)
        {

            DIAG_BUFER[0] = 0x22;
            DIAG_BUFER[1] = Get_DID_High_Byte(SV_DID);
            DIAG_BUFER[2] = Get_DID_Low_Byte(SV_DID);
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3); // 请求 软件版本号
            // Execute_Specify_Step(2);
        }
        loc_Step = 5;
        break;

    case 5:
        if (HW_Version[0] == 0xff)
        {
            DIAG_BUFER[0] = 0x22;
            DIAG_BUFER[1] = Get_DID_High_Byte(HV_DID);
            DIAG_BUFER[2] = Get_DID_Low_Byte(HV_DID);
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3); // 请求 硬件版本号
        }
        loc_Step = 6;
        break;

    case 6:
        if (Part_Version[0] == 0xff)
        {
            DIAG_BUFER[0] = 0x22;
            DIAG_BUFER[1] = Get_DID_High_Byte(PV_DID);
            DIAG_BUFER[2] = Get_DID_Low_Byte(PV_DID);
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3); // 请求 零件号
        }
        loc_Step = 7;
        break;

    case 7:
        if (Trie[0] == 0xff)
        {
            DIAG_BUFER[0] = 0x2E;
            DIAG_BUFER[1] = 0x02;
            DIAG_BUFER[2] = 0x0C;
            DIAG_BUFER[3] = 0x01;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 4); // 胎压检测系统配置
        }
        if (Trie[0] != 0x01 && MENU_CHECK_STEP == 5)
        {
            DIAG_BUFER[0] = 0x2E;
            DIAG_BUFER[1] = 0x02;
            DIAG_BUFER[2] = 0x0C;
            DIAG_BUFER[3] = 0x01;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 4);
        }
        if (Trie[0] == 0x01 && MENU_CHECK_STEP == 49)
        {
            DIAG_BUFER[0] = 0x2E;
            DIAG_BUFER[1] = 0x02;
            DIAG_BUFER[2] = 0x0C;
            DIAG_BUFER[3] = 0x00;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 4);
        }
        loc_Step = 8;
        break;

    case 8:
        if (Speed_limit[0] == 0xff)
        {
            DIAG_BUFER[0] = 0x2E;
            DIAG_BUFER[1] = 0x02;
            DIAG_BUFER[2] = 0x1F;
            DIAG_BUFER[3] = 0x01;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 4); // 限速报警配置
        }
        if (Speed_limit[0] != 0x01 && MENU_CHECK_STEP == 5)
        {
            DIAG_BUFER[0] = 0x2E;
            DIAG_BUFER[1] = 0x02;
            DIAG_BUFER[2] = 0x1F;
            DIAG_BUFER[3] = 0x01;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 4);
        }
        if (Speed_limit[0] == 0x01 && MENU_CHECK_STEP == 49)
        {
            DIAG_BUFER[0] = 0x2E;
            DIAG_BUFER[1] = 0x02;
            DIAG_BUFER[2] = 0x1F;
            DIAG_BUFER[3] = 0x00;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 4);
        }
        loc_Step = 9;
        break;

    case 9:
        if (AIR_BAG[0] == 0xff)
        {
            DIAG_BUFER[0] = 0x2E;
            DIAG_BUFER[1] = 0x02;
            DIAG_BUFER[2] = 0x16;
            DIAG_BUFER[3] = 0x01;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 4); // 安全气囊配置
        }
        if (AIR_BAG[0] != 0x01 && MENU_CHECK_STEP == 5)
        {
            DIAG_BUFER[0] = 0x2E;
            DIAG_BUFER[1] = 0x02;
            DIAG_BUFER[2] = 0x16;
            DIAG_BUFER[3] = 0x01;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 4);
        }
        if (AIR_BAG[0] == 0x01 && MENU_CHECK_STEP == 49)
        {
            DIAG_BUFER[0] = 0x2E;
            DIAG_BUFER[1] = 0x02;
            DIAG_BUFER[2] = 0x16;
            DIAG_BUFER[3] = 0x00;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 4);
        }
        loc_Step = 10;
        break;

    case 10:
        if (ESC[0] == 0xff)
        {
            DIAG_BUFER[0] = 0x2E;
            DIAG_BUFER[1] = 0x02;
            DIAG_BUFER[2] = 0x07;
            DIAG_BUFER[3] = 0x07;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 4); // ESC配置
        }
        if (ESC[0] != 0x07 && MENU_CHECK_STEP == 5)
        {
            DIAG_BUFER[0] = 0x2E;
            DIAG_BUFER[1] = 0x02;
            DIAG_BUFER[2] = 0x07;
            DIAG_BUFER[3] = 0x07;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 4);
        }
        if (ESC[0] == 0x07 && (MENU_CHECK_STEP == 0 || MENU_CHECK_STEP == 2 || MENU_CHECK_STEP == 29 || MENU_CHECK_STEP == 31 || MENU_CHECK_STEP == 49))
        {
            DIAG_BUFER[0] = 0x2E;
            DIAG_BUFER[1] = 0x02;
            DIAG_BUFER[2] = 0x07;
            DIAG_BUFER[3] = 0x00;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 4);
        }
        loc_Step = 11;
        break;

    case 11:
        if (Failure[0] == 0xff)
        {
            DIAG_BUFER[0] = 0x2E;
            DIAG_BUFER[1] = 0x02;
            DIAG_BUFER[2] = 0x0D;
            DIAG_BUFER[3] = 0x06;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 4); // 变速箱故障配置
        }
        if (Failure[0] != 0x06 && MENU_CHECK_STEP == 5)
        {
            DIAG_BUFER[0] = 0x2E;
            DIAG_BUFER[1] = 0x02;
            DIAG_BUFER[2] = 0x0D;
            DIAG_BUFER[3] = 0x06;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 4);
        }
        if (Failure[0] == 0x06 && MENU_CHECK_STEP == 49)
        {
            DIAG_BUFER[0] = 0x2E;
            DIAG_BUFER[1] = 0x02;
            DIAG_BUFER[2] = 0x0D;
            DIAG_BUFER[3] = 0x00;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 4);
        }
        loc_Step = 12;
        break;

    case 12:
        DIAG_BUFER[0] = 0x22;
        DIAG_BUFER[1] = 0x02;
        DIAG_BUFER[2] = 0x0C;
        UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3); // 读胎压检测配置
        loc_Step = 13;
        break;

    case 13:
        DIAG_BUFER[0] = 0x22;
        DIAG_BUFER[1] = 0x02;
        DIAG_BUFER[2] = 0x1F;
        UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3); // 读限速报警配置
        loc_Step = 14;
        break;

    case 14:
        DIAG_BUFER[0] = 0x22;
        DIAG_BUFER[1] = 0x02;
        DIAG_BUFER[2] = 0x16;
        UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3); // 读安全气囊默认配置
        loc_Step = 15;
        break;

    case 15:
        DIAG_BUFER[0] = 0x22;
        DIAG_BUFER[1] = 0x02;
        DIAG_BUFER[2] = 0x07;
        UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3); // 读ESC默认配置
        loc_Step = 16;
        break;

    case 16:
        DIAG_BUFER[0] = 0x22;
        DIAG_BUFER[1] = 0x02;
        DIAG_BUFER[2] = 0x0D;
        UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3); // 读变速箱故障配置
        loc_Step = 17;
        break;

    case 17:
        // if ( Voltage_UDS [ 0 ] == 0xff )
        //{
        DIAG_BUFER[0] = 0x22;
        DIAG_BUFER[1] = 0x20;
        DIAG_BUFER[2] = 0x14;
        UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);
        //}
        loc_Step = 18;
        break;
    case 18:
        // if ( Voltage_UDS [ 0 ] == 0xff )
        //{
        DIAG_BUFER[0] = 0x19;
        DIAG_BUFER[1] = 0x0A;

        UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 2);
        //}
        loc_Step = 0;
        break;
        break;
    }

    if ((UnLock_Flag == 1) || (UnLock_Flag == 3))
    {
        if (UnLock_Retry != 0)
        {
            UnLock_Retry--;
        }
        else
        {
            if (UnLock_Flag == 1)
            {
                UnLock_Flag = 0u;
            }
            else if (UnLock_Flag == 3)
            {
                UnLock_Flag = 2;
            }
        }
    }
}
uint8_t LED_Waring = 0;
uint32_t config = 0;
void Function_Check_Ctrl(uint32_t cmd)
{
    uint8_t p[20];
    uint8_t DIAG_BUFER[40];
    uint32_t i;
    uint32_t j;
    static uint32_t status = 0;
    static uint32_t MENU_BACK = 0xff;
    static uint8_t UDS_EunD = 0;
    static uint16_t Jishi = 0;
    static uint16_t gerpi = 0;

    static ResetFlag = 0;

    SetWheelInfo(5119, 68);

    if (cmd == 0)
    {
    }
    else if (cmd == 1)
    {
        // Voltage_UDS__Display();
        FUEL_UDS__Display(0);

        if (MENU_CHECK_STEP >= 50)
        {
            MENU_CHECK_STEP = 0;
        }

        if (MENU_BACK != MENU_CHECK_STEP)
        {

            Execute_Specify_Step(MENU_CHECK_STEP); // Excel表格发报文。

            if (0) // 数字需要3位还是2位
            {
                p[0] = (MENU_CHECK_STEP + 1) / 100; // 65535
                p[1] = ((MENU_CHECK_STEP + 1) % 100) / 10;
                p[2] = (MENU_CHECK_STEP + 1) % 10; // 65535
                p[3] = 0xff;
            }
            else
            {
                p[0] = ((MENU_CHECK_STEP) % 100) / 10;
                p[1] = (MENU_CHECK_STEP) % 10; // 65535
                p[2] = 0xff;
            }
            if (General_Number_Disp(p, 190, 10) != 0) // 刷图：报文检测步数
            {
                MENU_BACK = MENU_CHECK_STEP;
            }
        }
        switch (MENU_CHECK_STEP)
        {
        case 0:
        {
            // 车速、转速0、水温0格、大计0、小计0、燃油指示灯常亮、时间显示00：00
            LINE_OUT_POS_01 = 0U; // 位置灯 A13
            LINE_OUT_POS_02 = 0U; // 左转灯 B25
            LINE_OUT_POS_03 = 0U; // 后雾灯 A1
            LINE_OUT_POS_04 = 0U; // 近光灯 B28
            LINE_OUT_POS_05 = 0U; // 昼行灯 A19
            LINE_OUT_POS_06 = 0U; // 前雾灯 A11
            LINE_OUT_POS_08 = 0U; // 右转灯 A4
            LINE_OUT_POS_09 = 0U; // 后视镜除霜工作指示灯 A18
            LINE_OUT_POS_10 = 0U; // 档位R A15
            LINE_OUT_NEG_01 = 0U; // 车门未关报警灯 B18
            LINE_OUT_NEG_02 = 0U; // 制动故障灯 A9
            LINE_OUT_NEG_03 = 0U; // 安全带 B19
            LINE_OUT_NEG_04 = 0U; // 冷却液位低 B24
            LINE_OUT_NEG_05 = 0U; // 安全气囊灯（熄灭） B7
            LINE_OUT_NEG_06 = 0U; // 机油压力低 A17
            LINE_OUT_NEG_07 = 0U; // 转向、离合液位低 B23
            LINE_OUT_NEG_08 = 0U; // 驻车制动灯 B29
            LINE_OUT_NEG_09 = 0U; // 转向故障灯 A9 EPS报警 A10
            LINE_OUT_NEG_10 = 0U; // 巡航工作灯 B1
            LINE_FUEL_RES01 = 0U; // 燃油0格
            LINE_FUEL_RES02 = 0U; // 燃油2格
            LINE_FUEL_RES03 = 0U; // 燃油4格
            LINE_FUEL_RES04 = 0U; // 燃油满格
            FT_CurVehSpeed = 0;   // 车速
            ResetFlag = 0;
            if (config == 0)
            {
                Display_Menu_Type = 1;
                config = 1;
            }
            break;
        }
        case 1:
        {
            if (config == 1)
            {
                Display_Menu_Type = 2;
                config = 0;
            }
            config = 0;
            // 驻车制动灯
            LINE_OUT_NEG_08 = 1; // 驻车制动
            LINE_OUT_NEG_09 = 0;

            break;
        }
        case 2:
        {
            // EPS报警、转向故障
            FT_CurVehSpeed = 0;
            LINE_OUT_NEG_08 = 0;
            LINE_OUT_NEG_09 = 1; // 转向故障灯
            LINE_OUT_NEG_10 = 0;
            break;
        }
        case 3:
        {
            // 巡航灯
            LINE_OUT_NEG_09 = 0;
            LINE_OUT_NEG_10 = 1; // 巡航工作灯
            LINE_OUT_POS_10 = 0;
            break;
        }
        case 4:
        {
            // 档位R
            LINE_OUT_NEG_10 = 0;
            LINE_OUT_POS_10 = 1; // R挡
            break;
        }
        case 5:
        {
            // 仪表配置，屏幕熄灭再点亮
            LINE_OUT_POS_10 = 0;
            LINE_FUEL_RES01 = 0;
            if (ResetFlag == 0)
            {
                Display_Menu_Type = 3;
                ResetFlag = 1;
                Service11Reset();
            }
            if (++gerpi > 50)
            {
                gerpi = 0;
                Display_Menu_Type = 2;
            }
            // else if (ResetFlag == 1)
            // {
            //     for (int i = 0; i < 100000; i++)
            //         Display_Menu_Type = 2;
            // }
            break;
        }
        case 6:
        {
            // 燃油显0格，燃油报警灯亮，水温0格，CNG 1格闪烁、车速0、转速0、档位N、安全气囊常量（下同）
            LINE_FUEL_RES01 = 1;
            LINE_FUEL_RES03 = 0;
            FT_CurVehSpeed = 0;
            if (ResetFlag == 1)
            {
                ResetFlag = 0;
                Display_Menu_Type = 2;
            }
            break;
        }
        case 7:
        {
            LINE_FUEL_RES01 = 0;
            LINE_FUEL_RES02 = 0;
            LINE_FUEL_RES03 = 1;
            FT_CurVehSpeed = 0;
            break;
        }
        case 8:
        {

            LINE_FUEL_RES03 = 0;
            LINE_FUEL_RES04 = 0;
            LINE_FUEL_RES02 = 1;
            FT_CurVehSpeed = 0;
            break;
        }
        case 9:
        {
            LINE_FUEL_RES01 = 0;
            LINE_FUEL_RES02 = 0;
            LINE_OUT_POS_01 = 0;
            LINE_FUEL_RES04 = 1;
            FT_CurVehSpeed = 0;

            break;
        }
        case 10:
        {
            LINE_FUEL_RES04 = 0;
            LINE_OUT_POS_02 = 0;
            LINE_FUEL_RES01 = 1;
            LINE_OUT_POS_01 = 1; // 位置灯
            FT_CurVehSpeed = 0;

            break;
        }
        case 11:
        {
            LINE_FUEL_RES01 = 0;
            LINE_OUT_POS_01 = 0;
            LINE_OUT_POS_02 = 1; // 左转
            FT_CurVehSpeed = 20;
            break;
        }
        case 12:
        {
            LINE_OUT_POS_02 = 0;
            LINE_OUT_POS_04 = 0;
            FT_CurVehSpeed = 40;

            break;
        }
        case 13:
        {
            LINE_OUT_POS_04 = 1; // 近光
            LINE_OUT_POS_05 = 0;
            FT_CurVehSpeed = 60;
            break;
        }
        case 14:
        {
            LINE_OUT_POS_04 = 0;
            LINE_OUT_POS_06 = 0;
            LINE_OUT_POS_05 = 1; // 昼行灯
            FT_CurVehSpeed = 80;
            break;
        }
        case 15:
        {
            LINE_OUT_POS_05 = 0;
            LINE_OUT_POS_03 = 0;
            LINE_OUT_POS_06 = 1; // 前雾灯
            FT_CurVehSpeed = 100;
            break;
        }
        case 16:
        {
            LINE_OUT_POS_06 = 0;
            LINE_OUT_POS_03 = 1; // 后雾灯
            FT_CurVehSpeed = 120;

            break;
        }
        case 17:
        {
            LINE_OUT_POS_03 = 0;
            FT_CurVehSpeed = 140;
            break;
        }
        case 18:
        {
            FT_CurVehSpeed = 160;
            break;
        }
        case 19:
        {
            LINE_OUT_POS_08 = 0;
            LINE_OUT_POS_10 = 0; // 正控10
            FT_CurVehSpeed = 180;
            break;
        }
        case 20:
        {
            LINE_OUT_NEG_01 = 0;
            LINE_OUT_POS_08 = 1; // 右转
            LINE_OUT_POS_10 = 1; // 正控10
            FT_CurVehSpeed = 20;
            break;
        }
        case 21:
        {
            LINE_OUT_POS_08 = 0;
            LINE_OUT_NEG_02 = 0;
            LINE_OUT_POS_10 = 0; // 正控10
            LINE_OUT_NEG_01 = 1; // 车门未关
            FT_CurVehSpeed = 20;
            break;
        }
        case 22:
        {
            LINE_OUT_NEG_01 = 0;
            LINE_OUT_NEG_02 = 1; // 制动故障灯
            FT_CurVehSpeed = 0;
            break;
        }
        case 23:
        {
            LINE_OUT_NEG_02 = 0;
            FT_CurVehSpeed = 0;
            break;
        }
        case 24:
        {
            FT_CurVehSpeed = 0;
            break;
        }
        case 25:
        {
            FT_CurVehSpeed = 0;
            break;
        }
        case 26:
        {
            FT_CurVehSpeed = 0;
            break;
        }
        case 27:
        {
            FT_CurVehSpeed = 0;
            break;
        }
        case 28:
        {
            FT_CurVehSpeed = 0;
            break;
        }
        case 29:
        {

            LINE_OUT_NEG_08 = 0;
            FT_CurVehSpeed = 0;
            break;
        }
        case 30:
        {
            LINE_OUT_NEG_08 = 1;
            FT_CurVehSpeed = 10;
            break;
        }
        case 31:
        {
            LINE_OUT_NEG_08 = 0;
            FT_CurVehSpeed = 0;
            break;
        }
        case 32:
        {
            FT_CurVehSpeed = 0;
            break;
        }
        case 33:
        {
            FT_CurVehSpeed = 0;
            break;
        }
        case 34:
        {
            FT_CurVehSpeed = 0;
            break;
        }
        case 35:
        {
            FT_CurVehSpeed = 0;
            break;
        }
        case 36:
        {
            FT_CurVehSpeed = 0;
            break;
        }
        case 37:
        {
            FT_CurVehSpeed = 0;
            break;
        }
        case 38:
        {
            LINE_OUT_NEG_03 = 0;
            FT_CurVehSpeed = 0;
            break;
        }
        case 39:
        {
            LINE_OUT_NEG_03 = 1; // 安全带
            FT_CurVehSpeed = 20;
            break;
        }
        case 40:
        {
            // 变速箱
            LINE_OUT_NEG_03 = 0;
            LINE_OUT_NEG_04 = 0;
            FT_CurVehSpeed = 0;
            break;
        }
        case 41:
        {
            LINE_OUT_NEG_05 = 0;
            LINE_OUT_NEG_04 = 1; // 冷却液位低
            FT_CurVehSpeed = 0;
            break;
        }
        case 42:
        {
            LINE_OUT_NEG_04 = 0;
            LINE_OUT_NEG_09 = 0; // EPS报警
            LINE_OUT_NEG_05 = 1; // 安全气囊
            FT_CurVehSpeed = 0;
            break;
        }
        case 43:
        {
            // 转向故障
            LINE_OUT_NEG_05 = 0;
            LINE_OUT_NEG_06 = 0;
            LINE_OUT_NEG_09 = 1; // EPS报警
            FT_CurVehSpeed = 0;
            break;
        }
        case 44:
        {
            LINE_OUT_NEG_09 = 0; // EPS报警
            LINE_OUT_NEG_07 = 0;
            LINE_OUT_NEG_06 = 1; // 机油压力低
            FT_CurVehSpeed = 0;
            break;
        }
        case 45:
        {
            FT_CurVehSpeed = 0;
            LINE_OUT_NEG_06 = 0;
            LINE_OUT_NEG_07 = 1; // 转向、离合液位低
            break;
        }
        case 46:
        {
            LINE_OUT_NEG_07 = 0;
            LINE_OUT_POS_09 = 0;
            FT_CurVehSpeed = 0;
            break;
        }
        case 47:
        {
            LINE_OUT_POS_09 = 1; // 后视镜除霜工作指示灯
            LINE_OUT_POS_01 = 0U;
            LINE_OUT_POS_02 = 0U;
            LINE_OUT_POS_03 = 0U;
            LINE_OUT_POS_04 = 0U;
            LINE_OUT_POS_05 = 0U;
            LINE_OUT_POS_06 = 0U;
            LINE_OUT_POS_08 = 0U;
            LINE_OUT_POS_10 = 0U;
            LINE_OUT_NEG_01 = 0U;
            LINE_OUT_NEG_02 = 0U;
            LINE_OUT_NEG_03 = 0U;
            LINE_OUT_NEG_04 = 0U;
            LINE_OUT_NEG_05 = 0U;
            LINE_OUT_NEG_06 = 0U;
            LINE_OUT_NEG_07 = 0U;
            LINE_OUT_NEG_08 = 0U;
            LINE_OUT_NEG_09 = 0U;
            LINE_OUT_NEG_10 = 0U;
            LINE_FUEL_RES01 = 0U;
            LINE_FUEL_RES02 = 0U;
            LINE_FUEL_RES03 = 0U;
            LINE_FUEL_RES04 = 0U;
            FT_CurVehSpeed = 0;
            break;
        }
        case 48:
        {
            // 全部点亮
            LINE_OUT_POS_01 = 1U;
            LINE_OUT_POS_02 = 1U;
            LINE_OUT_POS_03 = 1U;
            LINE_OUT_POS_04 = 1U;
            LINE_OUT_POS_05 = 1U;
            LINE_OUT_POS_06 = 1U;
            LINE_OUT_POS_08 = 1U;
            LINE_OUT_POS_09 = 1U;
            LINE_OUT_POS_10 = 1U;
            LINE_OUT_NEG_01 = 1U;
            LINE_OUT_NEG_02 = 1U;
            LINE_OUT_NEG_03 = 1U;
            LINE_OUT_NEG_04 = 1U;
            LINE_OUT_NEG_05 = 1U;
            LINE_OUT_NEG_06 = 1U;
            LINE_OUT_NEG_07 = 1U;
            LINE_OUT_NEG_08 = 1U;
            LINE_OUT_NEG_09 = 1U;
            LINE_OUT_NEG_10 = 1U;
            FT_CurVehSpeed = 180;
            ResetFlag = 0;
            break;
        }
        case 49:
        {
            LINE_OUT_POS_01 = 0U;
            LINE_OUT_POS_02 = 0U;
            LINE_OUT_POS_03 = 0U;
            LINE_OUT_POS_04 = 0U;
            LINE_OUT_POS_05 = 0U;
            LINE_OUT_POS_06 = 0U;
            LINE_OUT_POS_08 = 0U;
            LINE_OUT_POS_09 = 0U;
            LINE_OUT_POS_10 = 0U;
            LINE_OUT_NEG_01 = 0U;
            LINE_OUT_NEG_02 = 0U;
            LINE_OUT_NEG_03 = 0U;
            LINE_OUT_NEG_04 = 0U;
            LINE_OUT_NEG_05 = 0U;
            LINE_OUT_NEG_06 = 0U;
            LINE_OUT_NEG_07 = 0U;
            LINE_OUT_NEG_08 = 0U;
            LINE_OUT_NEG_09 = 0U;
            LINE_OUT_NEG_10 = 0U;
            FT_CurVehSpeed = 0;
            if (ResetFlag == 0)
            {
                Display_Menu_Type = 3;
                ResetFlag = 1;
                Service11Reset();
            }

            if (Jishi < 3000)
            {
                Jishi++;
            }
            else
            {
                CAN_Msg_Tx_Enable = 0u;
            }

            break;
        }
        default:
            break;
        }
        //can_send_setup(0);
    }
}
// 外发处理函数
// void can_send_setup(uint8_t Get_can)
// {
    // switch (Get_can)
    // {
    // case Sent_outgoing_DrvrSbltAtcHSC1_Count:
    //     {
    //         if(Get_ID_18E00017_Sig_DrvrSbltAtcHSC1() == 0x0)
    //         {
    //             Seat_belt_send = 0;
    //         }
    //         else
    //         {
    //             Seat_belt_send = 1;
    //         }
    //     }
    //     break;
    // case Sent_outgoing_ParkingBrakeSwitch_Count:
    //     {
    //         if(Get_ID_18FEF121_Sig_ParkingBrakeSwitch() == 1)
    //         {
    //             Parking_brake_send = 1;
    //         }
    //         else
    //         {
    //             Parking_brake_send = 0;
    //         }
    //     }
    //     break;
    // case Sent_outgoing_Sig_DoorOpenSw_Count:
    //     {
    //         if(Get_ID_18FF0917_Sig_DoorOpenSw() == 1)
    //         {
    //             DoorOpenSw_send = 1;
    //         }
    //         else
    //         {
    //             DoorOpenSw_send = 0;
    //         }
    //     }
    //     break;
    // default:
    //     break;
    // }
//     if (Get_ID_18E00017_Sig_DrvrSbltAtcHSC1() == 0x0)
//     {
//         Seat_belt_send = 0;
//     }
//     else
//     {
//         Seat_belt_send = 1;
//     }

//     if (Get_ID_18FEF121_Sig_ParkingBrakeSwitch() == 1)
//     {
//         Parking_brake_send = 1;
//     }
//     else
//     {
//         Parking_brake_send = 0;
//     }

//     if (Get_ID_18FF0917_Sig_DoorOpenSw() == 0x00u)
//     {
//         DoorOpenSw_send = 0;
//     }
//     else if (Get_ID_18FF0917_Sig_DoorOpenSw() == 0x01u)
//     {
//         DoorOpenSw_send = 1;
//     }
//     if (Get_ID_18FF0917_Sig_ReverseSw() == 0x00u)
//     {
//         ReverseSw_send = 0;
//     }
//     else if (Get_ID_18FF0917_Sig_ReverseSw() == 0x01u)
//     {
//         ReverseSw_send = 1;
//     }
// }
//void Get_ODO_Call(void)
//{
//}



//******************************673检测台************************************************** */
//标题
const unsigned char gImage_title[] = { 0X79,0X19,
0X00,0X00,0X00,0X00,0X00,0X00,0XE0,0X00,0X00,0X00,0X00,0X00,0X80,0X80,0X40,0X60,
0X00,0X00,0X00,0X00,0XC0,0X40,0X40,0X40,0X40,0X40,0X50,0X60,0X40,0X40,0X40,0X40,
0X40,0XC0,0X00,0X00,0XC0,0X40,0X40,0X40,0X40,0X40,0XF0,0X40,0X40,0X40,0X40,0X40,
0XC0,0X00,0X00,0X00,0X80,0X80,0XF0,0X80,0X80,0X00,0XE0,0X20,0X20,0X20,0X20,0XE0,
0X00,0X00,0X00,0X00,0X80,0X80,0XF0,0X80,0X80,0X00,0X00,0X80,0X60,0X30,0X20,0XC0,
0X80,0X00,0X00,0X00,0X10,0X60,0X40,0XE0,0XE0,0X20,0XA0,0X20,0XE0,0X00,0X00,0XE0,
0X00,0XF0,0X00,0X00,0X00,0X00,0X00,0X80,0X40,0X20,0X10,0X00,0X00,0X00,0XC0,0X80,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X08,0X08,0XFF,
0X08,0X08,0X0A,0X99,0X39,0X48,0X88,0X08,0X08,0X08,0X08,0X00,0X08,0X09,0X08,0X28,
0X78,0X4C,0X8F,0X89,0X88,0X88,0X48,0X38,0X08,0X08,0X09,0X08,0X00,0XFF,0X44,0X44,
0X44,0X44,0X44,0XFF,0X44,0X44,0X44,0X44,0X44,0X7F,0X80,0X00,0X40,0X30,0X0E,0XFF,
0X04,0X08,0X80,0X7F,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,0XC0,0X40,0X30,0X07,0XFF,
0X04,0X08,0X12,0XE5,0X04,0X14,0XF4,0X04,0XC4,0X35,0X01,0X02,0X01,0X02,0XE4,0X00,
0X3F,0X3F,0XC0,0XBF,0X00,0X3F,0X00,0X00,0X7F,0X00,0XFF,0X00,0X00,0X04,0X06,0XE5,
0X24,0X24,0X24,0X24,0X22,0X22,0X22,0X22,0X23,0XE3,0X04,0X08,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X03,0X01,0X01,0X01,0X00,0X00,0X00,0X00,
0X01,0X01,0X02,0X02,0X00,0X00,0X04,0X04,0X04,0X02,0X02,0X03,0X01,0X01,0X01,0X01,
0X02,0X02,0X04,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X03,0X02,0X02,0X02,
0X02,0X02,0X02,0X03,0X00,0X00,0X00,0X00,0X03,0X00,0X02,0X01,0X00,0X00,0X00,0X00,
0X00,0X03,0X02,0X02,0X01,0X00,0X00,0X00,0X07,0X00,0X00,0X02,0X02,0X02,0X02,0X02,
0X02,0X03,0X02,0X02,0X02,0X00,0X07,0X00,0X04,0X02,0X01,0X00,0X00,0X01,0X02,0X04,
0X00,0X04,0X04,0X07,0X00,0X00,0X00,0X00,0X07,0X02,0X02,0X02,0X02,0X02,0X02,0X02,
0X02,0X02,0X07,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,};

//霍尔电源
const unsigned char gImage_Hall_VDD[] =  { 0X46,0X1C,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X80,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X80,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X8C,0XC5,0XF5,0X75,0X55,0X55,0X45,0XEF,
0X45,0X55,0X55,0X55,0X45,0X4D,0X00,0X20,0X10,0X08,0X86,0X63,0X02,0X02,0X02,0XFA,
0X02,0X02,0X62,0XC2,0X1A,0X0E,0X02,0X00,0XFE,0X22,0X22,0X22,0X22,0X22,0XFF,0X22,
0X22,0X22,0X22,0X22,0XFE,0X00,0X00,0X00,0X18,0XB1,0X23,0X00,0XFF,0X01,0X01,0XF9,
0XA9,0XAF,0XA9,0XA9,0XA9,0XF9,0X01,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X00,
0X3F,0X15,0X15,0X15,0X15,0X1F,0X15,0X15,0X15,0X15,0X15,0X10,0X00,0X00,0X06,0X03,
0X00,0X00,0X10,0X10,0X10,0X0F,0X00,0X00,0X00,0X00,0X01,0X06,0X04,0X00,0X07,0X02,
0X02,0X02,0X02,0X02,0X1F,0X12,0X12,0X12,0X12,0X12,0X13,0X1C,0X04,0X00,0X3C,0X07,
0X30,0X1C,0X07,0X10,0X08,0X06,0X20,0X20,0X1F,0X00,0X06,0X08,0X10,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,};



//手动设置
const unsigned char gImage_hand_set[] = {0X67,0X1E,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X02,0X22,0X22,0X22,0X22,0X22,
0XFE,0X22,0X22,0X21,0X21,0X21,0X21,0X00,0X00,0X00,0X20,0X22,0XE2,0X22,0X22,0X22,
0X22,0X08,0X08,0XFF,0X08,0X08,0X08,0XF8,0X00,0X00,0XC0,0X70,0X9C,0X0A,0X08,0X88,
0XF8,0X00,0X00,0XFE,0X20,0X40,0XC0,0X80,0X00,0X00,0X0C,0X0F,0X08,0X88,0XF8,0XCF,
0X48,0X48,0X48,0X49,0X4B,0XCE,0XC8,0X08,0X08,0X20,0X30,0XF8,0XFC,0X92,0X93,0X92,
0X92,0XF2,0X9A,0X96,0X92,0X90,0XF0,0X00,0X00,0X00,0X00,0XFC,0X04,0X24,0X24,0XF4,
0XA4,0XA7,0XA6,0XA4,0XF4,0X24,0X24,0X24,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X02,0X02,0X02,0X02,0X22,0X22,0X22,0X3F,0X02,0X02,0X02,0X02,0X02,0X02,0X02,0X02,
0X00,0X0C,0X0B,0X09,0X04,0X05,0X06,0X38,0X18,0X06,0X01,0X20,0X20,0X20,0X1F,0X00,
0X01,0X20,0X10,0X10,0X09,0X07,0X01,0X00,0X00,0X00,0X3F,0X00,0X00,0X00,0X01,0X01,
0X20,0X30,0X08,0X46,0X41,0X20,0X21,0X32,0X14,0X18,0X18,0X26,0X23,0X40,0X40,0X40,
0X00,0X60,0X1F,0X07,0X04,0X04,0X04,0X04,0X7F,0X04,0X44,0X44,0X44,0X7F,0X00,0X00,
0X20,0X38,0X07,0X20,0X22,0X22,0X16,0X1A,0X1A,0X1A,0X1A,0X16,0X26,0X22,0X20,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,};


//霍尔计算角度
const unsigned char gImage_Hall_sig[] = {0X69,0X1E,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,0X80,0X80,
0X80,0X00,0X00,0X00,0X00,0X00,0X80,0X00,0X00,0X00,0X80,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X8C,0XC5,0XF5,0X75,
0X55,0X55,0X45,0XEF,0X45,0X55,0X55,0X55,0X45,0X4D,0X00,0X20,0X30,0X08,0X86,0X63,
0X02,0X02,0X02,0XFA,0X02,0X02,0X62,0XC2,0X1A,0X0E,0X00,0X00,0X80,0X8D,0X91,0XA1,
0X81,0X81,0X87,0XF9,0X81,0X81,0XB0,0X88,0X86,0X80,0X80,0X10,0X18,0X0C,0XFF,0XAA,
0XAA,0XAA,0XAA,0XFF,0XAB,0XAA,0XAA,0XAA,0XAA,0X82,0X00,0X10,0X18,0XFC,0XFE,0X49,
0X49,0X49,0X49,0XF9,0X4D,0X4B,0X49,0X48,0XF8,0X00,0X00,0X00,0X00,0XFE,0X02,0X12,
0X12,0X7A,0X52,0X53,0X53,0X52,0X7A,0X12,0X12,0X12,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X01,0X00,0X3F,0X15,0X15,0X15,0X15,0X1F,0X15,0X15,0X15,
0X15,0X15,0X10,0X00,0X00,0X06,0X03,0X00,0X00,0X10,0X10,0X10,0X0F,0X00,0X00,0X00,
0X00,0X01,0X06,0X04,0X10,0X10,0X08,0X08,0X04,0X02,0X03,0X01,0X3F,0X01,0X02,0X04,
0X08,0X08,0X10,0X10,0X10,0X12,0X12,0X0A,0X0A,0X0A,0X06,0X06,0X1F,0X06,0X02,0X0A,
0X0A,0X12,0X12,0X10,0X00,0X30,0X0F,0X03,0X02,0X02,0X02,0X02,0X3F,0X02,0X22,0X22,
0X22,0X3F,0X00,0X00,0X10,0X1C,0X07,0X10,0X11,0X11,0X0B,0X0D,0X0D,0X0D,0X0D,0X0B,
0X13,0X11,0X10,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,};

//显示屏角度
const unsigned char gImage_lcd[] = {0X73,0X18,
0X00,0X00,0X00,0XE0,0XA0,0XA0,0XA0,0XA0,0XA0,0XA0,0XA0,0XA0,0XA0,0XA0,0XE0,0X00,
0X00,0X00,0X00,0X20,0X20,0X20,0X20,0X20,0X20,0X20,0X20,0X20,0X20,0X20,0X20,0X00,
0X00,0X00,0X00,0XE0,0X20,0X20,0X20,0X20,0X20,0X20,0X20,0X20,0X20,0X20,0X20,0XE0,
0X00,0X00,0X00,0XE0,0X20,0X20,0X20,0X20,0X20,0X20,0X20,0X20,0X10,0X10,0X10,0X00,
0X00,0X00,0X80,0X70,0X40,0XC0,0X40,0XE0,0X20,0X20,0X20,0XF0,0X20,0X20,0X20,0XE0,
0X00,0X00,0X00,0X80,0XC0,0X20,0X30,0X20,0X20,0X20,0XA0,0X60,0X20,0X00,0X00,0X00,
0X00,0X00,0X00,0XC0,0X40,0X40,0X40,0X40,0X40,0X70,0X60,0X40,0X40,0X40,0X40,0X40,
0X00,0X00,0X00,0X00,0X00,0X00,0X2F,0XC4,0X04,0X04,0XF4,0X04,0X04,0XF4,0X14,0X04,
0XC4,0X2F,0X10,0X00,0X02,0X82,0X62,0X32,0X0A,0X02,0X02,0X02,0XFE,0X02,0X02,0X02,
0X1A,0X62,0XC2,0X02,0X00,0X80,0XFF,0X41,0X49,0X49,0XEB,0X7D,0X49,0X49,0X4D,0XFF,
0X4B,0X49,0X49,0X40,0X00,0X80,0X7F,0X01,0X01,0X07,0X19,0XB1,0XE1,0X41,0XA1,0X19,
0X0D,0X03,0X00,0X00,0X04,0X01,0XFC,0X00,0X03,0X04,0XF5,0X15,0X15,0X15,0XD7,0X15,
0X15,0X15,0XF5,0X04,0X02,0X03,0XFF,0X4D,0X49,0X49,0X49,0X49,0XFF,0X49,0X49,0X49,
0X49,0XFF,0X00,0X00,0X00,0X80,0X7F,0X00,0X22,0X22,0X6F,0XAA,0XAA,0XAA,0XAA,0X6F,
0X63,0X22,0X02,0X00,0X00,0X00,0X00,0X02,0X02,0X02,0X02,0X02,0X02,0X03,0X02,0X02,
0X03,0X02,0X02,0X02,0X02,0X02,0X02,0X00,0X01,0X00,0X00,0X00,0X02,0X02,0X02,0X03,
0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X02,0X01,0X00,0X00,0X02,0X03,0X01,0X00,0X00,
0X00,0X00,0X03,0X00,0X00,0X00,0X00,0X02,0X01,0X00,0X02,0X02,0X01,0X01,0X00,0X00,
0X00,0X00,0X01,0X01,0X03,0X02,0X02,0X00,0X00,0X03,0X01,0X01,0X04,0X04,0X00,0X02,
0X03,0X01,0X01,0X02,0X02,0X04,0X00,0X00,0X06,0X01,0X00,0X00,0X00,0X00,0X00,0X07,
0X00,0X04,0X04,0X04,0X07,0X01,0X00,0X02,0X01,0X00,0X02,0X02,0X02,0X01,0X01,0X01,
0X01,0X01,0X01,0X02,0X02,0X02,0X00,0X00,0X00,};


//boot
const unsigned char gImage_boot[] = {0X63,0X18,
0X00,0X00,0X00,0X00,0XE0,0X20,0X20,0X20,0X20,0XC0,0X00,0X00,0X00,0X00,0X80,0X40,
0X20,0X20,0X20,0X20,0X20,0X40,0X80,0X00,0X00,0X00,0X00,0X80,0X40,0X20,0X20,0X20,
0X20,0X20,0X40,0X80,0X00,0X00,0X20,0X20,0X20,0X20,0XE0,0X20,0X20,0X20,0X20,0X00,
0XF0,0XF0,0X00,0XF0,0X00,0X00,0XE0,0X20,0X20,0X20,0X20,0X20,0X10,0X10,0X00,0X00,
0X40,0X40,0X40,0X40,0X40,0X40,0XF0,0XF0,0X40,0X40,0X40,0X40,0X40,0X40,0X00,0X00,
0X00,0X00,0XE0,0X20,0X20,0X20,0X20,0X20,0X20,0X20,0X20,0XE0,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X04,0X04,0X04,0X06,0XDB,0X70,0X00,0X00,
0X3F,0X61,0X80,0X00,0X00,0X00,0X00,0X00,0X80,0X61,0X3F,0X00,0X00,0X3F,0X61,0X80,
0X00,0X00,0X00,0X00,0X00,0X80,0X61,0X3F,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,
0X00,0X00,0X00,0XFF,0X7F,0X12,0XF3,0X02,0X02,0XFF,0X02,0X1E,0X72,0XC2,0X42,0X3A,
0X06,0X00,0X80,0XC0,0X60,0X10,0X88,0X86,0X83,0XFF,0XFF,0X81,0X84,0X98,0X30,0X60,
0XC0,0X00,0X08,0X08,0X08,0X6B,0X59,0X49,0X49,0X49,0X49,0X49,0X49,0X49,0XCB,0XC8,
0X08,0X08,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X01,0X01,0X01,0X01,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X01,0X01,0X01,0X01,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X01,0X01,0X01,0X01,0X01,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X01,0X00,0X00,0X00,0X00,0X00,0X03,0X00,0X00,0X07,0X04,0X07,0X01,0X04,0X02,0X03,
0X01,0X01,0X02,0X04,0X04,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X03,0X03,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X02,0X02,0X02,0X02,0X02,
0X02,0X03,0X00,0X00,0X00,0X00,0X00,0X00,0X00,};


//flash
const unsigned char gImage_flash[] = { 0X5B,0X1C,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,0X80,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,
0X80,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,0X80,0X00,0X80,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X80,0X80,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0X21,
0X21,0X21,0X21,0X01,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X90,0X88,0X88,0X48,0XF8,
0XE0,0X00,0X00,0X70,0XD8,0X88,0X88,0X00,0X00,0X00,0XFF,0XFF,0X10,0X08,0X08,0X08,
0XF8,0XE0,0X00,0X00,0XFF,0XFF,0X90,0X9F,0X10,0X10,0XFF,0X11,0XF1,0X11,0X11,0X11,
0XD0,0X30,0X00,0X00,0X02,0X02,0X82,0X42,0X32,0X1A,0XFF,0X3E,0X0A,0X22,0XC2,0X82,
0X02,0X02,0X00,0X40,0X40,0X40,0X5F,0XC9,0X49,0X49,0X49,0X49,0X49,0X49,0X49,0X5F,
0X50,0X40,0X40,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X0F,0X0F,0X00,0X00,0X07,0X0C,0X08,0X08,0X0C,0X0F,0X0F,0X00,0X00,0X08,0X08,
0X08,0X09,0X07,0X00,0X00,0X0F,0X0F,0X00,0X00,0X00,0X00,0X0F,0X0F,0X00,0X00,0X3F,
0X03,0X00,0X3F,0X20,0X38,0X0F,0X20,0X10,0X0B,0X0E,0X0A,0X11,0X20,0X20,0X04,0X06,
0X03,0X00,0X04,0X04,0X04,0X1F,0X04,0X04,0X04,0X04,0X01,0X03,0X06,0X00,0X00,0X00,
0X00,0X03,0X02,0X02,0X12,0X12,0X12,0X12,0X12,0X12,0X1E,0X06,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,};


const unsigned char gImage_eeprom[] = { 0X7B,0X19,
0X00,0X00,0X00,0X00,0XE0,0X20,0X20,0X20,0X20,0X20,0X00,0X00,0X00,0XE0,0X20,0X20,
0X20,0X20,0X20,0X00,0X00,0X00,0XE0,0X20,0X20,0X20,0X20,0X40,0XC0,0X00,0X00,0X00,
0XE0,0X20,0X20,0X20,0X60,0XC0,0X00,0X00,0X00,0X00,0X80,0X40,0X20,0X20,0X20,0X20,
0X20,0X40,0X80,0X00,0X00,0X00,0X00,0XE0,0XE0,0X80,0X00,0X00,0X00,0X00,0X00,0X00,
0X80,0X60,0XE0,0X00,0X00,0X00,0XF0,0XF0,0X00,0XF0,0X00,0X00,0XE0,0X20,0X20,0X20,
0X20,0X20,0X10,0X10,0X00,0X00,0X40,0X40,0X40,0X40,0X40,0X40,0XF0,0XF0,0X40,0X40,
0X40,0X40,0X40,0X40,0X00,0X00,0X00,0X00,0XE0,0X20,0X20,0X20,0X20,0X20,0X20,0X20,
0X20,0XE0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,
0X04,0X04,0X04,0X04,0X00,0X00,0X00,0X00,0XFF,0X04,0X04,0X04,0X04,0X00,0X00,0X00,
0X00,0XFF,0X08,0X08,0X08,0X08,0X04,0X03,0X00,0X00,0X00,0XFF,0X08,0X08,0X18,0X34,
0XE7,0X81,0X00,0X00,0X3F,0X61,0X80,0X00,0X00,0X00,0X00,0X00,0X80,0X61,0X3F,0X00,
0X00,0X00,0XFF,0X00,0X03,0X0E,0X30,0XE0,0XC0,0X30,0X0E,0X03,0X00,0XFF,0X00,0X00,
0X00,0XFF,0X7F,0X12,0XF3,0X02,0X02,0XFF,0X02,0X1E,0X72,0XC2,0X42,0X3A,0X06,0X00,
0X80,0XC0,0X60,0X10,0X88,0X86,0X83,0XFF,0XFF,0X81,0X84,0X98,0X30,0X60,0XC0,0X00,
0X08,0X08,0X08,0X6B,0X59,0X49,0X49,0X49,0X49,0X49,0X49,0X49,0XCB,0XC8,0X08,0X08,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X01,0X01,0X01,0X01,0X01,
0X00,0X00,0X00,0X01,0X01,0X01,0X01,0X01,0X01,0X00,0X00,0X00,0X01,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X00,0X00,0X00,0X00,0X00,0X01,0X01,0X00,0X00,
0X00,0X00,0X01,0X01,0X01,0X01,0X01,0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X00,0X00,
0X00,0X00,0X01,0X01,0X00,0X00,0X00,0X00,0X01,0X00,0X00,0X00,0X03,0X00,0X00,0X07,
0X04,0X07,0X01,0X04,0X02,0X03,0X01,0X01,0X02,0X04,0X04,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X03,0X03,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X02,0X02,0X02,0X02,0X02,0X02,0X03,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,};



const unsigned char gImage_mv[] = { 0X32,0X19,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XC0,0X60,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,0XE0,0X78,0X0F,0X03,
0X00,0X00,0X00,0XFE,0X0C,0X06,0X02,0X02,0X06,0XFE,0XFC,0X06,0X02,0X02,0X06,0XFE,
0XF8,0X00,0X02,0X1E,0X78,0XE0,0X00,0XC0,0XF0,0X1E,0X06,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X1C,0X07,0X01,0X00,
0X00,0X00,0X00,0X00,0X00,0X03,0X00,0X00,0X00,0X00,0X00,0X03,0X03,0X00,0X00,0X00,
0X00,0X03,0X03,0X00,0X00,0X00,0X00,0X03,0X03,0X03,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,};

const unsigned char gImage_FREQ[] = { 0X2A,0X12,
0X00,0X00,0X00,0X00,0XF0,0X10,0X10,0X10,0X00,0X00,0XF0,0X10,0X10,0X10,0XB0,0XE0,
0X00,0X00,0XF0,0X10,0X10,0X10,0X10,0X00,0XC0,0X60,0X30,0X10,0X10,0X10,0X30,0XE0,
0X80,0X00,0X00,0X00,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X1F,0X01,
0X01,0X01,0X00,0X00,0X1F,0X01,0X01,0X03,0X06,0X18,0X10,0X00,0X1F,0X11,0X11,0X11,
0X11,0X00,0X07,0X0C,0X18,0X10,0X10,0X10,0X18,0X2F,0X23,0X00,0X00,0X00,0X10,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,};


//频率

const unsigned char NO_L1 [] = {24, 24,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0XF0,0XF0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X1F,0X1F,0X18,0X18,0X18,0X18,0X18,0X18,0X18,0X18,0X00,0X00,0X00,0X00,0X00,0X00,};


const unsigned char NO_R1 [] = {24, 24,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0XF0,0XF0,0X30,0X30,0X30,0X20,0X60,0XE0,0XC0,0X80,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X30,0X30,0X30,0X70,0XF8,0X9C,0X0F,0X07,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X1F,0X1F,0X00,
0X00,0X00,0X00,0X01,0X0F,0X1E,0X18,0X00,0X00,0X00,0X00,0X00,0X00,};

const unsigned char NO_M1 [] = {24, 24,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0XF0,0XF0,0XF0,0X00,0X00,0X00,0X80,0XF0,0XF0,0XF0,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X0F,0XFF,0XE0,0XE0,0XFF,0X07,
0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X1F,0X1F,0X00,0X01,0X1F,0X1F,0X00,0X00,0X1F,0X1F,0X00,0X00,0X00,0X00,0X00,0X00,};


const unsigned char gImage_DUTY[] =  { 0X28,0X12,
0X00,0X00,0XF0,0X10,0X10,0X20,0X20,0X60,0XC0,0X00,0X00,0XF0,0X00,0X00,0X00,0X00,
0XE0,0XE0,0X00,0X30,0X10,0X30,0XF0,0X30,0X10,0X00,0X30,0XE0,0X80,0X00,0X80,0X60,
0X30,0X00,0X00,0X80,0X80,0X00,0X00,0X00,0X00,0X00,0X3F,0X30,0X10,0X10,0X10,0X08,
0X07,0X00,0X00,0X1F,0X10,0X20,0X20,0X10,0X1F,0X07,0X00,0X00,0X00,0X00,0X1F,0X00,
0X00,0X00,0X00,0X00,0X01,0X1E,0X01,0X00,0X00,0X00,0X00,0X10,0X10,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,};

//占空比

const unsigned char gImage_100[] = { 0X14,0X14,
0X00,0X00,0X00,0X00,0XE0,0X10,0X10,0X30,0X40,0X00,0X80,0X60,0X10,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X01,0X21,0X19,0X04,0X03,0X3C,0X26,
0X02,0X24,0X18,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,};//%比


const unsigned char gImage_Hz[] = { 0X14,0X0B,
0X00,0X00,0XC0,0X30,0X0C,0X00,0XFE,0X10,0X10,0X10,0X10,0XFE,0X00,0X88,0XC8,0XB8,
0X88,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,};//HZ




const unsigned char gImage_KHZ[] = { 0X19,0X0F,
0X00,0X00,0X00,0X40,0X18,0X00,0XF8,0X80,0X40,0X20,0X00,0XF0,0X40,0X40,0X40,0X40,
0XF0,0X00,0X20,0XA0,0X60,0X20,0X00,0X00,0X00,0X00,0X04,0X03,0X00,0X00,0X00,0X03,
0X00,0X01,0X02,0X00,0X03,0X00,0X00,0X00,0X00,0X03,0X00,0X02,0X03,0X02,0X02,0X00,
0X00,0X00,};
//KHZ


//NUMBER
const unsigned char NO_00 []= {24, 24,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XC0,0XE0,0X70,0X30,0X30,0X60,0XE0,
0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X01,0XFF,0XFE,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X07,0X0E,0X0C,0X18,0X18,0X0C,0X0F,
0X07,0X00,0X00,0X00,0X00,0X00,0X00,0X00,};

const unsigned char NO_11 []= {24, 24,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,0XC0,0XE0,0XF0,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X03,0X01,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0X0F,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,};

const unsigned char NO_22 []= {24, 24,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,0XE0,0X60,0X30,0X30,0X30,0X70,0XE0,
0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X01,0X01,0X00,0X80,0XC0,0XE0,0X38,0X1F,0X07,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X08,0X0E,0X0F,0X0B,0X09,0X08,0X08,0X08,
0X08,0X08,0X00,0X00,0X00,0X00,0X00,0X00,};

const unsigned char NO_33 []= {24, 24,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,0XC0,0X60,0X30,0X30,0X30,0X30,0XE0,
0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X01,0X01,0X00,0X00,0X18,0X18,0X38,0X7F,0XE7,0X80,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X03,0X07,0X0C,0X18,0X18,0X18,0X0C,0X0E,
0X07,0X01,0X00,0X00,0X00,0X00,0X00,0X00,};

const unsigned char NO_44 []= {24, 24,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XC0,0XE0,0XF0,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,
0XC0,0XF0,0XB8,0X8E,0X87,0X81,0XFF,0XFF,0X80,0X80,0X80,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X01,0X01,0X01,0X01,0X01,0X01,0X0F,0X0F,
0X01,0X01,0X01,0X00,0X00,0X00,0X00,0X00,};

const unsigned char NO_55 []= {24, 24,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XE0,0XE0,0X20,0X20,0X20,0X20,0X20,
0X20,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X1C,0X1F,0X0D,0X04,0X04,0X0C,0X0C,0X3C,0XF8,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X07,0X0E,0X08,0X18,0X18,0X18,0X0C,0X0F,
0X07,0X00,0X00,0X00,0X00,0X00,0X00,0X00,};

const unsigned char NO_66 []= {24, 24,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XC0,0XF0,0X30,0X10,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0XE0,0XF8,0X1E,0X0F,0X0D,0X0C,0X0C,0X18,0XF8,0XF0,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X03,0X07,0X0C,0X18,0X18,0X18,0X18,0X0C,
0X0F,0X03,0X00,0X00,0X00,0X00,0X00,0X00,};

const unsigned char NO_77 []= {24, 24,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X20,0X20,0X20,0X20,0X20,0X20,0X20,0XA0,
0XE0,0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0XE0,0XF8,0X1E,0X07,0X01,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X08,0X0F,0X07,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,};

const unsigned char NO_88 []= {24, 24,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,0XE0,0X60,0X30,0X30,0X30,0X20,0XE0,
0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0XE3,0XFF,0X3C,0X18,0X18,0X18,0X3C,0X3F,0XE7,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X07,0X0F,0X0C,0X18,0X18,0X18,0X18,0X0C,
0X07,0X03,0X00,0X00,0X00,0X00,0X00,0X00,};

const unsigned char NO_99 []= {24, 24,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XC0,0XE0,0X60,0X30,0X30,0X30,0X60,0XE0,
0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X02,
0X1F,0X3D,0X30,0X60,0X60,0XE0,0XF0,0X7F,0X1F,0X03,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X10,0X1C,0X0F,0X03,0X01,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,};

const unsigned char gImage_ANGLE[] = {0X1E,0X1B,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,
0XC0,0X40,0X00,0XC0,0X40,0X40,0X40,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XC0,0XF0,0X3E,0X07,0X01,0X00,
0X00,0X03,0X06,0X04,0X04,0X03,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X60,0X78,0X1E,0X03,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,};


const unsigned char gImage_GND[] = {0X50,0X15,
0X00,0X00,0X00,0XE0,0XF0,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X00,0X00,0X00,0X00,
0X00,0X80,0X80,0X80,0X00,0X00,0X00,0X00,0XF0,0X00,0X00,0X00,0XF0,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X80,0XC0,0X60,0X30,0X30,0X10,0X10,0X30,0X30,0X00,0X00,0X00,
0XF0,0XF0,0XE0,0X80,0X00,0X00,0X00,0X00,0XF0,0X00,0X00,0X00,0X00,0XF0,0X30,0X30,
0X30,0X30,0X30,0X60,0XC0,0X80,0X00,0X00,0X00,0X00,0X80,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X7F,0X7F,0X02,0X02,0X02,0X02,0X02,0X02,0X7F,0X00,0X00,0X00,0X70,
0X59,0XC9,0X49,0X4D,0X7F,0X7E,0X00,0X00,0X7F,0X00,0X00,0X00,0X7F,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X1F,0X30,0X60,0X40,0XC0,0XC4,0X46,0X46,0X7E,0X00,0X00,0X00,
0X7F,0X7F,0X00,0X01,0X07,0X0C,0X38,0X70,0X7F,0X00,0X00,0X00,0X00,0X7F,0X40,0X40,
0X40,0X40,0X40,0X60,0X30,0X1F,0X00,0X00,0X00,0X00,0X41,0X41,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
};

const unsigned char gImage_dian[] = {0X09,0X0A,
0X00,0X00,0X00,0X30,0X30,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,};// .

const unsigned char gImage_motor_state[] = {0X64,0X16,
0X00,0X00,0XE0,0X20,0X20,0X20,0X20,0XF8,0XF0,0X20,0X20,0X20,0X20,0XE0,0X00,0X00,
0X00,0X40,0X40,0XF8,0X40,0X40,0X00,0X00,0XF0,0X10,0X10,0X10,0XF0,0X00,0X00,0X00,
0X00,0X80,0X60,0X18,0X80,0X80,0X80,0X80,0X80,0XF8,0X80,0X80,0XD0,0X60,0X40,0X00,
0X00,0XF0,0X10,0X10,0X10,0XF0,0X80,0XC0,0XF0,0XB8,0X20,0X20,0XE0,0X60,0X00,0X00,
0X40,0X80,0X00,0XF8,0X00,0X00,0X00,0X00,0X00,0XF8,0X00,0X10,0X20,0X20,0X00,0X00,
0X20,0X20,0X20,0X20,0X20,0XE0,0XF8,0XF0,0X20,0X20,0X20,0X20,0X20,0X20,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X7F,0X22,0X22,0X22,0X22,0XFF,0XFF,0X22,0X22,0X22,
0X22,0X3F,0X00,0XC0,0X00,0X38,0X0E,0XFF,0X00,0X04,0X80,0XF8,0X0F,0X00,0X00,0X00,
0XFF,0X00,0X00,0XC0,0X00,0X33,0X3F,0X93,0X91,0X80,0X08,0X0C,0X8C,0X9F,0XE4,0XC4,
0X24,0X14,0XC4,0X40,0X00,0XFD,0X01,0XFF,0X89,0X01,0X08,0XF8,0X34,0X17,0X13,0X17,
0X34,0XFC,0X08,0X00,0X20,0X31,0X18,0XFF,0X00,0X01,0X81,0XE1,0X3D,0X0F,0X39,0X61,
0X81,0X01,0X00,0X00,0XCC,0X6C,0X04,0XE2,0X03,0X03,0X34,0X20,0X01,0X03,0XC2,0X24,
0X6C,0XCC,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X01,
0X01,0X03,0X03,0X03,0X03,0X03,0X01,0X01,0X00,0X00,0X00,0X03,0X00,0X02,0X03,0X00,
0X00,0X00,0X00,0X00,0X01,0X03,0X01,0X01,0X00,0X01,0X01,0X00,0X00,0X02,0X03,0X01,
0X01,0X00,0X00,0X01,0X03,0X02,0X03,0X00,0X01,0X01,0X01,0X01,0X01,0X00,0X00,0X03,
0X03,0X01,0X01,0X01,0X03,0X03,0X00,0X00,0X00,0X00,0X00,0X03,0X02,0X03,0X01,0X00,
0X00,0X00,0X00,0X00,0X01,0X01,0X00,0X00,0X01,0X00,0X00,0X01,0X01,0X02,0X02,0X02,
0X02,0X01,0X01,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,};

const unsigned char gImage_cuo1[] = {24, 24,0X00,0X00,0X00,0X00,0X30,0X70,0XE0,
0XC0,0X80,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,0XC0,0X70,0X30,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X83,0XC7,0X66,0X38,0X38,0X7C,0XE6,
0XC3,0X81,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0C,0X0C,0X06,
0X03,0X01,0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X03,0X07,0X0E,0X0C,0X00,0X00,0X00,0X00,};

const unsigned char gImage_dui1[] = {24, 24,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,0XC0,0XE0,0X40,0X00,
0X00,0X00,0X00,0X08,0X18,0X30,0X70,0XC0,0X80,0X00,0X00,0X80,0XC0,0XE0,0X70,0X38,
0X1C,0X0E,0X07,0X03,0X01,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X01,0X03,0X07,0X03,0X01,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,};



const unsigned char *p[10]={NO_00,NO_11,NO_22,NO_33,NO_44,NO_55,NO_66,NO_77,NO_88,NO_99};





static uint32_t test = 0;

//CANFD报文
uint8_t calibration[8]={0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00};
uint8_t angle0[8]={0x00,0x17,0x80,0x00,0x00,0x00,0x00,0x00};
uint8_t angle1[8]={0x00,0x04,0x40,0x00,0x00,0x00,0x00,0x00};
uint8_t angle2[8]={0x00,0x07,0xC0,0x00,0x00,0x00,0x00,0x00};
uint8_t angle3[8]={0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00};
uint8_t angle4[8]={0x00,0x08,0x40,0x00,0x00,0x00,0x00,0x00};
uint8_t angle5[8]={0x00,0x08,0x80,0x00,0x00,0x00,0x00,0x00};
uint8_t angle6[8]={0x00,0x08,0xC0,0x00,0x00,0x00,0x00,0x00};
uint8_t angle7[8]={0x00,0x09,0x00,0x00,0x00,0x00,0x00,0x00};
uint8_t angle8[8]={0x00,0x09,0x40,0x00,0x00,0x00,0x00,0x00};
uint8_t angle9[8]={0x00,0x09,0x80,0x00,0x00,0x00,0x00,0x00};
uint8_t angle10[8]={0x00,0x09,0xC0,0x00,0x00,0x00,0x00,0x00};
uint8_t angle11[8]={0x00,0x0A,0x00,0x00,0x00,0x00,0x00,0x00};
uint8_t angle12[8]={0x00,0x0A,0x40,0x00,0x00,0x00,0x00,0x00};
uint8_t angle_1[8]={0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00};
uint8_t angle_2[8]={0x00,0x06,0xC0,0x00,0x00,0x00,0x00,0x00};
uint8_t angle_3[8]={0x00,0x06,0x80,0x00,0x00,0x00,0x00,0x00};
uint8_t angle_4[8]={0x00,0x06,0x40,0x00,0x00,0x00,0x00,0x00};
uint8_t angle_5[8]={0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00};
uint8_t angle_6[8]={0x00,0x05,0xC0,0x00,0x00,0x00,0x00,0x00};
uint8_t angle_7[8]={0x00,0x05,0x80,0x00,0x00,0x00,0x00,0x00};
uint8_t angle_8[8]={0x00,0x05,0x40,0x00,0x00,0x00,0x00,0x00};
uint8_t angle_9[8]={0x00,0x05,0x00,0x00,0x00,0x00,0x00,0x00};
uint8_t angle_10[8]={0x00,0x04,0x40,0x00,0x00,0x00,0x00,0x00};
uint8_t angle_11[8]={0x00,0x40,0x80,0x00,0x00,0x00,0x00,0x00};
uint8_t angle_12[8]={0x00,0x04,0x40,0x00,0x00,0x00,0x00,0x00};
uint8_t angle13[8]={0x00,0x04,0x40,0x00,0x00,0x00,0x00,0x00};
uint8_t angle_13[8]={0x00,0x0A,0xC0,0x00,0x00,0x00,0x00,0x00};
uint8_t angle_reset[8]={0x00,0x07,0x80,0x00,0x00,0x00,0x00,0x00};
uint8_t hold_master[8]={0x00,0x1F,0XC0,0X00,0X00,0X00,0X00,0X00};

const unsigned char NO_F1 [] = {24, 24,0X00,0X00,0X00,0X00,0X00,0X00
,0X00,0X00,0XF0,0XF0,0X30,0X30,0X30,0X30,0X30,0X30,0X30,0X30,0X00,0X00
,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,
0X10,0X10,0X10,0X10,0X10,0X10,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X1F,0X1F,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,};


const unsigned char NO_B1 [] = {24, 24,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0XF0,0XF0,0X30,0X30,0X30,0X20,0X60,0XE0,0XC0,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X18,0X18,0X18,
0X18,0X18,0X3F,0XE7,0XC3,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X1F,0X1F,0X18,0X18,0X18,0X18,0X0C,0X0E,0X0F,0X03,0X00,
0X00,0X00,0X00,0X00,0X00,};

const unsigned char NO_V1 [] = {24, 24,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X30,0XF0,0XE0,0X00,0X00,0X00,0X00,0X00,0X80,0XF0,0XF0,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X1F,0XFF,0XF0,0X00,
0X80,0XF8,0X7F,0X07,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X07,0X1F,0X1F,0X03,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,};


uint8_t *p1[]={angle1,angle2,angle3,angle4,angle5,angle6,angle7,angle8,angle9,angle10,
                angle11,angle12,angle13,angle_1,angle_2,angle_3,angle_4,angle_5,angle_6,
                angle_7,angle_8,angle_9,angle_10,angle_11,angle_12,angle_13};


void Motor_Test_Display(void)
{
    test++;
    if(test==99)test=0;
    static uint16_t Hall_Vcc = 0;
    
       
    
    TFT_LCD_Draw_Bmp(60,10,( uint8_t * )gImage_title);


    TFT_LCD_Draw_Bmp(15,45,( uint8_t * )gImage_Hall_VDD);
    TFT_LCD_Draw_Bmp(185,45,( uint8_t * )gImage_mv);
    Hall_Vcc =  ADC_Conv_Single_Channel(HALL_5VADC);
    Motor_Test_HALL_VDD(Hall_Vcc);//ADC
  




    TFT_LCD_Draw_Bmp(15,69+5,( uint8_t * )gImage_hand_set);
    Hand_set_angle(HAND_SET);
    


    

    TFT_LCD_Draw_Bmp(15,95+10,( uint8_t * )gImage_Hall_sig);
    static int16_t temp=0; 
    temp = Hall_Duty_Conversion_Angle(Hall_Sig_Duty_c);
    Hall_angle(temp);
    static uint8_t TEST = 0;
    
    

    //test = get_0x2de_trg();
    TFT_LCD_Draw_Bmp(15,122+20,( uint8_t * )gImage_lcd);
    TEST =  Get_CANFD_CH0_ID_53C_Sig_MotorScreenAgFb();
    if (TEST==0X2B)
    {
         Display_angle(13);
    }
    else if(TEST==0X11)
    {
         Display_angle(-13);
    }
    else if(TEST==0X1E)
    {
         Display_angle(0);
    }
    
    
    
   




    TFT_LCD_Draw_Bmp(15,150+25,( uint8_t * )gImage_boot);
    Boot_v();
    
     
     


    TFT_LCD_Draw_Bmp(15,170+40,( uint8_t * )gImage_flash);
    Flash_v();

     
   


    TFT_LCD_Draw_Bmp(15,200+50-5,( uint8_t * )gImage_eeprom);
    EEprom_v();

    
    TFT_LCD_Draw_Bmp(16,220+50,( uint8_t * )gImage_motor_state);
    if(Hall_Sig_Duty_c>0)
    {
         TFT_LCD_Draw_Bmp(145,220+50,( uint8_t * )gImage_dui1);
    }
    else
    {
        TFT_LCD_Draw_Bmp(145,220+50,( uint8_t * )gImage_cuo1);
    }
    
}

void Motor_Test_HALL_VDD(uint32_t VDD)
{
    static uint32_t Num1 = 0;
    static uint32_t Num2 = 0;

    static uint32_t Num3 = 0;
    static uint32_t Num4 = 0;
    static uint32_t Num5 = 0;


    Num1 = VDD / 1 % 10;//个位
    Num2 = VDD / 10 % 10;//十位
    Num3 = VDD / 100 % 10;//百位
    Num4 = VDD / 1000 % 10;//千位
    Num5 = VDD / 10000 % 10;//万位


    TFT_LCD_Draw_Bmp(83,45,( uint8_t * )(p[Num5]));
    TFT_LCD_Draw_Bmp(103,45,( uint8_t * )(p[Num4]));
    TFT_LCD_Draw_Bmp(123,45,( uint8_t * )(p[Num3]));
    TFT_LCD_Draw_Bmp(143,45,( uint8_t * )(p[Num2]));
    TFT_LCD_Draw_Bmp(163,45,( uint8_t * )(p[Num1]));


}

void Hand_set_angle(int32_t hand)
{
     
     if(hand<0)
     {
        TFT_LCD_Draw_Bmp(120,69+8,( uint8_t * )NO_L1);
     }
     else if(hand==0)
     {
        TFT_LCD_Draw_Bmp(120,69+8,( uint8_t * )NO_M1);
     }
     else
     {
        TFT_LCD_Draw_Bmp(120,69+8,( uint8_t * )NO_R1);
     }
     
    TFT_LCD_Draw_Bmp(160,69+8,( uint8_t * )p[hand / 10 % 10]);
    TFT_LCD_Draw_Bmp(180,69+8,( uint8_t * )p[hand / 1 % 10]);
 
}

void Hall_angle(int16_t hall_angle)
{

    // hall_angle = hall_angle / 1 % 10;//个位
    // hall_angle = hall_angle / 10 % 10;//十位
     if(hall_angle<0)
     {
        hall_angle = abs(hall_angle);
        TFT_LCD_Draw_Bmp(120,95+13,( uint8_t * )NO_R1);
     }
     else
     {
        TFT_LCD_Draw_Bmp(120,95+13,( uint8_t * )NO_L1);
     }
   
    TFT_LCD_Draw_Bmp(160,95+13,( uint8_t * )p[(hall_angle / 100 % 10)]);
    TFT_LCD_Draw_Bmp(180,95+13,( uint8_t * )p[(hall_angle / 10 % 10)]);
    
    TFT_LCD_Draw_Bmp(205,95+25,( uint8_t * )gImage_dian);
    TFT_LCD_Draw_Bmp(210,95+13,( uint8_t * )p[(hall_angle / 1 % 10)]);
     
}

void Display_angle(int16_t Dis_Angle)
{
    if(Dis_Angle<0)
    {
        Dis_Angle = abs(Dis_Angle);
        TFT_LCD_Draw_Bmp(128,122+20,( uint8_t * )NO_R1);
    }
    else if(Dis_Angle==0)
    {
        TFT_LCD_Draw_Bmp(128,122+20,( uint8_t * )NO_M1);
    }
    else
    {
        TFT_LCD_Draw_Bmp(128,122+20,( uint8_t * )NO_L1);
    }
    TFT_LCD_Draw_Bmp(160,122+20,( uint8_t * )p[(Dis_Angle / 10 % 10)]);
    TFT_LCD_Draw_Bmp(180,122+20,( uint8_t * )p[(Dis_Angle / 1 % 10)]);
}

void Boot_v(void)
{
    static uint8_t num1 = 0;
    static uint8_t num2 = 0;
    static uint8_t num3 = 0;

    TFT_LCD_Draw_Bmp(123-10,150+28-5,( uint8_t * )NO_B1);

    TFT_LCD_Draw_Bmp(140-10,150+28-5,( uint8_t * )NO_V1);

    num1 =  Get_CANFD_CH0_ID_549_Sig_MotorSwVers2();
    num1 =  num1-48;
    if(num1>=0&&num1<=9)
    {
        TFT_LCD_Draw_Bmp(148,150+28-5,( uint8_t * )p[num1]);
        TFT_LCD_Draw_Bmp(172,150+28-5+12,( uint8_t * )gImage_dian);
    }
    else
    {
        TFT_LCD_Draw_Bmp(148,150+28-5,( uint8_t * )p[0]);
        TFT_LCD_Draw_Bmp(172,150+28-5+12,( uint8_t * )gImage_dian);
    }

    num2 =  Get_CANFD_CH0_ID_549_Sig_MotorSwVers4();
    num2 =  num2 -48;
    if(num2>=0&&num2<=9)
    {
        TFT_LCD_Draw_Bmp(173+5,150+28-5,( uint8_t * )p[num2]);
        TFT_LCD_Draw_Bmp(173+5+24,150+28-5+12,( uint8_t * )gImage_dian);
    }
    else
    {
        TFT_LCD_Draw_Bmp(173+5,150+28-5,( uint8_t * )p[0]);
        TFT_LCD_Draw_Bmp(173+5+24,150+28-5+12,( uint8_t * )gImage_dian);
    }

    num3 =  Get_CANFD_CH0_ID_549_Sig_MotorSwVers6();
    num3 =  num3 -48;
    if(num3<10&&num3>0)
    {
        TFT_LCD_Draw_Bmp(173+5+24+5,150+28-5,( uint8_t * )p[num3]);
    }
    else
    {
         TFT_LCD_Draw_Bmp(173+5+24+5,150+28-5,( uint8_t * )p[0]);
    }
}


void Flash_v(void)
{
    static uint8_t num1 = 0;
    static uint8_t num2 = 0;
    static uint8_t num3 = 0;
    static uint8_t num4 = 0;


    num1 = Get_CANFD_CH0_ID_559_Sig_MotorHwVers0();
    num1 = num1 -48;
    if(num1>=0&&num1<=9)
    {   
        TFT_LCD_Draw_Bmp(118,170+40+2,( uint8_t * )p[num1]);
        TFT_LCD_Draw_Bmp(143,170+40+2+12,( uint8_t * )gImage_dian);
    }
    else
    {
        TFT_LCD_Draw_Bmp(118,170+40+2,( uint8_t * )p[0]);
        TFT_LCD_Draw_Bmp(143,170+40+2+12,( uint8_t * )gImage_dian);
    }


    num2 = Get_CANFD_CH0_ID_559_Sig_MotorHwVers1();
    num2 = num2 -48;
    if(num2>=0&&num2<=9)
    { 
        TFT_LCD_Draw_Bmp(148,170+40+2,( uint8_t * )p[num2]);
        TFT_LCD_Draw_Bmp(172,170+40+2+12,( uint8_t * )gImage_dian);
    }
    else
    {
        TFT_LCD_Draw_Bmp(148,170+40+2,( uint8_t * )p[0]);
        TFT_LCD_Draw_Bmp(172,170+40+2+12,( uint8_t * )gImage_dian);
    }


    num3 = Get_CANFD_CH0_ID_559_Sig_MotorHwVers2();
    num3 = num3 -48;
    if(num3>=0&&num3<=9)
    {
        TFT_LCD_Draw_Bmp(178,170+40+2,( uint8_t * )p[num3]);
        TFT_LCD_Draw_Bmp(172,170+40+2+12,( uint8_t * )gImage_dian);
    }
    else
    {
        TFT_LCD_Draw_Bmp(178,170+40+2,( uint8_t * )p[0]);
        TFT_LCD_Draw_Bmp(172,170+40+2+12,( uint8_t * )gImage_dian);
    }


    num4 = Get_CANFD_CH0_ID_559_Sig_MotorHwVers3();
    num4 = num4 -48;
    if(num4>=0&&num4<=9)
    {
        TFT_LCD_Draw_Bmp(208,170+40+2,( uint8_t * )p[num4]);
    }
    else
    {
        TFT_LCD_Draw_Bmp(208,170+40+2,( uint8_t * )p[0]);
    }
}

void EEprom_v(void)
{

    static uint8_t num1 = 0;
    static uint8_t num2 = 0;
   
     TFT_LCD_Draw_Bmp(123+12,200+50-5,( uint8_t * )NO_F1);
     TFT_LCD_Draw_Bmp(143+15,200+50+12-5,( uint8_t * )gImage_dian);
     num1 = Get_CANFD_CH0_ID_559_Sig_MotorHwVers4();
     num1 = num1-48;
     if(num1>=0&&num1<=9)
     {
        TFT_LCD_Draw_Bmp(143+15+5,200+50-5,( uint8_t * )p[num1]);
        TFT_LCD_Draw_Bmp(163+20+1,200+50+12-5,( uint8_t * )gImage_dian);
     }
     else
     {
        TFT_LCD_Draw_Bmp(143+15+5,200+50-5,( uint8_t * )p[0]);
        TFT_LCD_Draw_Bmp(163+20+1,200+50+12-5,( uint8_t * )gImage_dian);
     }
     
     num2 = Get_CANFD_CH0_ID_559_Sig_MotorHwVers6();
     num2 = num2-48;
     if(num2>=0&&num2<=9)
     {
        TFT_LCD_Draw_Bmp(163+20+6,200+50-5,( uint8_t * )p[num2]);
     }
     else
     {
        TFT_LCD_Draw_Bmp(163+20+6,200+50-5,( uint8_t * )p[0]);
     }
}

void CAN_TX_CXD(uint8_t* cxd_msg, uint32_t Can_Id)
{
    CAN_Frame_st_t cxd_msg1;
	uint8_t len = 0;
    uint8_t i = 0;
	for (len = 0; len < 8; len++)
	{
		cxd_msg1.unCANData.u8CANData[len] = cxd_msg[len];
	}
	cxd_msg1.u32CANID = Can_Id;
	cxd_msg1.u8CANLEN = 8;
	cxd_msg1.u8CANFrameIDE = 0;
    
    for (size_t i = 0; i < 3; i++)
    {
        RSCAN0_CH4_Set_FIFO0_Data(&cxd_msg1);
        Gen_TimeDelay(2 * 1000, 50U);
    }
    
    
    
}

void Auto_run(uint8_t count1)//5s自运行
{
   
    if(count1==1)
    {
       CAN_TX_CXD(angle0,0x2DE);
    }
    else if(count1==2)
    {
       CAN_TX_CXD(angle5,0x2DE);
    }
    else if(count1==3)
    {
       CAN_TX_CXD(angle0,0x2DE);
    }
    else if(count1==4)
    {
       CAN_TX_CXD(angle_5,0x2DE);
    }
    if(count1==5)
    {
       CAN_TX_CXD(angle0,0x2DE);
    }
    else if(count1==6)
    {
       CAN_TX_CXD(angle10,0x2DE);
    }
    else if(count1==7)
    {
       CAN_TX_CXD(angle0,0x2DE);
    }
    else if(count1==8)
    {
       CAN_TX_CXD(angle_10,0x2DE);
    }
    
    
}

void Calibration_15s(void)//15s自运行
{
    CAN_TX_CXD(calibration,0x2DE);
}


extern void Motor_Can_TX(uint32_t choose)
{

    static uint8_t count = 0;
    if(choose==0)
    {    
       CAN_TX_CXD(hold_master,0X2DE);//维持
    }
    else if(choose==1)//校准
    {
        CAN_TX_CXD(calibration,0X2DE);
        
    }
    else if(choose==2)//左侧最大角度
    {
        CAN_TX_CXD(angle_13,0X2DE);
        
    }
    else if(choose==3)
    {
    
        CAN_TX_CXD(angle13,0X2DE);
        
       
    }
    else if(choose==4)//度数增加
    {

       
        count++;

        if(count<27)
        {
            CAN_TX_CXD(p1[count-1],0x2DE);
           
        }
        else
        {
            count = 0;
            
        }

    }
    else if(choose==5)//度数减少
    {

        count--;
        if(count>=0)
        {
            CAN_TX_CXD(p1[count-1],0X2DE);
            
        }
        else
        {
            count = 0;
            
        }
    }    
   
}


void Button_server()
{
    if(GPIO_IN_APORT00_PIN06==0)//1
    {
       Motor_Can_TX(1);
       HAND_SET =0;
    }
    else if(GPIO_IN_APORT00_PIN05==0)//2
    {
       Motor_Can_TX(2);
       HAND_SET =-13;
    }
    else if(GPIO_IN_APORT00_PIN04==0)//3
    {
        Motor_Can_TX(3);
        HAND_SET =13;
    }
    else 
    {
        Motor_Can_TX(0);
    }
   

}

