#include "Motor_Angle_calculation.h"

static float32_T Coefficient = 0.222222222;//角度转换系数
float32_T ZERO_ANGLE = 0;//绝对0°
static uint32_t L_Relative_Range = 0;//左侧绝对角度
static uint32_t R_Relative_Range = 0;//右侧绝对角度


//0°=两侧极限占空比做差/2
void Limiting_Duty_Conversion(uint16_t LIMIT_Duty,uint16_t lock)//传入极限占空比
{    
     if(lock==1)
     {
        L_Relative_Range = LIMIT_Duty/Coefficient;
     }
     else if(lock==2)
     {
        R_Relative_Range = LIMIT_Duty/Coefficient;
     }
     if((L_Relative_Range!=0)&&(R_Relative_Range!=0))
     {
        ZERO_ANGLE = ((L_Relative_Range+R_Relative_Range)/2);
     }
} 


int16_t Hall_Duty_Conversion_Angle(uint16_t Actual_Duty)//传入实际数值进行查表
{
    
    return ((Actual_Duty/Coefficient)-ZERO_ANGLE);//减去0°为角度值
    
      
}
