/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2X MCAL Components                                                                 */
/* Module       = Mcu_Ram.c                                                                                           */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains API function implementations of MCU Driver                                                      */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2X                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.4.4:  15/07/2022   : Update QAC message 9.5.0
 * 1.4.3:  24/05/2022   : Removed redundant QAC message
 *         24/04/2022   : Update SW-Version to 1.4.3, map QAC message
 * 1.3.1:  02/07/2021   : Format source code to 120 characters
 *                        Improve Violation tag (remove START/END) 
 *         12/05/2021   : Insert a space after each comma in the argument or initialization list.
 *         07/05/2021   : As ARDAACL-145, remove definition of Mcu_GpEcmSetting since it's redundant.
 * 1.3.0:  17/11/2020   : Add new Mcu_GaaDmonWaitCntNumPll
 * 1.2.0:  17/07/2020   : Release
 * 1.1.0:  19/06/2020   : Release
 * 1.0.1:  12/05/2020   : Update to add global variable to the appropriate memory section
 * 1.0.0:  10/01/2020   : Initial Version
 */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/

/* Included for version check macro definitions and type definitions */
#include "Mcu.h"

/* Included for RAM variable declarations */
#include "Mcu_Ram.h"                                                                                                    /* PRQA S 0857 # JV-01 */

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/

/* AUTOSAR release version information */
#define MCU_RAM_C_AR_RELEASE_MAJOR_VERSION    MCU_AR_RELEASE_MAJOR_VERSION_VALUE
#define MCU_RAM_C_AR_RELEASE_MINOR_VERSION    MCU_AR_RELEASE_MINOR_VERSION_VALUE
#define MCU_RAM_C_AR_RELEASE_REVISION_VERSION MCU_AR_RELEASE_REVISION_VERSION_VALUE

/* File version information */
#define MCU_RAM_C_SW_MAJOR_VERSION            MCU_SW_MAJOR_VERSION_VALUE
#define MCU_RAM_C_SW_MINOR_VERSION            MCU_SW_MINOR_VERSION_VALUE

/***********************************************************************************************************************
**                                                   Version Check                                                    **
***********************************************************************************************************************/

#if (MCU_RAM_AR_RELEASE_MAJOR_VERSION != MCU_RAM_C_AR_RELEASE_MAJOR_VERSION)
  #error "Mcu_Ram.c : Mismatch in Release Major Version"
#endif

#if (MCU_RAM_AR_RELEASE_MINOR_VERSION != MCU_RAM_C_AR_RELEASE_MINOR_VERSION)
  #error "Mcu_Ram.c : Mismatch in Release Minor Version"
#endif

#if (MCU_RAM_AR_RELEASE_REVISION_VERSION != MCU_RAM_C_AR_RELEASE_REVISION_VERSION)
  #error "Mcu_Ram.c : Mismatch in Release Revision Version"
#endif

#if (MCU_RAM_SW_MAJOR_VERSION != MCU_RAM_C_SW_MAJOR_VERSION)
  #error "Mcu_Ram.c : Mismatch in Software Major Version"
#endif

#if (MCU_RAM_SW_MINOR_VERSION != MCU_RAM_C_SW_MINOR_VERSION)
  #error "Mcu_Ram.c : Mismatch in Software Minor Version"
#endif

/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0857)    : Number of macro definitions exceeds 1024 - program does not conform strictly to ISO:C90.     */
/* Rule                : MISRA C:2012 Dir-1.1                                                                         */
/* JV-01 Justification : The number of macro depend on module code size. There is no issue when number of macro is    */
/*                       over 1024                                                                                    */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (1:1531)    : The object '%1s' is referenced in only one translation unit - but not the one in which it    */
/*                       is defined.                                                                                  */
/* Rule                : CERTCCM DCL15, DCL19, MISRA C:2012 Rule-8.7                                                  */
/* JV-01 Justification : Followed coding rules, the objects (global variable/const) is define in separated source     */
/*                       file, so this could be accepted                                                              */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (1:1533)    : The object '%1s' is only referenced by function '%2s'.                                       */
/* Rule                : MISRA C:2012 Rule-8.9                                                                        */
/* JV-01 Justification : This is accepted, due to the object is defined in separated source C file to followed        */
/*                       coding rule                                                                                  */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (4:5087)    : Use of #include directive after code fragment.                                               */
/* Rule                : MISRA C:2012 Rule-20.1                                                                       */
/* JV-01 Justification : This is done as per Memory Requirement, (MEMMAP003 - Specification of Memory Mapping).       */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                    Global Data                                                     **
***********************************************************************************************************************/
#define MCU_START_SEC_VAR_NO_INIT_PTR
#include "Mcu_MemMap.h"

/* Global variable to store the config pointer */
P2CONST(Mcu_ConfigType, MCU_VAR_NO_INIT, MCU_CONFIG_CONST) volatile Mcu_GpConfigPtr;

/* Global pointer variable for MCU Clock Setting configuration */
P2CONST(Mcu_ClockSettingType, MCU_VAR_NO_INIT, MCU_CONFIG_CONST) volatile Mcu_GpClockSetting;

#define MCU_STOP_SEC_VAR_NO_INIT_PTR
#include "Mcu_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

#define MCU_START_SEC_VAR_INIT_BOOLEAN
#include "Mcu_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

#if (MCU_DEV_ERROR_DETECT == STD_ON)
/* Global variable to store Initialization status of MCU Driver */
volatile VAR(boolean, MCU_VAR_INIT) Mcu_GblDriverStatus = MCU_UNINITIALIZED;                                            /* PRQA S 1531 # JV-01 */
#endif
#if (MCU_GET_RAM_STATE_API == STD_ON)
/* Global variable to store ram status of MCU Driver */
volatile VAR(Mcu_RamStateType, MCU_VAR_INIT) Mcu_GblRAMInitStatus = MCU_RAMSTATE_VALID;
#endif

#define MCU_STOP_SEC_VAR_INIT_BOOLEAN
#include "Mcu_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

#define MCU_START_SEC_VAR_INIT_8
#include "Mcu_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

/* Global variable to Reset reasonvalue call of MCU Driver */
volatile VAR(uint8, MCU_VAR_INIT) Mcu_GucMulRstReasonCall = MCU_ZERO;                                                   /* PRQA S 1531 # JV-01 */

/* Global variable to Reset rawvalue call of MCU Driver */
volatile VAR(uint8, MCU_VAR_INIT) Mcu_GucMulRstRawValCall = MCU_ZERO;                                                   /* PRQA S 1531 # JV-01 */

#if (MCU_DEV_ERROR_DETECT == STD_ON)
/* Golbal variable to store status of wake up setting of MCU Driver */
volatile VAR(uint8, MCU_VAR_INIT) Mcu_GucStopModeWakeUpStatus = MCU_NO_WAKEUP_SET;                                      /* PRQA S 1531, 1533 # JV-01, JV-01 */
volatile VAR(uint8, MCU_VAR_INIT) Mcu_GucCylicStopModeWakeUpStatus = MCU_NO_WAKEUP_SET;                                 /* PRQA S 1531, 1533 # JV-01, JV-01 */
volatile VAR(uint8, MCU_VAR_INIT) Mcu_GucDeepStopModeWakeUpStatus = MCU_NO_WAKEUP_SET;                                  /* PRQA S 1531, 1533 # JV-01, JV-01 */
#endif

#define MCU_STOP_SEC_VAR_INIT_8
#include "Mcu_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

#define MCU_START_SEC_VAR_NO_INIT_32
#include "Mcu_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

/* Global variable to store Last Reset rawvalue of MCU Driver */
volatile VAR(uint32, MCU_VAR_NO_INIT) Mcu_GulLastResetRawValue;                                                         /* PRQA S 1533 # JV-01 */

/* Global variable to store Last Reset reason status of MCU Driver */
volatile VAR(uint32, MCU_VAR_NO_INIT) Mcu_GulLastResetReason;                                                           /* PRQA S 1533 # JV-01 */

/* Global variable to save RESF status of MCU Driver */
volatile VAR(uint32, MCU_VAR_NO_INIT) Mcu_GulSavedResfStatus;                                                           /* PRQA S 1531 # JV-01 */

#define MCU_STOP_SEC_VAR_NO_INIT_32
#include "Mcu_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

#define MCU_START_SEC_CONST_32
#include "Mcu_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

#if (MCU_DEVICE_U2X == STD_ON)
CONST (uint32, MCU_CONST)Mcu_GaaDmonWaitCntNumPll[MCU_THREE][MCU_FOUR] =                                                /* PRQA S 1533 # JV-01 */
{   
  {
    MCU_RESERVED,
    MCU_RESERVED,
    MCU_RESERVED,
    MCU_RESERVED
  },
  {   /* PLLCLKDCSID[2:0] DIV1 */
    MCU_DMON_WAIT_CNT_NUM_PLL_240MHZ, /*240MHZ*/
    MCU_DMON_WAIT_CNT_NUM_PLL_240MHZ, /*240MHZ*/
    MCU_DMON_WAIT_CNT_NUM_PLL_320MHZ, /*320MHZ*/
    MCU_DMON_WAIT_CNT_NUM_PLL_400MHZ  /*400MHZ*/
  }, 
  {   /*PLLCLKDCSID[2:0] DIV2 */
    MCU_DMON_WAIT_CNT_NUM_PLL_120MHZ,   
    MCU_DMON_WAIT_CNT_NUM_PLL_120MHZ,
    MCU_DMON_WAIT_CNT_NUM_PLL_160MHZ, 
    MCU_DMON_WAIT_CNT_NUM_PLL_200MHZ
  }

};
#else
CONST (uint32, MCU_CONST)Mcu_GaaDmonWaitCntNumPll[MCU_THREE][MCU_ONE] =                                                 /* PRQA S 1533 # JV-01 */
{   
  {
    MCU_RESERVED
  }, 
  { /* CLKD0DIV == 001B DIV 1 */
    MCU_DMON_WAIT_CNT_NUM_PLL_400MHZ
  }, 
  {/* CLKD0DIV == 010B DIV 2 */
    MCU_DMON_WAIT_CNT_NUM_PLL_200MHZ
  }

};
#endif
#define MCU_STOP_SEC_CONST_32
#include "Mcu_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

/***********************************************************************************************************************
**                                                Function Definitions                                                **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
