/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Eth_PBcfg.c                                                                                         */
/*====================================================================================================================*/
/*                                  COPYRIGHT                                                                         */
/*====================================================================================================================*/
/* (c) 2022 Renesas Electronics Corporation. All rights reserved.                                                     */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains post-build time parameters.                                                                     */
/* AUTOMATICALLY GENERATED FILE - DO NOT EDIT                                                                         */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s)        */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        R7F702301BFABG                                                                        */
/*====================================================================================================================*/


/***********************************************************************************************************************
**                      Revision Control History                                                                      **
***********************************************************************************************************************/



/***********************************************************************************************************************
**                      Generation Tool Version                                                                       **
***********************************************************************************************************************/
/*                                                                                                                    */
/* TOOL VERSION:  EthU2x.dll version: 1.4.0, MCALConfGen.exe version: 1.4.0                                           */
/*                                                                                                                    */


/***********************************************************************************************************************
**                      Input File                                                                                    **
***********************************************************************************************************************/
/*
 * INPUT FILE:    D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\Config\ECUC\test_Eth_Eth_ecuc.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\generator\BSWMDT\R431_ETH_U2A8_BSWMDT.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\stubs\Dem\xml\Dem_Eth.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\stubs\Os\xml\Os_Eth.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\Translation.trxml
 * GENERATED ON:  24 Apr 2025 - 19:49:53
 */


/***********************************************************************************************************************
**                      Instance Index                                                                                **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      Include Section                                                                               **
***********************************************************************************************************************/
#include "Eth.h"


/***********************************************************************************************************************
**                      Coding Rule Violations                                                                        **
***********************************************************************************************************************/
/* Message (2:0315)    : [I] Implicit conversion from a pointer to object type to a pointer to void.                  */
/* Rule                : MISRA C:2012 Dir-1.1                                                                         */
/*                       REFERENCE - ISO-6.3.4 Semantics                                                              */
/* JV-01 Justification : Pointer to a void is a generic pointer type which can be use cast to any other pointer type. */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (4:5087)    : Use of #include directive after code fragment.                                               */
/* Rule                : MISRA C:2012 Rule-20.1                                                                       */
/* JV-01 Justification : This is accepted, due to implementation for include memmap is following AUTOSAR rule.        */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:0612)    : [L] Size of object '%s' exceeds 32767 bytes - program does not conform strictly to ISO:C90.  */
/* Rule                : MISRA-C:2012 Dir 1.1                                                                         */
/* JV-01 Justification : Size of global variable exceeds 32767 due to size of Tx buffer byte of Eth module.           */
/*       Verification  : There is no problem because it is an intended design considering the space-time tradeoff,    */
/*                       that is, scalability.                                                                        */
/**********************************************************************************************************************/
/* Message (1:1531)    : The object '%1s' is referenced in only one translation unit - but not the one in which it    */
/*                       is defined.                                                                                  */
/* Rule                : CERTCCM DCL15, DCL19, MISRA C:2012 Rule-8.7                                                  */
/* JV-01 Justification : Followed coding rules, the objects (global variable/const) is define in separated source     */
/*                       file, so this could be accepted                                                              */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (1:1533)    : The object 'entity' is only referenced by function 'func'.                                   */
/* Rule                : MISRA C:2012 Rule-8.9                                                                        */
/* JV-01 Justification : This is accepted, due to the object is defined in seperated cource C file to followed        */
/*                       coding rule                                                                                  */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:3432)    : Simple macro argument expression is not parenthesized.                                       */
/* Rule                : MISRA C:2012 Rule-20.7                                                                       */
/* JV-01 Justification : Compiler keyword (macro) is defined and used followed AUTOSAR standard rule. It is accepted. */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:0306)    : [I] Cast between a pointer to object and an integral type.                                   */
/* Rule                : CERTCCM INT36, MISRA C:2012 Rule-11.4                                                        */
/*                       REFERENCE - ISO:C90-6.3.4  Semantics                                                         */
/* JV-01 Justification : This cast is essential to declare a pointer which points an I/O register.                    */
/*       Verification  : These pointers are const values and only used for I/O accesses, any problem doesn't occur.   */
/**********************************************************************************************************************/


/***********************************************************************************************************************
**                      Version Information                                                                           **
***********************************************************************************************************************/
/* AUTOSAR release version information */
#define ETH_PBCFG_C_AR_RELEASE_MAJOR_VERSION                                    4U
#define ETH_PBCFG_C_AR_RELEASE_MINOR_VERSION                                    3U
#define ETH_PBCFG_C_AR_RELEASE_REVISION_VERSION                                 1U
/* File version information */
#define ETH_PBCFG_C_SW_MAJOR_VERSION                                            1U
#define ETH_PBCFG_C_SW_MINOR_VERSION                                            6U

/***********************************************************************************************************************
**                      Version Check                                                                                 **
***********************************************************************************************************************/
#if (ETH_TYPES_AR_RELEASE_MAJOR_VERSION != \
      ETH_PBCFG_C_AR_RELEASE_MAJOR_VERSION)
#error "Eth_PBcfg.c : Mismatch in Release Major Version"
#endif
#if (ETH_TYPES_AR_RELEASE_MINOR_VERSION != \
      ETH_PBCFG_C_AR_RELEASE_MINOR_VERSION)
#error "Eth_PBcfg.c : Mismatch in Release Minor Version"
#endif
#if (ETH_TYPES_AR_RELEASE_REVISION_VERSION != \
      ETH_PBCFG_C_AR_RELEASE_REVISION_VERSION)
#error "Eth_PBcfg.c : Mismatch in Release Revision Version"
#endif
#if (ETH_TYPES_SW_MAJOR_VERSION != ETH_PBCFG_C_SW_MAJOR_VERSION)
      #error "Eth_PBcfg.c : Mismatch in Software Major Version"
#endif
#if (ETH_TYPES_SW_MINOR_VERSION != ETH_PBCFG_C_SW_MINOR_VERSION)
      #error "Eth_PBcfg.c : Mismatch in Software Minor Version"
#endif


/***********************************************************************************************************************
**                      Global Data Types                                                                             **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      Global Data                                                                                   **
***********************************************************************************************************************/
#define ETH_START_SEC_VAR_PORT_BUFFER_0
#include "Eth_MemMap.h"

STATIC VAR(uint8, ETH_VAR_NO_INIT) Eth_GaaMemPoolBuffer_0[0x00019000UL];                                                /* PRQA S 0612 # JV-01 */
#define ETH_STOP_SEC_VAR_PORT_BUFFER_0
#include "Eth_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

#define ETH_START_SEC_VAR_PORT_BUFFER_1
#include "Eth_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

STATIC VAR(uint8, ETH_VAR_NO_INIT) Eth_GaaMemPoolBuffer_1[0x00019000UL];                                                /* PRQA S 0612 # JV-01 */
#define ETH_STOP_SEC_VAR_PORT_BUFFER_1
#include "Eth_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

#define ETH_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Eth_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


static CONST(Eth_EthConfigType, ETH_CONFIG_DATA) Eth_GaaEthConfiguration[] =
{
  /* Index: 0 - Eth_GaaEthConfiguration */
  {
    /* enEthSpeed */
    ETH_MAC_LAYER_SPEED_100M,

    /* enEthDuplex */
    ETH_FULL_DUPLEX,

    /* enInternalLoopBackMode */
    ETH_DISABLE,

    /* enEthPHYInterface */
    ETH_MII,

    /* enTxInterruptMode */
    ETH_DISABLE,

    /* enRxInterruptMode */
    ETH_DISABLE
  },
  /* Index: 1 - Eth_GaaEthConfiguration */
  {
    /* enEthSpeed */
    ETH_MAC_LAYER_SPEED_1G,

    /* enEthDuplex */
    ETH_FULL_DUPLEX,

    /* enInternalLoopBackMode */
    ETH_DISABLE,

    /* enEthPHYInterface */
    ETH_SGMII,

    /* enTxInterruptMode */
    ETH_DISABLE,

    /* enRxInterruptMode */
    ETH_DISABLE
  }
};

/* Structure for Tx Queue configuration of controller 0 */
static CONST(Eth_TxQueueType, ETH_CONFIG_DATA) Eth_GaaTxQueueConfig0[] =
{
  /* Index: 0 - Eth_GaaTxQueueConfig0 */
  {
    /* Index: 0 - stTxQueueShaper */
    {
      /* enTxQPolicy */
      ETH_NONE,

      /* ulCiv */
      (uint32)0,

      /* slCdv */
      (sint32)0
    },
    /* usEthTxQueueBufs */
    0x0008U,

    /* ucEthTxQueueId */
    0x00U
  },
  /* Index: 1 - Eth_GaaTxQueueConfig0 */
  {
    /* Index: 0 - stTxQueueShaper */
    {
      /* enTxQPolicy */
      ETH_NONE,

      /* ulCiv */
      (uint32)0,

      /* slCdv */
      (sint32)0
    },
    /* usEthTxQueueBufs */
    0x0008U,

    /* ucEthTxQueueId */
    0x01U
  },
  /* Index: 2 - Eth_GaaTxQueueConfig0 */
  {
    /* Index: 0 - stTxQueueShaper */
    {
      /* enTxQPolicy */
      ETH_CBS,

      /* ulCiv */
      (uint32)3300,

      /* slCdv */
      (sint32)-6699
    },
    /* usEthTxQueueBufs */
    0x0008U,

    /* ucEthTxQueueId */
    0x02U
  },
  /* Index: 3 - Eth_GaaTxQueueConfig0 */
  {
    /* Index: 0 - stTxQueueShaper */
    {
      /* enTxQPolicy */
      ETH_NONE,

      /* ulCiv */
      (uint32)0,

      /* slCdv */
      (sint32)0
    },
    /* usEthTxQueueBufs */
    0x0008U,

    /* ucEthTxQueueId */
    0x03U
  }
};

/* Structure for Tx Queue configuration of controller 1 */
static CONST(Eth_TxQueueType, ETH_CONFIG_DATA) Eth_GaaTxQueueConfig1[] =
{
  /* Index: 0 - Eth_GaaTxQueueConfig1 */
  {
    /* Index: 0 - stTxQueueShaper */
    {
      /* enTxQPolicy */
      ETH_NONE,

      /* ulCiv */
      (uint32)0,

      /* slCdv */
      (sint32)0
    },
    /* usEthTxQueueBufs */
    0x0008U,

    /* ucEthTxQueueId */
    0x00U
  },
  /* Index: 1 - Eth_GaaTxQueueConfig1 */
  {
    /* Index: 0 - stTxQueueShaper */
    {
      /* enTxQPolicy */
      ETH_NONE,

      /* ulCiv */
      (uint32)0,

      /* slCdv */
      (sint32)0
    },
    /* usEthTxQueueBufs */
    0x0008U,

    /* ucEthTxQueueId */
    0x01U
  },
  /* Index: 2 - Eth_GaaTxQueueConfig1 */
  {
    /* Index: 0 - stTxQueueShaper */
    {
      /* enTxQPolicy */
      ETH_CBS,

      /* ulCiv */
      (uint32)3300,

      /* slCdv */
      (sint32)-6699
    },
    /* usEthTxQueueBufs */
    0x0008U,

    /* ucEthTxQueueId */
    0x02U
  },
  /* Index: 3 - Eth_GaaTxQueueConfig1 */
  {
    /* Index: 0 - stTxQueueShaper */
    {
      /* enTxQPolicy */
      ETH_NONE,

      /* ulCiv */
      (uint32)0,

      /* slCdv */
      (sint32)0
    },
    /* usEthTxQueueBufs */
    0x0008U,

    /* ucEthTxQueueId */
    0x03U
  }
};

/* Structure for Rx Queue configuration of controller 0 */
static CONST(Eth_RxQueueType, ETH_CONFIG_DATA) Eth_GaaRxQueueConfig0[] =
{
  /* Index: 0 - Eth_GaaRxQueueConfig0 */
  {
    /* usEthRxQueueBufs */
    0x0008U,

    /* ucEthRxQueueId */
    0x00U,

    /* Index: 2 - aaEthPatternStream */
    {
      /* 0 */
      0x00U,

      /* 1 */
      0x00U,

      /* 2 */
      0x00U,

      /* 3 */
      0x00U,

      /* 4 */
      0x00U,

      /* 5 */
      0x00U,

      /* 6 */
      0x00U,

      /* 7 */
      0x00U
    }
  },
  /* Index: 1 - Eth_GaaRxQueueConfig0 */
  {
    /* usEthRxQueueBufs */
    0x0008U,

    /* ucEthRxQueueId */
    0x01U,

    /* Index: 2 - aaEthPatternStream */
    {
      /* 0 */
      0x00U,

      /* 1 */
      0x00U,

      /* 2 */
      0x00U,

      /* 3 */
      0x00U,

      /* 4 */
      0x00U,

      /* 5 */
      0x00U,

      /* 6 */
      0x00U,

      /* 7 */
      0x00U
    }
  },
  /* Index: 2 - Eth_GaaRxQueueConfig0 */
  {
    /* usEthRxQueueBufs */
    0x0008U,

    /* ucEthRxQueueId */
    0x02U,

    /* Index: 2 - aaEthPatternStream */
    {
      /* 0 */
      0x11U,

      /* 1 */
      0x22U,

      /* 2 */
      0x33U,

      /* 3 */
      0x44U,

      /* 4 */
      0x55U,

      /* 5 */
      0xAAU,

      /* 6 */
      0x00U,

      /* 7 */
      0x00U
    }
  },
  /* Index: 3 - Eth_GaaRxQueueConfig0 */
  {
    /* usEthRxQueueBufs */
    0x0008U,

    /* ucEthRxQueueId */
    0x03U,

    /* Index: 2 - aaEthPatternStream */
    {
      /* 0 */
      0x11U,

      /* 1 */
      0x22U,

      /* 2 */
      0x33U,

      /* 3 */
      0x44U,

      /* 4 */
      0x55U,

      /* 5 */
      0x00U,

      /* 6 */
      0x00U,

      /* 7 */
      0x00U
    }
  }
};

/* Structure for Rx Queue configuration of controller 1 */
static CONST(Eth_RxQueueType, ETH_CONFIG_DATA) Eth_GaaRxQueueConfig1[] =
{
  /* Index: 0 - Eth_GaaRxQueueConfig1 */
  {
    /* usEthRxQueueBufs */
    0x0008U,

    /* ucEthRxQueueId */
    0x00U,

    /* Index: 2 - aaEthPatternStream */
    {
      /* 0 */
      0x00U,

      /* 1 */
      0x00U,

      /* 2 */
      0x00U,

      /* 3 */
      0x00U,

      /* 4 */
      0x00U,

      /* 5 */
      0x00U,

      /* 6 */
      0x00U,

      /* 7 */
      0x00U
    }
  },
  /* Index: 1 - Eth_GaaRxQueueConfig1 */
  {
    /* usEthRxQueueBufs */
    0x0008U,

    /* ucEthRxQueueId */
    0x01U,

    /* Index: 2 - aaEthPatternStream */
    {
      /* 0 */
      0x00U,

      /* 1 */
      0x00U,

      /* 2 */
      0x00U,

      /* 3 */
      0x00U,

      /* 4 */
      0x00U,

      /* 5 */
      0x00U,

      /* 6 */
      0x00U,

      /* 7 */
      0x00U
    }
  },
  /* Index: 2 - Eth_GaaRxQueueConfig1 */
  {
    /* usEthRxQueueBufs */
    0x0008U,

    /* ucEthRxQueueId */
    0x02U,

    /* Index: 2 - aaEthPatternStream */
    {
      /* 0 */
      0x11U,

      /* 1 */
      0x22U,

      /* 2 */
      0x33U,

      /* 3 */
      0x44U,

      /* 4 */
      0x55U,

      /* 5 */
      0xAAU,

      /* 6 */
      0x00U,

      /* 7 */
      0x00U
    }
  },
  /* Index: 3 - Eth_GaaRxQueueConfig1 */
  {
    /* usEthRxQueueBufs */
    0x0008U,

    /* ucEthRxQueueId */
    0x03U,

    /* Index: 2 - aaEthPatternStream */
    {
      /* 0 */
      0x11U,

      /* 1 */
      0x22U,

      /* 2 */
      0x33U,

      /* 3 */
      0x44U,

      /* 4 */
      0x55U,

      /* 5 */
      0x00U,

      /* 6 */
      0x00U,

      /* 7 */
      0x00U
    }
  }
};

/* Structure for Control Priority configuration of controller 0 */
static CONST(Eth_PriorityMappingType, ETH_CONFIG_DATA) Eth_GaaCtrlPriorityTable0[] =
{
  /* Index: 0 - Eth_GaaCtrlPriorityTable0 */
  {
    /* ucEthCtrlPriorityValue */
    0x00U,

    /* ucEthCtrlTxQueueId */
    0x00U
  },
  /* Index: 1 - Eth_GaaCtrlPriorityTable0 */
  {
    /* ucEthCtrlPriorityValue */
    0x01U,

    /* ucEthCtrlTxQueueId */
    0x01U
  },
  /* Index: 2 - Eth_GaaCtrlPriorityTable0 */
  {
    /* ucEthCtrlPriorityValue */
    0x02U,

    /* ucEthCtrlTxQueueId */
    0x02U
  },
  /* Index: 3 - Eth_GaaCtrlPriorityTable0 */
  {
    /* ucEthCtrlPriorityValue */
    0x03U,

    /* ucEthCtrlTxQueueId */
    0x03U
  }
};

/* Structure for Control Priority configuration of controller 1 */
static CONST(Eth_PriorityMappingType, ETH_CONFIG_DATA) Eth_GaaCtrlPriorityTable1[] =
{
  /* Index: 0 - Eth_GaaCtrlPriorityTable1 */
  {
    /* ucEthCtrlPriorityValue */
    0x00U,

    /* ucEthCtrlTxQueueId */
    0x00U
  },
  /* Index: 1 - Eth_GaaCtrlPriorityTable1 */
  {
    /* ucEthCtrlPriorityValue */
    0x01U,

    /* ucEthCtrlTxQueueId */
    0x01U
  },
  /* Index: 2 - Eth_GaaCtrlPriorityTable1 */
  {
    /* ucEthCtrlPriorityValue */
    0x02U,

    /* ucEthCtrlTxQueueId */
    0x02U
  },
  /* Index: 3 - Eth_GaaCtrlPriorityTable1 */
  {
    /* ucEthCtrlPriorityValue */
    0x03U,

    /* ucEthCtrlTxQueueId */
    0x03U
  }
};

static CONST(Eth_ETNBConfigType, ETH_CONFIG_DATA) Eth_GaaHwUnitConfiguration[] =
{
  /* Index: 0 - Eth_GaaHwUnitConfiguration */
  {
    /* Index: 0 - stQueueConfig */
    {
      /* pTxQueueConfig */
      &Eth_GaaTxQueueConfig0[0],

      /* pRxQueueConfig */
      &Eth_GaaRxQueueConfig0[0],

      /* ucNumberOfTxQueue */
      0x04U,

      /* ucNumberOfRxQueue */
      0x04U
    },
    /* Index: 1 - stRxConfig */
    {
      /* enEncf */
      ETH_ENABLE,

      /* enEsf */
      ETH_AVBNMQUE0,

      /* enEts0 */
      ETH_ENABLE,

      /* enEts2 */
      ETH_ENABLE,

      /* ulRfcl */
      ETH_RX_FIFO_CRIT_LVL,

      /* enSRPTalkerFiltering */
      ETH_ENABLE
    },
    /* enTxConfig */
    ETH_AVBDEF,

    /* enEcbs */
    ETH_ENABLE,

    /* Index: 4 - stCtrlPriority */
    {
      /* pPriorityTable */
      &Eth_GaaCtrlPriorityTable0[0],

      /* ucNumberOfPriorities */
      0x04U,

      /* ucDflTxQueue */
      0x00U
    }
  },
  /* Index: 1 - Eth_GaaHwUnitConfiguration */
  {
    /* Index: 0 - stQueueConfig */
    {
      /* pTxQueueConfig */
      &Eth_GaaTxQueueConfig1[0],

      /* pRxQueueConfig */
      &Eth_GaaRxQueueConfig1[0],

      /* ucNumberOfTxQueue */
      0x04U,

      /* ucNumberOfRxQueue */
      0x04U
    },
    /* Index: 1 - stRxConfig */
    {
      /* enEncf */
      ETH_ENABLE,

      /* enEsf */
      ETH_AVBNMQUE0,

      /* enEts0 */
      ETH_ENABLE,

      /* enEts2 */
      ETH_ENABLE,

      /* ulRfcl */
      ETH_RX_FIFO_CRIT_LVL,

      /* enSRPTalkerFiltering */
      ETH_ENABLE
    },
    /* enTxConfig */
    ETH_AVBDEF,

    /* enEcbs */
    ETH_ENABLE,

    /* Index: 4 - stCtrlPriority */
    {
      /* pPriorityTable */
      &Eth_GaaCtrlPriorityTable1[0],

      /* ucNumberOfPriorities */
      0x04U,

      /* ucDflTxQueue */
      0x00U
    }
  }
};

static CONST(Eth_CtrlConfigType, ETH_CONFIG_DATA) Eth_GaaCtrlConfiguration[] =
{
  /* Index: 0 - Eth_GaaCtrlConfiguration */
  {
    /* Index: 0 - aaEthMACAddr */
    {
      /* 0 */
      0x74U,

      /* 1 */
      0x90U,

      /* 2 */
      0x50U,

      /* 3 */
      0x00U,

      /* 4 */
      0x00U,

      /* 5 */
      0x00U
    },
    /* pEthConfig */
    &Eth_GaaEthConfiguration[0],

    /* pHwUnitConfig */
    &Eth_GaaHwUnitConfiguration[0]                                                                                      /* PRQA S 0315 # JV-01 */
  },
  /* Index: 1 - Eth_GaaCtrlConfiguration */
  {
    /* Index: 0 - aaEthMACAddr */
    {
      /* 0 */
      0x74U,

      /* 1 */
      0x90U,

      /* 2 */
      0x50U,

      /* 3 */
      0x00U,

      /* 4 */
      0x00U,

      /* 5 */
      0x01U
    },
    /* pEthConfig */
    &Eth_GaaEthConfiguration[1],

    /* pHwUnitConfig */
    &Eth_GaaHwUnitConfiguration[1]                                                                                      /* PRQA S 0315 # JV-01 */
  }
};

CONST(uint32, ETH_CONFIG_DATA) Eth_GaaRamSize[] =                                                                       /* PRQA S 1533 # JV-01 */
{
  /* 0 */
  0x00019000UL,
  /* 1 */
  0x00019000UL
};

#define ETH_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Eth_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


#define ETH_START_SEC_DBTOC_DATA_UNSPECIFIED
#include "Eth_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


/* Structure for general configuration */
CONST(Eth_ConfigType, ETH_CONFIG_DATA) Eth_GaaConfiguration[] =
{
  /* Index: 0 - Eth_GaaConfiguration */
  {
    /* ulStartOfDbToc */
    0x0ED60130UL,

    /* pCtrlConfig */
    &Eth_GaaCtrlConfiguration[0]
  }
};

#define ETH_STOP_SEC_DBTOC_DATA_UNSPECIFIED
#include "Eth_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


#define ETH_START_SEC_VAR_INIT_PTR
#include "Eth_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


P2VAR(uint8, AUTOMATIC, ETH_VAR_INIT_PTR) Eth_GaaMemPoolBufferTable[] =                                                 /* PRQA S 1533, 3432 # JV-01, JV-01 */
{
  /* 0 */
  Eth_GaaMemPoolBuffer_0,
  /* 1 */
  Eth_GaaMemPoolBuffer_1
};

#define ETH_STOP_SEC_VAR_INIT_PTR
#include "Eth_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


#define ETH_START_SEC_VAR_INIT_16
#include "Eth_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventAccess[] =                                                                     /* PRQA S 1531 # JV-01 */
{
  /* 0 */
  DemConf_DemEventParameter_DemEventParameter,
  /* 1 */
  DemConf_DemEventParameter_DemEventParameter
};

VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventRxFramesLost[] =
{
  /* 0 */
  ETH_DEM_NOT_CONFIGURED,
  /* 1 */
  ETH_DEM_NOT_CONFIGURED
};

VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventCRC[] =
{
  /* 0 */
  DemConf_DemEventParameter_DemEventParameter_002,
  /* 1 */
  DemConf_DemEventParameter_DemEventParameter_002
};

VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventUnderSizeFrame[] =
{
  /* 0 */
  ETH_DEM_NOT_CONFIGURED,
  /* 1 */
  ETH_DEM_NOT_CONFIGURED
};

VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventOverSizeFrame[] =
{
  /* 0 */
  ETH_DEM_NOT_CONFIGURED,
  /* 1 */
  ETH_DEM_NOT_CONFIGURED
};

VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventAlignment[] =
{
  /* 0 */
  DemConf_DemEventParameter_DemEventParameter_001,
  /* 1 */
  DemConf_DemEventParameter_DemEventParameter_001
};

VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventSinglecollision[] =                                                            /* PRQA S 1533 # JV-01 */
{
  /* 0 */
  ETH_DEM_NOT_CONFIGURED,
  /* 1 */
  ETH_DEM_NOT_CONFIGURED
};

VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventMultiplecollision[] =                                                          /* PRQA S 1533 # JV-01 */
{
  /* 0 */
  ETH_DEM_NOT_CONFIGURED,
  /* 1 */
  ETH_DEM_NOT_CONFIGURED
};

VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventLatecollision[] =                                                              /* PRQA S 1533 # JV-01 */
{
  /* 0 */
  ETH_DEM_NOT_CONFIGURED,
  /* 1 */
  ETH_DEM_NOT_CONFIGURED
};

#if (ETH_GLOBAL_TIME_SUPPORT == STD_ON)

VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventTimerincFailed[] =                                                             /* PRQA S 1533 # JV-01 */
{
  /* 0 */
  ETH_DEM_NOT_CONFIGURED,
  /* 1 */
  ETH_DEM_NOT_CONFIGURED
};

#endif

#if (ETH_GLOBAL_TIME_SUPPORT == STD_ON)

VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventTimeroffsetFailed[] =                                                          /* PRQA S 1533 # JV-01 */
{
  /* 0 */
  ETH_DEM_NOT_CONFIGURED,
  /* 1 */
  ETH_DEM_NOT_CONFIGURED
};

#endif

#if (ETH_INTERRUPT_CONSISTENCY_CHECK == STD_ON)

VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventIntInconsistent[] =                                                            /* PRQA S 1531 # JV-01 */
{
  /* 0 */
  DemConf_DemEventParameter_DemEventParameter_003,
  /* 1 */
  DemConf_DemEventParameter_DemEventParameter_003
};

#endif

#if ((ETH_REGISTER_CHECK_INITTIME == STD_ON) || (ETH_REGISTER_CHECK_RUNTIME == STD_ON))

VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventRegisterCorruption[] =                                                         /* PRQA S 1531 # JV-01 */
{
  /* 0 */
  ETH_DEM_NOT_CONFIGURED,
  /* 1 */
  ETH_DEM_NOT_CONFIGURED
};

#endif

VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventDmaError[] =                                                                   /* PRQA S 1531, 1533 # JV-01, JV-01 */
{
  /* 0 */
  ETH_DEM_NOT_CONFIGURED,
  /* 1 */
  ETH_DEM_NOT_CONFIGURED
};

#define ETH_STOP_SEC_VAR_INIT_16
#include "Eth_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


#define ETH_START_SEC_CONST_32
#include "Eth_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


CONSTP2VAR(volatile Eth_ETNBRegType, ETH_CONST, REGSPACE) Eth_GaaETNBRegs[] =
{
  /* Eth_GaaETNBRegs[0] */
  (Eth_ETNBRegType *)0xFF0A2000UL,                                                                                      /* PRQA S 0306 # JV-01 */
  /* Eth_GaaETNBRegs[1] */
  (Eth_ETNBRegType *)0xFF0A4000UL                                                                                       /* PRQA S 0306 # JV-01 */
};

CONSTP2VAR(volatile Eth_ETNBEICRegType, ETH_CONST, REGSPACE) Eth_GaaETNBEICRegs[] =                                     /* PRQA S 1533 # JV-01 */
{
  /* Eth_GaaETNBEICRegs[0] */
  (Eth_ETNBEICRegType *)0xFFF8050AUL,                                                                                   /* PRQA S 0306 # JV-01 */
  /* Eth_GaaETNBEICRegs[1] */
  (Eth_ETNBEICRegType *)0xFFF80512UL                                                                                    /* PRQA S 0306 # JV-01 */
};

#define ETH_STOP_SEC_CONST_32
#include "Eth_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */



/***********************************************************************************************************************
**                      Function Definitions                                                                          **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      End of File                                                                                   **
***********************************************************************************************************************/

