/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Gpt_TAUJ_Ram.c                                                                                      */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020,2021 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* Global variable declarations                                                                                       */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 *  1.3.2  22/08/2021  : Changed Gpt_MemMap.h to Gpt_Mapping.h.
 *  1.3.1  02/07/2021  : Format source code to 120 characters
 *         24/05/2021  : Removed QAC Msg 3635.
 *         06/05/2021  : Updated the Memory section for Gpt_TaujFunc using GPT_START_SEC_VAR_INIT_UNSPECIFIED
 *  1.2.0  17/07/2020  : Release
 *  1.1.0  19/06/2020  : Release
 *         14/05/2020  : Define Unspecified Section in boundary Gpt_TaujFunc
 *         20/04/2020  : Add preceding & operator for Function identifier used  as a pointer
 *         10/03/2020  : As per Redmine #256079, update to add macro pre-compile to enable/disable APIs respectively
 *  1.0.0  01/01/2020  : Initial Version
 */
/**********************************************************************************************************************/
/***********************************************************************************************************************
**                                             Margin for Control History                                             **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (1:1531)    : The object '%1s' is referenced in only one translation unit - but not the one in which it    */
/*                       is defined.                                                                                  */
/* Rule                : CERTCCM DCL15, DCL19, MISRA C:2012 Rule-8.7                                                  */
/* JV-01 Justification : Followed coding rules, the objects (global variable/const) is define in separated source     */
/*                       file, so this could be accepted                                                              */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (4:5087)    : Use of #include directive after code fragment.                                               */
/* Rule                : MISRA C:2012 Rule-20.1                                                                       */
/* JV-01 Justification : This is done as per Memory Requirement, (MEMMAP003 - Specification of Memory Mapping).       */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/
/* Included for RAM variable declarations */
#include "Gpt_TAUJ_Ram.h"
/* Included for function table of low level functions */
#include "Gpt_TAUJ_LLDriver.h"
/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR Release version information */
#define GPT_TAUJ_RAM_C_AR_RELEASE_MAJOR_VERSION    GPT_AR_RELEASE_MAJOR_VERSION_VALUE
#define GPT_TAUJ_RAM_C_AR_RELEASE_MINOR_VERSION    GPT_AR_RELEASE_MINOR_VERSION_VALUE
#define GPT_TAUJ_RAM_C_AR_RELEASE_REVISION_VERSION GPT_AR_RELEASE_REVISION_VERSION_VALUE
/* File version information */
#define GPT_TAUJ_RAM_C_SW_MAJOR_VERSION            GPT_SW_MAJOR_VERSION_VALUE
#define GPT_TAUJ_RAM_C_SW_MINOR_VERSION            GPT_SW_MINOR_VERSION_VALUE
/***********************************************************************************************************************
**                                                   Version Check                                                    **
***********************************************************************************************************************/
#if (GPT_TAUJ_RAM_AR_RELEASE_MAJOR_VERSION != GPT_TAUJ_RAM_C_AR_RELEASE_MAJOR_VERSION)
  #error "Gpt_TAUJ_Ram.c : Mismatch in Release Major Version"
#endif
#if (GPT_TAUJ_RAM_AR_RELEASE_MINOR_VERSION != GPT_TAUJ_RAM_C_AR_RELEASE_MINOR_VERSION)
  #error "Gpt_TAUJ_Ram.c : Mismatch in Release Minor Version"
#endif
#if (GPT_TAUJ_RAM_AR_RELEASE_REVISION_VERSION != GPT_TAUJ_RAM_C_AR_RELEASE_REVISION_VERSION)
  #error "Gpt_TAUJ_Ram.c : Mismatch in Release Revision Version"
#endif
#if (GPT_TAUJ_RAM_SW_MAJOR_VERSION != GPT_TAUJ_RAM_C_SW_MAJOR_VERSION)
  #error "Gpt_TAUJ_Ram.c : Mismatch in Software Major Version"
#endif
#if (GPT_TAUJ_RAM_SW_MINOR_VERSION != GPT_TAUJ_RAM_C_SW_MINOR_VERSION)
  #error "Gpt_TAUJ_Ram.c : Mismatch in Software Minor Version"
#endif

/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                    Global Data                                                     **
***********************************************************************************************************************/
#if (GPT_TIMER_IP_TAUJ == STD_ON)
#define GPT_START_SEC_VAR_INIT_UNSPECIFIED
#include "Gpt_Mapping.h"
VAR(Gpt_HwFuncTableType, GPT_VAR_INIT) Gpt_TaujFunc =                                                                   /* PRQA S 1531 # JV-01 */
{
  &Gpt_HW_Tauj_UnitInit,           &Gpt_HW_Tauj_ChannelInit,
  #if (GPT_DE_INIT_API == STD_ON)
  &Gpt_HW_Tauj_UnitDeInit,         &Gpt_HW_Tauj_ChannelDeInit,
  #endif
  #if (GPT_TIME_ELAPSED_API == STD_ON)
  &Gpt_HW_Tauj_GetTimeElapsed,
  #endif
  #if (GPT_TIME_REMAINING_API == STD_ON)
  &Gpt_HW_Tauj_GetTimeRemaining,
  #endif
  &Gpt_HW_Tauj_StartTimer,         &Gpt_HW_Tauj_StopTimer,
  &Gpt_HW_Tauj_EnableInterrupt,    &Gpt_HW_Tauj_DisableInterrupt,
  #if ((GPT_REPORT_WAKEUP_SOURCE == STD_ON) && (GPT_WAKEUP_FUNCTIONALITY_API == STD_ON))
  &Gpt_HW_Tauj_EnableWakeup,       &Gpt_HW_Tauj_DisableWakeup,
  #endif
  #if (GPT_GET_PREDEF_TIMER_VALUE_API == STD_ON)
  &Gpt_HW_Tauj_StartPredefTimer,   &Gpt_HW_Tauj_StopPredefTimer,
  &Gpt_HW_Tauj_GetPredefTimerValue
  #endif
};
#define GPT_STOP_SEC_VAR_INIT_UNSPECIFIED
#include "Gpt_Mapping.h"                                                                                                /* PRQA S 5087 # JV-01 */
#endif /* GPT_TIMER_IP_TAUJ == STD_ON */

/***********************************************************************************************************************
**                                                Function Definitions                                                **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
