/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Spi_CSIX_LLDriver.h                                                                                 */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains the type definitions for link time parameters                                                   */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/* 1.4.3:  10/05/2022  : Remove redundant macro
 * 1.4.2:  02/03/2022  : Merge QAC
 * 1.3.2:  06/09/2021  : Update QAC contents
 *         04/09/2021  : Add pre-compile condition for defining multiple files base on instance index
 *                       Replace the inclusion of Spi_MemMap.h with Spi_Mapping.h
 * 1.3.1:  02/07/2021  : Add QAC message 9.5.0
 *                       Format source code to 120 characters
 *                       Improve Violation tag (remove START/END)
 *         07/05/2021  : Change extern const Spi_CSIHRegisterSetType
 *                       Spi_GaaCSIHRegs[]; to extern CONST
 *                       (SpiCSIHRegisterSetType, SPI_CONFIG_DATA)
 *                       Spi_GaaCSIHRegs[];
 * 1.2.0:  30/07/2020  : Release
 *         28/07/2020  : Add QAC 9.3.1 comment.
 * 1.1.0:  19/06/2020  : Release
 * 1.0.2:  10/06/2020  : 1. Remove ulMCTL1, ulMCTL2, ulMRWP0, usMCTL0.
 *                       2. Change access size of CSIHnEIE and CSIHnECTL0
 *                          from 8bit to 32bit access.
 * 1.0.1:  21/05/2020  : Update QAC warning and MISRA-C Rule violation
 * 1.0.0:  24/03/2020  : Initial Version
 */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/
/* Message (2:3472)    : All toplevel uses of this function-like macro look like they could be replaced by            */
/*                       equivalent function calls.                                                                   */
/* Rule                : MISRA C:2012 Dir-4.9                                                                         */
/* JV-01 Justification : This message indicates that a candidate macro may be suitable for replacement by a           */
/*                       function, based on an actual call-site and the arguments passed to it there                  */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:3630)    : The implementation of this struct/union type should be hidden.                               */
/* Rule                : MISRA C:2012 Dir-4.8                                                                         */
/* JV-01 Justification : This is accepted. Redundant of struct or union type has no affect to driver operation.       */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:3432)    : Simple macro argument expression is not parenthesized.                                       */
/* Rule                : MISRA C:2012 Rule-20.7                                                                       */
/* JV-01 Justification : Compiler keyword (macro) is defined and used followed AUTOSAR standard rule. It is accepted. */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:3684)    : Array declared with unknown size.                                                            */
/* Rule                : CERTCCM ARR02, MISRA C:2012 Rule-8.11                                                        */
/* JV-01 Justification : Arrays used are verified in the file which are only declarations and size is configuration   */
/*                       dependent.                                                                                   */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/

#ifdef SPI_INSTANCE_INDEX
    #if (SPI_INSTANCE_INDEX == 0)
        #ifndef SPI_59_INST0_CSIX_LLDRIVER_H
            #define SPI_59_INST0_CSIX_LLDRIVER_H
            #define SPI_CSIX_LLDRIVER_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 1)
        #ifndef SPI_59_INST1_CSIX_LLDRIVER_H
            #define SPI_59_INST1_CSIX_LLDRIVER_H
            #define SPI_CSIX_LLDRIVER_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 2)
        #ifndef SPI_59_INST2_CSIX_LLDRIVER_H
            #define SPI_59_INST2_CSIX_LLDRIVER_H
            #define SPI_CSIX_LLDRIVER_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 3)
        #ifndef SPI_59_INST3_CSIX_LLDRIVER_H
            #define SPI_59_INST3_CSIX_LLDRIVER_H
            #define SPI_CSIX_LLDRIVER_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 4)
        #ifndef SPI_59_INST4_CSIX_LLDRIVER_H
            #define SPI_59_INST4_CSIX_LLDRIVER_H
            #define SPI_CSIX_LLDRIVER_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 5)
        #ifndef SPI_59_INST5_CSIX_LLDRIVER_H
            #define SPI_59_INST5_CSIX_LLDRIVER_H
            #define SPI_CSIX_LLDRIVER_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 6)
        #ifndef SPI_59_INST6_CSIX_LLDRIVER_H
            #define SPI_59_INST6_CSIX_LLDRIVER_H
            #define SPI_CSIX_LLDRIVER_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 7)
        #ifndef SPI_59_INST7_CSIX_LLDRIVER_H
            #define SPI_59_INST7_CSIX_LLDRIVER_H
            #define SPI_CSIX_LLDRIVER_HEADER
        #endif
    #else
        #error "Miss instance index"
    #endif
#else
    #ifndef SPI_CSIX_LLDRIVER_H
        #define SPI_CSIX_LLDRIVER_H
        #define SPI_CSIX_LLDRIVER_HEADER
    #endif
#endif

#ifdef SPI_CSIX_LLDRIVER_HEADER
#undef SPI_CSIX_LLDRIVER_HEADER                                                                                         /* PRQA S 0841 # JV-01 */

/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR Release version information */
#define SPI_CSIX_LLDRIVER_AR_RELEASE_MAJOR_VERSION    SPI_AR_RELEASE_MAJOR_VERSION
#define SPI_CSIX_LLDRIVER_AR_RELEASE_MINOR_VERSION    SPI_AR_RELEASE_MINOR_VERSION
#define SPI_CSIX_LLDRIVER_AR_RELEASE_REVISION_VERSION SPI_AR_RELEASE_REVISION_VERSION

/* File version information */
#define SPI_CSIX_LLDRIVER_SW_MAJOR_VERSION            SPI_SW_MAJOR_VERSION
#define SPI_CSIX_LLDRIVER_SW_MINOR_VERSION            SPI_SW_MINOR_VERSION

/***********************************************************************************************************************
**                                                   Global Symbols                                                   **
***********************************************************************************************************************/
/* Maximum bit length of single transmit for CSIH */
#define SPI_CSIX_WORD                                 16U

/* CSIXnCTL0 */
#define SPI_CSIX_CTL0_DEFAULT                         (uint8)0x00U
#define SPI_CSIX_PWR                                  (uint8)0x80U
#define SPI_CSIX_TXE                                  (uint8)0x40U
#define SPI_CSIX_RXE                                  (uint8)0x20U
#define SPI_CSIH_JOBE                                 (uint8)0x02U
#define SPI_CSIH_MBS                                  (uint8)0x01U
#define SPI_CSIH_CTL0_TURNOFF                         (uint8)(SPI_CSIX_TXE | SPI_CSIX_RXE | SPI_CSIH_MBS)
#define SPI_CSIH_CTL0_TURNON                          (uint8)(SPI_CSIX_PWR | SPI_CSIH_CTL0_TURNOFF)

/* CSIXnCTL1 */
#define SPI_CSIX_CTL1_DEFAULT                         0x00000000UL
#define SPI_CSIH_JE                                   0x00000040UL

/* CSIXnCTL2 */
#define SPI_CSIX_CTL2_DEFAULT                         (uint16)0xE000U
#define SPI_CSIX_PRS_DIV_1                            (uint16)0x0000U
#define SPI_CSIX_PRS_DIV_2                            (uint16)0x2000U
#define SPI_CSIX_PRS_DIV_4                            (uint16)0x4000U
#define SPI_CSIX_PRS_DIV_8                            (uint16)0x6000U
#define SPI_CSIX_PRS_DIV_16                           (uint16)0x8000U
#define SPI_CSIX_PRS_DIV_32                           (uint16)0x9000U
#define SPI_CSIX_PRS_DIV_64                           (uint16)0xC000U
#define SPI_CSIX_PRS_SLAVE                            (uint16)0xE000U

/* CSIXnBRS */
#define SPI_CSIX_BRS_NUM                              4U
#define SPI_CSIX_BRS_DEFAULT                          (uint16)0x0000U
#define SPI_CSIX_BRS(x)                               (uint16)(x)

/* CSIXnSTR0 */
#define SPI_CSIX_DCE                                  0x00000008UL
#define SPI_CSIX_PE                                   0x00000002UL
#define SPI_CSIX_OVE                                  0x00000001UL

/* CSIXnSTCR0 */
#define SPI_CSIX_DCEC                                 (uint16)0x0008U
#define SPI_CSIX_PEC                                  (uint16)0x0002U
#define SPI_CSIX_OVEC                                 (uint16)0x0001U

/* CSIXnCFGx */
#define SPI_CSIX_CS_MASK                              0x000000FFUL
#define SPI_CSIX_CFG_DEFAULT                          0x00000000UL
#define SPI_CSIH_BRSS(x)                              ((uint32)(x) << 30UL)
#define SPI_CSIH_BRSS_GET(x)                          ((uint32)(x) >> 30UL)                                             /* PRQA S 3472 # JV-01 */
#define SPI_CSIX_PS_NONE                              0x00000000UL
#define SPI_CSIX_PS_ZERO                              0x10000000UL
#define SPI_CSIX_PS_ODD                               0x20000000UL
#define SPI_CSIX_PS_EVEN                              0x30000000UL
#define SPI_CSIX_DLS(x)                               (((uint32)(x) % 16UL) << 24UL)                                    /* PRQA S 3472 # JV-01 */
#define SPI_CSIH_RCB                                  0x00080000UL
#define SPI_CSIX_DIRM                                 0x00000000UL
#define SPI_CSIX_DIRL                                 0x00040000UL
#define SPI_CSIX_DAP                                  0x00010000UL
#define SPI_CSIH_IDL                                  0x00008000UL
#define SPI_CSIH_ID_0_5                               0x00000000UL
#define SPI_CSIH_ID_1                                 0x00001000UL
#define SPI_CSIH_ID_1_5                               0x00002000UL
#define SPI_CSIH_ID_2_5                               0x00003000UL
#define SPI_CSIH_ID_3_5                               0x00004000UL
#define SPI_CSIH_ID_4_5                               0x00005000UL
#define SPI_CSIH_ID_6_5                               0x00006000UL
#define SPI_CSIH_ID_8_5                               0x00007000UL
#define SPI_CSIH_HD_0_5                               0x00000000UL
#define SPI_CSIH_HD_1                                 0x00000100UL
#define SPI_CSIH_HD_1_5                               0x00000200UL
#define SPI_CSIH_HD_2_5                               0x00000300UL
#define SPI_CSIH_HD_3_5                               0x00000400UL
#define SPI_CSIH_HD_4_5                               0x00000500UL
#define SPI_CSIH_HD_6_5                               0x00000600UL
#define SPI_CSIH_HD_8_5                               0x00000700UL
#define SPI_CSIH_HD_9_5                               0x00000800UL
#define SPI_CSIH_HD_10_5                              0x00000900UL
#define SPI_CSIH_HD_11_5                              0x00000A00UL
#define SPI_CSIH_HD_12_5                              0x00000B00UL
#define SPI_CSIH_HD_14_5                              0x00000C00UL
#define SPI_CSIH_HD_16_5                              0x00000D00UL
#define SPI_CSIH_HD_18_5                              0x00000E00UL
#define SPI_CSIH_HD_20_5                              0x00000F00UL
#define SPI_CSIH_IN_0                                 0x00000000UL
#define SPI_CSIH_IN_0_5                               0x00000010UL
#define SPI_CSIH_IN_1                                 0x00000020UL
#define SPI_CSIH_IN_2                                 0x00000030UL
#define SPI_CSIH_IN_3                                 0x00000040UL
#define SPI_CSIH_IN_4                                 0x00000050UL
#define SPI_CSIH_IN_6                                 0x00000060UL
#define SPI_CSIH_IN_8                                 0x00000070UL
#define SPI_CSIH_IN_9                                 0x00000080UL
#define SPI_CSIH_IN_10                                0x00000090UL
#define SPI_CSIH_IN_11                                0x000000A0UL
#define SPI_CSIH_IN_12                                0x000000B0UL
#define SPI_CSIH_IN_14                                0x000000C0UL
#define SPI_CSIH_IN_16                                0x000000D0UL
#define SPI_CSIH_IN_18                                0x000000E0UL
#define SPI_CSIH_IN_20                                0x000000F0UL
#define SPI_CSIH_SP_0_5                               0x00000000UL
#define SPI_CSIH_SP_1                                 0x00000001UL
#define SPI_CSIH_SP_1_5                               0x00000002UL
#define SPI_CSIH_SP_2_5                               0x00000003UL
#define SPI_CSIH_SP_3_5                               0x00000004UL
#define SPI_CSIH_SP_4_5                               0x00000005UL
#define SPI_CSIH_SP_6_5                               0x00000006UL
#define SPI_CSIH_SP_8_5                               0x00000007UL
#define SPI_CSIH_SP_9_5                               0x00000008UL
#define SPI_CSIH_SP_10_5                              0x00000009UL
#define SPI_CSIH_SP_11_5                              0x0000000AUL
#define SPI_CSIH_SP_12_5                              0x0000000BUL
#define SPI_CSIH_SP_14_5                              0x0000000CUL
#define SPI_CSIH_SP_16_5                              0x0000000DUL
#define SPI_CSIH_SP_18_5                              0x0000000EUL
#define SPI_CSIH_SP_20_5                              0x0000000FUL

/* CSIXnTX0W */
#define SPI_CSIH_CIRE                                 0x80000000UL
#define SPI_CSIH_EOJ                                  0x40000000UL
#define SPI_CSIX_EDL                                  0x20000000UL
#define SPI_CSIH_CS(x)                                ((uint32)(x) << 16UL)                                             /* PRQA S 3472 # JV-01 */

/* CSIHnEIE */
#define SPI_CSIH_EIE_DEFAULT                          (uint32)0x00000000U
#define SPI_CSIH_EIJE                                 (uint32)0x00000008U
#define SPI_CSIH_EIEE                                 (uint32)0x00000004U
#define SPI_CSIH_EIRE                                 (uint32)0x00000002U
#define SPI_CSIH_EICE                                 (uint32)0x00000001U

/***********************************************************************************************************************
**                                                 Global Data Types                                                  **
***********************************************************************************************************************/
/* IO mapping structure for BRS register */
typedef struct STag_Spi_BRSRegType
{
  uint16 usBRS;        /* BRS              */
  uint8 aaReserved[2]; /* Reserved         */
} Spi_BRSRegType;

/* IO mapping structure for CSIH registers */
typedef struct STag_Spi_CSIHRegType                                                                                     /* PRQA S 3630 # JV-01 */
{
  uint8 ucCTL0;            /* +0000H CTL0      */
  uint8 aaReserved0[3];    /* Reserved         */
  uint32 ulSTR0;           /* +0004H STR0      */
  uint16 usSTCR0;          /* +0008H STCR0     */
  uint8 aaReserved1[6];    /* Reserved         */
  uint32 ulCTL1;           /* +0010H CTL1      */
  uint16 usCTL2;           /* +0014H CTL2      */
  uint8 aaReserved2[4082]; /* Reserved         */
  uint32 ulTX0W;           /* +1008H TX0W      */
  uint16 usTX0H;           /* +100CH TX0H      */
  uint8 aaReserved3[2];    /* Reserved         */
  uint32 ulRX0W;           /* +1010H RX0W      */
  uint16 usRX0H;           /* +1014H RX0H      */
  uint8 aaReserved4[46];   /* Reserved         */
  uint32 aaCFG[8];         /* +1044H CFG       */
  uint8 aaReserved7[4];    /* Reserved         */
  Spi_BRSRegType aaBRS[4]; /* +1068H BRS       */
  uint8 aaReserved8[136];  /* Reserved         */
  uint32 ulEIE;            /* +1100H EIE       */
  uint32 ulECTL0;          /* +1104H ECTL0     */
  uint32 ulECTL1;          /* +1108H ECTL1     */
  uint32 aaETXDA[16];      /* +110CH ETXDAm    */
  uint8 aaReserved11[4];   /* Reserved         */
  uint32 aaERXDA[16];      /* +1150H ERXDAm    */
  uint32 ulESTT;           /* +1190H ESTT      */
  uint32 ulESTF;           /* +1194H ESTF      */
} Spi_CSIHRegType;

/* Structure for the register information for each CSIX unit */
typedef struct STag_Spi_CSIHRegisterSetType
{
  /* Base address of CSIH registers */
  volatile P2VAR(Spi_CSIHRegType, TYPEDEF, REGSPACE) pRegs;                                                             /* PRQA S 3432 # JV-01 */
  /* EIC register address for CSIXnTIC interrupt */
  volatile P2VAR(uint16, TYPEDEF, REGSPACE) pICTIC;                                                                     /* PRQA S 3432 # JV-01 */
  /* EIC register address for CSIXnTIR interrupt */
  volatile P2VAR(uint16, TYPEDEF, REGSPACE) pICTIR;                                                                     /* PRQA S 3432 # JV-01 */
  /* EIC reigster address for CSIXnTIRE interrupt */
  volatile P2VAR(uint16, TYPEDEF, REGSPACE) pICTIRE;                                                                    /* PRQA S 3432 # JV-01 */
  /* EIC register address for CSIHnTIJC interrupt */
  volatile P2VAR(uint16, TYPEDEF, REGSPACE) pICTIJC;                                                                    /* PRQA S 3432 # JV-01 */
  /* The number of Chip Select */
  uint8 ucNoOfCS;
} Spi_CSIHRegisterSetType;

/* Structure for HW-dependent device configuration */
typedef struct STag_Spi_CSIXDeviceConfigType
{
  /* Value of CSIXnCTL1 register */
  uint32 ulCSIXCTL1;
  /* Value of CSIXnCTL2 register */
  uint16 usCSIXCTL2;
  /* Value of CSIXnBRS register */
  uint16 usCSIXBRS;
  /* Value of CSIXnCFG register except DLS and DIR fields */
  uint32 ulCSIXCFG;
} Spi_CSIXDeviceConfigType;

#if (SPI_EXTENDED_DATA_LENGTH == STD_ON)
/* Structure for the EDL status */
typedef struct STag_Spi_CSIXEDLStatusType
{
  /* Whether the first half of 32bit data is going on tx side */
  boolean blTxEDLOngoing;
  /* Whether the second half of 32bit data is going on rx side */
  boolean blRxEDLOngoing;
  /* Second half of 32bit data that will be written in the next transmission */
  uint32 ulTxEDLSecondWord;
  /* First half of 32bit data that was received */
  uint16 usRxEDLFirstWord;
} Spi_CSIXEDLStatusType;
#endif /* (SPI_EXTENDED_DATA_LENGTH == STD_ON) */

#define SPI_START_SEC_CONST_UNSPECIFIED
#include "Spi_Mapping.h"

/* The instance is declared in Spi_Lcfg.c */
extern CONST(Spi_CSIHRegisterSetType, SPI_CONFIG_DATA) Spi_GaaCSIHRegs[];                                               /* PRQA S 3684 # JV-01 */

/* HW-dependent function pointer table */
extern CONST(Spi_HwFuncTableType, SPI_CONST) Spi_GstCSIXFunc;

#define SPI_STOP_SEC_CONST_UNSPECIFIED
#include "Spi_Mapping.h"

/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/
#define SPI_START_SEC_PRIVATE_CODE
#include "Spi_Mapping.h"

#if (SPI_CSIH_CONFIGURED == STD_ON)
extern FUNC(void, SPI_PRIVATE_CODE) Spi_CSIXTransmitISR(const uint32 LulHWUnitIndex);
extern FUNC(void, SPI_PRIVATE_CODE) Spi_CSIXReceiveISR(const uint32 LulHWUnitIndex);
#endif /* (SPI_CSIH_CONFIGURED == STD_ON) */

#define SPI_STOP_SEC_PRIVATE_CODE
#include "Spi_Mapping.h"

#endif /* SPI_CSIX_LLDRIVER_HEADER */
/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
