/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Spi_Ram.c                                                                                           */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020,2021 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains global variable definitions of SPI Driver                                                       */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/* 1.3.2:  04/09/2021  : Replace the inclusion of Spi_MemMap.h with Spi_Mapping.h 
 * 1.3.1:  02/07/2021  : Format source code to 120 characters
 *                       Improve Violation tag (remove START/END)
 * 1.2.0:  30/07/2020  : Release
 *         28/07/2020  : Add QAC 9.3.1 comment.
 * 1.1.0:  19/06/2020  : Release
 * 1.0.0:  24/03/2020  : Initial Version
 */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/
#include "Spi.h"                                                                                                        /* PRQA S 0857 # JV-01 */
#include "Spi_Ram.h"

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR release version information */
#define SPI_RAM_C_AR_RELEASE_MAJOR_VERSION    SPI_AR_RELEASE_MAJOR_VERSION_VALUE
#define SPI_RAM_C_AR_RELEASE_MINOR_VERSION    SPI_AR_RELEASE_MINOR_VERSION_VALUE
#define SPI_RAM_C_AR_RELEASE_REVISION_VERSION SPI_AR_RELEASE_REVISION_VERSION_VALUE

/* File version information */
#define SPI_RAM_C_SW_MAJOR_VERSION            SPI_SW_MAJOR_VERSION_VALUE
#define SPI_RAM_C_SW_MINOR_VERSION            SPI_SW_MINOR_VERSION_VALUE

/***********************************************************************************************************************
**                                                   Version Check                                                    **
***********************************************************************************************************************/
#if (SPI_RAM_AR_RELEASE_MAJOR_VERSION != SPI_RAM_C_AR_RELEASE_MAJOR_VERSION)
#error "Spi_Ram.c : Mismatch in Release Major Version"
#endif

#if (SPI_RAM_AR_RELEASE_MINOR_VERSION != SPI_RAM_C_AR_RELEASE_MINOR_VERSION)
#error "Spi_Ram.c : Mismatch in Release Minor Version"
#endif

#if (SPI_RAM_AR_RELEASE_REVISION_VERSION != SPI_RAM_C_AR_RELEASE_REVISION_VERSION)
#error "Spi_Ram.c : Mismatch in Release Revision Version"
#endif

#if (SPI_RAM_SW_MAJOR_VERSION != SPI_RAM_C_SW_MAJOR_VERSION)
#error "Spi_Ram.c : Mismatch in Software Major Version"
#endif

#if (SPI_RAM_SW_MINOR_VERSION != SPI_RAM_C_SW_MINOR_VERSION)
#error "Spi_Ram.c : Mismatch in Software Minor Version"
#endif

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0857)    : Number of macro definitions exceeds 1024 - program does not conform strictly to ISO:C90.     */
/* Rule                : MISRA C:2012 Dir-1.1                                                                         */
/* JV-01 Justification : The number of macro depend on module code size. There is no issue when number of macro is    */
/*                       over 1024                                                                                    */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (1:1531)    : The object '%1s' is referenced in only one translation unit - but not the one in which it    */
/*                       is defined.                                                                                  */
/* Rule                : CERTCCM DCL15, DCL19, MISRA C:2012 Rule-8.7                                                  */
/* JV-01 Justification : Followed coding rules, the objects (global variable/const) is define in separated source     */
/*                       file, so this could be accepted                                                              */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (4:5087)    : Use of #include directive after code fragment.                                               */
/* Rule                : MISRA C:2012 Rule-20.1                                                                       */
/* JV-01 Justification : This is done as per Memory Requirement, (MEMMAP003 - Specification of Memory Mapping).       */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (1:1533)    : The object '%1s' is only referenced by function '%2s'.                                       */
/* Rule                : MISRA C:2012 Rule-8.9                                                                        */
/* JV-01 Justification : This is accepted, due to the object is defined in separated source C file to followed        */
/*                       coding rule                                                                                  */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                    Global Data                                                     **
***********************************************************************************************************************/
#define SPI_START_SEC_VAR_INIT_BOOLEAN
#include "Spi_Mapping.h"

/* Global variable to store the initialization status of SPI Driver */
volatile VAR(boolean, SPI_VAR_INIT) Spi_GblInitialized = SPI_FALSE;                                                     /* PRQA S 1531 # JV-01 */

#define SPI_STOP_SEC_VAR_INIT_BOOLEAN
#include "Spi_Mapping.h"                                                                                                /* PRQA S 5087 # JV-01 */

#define SPI_START_SEC_VAR_NO_INIT_PTR
#include "Spi_Mapping.h"                                                                                                /* PRQA S 5087 # JV-01 */

/* Global variable to store config pointer */
P2CONST(Spi_ConfigType, SPI_VAR_NO_INIT, SPI_CONFIG_DATA)
volatile Spi_GpConfigPtr;

/* Global variable to store first channel structure */
P2CONST(Spi_ChannelConfigType, SPI_VAR_NO_INIT, SPI_CONFIG_DATA)
volatile Spi_GpFirstChannel;

/* Global variable to store first job structure */
P2CONST(Spi_JobConfigType, SPI_VAR_NO_INIT, SPI_CONFIG_DATA)
volatile Spi_GpFirstJob;

/* Global variable to store first sequence structure */
P2CONST(Spi_SeqConfigType, SPI_VAR_NO_INIT, SPI_CONFIG_DATA)
volatile Spi_GpFirstSeq;

/* Global variable to store HWUnit information table */
P2CONST(Spi_HWUnitInfoType, SPI_VAR_NO_INIT, SPI_CONFIG_DATA)
volatile Spi_GpFirstHWUnit;

#if (SPI_DMA_CONFIGURED == STD_ON)
/* Global pointer variable for HW group configuration */
P2CONST(Spi_DmaConfigType, SPI_VAR_NO_INIT, SPI_CONFIG_DATA)
volatile Spi_GpFirstDMAUnit;
#endif

/* Global pointer variable for HW-dependent function pointer table */
P2CONST(Spi_HwConfigType, SPI_VAR_NO_INIT, SPI_CONST)
volatile Spi_GpHwConfig;

#define SPI_STOP_SEC_VAR_NO_INIT_PTR
#include "Spi_Mapping.h"                                                                                                /* PRQA S 5087 # JV-01 */

#define SPI_START_SEC_VAR_NO_INIT_UNSPECIFIED
#include "Spi_Mapping.h"                                                                                                /* PRQA S 5087 # JV-01 */

#if (SPI_LEVEL_DELIVERED == SPI_LEVEL_2)
/* Global variable to store the asynchronous transmission mechanism */
volatile VAR(Spi_AsyncModeType, SPI_VAR_NO_INIT) Spi_GenAsyncMode;
#endif

/* Hardware statuses */
volatile VAR(Spi_HWStatusType, SPI_VAR_NO_INIT) Spi_GaaHWStatus[SPI_MAX_HWUNIT];

#if ((SPI_LEVEL_DELIVERED == SPI_LEVEL_1) || (SPI_LEVEL_DELIVERED == SPI_LEVEL_2))
/* Queue structures */
volatile VAR(Spi_QueueType, SPI_VAR_NO_INIT) Spi_GaaQueue[SPI_MAX_QUEUE];
#endif

/* Sequence statuses and results */
volatile VAR(Spi_SeqStatusType, SPI_VAR_NO_INIT) Spi_GaaSeqStatus[SPI_MAX_SEQUENCE];

/* Job statuses and results */
volatile VAR(Spi_JobStatusType, SPI_VAR_NO_INIT) Spi_GaaJobStatus[SPI_MAX_JOB];

#if (SPI_EBDATA_SIZE > 0)
volatile VAR(Spi_EBDataType, SPI_VAR_NO_INIT) Spi_GaaEBData[SPI_EBDATA_SIZE];                                           /* PRQA S 1531 # JV-01 */
#endif

#define SPI_STOP_SEC_VAR_NO_INIT_UNSPECIFIED
#include "Spi_Mapping.h"                                                                                                /* PRQA S 5087 # JV-01 */

#define SPI_START_SEC_VAR_NO_INIT_32
#include "Spi_Mapping.h"                                                                                                /* PRQA S 5087 # JV-01 */

/* Bit array indicates active HW unit index
- The lower 16-bits are for synchronous transmission
- The upper 16-bits are for asynchronous transmission */
volatile VAR(uint32, SPI_VAR_NO_INIT) Spi_GulActiveHWUnits;                                                             /* PRQA S 1531 # JV-01 */

#if ((SPI_LEVEL_DELIVERED == SPI_LEVEL_1) || (SPI_LEVEL_DELIVERED == SPI_LEVEL_2))
/* Bit array indicates active Queues */
volatile VAR(uint32, SPI_VAR_NO_INIT) Spi_GulAllQueueSts;
/* Bit array indicates active Sequences */
volatile VAR(uint32, SPI_VAR_NO_INIT) Spi_GaaActiveSequence[SPI_BITS_TO_WORDS(SPI_MAX_SEQUENCE)];
#endif

#if (SPI_MAX_CHANNEL_BUFFER_SIZE > 0U)
/* Channel buffer, includes all tx and rx buffers for all channels
   This buffer should be aligned to 4 byte for 32 bit access */
volatile VAR(uint32, SPI_VAR_NO_INIT) Spi_GaaChannelBuffer[SPI_MAX_CHANNEL_BUFFER_SIZE / sizeof(uint32)];
#endif

#if (SPI_DMA_CONFIGURED == STD_ON)
/* Dummy destination if read data is not necessary */
volatile VAR(uint32, SPI_VAR_NO_INIT) Spi_GulDmaRxData;                                                                 /* PRQA S 1533, 1531 # JV-01, JV-01 */
#endif

#if ((SPI_LEVEL_DELIVERED == SPI_LEVEL_2) && (SPI_FORCE_CANCEL_API == STD_ON))
/* Bit array indicates HWUnits is being canceled by Spi_ForceCancel */
volatile VAR(uint32, SPI_VAR_NO_INIT) Spi_GulCancelingHWUnits;
#endif

#define SPI_STOP_SEC_VAR_NO_INIT_32
#include "Spi_Mapping.h"                                                                                                /* PRQA S 5087 # JV-01 */

/***********************************************************************************************************************
**                                                Function Definitions                                                **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
