/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Adc_sDMAC_LLDriver.h                                                                                */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* Private functions declarations.                                                                                    */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.4.4: 08/09/2022 : Removed macros ADC_DMA_TMR_DM_INC, ADC_DMA_TMR_SM_INC, ADC_DMA_CHCR_IE, ADC_DMA_CHCR_CAIE,
 *                     ADC_DMA_CHFCR_DPEC, ADC_DMA_DPPTR_PTR_MASK.
 *                     Added macros ADC_DMA_TMR_STS_2, ADC_DMA_CHCR_CAEE, ADC_DMA_CHFCR_CAEC
 * 1.4.3: 18/05/2022 : Fixed the typos in comments.
 * 1.4.1: 25/11/2021 : Added macros for handling DMA Transfer Request Group Selection Register.
 *                     Added instance 4 to the suppression of duplicate inclusion.
 * 1.4.0: 13/10/2021 : Removed macro ADC_DMA_SG_OUTER_HALF and ADC_DMA_RS_TL_DTS.
 *                     Added macro ADC_DMA_RS_TL_TSR.
 * 1.3.2: 16/09/2021 : Changed macros for DMA transfer settings.
 *        09/09/2021 : Added structures for storing DMA descriptors.
 *                     Changed the names of macros for handling DMA.
 *        06/09/2021 : Update header file macro to call file multiple times.
 * 1.3.1: 17/07/2021 : Removed unnecessary macro.
 *        07/07/2021 : Added QAC message 9.5.0
 *                     Changed comment format to 120 columns
 *                     Changed violation tag from START/END
 *        24/06/2021 : Removed the macro that not using.
 *        24/05/2021 : Added "extern" to external functions.
 *                     Change the position of an external function declaration.
 *        07/04/2021 : Changed to comply with coding rules.
 * 1.3.0: 23/12/2020 : Change return type of Adc_DmaDisable to boolean
 * 1.2.0: 14/07/2020 : Release
 *        27/07/2020 : Add QAC 9.3.1 comment.
 * 1.1.0: 19/06/2020 : Release
 * 1.0.2: 18/06/2020 : Add macro ADC_DMA_CLEAR_CHANNEL_CONTROL
 * 1.0.1: 09/04/2020 : Add const qualifier for arguments of internal functions
 *                     that are never changed
 * 1.0.0: 09/01/2020 : Initial Version
 */
/**********************************************************************************************************************/
#ifdef ADC_INSTANCE_INDEX
  #if (ADC_INSTANCE_INDEX == 0)
    #ifndef ADC_59_INST0_SDMAC_LLDRIVER_H
      #define ADC_59_INST0_SDMAC_LLDRIVER_H
      #define ADC_SDMAC_LLDRIVER_HEADER
    #endif
  #elif (ADC_INSTANCE_INDEX == 1)
    #ifndef ADC_59_INST1_SDMAC_LLDRIVER_H
      #define ADC_59_INST1_SDMAC_LLDRIVER_H
      #define ADC_SDMAC_LLDRIVER_HEADER
    #endif
  #elif (ADC_INSTANCE_INDEX == 2)
    #ifndef ADC_59_INST2_SDMAC_LLDRIVER_H
      #define ADC_59_INST2_SDMAC_LLDRIVER_H
      #define ADC_SDMAC_LLDRIVER_HEADER
    #endif
  #elif (ADC_INSTANCE_INDEX == 3)
    #ifndef ADC_59_INST3_SDMAC_LLDRIVER_H
      #define ADC_59_INST3_SDMAC_LLDRIVER_H
      #define ADC_SDMAC_LLDRIVER_HEADER
    #endif
  #elif (ADC_INSTANCE_INDEX == 4)
    #ifndef ADC_59_INST4_SDMAC_LLDRIVER_H
      #define ADC_59_INST4_SDMAC_LLDRIVER_H
      #define ADC_SDMAC_LLDRIVER_HEADER
    #endif
  #else
    #error "Miss instance index"
  #endif
#else
  #ifndef ADC_SDMAC_LLDRIVER_H
    #define ADC_SDMAC_LLDRIVER_H
    #define ADC_SDMAC_LLDRIVER_HEADER
  #endif
#endif

#ifdef ADC_SDMAC_LLDRIVER_HEADER
#undef ADC_SDMAC_LLDRIVER_HEADER                                                                                        /* PRQA S 0841 # JV-01 */


/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR release version information */
#define ADC_SDMAC_LLDRIVER_AR_RELEASE_MAJOR_VERSION    ADC_AR_RELEASE_MAJOR_VERSION
#define ADC_SDMAC_LLDRIVER_AR_RELEASE_MINOR_VERSION    ADC_AR_RELEASE_MINOR_VERSION                                     /* PRQA S 0791 # JV-01 */
#define ADC_SDMAC_LLDRIVER_AR_RELEASE_REVISION_VERSION ADC_AR_RELEASE_REVISION_VERSION

/* Module Software version information */
#define ADC_SDMAC_LLDRIVER_SW_MAJOR_VERSION            ADC_SW_MAJOR_VERSION
#define ADC_SDMAC_LLDRIVER_SW_MINOR_VERSION            ADC_SW_MINOR_VERSION

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (7:0791)    : [U] Macro identifier does not differ from other macro identifier(s) (e.g. '%s') within       */
/*                       the specified number of significant characters.                                              */
/* Rule                : CERTCCM DCL23, MISRA C:2012 Rule-5.4                                                         */
/* JV-01 Justification : This macro identifier is following AUTOSAR standard rule (Symbolic Name or Published         */
/*                       Macro's name), so this is accepted.                                                          */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:3630)    : The implementation of this struct/union type should be hidden.                               */
/* Rule                : MISRA C:2012 Dir-4.8                                                                         */
/* JV-01 Justification : This is accepted. Redundant of struct or union type has no affect to driver operation        */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                   Global Symbols                                                   **
***********************************************************************************************************************/
/* DMA function setting value */

/* Macros for register initialization */
#define ADC_DMA_SAR_INIT                     (uint32)0x00000000UL
#define ADC_DMA_DAR_INIT                     (uint32)0x00000000UL
#define ADC_DMA_TSR_INIT                     (uint32)0x00000000UL
#define ADC_DMA_GIAI_INIT                    (uint32)0x00000000UL
#define ADC_DMA_GOAI_INIT                    (uint32)0x00000000UL
#define ADC_DMA_SIAI_INIT                    (uint32)0x00000000UL
#define ADC_DMA_SOAI_INIT                    (uint32)0x00000000UL
#define ADC_DMA_SGCR_INIT                    (uint32)0x00000000UL
#define ADC_DMA_RS_INIT                      (uint32)0x00000000UL
#define ADC_DMA_DPPTR_INIT                   (uint32)0x00000000UL
#define ADC_DMA_DPCR_INIT                    (uint32)0x00000000UL
#define ADC_DMACSEL0_INIT                    (uint32)0x00000000UL
#define ADC_DMACSEL1_INIT                    (uint32)0x55555555UL

/* Macros for handling DMA transfer request group selection register */
#define ADC_DMA_CSEL_SHIFT_MASK              (uint32)0x0000000FUL
#define ADC_DMA_CSEL_MASK                    (uint32)0x00000003UL

/* Channel request priority setting mask */
#define ADC_DMA_TMR_PRI_MASK                 (uint32)(0x0FUL << 16U)
/* Transfer request source (1: Hardware request) */
#define ADC_DMA_TMR_TRS                      (uint32)(1UL << 12U)
/* DMA destination transaction size (1:2-byte, 2:4-byte,...) */
#define ADC_DMA_TMR_DTS_2                    (uint32)(1UL << 4U)
/* DMA source transaction size (1:2-byte, 2:4-byte,...) */
#define ADC_DMA_TMR_STS_2                    (uint32)(1UL << 0U)
/* DMA source transaction size (1:2-byte, 2:4-byte,...) */
#define ADC_DMA_TMR_STS_4                    (uint32)(2UL << 0U)

/* DMA enable */
#define ADC_DMA_CHCR_DE                      (uint16)(1UL << 0U)
/* Descriptor step end interrupt enable */
#define ADC_DMA_CHCR_DSIE                    (uint16)(1UL << 2U)
/* Channel address error interrupt INTSDMACERR enable */
#define ADC_DMA_CHCR_CAEE                    (uint16)(1UL << 4U)
/* Descriptor start */
#define ADC_DMA_CHCR_DPB                     (uint16)(1UL << 8U)
/* Descriptor enable */
#define ADC_DMA_CHCR_DPE                     (uint16)(1UL << 9U)

/* Channel busy flag */
#define ADC_DMA_CHSTA_BUSY                   (uint32)(1UL << 0U)
/* Transfer end flag */
#define ADC_DMA_CHSTA_TE                     (uint32)(1UL << 1U)
/* Descriptor step end flag */
#define ADC_DMA_CHSTA_DSE                    (uint32)(1UL << 2U)

/* DMA enable clear */
#define ADC_DMA_CHFCR_DEC                    (uint32)(1UL << 0U)
/* Transfer end flag clear */
#define ADC_DMA_CHFCR_TEC                    (uint32)(1UL << 1U)
/* Descriptor step end flag clear */
#define ADC_DMA_CHFCR_DSEC                   (uint32)(1UL << 2U)
/* Address error flag clear */
#define ADC_DMA_CHFCR_CAEC                   (uint32)(1UL << 3U)
/* Hardware transfer request clear */
#define ADC_DMA_CHFCR_DRQC                   (uint32)(1UL << 12U)
/* Hardware transfer request overflow flag clear */
#define ADC_DMA_CHFCR_OVFC                   (uint32)(1UL << 13U)

/* Scatter enable on source side */
#define ADC_DMA_SGCR_SEN                     (uint32)(1UL << 31U)
/* Gather enable on destination side*/
#define ADC_DMA_SGCR_GEN                     (uint32)(1UL << 15U)
/* Number of shifts to set the SIRPT bits */
#define ADC_DMA_SGCR_SIRPT_SFT               16U

/* Number of shifts to set the TC bits */
#define ADC_DMA_RS_TC_SFT                    16U
/* Transfer limit per hardware request (0:STS*TC, 1:DTS*TC, 2:TSR, 3:DSE, 4:TE) */
#define ADC_DMA_RS_TL_TSR                    (uint32)(2UL << 12U)

/* Descriptor interrupt enable */
#define ADC_DMA_DPPTR_DIE                    (uint32)(1UL << 1U)
/* Continuation flag of descriptor */
#define ADC_DMA_DPPTR_CF                     (uint32)(1UL << 0U)

/* Update flag of descriptor */
#define ADC_DMA_DPCR_UPF_SAR                 (uint32)(1UL << 0UL)
#define ADC_DMA_DPCR_UPF_DAR                 (uint32)(1UL << 1UL)
#define ADC_DMA_DPCR_UPF_TSR                 (uint32)(1UL << 2UL)

/* Transfer data size (sizeof Adc_ValueGroupType */
#define ADC_DMA_DATA_SIZE                    (uint32)0x00000002UL

/* Source transaction size (sizeof ADCXnDRj * 2 or sizeof ADCXnDIRj) */
#define ADC_DMA_STS_SIZE                     (uint32)0x00000004UL

/* Number of descriptor in descriptor set */
#define ADC_DMA_DESC_NUM                     2U

/* Macro for DMA channel */
#define ADC_DMA_CHANNEL_0                    (uint8)0x00U
#define ADC_DMA_CHANNEL_1                    (uint8)0x01U
#define ADC_DMA_CHANNEL_2                    (uint8)0x02U
#define ADC_DMA_CHANNEL_3                    (uint8)0x03U
#define ADC_DMA_CHANNEL_4                    (uint8)0x04U
#define ADC_DMA_CHANNEL_5                    (uint8)0x05U
#define ADC_DMA_CHANNEL_6                    (uint8)0x06U
#define ADC_DMA_CHANNEL_7                    (uint8)0x07U
#define ADC_DMA_CHANNEL_8                    (uint8)0x08U
#define ADC_DMA_CHANNEL_9                    (uint8)0x09U
#define ADC_DMA_CHANNEL_10                   (uint8)0x0AU
#define ADC_DMA_CHANNEL_11                   (uint8)0x0BU
#define ADC_DMA_CHANNEL_12                   (uint8)0x0CU
#define ADC_DMA_CHANNEL_13                   (uint8)0x0DU
#define ADC_DMA_CHANNEL_14                   (uint8)0x0EU
#define ADC_DMA_CHANNEL_15                   (uint8)0x0FU
#define ADC_DMA_CHANNEL_16                   (uint8)0x10U
#define ADC_DMA_CHANNEL_17                   (uint8)0x11U
#define ADC_DMA_CHANNEL_18                   (uint8)0x12U
#define ADC_DMA_CHANNEL_19                   (uint8)0x13U
#define ADC_DMA_CHANNEL_20                   (uint8)0x14U
#define ADC_DMA_CHANNEL_21                   (uint8)0x15U
#define ADC_DMA_CHANNEL_22                   (uint8)0x16U
#define ADC_DMA_CHANNEL_23                   (uint8)0x17U
#define ADC_DMA_CHANNEL_24                   (uint8)0x18U
#define ADC_DMA_CHANNEL_25                   (uint8)0x19U
#define ADC_DMA_CHANNEL_26                   (uint8)0x1AU
#define ADC_DMA_CHANNEL_27                   (uint8)0x1BU
#define ADC_DMA_CHANNEL_28                   (uint8)0x1CU
#define ADC_DMA_CHANNEL_29                   (uint8)0x1DU
#define ADC_DMA_CHANNEL_30                   (uint8)0x1EU
#define ADC_DMA_CHANNEL_31                   (uint8)0x1FU

/***********************************************************************************************************************
**                                                 Global Data Types                                                  **
***********************************************************************************************************************/

/***********************************************************************************************************************
** Structure for sDMAC Registers, which are used to read or write                                                     **
** the status or configured values for proper working of the sDMAC                                                    **
***********************************************************************************************************************/
#if (ADC_ENABLE_DMA_MODE == STD_ON)
typedef struct STag_Adc_DmaRegisters                                                                                    /* PRQA S 3630 # JV-01 */
{
  /* DMA source address register */
  volatile uint32 ulDMAjSARn;                                        /* 00H */
  /* DMA destination address register */
  volatile uint32 ulDMAjDARn;                                        /* 04H */
  /* DMA transfer size register */
  volatile uint32 ulDMAjTSRn;                                        /* 08H */
  /* DMA transfer size register B */
  volatile uint32 ulDMAjTSRBn;                                       /* 0CH */
  /* DMA transfer mode register */
  volatile uint32 ulDMAjTMRn;                                        /* 10H */
  /* DMA channel control register */
  volatile uint16 usDMAjCHCRn;                                       /* 14H */
  /* DMA channel stop register */
  volatile uint16 usDMAjCHSTPn;                                      /* 16H */
  /* DMA channel status register */
  volatile uint32 ulDMAjCHSTAn;                                      /* 18H */
  /* DMA channel flag clear register */
  volatile uint32 ulDMAjCHFCRn;                                      /* 1CH */
  /* DMA gather inner address increment register */
  volatile uint32 ulDMAjGIAIn;                                       /* 20H */
  /* DMA gather outer address increment register */
  volatile uint32 ulDMAjGOAIn;                                       /* 24H */
  /* DMA scatter inner address increment register */
  volatile uint32 ulDMAjSIAIn;                                       /* 28H */
  /* DMA scatter outer address increment register */
  volatile uint32 ulDMAjSOAIn;                                       /* 2CH */
  volatile uint32 aaReserved1[2];
  /* DMA scatter gather status register */
  volatile uint32 ulDMAjSGSTn;                                       /* 38H */
  /* DMA scatter gather control register */
  volatile uint32 ulDMAjSGCRn;                                       /* 3CH */
  /* DMA resource select register */
  volatile uint32 ulDMAjRSn;                                         /* 40H */
  volatile uint32 aaReserved2;
  /* DMA buffer control registers */
  volatile uint32 ulDMAjBUFCRn;                                      /* 48H */
  volatile uint32 aaReserved3;
  /* DMA descriptor pointer register */
  volatile uint32 ulDMAjDPPTRn;                                      /* 50H */
  /* DMA descriptor control register */
  volatile uint32 ulDMAjDPCRn;                                       /* 54H */
} Adc_DmaRegisters;

/* Structure for DMA descriptor */
typedef struct STag_Adc_DmaDescType
{
  /* DMA source address register */
  volatile uint32 ulDMAjSARn;                                        /* 00H */
  /* DMA destination address register */
  volatile uint32 ulDMAjDARn;                                        /* 04H */
  /* DMA transfer size register */
  volatile uint32 ulDMAjTSRn;                                        /* 08H */
  /* DMA descriptor pointer register */
  volatile uint32 ulDMAjDPPTRn;                                      /* 0CH */
} Adc_DmaDescType;

/* Structure for DMA descriptor set */
typedef struct STag_Adc_DmaDescSetType                                                                                  /* PRQA S 3630 # JV-01 */
{
  /* Two descriptors that are used alternately in a continuous transfer */
  Adc_DmaDescType aaDmaDesc[ADC_DMA_DESC_NUM];
} Adc_DmaDescSetType;

#endif /* (ADC_ENABLE_DMA_MODE == STD_ON) */

/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/
#if (ADC_ENABLE_DMA_MODE == STD_ON)

#define ADC_START_SEC_PRIVATE_CODE
#include "Adc_Mapping.h"

extern FUNC(void, ADC_PRIVATE_CODE) Adc_DmaInit(void);

#if (ADC_DEINIT_API == STD_ON)
extern FUNC(void, ADC_PRIVATE_CODE) Adc_DmaDeInit(void);
#endif /* (ADC_DEINIT_API == STD_ON) */

extern FUNC(void, ADC_PRIVATE_CODE) Adc_DmaEnable(const Adc_GroupType LddGroup);
extern FUNC(boolean, ADC_PRIVATE_CODE) Adc_DmaDisable(const Adc_GroupType LddGroup);
extern FUNC(boolean, ADC_PRIVATE_CODE) Adc_DmaGetTransferStatus(const Adc_GroupType LddGroup);
extern FUNC(void, ADC_PRIVATE_CODE) Adc_DmaClearInterruptFlag(const Adc_GroupType LddGroup);

#define ADC_STOP_SEC_PRIVATE_CODE
#include "Adc_Mapping.h"

#endif /* (ADC_ENABLE_DMA_MODE == STD_ON) */
#endif /* ADC_SDMAC_LLDRIVER_HEADER */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
