/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Spi_SDMAC_Irq.h                                                                                     */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* Provision for prototypes of Interrupt Service Routines.                                                            */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/* 1.4.4:  16/10/2022  : Add respectively pre-compile for ISR
 * 1.4.2:  02/03/2022  : Merge QAC
 * 1.3.2:  06/09/2021  : Update QAC contents
 *         04/09/2021  : Add pre-compile condition for defining multiple files base on instance index
 *                       Replace the inclusion of Spi_MemMap.h with Spi_Mapping.h
 * 1.3.1:  02/07/2021  : Add QAC message 9.5.0
 *                       Format source code to 120 characters
 *                       Improve Violation tag (remove START/END) 
 * 1.2.0:  30/07/2020  : Release
 *         28/07/2020  : Add QAC 9.3.1 comment.
 * 1.1.0:  19/06/2020  : Release
 * 1.0.0:  24/03/2020  : Initial Version
 */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/

/**********************************************************************************************************************/

#ifdef SPI_INSTANCE_INDEX
    #if (SPI_INSTANCE_INDEX == 0)
        #ifndef SPI_59_INST0_SDMAC_IRQ
            #define SPI_59_INST0_SDMAC_IRQ
            #define SPI_SDMAC_IRQ_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 1)
        #ifndef SPI_59_INST1_SDMAC_IRQ
            #define SPI_59_INST1_SDMAC_IRQ
            #define SPI_SDMAC_IRQ_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 2)
        #ifndef SPI_59_INST2_SDMAC_IRQ
            #define SPI_59_INST2_SDMAC_IRQ
            #define SPI_SDMAC_IRQ_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 3)
        #ifndef SPI_59_INST3_SDMAC_IRQ
            #define SPI_59_INST3_SDMAC_IRQ
            #define SPI_SDMAC_IRQ_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 4)
        #ifndef SPI_59_INST4_SDMAC_IRQ
            #define SPI_59_INST4_SDMAC_IRQ
            #define SPI_SDMAC_IRQ_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 5)
        #ifndef SPI_59_INST5_SDMAC_IRQ
            #define SPI_59_INST5_SDMAC_IRQ
            #define SPI_SDMAC_IRQ_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 6)
        #ifndef SPI_59_INST6_SDMAC_IRQ
            #define SPI_59_INST6_SDMAC_IRQ
            #define SPI_SDMAC_IRQ_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 7)
        #ifndef SPI_59_INST7_SDMAC_IRQ
            #define SPI_59_INST7_SDMAC_IRQ
            #define SPI_SDMAC_IRQ_HEADER
        #endif
    #else
        #error "Miss instance index"
    #endif
#else
    #ifndef SPI_SDMAC_IRQ
        #define SPI_SDMAC_IRQ
        #define SPI_SDMAC_IRQ_HEADER
    #endif
#endif

#ifdef SPI_SDMAC_IRQ_HEADER
#undef SPI_SDMAC_IRQ_HEADER                                                                                             /* PRQA S 0841 # JV-01 */

/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/
/* Included for interrupt category definitions */
#include "Os.h"

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR Release version information */
#define SPI_SDMAC_IRQ_AR_RELEASE_MAJOR_VERSION    SPI_AR_RELEASE_MAJOR_VERSION
#define SPI_SDMAC_IRQ_AR_RELEASE_MINOR_VERSION    SPI_AR_RELEASE_MINOR_VERSION
#define SPI_SDMAC_IRQ_AR_RELEASE_REVISION_VERSION SPI_AR_RELEASE_REVISION_VERSION

/* File version information */
#define SPI_SDMAC_IRQ_SW_MAJOR_VERSION            SPI_SW_MAJOR_VERSION
#define SPI_SDMAC_IRQ_SW_MINOR_VERSION            SPI_SW_MINOR_VERSION

/***********************************************************************************************************************
**                                                   Global Symbols                                                   **
***********************************************************************************************************************/

/* Physical unit number */
#define SPI_PHYIDX_DMA0_00                        0U
#define SPI_PHYIDX_DMA0_01                        1U
#define SPI_PHYIDX_DMA0_02                        2U
#define SPI_PHYIDX_DMA0_03                        3U
#define SPI_PHYIDX_DMA0_04                        4U
#define SPI_PHYIDX_DMA0_05                        5U
#define SPI_PHYIDX_DMA0_06                        6U
#define SPI_PHYIDX_DMA0_07                        7U
#define SPI_PHYIDX_DMA0_08                        8U
#define SPI_PHYIDX_DMA0_09                        9U
#define SPI_PHYIDX_DMA0_10                        10U
#define SPI_PHYIDX_DMA0_11                        11U
#define SPI_PHYIDX_DMA0_12                        12U
#define SPI_PHYIDX_DMA0_13                        13U
#define SPI_PHYIDX_DMA0_14                        14U
#define SPI_PHYIDX_DMA0_15                        15U
#define SPI_PHYIDX_DMA1_00                        16U
#define SPI_PHYIDX_DMA1_01                        17U
#define SPI_PHYIDX_DMA1_02                        18U
#define SPI_PHYIDX_DMA1_03                        19U
#define SPI_PHYIDX_DMA1_04                        20U
#define SPI_PHYIDX_DMA1_05                        21U
#define SPI_PHYIDX_DMA1_06                        22U
#define SPI_PHYIDX_DMA1_07                        23U
#define SPI_PHYIDX_DMA1_08                        24U
#define SPI_PHYIDX_DMA1_09                        25U
#define SPI_PHYIDX_DMA1_10                        26U
#define SPI_PHYIDX_DMA1_11                        27U
#define SPI_PHYIDX_DMA1_12                        28U
#define SPI_PHYIDX_DMA1_13                        29U
#define SPI_PHYIDX_DMA1_14                        30U
#define SPI_PHYIDX_DMA1_15                        31U

/***********************************************************************************************************************
**                                                 Global Data Types                                                  **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/
#define SPI_START_SEC_CODE_FAST
#include "Spi_Mapping.h"

#if (SPI_DMA0_00_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA0_00_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA0_00_ISR(void);
#endif
#endif /* End of (SPI_DMA0_00_ISR_API == STD_ON) */

#if (SPI_DMA0_01_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA0_01_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA0_01_ISR(void);
#endif
#endif /* End of (SPI_DMA0_01_ISR_API == STD_ON) */

#if (SPI_DMA0_02_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA0_02_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA0_02_ISR(void);
#endif
#endif /* End of (SPI_DMA0_02_ISR_API == STD_ON) */

#if (SPI_DMA0_03_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA0_03_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA0_03_ISR(void);
#endif
#endif /* End of (SPI_DMA0_03_ISR_API == STD_ON) */

#if (SPI_DMA0_04_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA0_04_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA0_04_ISR(void);
#endif
#endif /* End of (SPI_DMA0_04_ISR_API == STD_ON) */

#if (SPI_DMA0_05_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA0_05_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA0_05_ISR(void);
#endif
#endif /* End of (SPI_DMA0_05_ISR_API == STD_ON) */

#if (SPI_DMA0_06_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA0_06_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA0_06_ISR(void);
#endif
#endif /* End of (SPI_DMA0_06_ISR_API == STD_ON) */

#if (SPI_DMA0_07_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA0_07_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA0_07_ISR(void);
#endif
#endif /* End of (SPI_DMA0_07_ISR_API == STD_ON) */

#if (SPI_DMA0_08_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA0_08_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA0_08_ISR(void);
#endif
#endif /* End of (SPI_DMA0_08_ISR_API == STD_ON) */

#if (SPI_DMA0_09_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA0_09_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA0_09_ISR(void);
#endif
#endif /* End of (SPI_DMA0_09_ISR_API == STD_ON) */

#if (SPI_DMA0_10_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA0_10_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA0_10_ISR(void);
#endif
#endif /* End of (SPI_DMA0_10_ISR_API == STD_ON) */

#if (SPI_DMA0_11_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA0_11_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA0_11_ISR(void);
#endif
#endif /* End of (SPI_DMA0_11_ISR_API == STD_ON) */

#if (SPI_DMA0_12_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA0_12_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA0_12_ISR(void);
#endif
#endif /* End of (SPI_DMA0_12_ISR_API == STD_ON) */

#if (SPI_DMA0_13_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA0_13_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA0_13_ISR(void);
#endif
#endif /* End of (SPI_DMA0_13_ISR_API == STD_ON) */

#if (SPI_DMA0_14_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA0_14_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA0_14_ISR(void);
#endif
#endif /* End of (SPI_DMA0_14_ISR_API == STD_ON) */

#if (SPI_DMA0_15_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA0_15_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA0_15_ISR(void);
#endif
#endif /* End of (SPI_DMA0_15_ISR_API == STD_ON) */

#if (SPI_DMA1_00_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA1_00_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA1_00_ISR(void);
#endif
#endif /* End of (SPI_DMA1_00_ISR_API == STD_ON) */

#if (SPI_DMA1_01_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA1_01_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA1_01_ISR(void);
#endif
#endif /* End of (SPI_DMA1_01_ISR_API == STD_ON) */

#if (SPI_DMA1_02_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA1_02_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA1_02_ISR(void);
#endif
#endif /* End of (SPI_DMA1_02_ISR_API == STD_ON) */

#if (SPI_DMA1_03_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA1_03_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA1_03_ISR(void);
#endif
#endif /* End of (SPI_DMA1_03_ISR_API == STD_ON) */

#if (SPI_DMA1_04_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA1_04_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA1_04_ISR(void);
#endif
#endif /* End of (SPI_DMA1_04_ISR_API == STD_ON) */

#if (SPI_DMA1_05_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA1_05_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA1_05_ISR(void);
#endif
#endif /* End of (SPI_DMA1_05_ISR_API == STD_ON) */

#if (SPI_DMA1_06_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA1_06_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA1_06_ISR(void);
#endif
#endif /* End of (SPI_DMA1_06_ISR_API == STD_ON) */

#if (SPI_DMA1_07_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA1_07_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA1_07_ISR(void);
#endif
#endif /* End of (SPI_DMA1_07_ISR_API == STD_ON) */

#if (SPI_DMA1_08_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA1_08_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA1_08_ISR(void);
#endif
#endif /* End of (SPI_DMA1_08_ISR_API == STD_ON) */

#if (SPI_DMA1_09_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA1_09_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA1_09_ISR(void);
#endif
#endif /* End of (SPI_DMA1_09_ISR_API == STD_ON) */

#if (SPI_DMA1_10_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA1_10_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA1_10_ISR(void);
#endif
#endif /* End of (SPI_DMA1_10_ISR_API == STD_ON) */

#if (SPI_DMA1_11_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA1_11_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA1_11_ISR(void);
#endif
#endif /* End of (SPI_DMA1_11_ISR_API == STD_ON) */

#if (SPI_DMA1_12_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA1_12_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA1_12_ISR(void);
#endif
#endif /* End of (SPI_DMA1_12_ISR_API == STD_ON) */

#if (SPI_DMA1_13_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA1_13_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA1_13_ISR(void);
#endif
#endif /* End of (SPI_DMA1_13_ISR_API == STD_ON) */

#if (SPI_DMA1_14_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA1_14_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA1_14_ISR(void);
#endif
#endif /* End of (SPI_DMA1_14_ISR_API == STD_ON) */

#if (SPI_DMA1_15_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_SPI_DMA1_15_CAT2_ISR) || (SPI_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, SPI_CODE_FAST) SPI_DMA1_15_ISR(void);
#endif
#endif /* End of (SPI_DMA1_15_ISR_API == STD_ON) */

#define SPI_STOP_SEC_CODE_FAST
#include "Spi_Mapping.h"

#endif /* SPI_SDMAC_IRQ_HEADER */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
