/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Spi_Lcfg.c                                                                                          */
/*====================================================================================================================*/
/*                                  COPYRIGHT                                                                         */
/*====================================================================================================================*/
/* (c) 2022 Renesas Electronics Corporation. All rights reserved.                                                     */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains link time parameters.                                                                           */
/* AUTOMATICALLY GENERATED FILE - DO NOT EDIT                                                                         */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s)        */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        R7F702301BFABG                                                                        */
/*====================================================================================================================*/


/***********************************************************************************************************************
**                      Revision Control History                                                                      **
***********************************************************************************************************************/



/***********************************************************************************************************************
**                      Generation Tool Version                                                                       **
***********************************************************************************************************************/
/*                                                                                                                    */
/* TOOL VERSION:  SpiU2x.dll version: 1.5.0, MCALConfGen.exe version: 1.4.0                                           */
/*                                                                                                                    */


/***********************************************************************************************************************
**                      Input File                                                                                    **
***********************************************************************************************************************/
/*
 * INPUT FILE:    D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\Config\ECUC\test_Spi_Spi_ecuc.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\Config\ECUC\test_Mcu_Mcu_ecuc.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\generator\BSWMDT\R431_SPI_U2A8_BSWMDT.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\stubs\Dem\xml\Dem_Spi.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\Translation.trxml
 * GENERATED ON:  27 Apr 2025 - 14:14:15
 */


/***********************************************************************************************************************
**                      Instance Index                                                                                **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      Include Section                                                                               **
***********************************************************************************************************************/
#include "Spi.h"                                                                                                        /* PRQA S 0857 # JV-01 */

#include "Spi_Ram.h"

#include "Spi_MSPI_LLDriver.h"


/***********************************************************************************************************************
**                      Coding Rule Violations                                                                        **
***********************************************************************************************************************/
/**********************************************************************************************************************/
/* Message (2:0306)    : [I] Cast between a pointer to object and an integral type.                                   */
/* Rule                : MISRA-C:2012 Rule 11.4, CERT-C:1.2.4 CERTCMM INT36                                           */
/* JV-01 Justification : Typecasting is done as per the register size, to access hardware registers.                  */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (1:1531)    : The object 'name' is referenced in only one translation unit - but not the one in which it   */
/*                       is defined.                                                                                  */
/* Rule                : MISRA C:2012 Rule-8.7, CERTCCM DCL15, CERTCCM DCL19                                          */
/* JV-01 Justification : Followed coding rules, the objects (global variable/const) is define in seperated source     */
/*                       file, so this could be accepted.                                                             */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (4:5087)    : Use of #include directive after code fragment.                                               */
/* Rule                : MISRA C:2012 Rule 20.1                                                                       */
/* JV-01 Justification : This is done as per Memory Requirement, (MEMMAP003 - Specification of Memory Mapping).       */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:0857)    : Number of macro definitions exceeds 1024 - program does not conform strictly to ISO:C90.     */
/* Rule                : MISRA C:2012 Dir-1.1                                                                         */
/* JV-01 Justification : The number of macro depend on module code size. There is no issue when number of macro       */
/*                       is over 1024                                                                                 */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/


/***********************************************************************************************************************
**                      Version Information                                                                           **
***********************************************************************************************************************/
/* AUTOSAR specification version information */
#define SPI_LCFG_C_AR_RELEASE_MAJOR_VERSION                                     4U
#define SPI_LCFG_C_AR_RELEASE_MINOR_VERSION                                     3U
#define SPI_LCFG_C_AR_RELEASE_REVISION_VERSION                                  1U
/* File version information */
#define SPI_LCFG_C_SW_MAJOR_VERSION                                             1U
#define SPI_LCFG_C_SW_MINOR_VERSION                                             5U

/***********************************************************************************************************************
**                      Version Check                                                                                 **
***********************************************************************************************************************/
#if (SPI_LTTYPES_AR_RELEASE_MAJOR_VERSION != SPI_LCFG_C_AR_RELEASE_MAJOR_VERSION)
  #error "Spi_Lcfg.c : Mismatch in Release Major Version"
#endif

#if (SPI_LTTYPES_AR_RELEASE_MINOR_VERSION != SPI_LCFG_C_AR_RELEASE_MINOR_VERSION)
  #error "Spi_Lcfg.c : Mismatch in Release Minor Version"
#endif

#if (SPI_LTTYPES_AR_RELEASE_REVISION_VERSION != SPI_LCFG_C_AR_RELEASE_REVISION_VERSION)
  #error "Spi_Lcfg.c : Mismatch in Release Revision Version"
#endif

#if (SPI_LTTYPES_SW_MAJOR_VERSION != SPI_LCFG_C_SW_MAJOR_VERSION)
  #error "Spi_Lcfg.c : Mismatch in Software Major Version"
#endif

#if (SPI_LTTYPES_SW_MINOR_VERSION != SPI_LCFG_C_SW_MINOR_VERSION)
  #error "Spi_Lcfg.c : Mismatch in Software Minor Version"
#endif


/***********************************************************************************************************************
**                      Global Data Types                                                                             **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      Global Data                                                                                   **
***********************************************************************************************************************/
#define SPI_START_SEC_CONST_UNSPECIFIED
#include "Spi_MemMap.h"


/* MSPI Register set information */
CONST(Spi_MSPIRegisterSetType, SPI_CONFIG_DATA) Spi_GaaMSPIRegs[] =                                                     /* PRQA S 1531 # JV-01 */
{
  /* Index: 0 - MSPI0 */
  {
    /* pRegs */
    (Spi_MSPIRegType*)0xFFC76000UL,                                                                                     /* PRQA S 0306 # JV-01 */

    /* pIntfRegs */
    (Spi_MSPIIntfRegType*)0xFFC75740UL,                                                                                 /* PRQA S 0306 # JV-01 */

    /* pTrgGenRegs */
    (Spi_MSPITrgGenRegType*)0xFFC75D00UL,                                                                               /* PRQA S 0306 # JV-01 */

    /* pICTX */
    (uint16*)0xFFF801F4UL,                                                                                              /* PRQA S 0306 # JV-01 */

    /* pICRX */
    (uint16*)0xFFF801F6UL,                                                                                              /* PRQA S 0306 # JV-01 */

    /* pICFE */
    (uint16*)0xFFF801F8UL,                                                                                              /* PRQA S 0306 # JV-01 */

    /* pICERR */
    (uint16*)0xFFF801FAUL,                                                                                              /* PRQA S 0306 # JV-01 */

    /* ucPhyChannelMax */
    0x08U
  },
  /* Index: 1 - MSPI1 */
  {
    /* pRegs */
    (Spi_MSPIRegType*)0xFFC7E000UL,                                                                                     /* PRQA S 0306 # JV-01 */

    /* pIntfRegs */
    (Spi_MSPIIntfRegType*)0xFFC7C840UL,                                                                                 /* PRQA S 0306 # JV-01 */

    /* pTrgGenRegs */
    (Spi_MSPITrgGenRegType*)0xFFC75D00UL,                                                                               /* PRQA S 0306 # JV-01 */

    /* pICTX */
    (uint16*)0xFFF80208UL,                                                                                              /* PRQA S 0306 # JV-01 */

    /* pICRX */
    (uint16*)0xFFF8020AUL,                                                                                              /* PRQA S 0306 # JV-01 */

    /* pICFE */
    (uint16*)0xFFF8020CUL,                                                                                              /* PRQA S 0306 # JV-01 */

    /* pICERR */
    (uint16*)0xFFF8020EUL,                                                                                              /* PRQA S 0306 # JV-01 */

    /* ucPhyChannelMax */
    0x08U
  },
  /* Index: 2 - MSPI2 */
  {
    /* pRegs */
    (Spi_MSPIRegType*)0xFFD80000UL,                                                                                     /* PRQA S 0306 # JV-01 */

    /* pIntfRegs */
    (Spi_MSPIIntfRegType*)0xFFC75840UL,                                                                                 /* PRQA S 0306 # JV-01 */

    /* pTrgGenRegs */
    (Spi_MSPITrgGenRegType*)0xFFC75D00UL,                                                                               /* PRQA S 0306 # JV-01 */

    /* pICTX */
    (uint16*)0xFFF80210UL,                                                                                              /* PRQA S 0306 # JV-01 */

    /* pICRX */
    (uint16*)0xFFF80212UL,                                                                                              /* PRQA S 0306 # JV-01 */

    /* pICFE */
    (uint16*)0xFFF80214UL,                                                                                              /* PRQA S 0306 # JV-01 */

    /* pICERR */
    (uint16*)0xFFF80216UL,                                                                                              /* PRQA S 0306 # JV-01 */

    /* ucPhyChannelMax */
    0x08U
  },
  /* Index: 3 - MSPI3 */
  {
    /* pRegs */
    (Spi_MSPIRegType*)0xFFCC0000UL,                                                                                     /* PRQA S 0306 # JV-01 */

    /* pIntfRegs */
    (Spi_MSPIIntfRegType*)0xFFC7CA40UL,                                                                                 /* PRQA S 0306 # JV-01 */

    /* pTrgGenRegs */
    (Spi_MSPITrgGenRegType*)0xFFC75D00UL,                                                                               /* PRQA S 0306 # JV-01 */

    /* pICTX */
    (uint16*)0xFFF80218UL,                                                                                              /* PRQA S 0306 # JV-01 */

    /* pICRX */
    (uint16*)0xFFF8021AUL,                                                                                              /* PRQA S 0306 # JV-01 */

    /* pICFE */
    (uint16*)0xFFF8021CUL,                                                                                              /* PRQA S 0306 # JV-01 */

    /* pICERR */
    (uint16*)0xFFF8021EUL,                                                                                              /* PRQA S 0306 # JV-01 */

    /* ucPhyChannelMax */
    0x08U
  },
  /* Index: 4 - MSPI4 */
  {
    /* pRegs */
    (Spi_MSPIRegType*)0xFFD82000UL,                                                                                     /* PRQA S 0306 # JV-01 */

    /* pIntfRegs */
    (Spi_MSPIIntfRegType*)0xFFC75940UL,                                                                                 /* PRQA S 0306 # JV-01 */

    /* pTrgGenRegs */
    (Spi_MSPITrgGenRegType*)0xFFC75D00UL,                                                                               /* PRQA S 0306 # JV-01 */

    /* pICTX */
    (uint16*)0xFFF80220UL,                                                                                              /* PRQA S 0306 # JV-01 */

    /* pICRX */
    (uint16*)0xFFF80222UL,                                                                                              /* PRQA S 0306 # JV-01 */

    /* pICFE */
    (uint16*)0xFFF80224UL,                                                                                              /* PRQA S 0306 # JV-01 */

    /* pICERR */
    (uint16*)0xFFF80226UL,                                                                                              /* PRQA S 0306 # JV-01 */

    /* ucPhyChannelMax */
    0x08U
  }
};

#define SPI_STOP_SEC_CONST_UNSPECIFIED
#include "Spi_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */



/***********************************************************************************************************************
**                      Function Definitions                                                                          **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      End of File                                                                                   **
***********************************************************************************************************************/

