/*============================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                         */
/* Module       = U2A8_translation.h                                          */
/* SW-VERSION   = 1.5.0                                                       */
/*============================================================================*/
/*                                  COPYRIGHT                                 */
/*============================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.        */
/*============================================================================*/
/* Purpose:                                                                   */
/* This translation file maps device file macros with user defined            */
/* (RENESAS_SCIT) macros.  Generator uses this translation file inorder to    */
/* avoid hardcoding of base addressess or the usage of device header file     */
/* macros directly.                                                           */
/*============================================================================*/
/*                                                                            */
/* Unless otherwise agreed upon in writing between your company and           */
/* Renesas Electronics Corporation the following shall apply!                 */
/*                                                                            */
/* Warranty Disclaimer                                                        */
/*                                                                            */
/* There is no warranty of any kind whatsoever granted by Renesas. Any        */
/* warranty is expressly disclaimed and excluded by Renesas, either expressed */
/* or implied, including but not limited to those for non-infringement of     */
/* intellectual property, merchantability and/or fitness for the particular   */
/* purpose.                                                                   */
/*                                                                            */
/* Renesas shall not have any obligation to maintain, service or provide bug  */
/* fixes for the supplied Product(s) and/or the Application.                  */
/*                                                                            */
/* Each User is solely responsible for determining the appropriateness of     */
/* using the Product(s) and assumes all risks associated with its exercise    */
/* of rights under this Agreement, including, but not limited to the risks    */
/* and costs of program errors, compliance with applicable laws, damage to    */
/* or loss of data, programs or equipment, and unavailability or              */
/* interruption of operations.                                                */
/*                                                                            */
/* Limitation of Liability                                                    */
/*                                                                            */
/* In no event shall Renesas be liable to the User for any incidental,        */
/* consequential, indirect, or punitive damage (including but not limited     */
/* to lost profits) regardless of whether such liability is based on breach   */
/* of contract, tort, strict liability, breach of warranties, failure of      */
/* essential purpose or otherwise and even if advised of the possibility of   */
/* such damages. Renesas shall not be liable for any services or products     */
/* provided by third party vendors, developers or consultants identified or   */
/* referred to the User by Renesas in connection with the Product(s) and/or   */
/* the Application.                                                           */
/*                                                                            */
/*============================================================================*/
/* Environment:                                                               */
/*              Devices:        RH850/U2A8                                    */
/*============================================================================*/

/*******************************************************************************
**                      Revision Control History                              **
*******************************************************************************/
/*
 * 1.4.4: 04/08/2022 : Update macros name RENESAS_RSCFD0CFDGAFLID1, 
 *                     RENESAS_RSCFD1CFDGAFLID1 and value RSCFD0_CFDGAFLID1,
 *                     RSCFD1_CFDGAFLID1 to RENESAS_RSCFD0CFDGAFLID0, 
 *                     RENESAS_RSCFD1CFDGAFLID0 and value RSCFD0_CFDGAFLID0,
 *                     RSCFD1_CFDGAFLID0
 *        20/06/2022 : Added RENESAS_PIC2ADTEN[5-8][0-1]0, and
 *                     RENESAS_PIC2ADTEN4[1-2]0 for ADC.
 * 1.3.2: 23/08/2021 : Add RENESAS_PWBA, RENESAS_SLPWG, RENESAS_PWSD, RENESAS_PWGC_INTF
                       Add RENESAS_PWGC0CSDR to RENESAS_PWGC95CSDR
                       Add RENESAS_INTPWGCG00, RENESAS_INTPWGCG01, RENESAS_INTPWGCG02,
                       RENESAS_INTPWGCG10, RENESAS_INTPWGCG11, RENESAS_INTPWGCG12,
                       RENESAS_INTPWGCG20, RENESAS_INTPWGCG21, RENESAS_INTPWGCG22,
                       RENESAS_INTPWGCG30, RENESAS_INTPWGCG31, RENESAS_INTPWGCG32
 * 1.3.1: 13/05/2021 : Remove RENESAS_PCR08_10
 *                     Update RENESAS_APSFTS1 and RENESAS_APSFTSE1
 *        10/05/2021 : Remove define of unsupport port group.
 *                     Add define for missing port pin.
 *                     Update RENESAS_ICWDTBA to INTC2_EIC705
 *        29/04/2021 : Update define RENESAS_ICOSTMn for OSTM Unit
 * 1.2.0: 24/07/2020 : Release, remove macro related to OSTM6 and
 *                     OSTM7, added definnition of OSTM8 and OSTM9
 *                     Add macro RENESAS_ECMMESSTR2, RENESAS_ECMINCFG002,
 *                     RENESAS_ECMINCFG102, RENESAS_ECMISCFG2.
 * 1.1.0: 19/06/2020 : Release
 * 1.0.2: 11/06/2020 : Add macro RENESAS_DMONTEST and RENESAS_DMONKCPROT2
 * 1.0.1: 28/05/2020 : Update macro name of Flexray modules
 * 1.0.0: 04/05/2020 : Initial version
 */
/******************************************************************************/
/*******************************************************************************
**                      Include Section                                       **
*******************************************************************************/

/*******************************************************************************
**                      Version Information                                   **
*******************************************************************************/

/*******************************************************************************
**                      Global Symbols                                        **
*******************************************************************************/

/*******************************************************************************
**                      Global Data Types                                     **
*******************************************************************************/

#define RENESAS_P0                                      PORT0_P0
#define RENESAS_PSR0                                    PORT0_PSR0
#define RENESAS_PNOT0                                   PORT0_PNOT0
#define RENESAS_PPR0                                    PORT0_PPR0
#define RENESAS_PM0                                     PORT0_PM0
#define RENESAS_PMC0                                    PORT0_PMC0
#define RENESAS_PFC0                                    PORT0_PFC0
#define RENESAS_PFCE0                                   PORT0_PFCE0
#define RENESAS_PMSR0                                   PORT0_PMSR0
#define RENESAS_PMCSR0                                  PORT0_PMCSR0
#define RENESAS_PFCAE0                                  PORT0_PFCAE0
#define RENESAS_PINV0                                   PORT0_PINV0
#define RENESAS_PSFC0                                   PORT0_PSFC0
#define RENESAS_PSFTS0                                  PORT0_PSFTS0
#define RENESAS_PSFTSE0                                 PORT0_PSFTSE0
#define RENESAS_P2                                      PORT0_P2
#define RENESAS_PSR2                                    PORT0_PSR2
#define RENESAS_PNOT2                                   PORT0_PNOT2
#define RENESAS_PPR2                                    PORT0_PPR2
#define RENESAS_PM2                                     PORT0_PM2
#define RENESAS_PMC2                                    PORT0_PMC2
#define RENESAS_PFC2                                    PORT0_PFC2
#define RENESAS_PFCE2                                   PORT0_PFCE2
#define RENESAS_PMSR2                                   PORT0_PMSR2
#define RENESAS_PMCSR2                                  PORT0_PMCSR2
#define RENESAS_PFCAE2                                  PORT0_PFCAE2
#define RENESAS_PINV2                                   PORT0_PINV2
#define RENESAS_PSFC2                                   PORT0_PSFC2
#define RENESAS_PSFTS2                                  PORT0_PSFTS2
#define RENESAS_PSFTSE2                                 PORT0_PSFTSE2
#define RENESAS_P10                                     PORT0_P10
#define RENESAS_PSR10                                   PORT0_PSR10
#define RENESAS_PNOT10                                  PORT0_PNOT10
#define RENESAS_PPR10                                   PORT0_PPR10
#define RENESAS_PM10                                    PORT0_PM10
#define RENESAS_PMC10                                   PORT0_PMC10
#define RENESAS_PFC10                                   PORT0_PFC10
#define RENESAS_PFCE10                                  PORT0_PFCE10
#define RENESAS_PMSR10                                  PORT0_PMSR10
#define RENESAS_PMCSR10                                 PORT0_PMCSR10
#define RENESAS_PFCAE10                                 PORT0_PFCAE10
#define RENESAS_PINV10                                  PORT0_PINV10
#define RENESAS_PSFC10                                  PORT0_PSFC10
#define RENESAS_PSFTS10                                 PORT0_PSFTS10
#define RENESAS_PSFTSE10                                PORT0_PSFTSE10
#define RENESAS_P11                                     PORT0_P11
#define RENESAS_PSR11                                   PORT0_PSR11
#define RENESAS_PNOT11                                  PORT0_PNOT11
#define RENESAS_PPR11                                   PORT0_PPR11
#define RENESAS_PM11                                    PORT0_PM11
#define RENESAS_PMC11                                   PORT0_PMC11
#define RENESAS_PFC11                                   PORT0_PFC11
#define RENESAS_PFCE11                                  PORT0_PFCE11
#define RENESAS_PMSR11                                  PORT0_PMSR11
#define RENESAS_PMCSR11                                 PORT0_PMCSR11
#define RENESAS_PFCAE11                                 PORT0_PFCAE11
#define RENESAS_PINV11                                  PORT0_PINV11
#define RENESAS_PSFC11                                  PORT0_PSFC11
#define RENESAS_PSFTS11                                 PORT0_PSFTS11
#define RENESAS_PSFTSE11                                PORT0_PSFTSE11
#define RENESAS_P20                                     PORT0_P20
#define RENESAS_PSR20                                   PORT0_PSR20
#define RENESAS_PNOT20                                  PORT0_PNOT20
#define RENESAS_PPR20                                   PORT0_PPR20
#define RENESAS_PM20                                    PORT0_PM20
#define RENESAS_PMC20                                   PORT0_PMC20
#define RENESAS_PFC20                                   PORT0_PFC20
#define RENESAS_PFCE20                                  PORT0_PFCE20
#define RENESAS_PMSR20                                  PORT0_PMSR20
#define RENESAS_PMCSR20                                 PORT0_PMCSR20
#define RENESAS_PFCAE20                                 PORT0_PFCAE20
#define RENESAS_PINV20                                  PORT0_PINV20
#define RENESAS_PSFC20                                  PORT0_PSFC20
#define RENESAS_PSFTS20                                 PORT0_PSFTS20
#define RENESAS_PSFTSE20                                PORT0_PSFTSE20
#define RENESAS_P21                                     PORT0_P21
#define RENESAS_PSR21                                   PORT0_PSR21
#define RENESAS_PNOT21                                  PORT0_PNOT21
#define RENESAS_PPR21                                   PORT0_PPR21
#define RENESAS_PM21                                    PORT0_PM21
#define RENESAS_PMC21                                   PORT0_PMC21
#define RENESAS_PFC21                                   PORT0_PFC21
#define RENESAS_PFCE21                                  PORT0_PFCE21
#define RENESAS_PMSR21                                  PORT0_PMSR21
#define RENESAS_PMCSR21                                 PORT0_PMCSR21
#define RENESAS_PFCAE21                                 PORT0_PFCAE21
#define RENESAS_PINV21                                  PORT0_PINV21
#define RENESAS_PSFC21                                  PORT0_PSFC21
#define RENESAS_PSFTS21                                 PORT0_PSFTS21
#define RENESAS_PSFTSE21                                PORT0_PSFTSE21
#define RENESAS_P22                                     PORT0_P22
#define RENESAS_PSR22                                   PORT0_PSR22
#define RENESAS_PNOT22                                  PORT0_PNOT22
#define RENESAS_PPR22                                   PORT0_PPR22
#define RENESAS_PM22                                    PORT0_PM22
#define RENESAS_PMC22                                   PORT0_PMC22
#define RENESAS_PFC22                                   PORT0_PFC22
#define RENESAS_PFCE22                                  PORT0_PFCE22
#define RENESAS_PMSR22                                  PORT0_PMSR22
#define RENESAS_PMCSR22                                 PORT0_PMCSR22
#define RENESAS_PFCAE22                                 PORT0_PFCAE22
#define RENESAS_PINV22                                  PORT0_PINV22
#define RENESAS_PSFC22                                  PORT0_PSFC22
#define RENESAS_PSFTS22                                 PORT0_PSFTS22
#define RENESAS_PSFTSE22                                PORT0_PSFTSE22
#define RENESAS_P24                                     PORT0_P24
#define RENESAS_PSR24                                   PORT0_PSR24
#define RENESAS_PNOT24                                  PORT0_PNOT24
#define RENESAS_PPR24                                   PORT0_PPR24
#define RENESAS_PM24                                    PORT0_PM24
#define RENESAS_PMC24                                   PORT0_PMC24
#define RENESAS_PFC24                                   PORT0_PFC24
#define RENESAS_PFCE24                                  PORT0_PFCE24
#define RENESAS_PMSR24                                  PORT0_PMSR24
#define RENESAS_PMCSR24                                 PORT0_PMCSR24
#define RENESAS_PFCAE24                                 PORT0_PFCAE24
#define RENESAS_PINV24                                  PORT0_PINV24
#define RENESAS_PSFC24                                  PORT0_PSFC24
#define RENESAS_PSFTS24                                 PORT0_PSFTS24
#define RENESAS_PSFTSE24                                PORT0_PSFTSE24

#define RENESAS_PCR00_0                                 PORT0_PCR0_0
#define RENESAS_PCR00_1                                 PORT0_PCR0_1
#define RENESAS_PCR00_2                                 PORT0_PCR0_2
#define RENESAS_PCR00_3                                 PORT0_PCR0_3
#define RENESAS_PCR00_4                                 PORT0_PCR0_4
#define RENESAS_PCR00_5                                 PORT0_PCR0_5
#define RENESAS_PCR00_6                                 PORT0_PCR0_6
#define RENESAS_PCR00_7                                 PORT0_PCR0_7
#define RENESAS_PCR00_8                                 PORT0_PCR0_8
#define RENESAS_PCR00_9                                 PORT0_PCR0_9
#define RENESAS_PCR00_10                                PORT0_PCR0_10
#define RENESAS_PCR00_11                                PORT0_PCR0_11
#define RENESAS_PCR00_12                                PORT0_PCR0_12
#define RENESAS_PCR02_0                                 PORT0_PCR2_0
#define RENESAS_PCR02_1                                 PORT0_PCR2_1
#define RENESAS_PCR02_2                                 PORT0_PCR2_2
#define RENESAS_PCR02_3                                 PORT0_PCR2_3
#define RENESAS_PCR02_4                                 PORT0_PCR2_4
#define RENESAS_PCR02_5                                 PORT0_PCR2_5
#define RENESAS_PCR02_6                                 PORT0_PCR2_6
#define RENESAS_PCR02_7                                 PORT0_PCR2_7
#define RENESAS_PCR02_8                                 PORT0_PCR2_8
#define RENESAS_PCR02_9                                 PORT0_PCR2_9
#define RENESAS_PCR02_10                                PORT0_PCR2_10
#define RENESAS_PCR02_11                                PORT0_PCR2_11
#define RENESAS_PCR02_12                                PORT0_PCR2_12
#define RENESAS_PCR02_13                                PORT0_PCR2_13
#define RENESAS_PCR02_14                                PORT0_PCR2_14
#define RENESAS_PCR02_15                                PORT0_PCR2_15
#define RENESAS_PCR03_0                                 PORT0_PCR3_0
#define RENESAS_PCR03_1                                 PORT0_PCR3_1
#define RENESAS_PCR03_2                                 PORT0_PCR3_2
#define RENESAS_PCR03_3                                 PORT0_PCR3_3
#define RENESAS_PCR03_4                                 PORT0_PCR3_4
#define RENESAS_PCR03_5                                 PORT0_PCR3_5
#define RENESAS_PCR03_6                                 PORT0_PCR3_6
#define RENESAS_PCR03_7                                 PORT0_PCR3_7
#define RENESAS_PCR03_8                                 PORT0_PCR3_8
#define RENESAS_PCR04_0                                 PORT0_PCR4_0
#define RENESAS_PCR04_1                                 PORT0_PCR4_1
#define RENESAS_PCR04_4                                 PORT0_PCR4_4
#define RENESAS_PCR04_5                                 PORT0_PCR4_5
#define RENESAS_PCR04_6                                 PORT0_PCR4_6
#define RENESAS_PCR04_7                                 PORT0_PCR4_7
#define RENESAS_PCR04_8                                 PORT0_PCR4_8
#define RENESAS_PCR04_9                                 PORT0_PCR4_9
#define RENESAS_PCR04_10                                PORT0_PCR4_10
#define RENESAS_PCR04_11                                PORT0_PCR4_11
#define RENESAS_PCR04_12                                PORT0_PCR4_12
#define RENESAS_PCR04_13                                PORT0_PCR4_13
#define RENESAS_PCR04_14                                PORT0_PCR4_14
#define RENESAS_PCR04_15                                PORT0_PCR4_15
#define RENESAS_PCR05_2                                 PORT0_PCR5_2
#define RENESAS_PCR05_3                                 PORT0_PCR5_3
#define RENESAS_PCR05_4                                 PORT0_PCR5_4
#define RENESAS_PCR05_6                                 PORT0_PCR5_6
#define RENESAS_PCR06_0                                 PORT0_PCR6_0
#define RENESAS_PCR06_2                                 PORT0_PCR6_2
#define RENESAS_PCR06_3                                 PORT0_PCR6_3
#define RENESAS_PCR06_4                                 PORT0_PCR6_4
#define RENESAS_PCR06_5                                 PORT0_PCR6_5
#define RENESAS_PCR06_6                                 PORT0_PCR6_6
#define RENESAS_PCR06_7                                 PORT0_PCR6_7
#define RENESAS_PCR06_8                                 PORT0_PCR6_8
#define RENESAS_PCR06_9                                 PORT0_PCR6_9
#define RENESAS_PCR06_10                                PORT0_PCR6_10
#define RENESAS_PCR06_11                                PORT0_PCR6_11
#define RENESAS_PCR06_12                                PORT0_PCR6_12
#define RENESAS_PCR06_13                                PORT0_PCR6_13
#define RENESAS_PCR06_14                                PORT0_PCR6_14
#define RENESAS_PCR06_15                                PORT0_PCR6_15
#define RENESAS_PCR08_0                                 PORT0_PCR8_0
#define RENESAS_PCR08_1                                 PORT0_PCR8_1
#define RENESAS_PCR08_2                                 PORT0_PCR8_2
#define RENESAS_PCR08_3                                 PORT0_PCR8_3
#define RENESAS_PCR08_4                                 PORT0_PCR8_4
#define RENESAS_PCR08_5                                 PORT0_PCR8_5
#define RENESAS_PCR08_6                                 PORT0_PCR8_6
#define RENESAS_PCR08_7                                 PORT0_PCR8_7
#define RENESAS_PCR08_8                                 PORT0_PCR8_8
#define RENESAS_PCR08_9                                 PORT0_PCR8_9
#define RENESAS_PCR10_0                                 PORT0_PCR10_0
#define RENESAS_PCR10_1                                 PORT0_PCR10_1
#define RENESAS_PCR10_2                                 PORT0_PCR10_2
#define RENESAS_PCR10_3                                 PORT0_PCR10_3
#define RENESAS_PCR10_4                                 PORT0_PCR10_4
#define RENESAS_PCR10_5                                 PORT0_PCR10_5
#define RENESAS_PCR10_6                                 PORT0_PCR10_6
#define RENESAS_PCR10_7                                 PORT0_PCR10_7
#define RENESAS_PCR10_8                                 PORT0_PCR10_8
#define RENESAS_PCR10_9                                 PORT0_PCR10_9
#define RENESAS_PCR10_10                                PORT0_PCR10_10
#define RENESAS_PCR10_11                                PORT0_PCR10_11
#define RENESAS_PCR10_12                                PORT0_PCR10_12
#define RENESAS_PCR10_13                                PORT0_PCR10_13
#define RENESAS_PCR10_14                                PORT0_PCR10_14
#define RENESAS_PCR11_0                                 PORT0_PCR11_0
#define RENESAS_PCR11_1                                 PORT0_PCR11_1
#define RENESAS_PCR11_2                                 PORT0_PCR11_2
#define RENESAS_PCR11_3                                 PORT0_PCR11_3
#define RENESAS_PCR11_4                                 PORT0_PCR11_4
#define RENESAS_PCR11_5                                 PORT0_PCR11_5
#define RENESAS_PCR11_6                                 PORT0_PCR11_6
#define RENESAS_PCR11_7                                 PORT0_PCR11_7
#define RENESAS_PCR11_8                                 PORT0_PCR11_8
#define RENESAS_PCR11_9                                 PORT0_PCR11_9
#define RENESAS_PCR11_10                                PORT0_PCR11_10
#define RENESAS_PCR11_11                                PORT0_PCR11_11
#define RENESAS_PCR11_12                                PORT0_PCR11_12
#define RENESAS_PCR11_13                                PORT0_PCR11_13
#define RENESAS_PCR11_14                                PORT0_PCR11_14
#define RENESAS_PCR11_15                                PORT0_PCR11_15
#define RENESAS_PCR17_0                                 PORT0_PCR17_0
#define RENESAS_PCR17_1                                 PORT0_PCR17_1
#define RENESAS_PCR17_2                                 PORT0_PCR17_2
#define RENESAS_PCR17_3                                 PORT0_PCR17_3
#define RENESAS_PCR17_4                                 PORT0_PCR17_4
#define RENESAS_PCR17_5                                 PORT0_PCR17_5
#define RENESAS_PCR17_6                                 PORT0_PCR17_6
#define RENESAS_PCR20_0                                 PORT0_PCR20_0
#define RENESAS_PCR20_1                                 PORT0_PCR20_1
#define RENESAS_PCR20_2                                 PORT0_PCR20_2
#define RENESAS_PCR20_3                                 PORT0_PCR20_3
#define RENESAS_PCR20_4                                 PORT0_PCR20_4
#define RENESAS_PCR20_5                                 PORT0_PCR20_5
#define RENESAS_PCR20_6                                 PORT0_PCR20_6
#define RENESAS_PCR20_7                                 PORT0_PCR20_7
#define RENESAS_PCR20_8                                 PORT0_PCR20_8
#define RENESAS_PCR20_9                                 PORT0_PCR20_9
#define RENESAS_PCR20_10                                PORT0_PCR20_10
#define RENESAS_PCR20_11                                PORT0_PCR20_11
#define RENESAS_PCR20_12                                PORT0_PCR20_12
#define RENESAS_PCR20_13                                PORT0_PCR20_13
#define RENESAS_PCR20_14                                PORT0_PCR20_14
#define RENESAS_PCR21_0                                 PORT0_PCR21_0
#define RENESAS_PCR21_1                                 PORT0_PCR21_1
#define RENESAS_PCR21_2                                 PORT0_PCR21_2
#define RENESAS_PCR21_3                                 PORT0_PCR21_3
#define RENESAS_PCR21_4                                 PORT0_PCR21_4
#define RENESAS_PCR21_5                                 PORT0_PCR21_5
#define RENESAS_PCR21_6                                 PORT0_PCR21_6
#define RENESAS_PCR21_7                                 PORT0_PCR21_7
#define RENESAS_PCR22_0                                 PORT0_PCR22_0
#define RENESAS_PCR22_1                                 PORT0_PCR22_1
#define RENESAS_PCR22_2                                 PORT0_PCR22_2
#define RENESAS_PCR22_3                                 PORT0_PCR22_3
#define RENESAS_PCR22_4                                 PORT0_PCR22_4
#define RENESAS_PCR24_4                                 PORT0_PCR24_4
#define RENESAS_PCR24_5                                 PORT0_PCR24_5
#define RENESAS_PCR24_6                                 PORT0_PCR24_6
#define RENESAS_PCR24_7                                 PORT0_PCR24_7
#define RENESAS_PCR24_8                                 PORT0_PCR24_8
#define RENESAS_PCR24_9                                 PORT0_PCR24_9
#define RENESAS_PCR24_10                                PORT0_PCR24_10
#define RENESAS_PCR24_11                                PORT0_PCR24_11
#define RENESAS_PCR24_12                                PORT0_PCR24_12
#define RENESAS_PCR24_13                                PORT0_PCR24_13
#define RENESAS_PKCPROT                                 PORT0_PKCPROT
#define RENESAS_PWE                                     PORT0_PWE
#define RENESAS_JP0                                     JPORT0_JP0
#define RENESAS_JPSR0                                   JPORT0_JPSR0
#define RENESAS_JPNOT0                                  JPORT0_JPNOT0
#define RENESAS_JPPR0                                   JPORT0_JPPR0
#define RENESAS_JPM0                                    JPORT0_JPM0
#define RENESAS_JPMC0                                   JPORT0_JPMC0
#define RENESAS_JPMSR0                                  JPORT0_JPMSR0
#define RENESAS_JPMCSR0                                 JPORT0_JPMCSR0
#define RENESAS_JPINV0                                  JPORT0_JPINV0
#define RENESAS_JPCR0_0                                 JPORT0_JPCR0_0
#define RENESAS_JPCR0_1                                 JPORT0_JPCR0_1
#define RENESAS_JPCR0_2                                 JPORT0_JPCR0_2
#define RENESAS_JPCR0_3                                 JPORT0_JPCR0_3
#define RENESAS_JPCR0_5                                 JPORT0_JPCR0_5
#define RENESAS_PIBC0                                   PORT0_PIBC0
#define RENESAS_PBDC0                                   PORT0_PBDC0
#define RENESAS_PIPC0                                   PORT0_PIPC0
#define RENESAS_PU0                                     PORT0_PU0
#define RENESAS_PD0                                     PORT0_PD0
#define RENESAS_PODC0                                   PORT0_PODC0
#define RENESAS_PDSC0                                   PORT0_PDSC0
#define RENESAS_PIS0                                    PORT0_PIS0
#define RENESAS_PISA0                                   PORT0_PISA0
#define RENESAS_PUCC0                                   PORT0_PUCC0
#define RENESAS_PODCE0                                  PORT0_PODCE0
#define RENESAS_PIBC2                                   PORT0_PIBC2
#define RENESAS_PBDC2                                   PORT0_PBDC2
#define RENESAS_PIPC2                                   PORT0_PIPC2
#define RENESAS_PU2                                     PORT0_PU2
#define RENESAS_PD2                                     PORT0_PD2
#define RENESAS_PODC2                                   PORT0_PODC2
#define RENESAS_PDSC2                                   PORT0_PDSC2
#define RENESAS_PIS2                                    PORT0_PIS2
#define RENESAS_PISA2                                   PORT0_PISA2
#define RENESAS_PUCC2                                   PORT0_PUCC2
#define RENESAS_PODCE2                                  PORT0_PODCE2
#define RENESAS_PIBC10                                  PORT0_PIBC10
#define RENESAS_PBDC10                                  PORT0_PBDC10
#define RENESAS_PIPC10                                  PORT0_PIPC10
#define RENESAS_PU10                                    PORT0_PU10
#define RENESAS_PD10                                    PORT0_PD10
#define RENESAS_PODC10                                  PORT0_PODC10
#define RENESAS_PDSC10                                  PORT0_PDSC10
#define RENESAS_PIS10                                   PORT0_PIS10
#define RENESAS_PISA10                                  PORT0_PISA10
#define RENESAS_PUCC10                                  PORT0_PUCC10
#define RENESAS_PODCE10                                 PORT0_PODCE10
#define RENESAS_PIBC11                                  PORT0_PIBC11
#define RENESAS_PBDC11                                  PORT0_PBDC11
#define RENESAS_PIPC11                                  PORT0_PIPC11
#define RENESAS_PU11                                    PORT0_PU11
#define RENESAS_PD11                                    PORT0_PD11
#define RENESAS_PODC11                                  PORT0_PODC11
#define RENESAS_PDSC11                                  PORT0_PDSC11
#define RENESAS_PIS11                                   PORT0_PIS11
#define RENESAS_PISA11                                  PORT0_PISA11
#define RENESAS_PUCC11                                  PORT0_PUCC11
#define RENESAS_PODCE11                                 PORT0_PODCE11
#define RENESAS_PIBC20                                  PORT0_PIBC20
#define RENESAS_PBDC20                                  PORT0_PBDC20
#define RENESAS_PIPC20                                  PORT0_PIPC20
#define RENESAS_PU20                                    PORT0_PU20
#define RENESAS_PD20                                    PORT0_PD20
#define RENESAS_PODC20                                  PORT0_PODC20
#define RENESAS_PDSC20                                  PORT0_PDSC20
#define RENESAS_PIS20                                   PORT0_PIS20
#define RENESAS_PISA20                                  PORT0_PISA20
#define RENESAS_PUCC20                                  PORT0_PUCC20
#define RENESAS_PODCE20                                 PORT0_PODCE20
#define RENESAS_PIBC21                                  PORT0_PIBC21
#define RENESAS_PBDC21                                  PORT0_PBDC21
#define RENESAS_PIPC21                                  PORT0_PIPC21
#define RENESAS_PU21                                    PORT0_PU21
#define RENESAS_PD21                                    PORT0_PD21
#define RENESAS_PODC21                                  PORT0_PODC21
#define RENESAS_PDSC21                                  PORT0_PDSC21
#define RENESAS_PIS21                                   PORT0_PIS21
#define RENESAS_PISA21                                  PORT0_PISA21
#define RENESAS_PUCC21                                  PORT0_PUCC21
#define RENESAS_PODCE21                                 PORT0_PODCE21
#define RENESAS_PIBC22                                  PORT0_PIBC22
#define RENESAS_PBDC22                                  PORT0_PBDC22
#define RENESAS_PIPC22                                  PORT0_PIPC22
#define RENESAS_PU22                                    PORT0_PU22
#define RENESAS_PD22                                    PORT0_PD22
#define RENESAS_PODC22                                  PORT0_PODC22
#define RENESAS_PDSC22                                  PORT0_PDSC22
#define RENESAS_PIS22                                   PORT0_PIS22
#define RENESAS_PISA22                                  PORT0_PISA22
#define RENESAS_PUCC22                                  PORT0_PUCC22
#define RENESAS_PODCE22                                 PORT0_PODCE22
#define RENESAS_PIBC24                                  PORT0_PIBC24
#define RENESAS_PBDC24                                  PORT0_PBDC24
#define RENESAS_PIPC24                                  PORT0_PIPC24
#define RENESAS_PU24                                    PORT0_PU24
#define RENESAS_PD24                                    PORT0_PD24
#define RENESAS_PODC24                                  PORT0_PODC24
#define RENESAS_PDSC24                                  PORT0_PDSC24
#define RENESAS_PIS24                                   PORT0_PIS24
#define RENESAS_PUCC24                                  PORT0_PUCC24
#define RENESAS_PODCE24                                 PORT0_PODCE24

#define RENESAS_JPIBC0                                  JPORT0_JPIBC0
#define RENESAS_JPBDC0                                  JPORT0_JPBDC0
#define RENESAS_JPU0                                    JPORT0_JPU0
#define RENESAS_JPD0                                    JPORT0_JPD0
#define RENESAS_JPODC0                                  JPORT0_JPODC0
#define RENESAS_JPDSC0                                  JPORT0_JPDSC0
#define RENESAS_JPIS0                                   JPORT0_JPIS0
#define RENESAS_JPISA0                                  JPORT0_JPISA0
#define RENESAS_JPUCC0                                  JPORT0_JPUCC0
#define RENESAS_JPODCE0                                 JPORT0_JPODCE0

/* U2A add start */
#define RENESAS_P3                                      PORT0_P3
#define RENESAS_PSR3                                    PORT0_PSR3
#define RENESAS_PNOT3                                   PORT0_PNOT3
#define RENESAS_PPR3                                    PORT0_PPR3
#define RENESAS_PM3                                     PORT0_PM3
#define RENESAS_PMC3                                    PORT0_PMC3
#define RENESAS_PFC3                                    PORT0_PFC3
#define RENESAS_PFCE3                                   PORT0_PFCE3
#define RENESAS_PMSR3                                   PORT0_PMSR3
#define RENESAS_PMCSR3                                  PORT0_PMCSR3
#define RENESAS_PFCAE3                                  PORT0_PFCAE3
#define RENESAS_PINV3                                   PORT0_PINV3
#define RENESAS_PSFC3                                   PORT0_PSFC3
#define RENESAS_PSFTS3                                  PORT0_PSFTS3
#define RENESAS_PSFTSE3                                 PORT0_PSFTSE3
#define RENESAS_P4                                      PORT0_P4
#define RENESAS_PSR4                                    PORT0_PSR4
#define RENESAS_PNOT4                                   PORT0_PNOT4
#define RENESAS_PPR4                                    PORT0_PPR4
#define RENESAS_PM4                                     PORT0_PM4
#define RENESAS_PMC4                                    PORT0_PMC4
#define RENESAS_PFC4                                    PORT0_PFC4
#define RENESAS_PFCE4                                   PORT0_PFCE4
#define RENESAS_PMSR4                                   PORT0_PMSR4
#define RENESAS_PMCSR4                                  PORT0_PMCSR4
#define RENESAS_PFCAE4                                  PORT0_PFCAE4
#define RENESAS_PINV4                                   PORT0_PINV4
#define RENESAS_PSFC4                                   PORT0_PSFC4
#define RENESAS_PSFTS4                                  PORT0_PSFTS4
#define RENESAS_PSFTSE4                                 PORT0_PSFTSE4
#define RENESAS_P5                                      PORT0_P5
#define RENESAS_PSR5                                    PORT0_PSR5
#define RENESAS_PNOT5                                   PORT0_PNOT5
#define RENESAS_PPR5                                    PORT0_PPR5
#define RENESAS_PM5                                     PORT0_PM5
#define RENESAS_PMC5                                    PORT0_PMC5
#define RENESAS_PFC5                                    PORT0_PFC5
#define RENESAS_PFCE5                                   PORT0_PFCE5
#define RENESAS_PMSR5                                   PORT0_PMSR5
#define RENESAS_PMCSR5                                  PORT0_PMCSR5
#define RENESAS_PFCAE5                                  PORT0_PFCAE5
#define RENESAS_PINV5                                   PORT0_PINV5
#define RENESAS_PSFC5                                   PORT0_PSFC5
#define RENESAS_PSFTS5                                  PORT0_PSFTS5
#define RENESAS_PSFTSE5                                 PORT0_PSFTSE5
#define RENESAS_P6                                      PORT0_P6
#define RENESAS_PSR6                                    PORT0_PSR6
#define RENESAS_PNOT6                                   PORT0_PNOT6
#define RENESAS_PPR6                                    PORT0_PPR6
#define RENESAS_PM6                                     PORT0_PM6
#define RENESAS_PMC6                                    PORT0_PMC6
#define RENESAS_PFC6                                    PORT0_PFC6
#define RENESAS_PFCE6                                   PORT0_PFCE6
#define RENESAS_PMSR6                                   PORT0_PMSR6
#define RENESAS_PMCSR6                                  PORT0_PMCSR6
#define RENESAS_PFCAE6                                  PORT0_PFCAE6
#define RENESAS_PINV6                                   PORT0_PINV6
#define RENESAS_PSFC6                                   PORT0_PSFC6
#define RENESAS_PSFTS6                                  PORT0_PSFTS6
#define RENESAS_PSFTSE6                                 PORT0_PSFTSE6
#define RENESAS_P8                                      PORT0_P8
#define RENESAS_PSR8                                    PORT0_PSR8
#define RENESAS_PNOT8                                   PORT0_PNOT8
#define RENESAS_PPR8                                    PORT0_PPR8
#define RENESAS_PM8                                     PORT0_PM8
#define RENESAS_PMC8                                    PORT0_PMC8
#define RENESAS_PFC8                                    PORT0_PFC8
#define RENESAS_PFCE8                                   PORT0_PFCE8
#define RENESAS_PMSR8                                   PORT0_PMSR8
#define RENESAS_PMCSR8                                  PORT0_PMCSR8
#define RENESAS_PFCAE8                                  PORT0_PFCAE8
#define RENESAS_PINV8                                   PORT0_PINV8
#define RENESAS_PSFC8                                   PORT0_PSFC8
#define RENESAS_PSFTS8                                  PORT0_PSFTS8
#define RENESAS_PSFTSE8                                 PORT0_PSFTSE8
#define RENESAS_P17                                     PORT0_P17
#define RENESAS_PSR17                                   PORT0_PSR17
#define RENESAS_PNOT17                                  PORT0_PNOT17
#define RENESAS_PPR17                                   PORT0_PPR17
#define RENESAS_PM17                                    PORT0_PM17
#define RENESAS_PMC17                                   PORT0_PMC17
#define RENESAS_PFC17                                   PORT0_PFC17
#define RENESAS_PFCE17                                  PORT0_PFCE17
#define RENESAS_PMSR17                                  PORT0_PMSR17
#define RENESAS_PMCSR17                                 PORT0_PMCSR17
#define RENESAS_PFCAE17                                 PORT0_PFCAE17
#define RENESAS_PINV17                                  PORT0_PINV17
#define RENESAS_PSFC17                                  PORT0_PSFC17
#define RENESAS_PSFTS17                                 PORT0_PSFTS17
#define RENESAS_PSFTSE17                                PORT0_PSFTSE17

#define RENESAS_PIBC3                                   PORT0_PIBC3
#define RENESAS_PBDC3                                   PORT0_PBDC3
#define RENESAS_PIPC3                                   PORT0_PIPC3
#define RENESAS_PU3                                     PORT0_PU3
#define RENESAS_PD3                                     PORT0_PD3
#define RENESAS_PODC3                                   PORT0_PODC3
#define RENESAS_PDSC3                                   PORT0_PDSC3
#define RENESAS_PIS3                                    PORT0_PIS3
#define RENESAS_PISA3                                   PORT0_PISA3
#define RENESAS_PUCC3                                   PORT0_PUCC3
#define RENESAS_PODCE3                                  PORT0_PODCE3
#define RENESAS_PIBC4                                   PORT0_PIBC4
#define RENESAS_PBDC4                                   PORT0_PBDC4
#define RENESAS_PIPC4                                   PORT0_PIPC4
#define RENESAS_PU4                                     PORT0_PU4
#define RENESAS_PD4                                     PORT0_PD4
#define RENESAS_PODC4                                   PORT0_PODC4
#define RENESAS_PDSC4                                   PORT0_PDSC4
#define RENESAS_PIS4                                    PORT0_PIS4
#define RENESAS_PISA4                                   PORT0_PISA4
#define RENESAS_PUCC4                                   PORT0_PUCC4
#define RENESAS_PODCE4                                  PORT0_PODCE4
#define RENESAS_PIBC5                                   PORT0_PIBC5
#define RENESAS_PBDC5                                   PORT0_PBDC5
#define RENESAS_PIPC5                                   PORT0_PIPC5
#define RENESAS_PU5                                     PORT0_PU5
#define RENESAS_PD5                                     PORT0_PD5
#define RENESAS_PODC5                                   PORT0_PODC5
#define RENESAS_PDSC5                                   PORT0_PDSC5
#define RENESAS_PIS5                                    PORT0_PIS5
#define RENESAS_PISA5                                   PORT0_PISA5
#define RENESAS_PUCC5                                   PORT0_PUCC5
#define RENESAS_PODCE5                                  PORT0_PODCE5
#define RENESAS_PIBC6                                   PORT0_PIBC6
#define RENESAS_PBDC6                                   PORT0_PBDC6
#define RENESAS_PIPC6                                   PORT0_PIPC6
#define RENESAS_PU6                                     PORT0_PU6
#define RENESAS_PD6                                     PORT0_PD6
#define RENESAS_PODC6                                   PORT0_PODC6
#define RENESAS_PDSC6                                   PORT0_PDSC6
#define RENESAS_PIS6                                    PORT0_PIS6
#define RENESAS_PISA6                                   PORT0_PISA6
#define RENESAS_PUCC6                                   PORT0_PUCC6
#define RENESAS_PODCE6                                  PORT0_PODCE6
#define RENESAS_PIBC8                                   PORT0_PIBC8
#define RENESAS_PBDC8                                   PORT0_PBDC8
#define RENESAS_PU8                                     PORT0_PU8
#define RENESAS_PD8                                     PORT0_PD8
#define RENESAS_PODC8                                   PORT0_PODC8
#define RENESAS_PDSC8                                   PORT0_PDSC8
#define RENESAS_PIS8                                    PORT0_PIS8
#define RENESAS_PISA8                                   PORT0_PISA8
#define RENESAS_PUCC8                                   PORT0_PUCC8
#define RENESAS_PODCE8                                  PORT0_PODCE8
#define RENESAS_PIBC17                                  PORT0_PIBC17
#define RENESAS_PBDC17                                  PORT0_PBDC17
#define RENESAS_PIPC17                                  PORT0_PIPC17
#define RENESAS_PU17                                    PORT0_PU17
#define RENESAS_PD17                                    PORT0_PD17
#define RENESAS_PODC17                                  PORT0_PODC17
#define RENESAS_PDSC17                                  PORT0_PDSC17
#define RENESAS_PIS17                                   PORT0_PIS17
#define RENESAS_PUCC17                                  PORT0_PUCC17
#define RENESAS_PODCE17                                 PORT0_PODCE17

#define RENESAS_APCR00_0                                PORT0_APCR0_0
#define RENESAS_APCR00_1                                PORT0_APCR0_1
#define RENESAS_APCR00_2                                PORT0_APCR0_2
#define RENESAS_APCR00_3                                PORT0_APCR0_3
#define RENESAS_APCR00_4                                PORT0_APCR0_4
#define RENESAS_APCR00_5                                PORT0_APCR0_5
#define RENESAS_APCR00_6                                PORT0_APCR0_6
#define RENESAS_APCR00_7                                PORT0_APCR0_7
#define RENESAS_APCR00_8                                PORT0_APCR0_8
#define RENESAS_APCR00_9                                PORT0_APCR0_9
#define RENESAS_APCR00_10                               PORT0_APCR0_10
#define RENESAS_APCR00_11                               PORT0_APCR0_11
#define RENESAS_APCR00_12                               PORT0_APCR0_12
#define RENESAS_APCR00_13                               PORT0_APCR0_13
#define RENESAS_APCR00_14                               PORT0_APCR0_14
#define RENESAS_APCR00_15                               PORT0_APCR0_15
#define RENESAS_APCR01_0                                PORT0_APCR1_0
#define RENESAS_APCR01_1                                PORT0_APCR1_1
#define RENESAS_APCR01_2                                PORT0_APCR1_2
#define RENESAS_APCR01_3                                PORT0_APCR1_3
#define RENESAS_APCR02_0                                PORT0_APCR2_0
#define RENESAS_APCR02_1                                PORT0_APCR2_1
#define RENESAS_APCR02_2                                PORT0_APCR2_2
#define RENESAS_APCR02_3                                PORT0_APCR2_3
#define RENESAS_APCR02_4                                PORT0_APCR2_4
#define RENESAS_APCR02_5                                PORT0_APCR2_5
#define RENESAS_APCR02_6                                PORT0_APCR2_6
#define RENESAS_APCR02_7                                PORT0_APCR2_7
#define RENESAS_APCR02_8                                PORT0_APCR2_8
#define RENESAS_APCR02_9                                PORT0_APCR2_9
#define RENESAS_APCR02_10                               PORT0_APCR2_10
#define RENESAS_APCR02_11                               PORT0_APCR2_11
#define RENESAS_APCR02_12                               PORT0_APCR2_12
#define RENESAS_APCR02_13                               PORT0_APCR2_13
#define RENESAS_APCR02_14                               PORT0_APCR2_14
#define RENESAS_APCR02_15                               PORT0_APCR2_15
#define RENESAS_APCR03_0                                PORT0_APCR3_0
#define RENESAS_APCR03_1                                PORT0_APCR3_1
#define RENESAS_APCR03_2                                PORT0_APCR3_2
#define RENESAS_APCR03_3                                PORT0_APCR3_3
#define RENESAS_APCR04_0                                PORT0_APCR4_0
#define RENESAS_APCR04_1                                PORT0_APCR4_1
#define RENESAS_APCR04_2                                PORT0_APCR4_2
#define RENESAS_APCR04_3                                PORT0_APCR4_3
#define RENESAS_APCR04_4                                PORT0_APCR4_4
#define RENESAS_APCR04_5                                PORT0_APCR4_5
#define RENESAS_APCR04_6                                PORT0_APCR4_6
#define RENESAS_APCR04_7                                PORT0_APCR4_7
#define RENESAS_APCR04_8                                PORT0_APCR4_8
#define RENESAS_APCR04_9                                PORT0_APCR4_9
#define RENESAS_APCR04_10                               PORT0_APCR4_10
#define RENESAS_APCR04_11                               PORT0_APCR4_11
#define RENESAS_APCR04_12                               PORT0_APCR4_12
#define RENESAS_APCR04_13                               PORT0_APCR4_13
#define RENESAS_APCR04_14                               PORT0_APCR4_14
#define RENESAS_APCR04_15                               PORT0_APCR4_15
#define RENESAS_APCR05_0                                PORT0_APCR5_0
#define RENESAS_APCR05_1                                PORT0_APCR5_1
#define RENESAS_APCR05_2                                PORT0_APCR5_2
#define RENESAS_APCR05_3                                PORT0_APCR5_3

#define RENESAS_AP0                                     PORT0_AP0
#define RENESAS_APSR0                                   PORT0_APSR0
#define RENESAS_APINV0                                  PORT0_APINV0
#define RENESAS_APMSR0                                  PORT0_APMSR0
#define RENESAS_AP1                                     PORT0_AP1
#define RENESAS_APSR1                                   PORT0_APSR1
#define RENESAS_APINV1                                  PORT0_APINV1
#define RENESAS_APMSR1                                  PORT0_APMSR1
#define RENESAS_AP2                                     PORT0_AP2
#define RENESAS_APSR2                                   PORT0_APSR2
#define RENESAS_APINV2                                  PORT0_APINV2
#define RENESAS_APMSR2                                  PORT0_APMSR2
#define RENESAS_AP3                                     PORT0_AP3
#define RENESAS_APSR3                                   PORT0_APSR3
#define RENESAS_APINV3                                  PORT0_APINV3
#define RENESAS_APMSR3                                  PORT0_APMSR3
#define RENESAS_AP4                                     PORT0_AP4
#define RENESAS_APSR4                                   PORT0_APSR4
#define RENESAS_APINV4                                  PORT0_APINV4
#define RENESAS_APMSR4                                  PORT0_APMSR4
#define RENESAS_AP5                                     PORT0_AP5
#define RENESAS_APSR5                                   PORT0_APSR5
#define RENESAS_APINV5                                  PORT0_APINV5
#define RENESAS_APMSR5                                  PORT0_APMSR5

#define RENESAS_APPR0                                   PORT0_APPR0
#define RENESAS_APNOT0                                  PORT0_APNOT0
#define RENESAS_APM0                                    PORT0_APM0
#define RENESAS_APSFC0                                  PORT0_APSFC0
#define RENESAS_APSFTS0                                 PORT0_APSFTS0
#define RENESAS_APSFTSE0                                PORT0_APSFTSE0
#define RENESAS_APPR1                                   PORT0_APPR1
#define RENESAS_APNOT1                                  PORT0_APNOT1
#define RENESAS_APM1                                    PORT0_APM1
#define RENESAS_APSFC1                                  PORT0_APSFC1
#define RENESAS_APSFTS1                                 PORT0_APSFTS1
#define RENESAS_APSFTSE1                                PORT0_APSFTSE1
#define RENESAS_APPR2                                   PORT0_APPR2
#define RENESAS_APNOT2                                  PORT0_APNOT2
#define RENESAS_APM2                                    PORT0_APM2
#define RENESAS_APSFC2                                  PORT0_APSFC2
#define RENESAS_APSFTS2                                 PORT0_APSFTS2
#define RENESAS_APSFTSE2                                PORT0_APSFTSE2
#define RENESAS_APPR3                                   PORT0_APPR3
#define RENESAS_APNOT3                                  PORT0_APNOT3
#define RENESAS_APM3                                    PORT0_APM3
#define RENESAS_APSFC3                                  PORT0_APSFC3
#define RENESAS_APSFTS3                                 PORT0_APSFTS3
#define RENESAS_APSFTSE3                                PORT0_APSFTSE3
#define RENESAS_APPR4                                   PORT0_APPR4
#define RENESAS_APNOT4                                  PORT0_APNOT4
#define RENESAS_APM4                                    PORT0_APM4
#define RENESAS_APSFC4                                  PORT0_APSFC4
#define RENESAS_APSFTS4                                 PORT0_APSFTS4
#define RENESAS_APSFTSE4                                PORT0_APSFTSE4
#define RENESAS_APPR5                                   PORT0_APPR5
#define RENESAS_APNOT5                                  PORT0_APNOT5
#define RENESAS_APM5                                    PORT0_APM5
#define RENESAS_APSFC5                                  PORT0_APSFC5
#define RENESAS_APSFTS5                                 PORT0_APSFTS5
#define RENESAS_APSFTSE5                                PORT0_APSFTSE5

#define RENESAS_APIBC0                                  PORT0_APIBC0
#define RENESAS_APBDC0                                  PORT0_APBDC0
#define RENESAS_APODC0                                  PORT0_APODC0
#define RENESAS_APDSC0                                  PORT0_APDSC0
#define RENESAS_APODCE0                                 PORT0_APODCE0
#define RENESAS_APIBC1                                  PORT0_APIBC1
#define RENESAS_APBDC1                                  PORT0_APBDC1
#define RENESAS_APODC1                                  PORT0_APODC1
#define RENESAS_APDSC1                                  PORT0_APDSC1
#define RENESAS_APODCE1                                 PORT0_APODCE1
#define RENESAS_APIBC2                                  PORT0_APIBC2
#define RENESAS_APBDC2                                  PORT0_APBDC2
#define RENESAS_APODC2                                  PORT0_APODC2
#define RENESAS_APDSC2                                  PORT0_APDSC2
#define RENESAS_APODCE2                                 PORT0_APODCE2
#define RENESAS_APIBC3                                  PORT0_APIBC3
#define RENESAS_APBDC3                                  PORT0_APBDC3
#define RENESAS_APODC3                                  PORT0_APODC3
#define RENESAS_APDSC3                                  PORT0_APDSC3
#define RENESAS_APODCE3                                 PORT0_APODCE3
#define RENESAS_APIBC4                                  PORT0_APIBC4
#define RENESAS_APBDC4                                  PORT0_APBDC4
#define RENESAS_APODC4                                  PORT0_APODC4
#define RENESAS_APDSC4                                  PORT0_APDSC4
#define RENESAS_APODCE4                                 PORT0_APODCE4
#define RENESAS_APIBC5                                  PORT0_APIBC5
#define RENESAS_APBDC5                                  PORT0_APBDC5
#define RENESAS_APODC5                                  PORT0_APODC5
#define RENESAS_APDSC5                                  PORT0_APDSC5
#define RENESAS_APODCE5                                 PORT0_APODCE5

#define RENESAS_JPFC0                                   JPORT0_JPFC0
#define RENESAS_JPFCE0                                  JPORT0_JPFCE0
/* U2A add end */

/* U2A add start */
#define RENESAS_FCLACTL                                 FLCA0_FCLACTL0_RLIN3
#define RENESAS_DNFACTL                                 DNFA0_DNFACTL_RLIN3

#define RENESAS_FCLACTL0_RLIN3                          FLCA0_FCLACTL0_RLIN3
#define RENESAS_FCLACTL1_RLIN3                          FLCA0_FCLACTL1_RLIN3
#define RENESAS_FCLACTL0_PSI5                           FLCA4_FCLACTL0_PSI5
#define RENESAS_FCLACTL1_PSI5                           FLCA4_FCLACTL1_PSI5
#define RENESAS_FCLACTL2_PSI5                           FLCA4_FCLACTL2_PSI5
#define RENESAS_FCLACTL3_PSI5                           FLCA4_FCLACTL3_PSI5
#define RENESAS_FCLACTL0_TAPA                           FLCA5_FCLACTL0_TAPA
#define RENESAS_FCLACTL1_TAPA                           FLCA5_FCLACTL1_TAPA
#define RENESAS_FCLACTL0_RSENT                          FLCA3_FCLACTL0_RSENT
#define RENESAS_FCLACTL1_RSENT                          FLCA3_FCLACTL1_RSENT
#define RENESAS_FCLACTL2_RSENT                          FLCA3_FCLACTL2_RSENT
#define RENESAS_FCLACTL3_RSENT                          FLCA3_FCLACTL3_RSENT
#define RENESAS_FCLACTL4_RSENT                          FLCA3_FCLACTL4_RSENT
#define RENESAS_FCLACTL5_RSENT                          FLCA3_FCLACTL5_RSENT
#define RENESAS_FCLACTL6_RSENT                          FLCA3_FCLACTL6_RSENT
#define RENESAS_FCLACTL7_RSENT                          FLCA3_FCLACTL7_RSENT

#define RENESAS_FCLACTL0_NMI                            FLCA6_FCLACTL0_NMI
#define RENESAS_FCLACTL0_INTP_0                         FLCA7_FCLACTL0_INTP_0
#define RENESAS_FCLACTL1_INTP_0                         FLCA7_FCLACTL1_INTP_0
#define RENESAS_FCLACTL2_INTP_0                         FLCA7_FCLACTL2_INTP_0
#define RENESAS_FCLACTL3_INTP_0                         FLCA7_FCLACTL3_INTP_0
#define RENESAS_FCLACTL4_INTP_0                         FLCA7_FCLACTL4_INTP_0
#define RENESAS_FCLACTL5_INTP_0                         FLCA7_FCLACTL5_INTP_0
#define RENESAS_FCLACTL6_INTP_0                         FLCA7_FCLACTL6_INTP_0
#define RENESAS_FCLACTL7_INTP_0                         FLCA7_FCLACTL7_INTP_0
#define RENESAS_FCLACTL0_INTP_1                         FLCA8_FCLACTL0_INTP_1
#define RENESAS_FCLACTL1_INTP_1                         FLCA8_FCLACTL1_INTP_1
#define RENESAS_FCLACTL2_INTP_1                         FLCA8_FCLACTL2_INTP_1
#define RENESAS_FCLACTL3_INTP_1                         FLCA8_FCLACTL3_INTP_1
#define RENESAS_FCLACTL4_INTP_1                         FLCA8_FCLACTL4_INTP_1
#define RENESAS_FCLACTL5_INTP_1                         FLCA8_FCLACTL5_INTP_1
#define RENESAS_FCLACTL6_INTP_1                         FLCA8_FCLACTL6_INTP_1
#define RENESAS_FCLACTL7_INTP_1                         FLCA8_FCLACTL7_INTP_1
#define RENESAS_FCLACTL0_INTP_2                         FLCA9_FCLACTL0_INTP_2
#define RENESAS_FCLACTL1_INTP_2                         FLCA9_FCLACTL1_INTP_2
#define RENESAS_FCLACTL2_INTP_2                         FLCA9_FCLACTL2_INTP_2
#define RENESAS_FCLACTL3_INTP_2                         FLCA9_FCLACTL3_INTP_2
#define RENESAS_FCLACTL4_INTP_2                         FLCA9_FCLACTL4_INTP_2
#define RENESAS_FCLACTL5_INTP_2                         FLCA9_FCLACTL5_INTP_2
#define RENESAS_FCLACTL6_INTP_2                         FLCA9_FCLACTL6_INTP_2
#define RENESAS_FCLACTL7_INTP_2                         FLCA9_FCLACTL7_INTP_2
#define RENESAS_FCLACTL0_INTP_3                         FLCA10_FCLACTL0_INTP_3
#define RENESAS_FCLACTL1_INTP_3                         FLCA10_FCLACTL1_INTP_3
#define RENESAS_FCLACTL2_INTP_3                         FLCA10_FCLACTL2_INTP_3
#define RENESAS_FCLACTL3_INTP_3                         FLCA10_FCLACTL3_INTP_3
#define RENESAS_FCLACTL4_INTP_3                         FLCA10_FCLACTL4_INTP_3
#define RENESAS_FCLACTL5_INTP_3                         FLCA10_FCLACTL5_INTP_3
#define RENESAS_FCLACTL6_INTP_3                         FLCA10_FCLACTL6_INTP_3
#define RENESAS_FCLACTL7_INTP_3                         FLCA10_FCLACTL7_INTP_3
#define RENESAS_FCLACTL0_INTP_4                         FLCA11_FCLACTL0_INTP_4
#define RENESAS_FCLACTL1_INTP_4                         FLCA11_FCLACTL1_INTP_4
#define RENESAS_FCLACTL2_INTP_4                         FLCA11_FCLACTL2_INTP_4
#define RENESAS_FCLACTL3_INTP_4                         FLCA11_FCLACTL3_INTP_4
#define RENESAS_FCLACTL4_INTP_4                         FLCA11_FCLACTL4_INTP_4
#define RENESAS_FCLACTL5_INTP_4                         FLCA11_FCLACTL5_INTP_4
#define RENESAS_FCLACTL6_INTP_4                         FLCA11_FCLACTL6_INTP_4
#define RENESAS_FCLACTL7_INTP_4                         FLCA11_FCLACTL7_INTP_4

#define RENESAS_FCLACTL0_ADCJ2                          FLCA12_FCLACTL0_ADCJ2
#define RENESAS_FCLACTL1_ADCJ2                          FLCA12_FCLACTL1_ADCJ2
#define RENESAS_FCLACTL2_ADCJ2                          FLCA12_FCLACTL2_ADCJ2
#define RENESAS_FCLACTL3_ADCJ2                          FLCA12_FCLACTL3_ADCJ2
#define RENESAS_FCLACTL4_ADCJ2                          FLCA12_FCLACTL4_ADCJ2

#define RENESAS_FCLACTL0_RSCAN                          FLCA1_FCLACTL0_RSCAN
#define RENESAS_FCLACTL1_RSCAN                          FLCA1_FCLACTL1_RSCAN
#define RENESAS_FCLACTL0_FLXA                           FLCA2_FCLACTL0_FLXA
#define RENESAS_FCLACTL1_FLXA                           FLCA2_FCLACTL1_FLXA
#define RENESAS_DNFACTL_RSCAN                           DNFA1_DNFACTL_RSCAN
#define RENESAS_DNFACTL_FLXA                            DNFA2_DNFACTL_FLXA
#define RENESAS_DNFACTL_ENCA                            DNFA9_DNFACTL_ENCA

#define RENESAS_DNFACTL_ADCJ0                           DNFA6_DNFACTL_ADCJ0
#define RENESAS_DNFACTL_ADCJ2                           DNFA8_DNFACTL_ADCJ2
#define RENESAS_DNFACTL_TAUD0                           DNFA10_DNFACTL_TAUD0
#define RENESAS_DNFACTL_TAUJ3                           DNFA17_DNFACTL_TAUJ3
#define RENESAS_DNFACTL_RLIN3                           DNFA0_DNFACTL_RLIN3
#define RENESAS_DNFACTL_PSI5                            DNFA4_DNFACTL_PSI5
#define RENESAS_DNFACTL_TAPA                            DNFA5_DNFACTL_TAPA
#define RENESAS_DNFACTL_RSENT                           DNFA3_DNFACTL_RSENT
#define RENESAS_DNFACTL_ECM                             DNFA13_DNFACTL_ECM
/* U2A add end */

/*******************************************************************************
**                 Macros for Watchdog Driver                                 **
*******************************************************************************/
#define RENESAS_WDTB0WDTE                               WDTB0_WDTE
#define RENESAS_WDTB0EVAC                               WDTB0_EVAC
#define RENESAS_WDTB0REF                                WDTB0_REF
#define RENESAS_WDTB0MD                                 WDTB0_MD
#define RENESAS_WDTB0WOST                               WDTB0_WOST
#define RENESAS_WDTB0WIS                                WDTB0_WIS

#define RENESAS_WDTB1WDTE                               WDTB1_WDTE
#define RENESAS_WDTB1EVAC                               WDTB1_EVAC
#define RENESAS_WDTB1REF                                WDTB1_REF
#define RENESAS_WDTB1MD                                 WDTB1_MD
#define RENESAS_WDTB1WOST                               WDTB1_WOST
#define RENESAS_WDTB1WIS                                WDTB1_WIS

#define RENESAS_WDTBAWDTE                               WDTBA_WDTE
#define RENESAS_WDTBAEVAC                               WDTBA_EVAC
#define RENESAS_WDTBAREF                                WDTBA_REF
#define RENESAS_WDTBAMD                                 WDTBA_MD
#define RENESAS_WDTBAWOST                               WDTBA_WOST
#define RENESAS_WDTBAWIS                                WDTBA_WIS

#define RENESAS_ICWDTB0_IMR                             22
#define RENESAS_ICWDTB1_IMR                             22
#define RENESAS_ICWDTB2_IMR                             22
#define RENESAS_ICWDTB3_IMR                             22
#define RENESAS_ICWDTBA_IMR                             705

#define RENESAS_ICWDTB0                                 INTC1_PE0_EIC22
#define RENESAS_ICWDTB1                                 INTC1_PE1_EIC22
#define RENESAS_ICWDTB2                                 INTC1_PE2_EIC22
#define RENESAS_ICWDTB3                                 INTC1_PE3_EIC22
#define RENESAS_ICWDTBA                                 INTC2_EIC705

#define RENESAS_FEINTF0                                 FEINC_PE0_FEINTF
#define RENESAS_FEINTMSK0                               FEINC_PE0_FEINTMSK
#define RENESAS_FEINTC0                                 FEINC_PE0_FEINTC
#define RENESAS_FEINTF1                                 FEINC_PE1_FEINTF
#define RENESAS_FEINTMSK1                               FEINC_PE1_FEINTMSK
#define RENESAS_FEINTC1                                 FEINC_PE1_FEINTC
#define RENESAS_FEINTF2                                 FEINC_PE2_FEINTF
#define RENESAS_FEINTMSK2                               FEINC_PE2_FEINTMSK
#define RENESAS_FEINTC2                                 FEINC_PE2_FEINTC
#define RENESAS_FEINTF3                                 FEINC_PE3_FEINTF
#define RENESAS_FEINTMSK3                               FEINC_PE3_FEINTMSK
#define RENESAS_FEINTC3                                 FEINC_PE3_FEINTC

#define RENESAS_ECMPE0FEINTMSK                          2
#define RENESAS_ECMPE1FEINTMSK                          2
#define RENESAS_ECMPE2FEINTMSK                          2
#define RENESAS_ECMPE3FEINTMSK                          2

#define RENESAS_ECMKCPROT_VALUE                         0x01
#define RENESAS_WDG0ECMNMICFG0_VALUE                    0x01

#define RENESAS_IMR0CPU2                                INTC1_PE2_IMR0
#define RENESAS_IMR0CPU3                                INTC1_PE3_IMR0
#define RENESAS_IMR22                                   INTC2_IMR22

#define RENESAS_ECMISCFG7                               ECM_ISCFG7
#define RENESAS_ECMISCFG8                               ECM_ISCFG8
#define RENESAS_ECMISCFG9                               ECM_ISCFG9
#define RENESAS_ECMISCFG10                              ECM_ISCFG10

#define RENESAS_ECMINCFG007                             ECM_INCFG0_7
#define RENESAS_ECMINCFG108                             ECM_INCFG1_4
#define RENESAS_ECMINCFG209                             ECM_INCFG2_1

#define RENESAS_ECMIRCFG10                              ECM_IRCFG10

#define RENESAS_ECMEMK10                                ECM_EMK10

/*******************************************************************************
**                 Macros for DMA Driver                                      **
*******************************************************************************/
#define RENESAS_DMACT0IC0                               INTC2_EIC47
#define RENESAS_DMACT0IC1                               INTC2_EIC48
#define RENESAS_DMACT0IC2                               INTC2_EIC49
#define RENESAS_DMACT0IC3                               INTC2_EIC50
#define RENESAS_DMACT0IC4                               INTC2_EIC51
#define RENESAS_DMACT0IC5                               INTC2_EIC52
#define RENESAS_DMACT0IC6                               INTC2_EIC53
#define RENESAS_DMACT0IC7                               INTC2_EIC54
#define RENESAS_DMACT0IC8                               INTC2_EIC55
#define RENESAS_DMACT0IC9                               INTC2_EIC56
#define RENESAS_DMACT0IC10                              INTC2_EIC57
#define RENESAS_DMACT0IC11                              INTC2_EIC58
#define RENESAS_DMACT0IC12                              INTC2_EIC59
#define RENESAS_DMACT0IC13                              INTC2_EIC60
#define RENESAS_DMACT0IC14                              INTC2_EIC61
#define RENESAS_DMACT0IC15                              INTC2_EIC62

#define RENESAS_DMACT1IC0                               INTC2_EIC63
#define RENESAS_DMACT1IC1                               INTC2_EIC64
#define RENESAS_DMACT1IC2                               INTC2_EIC65
#define RENESAS_DMACT1IC3                               INTC2_EIC66
#define RENESAS_DMACT1IC4                               INTC2_EIC67
#define RENESAS_DMACT1IC5                               INTC2_EIC68
#define RENESAS_DMACT1IC6                               INTC2_EIC69
#define RENESAS_DMACT1IC7                               INTC2_EIC70
#define RENESAS_DMACT1IC8                               INTC2_EIC71
#define RENESAS_DMACT1IC9                               INTC2_EIC72
#define RENESAS_DMACT1IC10                              INTC2_EIC73
#define RENESAS_DMACT1IC11                              INTC2_EIC74
#define RENESAS_DMACT1IC12                              INTC2_EIC75
#define RENESAS_DMACT1IC13                              INTC2_EIC76
#define RENESAS_DMACT1IC14                              INTC2_EIC77
#define RENESAS_DMACT1IC15                              INTC2_EIC78

#define RENESAS_DMACT0IC0_IMR                           47
#define RENESAS_DMACT0IC1_IMR                           48
#define RENESAS_DMACT0IC2_IMR                           49
#define RENESAS_DMACT0IC3_IMR                           50
#define RENESAS_DMACT0IC4_IMR                           51
#define RENESAS_DMACT0IC5_IMR                           52
#define RENESAS_DMACT0IC6_IMR                           53
#define RENESAS_DMACT0IC7_IMR                           54
#define RENESAS_DMACT0IC8_IMR                           55
#define RENESAS_DMACT0IC9_IMR                           56
#define RENESAS_DMACT0IC10_IMR                          57
#define RENESAS_DMACT0IC11_IMR                          58
#define RENESAS_DMACT0IC12_IMR                          59
#define RENESAS_DMACT0IC13_IMR                          60
#define RENESAS_DMACT0IC14_IMR                          61
#define RENESAS_DMACT0IC15_IMR                          62

#define RENESAS_DMACT1IC0_IMR                           63
#define RENESAS_DMACT1IC1_IMR                           64
#define RENESAS_DMACT1IC2_IMR                           65
#define RENESAS_DMACT1IC3_IMR                           66
#define RENESAS_DMACT1IC4_IMR                           67
#define RENESAS_DMACT1IC5_IMR                           68
#define RENESAS_DMACT1IC6_IMR                           69
#define RENESAS_DMACT1IC7_IMR                           70
#define RENESAS_DMACT1IC8_IMR                           71
#define RENESAS_DMACT1IC9_IMR                           72
#define RENESAS_DMACT1IC10_IMR                          73
#define RENESAS_DMACT1IC11_IMR                          74
#define RENESAS_DMACT1IC12_IMR                          75
#define RENESAS_DMACT1IC13_IMR                          76
#define RENESAS_DMACT1IC14_IMR                          77
#define RENESAS_DMACT1IC15_IMR                          78

#define RENESAS_DMA0SAR0                                SDMAC0_DMA0SAR_0
#define RENESAS_DMA0SAR1                                SDMAC0_DMA0SAR_1
#define RENESAS_DMA0SAR2                                SDMAC0_DMA0SAR_2
#define RENESAS_DMA0SAR3                                SDMAC0_DMA0SAR_3
#define RENESAS_DMA0SAR4                                SDMAC0_DMA0SAR_4
#define RENESAS_DMA0SAR5                                SDMAC0_DMA0SAR_5
#define RENESAS_DMA0SAR6                                SDMAC0_DMA0SAR_6
#define RENESAS_DMA0SAR7                                SDMAC0_DMA0SAR_7
#define RENESAS_DMA0SAR8                                SDMAC0_DMA0SAR_8
#define RENESAS_DMA0SAR9                                SDMAC0_DMA0SAR_9
#define RENESAS_DMA0SAR10                               SDMAC0_DMA0SAR_10
#define RENESAS_DMA0SAR11                               SDMAC0_DMA0SAR_11
#define RENESAS_DMA0SAR12                               SDMAC0_DMA0SAR_12
#define RENESAS_DMA0SAR13                               SDMAC0_DMA0SAR_13
#define RENESAS_DMA0SAR14                               SDMAC0_DMA0SAR_14
#define RENESAS_DMA0SAR15                               SDMAC0_DMA0SAR_15

#define RENESAS_DMA1SAR0                                SDMAC1_DMA1SAR_0
#define RENESAS_DMA1SAR1                                SDMAC1_DMA1SAR_1
#define RENESAS_DMA1SAR2                                SDMAC1_DMA1SAR_2
#define RENESAS_DMA1SAR3                                SDMAC1_DMA1SAR_3
#define RENESAS_DMA1SAR4                                SDMAC1_DMA1SAR_4
#define RENESAS_DMA1SAR5                                SDMAC1_DMA1SAR_5
#define RENESAS_DMA1SAR6                                SDMAC1_DMA1SAR_6
#define RENESAS_DMA1SAR7                                SDMAC1_DMA1SAR_7
#define RENESAS_DMA1SAR8                                SDMAC1_DMA1SAR_8
#define RENESAS_DMA1SAR9                                SDMAC1_DMA1SAR_9
#define RENESAS_DMA1SAR10                               SDMAC1_DMA1SAR_10
#define RENESAS_DMA1SAR11                               SDMAC1_DMA1SAR_11
#define RENESAS_DMA1SAR12                               SDMAC1_DMA1SAR_12
#define RENESAS_DMA1SAR13                               SDMAC1_DMA1SAR_13
#define RENESAS_DMA1SAR14                               SDMAC1_DMA1SAR_14
#define RENESAS_DMA1SAR15                               SDMAC1_DMA1SAR_15

#define RENESAS_DMA0RS0                                 SDMAC0_DMA0RS_0
#define RENESAS_DMA0RS1                                 SDMAC0_DMA0RS_1
#define RENESAS_DMA0RS2                                 SDMAC0_DMA0RS_2
#define RENESAS_DMA0RS3                                 SDMAC0_DMA0RS_3
#define RENESAS_DMA0RS4                                 SDMAC0_DMA0RS_4
#define RENESAS_DMA0RS5                                 SDMAC0_DMA0RS_5
#define RENESAS_DMA0RS6                                 SDMAC0_DMA0RS_6
#define RENESAS_DMA0RS7                                 SDMAC0_DMA0RS_7
#define RENESAS_DMA0RS8                                 SDMAC0_DMA0RS_8
#define RENESAS_DMA0RS9                                 SDMAC0_DMA0RS_9
#define RENESAS_DMA0RS10                                SDMAC0_DMA0RS_10
#define RENESAS_DMA0RS11                                SDMAC0_DMA0RS_11
#define RENESAS_DMA0RS12                                SDMAC0_DMA0RS_12
#define RENESAS_DMA0RS13                                SDMAC0_DMA0RS_13
#define RENESAS_DMA0RS14                                SDMAC0_DMA0RS_14
#define RENESAS_DMA0RS15                                SDMAC0_DMA0RS_15

#define RENESAS_DMA0SEL0                                DMATRGSEL_DMACSEL0_0
#define RENESAS_DMA0SEL1                                DMATRGSEL_DMACSEL0_1
#define RENESAS_DMA0SEL2                                DMATRGSEL_DMACSEL0_2
#define RENESAS_DMA0SEL3                                DMATRGSEL_DMACSEL0_3
#define RENESAS_DMA0SEL4                                DMATRGSEL_DMACSEL0_4
#define RENESAS_DMA0SEL5                                DMATRGSEL_DMACSEL0_5
#define RENESAS_DMA0SEL6                                DMATRGSEL_DMACSEL0_6
#define RENESAS_DMA0SEL7                                DMATRGSEL_DMACSEL0_7
#define RENESAS_DMA0SEL8                                DMATRGSEL_DMACSEL0_8
#define RENESAS_DMA0SEL9                                DMATRGSEL_DMACSEL0_9
#define RENESAS_DMA0SEL10                               DMATRGSEL_DMACSEL0_10
#define RENESAS_DMA0SEL11                               DMATRGSEL_DMACSEL0_11
#define RENESAS_DMA0SEL12                               DMATRGSEL_DMACSEL0_12
#define RENESAS_DMA0SEL13                               DMATRGSEL_DMACSEL0_13
#define RENESAS_DMA0SEL14                               DMATRGSEL_DMACSEL0_14
#define RENESAS_DMA0SEL15                               DMATRGSEL_DMACSEL0_15

#define RENESAS_DMA1SEL0                                DMATRGSEL_DMACSEL1_0
#define RENESAS_DMA1SEL1                                DMATRGSEL_DMACSEL1_1
#define RENESAS_DMA1SEL2                                DMATRGSEL_DMACSEL1_2
#define RENESAS_DMA1SEL3                                DMATRGSEL_DMACSEL1_3
#define RENESAS_DMA1SEL4                                DMATRGSEL_DMACSEL1_4
#define RENESAS_DMA1SEL5                                DMATRGSEL_DMACSEL1_5
#define RENESAS_DMA1SEL6                                DMATRGSEL_DMACSEL1_6
#define RENESAS_DMA1SEL7                                DMATRGSEL_DMACSEL1_7
#define RENESAS_DMA1SEL8                                DMATRGSEL_DMACSEL1_8
#define RENESAS_DMA1SEL9                                DMATRGSEL_DMACSEL1_9
#define RENESAS_DMA1SEL10                               DMATRGSEL_DMACSEL1_10
#define RENESAS_DMA1SEL11                               DMATRGSEL_DMACSEL1_11
#define RENESAS_DMA1SEL12                               DMATRGSEL_DMACSEL1_12
#define RENESAS_DMA1SEL13                               DMATRGSEL_DMACSEL1_13
#define RENESAS_DMA1SEL14                               DMATRGSEL_DMACSEL1_14
#define RENESAS_DMA1SEL15                               DMATRGSEL_DMACSEL1_15

/*******************************************************************************
**                 Macros for ADC Driver                                      **
*******************************************************************************/

#define RENESAS_ADC00DMA                                0
#define RENESAS_ADC01DMA                                1
#define RENESAS_ADC02DMA                                2
#define RENESAS_ADC03DMA                                3
#define RENESAS_ADC04DMA                                4

#define RENESAS_ADC10DMA                                7
#define RENESAS_ADC11DMA                                8
#define RENESAS_ADC12DMA                                9
#define RENESAS_ADC13DMA                                10
#define RENESAS_ADC14DMA                                11

#define RENESAS_ADC20DMA                                14
#define RENESAS_ADC21DMA                                15
#define RENESAS_ADC22DMA                                16
#define RENESAS_ADC23DMA                                17
#define RENESAS_ADC24DMA                                18

#define RENESAS_PIC2BADCX0TSEL0                         PIC20_ADCJ0TSEL0
#define RENESAS_PIC2BADCX1TSEL0                         PIC20_ADCJ1TSEL0

#define RENESAS_PIC2ADTEN500                            PIC20_ADTEN500
#define RENESAS_PIC2ADTEN510                            PIC20_ADTEN510
#define RENESAS_PIC2ADTEN600                            PIC20_ADTEN600
#define RENESAS_PIC2ADTEN610                            PIC20_ADTEN610
#define RENESAS_PIC2ADTEN700                            PIC20_ADTEN700
#define RENESAS_PIC2ADTEN710                            PIC20_ADTEN710
#define RENESAS_PIC2ADTEN800                            PIC20_ADTEN800
#define RENESAS_PIC2ADTEN810                            PIC20_ADTEN810
#define RENESAS_PIC2ADTEN400                            PIC20_ADTEN400
#define RENESAS_PIC2ADTEN410                            PIC20_ADTEN410
#define RENESAS_PIC2ADTEN420                            PIC20_ADTEN420

#define RENESAS_INTADCX0ERR_IMR                         226
#define RENESAS_INTADCX1ERR_IMR                         232
#define RENESAS_INTADCX2ERR_IMR                         238

#define RENESAS_ECMKCPROT                               ECM_KCPROT
#define RENESAS_INTC1CPU0_EIC8                          INTC1_PE0_EIC8
#define RENESAS_INTC1CPU1_EIC8                          INTC1_PE1_EIC8

#define RENESAS_INTADCX0ERR                             INTC2_EIC226
#define RENESAS_INTADCX1ERR                             INTC2_EIC232
#define RENESAS_INTADCX2ERR                             INTC2_EIC238

#define RENESAS_INTADCX0I0_IMR                          227
#define RENESAS_INTADCX0I1_IMR                          228
#define RENESAS_INTADCX0I2_IMR                          229
#define RENESAS_INTADCX0I3_IMR                          230
#define RENESAS_INTADCX0I4_IMR                          231

#define RENESAS_INTADCX1I0_IMR                          233
#define RENESAS_INTADCX1I1_IMR                          234
#define RENESAS_INTADCX1I2_IMR                          235
#define RENESAS_INTADCX1I3_IMR                          236
#define RENESAS_INTADCX1I4_IMR                          237

#define RENESAS_INTADCX2I0_IMR                          239
#define RENESAS_INTADCX2I1_IMR                          240
#define RENESAS_INTADCX2I2_IMR                          241
#define RENESAS_INTADCX2I3_IMR                          242
#define RENESAS_INTADCX2I4_IMR                          243

#define RENESAS_INTADCX0I0                              INTC2_EIC227
#define RENESAS_INTADCX0I1                              INTC2_EIC228
#define RENESAS_INTADCX0I2                              INTC2_EIC229
#define RENESAS_INTADCX0I3                              INTC2_EIC230
#define RENESAS_INTADCX0I4                              INTC2_EIC231

#define RENESAS_INTADCX1I0                              INTC2_EIC233
#define RENESAS_INTADCX1I1                              INTC2_EIC234
#define RENESAS_INTADCX1I2                              INTC2_EIC235
#define RENESAS_INTADCX1I3                              INTC2_EIC236
#define RENESAS_INTADCX1I4                              INTC2_EIC237

#define RENESAS_INTADCX2I0                              INTC2_EIC239
#define RENESAS_INTADCX2I1                              INTC2_EIC240
#define RENESAS_INTADCX2I2                              INTC2_EIC241
#define RENESAS_INTADCX2I3                              INTC2_EIC242
#define RENESAS_INTADCX2I4                              INTC2_EIC243

#define RENESAS_ADCX0DR00                               ADCJ0_DR0
#define RENESAS_ADCX0DR01                               ADCJ0_DR1
#define RENESAS_ADCX0DR02                               ADCJ0_DR2
#define RENESAS_ADCX0DR03                               ADCJ0_DR3
#define RENESAS_ADCX0DR04                               ADCJ0_DR4
#define RENESAS_ADCX0DR05                               ADCJ0_DR5
#define RENESAS_ADCX0DR06                               ADCJ0_DR6
#define RENESAS_ADCX0DR07                               ADCJ0_DR7
#define RENESAS_ADCX0DR08                               ADCJ0_DR8
#define RENESAS_ADCX0DR09                               ADCJ0_DR9
#define RENESAS_ADCX0DR10                               ADCJ0_DR10
#define RENESAS_ADCX0DR11                               ADCJ0_DR11
#define RENESAS_ADCX0DR12                               ADCJ0_DR12
#define RENESAS_ADCX0DR13                               ADCJ0_DR13
#define RENESAS_ADCX0DR14                               ADCJ0_DR14
#define RENESAS_ADCX0DR15                               ADCJ0_DR15
#define RENESAS_ADCX0DR16                               ADCJ0_DR16
#define RENESAS_ADCX0DR17                               ADCJ0_DR17
#define RENESAS_ADCX0DR18                               ADCJ0_DR18
#define RENESAS_ADCX0DR19                               ADCJ0_DR19
#define RENESAS_ADCX0DR20                               ADCJ0_DR20
#define RENESAS_ADCX0DR21                               ADCJ0_DR21
#define RENESAS_ADCX0DR22                               ADCJ0_DR22
#define RENESAS_ADCX0DR23                               ADCJ0_DR23
#define RENESAS_ADCX0DR24                               ADCJ0_DR24
#define RENESAS_ADCX0DR25                               ADCJ0_DR25
#define RENESAS_ADCX0DR26                               ADCJ0_DR26
#define RENESAS_ADCX0DR27                               ADCJ0_DR27
#define RENESAS_ADCX0DR28                               ADCJ0_DR28
#define RENESAS_ADCX0DR29                               ADCJ0_DR29
#define RENESAS_ADCX0DR30                               ADCJ0_DR30
#define RENESAS_ADCX0DR31                               ADCJ0_DR31
#define RENESAS_ADCX0DR32                               ADCJ0_DR32
#define RENESAS_ADCX0DR33                               ADCJ0_DR33
#define RENESAS_ADCX0DR34                               ADCJ0_DR34
#define RENESAS_ADCX0DR35                               ADCJ0_DR35
#define RENESAS_ADCX0DR36                               ADCJ0_DR36
#define RENESAS_ADCX0DR37                               ADCJ0_DR37
#define RENESAS_ADCX0DR38                               ADCJ0_DR38
#define RENESAS_ADCX0DR39                               ADCJ0_DR39

#define RENESAS_ADCX1DR00                               ADCJ1_DR0
#define RENESAS_ADCX1DR01                               ADCJ1_DR1
#define RENESAS_ADCX1DR02                               ADCJ1_DR2
#define RENESAS_ADCX1DR03                               ADCJ1_DR3
#define RENESAS_ADCX1DR04                               ADCJ1_DR4
#define RENESAS_ADCX1DR05                               ADCJ1_DR5
#define RENESAS_ADCX1DR06                               ADCJ1_DR6
#define RENESAS_ADCX1DR07                               ADCJ1_DR7
#define RENESAS_ADCX1DR08                               ADCJ1_DR8
#define RENESAS_ADCX1DR09                               ADCJ1_DR9
#define RENESAS_ADCX1DR10                               ADCJ1_DR10
#define RENESAS_ADCX1DR11                               ADCJ1_DR11
#define RENESAS_ADCX1DR12                               ADCJ1_DR12
#define RENESAS_ADCX1DR13                               ADCJ1_DR13
#define RENESAS_ADCX1DR14                               ADCJ1_DR14
#define RENESAS_ADCX1DR15                               ADCJ1_DR15
#define RENESAS_ADCX1DR16                               ADCJ1_DR16
#define RENESAS_ADCX1DR17                               ADCJ1_DR17
#define RENESAS_ADCX1DR18                               ADCJ1_DR18
#define RENESAS_ADCX1DR19                               ADCJ1_DR19
#define RENESAS_ADCX1DR20                               ADCJ1_DR20
#define RENESAS_ADCX1DR21                               ADCJ1_DR21
#define RENESAS_ADCX1DR22                               ADCJ1_DR22
#define RENESAS_ADCX1DR23                               ADCJ1_DR23
#define RENESAS_ADCX1DR24                               ADCJ1_DR24
#define RENESAS_ADCX1DR25                               ADCJ1_DR25
#define RENESAS_ADCX1DR26                               ADCJ1_DR26
#define RENESAS_ADCX1DR27                               ADCJ1_DR27
#define RENESAS_ADCX1DR28                               ADCJ1_DR28
#define RENESAS_ADCX1DR29                               ADCJ1_DR29
#define RENESAS_ADCX1DR30                               ADCJ1_DR30
#define RENESAS_ADCX1DR31                               ADCJ1_DR31
#define RENESAS_ADCX1DR32                               ADCJ1_DR32
#define RENESAS_ADCX1DR33                               ADCJ1_DR33
#define RENESAS_ADCX1DR34                               ADCJ1_DR34
#define RENESAS_ADCX1DR35                               ADCJ1_DR35
#define RENESAS_ADCX1DR36                               ADCJ1_DR36
#define RENESAS_ADCX1DR37                               ADCJ1_DR37
#define RENESAS_ADCX1DR38                               ADCJ1_DR38
#define RENESAS_ADCX1DR39                               ADCJ1_DR39

#define RENESAS_ADCX2DR00                               ADCJ2_DR0
#define RENESAS_ADCX2DR01                               ADCJ2_DR1
#define RENESAS_ADCX2DR02                               ADCJ2_DR2
#define RENESAS_ADCX2DR03                               ADCJ2_DR3
#define RENESAS_ADCX2DR04                               ADCJ2_DR4
#define RENESAS_ADCX2DR05                               ADCJ2_DR5
#define RENESAS_ADCX2DR06                               ADCJ2_DR6
#define RENESAS_ADCX2DR07                               ADCJ2_DR7
#define RENESAS_ADCX2DR08                               ADCJ2_DR8
#define RENESAS_ADCX2DR09                               ADCJ2_DR9
#define RENESAS_ADCX2DR10                               ADCJ2_DR10
#define RENESAS_ADCX2DR11                               ADCJ2_DR11
#define RENESAS_ADCX2DR12                               ADCJ2_DR12
#define RENESAS_ADCX2DR13                               ADCJ2_DR13
#define RENESAS_ADCX2DR14                               ADCJ2_DR14
#define RENESAS_ADCX2DR15                               ADCJ2_DR15
#define RENESAS_ADCX2DR16                               ADCJ2_DR16
#define RENESAS_ADCX2DR17                               ADCJ2_DR17
#define RENESAS_ADCX2DR18                               ADCJ2_DR18
#define RENESAS_ADCX2DR19                               ADCJ2_DR19
#define RENESAS_ADCX2DR20                               ADCJ2_DR20
#define RENESAS_ADCX2DR21                               ADCJ2_DR21
#define RENESAS_ADCX2DR22                               ADCJ2_DR22
#define RENESAS_ADCX2DR23                               ADCJ2_DR23
#define RENESAS_ADCX2DR24                               ADCJ2_DR24
#define RENESAS_ADCX2DR25                               ADCJ2_DR25
#define RENESAS_ADCX2DR26                               ADCJ2_DR26
#define RENESAS_ADCX2DR27                               ADCJ2_DR27
#define RENESAS_ADCX2DR28                               ADCJ2_DR28
#define RENESAS_ADCX2DR29                               ADCJ2_DR29
#define RENESAS_ADCX2DR30                               ADCJ2_DR30
#define RENESAS_ADCX2DR31                               ADCJ2_DR31
#define RENESAS_ADCX2DR32                               ADCJ2_DR32
#define RENESAS_ADCX2DR33                               ADCJ2_DR33
#define RENESAS_ADCX2DR34                               ADCJ2_DR34
#define RENESAS_ADCX2DR35                               ADCJ2_DR35
#define RENESAS_ADCX2DR36                               ADCJ2_DR36
#define RENESAS_ADCX2DR37                               ADCJ2_DR37
#define RENESAS_ADCX2DR38                               ADCJ2_DR38
#define RENESAS_ADCX2DR39                               ADCJ2_DR39

#define RENESAS_ADCX0DIR00                              ADCJ0_DIR0
#define RENESAS_ADCX0DIR01                              ADCJ0_DIR1
#define RENESAS_ADCX0DIR02                              ADCJ0_DIR2
#define RENESAS_ADCX0DIR03                              ADCJ0_DIR3
#define RENESAS_ADCX0DIR04                              ADCJ0_DIR4
#define RENESAS_ADCX0DIR05                              ADCJ0_DIR5
#define RENESAS_ADCX0DIR06                              ADCJ0_DIR6
#define RENESAS_ADCX0DIR07                              ADCJ0_DIR7
#define RENESAS_ADCX0DIR08                              ADCJ0_DIR8
#define RENESAS_ADCX0DIR09                              ADCJ0_DIR9
#define RENESAS_ADCX0DIR10                              ADCJ0_DIR10
#define RENESAS_ADCX0DIR11                              ADCJ0_DIR11
#define RENESAS_ADCX0DIR12                              ADCJ0_DIR12
#define RENESAS_ADCX0DIR13                              ADCJ0_DIR13
#define RENESAS_ADCX0DIR14                              ADCJ0_DIR14
#define RENESAS_ADCX0DIR15                              ADCJ0_DIR15
#define RENESAS_ADCX0DIR16                              ADCJ0_DIR16
#define RENESAS_ADCX0DIR17                              ADCJ0_DIR17
#define RENESAS_ADCX0DIR18                              ADCJ0_DIR18
#define RENESAS_ADCX0DIR19                              ADCJ0_DIR19
#define RENESAS_ADCX0DIR20                              ADCJ0_DIR20
#define RENESAS_ADCX0DIR21                              ADCJ0_DIR21
#define RENESAS_ADCX0DIR22                              ADCJ0_DIR22
#define RENESAS_ADCX0DIR23                              ADCJ0_DIR23
#define RENESAS_ADCX0DIR24                              ADCJ0_DIR24
#define RENESAS_ADCX0DIR25                              ADCJ0_DIR25
#define RENESAS_ADCX0DIR26                              ADCJ0_DIR26
#define RENESAS_ADCX0DIR27                              ADCJ0_DIR27
#define RENESAS_ADCX0DIR28                              ADCJ0_DIR28
#define RENESAS_ADCX0DIR29                              ADCJ0_DIR29
#define RENESAS_ADCX0DIR30                              ADCJ0_DIR30
#define RENESAS_ADCX0DIR31                              ADCJ0_DIR31
#define RENESAS_ADCX0DIR32                              ADCJ0_DIR32
#define RENESAS_ADCX0DIR33                              ADCJ0_DIR33
#define RENESAS_ADCX0DIR34                              ADCJ0_DIR34
#define RENESAS_ADCX0DIR35                              ADCJ0_DIR35
#define RENESAS_ADCX0DIR36                              ADCJ0_DIR36
#define RENESAS_ADCX0DIR37                              ADCJ0_DIR37
#define RENESAS_ADCX0DIR38                              ADCJ0_DIR38
#define RENESAS_ADCX0DIR39                              ADCJ0_DIR39
#define RENESAS_ADCX0DIR40                              ADCJ0_DIR40
#define RENESAS_ADCX0DIR41                              ADCJ0_DIR41
#define RENESAS_ADCX0DIR42                              ADCJ0_DIR42
#define RENESAS_ADCX0DIR43                              ADCJ0_DIR43
#define RENESAS_ADCX0DIR44                              ADCJ0_DIR44
#define RENESAS_ADCX0DIR45                              ADCJ0_DIR45
#define RENESAS_ADCX0DIR46                              ADCJ0_DIR46
#define RENESAS_ADCX0DIR47                              ADCJ0_DIR47
#define RENESAS_ADCX0DIR48                              ADCJ0_DIR48
#define RENESAS_ADCX0DIR49                              ADCJ0_DIR49
#define RENESAS_ADCX0DIR50                              ADCJ0_DIR50
#define RENESAS_ADCX0DIR51                              ADCJ0_DIR51
#define RENESAS_ADCX0DIR52                              ADCJ0_DIR52
#define RENESAS_ADCX0DIR53                              ADCJ0_DIR53
#define RENESAS_ADCX0DIR54                              ADCJ0_DIR54
#define RENESAS_ADCX0DIR55                              ADCJ0_DIR55
#define RENESAS_ADCX0DIR56                              ADCJ0_DIR56
#define RENESAS_ADCX0DIR57                              ADCJ0_DIR57
#define RENESAS_ADCX0DIR58                              ADCJ0_DIR58
#define RENESAS_ADCX0DIR59                              ADCJ0_DIR59
#define RENESAS_ADCX0DIR60                              ADCJ0_DIR60
#define RENESAS_ADCX0DIR61                              ADCJ0_DIR61
#define RENESAS_ADCX0DIR62                              ADCJ0_DIR62
#define RENESAS_ADCX0DIR63                              ADCJ0_DIR63

#define RENESAS_ADCX1DIR00                              ADCJ1_DIR0
#define RENESAS_ADCX1DIR01                              ADCJ1_DIR1
#define RENESAS_ADCX1DIR02                              ADCJ1_DIR2
#define RENESAS_ADCX1DIR03                              ADCJ1_DIR3
#define RENESAS_ADCX1DIR04                              ADCJ1_DIR4
#define RENESAS_ADCX1DIR05                              ADCJ1_DIR5
#define RENESAS_ADCX1DIR06                              ADCJ1_DIR6
#define RENESAS_ADCX1DIR07                              ADCJ1_DIR7
#define RENESAS_ADCX1DIR08                              ADCJ1_DIR8
#define RENESAS_ADCX1DIR09                              ADCJ1_DIR9
#define RENESAS_ADCX1DIR10                              ADCJ1_DIR10
#define RENESAS_ADCX1DIR11                              ADCJ1_DIR11
#define RENESAS_ADCX1DIR12                              ADCJ1_DIR12
#define RENESAS_ADCX1DIR13                              ADCJ1_DIR13
#define RENESAS_ADCX1DIR14                              ADCJ1_DIR14
#define RENESAS_ADCX1DIR15                              ADCJ1_DIR15
#define RENESAS_ADCX1DIR16                              ADCJ1_DIR16
#define RENESAS_ADCX1DIR17                              ADCJ1_DIR17
#define RENESAS_ADCX1DIR18                              ADCJ1_DIR18
#define RENESAS_ADCX1DIR19                              ADCJ1_DIR19
#define RENESAS_ADCX1DIR20                              ADCJ1_DIR20
#define RENESAS_ADCX1DIR21                              ADCJ1_DIR21
#define RENESAS_ADCX1DIR22                              ADCJ1_DIR22
#define RENESAS_ADCX1DIR23                              ADCJ1_DIR23
#define RENESAS_ADCX1DIR24                              ADCJ1_DIR24
#define RENESAS_ADCX1DIR25                              ADCJ1_DIR25
#define RENESAS_ADCX1DIR26                              ADCJ1_DIR26
#define RENESAS_ADCX1DIR27                              ADCJ1_DIR27
#define RENESAS_ADCX1DIR28                              ADCJ1_DIR28
#define RENESAS_ADCX1DIR29                              ADCJ1_DIR29
#define RENESAS_ADCX1DIR30                              ADCJ1_DIR30
#define RENESAS_ADCX1DIR31                              ADCJ1_DIR31
#define RENESAS_ADCX1DIR32                              ADCJ1_DIR32
#define RENESAS_ADCX1DIR33                              ADCJ1_DIR33
#define RENESAS_ADCX1DIR34                              ADCJ1_DIR34
#define RENESAS_ADCX1DIR35                              ADCJ1_DIR35
#define RENESAS_ADCX1DIR36                              ADCJ1_DIR36
#define RENESAS_ADCX1DIR37                              ADCJ1_DIR37
#define RENESAS_ADCX1DIR38                              ADCJ1_DIR38
#define RENESAS_ADCX1DIR39                              ADCJ1_DIR39
#define RENESAS_ADCX1DIR40                              ADCJ1_DIR40
#define RENESAS_ADCX1DIR41                              ADCJ1_DIR41
#define RENESAS_ADCX1DIR42                              ADCJ1_DIR42
#define RENESAS_ADCX1DIR43                              ADCJ1_DIR43
#define RENESAS_ADCX1DIR44                              ADCJ1_DIR44
#define RENESAS_ADCX1DIR45                              ADCJ1_DIR45
#define RENESAS_ADCX1DIR46                              ADCJ1_DIR46
#define RENESAS_ADCX1DIR47                              ADCJ1_DIR47
#define RENESAS_ADCX1DIR48                              ADCJ1_DIR48
#define RENESAS_ADCX1DIR49                              ADCJ1_DIR49
#define RENESAS_ADCX1DIR50                              ADCJ1_DIR50
#define RENESAS_ADCX1DIR51                              ADCJ1_DIR51
#define RENESAS_ADCX1DIR52                              ADCJ1_DIR52
#define RENESAS_ADCX1DIR53                              ADCJ1_DIR53
#define RENESAS_ADCX1DIR54                              ADCJ1_DIR54
#define RENESAS_ADCX1DIR55                              ADCJ1_DIR55
#define RENESAS_ADCX1DIR56                              ADCJ1_DIR56
#define RENESAS_ADCX1DIR57                              ADCJ1_DIR57
#define RENESAS_ADCX1DIR58                              ADCJ1_DIR58
#define RENESAS_ADCX1DIR59                              ADCJ1_DIR59
#define RENESAS_ADCX1DIR60                              ADCJ1_DIR60
#define RENESAS_ADCX1DIR61                              ADCJ1_DIR61
#define RENESAS_ADCX1DIR62                              ADCJ1_DIR62
#define RENESAS_ADCX1DIR63                              ADCJ1_DIR63

#define RENESAS_ADCX2DIR00                              ADCJ2_DIR0
#define RENESAS_ADCX2DIR01                              ADCJ2_DIR1
#define RENESAS_ADCX2DIR02                              ADCJ2_DIR2
#define RENESAS_ADCX2DIR03                              ADCJ2_DIR3
#define RENESAS_ADCX2DIR04                              ADCJ2_DIR4
#define RENESAS_ADCX2DIR05                              ADCJ2_DIR5
#define RENESAS_ADCX2DIR06                              ADCJ2_DIR6
#define RENESAS_ADCX2DIR07                              ADCJ2_DIR7
#define RENESAS_ADCX2DIR08                              ADCJ2_DIR8
#define RENESAS_ADCX2DIR09                              ADCJ2_DIR9
#define RENESAS_ADCX2DIR10                              ADCJ2_DIR10
#define RENESAS_ADCX2DIR11                              ADCJ2_DIR11
#define RENESAS_ADCX2DIR12                              ADCJ2_DIR12
#define RENESAS_ADCX2DIR13                              ADCJ2_DIR13
#define RENESAS_ADCX2DIR14                              ADCJ2_DIR14
#define RENESAS_ADCX2DIR15                              ADCJ2_DIR15
#define RENESAS_ADCX2DIR16                              ADCJ2_DIR16
#define RENESAS_ADCX2DIR17                              ADCJ2_DIR17
#define RENESAS_ADCX2DIR18                              ADCJ2_DIR18
#define RENESAS_ADCX2DIR19                              ADCJ2_DIR19
#define RENESAS_ADCX2DIR20                              ADCJ2_DIR20
#define RENESAS_ADCX2DIR21                              ADCJ2_DIR21
#define RENESAS_ADCX2DIR22                              ADCJ2_DIR22
#define RENESAS_ADCX2DIR23                              ADCJ2_DIR23
#define RENESAS_ADCX2DIR24                              ADCJ2_DIR24
#define RENESAS_ADCX2DIR25                              ADCJ2_DIR25
#define RENESAS_ADCX2DIR26                              ADCJ2_DIR26
#define RENESAS_ADCX2DIR27                              ADCJ2_DIR27
#define RENESAS_ADCX2DIR28                              ADCJ2_DIR28
#define RENESAS_ADCX2DIR29                              ADCJ2_DIR29
#define RENESAS_ADCX2DIR30                              ADCJ2_DIR30
#define RENESAS_ADCX2DIR31                              ADCJ2_DIR31
#define RENESAS_ADCX2DIR32                              ADCJ2_DIR32
#define RENESAS_ADCX2DIR33                              ADCJ2_DIR33
#define RENESAS_ADCX2DIR34                              ADCJ2_DIR34
#define RENESAS_ADCX2DIR35                              ADCJ2_DIR35
#define RENESAS_ADCX2DIR36                              ADCJ2_DIR36
#define RENESAS_ADCX2DIR37                              ADCJ2_DIR37
#define RENESAS_ADCX2DIR38                              ADCJ2_DIR38
#define RENESAS_ADCX2DIR39                              ADCJ2_DIR39
#define RENESAS_ADCX2DIR40                              ADCJ2_DIR40
#define RENESAS_ADCX2DIR41                              ADCJ2_DIR41
#define RENESAS_ADCX2DIR42                              ADCJ2_DIR42
#define RENESAS_ADCX2DIR43                              ADCJ2_DIR43
#define RENESAS_ADCX2DIR44                              ADCJ2_DIR44
#define RENESAS_ADCX2DIR45                              ADCJ2_DIR45
#define RENESAS_ADCX2DIR46                              ADCJ2_DIR46
#define RENESAS_ADCX2DIR47                              ADCJ2_DIR47
#define RENESAS_ADCX2DIR48                              ADCJ2_DIR48
#define RENESAS_ADCX2DIR49                              ADCJ2_DIR49
#define RENESAS_ADCX2DIR50                              ADCJ2_DIR50
#define RENESAS_ADCX2DIR51                              ADCJ2_DIR51
#define RENESAS_ADCX2DIR52                              ADCJ2_DIR52
#define RENESAS_ADCX2DIR53                              ADCJ2_DIR53
#define RENESAS_ADCX2DIR54                              ADCJ2_DIR54
#define RENESAS_ADCX2DIR55                              ADCJ2_DIR55
#define RENESAS_ADCX2DIR56                              ADCJ2_DIR56
#define RENESAS_ADCX2DIR57                              ADCJ2_DIR57
#define RENESAS_ADCX2DIR58                              ADCJ2_DIR58
#define RENESAS_ADCX2DIR59                              ADCJ2_DIR59
#define RENESAS_ADCX2DIR60                              ADCJ2_DIR60
#define RENESAS_ADCX2DIR61                              ADCJ2_DIR61
#define RENESAS_ADCX2DIR62                              ADCJ2_DIR62
#define RENESAS_ADCX2DIR63                              ADCJ2_DIR63

#define RENESAS_ADCX0VCR00                              ADCJ0_VCR0
#define RENESAS_ADCX0VCR01                              ADCJ0_VCR1
#define RENESAS_ADCX0VCR02                              ADCJ0_VCR2
#define RENESAS_ADCX0VCR03                              ADCJ0_VCR3
#define RENESAS_ADCX0VCR04                              ADCJ0_VCR4
#define RENESAS_ADCX0VCR05                              ADCJ0_VCR5
#define RENESAS_ADCX0VCR06                              ADCJ0_VCR6
#define RENESAS_ADCX0VCR07                              ADCJ0_VCR7
#define RENESAS_ADCX0VCR08                              ADCJ0_VCR8
#define RENESAS_ADCX0VCR09                              ADCJ0_VCR9
#define RENESAS_ADCX0VCR10                              ADCJ0_VCR10
#define RENESAS_ADCX0VCR11                              ADCJ0_VCR11
#define RENESAS_ADCX0VCR12                              ADCJ0_VCR12
#define RENESAS_ADCX0VCR13                              ADCJ0_VCR13
#define RENESAS_ADCX0VCR14                              ADCJ0_VCR14
#define RENESAS_ADCX0VCR15                              ADCJ0_VCR15
#define RENESAS_ADCX0VCR16                              ADCJ0_VCR16
#define RENESAS_ADCX0VCR17                              ADCJ0_VCR17
#define RENESAS_ADCX0VCR18                              ADCJ0_VCR18
#define RENESAS_ADCX0VCR19                              ADCJ0_VCR19
#define RENESAS_ADCX0VCR20                              ADCJ0_VCR20
#define RENESAS_ADCX0VCR21                              ADCJ0_VCR21
#define RENESAS_ADCX0VCR22                              ADCJ0_VCR22
#define RENESAS_ADCX0VCR23                              ADCJ0_VCR23
#define RENESAS_ADCX0VCR24                              ADCJ0_VCR24
#define RENESAS_ADCX0VCR25                              ADCJ0_VCR25
#define RENESAS_ADCX0VCR26                              ADCJ0_VCR26
#define RENESAS_ADCX0VCR27                              ADCJ0_VCR27
#define RENESAS_ADCX0VCR28                              ADCJ0_VCR28
#define RENESAS_ADCX0VCR29                              ADCJ0_VCR29
#define RENESAS_ADCX0VCR30                              ADCJ0_VCR30
#define RENESAS_ADCX0VCR31                              ADCJ0_VCR31
#define RENESAS_ADCX0VCR32                              ADCJ0_VCR32
#define RENESAS_ADCX0VCR33                              ADCJ0_VCR33
#define RENESAS_ADCX0VCR34                              ADCJ0_VCR34
#define RENESAS_ADCX0VCR35                              ADCJ0_VCR35
#define RENESAS_ADCX0VCR36                              ADCJ0_VCR36
#define RENESAS_ADCX0VCR37                              ADCJ0_VCR37
#define RENESAS_ADCX0VCR38                              ADCJ0_VCR38
#define RENESAS_ADCX0VCR39                              ADCJ0_VCR39
#define RENESAS_ADCX0VCR40                              ADCJ0_VCR40
#define RENESAS_ADCX0VCR41                              ADCJ0_VCR41
#define RENESAS_ADCX0VCR42                              ADCJ0_VCR42
#define RENESAS_ADCX0VCR43                              ADCJ0_VCR43
#define RENESAS_ADCX0VCR44                              ADCJ0_VCR44
#define RENESAS_ADCX0VCR45                              ADCJ0_VCR45
#define RENESAS_ADCX0VCR46                              ADCJ0_VCR46
#define RENESAS_ADCX0VCR47                              ADCJ0_VCR47
#define RENESAS_ADCX0VCR48                              ADCJ0_VCR48
#define RENESAS_ADCX0VCR49                              ADCJ0_VCR49
#define RENESAS_ADCX0VCR50                              ADCJ0_VCR50
#define RENESAS_ADCX0VCR51                              ADCJ0_VCR51
#define RENESAS_ADCX0VCR52                              ADCJ0_VCR52
#define RENESAS_ADCX0VCR53                              ADCJ0_VCR53
#define RENESAS_ADCX0VCR54                              ADCJ0_VCR54
#define RENESAS_ADCX0VCR55                              ADCJ0_VCR55
#define RENESAS_ADCX0VCR56                              ADCJ0_VCR56
#define RENESAS_ADCX0VCR57                              ADCJ0_VCR57
#define RENESAS_ADCX0VCR58                              ADCJ0_VCR58
#define RENESAS_ADCX0VCR59                              ADCJ0_VCR59
#define RENESAS_ADCX0VCR60                              ADCJ0_VCR60
#define RENESAS_ADCX0VCR61                              ADCJ0_VCR61
#define RENESAS_ADCX0VCR62                              ADCJ0_VCR62
#define RENESAS_ADCX0VCR63                              ADCJ0_VCR63

#define RENESAS_ADCX1VCR00                              ADCJ1_VCR0
#define RENESAS_ADCX1VCR01                              ADCJ1_VCR1
#define RENESAS_ADCX1VCR02                              ADCJ1_VCR2
#define RENESAS_ADCX1VCR03                              ADCJ1_VCR3
#define RENESAS_ADCX1VCR04                              ADCJ1_VCR4
#define RENESAS_ADCX1VCR05                              ADCJ1_VCR5
#define RENESAS_ADCX1VCR06                              ADCJ1_VCR6
#define RENESAS_ADCX1VCR07                              ADCJ1_VCR7
#define RENESAS_ADCX1VCR08                              ADCJ1_VCR8
#define RENESAS_ADCX1VCR09                              ADCJ1_VCR9
#define RENESAS_ADCX1VCR10                              ADCJ1_VCR10
#define RENESAS_ADCX1VCR11                              ADCJ1_VCR11
#define RENESAS_ADCX1VCR12                              ADCJ1_VCR12
#define RENESAS_ADCX1VCR13                              ADCJ1_VCR13
#define RENESAS_ADCX1VCR14                              ADCJ1_VCR14
#define RENESAS_ADCX1VCR15                              ADCJ1_VCR15
#define RENESAS_ADCX1VCR16                              ADCJ1_VCR16
#define RENESAS_ADCX1VCR17                              ADCJ1_VCR17
#define RENESAS_ADCX1VCR18                              ADCJ1_VCR18
#define RENESAS_ADCX1VCR19                              ADCJ1_VCR19
#define RENESAS_ADCX1VCR20                              ADCJ1_VCR20
#define RENESAS_ADCX1VCR21                              ADCJ1_VCR21
#define RENESAS_ADCX1VCR22                              ADCJ1_VCR22
#define RENESAS_ADCX1VCR23                              ADCJ1_VCR23
#define RENESAS_ADCX1VCR24                              ADCJ1_VCR24
#define RENESAS_ADCX1VCR25                              ADCJ1_VCR25
#define RENESAS_ADCX1VCR26                              ADCJ1_VCR26
#define RENESAS_ADCX1VCR27                              ADCJ1_VCR27
#define RENESAS_ADCX1VCR28                              ADCJ1_VCR28
#define RENESAS_ADCX1VCR29                              ADCJ1_VCR29
#define RENESAS_ADCX1VCR30                              ADCJ1_VCR30
#define RENESAS_ADCX1VCR31                              ADCJ1_VCR31
#define RENESAS_ADCX1VCR32                              ADCJ1_VCR32
#define RENESAS_ADCX1VCR33                              ADCJ1_VCR33
#define RENESAS_ADCX1VCR34                              ADCJ1_VCR34
#define RENESAS_ADCX1VCR35                              ADCJ1_VCR35
#define RENESAS_ADCX1VCR36                              ADCJ1_VCR36
#define RENESAS_ADCX1VCR37                              ADCJ1_VCR37
#define RENESAS_ADCX1VCR38                              ADCJ1_VCR38
#define RENESAS_ADCX1VCR39                              ADCJ1_VCR39
#define RENESAS_ADCX1VCR40                              ADCJ1_VCR40
#define RENESAS_ADCX1VCR41                              ADCJ1_VCR41
#define RENESAS_ADCX1VCR42                              ADCJ1_VCR42
#define RENESAS_ADCX1VCR43                              ADCJ1_VCR43
#define RENESAS_ADCX1VCR44                              ADCJ1_VCR44
#define RENESAS_ADCX1VCR45                              ADCJ1_VCR45
#define RENESAS_ADCX1VCR46                              ADCJ1_VCR46
#define RENESAS_ADCX1VCR47                              ADCJ1_VCR47
#define RENESAS_ADCX1VCR48                              ADCJ1_VCR48
#define RENESAS_ADCX1VCR49                              ADCJ1_VCR49
#define RENESAS_ADCX1VCR50                              ADCJ1_VCR50
#define RENESAS_ADCX1VCR51                              ADCJ1_VCR51
#define RENESAS_ADCX1VCR52                              ADCJ1_VCR52
#define RENESAS_ADCX1VCR53                              ADCJ1_VCR53
#define RENESAS_ADCX1VCR54                              ADCJ1_VCR54
#define RENESAS_ADCX1VCR55                              ADCJ1_VCR55
#define RENESAS_ADCX1VCR56                              ADCJ1_VCR56
#define RENESAS_ADCX1VCR57                              ADCJ1_VCR57
#define RENESAS_ADCX1VCR58                              ADCJ1_VCR58
#define RENESAS_ADCX1VCR59                              ADCJ1_VCR59
#define RENESAS_ADCX1VCR60                              ADCJ1_VCR60
#define RENESAS_ADCX1VCR61                              ADCJ1_VCR61
#define RENESAS_ADCX1VCR62                              ADCJ1_VCR62
#define RENESAS_ADCX1VCR63                              ADCJ1_VCR63

#define RENESAS_ADCX2VCR00                              ADCJ2_VCR0
#define RENESAS_ADCX2VCR01                              ADCJ2_VCR1
#define RENESAS_ADCX2VCR02                              ADCJ2_VCR2
#define RENESAS_ADCX2VCR03                              ADCJ2_VCR3
#define RENESAS_ADCX2VCR04                              ADCJ2_VCR4
#define RENESAS_ADCX2VCR05                              ADCJ2_VCR5
#define RENESAS_ADCX2VCR06                              ADCJ2_VCR6
#define RENESAS_ADCX2VCR07                              ADCJ2_VCR7
#define RENESAS_ADCX2VCR08                              ADCJ2_VCR8
#define RENESAS_ADCX2VCR09                              ADCJ2_VCR9
#define RENESAS_ADCX2VCR10                              ADCJ2_VCR10
#define RENESAS_ADCX2VCR11                              ADCJ2_VCR11
#define RENESAS_ADCX2VCR12                              ADCJ2_VCR12
#define RENESAS_ADCX2VCR13                              ADCJ2_VCR13
#define RENESAS_ADCX2VCR14                              ADCJ2_VCR14
#define RENESAS_ADCX2VCR15                              ADCJ2_VCR15
#define RENESAS_ADCX2VCR16                              ADCJ2_VCR16
#define RENESAS_ADCX2VCR17                              ADCJ2_VCR17
#define RENESAS_ADCX2VCR18                              ADCJ2_VCR18
#define RENESAS_ADCX2VCR19                              ADCJ2_VCR19
#define RENESAS_ADCX2VCR20                              ADCJ2_VCR20
#define RENESAS_ADCX2VCR21                              ADCJ2_VCR21
#define RENESAS_ADCX2VCR22                              ADCJ2_VCR22
#define RENESAS_ADCX2VCR23                              ADCJ2_VCR23
#define RENESAS_ADCX2VCR24                              ADCJ2_VCR24
#define RENESAS_ADCX2VCR25                              ADCJ2_VCR25
#define RENESAS_ADCX2VCR26                              ADCJ2_VCR26
#define RENESAS_ADCX2VCR27                              ADCJ2_VCR27
#define RENESAS_ADCX2VCR28                              ADCJ2_VCR28
#define RENESAS_ADCX2VCR29                              ADCJ2_VCR29
#define RENESAS_ADCX2VCR30                              ADCJ2_VCR30
#define RENESAS_ADCX2VCR31                              ADCJ2_VCR31
#define RENESAS_ADCX2VCR32                              ADCJ2_VCR32
#define RENESAS_ADCX2VCR33                              ADCJ2_VCR33
#define RENESAS_ADCX2VCR34                              ADCJ2_VCR34
#define RENESAS_ADCX2VCR35                              ADCJ2_VCR35
#define RENESAS_ADCX2VCR36                              ADCJ2_VCR36
#define RENESAS_ADCX2VCR37                              ADCJ2_VCR37
#define RENESAS_ADCX2VCR38                              ADCJ2_VCR38
#define RENESAS_ADCX2VCR39                              ADCJ2_VCR39
#define RENESAS_ADCX2VCR40                              ADCJ2_VCR40
#define RENESAS_ADCX2VCR41                              ADCJ2_VCR41
#define RENESAS_ADCX2VCR42                              ADCJ2_VCR42
#define RENESAS_ADCX2VCR43                              ADCJ2_VCR43
#define RENESAS_ADCX2VCR44                              ADCJ2_VCR44
#define RENESAS_ADCX2VCR45                              ADCJ2_VCR45
#define RENESAS_ADCX2VCR46                              ADCJ2_VCR46
#define RENESAS_ADCX2VCR47                              ADCJ2_VCR47
#define RENESAS_ADCX2VCR48                              ADCJ2_VCR48
#define RENESAS_ADCX2VCR49                              ADCJ2_VCR49
#define RENESAS_ADCX2VCR50                              ADCJ2_VCR50
#define RENESAS_ADCX2VCR51                              ADCJ2_VCR51
#define RENESAS_ADCX2VCR52                              ADCJ2_VCR52
#define RENESAS_ADCX2VCR53                              ADCJ2_VCR53
#define RENESAS_ADCX2VCR54                              ADCJ2_VCR54
#define RENESAS_ADCX2VCR55                              ADCJ2_VCR55
#define RENESAS_ADCX2VCR56                              ADCJ2_VCR56
#define RENESAS_ADCX2VCR57                              ADCJ2_VCR57
#define RENESAS_ADCX2VCR58                              ADCJ2_VCR58
#define RENESAS_ADCX2VCR59                              ADCJ2_VCR59
#define RENESAS_ADCX2VCR60                              ADCJ2_VCR60
#define RENESAS_ADCX2VCR61                              ADCJ2_VCR61
#define RENESAS_ADCX2VCR62                              ADCJ2_VCR62
#define RENESAS_ADCX2VCR63                              ADCJ2_VCR63

#define RENESAS_ADCX2SGTSEL0                            ADCJ2_SELB_ADCJ2SGTSEL0
#define RENESAS_ADCX2SGTSEL1                            ADCJ2_SELB_ADCJ2SGTSEL1
#define RENESAS_ADCX2SGTSEL2                            ADCJ2_SELB_ADCJ2SGTSEL2
#define RENESAS_ADCX2SGTSEL3                            ADCJ2_SELB_ADCJ2SGTSEL3
#define RENESAS_ADCX2SGTSEL4                            ADCJ2_SELB_ADCJ2SGTSEL4

#define RENESAS_ECMMESSTR2                              ECMM_ESSTR2
#define RENESAS_ECMINCFG002                             ECM_INCFG0_2
#define RENESAS_ECMINCFG102                             ECM_INCFG1_2
#define RENESAS_ECMISCFG2                               ECM_ISCFG2
/*******************************************************************************
**                 Macros for MCU Driver                                      **
*******************************************************************************/
#define RENESAS_RESF                                    SYSCTRL_RESF
#define RENESAS_RESFC                                   SYSCTRL_RESFC

#define RENESAS_ECMMESSTR0                              ECMM_ESSTR0
#define RENESAS_ECMMESSTR1                              ECMM_ESSTR1
#define RENESAS_ECMMESSTR3                              ECMM_ESSTR3
#define RENESAS_ECMMESSTR7                              ECMM_ESSTR7

#define RENESAS_ECMCECLR_ADDRESS                        ECMC_ECLR
#define RENESAS_ECMMECLR_ADDRESS                        ECMM_ECLR
#define RENESAS_ECMDTMCFG7_ADDRESS                      ECM_DTMCFG7
#define RENESAS_ECMDTMCFG8_ADDRESS                      ECM_DTMCFG8
#define RENESAS_ECMDTMCFG9_ADDRESS                      ECM_DTMCFG9
#define RENESAS_ECMDTMCFG10_ADDRESS                     ECM_DTMCFG10

#define RENESAS_INTC1CPU0EIC0                           INTC1_PE0_EIC0
#define RENESAS_BOOTCTRL                                SYSCTRL_BOOTCTRL
#define RENESAS_SWSRESA                                 SYSCTRL_SWSRESA
#define RENESAS_SWARESA                                 SYSCTRL_SWARESA
#define RENESAS_RESC                                    SYSCTRL_RESC
#define RENESAS_CLMAKCPROT                              CLMAPR_KCPROT
#define RENESAS_CLMA0CTL                                CLMA0_CTL
#define RENESAS_CLMA0CMPL                               CLMA0_CMPL
#define RENESAS_CLMA0CMPH                               CLMA0_CMPH
#define RENESAS_CLMA1CTL                                CLMA1_CTL
#define RENESAS_CLMA1CMPL                               CLMA1_CMPL
#define RENESAS_CLMA1CMPH                               CLMA1_CMPH
#define RENESAS_CLMA2CTL                                CLMA2_CTL
#define RENESAS_CLMA2CMPL                               CLMA2_CMPL
#define RENESAS_CLMA2CMPH                               CLMA2_CMPH
#define RENESAS_CLMA3CTL                                CLMA3_CTL
#define RENESAS_CLMA3CMPL                               CLMA3_CMPL
#define RENESAS_CLMA3CMPH                               CLMA3_CMPH
#define RENESAS_CLMA5CTL                                CLMA5_CTL
#define RENESAS_CLMA5CMPL                               CLMA5_CMPL
#define RENESAS_CLMA5CMPH                               CLMA5_CMPH
#define RENESAS_CLMA6CTL                                CLMA6_CTL
#define RENESAS_CLMA6CMPL                               CLMA6_CMPL
#define RENESAS_CLMA6CMPH                               CLMA6_CMPH
#define RENESAS_MOSCS                                   SYSCTRL_MOSCS
#define RENESAS_CLKKCPROT1                              SYSCTRL_CLKKCPROT1
#define RENESAS_ECMEPCFG                                ECM_EPCFG
#define RENESAS_ECMIRCFG0                               ECM_IRCFG0
#define RENESAS_ECMIRCFG1                               ECM_IRCFG1
#define RENESAS_ECMIRCFG2                               ECM_IRCFG2
#define RENESAS_ECMIRCFG3                               ECM_IRCFG3
#define RENESAS_ECMIRCFG4                               ECM_IRCFG4
#define RENESAS_ECMIRCFG5                               ECM_IRCFG5
#define RENESAS_ECMIRCFG6                               ECM_IRCFG6
#define RENESAS_ECMIRCFG7                               ECM_IRCFG7
#define RENESAS_ECMIRCFG8                               ECM_IRCFG8
#define RENESAS_ECMIRCFG9                               ECM_IRCFG9
#define RENESAS_ECMEMK0                                 ECM_EMK0
#define RENESAS_ECMEMK1                                 ECM_EMK1
#define RENESAS_ECMEMK2                                 ECM_EMK2
#define RENESAS_ECMEMK3                                 ECM_EMK3
#define RENESAS_ECMEMK4                                 ECM_EMK4
#define RENESAS_ECMEMK5                                 ECM_EMK5
#define RENESAS_ECMEMK6                                 ECM_EMK6
#define RENESAS_ECMEMK7                                 ECM_EMK7
#define RENESAS_ECMEMK8                                 ECM_EMK8
#define RENESAS_ECMEMK9                                 ECM_EMK9
#define RENESAS_ECMESSTC0                               ECM_ESSTC0
#define RENESAS_ECMESSTC1                               ECM_ESSTC1
#define RENESAS_ECMDTMCTL                               ECM_DTMCTL
#define RENESAS_ECMDTMR                                 ECM_DTMR
#define RENESAS_ECMDTMCMP                               ECM_DTMCMP
#define RENESAS_ECMEOCCFG                               ECM_EOCCFG
#define RENESAS_ECMPEM                                  ECM_PEM
#define RENESAS_ECMMECLR                                ECMM_ECLR
#define RENESAS_ECMCECLR                                ECMC_ECLR
#define RENESAS_ECMMESSTR9                              ECMM_ESSTR9
#define RENESAS_ECMCESSTR9                              ECMC_ESSTR9
#define RENESAS_ECMCESSTR0                              ECMC_ESSTR0

#define RENESAS_CR_SSTCLR                               MECCCAP_CRAM_CR_SSTCLRLL
#define RENESAS_CR_DSTCLR                               MECCCAP_CRAM_CR_DSTCLRLL
#define RENESAS_CR_SERSTR                               MECCCAP_CRAM_CR_SERSTRLL
#define RENESAS_CR_DERSTR                               MECCCAP_CRAM_CR_DERSTRLL
#define RENESAS_CR_OVFSTR                               MECCCAP_CRAM_CR_OVFSTR
#define RENESAS_CR_OVFCLR                               MECCCAP_CRAM_CR_OVFCLR

#define RENESAS_LR0_SERSTR_PE0                          MECCCAP_LR_PE0CL0_LR0_SERSTR
#define RENESAS_LR0_DERSTR_PE0                          MECCCAP_LR_PE0CL0_LR0_DERSTR
#define RENESAS_LR0_SSTCLR_PE0                          MECCCAP_LR_PE0CL0_LR0_SSTCLR
#define RENESAS_LR0_DSTCLR_PE0                          MECCCAP_LR_PE0CL0_LR0_DSTCLR
#define RENESAS_LR0_OVFSTR_PE0                          MECCCAP_LR_PE0CL0_LR0_OVFSTR
#define RENESAS_LR0_OVFCLR_PE0                          MECCCAP_LR_PE0CL0_LR0_OVFCLR

#define RENESAS_LR0_SERSTR_PE1                          MECCCAP_LR_PE1CL0_LR0_SERSTR
#define RENESAS_LR0_DERSTR_PE1                          MECCCAP_LR_PE1CL0_LR0_DERSTR
#define RENESAS_LR0_SSTCLR_PE1                          MECCCAP_LR_PE1CL0_LR0_SSTCLR
#define RENESAS_LR0_DSTCLR_PE1                          MECCCAP_LR_PE1CL0_LR0_DSTCLR
#define RENESAS_LR0_OVFSTR_PE1                          MECCCAP_LR_PE1CL0_LR0_OVFSTR
#define RENESAS_LR0_OVFCLR_PE1                          MECCCAP_LR_PE1CL0_LR0_OVFCLR

#define RENESAS_LR0_SERSTR_PE2                          MECCCAP_LR_PE2CL1_LR0_SERSTR
#define RENESAS_LR0_DERSTR_PE2                          MECCCAP_LR_PE2CL1_LR0_DERSTR
#define RENESAS_LR0_SSTCLR_PE2                          MECCCAP_LR_PE2CL1_LR0_SSTCLR
#define RENESAS_LR0_DSTCLR_PE2                          MECCCAP_LR_PE2CL1_LR0_DSTCLR
#define RENESAS_LR0_OVFSTR_PE2                          MECCCAP_LR_PE2CL1_LR0_OVFSTR
#define RENESAS_LR0_OVFCLR_PE2                          MECCCAP_LR_PE2CL1_LR0_OVFCLR

#define RENESAS_LR0_SERSTR_PE3                          MECCCAP_LR_PE3CL1_LR0_SERSTR
#define RENESAS_LR0_DERSTR_PE3                          MECCCAP_LR_PE3CL1_LR0_DERSTR
#define RENESAS_LR0_SSTCLR_PE3                          MECCCAP_LR_PE3CL1_LR0_SSTCLR
#define RENESAS_LR0_DSTCLR_PE3                          MECCCAP_LR_PE3CL1_LR0_DSTCLR
#define RENESAS_LR0_OVFSTR_PE3                          MECCCAP_LR_PE3CL1_LR0_OVFSTR
#define RENESAS_LR0_OVFCLR_PE3                          MECCCAP_LR_PE3CL1_LR0_OVFCLR

#define RENESAS_LR1_SERSTR                              MECCCAP_LRA_LR1_SERSTR
#define RENESAS_LR1_DERSTR                              MECCCAP_LRA_LR1_DERSTR
#define RENESAS_LR1_SSTCLR                              MECCCAP_LRA_LR1_SSTCLR
#define RENESAS_LR1_DSTCLR                              MECCCAP_LRA_LR1_DSTCLR
#define RENESAS_LR1_OVFSTR                              MECCCAP_LRA_LR1_OVFSTR
#define RENESAS_LR1_OVFCLR                              MECCCAP_LRA_LR1_OVFCLR

#define RENESAS_ECCKCPROT                               ECCKCPROT_KCPROT
#define RENESAS_LRECCCTL                                ECCCNT_LR_PE0CL0_LRECCCTL
#define RENESAS_CR_ERRINT                               MECCCAP_CRAM_CR_ERRINT

#define RENESAS_CRAECCCTL                               ECCCNT_CRA_CRAECCCTL

#define RENESAS_VMONF                                   VMON_F
#define RENESAS_VMONFC                                  VMON_FC
#define RENESAS_VMONDIAGMEW                             VMON_DIAGMEW
#define RENESAS_VMONMASK                                VMON_DMASK
#define RENESAS_VMONDIAG                                VMON_DIAG
#define RENESAS_VCCDE                                   VMON_VCCDE
#define RENESAS_VMONKCPROT                              VMON_KCPROT

#define RENESAS_DMONF                                   DMON_F
#define RENESAS_DMONFC                                  DMON_FC
#define RENESAS_DMONDIAGMEW                             DMON_DIAGMEW
#define RENESAS_DMONDIAG                                DMON_DIAG
#define RENESAS_DMONDE                                  DMON_DE
#define RENESAS_DMONFCR                                 DMON_FCR
#define RENESAS_DMONKCPROT0                             DMON_KCPROT0
#define RENESAS_DMONTEST                                DMON_TEST
#define RENESAS_DMONKCPROT2                             DMON_KCPROT2

/* not exist device header file */
#define RENESAS_OPBT4                                   0xFF320090

/* add for U2A */
#define RENESAS_AWOVDDDE                                VMON_AWOVDDDE
#define RENESAS_AWOVDDFCR                               VMON_AWOVDDFCR
#define RENESAS_CKSC_AADCC                              SYSCTRL_CKSC_AADCC
#define RENESAS_CKSC_AADCS                              SYSCTRL_CKSC_AADCS
#define RENESAS_CKSC_ADCC                               SYSCTRL_CKSC_ADCC
#define RENESAS_CKSC_ADCS                               SYSCTRL_CKSC_ADCS
#define RENESAS_CKSC_ARTCAC                             SYSCTRL_CKSC_ARTCAC
#define RENESAS_CKSC_ARTCAS                             SYSCTRL_CKSC_ARTCAS
#define RENESAS_CKSC_ATAUJC                             SYSCTRL_CKSC_ATAUJC
#define RENESAS_CKSC_ATAUJS                             SYSCTRL_CKSC_ATAUJS
#define RENESAS_CKSC_AWDTC                              SYSCTRL_CKSC_AWDTC
#define RENESAS_CKSC_AWDTS                              SYSCTRL_CKSC_AWDTS
#define RENESAS_CKSC_CPUC                               SYSCTRL_CKSC_CPUC
#define RENESAS_CKSC_CPUS                               SYSCTRL_CKSC_CPUS
#define RENESAS_CKSC_FOUT0C                             SYSCTRL_CKSC_FOUT0C
#define RENESAS_CKSC_FOUT0S                             SYSCTRL_CKSC_FOUT0S
#define RENESAS_CKSC_FOUT1C                             SYSCTRL_CKSC_FOUT1C
#define RENESAS_CKSC_FOUT1S                             SYSCTRL_CKSC_FOUT1S
#define RENESAS_CKSC_MSPIC                              SYSCTRL_CKSC_MSPIC
#define RENESAS_CKSC_MSPIS                              SYSCTRL_CKSC_MSPIS
#define RENESAS_CKSC_RCANC                              SYSCTRL_CKSC_RCANC
#define RENESAS_CKSC_RCANS                              SYSCTRL_CKSC_RCANS
#define RENESAS_CKSC_RLINC                              SYSCTRL_CKSC_RLINC
#define RENESAS_CKSC_RLINS                              SYSCTRL_CKSC_RLINS
#define RENESAS_CKSC_WDTC                               SYSCTRL_CKSC_WDTC
#define RENESAS_CKSC_WDTS                               SYSCTRL_CKSC_WDTS
#define RENESAS_CLKD_AADCC                              SYSCTRL_CLKD_AADCC
#define RENESAS_CLKD_AADCS                              SYSCTRL_CLKD_AADCS
#define RENESAS_CLKD_FOUT0C                             SYSCTRL_CLKD_FOUT0C
#define RENESAS_CLKD_FOUT0S                             SYSCTRL_CLKD_FOUT0S
#define RENESAS_CLKD_FOUT1C                             SYSCTRL_CLKD_FOUT1C
#define RENESAS_CLKD_FOUT1S                             SYSCTRL_CLKD_FOUT1S
#define RENESAS_CLKD_PLLC                               SYSCTRL_CLKD_PLLC
#define RENESAS_CLKD_PLLS                               SYSCTRL_CLKD_PLLS
#define RENESAS_CLMA4CMPH                               CLMA4_CMPH
#define RENESAS_CLMA4CMPL                               CLMA4_CMPL
#define RENESAS_CLMA4CTL                                CLMA4_CTL
#define RENESAS_CLMA7CMPH                               CLMA7_CMPH
#define RENESAS_CLMA7CMPL                               CLMA7_CMPL
#define RENESAS_CLMA7CTL                                CLMA7_CTL
#define RENESAS_CLMA8CMPH                               CLMA8_CMPH
#define RENESAS_CLMA8CMPL                               CLMA8_CMPL
#define RENESAS_CLMA8CTL                                CLMA8_CTL
#define RENESAS_CLMA9CMPH                               CLMA9_CMPH
#define RENESAS_CLMA9CMPL                               CLMA9_CMPL
#define RENESAS_CLMA9CTL                                CLMA9_CTL
#define RENESAS_CLMATEST                                CLMAC_CLMATEST
#define RENESAS_DMONDIAGME                              DMON_DIAGME
#define RENESAS_DMONDMASK                               DMON_DMASK
#define RENESAS_E0VCCDE                                 VMON_E0VCCDE
#define RENESAS_E0VCCFCR                                VMON_E0VCCFCR
#define RENESAS_ECMCECLR0                               ECMC_ECLR0
#define RENESAS_ECMDTMCFG0                              ECM_DTMCFG0
#define RENESAS_ECMDTMCFG1                              ECM_DTMCFG1
#define RENESAS_ECMDTMCFG2                              ECM_DTMCFG2
#define RENESAS_ECMDTMCFG3                              ECM_DTMCFG3
#define RENESAS_ECMETCCFG0                              ECM_ETCCFG0
#define RENESAS_ECMETMK000                              ECM_ETMK0_0
#define RENESAS_ECMETMK100                              ECM_ETMK1_0
#define RENESAS_ECMETMK200                              ECM_ETMK2_0
#define RENESAS_ECMETMK300                              ECM_ETMK3_0
#define RENESAS_ECMINCFG000                             ECM_INCFG0_0
#define RENESAS_ECMINCFG100                             ECM_INCFG1_0
#define RENESAS_ECMINCFG200                             ECM_INCFG2_0
#define RENESAS_ECMINCFG300                             ECM_INCFG3_0
#define RENESAS_ECMISCFG0                               ECM_ISCFG0
#define RENESAS_ECMMECLR0                               ECMM_ECLR0
#define RENESAS_ECMMESSTR10                             ECMM_ESSTR10
#define RENESAS_ECMMESSTR8                              ECMM_ESSTR8
#define RENESAS_HSOSCS                                  SYSCTRL_HSOSCS
#define RENESAS_HSOSCSTPM                               SYSCTRL_HSOSCSTPM
#define RENESAS_ISOVDDDE                                VMON_ISOVDDDE
#define RENESAS_ISOVDDFCR                               VMON_ISOVDDFCR
#define RENESAS_MOSCE                                   SYSCTRL_MOSCE
#define RENESAS_MOSCSTPM                                SYSCTRL_MOSCSTPM
#define RENESAS_PLLE                                    SYSCTRL_PLLE
#define RENESAS_PLLS                                    SYSCTRL_PLLS
#define RENESAS_PLLSTPM                                 SYSCTRL_PLLSTPM
#define RENESAS_PPR_ERROUTZ0                            PORT0_PPR0
#define RENESAS_PPR_ERROUTZ1                            PORT0_PPR1
#define RENESAS_PPR_ERROUTZ2                            PORT0_PPR2
#define RENESAS_PPR_ERROUTZ3                            PORT0_PPR3
#define RENESAS_RESKCPROT0                              SYSCTRL_RESKCPROT0
#define RENESAS_STAC_DPRAM                              SYSCTRL_STAC_DPRAM
#define RENESAS_STAC_DTSRAM                             SYSCTRL_STAC_DTSRAM
#define RENESAS_STAC_GTM                                SYSCTRL_STAC_GTM
#define RENESAS_STAC_MSPI                               SYSCTRL_STAC_MSPI
#define RENESAS_STAC_MMCA                               SYSCTRL_STAC_MMCA
#define RENESAS_SWMRESA_ADCJ_AWO                        SYSCTRL_SWMRESA_ADCJ_AWO
#define RENESAS_SWMRESA_ADCJ_ISO                        SYSCTRL_SWMRESA_ADCJ_ISO
#define RENESAS_SWMRESA_ETNB                            SYSCTRL_SWMRESA_ETNB
#define RENESAS_SWMRESA_FLXA                            SYSCTRL_SWMRESA_FLXA
#define RENESAS_SWMRESA_MSPI                            SYSCTRL_SWMRESA_MSPI
#define RENESAS_SWMRESA_OSTM                            SYSCTRL_SWMRESA_OSTM
#define RENESAS_SWMRESA_RSCFD                           SYSCTRL_SWMRESA_RSCFD
#define RENESAS_SWMRESA_RLIN3                           SYSCTRL_SWMRESA_RLIN3
#define RENESAS_SWMRESA_TAUD                            SYSCTRL_SWMRESA_TAUD
#define RENESAS_SWMRESA_TAUJ_AWO                        SYSCTRL_SWMRESA_TAUJ_AWO
#define RENESAS_SWMRESA_TAUJ_ISO                        SYSCTRL_SWMRESA_TAUJ_ISO
#define RENESAS_SWMRESS_ADCJ_AWO                        SYSCTRL_SWMRESS_ADCJ_AWO
#define RENESAS_SWMRESS_ADCJ_ISO                        SYSCTRL_SWMRESS_ADCJ_ISO
#define RENESAS_SWMRESS_ETNB                            SYSCTRL_SWMRESS_ETNB
#define RENESAS_SWMRESS_FLXA                            SYSCTRL_SWMRESS_FLXA
#define RENESAS_SWMRESS_MSPI                            SYSCTRL_SWMRESS_MSPI
#define RENESAS_SWMRESS_OSTM                            SYSCTRL_SWMRESS_OSTM
#define RENESAS_SWMRESS_RSCFD                           SYSCTRL_SWMRESS_RSCFD
#define RENESAS_SWMRESS_RLIN3                           SYSCTRL_SWMRESS_RLIN3
#define RENESAS_SWMRESS_TAUD                            SYSCTRL_SWMRESS_TAUD
#define RENESAS_SWMRESS_TAUJ_AWO                        SYSCTRL_SWMRESS_TAUJ_AWO
#define RENESAS_SWMRESS_TAUJ_ISO                        SYSCTRL_SWMRESS_TAUJ_ISO
#define RENESAS_VCCFCR                                  VMON_VCCFCR
#define RENESAS_VLVF                                    VLVI0_VLVF
#define RENESAS_VLVFC                                   VLVI0_VLVFC
#define RENESAS_VLVIKCPROT                              VLVI0_VLVIKCPROT
#define RENESAS_VMONDIAGFE                              VMON_DIAGFE
#define RENESAS_VMONDIAGME                              VMON_DIAGME
#define RENESAS_VMONDMASK                               VMON_DMASK
#define RENESAS_VMONDSCR                                VMON_DSCR
#define RENESAS_VMONMON                                 VMON_MON
#define RENESAS_VMONOUTF                                VMON_OUTF
#define RENESAS_VMONOUTFC                               VMON_OUTFC

#define RENESAS_EIBD8                                   INTC1_SELF_EIBD8
#define RENESAS_EIBD9                                   INTC1_SELF_EIBD9
#define RENESAS_FIBD0                                   INTC1_SELF_FIBD

/* Wake-Up Factor Registers*/
#define RENESAS_WUF0A0                                  SYSCTRL_WUF0_A0
#define RENESAS_WUF0A1                                  SYSCTRL_WUF0_A1
#define RENESAS_WUF0A2                                  SYSCTRL_WUF0_A2
#define RENESAS_WUF1A0                                  SYSCTRL_WUF1_A0
#define RENESAS_WUF1A1                                  SYSCTRL_WUF1_A1
#define RENESAS_WUF1A2                                  SYSCTRL_WUF1_A2
#define RENESAS_WUF0I0                                  SYSCTRL_WUF0_I0
#define RENESAS_WUF0I1                                  SYSCTRL_WUF0_I1
#define RENESAS_WUF1I0                                  SYSCTRL_WUF1_I0
#define RENESAS_WUF1I1                                  SYSCTRL_WUF1_I1

/* Wakeup Factor Clear registers*/
#define RENESAS_WUFC0A0                                 SYSCTRL_WUFC0_A0
#define RENESAS_WUFC0A1                                 SYSCTRL_WUFC0_A1
#define RENESAS_WUFC0A2                                 SYSCTRL_WUFC0_A2
#define RENESAS_WUFC1A0                                 SYSCTRL_WUFC1_A0
#define RENESAS_WUFC1A1                                 SYSCTRL_WUFC1_A1
#define RENESAS_WUFC1A2                                 SYSCTRL_WUFC1_A2
#define RENESAS_WUFC0I0                                 SYSCTRL_WUFC0_I0
#define RENESAS_WUFC0I1                                 SYSCTRL_WUFC0_I1
#define RENESAS_WUFC1I0                                 SYSCTRL_WUFC1_I0
#define RENESAS_WUFC1I1                                 SYSCTRL_WUFC1_I1

/* Wake-Up Factor Mask Registers */
#define RENESAS_WUFMSK0A0                               SYSCTRL_WUFMSK0_A0
#define RENESAS_WUFMSK0A1                               SYSCTRL_WUFMSK0_A1
#define RENESAS_WUFMSK0A2                               SYSCTRL_WUFMSK0_A2
#define RENESAS_WUFMSK1A0                               SYSCTRL_WUFMSK1_A0
#define RENESAS_WUFMSK1A1                               SYSCTRL_WUFMSK1_A1
#define RENESAS_WUFMSK1A2                               SYSCTRL_WUFMSK1_A2
#define RENESAS_WUFMSK0I0                               SYSCTRL_WUFMSK0_I0
#define RENESAS_WUFMSK0I1                               SYSCTRL_WUFMSK0_I1
#define RENESAS_WUFMSK1I0                               SYSCTRL_WUFMSK1_I0
#define RENESAS_WUFMSK1I1                               SYSCTRL_WUFMSK1_I1

/* Standby Controller Control Registers */
#define RENESAS_WUFMON                                  SYSCTRL_WUFMON
#define RENESAS_STBCKCPROT                              SYSCTRL_STBCKCPROT
#define RENESAS_STBC0STPT                               SYSCTRL_STBC0STPT
#define RENESAS_STBC0PSC                                SYSCTRL_STBC0PSC
#define RENESAS_PWRGD_CNT                               SYSCTRL_PWRGD_CNT
#define RENESAS_IOHOLD0                                 SYSCTRL_IOHOLD0
#define RENESAS_IOHOLD2                                 SYSCTRL_IOHOLD2
/*******************************************************************************
**                         Macros for ICU Driver                              **
*******************************************************************************/

/* U2A add start */
/* IRQ Registers*/
#define RENESAS_ICINTP0                                 INTC2_EIC544
#define RENESAS_ICINTP1                                 INTC2_EIC545
#define RENESAS_ICINTP2                                 INTC2_EIC546
#define RENESAS_ICINTP3                                 INTC2_EIC547
#define RENESAS_ICINTP4                                 INTC2_EIC548
#define RENESAS_ICINTP5                                 INTC2_EIC549
#define RENESAS_ICINTP6                                 INTC2_EIC550
#define RENESAS_ICINTP7                                 INTC2_EIC551
#define RENESAS_ICINTP8                                 INTC2_EIC552
#define RENESAS_ICINTP9                                 INTC2_EIC553
#define RENESAS_ICINTP10                                INTC2_EIC554
#define RENESAS_ICINTP11                                INTC2_EIC555
#define RENESAS_ICINTP12                                INTC2_EIC556
#define RENESAS_ICINTP13                                INTC2_EIC557
#define RENESAS_ICINTP14                                INTC2_EIC558
#define RENESAS_ICINTP15                                INTC2_EIC559
#define RENESAS_ICINTP16                                INTC2_EIC560
#define RENESAS_ICINTP17                                INTC2_EIC561
#define RENESAS_ICINTP18                                INTC2_EIC562
#define RENESAS_ICINTP19                                INTC2_EIC563
#define RENESAS_ICINTP20                                INTC2_EIC564
#define RENESAS_ICINTP21                                INTC2_EIC565
#define RENESAS_ICINTP22                                INTC2_EIC566
#define RENESAS_ICINTP23                                INTC2_EIC567
#define RENESAS_ICINTP24                                INTC2_EIC568
#define RENESAS_ICINTP25                                INTC2_EIC569
#define RENESAS_ICINTP26                                INTC2_EIC570
#define RENESAS_ICINTP27                                INTC2_EIC571
#define RENESAS_ICINTP28                                INTC2_EIC572
#define RENESAS_ICINTP29                                INTC2_EIC573
#define RENESAS_ICINTP30                                INTC2_EIC574
#define RENESAS_ICINTP31                                INTC2_EIC575
#define RENESAS_ICINTP32                                INTC2_EIC576
#define RENESAS_ICINTP33                                INTC2_EIC577
#define RENESAS_ICINTP34                                INTC2_EIC578
#define RENESAS_ICINTP35                                INTC2_EIC579
#define RENESAS_ICINTP36                                INTC2_EIC580
#define RENESAS_ICINTP37                                INTC2_EIC581
#define RENESAS_ICINTP38                                INTC2_EIC582
#define RENESAS_ICINTP39                                INTC2_EIC583

/* Interrupt control registers for TAUD */
#define RENESAS_ICPE0TAUD0I0                            INTC1_PE0_EIC10
#define RENESAS_ICPE1TAUD0I0                            INTC1_PE1_EIC10
#define RENESAS_ICTAUD0I1                               INTC2_EIC376
#define RENESAS_ICPE0TAUD0I2                            INTC1_PE0_EIC11
#define RENESAS_ICPE1TAUD0I2                            INTC1_PE1_EIC11
#define RENESAS_ICTAUD0I3                               INTC2_EIC377
#define RENESAS_ICPE0TAUD0I4                            INTC1_PE0_EIC12
#define RENESAS_ICPE1TAUD0I4                            INTC1_PE1_EIC12
#define RENESAS_ICTAUD0I5                               INTC2_EIC378
#define RENESAS_ICPE0TAUD0I6                            INTC1_PE0_EIC13
#define RENESAS_ICPE1TAUD0I6                            INTC1_PE1_EIC13
#define RENESAS_ICTAUD0I7                               INTC2_EIC379
#define RENESAS_ICPE0TAUD0I8                            INTC1_PE0_EIC23
#define RENESAS_ICPE1TAUD0I8                            INTC1_PE1_EIC23
#define RENESAS_ICTAUD0I9                               INTC2_EIC380
#define RENESAS_ICPE0TAUD0I10                           INTC1_PE0_EIC24
#define RENESAS_ICPE1TAUD0I10                           INTC1_PE1_EIC24
#define RENESAS_ICTAUD0I11                              INTC2_EIC381
#define RENESAS_ICPE0TAUD0I12                           INTC1_PE0_EIC25
#define RENESAS_ICPE1TAUD0I12                           INTC1_PE1_EIC25
#define RENESAS_ICTAUD0I13                              INTC2_EIC382
#define RENESAS_ICPE0TAUD0I14                           INTC1_PE0_EIC26
#define RENESAS_ICPE1TAUD0I14                           INTC1_PE1_EIC26
#define RENESAS_ICTAUD0I15                              INTC2_EIC383
#define RENESAS_ICTAUD1I0                               INTC2_EIC384
#define RENESAS_ICTAUD1I1                               INTC2_EIC385
#define RENESAS_ICTAUD1I2                               INTC2_EIC386
#define RENESAS_ICTAUD1I3                               INTC2_EIC387
#define RENESAS_ICTAUD1I4                               INTC2_EIC388
#define RENESAS_ICTAUD1I5                               INTC2_EIC389
#define RENESAS_ICTAUD1I6                               INTC2_EIC390
#define RENESAS_ICTAUD1I7                               INTC2_EIC391
#define RENESAS_ICTAUD1I8                               INTC2_EIC392
#define RENESAS_ICTAUD1I9                               INTC2_EIC393
#define RENESAS_ICTAUD1I10                              INTC2_EIC394
#define RENESAS_ICTAUD1I11                              INTC2_EIC395
#define RENESAS_ICTAUD1I12                              INTC2_EIC396
#define RENESAS_ICTAUD1I13                              INTC2_EIC397
#define RENESAS_ICTAUD1I14                              INTC2_EIC398
#define RENESAS_ICTAUD1I15                              INTC2_EIC399
#define RENESAS_ICTAUD2I0                               INTC2_EIC400
#define RENESAS_ICTAUD2I1                               INTC2_EIC401
#define RENESAS_ICTAUD2I2                               INTC2_EIC402
#define RENESAS_ICTAUD2I3                               INTC2_EIC403
#define RENESAS_ICTAUD2I4                               INTC2_EIC404
#define RENESAS_ICTAUD2I5                               INTC2_EIC405
#define RENESAS_ICTAUD2I6                               INTC2_EIC406
#define RENESAS_ICTAUD2I7                               INTC2_EIC407
#define RENESAS_ICTAUD2I8                               INTC2_EIC408
#define RENESAS_ICTAUD2I9                               INTC2_EIC409
#define RENESAS_ICTAUD2I10                              INTC2_EIC410
#define RENESAS_ICTAUD2I11                              INTC2_EIC411
#define RENESAS_ICTAUD2I12                              INTC2_EIC412
#define RENESAS_ICTAUD2I13                              INTC2_EIC413
#define RENESAS_ICTAUD2I14                              INTC2_EIC414
#define RENESAS_ICTAUD2I15                              INTC2_EIC415

/* Interrupt control registers for TAUJ */
#define RENESAS_ICTAUJ0I0                               INTC2_EIC360
#define RENESAS_ICTAUJ0I1                               INTC2_EIC361
#define RENESAS_ICTAUJ0I2                               INTC2_EIC362
#define RENESAS_ICTAUJ0I3                               INTC2_EIC363
#define RENESAS_ICTAUJ1I0                               INTC2_EIC364
#define RENESAS_ICTAUJ1I1                               INTC2_EIC365
#define RENESAS_ICTAUJ1I2                               INTC2_EIC366
#define RENESAS_ICTAUJ1I3                               INTC2_EIC367
#define RENESAS_ICTAUJ2I0                               INTC2_EIC368
#define RENESAS_ICTAUJ2I1                               INTC2_EIC369
#define RENESAS_ICTAUJ2I2                               INTC2_EIC370
#define RENESAS_ICTAUJ2I3                               INTC2_EIC371
#define RENESAS_ICTAUJ3I0                               INTC2_EIC372
#define RENESAS_ICTAUJ3I1                               INTC2_EIC373
#define RENESAS_ICTAUJ3I2                               INTC2_EIC374
#define RENESAS_ICTAUJ3I3                               INTC2_EIC375

/* PWM-Diag register addresses for PWBA */
#define RENESAS_PWBA                                    PWBA0_BRS0
/* PWM-Diag register addresses for SLPWG */
#define RENESAS_SLPWG                                   SLPWG_C0
/* PWM-Diag register addresses for PWSD */
#define RENESAS_PWSD                                    PWSD0_CTL
/* PWM-Diag register addresses for PWGC_INTF */
#define RENESAS_PWGC_INTF                               PWGC_INTF_PWGCINTF00

/* Interrupt PWGC Interrupt Connection */
#define RENESAS_INTPWGCG00                              INTC2_EIC660
#define RENESAS_INTPWGCG01                              INTC2_EIC661
#define RENESAS_INTPWGCG02                              INTC2_EIC662

#define RENESAS_INTPWGCG10                              INTC2_EIC663
#define RENESAS_INTPWGCG11                              INTC2_EIC664
#define RENESAS_INTPWGCG12                              INTC2_EIC665

#define RENESAS_INTPWGCG20                              INTC2_EIC666
#define RENESAS_INTPWGCG21                              INTC2_EIC667
#define RENESAS_INTPWGCG22                              INTC2_EIC668

#define RENESAS_INTPWGCG30                              INTC2_EIC669
#define RENESAS_INTPWGCG31                              INTC2_EIC670
#define RENESAS_INTPWGCG32                              INTC2_EIC671

/* Base address of PWGCn*/
#define RENESAS_PWGC0CSDR                               PWGC0_CSDR
#define RENESAS_PWGC1CSDR                               PWGC1_CSDR
#define RENESAS_PWGC2CSDR                               PWGC2_CSDR
#define RENESAS_PWGC3CSDR                               PWGC3_CSDR
#define RENESAS_PWGC4CSDR                               PWGC4_CSDR
#define RENESAS_PWGC5CSDR                               PWGC5_CSDR
#define RENESAS_PWGC6CSDR                               PWGC6_CSDR
#define RENESAS_PWGC7CSDR                               PWGC7_CSDR
#define RENESAS_PWGC8CSDR                               PWGC8_CSDR
#define RENESAS_PWGC9CSDR                               PWGC9_CSDR
#define RENESAS_PWGC10CSDR                              PWGC10_CSDR
#define RENESAS_PWGC11CSDR                              PWGC11_CSDR
#define RENESAS_PWGC12CSDR                              PWGC12_CSDR
#define RENESAS_PWGC13CSDR                              PWGC13_CSDR
#define RENESAS_PWGC14CSDR                              PWGC14_CSDR
#define RENESAS_PWGC15CSDR                              PWGC15_CSDR
#define RENESAS_PWGC16CSDR                              PWGC16_CSDR
#define RENESAS_PWGC17CSDR                              PWGC17_CSDR
#define RENESAS_PWGC18CSDR                              PWGC18_CSDR
#define RENESAS_PWGC19CSDR                              PWGC19_CSDR
#define RENESAS_PWGC20CSDR                              PWGC20_CSDR
#define RENESAS_PWGC21CSDR                              PWGC21_CSDR
#define RENESAS_PWGC22CSDR                              PWGC22_CSDR
#define RENESAS_PWGC23CSDR                              PWGC23_CSDR
#define RENESAS_PWGC24CSDR                              PWGC24_CSDR
#define RENESAS_PWGC25CSDR                              PWGC25_CSDR
#define RENESAS_PWGC26CSDR                              PWGC26_CSDR
#define RENESAS_PWGC27CSDR                              PWGC27_CSDR
#define RENESAS_PWGC28CSDR                              PWGC28_CSDR
#define RENESAS_PWGC29CSDR                              PWGC29_CSDR
#define RENESAS_PWGC30CSDR                              PWGC30_CSDR
#define RENESAS_PWGC31CSDR                              PWGC31_CSDR
#define RENESAS_PWGC32CSDR                              PWGC32_CSDR
#define RENESAS_PWGC33CSDR                              PWGC33_CSDR
#define RENESAS_PWGC34CSDR                              PWGC34_CSDR
#define RENESAS_PWGC35CSDR                              PWGC35_CSDR
#define RENESAS_PWGC36CSDR                              PWGC36_CSDR
#define RENESAS_PWGC37CSDR                              PWGC37_CSDR
#define RENESAS_PWGC38CSDR                              PWGC38_CSDR
#define RENESAS_PWGC39CSDR                              PWGC39_CSDR
#define RENESAS_PWGC40CSDR                              PWGC40_CSDR
#define RENESAS_PWGC41CSDR                              PWGC41_CSDR
#define RENESAS_PWGC42CSDR                              PWGC42_CSDR
#define RENESAS_PWGC43CSDR                              PWGC43_CSDR
#define RENESAS_PWGC44CSDR                              PWGC44_CSDR
#define RENESAS_PWGC45CSDR                              PWGC45_CSDR
#define RENESAS_PWGC46CSDR                              PWGC46_CSDR
#define RENESAS_PWGC47CSDR                              PWGC47_CSDR
#define RENESAS_PWGC48CSDR                              PWGC48_CSDR
#define RENESAS_PWGC49CSDR                              PWGC49_CSDR
#define RENESAS_PWGC50CSDR                              PWGC50_CSDR
#define RENESAS_PWGC51CSDR                              PWGC51_CSDR
#define RENESAS_PWGC52CSDR                              PWGC52_CSDR
#define RENESAS_PWGC53CSDR                              PWGC53_CSDR
#define RENESAS_PWGC54CSDR                              PWGC54_CSDR
#define RENESAS_PWGC55CSDR                              PWGC55_CSDR
#define RENESAS_PWGC56CSDR                              PWGC56_CSDR
#define RENESAS_PWGC57CSDR                              PWGC57_CSDR
#define RENESAS_PWGC58CSDR                              PWGC58_CSDR
#define RENESAS_PWGC59CSDR                              PWGC59_CSDR
#define RENESAS_PWGC60CSDR                              PWGC60_CSDR
#define RENESAS_PWGC61CSDR                              PWGC61_CSDR
#define RENESAS_PWGC62CSDR                              PWGC62_CSDR
#define RENESAS_PWGC63CSDR                              PWGC63_CSDR
#define RENESAS_PWGC64CSDR                              PWGC64_CSDR
#define RENESAS_PWGC65CSDR                              PWGC65_CSDR
#define RENESAS_PWGC66CSDR                              PWGC66_CSDR
#define RENESAS_PWGC67CSDR                              PWGC67_CSDR
#define RENESAS_PWGC68CSDR                              PWGC68_CSDR
#define RENESAS_PWGC69CSDR                              PWGC69_CSDR
#define RENESAS_PWGC70CSDR                              PWGC70_CSDR
#define RENESAS_PWGC71CSDR                              PWGC71_CSDR
#define RENESAS_PWGC72CSDR                              PWGC72_CSDR
#define RENESAS_PWGC73CSDR                              PWGC73_CSDR
#define RENESAS_PWGC74CSDR                              PWGC74_CSDR
#define RENESAS_PWGC75CSDR                              PWGC75_CSDR
#define RENESAS_PWGC76CSDR                              PWGC76_CSDR
#define RENESAS_PWGC77CSDR                              PWGC77_CSDR
#define RENESAS_PWGC78CSDR                              PWGC78_CSDR
#define RENESAS_PWGC79CSDR                              PWGC79_CSDR
#define RENESAS_PWGC80CSDR                              PWGC80_CSDR
#define RENESAS_PWGC81CSDR                              PWGC81_CSDR
#define RENESAS_PWGC82CSDR                              PWGC82_CSDR
#define RENESAS_PWGC83CSDR                              PWGC83_CSDR
#define RENESAS_PWGC84CSDR                              PWGC84_CSDR
#define RENESAS_PWGC85CSDR                              PWGC85_CSDR
#define RENESAS_PWGC86CSDR                              PWGC86_CSDR
#define RENESAS_PWGC87CSDR                              PWGC87_CSDR
#define RENESAS_PWGC88CSDR                              PWGC88_CSDR
#define RENESAS_PWGC89CSDR                              PWGC89_CSDR
#define RENESAS_PWGC90CSDR                              PWGC90_CSDR
#define RENESAS_PWGC91CSDR                              PWGC91_CSDR
#define RENESAS_PWGC92CSDR                              PWGC92_CSDR
#define RENESAS_PWGC93CSDR                              PWGC93_CSDR
#define RENESAS_PWGC94CSDR                              PWGC94_CSDR
#define RENESAS_PWGC95CSDR                              PWGC95_CSDR

/* Base address of the TAUD0 registers structure */
#define RENESAS_TAUD0CNT0                               TAUD0_CNT0
#define RENESAS_TAUD0CNT1                               TAUD0_CNT1
#define RENESAS_TAUD0CNT2                               TAUD0_CNT2
#define RENESAS_TAUD0CNT3                               TAUD0_CNT3
#define RENESAS_TAUD0CNT4                               TAUD0_CNT4
#define RENESAS_TAUD0CNT5                               TAUD0_CNT5
#define RENESAS_TAUD0CNT6                               TAUD0_CNT6
#define RENESAS_TAUD0CNT7                               TAUD0_CNT7
#define RENESAS_TAUD0CNT8                               TAUD0_CNT8
#define RENESAS_TAUD0CNT9                               TAUD0_CNT9
#define RENESAS_TAUD0CNT10                              TAUD0_CNT10
#define RENESAS_TAUD0CNT11                              TAUD0_CNT11
#define RENESAS_TAUD0CNT12                              TAUD0_CNT12
#define RENESAS_TAUD0CNT13                              TAUD0_CNT13
#define RENESAS_TAUD0CNT14                              TAUD0_CNT14
#define RENESAS_TAUD0CNT15                              TAUD0_CNT15

/* Base address of the TAUD1 registers structure */
#define RENESAS_TAUD1CNT0                               TAUD1_CNT0
#define RENESAS_TAUD1CNT1                               TAUD1_CNT1
#define RENESAS_TAUD1CNT2                               TAUD1_CNT2
#define RENESAS_TAUD1CNT3                               TAUD1_CNT3
#define RENESAS_TAUD1CNT4                               TAUD1_CNT4
#define RENESAS_TAUD1CNT5                               TAUD1_CNT5
#define RENESAS_TAUD1CNT6                               TAUD1_CNT6
#define RENESAS_TAUD1CNT7                               TAUD1_CNT7
#define RENESAS_TAUD1CNT8                               TAUD1_CNT8
#define RENESAS_TAUD1CNT9                               TAUD1_CNT9
#define RENESAS_TAUD1CNT10                              TAUD1_CNT10
#define RENESAS_TAUD1CNT11                              TAUD1_CNT11
#define RENESAS_TAUD1CNT12                              TAUD1_CNT12
#define RENESAS_TAUD1CNT13                              TAUD1_CNT13
#define RENESAS_TAUD1CNT14                              TAUD1_CNT14
#define RENESAS_TAUD1CNT15                              TAUD1_CNT15

/* Base address of the TAUD2 registers structure */
#define RENESAS_TAUD2CNT0                               TAUD2_CNT0
#define RENESAS_TAUD2CNT1                               TAUD2_CNT1
#define RENESAS_TAUD2CNT2                               TAUD2_CNT2
#define RENESAS_TAUD2CNT3                               TAUD2_CNT3
#define RENESAS_TAUD2CNT4                               TAUD2_CNT4
#define RENESAS_TAUD2CNT5                               TAUD2_CNT5
#define RENESAS_TAUD2CNT6                               TAUD2_CNT6
#define RENESAS_TAUD2CNT7                               TAUD2_CNT7
#define RENESAS_TAUD2CNT8                               TAUD2_CNT8
#define RENESAS_TAUD2CNT9                               TAUD2_CNT9
#define RENESAS_TAUD2CNT10                              TAUD2_CNT10
#define RENESAS_TAUD2CNT11                              TAUD2_CNT11
#define RENESAS_TAUD2CNT12                              TAUD2_CNT12
#define RENESAS_TAUD2CNT13                              TAUD2_CNT13
#define RENESAS_TAUD2CNT14                              TAUD2_CNT14
#define RENESAS_TAUD2CNT15                              TAUD2_CNT15

/* Base address of the TAUJ0 registers structure */
#define RENESAS_TAUJ0CNT0                               TAUJ0_CNT0
#define RENESAS_TAUJ0CNT1                               TAUJ0_CNT1
#define RENESAS_TAUJ0CNT2                               TAUJ0_CNT2
#define RENESAS_TAUJ0CNT3                               TAUJ0_CNT3

/* Base address of the TAUJ1 registers structure */
#define RENESAS_TAUJ1CNT0                               TAUJ1_CNT0
#define RENESAS_TAUJ1CNT1                               TAUJ1_CNT1
#define RENESAS_TAUJ1CNT2                               TAUJ1_CNT2
#define RENESAS_TAUJ1CNT3                               TAUJ1_CNT3

/* Base address of the TAUJ2 registers structure */
#define RENESAS_TAUJ2CNT0                               TAUJ2_CNT0
#define RENESAS_TAUJ2CNT1                               TAUJ2_CNT1
#define RENESAS_TAUJ2CNT2                               TAUJ2_CNT2
#define RENESAS_TAUJ2CNT3                               TAUJ2_CNT3

/* Base address of the TAUJ3 registers structure */
#define RENESAS_TAUJ3CNT0                               TAUJ3_CNT0
#define RENESAS_TAUJ3CNT1                               TAUJ3_CNT1
#define RENESAS_TAUJ3CNT2                               TAUJ3_CNT2
#define RENESAS_TAUJ3CNT3                               TAUJ3_CNT3

/* Base address of the TAUD Unit user control registers structure */
#define RENESAS_TAUD0TOL                                TAUD0_TOL
#define RENESAS_TAUD1TOL                                TAUD1_TOL
#define RENESAS_TAUD2TOL                                TAUD2_TOL

/* Base address of the TAUD Unit OS control registers structure */
#define RENESAS_TAUD0TPS                                TAUD0_TPS
#define RENESAS_TAUD1TPS                                TAUD1_TPS
#define RENESAS_TAUD2TPS                                TAUD2_TPS

/* Base address of the TAUJ Unit user control registers structure */
#define RENESAS_TAUJ0TE                                 TAUJ0_TE
#define RENESAS_TAUJ1TE                                 TAUJ1_TE
#define RENESAS_TAUJ2TE                                 TAUJ2_TE
#define RENESAS_TAUJ3TE                                 TAUJ3_TE

/* Base address of the TAUJ Unit OS control registers structure */
#define RENESAS_TAUJ0TPS                                TAUJ0_TPS
#define RENESAS_TAUJ1TPS                                TAUJ1_TPS
#define RENESAS_TAUJ2TPS                                TAUJ2_TPS
#define RENESAS_TAUJ3TPS                                TAUJ3_TPS


/*******************************************************************************
**                 Macros for GPT                                             **
*******************************************************************************/

/* TAUD register */
#define RENESAS_TAUD0CDR0                               TAUD0_CDR0
#define RENESAS_TAUD0CDR1                               TAUD0_CDR1
#define RENESAS_TAUD0CDR2                               TAUD0_CDR2
#define RENESAS_TAUD0CDR3                               TAUD0_CDR3
#define RENESAS_TAUD0CDR4                               TAUD0_CDR4
#define RENESAS_TAUD0CDR5                               TAUD0_CDR5
#define RENESAS_TAUD0CDR6                               TAUD0_CDR6
#define RENESAS_TAUD0CDR7                               TAUD0_CDR7
#define RENESAS_TAUD0CDR8                               TAUD0_CDR8
#define RENESAS_TAUD0CDR9                               TAUD0_CDR9
#define RENESAS_TAUD0CDR10                              TAUD0_CDR10
#define RENESAS_TAUD0CDR11                              TAUD0_CDR11
#define RENESAS_TAUD0CDR12                              TAUD0_CDR12
#define RENESAS_TAUD0CDR13                              TAUD0_CDR13
#define RENESAS_TAUD0CDR14                              TAUD0_CDR14
#define RENESAS_TAUD0CDR15                              TAUD0_CDR15
#define RENESAS_TAUD1CDR0                               TAUD1_CDR0
#define RENESAS_TAUD1CDR1                               TAUD1_CDR1
#define RENESAS_TAUD1CDR2                               TAUD1_CDR2
#define RENESAS_TAUD1CDR3                               TAUD1_CDR3
#define RENESAS_TAUD1CDR4                               TAUD1_CDR4
#define RENESAS_TAUD1CDR5                               TAUD1_CDR5
#define RENESAS_TAUD1CDR6                               TAUD1_CDR6
#define RENESAS_TAUD1CDR7                               TAUD1_CDR7
#define RENESAS_TAUD1CDR8                               TAUD1_CDR8
#define RENESAS_TAUD1CDR9                               TAUD1_CDR9
#define RENESAS_TAUD1CDR10                              TAUD1_CDR10
#define RENESAS_TAUD1CDR11                              TAUD1_CDR11
#define RENESAS_TAUD1CDR12                              TAUD1_CDR12
#define RENESAS_TAUD1CDR13                              TAUD1_CDR13
#define RENESAS_TAUD1CDR14                              TAUD1_CDR14
#define RENESAS_TAUD1CDR15                              TAUD1_CDR15
#define RENESAS_TAUD2CDR0                               TAUD2_CDR0
#define RENESAS_TAUD2CDR1                               TAUD2_CDR1
#define RENESAS_TAUD2CDR2                               TAUD2_CDR2
#define RENESAS_TAUD2CDR3                               TAUD2_CDR3
#define RENESAS_TAUD2CDR4                               TAUD2_CDR4
#define RENESAS_TAUD2CDR5                               TAUD2_CDR5
#define RENESAS_TAUD2CDR6                               TAUD2_CDR6
#define RENESAS_TAUD2CDR7                               TAUD2_CDR7
#define RENESAS_TAUD2CDR8                               TAUD2_CDR8
#define RENESAS_TAUD2CDR9                               TAUD2_CDR9
#define RENESAS_TAUD2CDR10                              TAUD2_CDR10
#define RENESAS_TAUD2CDR11                              TAUD2_CDR11
#define RENESAS_TAUD2CDR12                              TAUD2_CDR12
#define RENESAS_TAUD2CDR13                              TAUD2_CDR13
#define RENESAS_TAUD2CDR14                              TAUD2_CDR14
#define RENESAS_TAUD2CDR15                              TAUD2_CDR15
#define RENESAS_TAUD0CMOR0                              TAUD0_CMOR0
#define RENESAS_TAUD0CMOR1                              TAUD0_CMOR1
#define RENESAS_TAUD0CMOR2                              TAUD0_CMOR2
#define RENESAS_TAUD0CMOR3                              TAUD0_CMOR3
#define RENESAS_TAUD0CMOR4                              TAUD0_CMOR4
#define RENESAS_TAUD0CMOR5                              TAUD0_CMOR5
#define RENESAS_TAUD0CMOR6                              TAUD0_CMOR6
#define RENESAS_TAUD0CMOR7                              TAUD0_CMOR7
#define RENESAS_TAUD0CMOR8                              TAUD0_CMOR8
#define RENESAS_TAUD0CMOR9                              TAUD0_CMOR9
#define RENESAS_TAUD0CMOR10                             TAUD0_CMOR10
#define RENESAS_TAUD0CMOR11                             TAUD0_CMOR11
#define RENESAS_TAUD0CMOR12                             TAUD0_CMOR12
#define RENESAS_TAUD0CMOR13                             TAUD0_CMOR13
#define RENESAS_TAUD0CMOR14                             TAUD0_CMOR14
#define RENESAS_TAUD0CMOR15                             TAUD0_CMOR15
#define RENESAS_TAUD1CMOR0                              TAUD1_CMOR0
#define RENESAS_TAUD1CMOR1                              TAUD1_CMOR1
#define RENESAS_TAUD1CMOR2                              TAUD1_CMOR2
#define RENESAS_TAUD1CMOR3                              TAUD1_CMOR3
#define RENESAS_TAUD1CMOR4                              TAUD1_CMOR4
#define RENESAS_TAUD1CMOR5                              TAUD1_CMOR5
#define RENESAS_TAUD1CMOR6                              TAUD1_CMOR6
#define RENESAS_TAUD1CMOR7                              TAUD1_CMOR7
#define RENESAS_TAUD1CMOR8                              TAUD1_CMOR8
#define RENESAS_TAUD1CMOR9                              TAUD1_CMOR9
#define RENESAS_TAUD1CMOR10                             TAUD1_CMOR10
#define RENESAS_TAUD1CMOR11                             TAUD1_CMOR11
#define RENESAS_TAUD1CMOR12                             TAUD1_CMOR12
#define RENESAS_TAUD1CMOR13                             TAUD1_CMOR13
#define RENESAS_TAUD1CMOR14                             TAUD1_CMOR14
#define RENESAS_TAUD1CMOR15                             TAUD1_CMOR15
#define RENESAS_TAUD2CMOR0                              TAUD2_CMOR0
#define RENESAS_TAUD2CMOR1                              TAUD2_CMOR1
#define RENESAS_TAUD2CMOR2                              TAUD2_CMOR2
#define RENESAS_TAUD2CMOR3                              TAUD2_CMOR3
#define RENESAS_TAUD2CMOR4                              TAUD2_CMOR4
#define RENESAS_TAUD2CMOR5                              TAUD2_CMOR5
#define RENESAS_TAUD2CMOR6                              TAUD2_CMOR6
#define RENESAS_TAUD2CMOR7                              TAUD2_CMOR7
#define RENESAS_TAUD2CMOR8                              TAUD2_CMOR8
#define RENESAS_TAUD2CMOR9                              TAUD2_CMOR9
#define RENESAS_TAUD2CMOR10                             TAUD2_CMOR10
#define RENESAS_TAUD2CMOR11                             TAUD2_CMOR11
#define RENESAS_TAUD2CMOR12                             TAUD2_CMOR12
#define RENESAS_TAUD2CMOR13                             TAUD2_CMOR13
#define RENESAS_TAUD2CMOR14                             TAUD2_CMOR14
#define RENESAS_TAUD2CMOR15                             TAUD2_CMOR15
#define RENESAS_TAUD0TOL0                               TAUD0_TOL
#define RENESAS_TAUD1TOL0                               TAUD1_TOL
#define RENESAS_TAUD2TOL0                               TAUD2_TOL
#define RENESAS_TAUD0TPS0                               TAUD0_TPS
#define RENESAS_TAUD1TPS0                               TAUD1_TPS
#define RENESAS_TAUD2TPS0                               TAUD2_TPS

/* TAUJ register */
#define RENESAS_TAUJ0CDR0                               TAUJ0_CDR0
#define RENESAS_TAUJ0CDR1                               TAUJ0_CDR1
#define RENESAS_TAUJ0CDR2                               TAUJ0_CDR2
#define RENESAS_TAUJ0CDR3                               TAUJ0_CDR3
#define RENESAS_TAUJ1CDR0                               TAUJ1_CDR0
#define RENESAS_TAUJ1CDR1                               TAUJ1_CDR1
#define RENESAS_TAUJ1CDR2                               TAUJ1_CDR2
#define RENESAS_TAUJ1CDR3                               TAUJ1_CDR3
#define RENESAS_TAUJ2CDR0                               TAUJ2_CDR0
#define RENESAS_TAUJ2CDR1                               TAUJ2_CDR1
#define RENESAS_TAUJ2CDR2                               TAUJ2_CDR2
#define RENESAS_TAUJ2CDR3                               TAUJ2_CDR3
#define RENESAS_TAUJ3CDR0                               TAUJ3_CDR0
#define RENESAS_TAUJ3CDR1                               TAUJ3_CDR1
#define RENESAS_TAUJ3CDR2                               TAUJ3_CDR2
#define RENESAS_TAUJ3CDR3                               TAUJ3_CDR3
#define RENESAS_TAUJ0CMOR0                              TAUJ0_CMOR0
#define RENESAS_TAUJ0CMOR1                              TAUJ0_CMOR1
#define RENESAS_TAUJ0CMOR2                              TAUJ0_CMOR2
#define RENESAS_TAUJ0CMOR3                              TAUJ0_CMOR3
#define RENESAS_TAUJ1CMOR0                              TAUJ1_CMOR0
#define RENESAS_TAUJ1CMOR1                              TAUJ1_CMOR1
#define RENESAS_TAUJ1CMOR2                              TAUJ1_CMOR2
#define RENESAS_TAUJ1CMOR3                              TAUJ1_CMOR3
#define RENESAS_TAUJ2CMOR0                              TAUJ2_CMOR0
#define RENESAS_TAUJ2CMOR1                              TAUJ2_CMOR1
#define RENESAS_TAUJ2CMOR2                              TAUJ2_CMOR2
#define RENESAS_TAUJ2CMOR3                              TAUJ2_CMOR3
#define RENESAS_TAUJ3CMOR0                              TAUJ3_CMOR0
#define RENESAS_TAUJ3CMOR1                              TAUJ3_CMOR1
#define RENESAS_TAUJ3CMOR2                              TAUJ3_CMOR2
#define RENESAS_TAUJ3CMOR3                              TAUJ3_CMOR3
#define RENESAS_TAUJ0TE0                                TAUJ0_TE
#define RENESAS_TAUJ1TE0                                TAUJ1_TE
#define RENESAS_TAUJ2TE0                                TAUJ2_TE
#define RENESAS_TAUJ3TE0                                TAUJ3_TE
#define RENESAS_TAUJ0TPS0                               TAUJ0_TPS
#define RENESAS_TAUJ1TPS0                               TAUJ1_TPS
#define RENESAS_TAUJ2TPS0                               TAUJ2_TPS
#define RENESAS_TAUJ3TPS0                               TAUJ3_TPS

/* OSTM register */
#define RENESAS_OSTM0CMP                                OSTM0_CMP
#define RENESAS_OSTM1CMP                                OSTM1_CMP
#define RENESAS_OSTM2CMP                                OSTM2_CMP
#define RENESAS_OSTM3CMP                                OSTM3_CMP
#define RENESAS_OSTM4CMP                                OSTM4_CMP
#define RENESAS_OSTM5CMP                                OSTM5_CMP
#define RENESAS_OSTM8CMP                                OSTM8_CMP
#define RENESAS_OSTM9CMP                                OSTM9_CMP

#define RENESAS_OSTM0CNT                                OSTM0_CNT
#define RENESAS_OSTM1CNT                                OSTM1_CNT
#define RENESAS_OSTM2CNT                                OSTM2_CNT
#define RENESAS_OSTM3CNT                                OSTM3_CNT
#define RENESAS_OSTM4CNT                                OSTM4_CNT
#define RENESAS_OSTM5CNT                                OSTM5_CNT
#define RENESAS_OSTM8CNT                                OSTM8_CNT
#define RENESAS_OSTM9CNT                                OSTM9_CNT

#define RENESAS_OSTM0TO                                 OSTM0_TO
#define RENESAS_OSTM1TO                                 OSTM1_TO
#define RENESAS_OSTM2TO                                 OSTM2_TO
#define RENESAS_OSTM3TO                                 OSTM3_TO
#define RENESAS_OSTM4TO                                 OSTM4_TO
#define RENESAS_OSTM5TO                                 OSTM5_TO
#define RENESAS_OSTM8TO                                 OSTM8_TO
#define RENESAS_OSTM9TO                                 OSTM9_TO

#define RENESAS_OSTM0TOE                                OSTM0_TOE
#define RENESAS_OSTM1TOE                                OSTM1_TOE
#define RENESAS_OSTM2TOE                                OSTM2_TOE
#define RENESAS_OSTM3TOE                                OSTM2_TOE
#define RENESAS_OSTM4TOE                                OSTM2_TOE
#define RENESAS_OSTM5TOE                                OSTM2_TOE
#define RENESAS_OSTM8TOE                                OSTM2_TOE
#define RENESAS_OSTM9TOE                                OSTM2_TOE

#define RENESAS_OSTM0TE                                 OSTM0_TE
#define RENESAS_OSTM1TE                                 OSTM1_TE
#define RENESAS_OSTM2TE                                 OSTM2_TE

#define RENESAS_OSTM0TS                                 OSTM0_TS
#define RENESAS_OSTM1TS                                 OSTM1_TS
#define RENESAS_OSTM2TS                                 OSTM2_TS

#define RENESAS_OSTM0TT                                 OSTM0_TT
#define RENESAS_OSTM1TT                                 OSTM1_TT
#define RENESAS_OSTM2TT                                 OSTM2_TT

#define RENESAS_OSTM0CTL                                OSTM0_CTL
#define RENESAS_OSTM1CTL                                OSTM1_CTL
#define RENESAS_OSTM2CTL                                OSTM2_CTL
#define RENESAS_OSTM3CTL                                OSTM3_CTL
#define RENESAS_OSTM4CTL                                OSTM4_CTL
#define RENESAS_OSTM5CTL                                OSTM5_CTL
#define RENESAS_OSTM8CTL                                OSTM8_CTL
#define RENESAS_OSTM9CTL                                OSTM9_CTL

/* IMR Interrupt control registers for OSTM0 */
#define RENESAS_ICOSTM0IMR                              INTC1_PE0_IMR0
#define RENESAS_ICOSTM1IMR                              INTC1_PE0_IMR0
#define RENESAS_ICOSTM2IMR                              INTC1_PE1_IMR0

/* EIC Interrupt control registers */
#define RENESAS_TAUD0I0                                 INTC1_SELF_EIC10
#define RENESAS_TAUD0I1                                 INTC2_EIC376
#define RENESAS_TAUD0I2                                 INTC1_SELF_EIC11
#define RENESAS_TAUD0I3                                 INTC2_EIC377
#define RENESAS_TAUD0I4                                 INTC1_SELF_EIC12
#define RENESAS_TAUD0I5                                 INTC2_EIC378
#define RENESAS_TAUD0I6                                 INTC1_SELF_EIC13
#define RENESAS_TAUD0I7                                 INTC2_EIC379
#define RENESAS_TAUD0I8                                 INTC1_SELF_EIC23
#define RENESAS_TAUD0I9                                 INTC2_EIC380
#define RENESAS_TAUD0I10                                INTC1_SELF_EIC24
#define RENESAS_TAUD0I11                                INTC2_EIC381
#define RENESAS_TAUD0I12                                INTC1_SELF_EIC25
#define RENESAS_TAUD0I13                                INTC2_EIC382
#define RENESAS_TAUD0I14                                INTC1_SELF_EIC26
#define RENESAS_TAUD0I15                                INTC2_EIC383
#define RENESAS_TAUD1I0                                 INTC2_EIC384
#define RENESAS_TAUD1I1                                 INTC2_EIC385
#define RENESAS_TAUD1I2                                 INTC2_EIC386
#define RENESAS_TAUD1I3                                 INTC2_EIC387
#define RENESAS_TAUD1I4                                 INTC2_EIC388
#define RENESAS_TAUD1I5                                 INTC2_EIC389
#define RENESAS_TAUD1I6                                 INTC2_EIC390
#define RENESAS_TAUD1I7                                 INTC2_EIC391
#define RENESAS_TAUD1I8                                 INTC2_EIC392
#define RENESAS_TAUD1I9                                 INTC2_EIC393
#define RENESAS_TAUD1I10                                INTC2_EIC394
#define RENESAS_TAUD1I11                                INTC2_EIC395
#define RENESAS_TAUD1I12                                INTC2_EIC396
#define RENESAS_TAUD1I13                                INTC2_EIC397
#define RENESAS_TAUD1I14                                INTC2_EIC398
#define RENESAS_TAUD1I15                                INTC2_EIC399
#define RENESAS_TAUD2I0                                 INTC2_EIC400
#define RENESAS_TAUD2I1                                 INTC2_EIC401
#define RENESAS_TAUD2I2                                 INTC2_EIC402
#define RENESAS_TAUD2I3                                 INTC2_EIC403
#define RENESAS_TAUD2I4                                 INTC2_EIC404
#define RENESAS_TAUD2I5                                 INTC2_EIC405
#define RENESAS_TAUD2I6                                 INTC2_EIC406
#define RENESAS_TAUD2I7                                 INTC2_EIC407
#define RENESAS_TAUD2I8                                 INTC2_EIC408
#define RENESAS_TAUD2I9                                 INTC2_EIC409
#define RENESAS_TAUD2I10                                INTC2_EIC410
#define RENESAS_TAUD2I11                                INTC2_EIC411
#define RENESAS_TAUD2I12                                INTC2_EIC412
#define RENESAS_TAUD2I13                                INTC2_EIC413
#define RENESAS_TAUD2I14                                INTC2_EIC414
#define RENESAS_TAUD2I15                                INTC2_EIC415

#define RENESAS_TAUJ0I0                                 INTC2_EIC360
#define RENESAS_TAUJ0I1                                 INTC2_EIC361
#define RENESAS_TAUJ0I2                                 INTC2_EIC362
#define RENESAS_TAUJ0I3                                 INTC2_EIC363
#define RENESAS_TAUJ1I0                                 INTC2_EIC364
#define RENESAS_TAUJ1I1                                 INTC2_EIC365
#define RENESAS_TAUJ1I2                                 INTC2_EIC366
#define RENESAS_TAUJ1I3                                 INTC2_EIC367
#define RENESAS_TAUJ2I0                                 INTC2_EIC368
#define RENESAS_TAUJ2I1                                 INTC2_EIC369
#define RENESAS_TAUJ2I2                                 INTC2_EIC370
#define RENESAS_TAUJ2I3                                 INTC2_EIC371
#define RENESAS_TAUJ3I0                                 INTC2_EIC372
#define RENESAS_TAUJ3I1                                 INTC2_EIC373
#define RENESAS_TAUJ3I2                                 INTC2_EIC374
#define RENESAS_TAUJ3I3                                 INTC2_EIC375

#define RENESAS_ICOSTM0                                 INTC2_EIC199
#define RENESAS_ICOSTM1                                 INTC2_EIC200
#define RENESAS_ICOSTM2                                 INTC2_EIC201
#define RENESAS_ICOSTM3                                 INTC2_EIC202
#define RENESAS_ICOSTM4                                 INTC2_EIC203
#define RENESAS_ICOSTM5                                 INTC2_EIC204
#define RENESAS_ICOSTM8                                 INTC2_EIC207
#define RENESAS_ICOSTM9                                 INTC2_EIC208

#define RENESAS_INTC1CPU0EIC18                          INTC1_PE0_EIC18
#define RENESAS_INTC1CPU0EIC19                          INTC1_PE0_EIC19
#define RENESAS_INTC1CPU1EIC18                          INTC1_PE1_EIC18
#define RENESAS_INTC1CPU1EIC19                          INTC1_PE1_EIC19

/* Interrupt control registers for TAUD */
#define RENESAS_ICTAUD0I0_IMR                           96
#define RENESAS_ICTAUD0I1_IMR                           97
#define RENESAS_ICTAUD0I2_IMR                           98
#define RENESAS_ICTAUD0I3_IMR                           99
#define RENESAS_ICTAUD0I4_IMR                           100
#define RENESAS_ICTAUD0I5_IMR                           101
#define RENESAS_ICTAUD0I6_IMR                           102
#define RENESAS_ICTAUD0I7_IMR                           103
#define RENESAS_ICTAUD0I8_IMR                           104
#define RENESAS_ICTAUD0I9_IMR                           105
#define RENESAS_ICTAUD0I10_IMR                          106
#define RENESAS_ICTAUD0I11_IMR                          107
#define RENESAS_ICTAUD0I12_IMR                          108
#define RENESAS_ICTAUD0I13_IMR                          109
#define RENESAS_ICTAUD0I14_IMR                          110
#define RENESAS_ICTAUD0I15_IMR                          111
#define RENESAS_ICTAUD1I0_IMR                           112
#define RENESAS_ICTAUD1I1_IMR                           113
#define RENESAS_ICTAUD1I2_IMR                           114
#define RENESAS_ICTAUD1I3_IMR                           115
#define RENESAS_ICTAUD1I4_IMR                           116
#define RENESAS_ICTAUD1I5_IMR                           117
#define RENESAS_ICTAUD1I6_IMR                           118
#define RENESAS_ICTAUD1I7_IMR                           119
#define RENESAS_ICTAUD1I8_IMR                           120
#define RENESAS_ICTAUD1I9_IMR                           121
#define RENESAS_ICTAUD1I10_IMR                          122
#define RENESAS_ICTAUD1I11_IMR                          123
#define RENESAS_ICTAUD1I12_IMR                          124
#define RENESAS_ICTAUD1I13_IMR                          125
#define RENESAS_ICTAUD1I14_IMR                          126
#define RENESAS_ICTAUD1I15_IMR                          127

/* EIC registers */
#define RENESAS_EIC78                                   INTC2_EIC78
#define RENESAS_EIC79                                   INTC2_EIC79
#define RENESAS_EIC80                                   INTC2_EIC80
#define RENESAS_EIC81                                   INTC2_EIC81
#define RENESAS_EIC82                                   INTC2_EIC82
#define RENESAS_EIC83                                   INTC2_EIC83
#define RENESAS_EIC84                                   INTC2_EIC84
#define RENESAS_EIC85                                   INTC2_EIC85
#define RENESAS_EIC86                                   INTC2_EIC86
#define RENESAS_EIC87                                   INTC2_EIC87
#define RENESAS_EIC88                                   INTC2_EIC88
#define RENESAS_EIC89                                   INTC2_EIC89
#define RENESAS_EIC90                                   INTC2_EIC90
#define RENESAS_EIC91                                   INTC2_EIC91
#define RENESAS_EIC92                                   INTC2_EIC92
#define RENESAS_EIC93                                   INTC2_EIC93
#define RENESAS_EIC94                                   INTC2_EIC94
#define RENESAS_EIC95                                   INTC2_EIC95
#define RENESAS_EIC96                                   INTC2_EIC96
#define RENESAS_EIC97                                   INTC2_EIC97
#define RENESAS_EIC98                                   INTC2_EIC98
#define RENESAS_EIC99                                   INTC2_EIC99
#define RENESAS_EIC100                                  INTC2_EIC100
#define RENESAS_EIC101                                  INTC2_EIC101
#define RENESAS_EIC102                                  INTC2_EIC102
#define RENESAS_EIC103                                  INTC2_EIC103
#define RENESAS_EIC104                                  INTC2_EIC104
#define RENESAS_EIC105                                  INTC2_EIC105
#define RENESAS_EIC106                                  INTC2_EIC106
#define RENESAS_EIC107                                  INTC2_EIC107
#define RENESAS_EIC108                                  INTC2_EIC108
#define RENESAS_EIC109                                  INTC2_EIC109
#define RENESAS_EIC110                                  INTC2_EIC110
#define RENESAS_EIC111                                  INTC2_EIC111
#define RENESAS_EIC112                                  INTC2_EIC112
#define RENESAS_EIC113                                  INTC2_EIC113
#define RENESAS_EIC114                                  INTC2_EIC114
#define RENESAS_EIC115                                  INTC2_EIC115
#define RENESAS_EIC116                                  INTC2_EIC116
#define RENESAS_EIC117                                  INTC2_EIC117
#define RENESAS_EIC118                                  INTC2_EIC118
#define RENESAS_EIC119                                  INTC2_EIC119
#define RENESAS_EIC120                                  INTC2_EIC120
#define RENESAS_EIC121                                  INTC2_EIC121
#define RENESAS_EIC122                                  INTC2_EIC122
#define RENESAS_EIC123                                  INTC2_EIC123
#define RENESAS_EIC124                                  INTC2_EIC124
#define RENESAS_EIC125                                  INTC2_EIC125
#define RENESAS_EIC126                                  INTC2_EIC126
#define RENESAS_EIC127                                  INTC2_EIC127
#define RENESAS_EIC128                                  INTC2_EIC128
#define RENESAS_EIC129                                  INTC2_EIC129
#define RENESAS_EIC130                                  INTC2_EIC130
#define RENESAS_EIC131                                  INTC2_EIC131
#define RENESAS_EIC132                                  INTC2_EIC132
#define RENESAS_EIC133                                  INTC2_EIC133
#define RENESAS_EIC134                                  INTC2_EIC134
#define RENESAS_EIC135                                  INTC2_EIC135
#define RENESAS_EIC136                                  INTC2_EIC136
#define RENESAS_EIC137                                  INTC2_EIC137
#define RENESAS_EIC138                                  INTC2_EIC138
#define RENESAS_EIC139                                  INTC2_EIC139
#define RENESAS_EIC140                                  INTC2_EIC140
#define RENESAS_EIC141                                  INTC2_EIC141
#define RENESAS_EIC142                                  INTC2_EIC142
#define RENESAS_EIC143                                  INTC2_EIC143
#define RENESAS_EIC144                                  INTC2_EIC144
#define RENESAS_EIC145                                  INTC2_EIC145
#define RENESAS_EIC146                                  INTC2_EIC146
#define RENESAS_EIC147                                  INTC2_EIC147
#define RENESAS_EIC148                                  INTC2_EIC148
#define RENESAS_EIC149                                  INTC2_EIC149
#define RENESAS_EIC150                                  INTC2_EIC150
#define RENESAS_EIC151                                  INTC2_EIC151
#define RENESAS_EIC152                                  INTC2_EIC152
#define RENESAS_EIC153                                  INTC2_EIC153
#define RENESAS_EIC154                                  INTC2_EIC154
#define RENESAS_EIC155                                  INTC2_EIC155
#define RENESAS_EIC156                                  INTC2_EIC156
#define RENESAS_EIC157                                  INTC2_EIC157
#define RENESAS_EIC158                                  INTC2_EIC158
#define RENESAS_EIC159                                  INTC2_EIC159
#define RENESAS_EIC160                                  INTC2_EIC160
#define RENESAS_EIC161                                  INTC2_EIC161
#define RENESAS_EIC162                                  INTC2_EIC162
#define RENESAS_EIC163                                  INTC2_EIC163
#define RENESAS_EIC164                                  INTC2_EIC164
#define RENESAS_EIC165                                  INTC2_EIC165
#define RENESAS_EIC166                                  INTC2_EIC166
#define RENESAS_EIC167                                  INTC2_EIC167
#define RENESAS_EIC168                                  INTC2_EIC168
#define RENESAS_EIC169                                  INTC2_EIC169
#define RENESAS_EIC170                                  INTC2_EIC170
#define RENESAS_EIC171                                  INTC2_EIC171
#define RENESAS_EIC172                                  INTC2_EIC172
#define RENESAS_EIC173                                  INTC2_EIC173
#define RENESAS_EIC174                                  INTC2_EIC174
#define RENESAS_EIC175                                  INTC2_EIC175
#define RENESAS_EIC176                                  INTC2_EIC176
#define RENESAS_EIC177                                  INTC2_EIC177
#define RENESAS_EIC178                                  INTC2_EIC178
#define RENESAS_EIC179                                  INTC2_EIC179
#define RENESAS_EIC180                                  INTC2_EIC180
#define RENESAS_EIC181                                  INTC2_EIC181
#define RENESAS_EIC182                                  INTC2_EIC182
#define RENESAS_EIC183                                  INTC2_EIC183
#define RENESAS_EIC184                                  INTC2_EIC184
#define RENESAS_EIC185                                  INTC2_EIC185
#define RENESAS_EIC186                                  INTC2_EIC186
#define RENESAS_EIC187                                  INTC2_EIC187
#define RENESAS_EIC188                                  INTC2_EIC188
#define RENESAS_EIC189                                  INTC2_EIC189
#define RENESAS_EIC190                                  INTC2_EIC190
#define RENESAS_EIC191                                  INTC2_EIC191
#define RENESAS_EIC192                                  INTC2_EIC192
#define RENESAS_EIC193                                  INTC2_EIC193
#define RENESAS_EIC194                                  INTC2_EIC194
#define RENESAS_EIC195                                  INTC2_EIC195
#define RENESAS_EIC196                                  INTC2_EIC196
#define RENESAS_EIC197                                  INTC2_EIC197
#define RENESAS_EIC198                                  INTC2_EIC198
#define RENESAS_EIC199                                  INTC2_EIC199
#define RENESAS_EIC200                                  INTC2_EIC200
#define RENESAS_EIC201                                  INTC2_EIC201
#define RENESAS_EIC202                                  INTC2_EIC202
#define RENESAS_EIC203                                  INTC2_EIC203
#define RENESAS_EIC204                                  INTC2_EIC204
#define RENESAS_EIC205                                  INTC2_EIC205

#define RENESAS_INTC2EIC32                              INTC2_EIC32
#define RENESAS_INTC2EIC32L                             INTC2_EIC32L
#define RENESAS_INTC2EIC32H                             INTC2_EIC32H
#define RENESAS_INTC2EIC33                              INTC2_EIC33
#define RENESAS_INTC2EIC33L                             INTC2_EIC33L
#define RENESAS_INTC2EIC33H                             INTC2_EIC33H
#define RENESAS_INTC2EIC34                              INTC2_EIC34
#define RENESAS_INTC2EIC34L                             INTC2_EIC34L
#define RENESAS_INTC2EIC34H                             INTC2_EIC34H
#define RENESAS_INTC2EIC35                              INTC2_EIC35
#define RENESAS_INTC2EIC35L                             INTC2_EIC35L
#define RENESAS_INTC2EIC35H                             INTC2_EIC35H
#define RENESAS_INTC2EIC36                              INTC2_EIC36
#define RENESAS_INTC2EIC36L                             INTC2_EIC36L
#define RENESAS_INTC2EIC36H                             INTC2_EIC36H
#define RENESAS_INTC2EIC37                              INTC2_EIC37
#define RENESAS_INTC2EIC37L                             INTC2_EIC37L
#define RENESAS_INTC2EIC37H                             INTC2_EIC37H
#define RENESAS_INTC2EIC38                              INTC2_EIC38
#define RENESAS_INTC2EIC38L                             INTC2_EIC38L
#define RENESAS_INTC2EIC38H                             INTC2_EIC38H
#define RENESAS_INTC2EIC39                              INTC2_EIC39
#define RENESAS_INTC2EIC39L                             INTC2_EIC39L
#define RENESAS_INTC2EIC39H                             INTC2_EIC39H
#define RENESAS_INTC2EIC40                              INTC2_EIC40
#define RENESAS_INTC2EIC40L                             INTC2_EIC40L
#define RENESAS_INTC2EIC40H                             INTC2_EIC40H
#define RENESAS_INTC2EIC41                              INTC2_EIC41
#define RENESAS_INTC2EIC41L                             INTC2_EIC41L
#define RENESAS_INTC2EIC41H                             INTC2_EIC41H
#define RENESAS_INTC2EIC42                              INTC2_EIC42
#define RENESAS_INTC2EIC42L                             INTC2_EIC42L
#define RENESAS_INTC2EIC42H                             INTC2_EIC42H
#define RENESAS_INTC2EIC43                              INTC2_EIC43
#define RENESAS_INTC2EIC43L                             INTC2_EIC43L
#define RENESAS_INTC2EIC43H                             INTC2_EIC43H
#define RENESAS_INTC2EIC44                              INTC2_EIC44
#define RENESAS_INTC2EIC44L                             INTC2_EIC44L
#define RENESAS_INTC2EIC44H                             INTC2_EIC44H
#define RENESAS_INTC2EIC45                              INTC2_EIC45
#define RENESAS_INTC2EIC45L                             INTC2_EIC45L
#define RENESAS_INTC2EIC45H                             INTC2_EIC45H
#define RENESAS_INTC2EIC46                              INTC2_EIC46
#define RENESAS_INTC2EIC46L                             INTC2_EIC46L
#define RENESAS_INTC2EIC46H                             INTC2_EIC46H
#define RENESAS_INTC2EIC47                              INTC2_EIC47
#define RENESAS_INTC2EIC47L                             INTC2_EIC47L
#define RENESAS_INTC2EIC47H                             INTC2_EIC47H
#define RENESAS_INTC2EIC48                              INTC2_EIC48
#define RENESAS_INTC2EIC48L                             INTC2_EIC48L
#define RENESAS_INTC2EIC48H                             INTC2_EIC48H
#define RENESAS_INTC2EIC49                              INTC2_EIC49
#define RENESAS_INTC2EIC49L                             INTC2_EIC49L
#define RENESAS_INTC2EIC49H                             INTC2_EIC49H
#define RENESAS_INTC2EIC50                              INTC2_EIC50
#define RENESAS_INTC2EIC50L                             INTC2_EIC50L
#define RENESAS_INTC2EIC50H                             INTC2_EIC50H
#define RENESAS_INTC2EIC51                              INTC2_EIC51
#define RENESAS_INTC2EIC51L                             INTC2_EIC51L
#define RENESAS_INTC2EIC51H                             INTC2_EIC51H
#define RENESAS_INTC2EIC52                              INTC2_EIC52
#define RENESAS_INTC2EIC52L                             INTC2_EIC52L
#define RENESAS_INTC2EIC52H                             INTC2_EIC52H
#define RENESAS_INTC2EIC53                              INTC2_EIC53
#define RENESAS_INTC2EIC53L                             INTC2_EIC53L
#define RENESAS_INTC2EIC53H                             INTC2_EIC53H
#define RENESAS_INTC2EIC54                              INTC2_EIC54
#define RENESAS_INTC2EIC54L                             INTC2_EIC54L
#define RENESAS_INTC2EIC54H                             INTC2_EIC54H
#define RENESAS_INTC2EIC55                              INTC2_EIC55
#define RENESAS_INTC2EIC55L                             INTC2_EIC55L
#define RENESAS_INTC2EIC55H                             INTC2_EIC55H
#define RENESAS_INTC2EIC56                              INTC2_EIC56
#define RENESAS_INTC2EIC56L                             INTC2_EIC56L
#define RENESAS_INTC2EIC56H                             INTC2_EIC56H
#define RENESAS_INTC2EIC57                              INTC2_EIC57
#define RENESAS_INTC2EIC57L                             INTC2_EIC57L
#define RENESAS_INTC2EIC57H                             INTC2_EIC57H
#define RENESAS_INTC2EIC58                              INTC2_EIC58
#define RENESAS_INTC2EIC58L                             INTC2_EIC58L
#define RENESAS_INTC2EIC58H                             INTC2_EIC58H
#define RENESAS_INTC2EIC59                              INTC2_EIC59
#define RENESAS_INTC2EIC59L                             INTC2_EIC59L
#define RENESAS_INTC2EIC59H                             INTC2_EIC59H
#define RENESAS_INTC2EIC60                              INTC2_EIC60
#define RENESAS_INTC2EIC60L                             INTC2_EIC60L
#define RENESAS_INTC2EIC60H                             INTC2_EIC60H
#define RENESAS_INTC2EIC61                              INTC2_EIC61
#define RENESAS_INTC2EIC61L                             INTC2_EIC61L
#define RENESAS_INTC2EIC61H                             INTC2_EIC61H
#define RENESAS_INTC2EIC62                              INTC2_EIC62
#define RENESAS_INTC2EIC62L                             INTC2_EIC62L
#define RENESAS_INTC2EIC62H                             INTC2_EIC62H
#define RENESAS_INTC2EIC63                              INTC2_EIC63
#define RENESAS_INTC2EIC63L                             INTC2_EIC63L
#define RENESAS_INTC2EIC63H                             INTC2_EIC63H
#define RENESAS_INTC2EIC64                              INTC2_EIC64
#define RENESAS_INTC2EIC64L                             INTC2_EIC64L
#define RENESAS_INTC2EIC64H                             INTC2_EIC64H
#define RENESAS_INTC2EIC65                              INTC2_EIC65
#define RENESAS_INTC2EIC65L                             INTC2_EIC65L
#define RENESAS_INTC2EIC65H                             INTC2_EIC65H
#define RENESAS_INTC2EIC66                              INTC2_EIC66
#define RENESAS_INTC2EIC66L                             INTC2_EIC66L
#define RENESAS_INTC2EIC66H                             INTC2_EIC66H
#define RENESAS_INTC2EIC67                              INTC2_EIC67
#define RENESAS_INTC2EIC67L                             INTC2_EIC67L
#define RENESAS_INTC2EIC67H                             INTC2_EIC67H
#define RENESAS_INTC2EIC68                              INTC2_EIC68
#define RENESAS_INTC2EIC68L                             INTC2_EIC68L
#define RENESAS_INTC2EIC68H                             INTC2_EIC68H
#define RENESAS_INTC2EIC69                              INTC2_EIC69
#define RENESAS_INTC2EIC69L                             INTC2_EIC69L
#define RENESAS_INTC2EIC69H                             INTC2_EIC69H
#define RENESAS_INTC2EIC70                              INTC2_EIC70
#define RENESAS_INTC2EIC70L                             INTC2_EIC70L
#define RENESAS_INTC2EIC70H                             INTC2_EIC70H
#define RENESAS_INTC2EIC71                              INTC2_EIC71
#define RENESAS_INTC2EIC71L                             INTC2_EIC71L
#define RENESAS_INTC2EIC71H                             INTC2_EIC71H
#define RENESAS_INTC2EIC72                              INTC2_EIC72
#define RENESAS_INTC2EIC72L                             INTC2_EIC72L
#define RENESAS_INTC2EIC72H                             INTC2_EIC72H
#define RENESAS_INTC2EIC73                              INTC2_EIC73
#define RENESAS_INTC2EIC73L                             INTC2_EIC73L
#define RENESAS_INTC2EIC73H                             INTC2_EIC73H
#define RENESAS_INTC2EIC74                              INTC2_EIC74
#define RENESAS_INTC2EIC74L                             INTC2_EIC74L
#define RENESAS_INTC2EIC74H                             INTC2_EIC74H
#define RENESAS_INTC2EIC75                              INTC2_EIC75
#define RENESAS_INTC2EIC75L                             INTC2_EIC75L
#define RENESAS_INTC2EIC75H                             INTC2_EIC75H
#define RENESAS_INTC2EIC76                              INTC2_EIC76
#define RENESAS_INTC2EIC76L                             INTC2_EIC76L
#define RENESAS_INTC2EIC76H                             INTC2_EIC76H
#define RENESAS_INTC2EIC77                              INTC2_EIC77
#define RENESAS_INTC2EIC77L                             INTC2_EIC77L
#define RENESAS_INTC2EIC77H                             INTC2_EIC77H
#define RENESAS_INTC2EIC78                              INTC2_EIC78
#define RENESAS_INTC2EIC78L                             INTC2_EIC78L
#define RENESAS_INTC2EIC78H                             INTC2_EIC78H
#define RENESAS_INTC2EIC79                              INTC2_EIC79
#define RENESAS_INTC2EIC79L                             INTC2_EIC79L
#define RENESAS_INTC2EIC79H                             INTC2_EIC79H
#define RENESAS_INTC2EIC80                              INTC2_EIC80
#define RENESAS_INTC2EIC80L                             INTC2_EIC80L
#define RENESAS_INTC2EIC80H                             INTC2_EIC80H
#define RENESAS_INTC2EIC81                              INTC2_EIC81
#define RENESAS_INTC2EIC81L                             INTC2_EIC81L
#define RENESAS_INTC2EIC81H                             INTC2_EIC81H
#define RENESAS_INTC2EIC82                              INTC2_EIC82
#define RENESAS_INTC2EIC82L                             INTC2_EIC82L
#define RENESAS_INTC2EIC82H                             INTC2_EIC82H
#define RENESAS_INTC2EIC83                              INTC2_EIC83
#define RENESAS_INTC2EIC83L                             INTC2_EIC83L
#define RENESAS_INTC2EIC83H                             INTC2_EIC83H
#define RENESAS_INTC2EIC84                              INTC2_EIC84
#define RENESAS_INTC2EIC84L                             INTC2_EIC84L
#define RENESAS_INTC2EIC84H                             INTC2_EIC84H
#define RENESAS_INTC2EIC85                              INTC2_EIC85
#define RENESAS_INTC2EIC85L                             INTC2_EIC85L
#define RENESAS_INTC2EIC85H                             INTC2_EIC85H
#define RENESAS_INTC2EIC86                              INTC2_EIC86
#define RENESAS_INTC2EIC86L                             INTC2_EIC86L
#define RENESAS_INTC2EIC86H                             INTC2_EIC86H
#define RENESAS_INTC2EIC87                              INTC2_EIC87
#define RENESAS_INTC2EIC87L                             INTC2_EIC87L
#define RENESAS_INTC2EIC87H                             INTC2_EIC87H
#define RENESAS_INTC2EIC88                              INTC2_EIC88
#define RENESAS_INTC2EIC88L                             INTC2_EIC88L
#define RENESAS_INTC2EIC88H                             INTC2_EIC88H
#define RENESAS_INTC2EIC89                              INTC2_EIC89
#define RENESAS_INTC2EIC89L                             INTC2_EIC89L
#define RENESAS_INTC2EIC89H                             INTC2_EIC89H
#define RENESAS_INTC2EIC90                              INTC2_EIC90
#define RENESAS_INTC2EIC90L                             INTC2_EIC90L
#define RENESAS_INTC2EIC90H                             INTC2_EIC90H
#define RENESAS_INTC2EIC91                              INTC2_EIC91
#define RENESAS_INTC2EIC91L                             INTC2_EIC91L
#define RENESAS_INTC2EIC91H                             INTC2_EIC91H
#define RENESAS_INTC2EIC92                              INTC2_EIC92
#define RENESAS_INTC2EIC92L                             INTC2_EIC92L
#define RENESAS_INTC2EIC92H                             INTC2_EIC92H
#define RENESAS_INTC2EIC93                              INTC2_EIC93
#define RENESAS_INTC2EIC93L                             INTC2_EIC93L
#define RENESAS_INTC2EIC93H                             INTC2_EIC93H
#define RENESAS_INTC2EIC94                              INTC2_EIC94
#define RENESAS_INTC2EIC94L                             INTC2_EIC94L
#define RENESAS_INTC2EIC94H                             INTC2_EIC94H
#define RENESAS_INTC2EIC95                              INTC2_EIC95
#define RENESAS_INTC2EIC95L                             INTC2_EIC95L
#define RENESAS_INTC2EIC95H                             INTC2_EIC95H
#define RENESAS_INTC2EIC96                              INTC2_EIC96
#define RENESAS_INTC2EIC96L                             INTC2_EIC96L
#define RENESAS_INTC2EIC96H                             INTC2_EIC96H
#define RENESAS_INTC2EIC97                              INTC2_EIC97
#define RENESAS_INTC2EIC97L                             INTC2_EIC97L
#define RENESAS_INTC2EIC97H                             INTC2_EIC97H
#define RENESAS_INTC2EIC98                              INTC2_EIC98
#define RENESAS_INTC2EIC98L                             INTC2_EIC98L
#define RENESAS_INTC2EIC98H                             INTC2_EIC98H
#define RENESAS_INTC2EIC99                              INTC2_EIC99
#define RENESAS_INTC2EIC99L                             INTC2_EIC99L
#define RENESAS_INTC2EIC99H                             INTC2_EIC99H
#define RENESAS_INTC2EIC100                             INTC2_EIC100
#define RENESAS_INTC2EIC100L                            INTC2_EIC100L
#define RENESAS_INTC2EIC100H                            INTC2_EIC100H
#define RENESAS_INTC2EIC101                             INTC2_EIC101
#define RENESAS_INTC2EIC101L                            INTC2_EIC101L
#define RENESAS_INTC2EIC101H                            INTC2_EIC101H
#define RENESAS_INTC2EIC102                             INTC2_EIC102
#define RENESAS_INTC2EIC102L                            INTC2_EIC102L
#define RENESAS_INTC2EIC102H                            INTC2_EIC102H
#define RENESAS_INTC2EIC103                             INTC2_EIC103
#define RENESAS_INTC2EIC103L                            INTC2_EIC103L
#define RENESAS_INTC2EIC103H                            INTC2_EIC103H
#define RENESAS_INTC2EIC104                             INTC2_EIC104
#define RENESAS_INTC2EIC104L                            INTC2_EIC104L
#define RENESAS_INTC2EIC104H                            INTC2_EIC104H
#define RENESAS_INTC2EIC105                             INTC2_EIC105
#define RENESAS_INTC2EIC105L                            INTC2_EIC105L
#define RENESAS_INTC2EIC105H                            INTC2_EIC105H
#define RENESAS_INTC2EIC106                             INTC2_EIC106
#define RENESAS_INTC2EIC106L                            INTC2_EIC106L
#define RENESAS_INTC2EIC106H                            INTC2_EIC106H
#define RENESAS_INTC2EIC107                             INTC2_EIC107
#define RENESAS_INTC2EIC107L                            INTC2_EIC107L
#define RENESAS_INTC2EIC107H                            INTC2_EIC107H
#define RENESAS_INTC2EIC108                             INTC2_EIC108
#define RENESAS_INTC2EIC108L                            INTC2_EIC108L
#define RENESAS_INTC2EIC108H                            INTC2_EIC108H
#define RENESAS_INTC2EIC109                             INTC2_EIC109
#define RENESAS_INTC2EIC109L                            INTC2_EIC109L
#define RENESAS_INTC2EIC109H                            INTC2_EIC109H
#define RENESAS_INTC2EIC110                             INTC2_EIC110
#define RENESAS_INTC2EIC110L                            INTC2_EIC110L
#define RENESAS_INTC2EIC110H                            INTC2_EIC110H
#define RENESAS_INTC2EIC111                             INTC2_EIC111
#define RENESAS_INTC2EIC111L                            INTC2_EIC111L
#define RENESAS_INTC2EIC111H                            INTC2_EIC111H
#define RENESAS_INTC2EIC112                             INTC2_EIC112
#define RENESAS_INTC2EIC112L                            INTC2_EIC112L
#define RENESAS_INTC2EIC112H                            INTC2_EIC112H
#define RENESAS_INTC2EIC113                             INTC2_EIC113
#define RENESAS_INTC2EIC113L                            INTC2_EIC113L
#define RENESAS_INTC2EIC113H                            INTC2_EIC113H
#define RENESAS_INTC2EIC114                             INTC2_EIC114
#define RENESAS_INTC2EIC114L                            INTC2_EIC114L
#define RENESAS_INTC2EIC114H                            INTC2_EIC114H
#define RENESAS_INTC2EIC115                             INTC2_EIC115
#define RENESAS_INTC2EIC115L                            INTC2_EIC115L
#define RENESAS_INTC2EIC115H                            INTC2_EIC115H
#define RENESAS_INTC2EIC116                             INTC2_EIC116
#define RENESAS_INTC2EIC116L                            INTC2_EIC116L
#define RENESAS_INTC2EIC116H                            INTC2_EIC116H
#define RENESAS_INTC2EIC117                             INTC2_EIC117
#define RENESAS_INTC2EIC117L                            INTC2_EIC117L
#define RENESAS_INTC2EIC117H                            INTC2_EIC117H
#define RENESAS_INTC2EIC118                             INTC2_EIC118
#define RENESAS_INTC2EIC118L                            INTC2_EIC118L
#define RENESAS_INTC2EIC118H                            INTC2_EIC118H
#define RENESAS_INTC2EIC119                             INTC2_EIC119
#define RENESAS_INTC2EIC119L                            INTC2_EIC119L
#define RENESAS_INTC2EIC119H                            INTC2_EIC119H
#define RENESAS_INTC2EIC120                             INTC2_EIC120
#define RENESAS_INTC2EIC120L                            INTC2_EIC120L
#define RENESAS_INTC2EIC120H                            INTC2_EIC120H
#define RENESAS_INTC2EIC121                             INTC2_EIC121
#define RENESAS_INTC2EIC121L                            INTC2_EIC121L
#define RENESAS_INTC2EIC121H                            INTC2_EIC121H
#define RENESAS_INTC2EIC122                             INTC2_EIC122
#define RENESAS_INTC2EIC122L                            INTC2_EIC122L
#define RENESAS_INTC2EIC122H                            INTC2_EIC122H
#define RENESAS_INTC2EIC123                             INTC2_EIC123
#define RENESAS_INTC2EIC123L                            INTC2_EIC123L
#define RENESAS_INTC2EIC123H                            INTC2_EIC123H
#define RENESAS_INTC2EIC124                             INTC2_EIC124
#define RENESAS_INTC2EIC124L                            INTC2_EIC124L
#define RENESAS_INTC2EIC124H                            INTC2_EIC124H
#define RENESAS_INTC2EIC125                             INTC2_EIC125
#define RENESAS_INTC2EIC125L                            INTC2_EIC125L
#define RENESAS_INTC2EIC125H                            INTC2_EIC125H
#define RENESAS_INTC2EIC126                             INTC2_EIC126
#define RENESAS_INTC2EIC126L                            INTC2_EIC126L
#define RENESAS_INTC2EIC126H                            INTC2_EIC126H
#define RENESAS_INTC2EIC127                             INTC2_EIC127
#define RENESAS_INTC2EIC127L                            INTC2_EIC127L
#define RENESAS_INTC2EIC127H                            INTC2_EIC127H
#define RENESAS_INTC2EIC128                             INTC2_EIC128
#define RENESAS_INTC2EIC128L                            INTC2_EIC128L
#define RENESAS_INTC2EIC128H                            INTC2_EIC128H
#define RENESAS_INTC2EIC129                             INTC2_EIC129
#define RENESAS_INTC2EIC129L                            INTC2_EIC129L
#define RENESAS_INTC2EIC129H                            INTC2_EIC129H
#define RENESAS_INTC2EIC130                             INTC2_EIC130
#define RENESAS_INTC2EIC130L                            INTC2_EIC130L
#define RENESAS_INTC2EIC130H                            INTC2_EIC130H
#define RENESAS_INTC2EIC131                             INTC2_EIC131
#define RENESAS_INTC2EIC131L                            INTC2_EIC131L
#define RENESAS_INTC2EIC131H                            INTC2_EIC131H
#define RENESAS_INTC2EIC132                             INTC2_EIC132
#define RENESAS_INTC2EIC132L                            INTC2_EIC132L
#define RENESAS_INTC2EIC132H                            INTC2_EIC132H
#define RENESAS_INTC2EIC133                             INTC2_EIC133
#define RENESAS_INTC2EIC133L                            INTC2_EIC133L
#define RENESAS_INTC2EIC133H                            INTC2_EIC133H
#define RENESAS_INTC2EIC134                             INTC2_EIC134
#define RENESAS_INTC2EIC134L                            INTC2_EIC134L
#define RENESAS_INTC2EIC134H                            INTC2_EIC134H
#define RENESAS_INTC2EIC135                             INTC2_EIC135
#define RENESAS_INTC2EIC135L                            INTC2_EIC135L
#define RENESAS_INTC2EIC135H                            INTC2_EIC135H
#define RENESAS_INTC2EIC136                             INTC2_EIC136
#define RENESAS_INTC2EIC136L                            INTC2_EIC136L
#define RENESAS_INTC2EIC136H                            INTC2_EIC136H
#define RENESAS_INTC2EIC137                             INTC2_EIC137
#define RENESAS_INTC2EIC137L                            INTC2_EIC137L
#define RENESAS_INTC2EIC137H                            INTC2_EIC137H
#define RENESAS_INTC2EIC138                             INTC2_EIC138
#define RENESAS_INTC2EIC138L                            INTC2_EIC138L
#define RENESAS_INTC2EIC138H                            INTC2_EIC138H
#define RENESAS_INTC2EIC139                             INTC2_EIC139
#define RENESAS_INTC2EIC139L                            INTC2_EIC139L
#define RENESAS_INTC2EIC139H                            INTC2_EIC139H
#define RENESAS_INTC2EIC140                             INTC2_EIC140
#define RENESAS_INTC2EIC140L                            INTC2_EIC140L
#define RENESAS_INTC2EIC140H                            INTC2_EIC140H
#define RENESAS_INTC2EIC141                             INTC2_EIC141
#define RENESAS_INTC2EIC141L                            INTC2_EIC141L
#define RENESAS_INTC2EIC141H                            INTC2_EIC141H
#define RENESAS_INTC2EIC142                             INTC2_EIC142
#define RENESAS_INTC2EIC142L                            INTC2_EIC142L
#define RENESAS_INTC2EIC142H                            INTC2_EIC142H
#define RENESAS_INTC2EIC143                             INTC2_EIC143
#define RENESAS_INTC2EIC143L                            INTC2_EIC143L
#define RENESAS_INTC2EIC143H                            INTC2_EIC143H
#define RENESAS_INTC2EIC144                             INTC2_EIC144
#define RENESAS_INTC2EIC144L                            INTC2_EIC144L
#define RENESAS_INTC2EIC144H                            INTC2_EIC144H
#define RENESAS_INTC2EIC145                             INTC2_EIC145
#define RENESAS_INTC2EIC145L                            INTC2_EIC145L
#define RENESAS_INTC2EIC145H                            INTC2_EIC145H
#define RENESAS_INTC2EIC146                             INTC2_EIC146
#define RENESAS_INTC2EIC146L                            INTC2_EIC146L
#define RENESAS_INTC2EIC146H                            INTC2_EIC146H
#define RENESAS_INTC2EIC147                             INTC2_EIC147
#define RENESAS_INTC2EIC147L                            INTC2_EIC147L
#define RENESAS_INTC2EIC147H                            INTC2_EIC147H
#define RENESAS_INTC2EIC148                             INTC2_EIC148
#define RENESAS_INTC2EIC148L                            INTC2_EIC148L
#define RENESAS_INTC2EIC148H                            INTC2_EIC148H
#define RENESAS_INTC2EIC149                             INTC2_EIC149
#define RENESAS_INTC2EIC149L                            INTC2_EIC149L
#define RENESAS_INTC2EIC149H                            INTC2_EIC149H
#define RENESAS_INTC2EIC150                             INTC2_EIC150
#define RENESAS_INTC2EIC150L                            INTC2_EIC150L
#define RENESAS_INTC2EIC150H                            INTC2_EIC150H
#define RENESAS_INTC2EIC151                             INTC2_EIC151
#define RENESAS_INTC2EIC151L                            INTC2_EIC151L
#define RENESAS_INTC2EIC151H                            INTC2_EIC151H
#define RENESAS_INTC2EIC152                             INTC2_EIC152
#define RENESAS_INTC2EIC152L                            INTC2_EIC152L
#define RENESAS_INTC2EIC152H                            INTC2_EIC152H
#define RENESAS_INTC2EIC153                             INTC2_EIC153
#define RENESAS_INTC2EIC153L                            INTC2_EIC153L
#define RENESAS_INTC2EIC153H                            INTC2_EIC153H
#define RENESAS_INTC2EIC154                             INTC2_EIC154
#define RENESAS_INTC2EIC154L                            INTC2_EIC154L
#define RENESAS_INTC2EIC154H                            INTC2_EIC154H
#define RENESAS_INTC2EIC155                             INTC2_EIC155
#define RENESAS_INTC2EIC155L                            INTC2_EIC155L
#define RENESAS_INTC2EIC155H                            INTC2_EIC155H
#define RENESAS_INTC2EIC156                             INTC2_EIC156
#define RENESAS_INTC2EIC156L                            INTC2_EIC156L
#define RENESAS_INTC2EIC156H                            INTC2_EIC156H
#define RENESAS_INTC2EIC157                             INTC2_EIC157
#define RENESAS_INTC2EIC157L                            INTC2_EIC157L
#define RENESAS_INTC2EIC157H                            INTC2_EIC157H
#define RENESAS_INTC2EIC158                             INTC2_EIC158
#define RENESAS_INTC2EIC158L                            INTC2_EIC158L
#define RENESAS_INTC2EIC158H                            INTC2_EIC158H
#define RENESAS_INTC2EIC159                             INTC2_EIC159
#define RENESAS_INTC2EIC159L                            INTC2_EIC159L
#define RENESAS_INTC2EIC159H                            INTC2_EIC159H
#define RENESAS_INTC2EIC160                             INTC2_EIC160
#define RENESAS_INTC2EIC160L                            INTC2_EIC160L
#define RENESAS_INTC2EIC160H                            INTC2_EIC160H
#define RENESAS_INTC2EIC161                             INTC2_EIC161
#define RENESAS_INTC2EIC161L                            INTC2_EIC161L
#define RENESAS_INTC2EIC161H                            INTC2_EIC161H
#define RENESAS_INTC2EIC162                             INTC2_EIC162
#define RENESAS_INTC2EIC162L                            INTC2_EIC162L
#define RENESAS_INTC2EIC162H                            INTC2_EIC162H
#define RENESAS_INTC2EIC163                             INTC2_EIC163
#define RENESAS_INTC2EIC163L                            INTC2_EIC163L
#define RENESAS_INTC2EIC163H                            INTC2_EIC163H
#define RENESAS_INTC2EIC164                             INTC2_EIC164
#define RENESAS_INTC2EIC164L                            INTC2_EIC164L
#define RENESAS_INTC2EIC164H                            INTC2_EIC164H
#define RENESAS_INTC2EIC165                             INTC2_EIC165
#define RENESAS_INTC2EIC165L                            INTC2_EIC165L
#define RENESAS_INTC2EIC165H                            INTC2_EIC165H
#define RENESAS_INTC2EIC166                             INTC2_EIC166
#define RENESAS_INTC2EIC166L                            INTC2_EIC166L
#define RENESAS_INTC2EIC166H                            INTC2_EIC166H
#define RENESAS_INTC2EIC167                             INTC2_EIC167
#define RENESAS_INTC2EIC167L                            INTC2_EIC167L
#define RENESAS_INTC2EIC167H                            INTC2_EIC167H
#define RENESAS_INTC2EIC168                             INTC2_EIC168
#define RENESAS_INTC2EIC168L                            INTC2_EIC168L
#define RENESAS_INTC2EIC168H                            INTC2_EIC168H
#define RENESAS_INTC2EIC169                             INTC2_EIC169
#define RENESAS_INTC2EIC169L                            INTC2_EIC169L
#define RENESAS_INTC2EIC169H                            INTC2_EIC169H
#define RENESAS_INTC2EIC170                             INTC2_EIC170
#define RENESAS_INTC2EIC170L                            INTC2_EIC170L
#define RENESAS_INTC2EIC170H                            INTC2_EIC170H
#define RENESAS_INTC2EIC171                             INTC2_EIC171
#define RENESAS_INTC2EIC171L                            INTC2_EIC171L
#define RENESAS_INTC2EIC171H                            INTC2_EIC171H
#define RENESAS_INTC2EIC172                             INTC2_EIC172
#define RENESAS_INTC2EIC172L                            INTC2_EIC172L
#define RENESAS_INTC2EIC172H                            INTC2_EIC172H
#define RENESAS_INTC2EIC173                             INTC2_EIC173
#define RENESAS_INTC2EIC173L                            INTC2_EIC173L
#define RENESAS_INTC2EIC173H                            INTC2_EIC173H
#define RENESAS_INTC2EIC174                             INTC2_EIC174
#define RENESAS_INTC2EIC174L                            INTC2_EIC174L
#define RENESAS_INTC2EIC174H                            INTC2_EIC174H
#define RENESAS_INTC2EIC175                             INTC2_EIC175
#define RENESAS_INTC2EIC175L                            INTC2_EIC175L
#define RENESAS_INTC2EIC175H                            INTC2_EIC175H
#define RENESAS_INTC2EIC176                             INTC2_EIC176
#define RENESAS_INTC2EIC176L                            INTC2_EIC176L
#define RENESAS_INTC2EIC176H                            INTC2_EIC176H
#define RENESAS_INTC2EIC177                             INTC2_EIC177
#define RENESAS_INTC2EIC177L                            INTC2_EIC177L
#define RENESAS_INTC2EIC177H                            INTC2_EIC177H
#define RENESAS_INTC2EIC178                             INTC2_EIC178
#define RENESAS_INTC2EIC178L                            INTC2_EIC178L
#define RENESAS_INTC2EIC178H                            INTC2_EIC178H
#define RENESAS_INTC2EIC179                             INTC2_EIC179
#define RENESAS_INTC2EIC179L                            INTC2_EIC179L
#define RENESAS_INTC2EIC179H                            INTC2_EIC179H
#define RENESAS_INTC2EIC180                             INTC2_EIC180
#define RENESAS_INTC2EIC180L                            INTC2_EIC180L
#define RENESAS_INTC2EIC180H                            INTC2_EIC180H
#define RENESAS_INTC2EIC181                             INTC2_EIC181
#define RENESAS_INTC2EIC181L                            INTC2_EIC181L
#define RENESAS_INTC2EIC181H                            INTC2_EIC181H
#define RENESAS_INTC2EIC182                             INTC2_EIC182
#define RENESAS_INTC2EIC182L                            INTC2_EIC182L
#define RENESAS_INTC2EIC182H                            INTC2_EIC182H
#define RENESAS_INTC2EIC183                             INTC2_EIC183
#define RENESAS_INTC2EIC183L                            INTC2_EIC183L
#define RENESAS_INTC2EIC183H                            INTC2_EIC183H
#define RENESAS_INTC2EIC184                             INTC2_EIC184
#define RENESAS_INTC2EIC184L                            INTC2_EIC184L
#define RENESAS_INTC2EIC184H                            INTC2_EIC184H
#define RENESAS_INTC2EIC185                             INTC2_EIC185
#define RENESAS_INTC2EIC185L                            INTC2_EIC185L
#define RENESAS_INTC2EIC185H                            INTC2_EIC185H
#define RENESAS_INTC2EIC186                             INTC2_EIC186
#define RENESAS_INTC2EIC186L                            INTC2_EIC186L
#define RENESAS_INTC2EIC186H                            INTC2_EIC186H
#define RENESAS_INTC2EIC187                             INTC2_EIC187
#define RENESAS_INTC2EIC187L                            INTC2_EIC187L
#define RENESAS_INTC2EIC187H                            INTC2_EIC187H
#define RENESAS_INTC2EIC188                             INTC2_EIC188
#define RENESAS_INTC2EIC188L                            INTC2_EIC188L
#define RENESAS_INTC2EIC188H                            INTC2_EIC188H
#define RENESAS_INTC2EIC189                             INTC2_EIC189
#define RENESAS_INTC2EIC189L                            INTC2_EIC189L
#define RENESAS_INTC2EIC189H                            INTC2_EIC189H
#define RENESAS_INTC2EIC190                             INTC2_EIC190
#define RENESAS_INTC2EIC190L                            INTC2_EIC190L
#define RENESAS_INTC2EIC190H                            INTC2_EIC190H
#define RENESAS_INTC2EIC191                             INTC2_EIC191
#define RENESAS_INTC2EIC191L                            INTC2_EIC191L
#define RENESAS_INTC2EIC191H                            INTC2_EIC191H
#define RENESAS_INTC2EIC192                             INTC2_EIC192
#define RENESAS_INTC2EIC192L                            INTC2_EIC192L
#define RENESAS_INTC2EIC192H                            INTC2_EIC192H
#define RENESAS_INTC2EIC193                             INTC2_EIC193
#define RENESAS_INTC2EIC193L                            INTC2_EIC193L
#define RENESAS_INTC2EIC193H                            INTC2_EIC193H
#define RENESAS_INTC2EIC194                             INTC2_EIC194
#define RENESAS_INTC2EIC194L                            INTC2_EIC194L
#define RENESAS_INTC2EIC194H                            INTC2_EIC194H
#define RENESAS_INTC2EIC195                             INTC2_EIC195
#define RENESAS_INTC2EIC195L                            INTC2_EIC195L
#define RENESAS_INTC2EIC195H                            INTC2_EIC195H
#define RENESAS_INTC2EIC196                             INTC2_EIC196
#define RENESAS_INTC2EIC196L                            INTC2_EIC196L
#define RENESAS_INTC2EIC196H                            INTC2_EIC196H
#define RENESAS_INTC2EIC197                             INTC2_EIC197
#define RENESAS_INTC2EIC197L                            INTC2_EIC197L
#define RENESAS_INTC2EIC197H                            INTC2_EIC197H
#define RENESAS_INTC2EIC198                             INTC2_EIC198
#define RENESAS_INTC2EIC198L                            INTC2_EIC198L
#define RENESAS_INTC2EIC198H                            INTC2_EIC198H
#define RENESAS_INTC2EIC199                             INTC2_EIC199
#define RENESAS_INTC2EIC199L                            INTC2_EIC199L
#define RENESAS_INTC2EIC199H                            INTC2_EIC199H
#define RENESAS_INTC2EIC200                             INTC2_EIC200
#define RENESAS_INTC2EIC200L                            INTC2_EIC200L
#define RENESAS_INTC2EIC200H                            INTC2_EIC200H
#define RENESAS_INTC2EIC201                             INTC2_EIC201
#define RENESAS_INTC2EIC201L                            INTC2_EIC201L
#define RENESAS_INTC2EIC201H                            INTC2_EIC201H
#define RENESAS_INTC2EIC202                             INTC2_EIC202
#define RENESAS_INTC2EIC202L                            INTC2_EIC202L
#define RENESAS_INTC2EIC202H                            INTC2_EIC202H
#define RENESAS_INTC2EIC203                             INTC2_EIC203
#define RENESAS_INTC2EIC203L                            INTC2_EIC203L
#define RENESAS_INTC2EIC203H                            INTC2_EIC203H
#define RENESAS_INTC2EIC204                             INTC2_EIC204
#define RENESAS_INTC2EIC204L                            INTC2_EIC204L
#define RENESAS_INTC2EIC204H                            INTC2_EIC204H
#define RENESAS_INTC2EIC205                             INTC2_EIC205
#define RENESAS_INTC2EIC205L                            INTC2_EIC205L
#define RENESAS_INTC2EIC205H                            INTC2_EIC205H
#define RENESAS_INTC2EIC206                             INTC2_EIC206
#define RENESAS_INTC2EIC206L                            INTC2_EIC206L
#define RENESAS_INTC2EIC206H                            INTC2_EIC206H
#define RENESAS_INTC2EIC207                             INTC2_EIC207
#define RENESAS_INTC2EIC207L                            INTC2_EIC207L
#define RENESAS_INTC2EIC207H                            INTC2_EIC207H
#define RENESAS_INTC2EIC208                             INTC2_EIC208
#define RENESAS_INTC2EIC208L                            INTC2_EIC208L
#define RENESAS_INTC2EIC208H                            INTC2_EIC208H
#define RENESAS_INTC2EIC209                             INTC2_EIC209
#define RENESAS_INTC2EIC209L                            INTC2_EIC209L
#define RENESAS_INTC2EIC209H                            INTC2_EIC209H
#define RENESAS_INTC2EIC210                             INTC2_EIC210
#define RENESAS_INTC2EIC210L                            INTC2_EIC210L
#define RENESAS_INTC2EIC210H                            INTC2_EIC210H
#define RENESAS_INTC2EIC211                             INTC2_EIC211
#define RENESAS_INTC2EIC211L                            INTC2_EIC211L
#define RENESAS_INTC2EIC211H                            INTC2_EIC211H
#define RENESAS_INTC2EIC212                             INTC2_EIC212
#define RENESAS_INTC2EIC212L                            INTC2_EIC212L
#define RENESAS_INTC2EIC212H                            INTC2_EIC212H
#define RENESAS_INTC2EIC213                             INTC2_EIC213
#define RENESAS_INTC2EIC213L                            INTC2_EIC213L
#define RENESAS_INTC2EIC213H                            INTC2_EIC213H
#define RENESAS_INTC2EIC214                             INTC2_EIC214
#define RENESAS_INTC2EIC214L                            INTC2_EIC214L
#define RENESAS_INTC2EIC214H                            INTC2_EIC214H
#define RENESAS_INTC2EIC215                             INTC2_EIC215
#define RENESAS_INTC2EIC215L                            INTC2_EIC215L
#define RENESAS_INTC2EIC215H                            INTC2_EIC215H
#define RENESAS_INTC2EIC216                             INTC2_EIC216
#define RENESAS_INTC2EIC216L                            INTC2_EIC216L
#define RENESAS_INTC2EIC216H                            INTC2_EIC216H
#define RENESAS_INTC2EIC217                             INTC2_EIC217
#define RENESAS_INTC2EIC217L                            INTC2_EIC217L
#define RENESAS_INTC2EIC217H                            INTC2_EIC217H
#define RENESAS_INTC2EIC218                             INTC2_EIC218
#define RENESAS_INTC2EIC218L                            INTC2_EIC218L
#define RENESAS_INTC2EIC218H                            INTC2_EIC218H
#define RENESAS_INTC2EIC219                             INTC2_EIC219
#define RENESAS_INTC2EIC219L                            INTC2_EIC219L
#define RENESAS_INTC2EIC219H                            INTC2_EIC219H
#define RENESAS_INTC2EIC220                             INTC2_EIC220
#define RENESAS_INTC2EIC220L                            INTC2_EIC220L
#define RENESAS_INTC2EIC220H                            INTC2_EIC220H
#define RENESAS_INTC2EIC221                             INTC2_EIC221
#define RENESAS_INTC2EIC221L                            INTC2_EIC221L
#define RENESAS_INTC2EIC221H                            INTC2_EIC221H
#define RENESAS_INTC2EIC222                             INTC2_EIC222
#define RENESAS_INTC2EIC222L                            INTC2_EIC222L
#define RENESAS_INTC2EIC222H                            INTC2_EIC222H
#define RENESAS_INTC2EIC223                             INTC2_EIC223
#define RENESAS_INTC2EIC223L                            INTC2_EIC223L
#define RENESAS_INTC2EIC223H                            INTC2_EIC223H
#define RENESAS_INTC2EIC224                             INTC2_EIC224
#define RENESAS_INTC2EIC224L                            INTC2_EIC224L
#define RENESAS_INTC2EIC224H                            INTC2_EIC224H
#define RENESAS_INTC2EIC225                             INTC2_EIC225
#define RENESAS_INTC2EIC225L                            INTC2_EIC225L
#define RENESAS_INTC2EIC225H                            INTC2_EIC225H
#define RENESAS_INTC2EIC226                             INTC2_EIC226
#define RENESAS_INTC2EIC226L                            INTC2_EIC226L
#define RENESAS_INTC2EIC226H                            INTC2_EIC226H
#define RENESAS_INTC2EIC227                             INTC2_EIC227
#define RENESAS_INTC2EIC227L                            INTC2_EIC227L
#define RENESAS_INTC2EIC227H                            INTC2_EIC227H
#define RENESAS_INTC2EIC228                             INTC2_EIC228
#define RENESAS_INTC2EIC228L                            INTC2_EIC228L
#define RENESAS_INTC2EIC228H                            INTC2_EIC228H
#define RENESAS_INTC2EIC229                             INTC2_EIC229
#define RENESAS_INTC2EIC229L                            INTC2_EIC229L
#define RENESAS_INTC2EIC229H                            INTC2_EIC229H
#define RENESAS_INTC2EIC230                             INTC2_EIC230
#define RENESAS_INTC2EIC230L                            INTC2_EIC230L
#define RENESAS_INTC2EIC230H                            INTC2_EIC230H
#define RENESAS_INTC2EIC231                             INTC2_EIC231
#define RENESAS_INTC2EIC231L                            INTC2_EIC231L
#define RENESAS_INTC2EIC231H                            INTC2_EIC231H
#define RENESAS_INTC2EIC232                             INTC2_EIC232
#define RENESAS_INTC2EIC232L                            INTC2_EIC232L
#define RENESAS_INTC2EIC232H                            INTC2_EIC232H
#define RENESAS_INTC2EIC233                             INTC2_EIC233
#define RENESAS_INTC2EIC233L                            INTC2_EIC233L
#define RENESAS_INTC2EIC233H                            INTC2_EIC233H
#define RENESAS_INTC2EIC234                             INTC2_EIC234
#define RENESAS_INTC2EIC234L                            INTC2_EIC234L
#define RENESAS_INTC2EIC234H                            INTC2_EIC234H
#define RENESAS_INTC2EIC235                             INTC2_EIC235
#define RENESAS_INTC2EIC235L                            INTC2_EIC235L
#define RENESAS_INTC2EIC235H                            INTC2_EIC235H
#define RENESAS_INTC2EIC236                             INTC2_EIC236
#define RENESAS_INTC2EIC236L                            INTC2_EIC236L
#define RENESAS_INTC2EIC236H                            INTC2_EIC236H
#define RENESAS_INTC2EIC237                             INTC2_EIC237
#define RENESAS_INTC2EIC237L                            INTC2_EIC237L
#define RENESAS_INTC2EIC237H                            INTC2_EIC237H
#define RENESAS_INTC2EIC238                             INTC2_EIC238
#define RENESAS_INTC2EIC238L                            INTC2_EIC238L
#define RENESAS_INTC2EIC238H                            INTC2_EIC238H
#define RENESAS_INTC2EIC239                             INTC2_EIC239
#define RENESAS_INTC2EIC239L                            INTC2_EIC239L
#define RENESAS_INTC2EIC239H                            INTC2_EIC239H
#define RENESAS_INTC2EIC240                             INTC2_EIC240
#define RENESAS_INTC2EIC240L                            INTC2_EIC240L
#define RENESAS_INTC2EIC240H                            INTC2_EIC240H
#define RENESAS_INTC2EIC241                             INTC2_EIC241
#define RENESAS_INTC2EIC241L                            INTC2_EIC241L
#define RENESAS_INTC2EIC241H                            INTC2_EIC241H
#define RENESAS_INTC2EIC242                             INTC2_EIC242
#define RENESAS_INTC2EIC242L                            INTC2_EIC242L
#define RENESAS_INTC2EIC242H                            INTC2_EIC242H
#define RENESAS_INTC2EIC243                             INTC2_EIC243
#define RENESAS_INTC2EIC243L                            INTC2_EIC243L
#define RENESAS_INTC2EIC243H                            INTC2_EIC243H
#define RENESAS_INTC2EIC244                             INTC2_EIC244
#define RENESAS_INTC2EIC244L                            INTC2_EIC244L
#define RENESAS_INTC2EIC244H                            INTC2_EIC244H
#define RENESAS_INTC2EIC245                             INTC2_EIC245
#define RENESAS_INTC2EIC245L                            INTC2_EIC245L
#define RENESAS_INTC2EIC245H                            INTC2_EIC245H
#define RENESAS_INTC2EIC246                             INTC2_EIC246
#define RENESAS_INTC2EIC246L                            INTC2_EIC246L
#define RENESAS_INTC2EIC246H                            INTC2_EIC246H
#define RENESAS_INTC2EIC247                             INTC2_EIC247
#define RENESAS_INTC2EIC247L                            INTC2_EIC247L
#define RENESAS_INTC2EIC247H                            INTC2_EIC247H
#define RENESAS_INTC2EIC248                             INTC2_EIC248
#define RENESAS_INTC2EIC248L                            INTC2_EIC248L
#define RENESAS_INTC2EIC248H                            INTC2_EIC248H
#define RENESAS_INTC2EIC249                             INTC2_EIC249
#define RENESAS_INTC2EIC249L                            INTC2_EIC249L
#define RENESAS_INTC2EIC249H                            INTC2_EIC249H
#define RENESAS_INTC2EIC250                             INTC2_EIC250
#define RENESAS_INTC2EIC250L                            INTC2_EIC250L
#define RENESAS_INTC2EIC250H                            INTC2_EIC250H
#define RENESAS_INTC2EIC251                             INTC2_EIC251
#define RENESAS_INTC2EIC251L                            INTC2_EIC251L
#define RENESAS_INTC2EIC251H                            INTC2_EIC251H
#define RENESAS_INTC2EIC252                             INTC2_EIC252
#define RENESAS_INTC2EIC252L                            INTC2_EIC252L
#define RENESAS_INTC2EIC252H                            INTC2_EIC252H
#define RENESAS_INTC2EIC253                             INTC2_EIC253
#define RENESAS_INTC2EIC253L                            INTC2_EIC253L
#define RENESAS_INTC2EIC253H                            INTC2_EIC253H
#define RENESAS_INTC2EIC254                             INTC2_EIC254
#define RENESAS_INTC2EIC254L                            INTC2_EIC254L
#define RENESAS_INTC2EIC254H                            INTC2_EIC254H
#define RENESAS_INTC2EIC255                             INTC2_EIC255
#define RENESAS_INTC2EIC255L                            INTC2_EIC255L
#define RENESAS_INTC2EIC255H                            INTC2_EIC255H
#define RENESAS_INTC2EIC256                             INTC2_EIC256
#define RENESAS_INTC2EIC256L                            INTC2_EIC256L
#define RENESAS_INTC2EIC256H                            INTC2_EIC256H
#define RENESAS_INTC2EIC257                             INTC2_EIC257
#define RENESAS_INTC2EIC257L                            INTC2_EIC257L
#define RENESAS_INTC2EIC257H                            INTC2_EIC257H
#define RENESAS_INTC2EIC258                             INTC2_EIC258
#define RENESAS_INTC2EIC258L                            INTC2_EIC258L
#define RENESAS_INTC2EIC258H                            INTC2_EIC258H
#define RENESAS_INTC2EIC259                             INTC2_EIC259
#define RENESAS_INTC2EIC259L                            INTC2_EIC259L
#define RENESAS_INTC2EIC259H                            INTC2_EIC259H
#define RENESAS_INTC2EIC260                             INTC2_EIC260
#define RENESAS_INTC2EIC260L                            INTC2_EIC260L
#define RENESAS_INTC2EIC260H                            INTC2_EIC260H
#define RENESAS_INTC2EIC261                             INTC2_EIC261
#define RENESAS_INTC2EIC261L                            INTC2_EIC261L
#define RENESAS_INTC2EIC261H                            INTC2_EIC261H
#define RENESAS_INTC2EIC262                             INTC2_EIC262
#define RENESAS_INTC2EIC262L                            INTC2_EIC262L
#define RENESAS_INTC2EIC262H                            INTC2_EIC262H
#define RENESAS_INTC2EIC263                             INTC2_EIC263
#define RENESAS_INTC2EIC263L                            INTC2_EIC263L
#define RENESAS_INTC2EIC263H                            INTC2_EIC263H
#define RENESAS_INTC2EIC264                             INTC2_EIC264
#define RENESAS_INTC2EIC264L                            INTC2_EIC264L
#define RENESAS_INTC2EIC264H                            INTC2_EIC264H
#define RENESAS_INTC2EIC265                             INTC2_EIC265
#define RENESAS_INTC2EIC265L                            INTC2_EIC265L
#define RENESAS_INTC2EIC265H                            INTC2_EIC265H
#define RENESAS_INTC2EIC266                             INTC2_EIC266
#define RENESAS_INTC2EIC266L                            INTC2_EIC266L
#define RENESAS_INTC2EIC266H                            INTC2_EIC266H
#define RENESAS_INTC2EIC267                             INTC2_EIC267
#define RENESAS_INTC2EIC267L                            INTC2_EIC267L
#define RENESAS_INTC2EIC267H                            INTC2_EIC267H
#define RENESAS_INTC2EIC268                             INTC2_EIC268
#define RENESAS_INTC2EIC268L                            INTC2_EIC268L
#define RENESAS_INTC2EIC268H                            INTC2_EIC268H
#define RENESAS_INTC2EIC269                             INTC2_EIC269
#define RENESAS_INTC2EIC269L                            INTC2_EIC269L
#define RENESAS_INTC2EIC269H                            INTC2_EIC269H
#define RENESAS_INTC2EIC270                             INTC2_EIC270
#define RENESAS_INTC2EIC270L                            INTC2_EIC270L
#define RENESAS_INTC2EIC270H                            INTC2_EIC270H
#define RENESAS_INTC2EIC271                             INTC2_EIC271
#define RENESAS_INTC2EIC271L                            INTC2_EIC271L
#define RENESAS_INTC2EIC271H                            INTC2_EIC271H
#define RENESAS_INTC2EIC272                             INTC2_EIC272
#define RENESAS_INTC2EIC272L                            INTC2_EIC272L
#define RENESAS_INTC2EIC272H                            INTC2_EIC272H
#define RENESAS_INTC2EIC273                             INTC2_EIC273
#define RENESAS_INTC2EIC273L                            INTC2_EIC273L
#define RENESAS_INTC2EIC273H                            INTC2_EIC273H
#define RENESAS_INTC2EIC274                             INTC2_EIC274
#define RENESAS_INTC2EIC274L                            INTC2_EIC274L
#define RENESAS_INTC2EIC274H                            INTC2_EIC274H
#define RENESAS_INTC2EIC275                             INTC2_EIC275
#define RENESAS_INTC2EIC275L                            INTC2_EIC275L
#define RENESAS_INTC2EIC275H                            INTC2_EIC275H
#define RENESAS_INTC2EIC276                             INTC2_EIC276
#define RENESAS_INTC2EIC276L                            INTC2_EIC276L
#define RENESAS_INTC2EIC276H                            INTC2_EIC276H
#define RENESAS_INTC2EIC277                             INTC2_EIC277
#define RENESAS_INTC2EIC277L                            INTC2_EIC277L
#define RENESAS_INTC2EIC277H                            INTC2_EIC277H
#define RENESAS_INTC2EIC278                             INTC2_EIC278
#define RENESAS_INTC2EIC278L                            INTC2_EIC278L
#define RENESAS_INTC2EIC278H                            INTC2_EIC278H
#define RENESAS_INTC2EIC279                             INTC2_EIC279
#define RENESAS_INTC2EIC279L                            INTC2_EIC279L
#define RENESAS_INTC2EIC279H                            INTC2_EIC279H
#define RENESAS_INTC2EIC280                             INTC2_EIC280
#define RENESAS_INTC2EIC280L                            INTC2_EIC280L
#define RENESAS_INTC2EIC280H                            INTC2_EIC280H
#define RENESAS_INTC2EIC281                             INTC2_EIC281
#define RENESAS_INTC2EIC281L                            INTC2_EIC281L
#define RENESAS_INTC2EIC281H                            INTC2_EIC281H
#define RENESAS_INTC2EIC282                             INTC2_EIC282
#define RENESAS_INTC2EIC282L                            INTC2_EIC282L
#define RENESAS_INTC2EIC282H                            INTC2_EIC282H
#define RENESAS_INTC2EIC283                             INTC2_EIC283
#define RENESAS_INTC2EIC283L                            INTC2_EIC283L
#define RENESAS_INTC2EIC283H                            INTC2_EIC283H
#define RENESAS_INTC2EIC284                             INTC2_EIC284
#define RENESAS_INTC2EIC284L                            INTC2_EIC284L
#define RENESAS_INTC2EIC284H                            INTC2_EIC284H
#define RENESAS_INTC2EIC285                             INTC2_EIC285
#define RENESAS_INTC2EIC285L                            INTC2_EIC285L
#define RENESAS_INTC2EIC285H                            INTC2_EIC285H
#define RENESAS_INTC2EIC286                             INTC2_EIC286
#define RENESAS_INTC2EIC286L                            INTC2_EIC286L
#define RENESAS_INTC2EIC286H                            INTC2_EIC286H
#define RENESAS_INTC2EIC287                             INTC2_EIC287
#define RENESAS_INTC2EIC287L                            INTC2_EIC287L
#define RENESAS_INTC2EIC287H                            INTC2_EIC287H
#define RENESAS_INTC2EIC288                             INTC2_EIC288
#define RENESAS_INTC2EIC288L                            INTC2_EIC288L
#define RENESAS_INTC2EIC288H                            INTC2_EIC288H
#define RENESAS_INTC2EIC289                             INTC2_EIC289
#define RENESAS_INTC2EIC289L                            INTC2_EIC289L
#define RENESAS_INTC2EIC289H                            INTC2_EIC289H
#define RENESAS_INTC2EIC290                             INTC2_EIC290
#define RENESAS_INTC2EIC290L                            INTC2_EIC290L
#define RENESAS_INTC2EIC290H                            INTC2_EIC290H
#define RENESAS_INTC2EIC291                             INTC2_EIC291
#define RENESAS_INTC2EIC291L                            INTC2_EIC291L
#define RENESAS_INTC2EIC291H                            INTC2_EIC291H
#define RENESAS_INTC2EIC292                             INTC2_EIC292
#define RENESAS_INTC2EIC292L                            INTC2_EIC292L
#define RENESAS_INTC2EIC292H                            INTC2_EIC292H
#define RENESAS_INTC2EIC293                             INTC2_EIC293
#define RENESAS_INTC2EIC293L                            INTC2_EIC293L
#define RENESAS_INTC2EIC293H                            INTC2_EIC293H
#define RENESAS_INTC2EIC294                             INTC2_EIC294
#define RENESAS_INTC2EIC294L                            INTC2_EIC294L
#define RENESAS_INTC2EIC294H                            INTC2_EIC294H
#define RENESAS_INTC2EIC295                             INTC2_EIC295
#define RENESAS_INTC2EIC295L                            INTC2_EIC295L
#define RENESAS_INTC2EIC295H                            INTC2_EIC295H
#define RENESAS_INTC2EIC296                             INTC2_EIC296
#define RENESAS_INTC2EIC296L                            INTC2_EIC296L
#define RENESAS_INTC2EIC296H                            INTC2_EIC296H
#define RENESAS_INTC2EIC297                             INTC2_EIC297
#define RENESAS_INTC2EIC297L                            INTC2_EIC297L
#define RENESAS_INTC2EIC297H                            INTC2_EIC297H
#define RENESAS_INTC2EIC298                             INTC2_EIC298
#define RENESAS_INTC2EIC298L                            INTC2_EIC298L
#define RENESAS_INTC2EIC298H                            INTC2_EIC298H
#define RENESAS_INTC2EIC299                             INTC2_EIC299
#define RENESAS_INTC2EIC299L                            INTC2_EIC299L
#define RENESAS_INTC2EIC299H                            INTC2_EIC299H
#define RENESAS_INTC2EIC300                             INTC2_EIC300
#define RENESAS_INTC2EIC300L                            INTC2_EIC300L
#define RENESAS_INTC2EIC300H                            INTC2_EIC300H
#define RENESAS_INTC2EIC301                             INTC2_EIC301
#define RENESAS_INTC2EIC301L                            INTC2_EIC301L
#define RENESAS_INTC2EIC301H                            INTC2_EIC301H
#define RENESAS_INTC2EIC302                             INTC2_EIC302
#define RENESAS_INTC2EIC302L                            INTC2_EIC302L
#define RENESAS_INTC2EIC302H                            INTC2_EIC302H
#define RENESAS_INTC2EIC303                             INTC2_EIC303
#define RENESAS_INTC2EIC303L                            INTC2_EIC303L
#define RENESAS_INTC2EIC303H                            INTC2_EIC303H
#define RENESAS_INTC2EIC304                             INTC2_EIC304
#define RENESAS_INTC2EIC304L                            INTC2_EIC304L
#define RENESAS_INTC2EIC304H                            INTC2_EIC304H
#define RENESAS_INTC2EIC305                             INTC2_EIC305
#define RENESAS_INTC2EIC305L                            INTC2_EIC305L
#define RENESAS_INTC2EIC305H                            INTC2_EIC305H
#define RENESAS_INTC2EIC306                             INTC2_EIC306
#define RENESAS_INTC2EIC306L                            INTC2_EIC306L
#define RENESAS_INTC2EIC306H                            INTC2_EIC306H
#define RENESAS_INTC2EIC307                             INTC2_EIC307
#define RENESAS_INTC2EIC307L                            INTC2_EIC307L
#define RENESAS_INTC2EIC307H                            INTC2_EIC307H
#define RENESAS_INTC2EIC308                             INTC2_EIC308
#define RENESAS_INTC2EIC308L                            INTC2_EIC308L
#define RENESAS_INTC2EIC308H                            INTC2_EIC308H
#define RENESAS_INTC2EIC309                             INTC2_EIC309
#define RENESAS_INTC2EIC309L                            INTC2_EIC309L
#define RENESAS_INTC2EIC309H                            INTC2_EIC309H
#define RENESAS_INTC2EIC310                             INTC2_EIC310
#define RENESAS_INTC2EIC310L                            INTC2_EIC310L
#define RENESAS_INTC2EIC310H                            INTC2_EIC310H
#define RENESAS_INTC2EIC311                             INTC2_EIC311
#define RENESAS_INTC2EIC311L                            INTC2_EIC311L
#define RENESAS_INTC2EIC311H                            INTC2_EIC311H
#define RENESAS_INTC2EIC312                             INTC2_EIC312
#define RENESAS_INTC2EIC312L                            INTC2_EIC312L
#define RENESAS_INTC2EIC312H                            INTC2_EIC312H
#define RENESAS_INTC2EIC313                             INTC2_EIC313
#define RENESAS_INTC2EIC313L                            INTC2_EIC313L
#define RENESAS_INTC2EIC313H                            INTC2_EIC313H
#define RENESAS_INTC2EIC314                             INTC2_EIC314
#define RENESAS_INTC2EIC314L                            INTC2_EIC314L
#define RENESAS_INTC2EIC314H                            INTC2_EIC314H
#define RENESAS_INTC2EIC315                             INTC2_EIC315
#define RENESAS_INTC2EIC315L                            INTC2_EIC315L
#define RENESAS_INTC2EIC315H                            INTC2_EIC315H
#define RENESAS_INTC2EIC316                             INTC2_EIC316
#define RENESAS_INTC2EIC316L                            INTC2_EIC316L
#define RENESAS_INTC2EIC316H                            INTC2_EIC316H
#define RENESAS_INTC2EIC317                             INTC2_EIC317
#define RENESAS_INTC2EIC317L                            INTC2_EIC317L
#define RENESAS_INTC2EIC317H                            INTC2_EIC317H
#define RENESAS_INTC2EIC318                             INTC2_EIC318
#define RENESAS_INTC2EIC318L                            INTC2_EIC318L
#define RENESAS_INTC2EIC318H                            INTC2_EIC318H
#define RENESAS_INTC2EIC319                             INTC2_EIC319
#define RENESAS_INTC2EIC319L                            INTC2_EIC319L
#define RENESAS_INTC2EIC319H                            INTC2_EIC319H
#define RENESAS_INTC2EIC320                             INTC2_EIC320
#define RENESAS_INTC2EIC320L                            INTC2_EIC320L
#define RENESAS_INTC2EIC320H                            INTC2_EIC320H
#define RENESAS_INTC2EIC321                             INTC2_EIC321
#define RENESAS_INTC2EIC321L                            INTC2_EIC321L
#define RENESAS_INTC2EIC321H                            INTC2_EIC321H
#define RENESAS_INTC2EIC322                             INTC2_EIC322
#define RENESAS_INTC2EIC322L                            INTC2_EIC322L
#define RENESAS_INTC2EIC322H                            INTC2_EIC322H
#define RENESAS_INTC2EIC323                             INTC2_EIC323
#define RENESAS_INTC2EIC323L                            INTC2_EIC323L
#define RENESAS_INTC2EIC323H                            INTC2_EIC323H
#define RENESAS_INTC2EIC324                             INTC2_EIC324
#define RENESAS_INTC2EIC324L                            INTC2_EIC324L
#define RENESAS_INTC2EIC324H                            INTC2_EIC324H
#define RENESAS_INTC2EIC325                             INTC2_EIC325
#define RENESAS_INTC2EIC325L                            INTC2_EIC325L
#define RENESAS_INTC2EIC325H                            INTC2_EIC325H
#define RENESAS_INTC2EIC326                             INTC2_EIC326
#define RENESAS_INTC2EIC326L                            INTC2_EIC326L
#define RENESAS_INTC2EIC326H                            INTC2_EIC326H
#define RENESAS_INTC2EIC327                             INTC2_EIC327
#define RENESAS_INTC2EIC327L                            INTC2_EIC327L
#define RENESAS_INTC2EIC327H                            INTC2_EIC327H
#define RENESAS_INTC2EIC328                             INTC2_EIC328
#define RENESAS_INTC2EIC328L                            INTC2_EIC328L
#define RENESAS_INTC2EIC328H                            INTC2_EIC328H
#define RENESAS_INTC2EIC329                             INTC2_EIC329
#define RENESAS_INTC2EIC329L                            INTC2_EIC329L
#define RENESAS_INTC2EIC329H                            INTC2_EIC329H
#define RENESAS_INTC2EIC330                             INTC2_EIC330
#define RENESAS_INTC2EIC330L                            INTC2_EIC330L
#define RENESAS_INTC2EIC330H                            INTC2_EIC330H
#define RENESAS_INTC2EIC331                             INTC2_EIC331
#define RENESAS_INTC2EIC331L                            INTC2_EIC331L
#define RENESAS_INTC2EIC331H                            INTC2_EIC331H
#define RENESAS_INTC2EIC332                             INTC2_EIC332
#define RENESAS_INTC2EIC332L                            INTC2_EIC332L
#define RENESAS_INTC2EIC332H                            INTC2_EIC332H
#define RENESAS_INTC2EIC333                             INTC2_EIC333
#define RENESAS_INTC2EIC333L                            INTC2_EIC333L
#define RENESAS_INTC2EIC333H                            INTC2_EIC333H
#define RENESAS_INTC2EIC334                             INTC2_EIC334
#define RENESAS_INTC2EIC334L                            INTC2_EIC334L
#define RENESAS_INTC2EIC334H                            INTC2_EIC334H
#define RENESAS_INTC2EIC335                             INTC2_EIC335
#define RENESAS_INTC2EIC335L                            INTC2_EIC335L
#define RENESAS_INTC2EIC335H                            INTC2_EIC335H
#define RENESAS_INTC2EIC336                             INTC2_EIC336
#define RENESAS_INTC2EIC336L                            INTC2_EIC336L
#define RENESAS_INTC2EIC336H                            INTC2_EIC336H
#define RENESAS_INTC2EIC337                             INTC2_EIC337
#define RENESAS_INTC2EIC337L                            INTC2_EIC337L
#define RENESAS_INTC2EIC337H                            INTC2_EIC337H
#define RENESAS_INTC2EIC338                             INTC2_EIC338
#define RENESAS_INTC2EIC338L                            INTC2_EIC338L
#define RENESAS_INTC2EIC338H                            INTC2_EIC338H
#define RENESAS_INTC2EIC339                             INTC2_EIC339
#define RENESAS_INTC2EIC339L                            INTC2_EIC339L
#define RENESAS_INTC2EIC339H                            INTC2_EIC339H
#define RENESAS_INTC2EIC340                             INTC2_EIC340
#define RENESAS_INTC2EIC340L                            INTC2_EIC340L
#define RENESAS_INTC2EIC340H                            INTC2_EIC340H
#define RENESAS_INTC2EIC341                             INTC2_EIC341
#define RENESAS_INTC2EIC341L                            INTC2_EIC341L
#define RENESAS_INTC2EIC341H                            INTC2_EIC341H
#define RENESAS_INTC2EIC342                             INTC2_EIC342
#define RENESAS_INTC2EIC342L                            INTC2_EIC342L
#define RENESAS_INTC2EIC342H                            INTC2_EIC342H
#define RENESAS_INTC2EIC343                             INTC2_EIC343
#define RENESAS_INTC2EIC343L                            INTC2_EIC343L
#define RENESAS_INTC2EIC343H                            INTC2_EIC343H
#define RENESAS_INTC2EIC344                             INTC2_EIC344
#define RENESAS_INTC2EIC344L                            INTC2_EIC344L
#define RENESAS_INTC2EIC344H                            INTC2_EIC344H
#define RENESAS_INTC2EIC345                             INTC2_EIC345
#define RENESAS_INTC2EIC345L                            INTC2_EIC345L
#define RENESAS_INTC2EIC345H                            INTC2_EIC345H
#define RENESAS_INTC2EIC346                             INTC2_EIC346
#define RENESAS_INTC2EIC346L                            INTC2_EIC346L
#define RENESAS_INTC2EIC346H                            INTC2_EIC346H
#define RENESAS_INTC2EIC347                             INTC2_EIC347
#define RENESAS_INTC2EIC347L                            INTC2_EIC347L
#define RENESAS_INTC2EIC347H                            INTC2_EIC347H
#define RENESAS_INTC2EIC348                             INTC2_EIC348
#define RENESAS_INTC2EIC348L                            INTC2_EIC348L
#define RENESAS_INTC2EIC348H                            INTC2_EIC348H
#define RENESAS_INTC2EIC349                             INTC2_EIC349
#define RENESAS_INTC2EIC349L                            INTC2_EIC349L
#define RENESAS_INTC2EIC349H                            INTC2_EIC349H
#define RENESAS_INTC2EIC350                             INTC2_EIC350
#define RENESAS_INTC2EIC350L                            INTC2_EIC350L
#define RENESAS_INTC2EIC350H                            INTC2_EIC350H
#define RENESAS_INTC2EIC351                             INTC2_EIC351
#define RENESAS_INTC2EIC351L                            INTC2_EIC351L
#define RENESAS_INTC2EIC351H                            INTC2_EIC351H
#define RENESAS_INTC2EIC352                             INTC2_EIC352
#define RENESAS_INTC2EIC352L                            INTC2_EIC352L
#define RENESAS_INTC2EIC352H                            INTC2_EIC352H
#define RENESAS_INTC2EIC353                             INTC2_EIC353
#define RENESAS_INTC2EIC353L                            INTC2_EIC353L
#define RENESAS_INTC2EIC353H                            INTC2_EIC353H
#define RENESAS_INTC2EIC354                             INTC2_EIC354
#define RENESAS_INTC2EIC354L                            INTC2_EIC354L
#define RENESAS_INTC2EIC354H                            INTC2_EIC354H
#define RENESAS_INTC2EIC355                             INTC2_EIC355
#define RENESAS_INTC2EIC355L                            INTC2_EIC355L
#define RENESAS_INTC2EIC355H                            INTC2_EIC355H
#define RENESAS_INTC2EIC356                             INTC2_EIC356
#define RENESAS_INTC2EIC356L                            INTC2_EIC356L
#define RENESAS_INTC2EIC356H                            INTC2_EIC356H
#define RENESAS_INTC2EIC357                             INTC2_EIC357
#define RENESAS_INTC2EIC357L                            INTC2_EIC357L
#define RENESAS_INTC2EIC357H                            INTC2_EIC357H
#define RENESAS_INTC2EIC358                             INTC2_EIC358
#define RENESAS_INTC2EIC358L                            INTC2_EIC358L
#define RENESAS_INTC2EIC358H                            INTC2_EIC358H
#define RENESAS_INTC2EIC359                             INTC2_EIC359
#define RENESAS_INTC2EIC359L                            INTC2_EIC359L
#define RENESAS_INTC2EIC359H                            INTC2_EIC359H
#define RENESAS_INTC2EIC360                             INTC2_EIC360
#define RENESAS_INTC2EIC360L                            INTC2_EIC360L
#define RENESAS_INTC2EIC360H                            INTC2_EIC360H
#define RENESAS_INTC2EIC361                             INTC2_EIC361
#define RENESAS_INTC2EIC361L                            INTC2_EIC361L
#define RENESAS_INTC2EIC361H                            INTC2_EIC361H
#define RENESAS_INTC2EIC362                             INTC2_EIC362
#define RENESAS_INTC2EIC362L                            INTC2_EIC362L
#define RENESAS_INTC2EIC362H                            INTC2_EIC362H
#define RENESAS_INTC2EIC363                             INTC2_EIC363
#define RENESAS_INTC2EIC363L                            INTC2_EIC363L
#define RENESAS_INTC2EIC363H                            INTC2_EIC363H
#define RENESAS_INTC2EIC364                             INTC2_EIC364
#define RENESAS_INTC2EIC364L                            INTC2_EIC364L
#define RENESAS_INTC2EIC364H                            INTC2_EIC364H
#define RENESAS_INTC2EIC365                             INTC2_EIC365
#define RENESAS_INTC2EIC365L                            INTC2_EIC365L
#define RENESAS_INTC2EIC365H                            INTC2_EIC365H
#define RENESAS_INTC2EIC366                             INTC2_EIC366
#define RENESAS_INTC2EIC366L                            INTC2_EIC366L
#define RENESAS_INTC2EIC366H                            INTC2_EIC366H
#define RENESAS_INTC2EIC367                             INTC2_EIC367
#define RENESAS_INTC2EIC367L                            INTC2_EIC367L
#define RENESAS_INTC2EIC367H                            INTC2_EIC367H
#define RENESAS_INTC2EIC368                             INTC2_EIC368
#define RENESAS_INTC2EIC368L                            INTC2_EIC368L
#define RENESAS_INTC2EIC368H                            INTC2_EIC368H
#define RENESAS_INTC2EIC369                             INTC2_EIC369
#define RENESAS_INTC2EIC369L                            INTC2_EIC369L
#define RENESAS_INTC2EIC369H                            INTC2_EIC369H
#define RENESAS_INTC2EIC370                             INTC2_EIC370
#define RENESAS_INTC2EIC370L                            INTC2_EIC370L
#define RENESAS_INTC2EIC370H                            INTC2_EIC370H
#define RENESAS_INTC2EIC371                             INTC2_EIC371
#define RENESAS_INTC2EIC371L                            INTC2_EIC371L
#define RENESAS_INTC2EIC371H                            INTC2_EIC371H
#define RENESAS_INTC2EIC372                             INTC2_EIC372
#define RENESAS_INTC2EIC372L                            INTC2_EIC372L
#define RENESAS_INTC2EIC372H                            INTC2_EIC372H
#define RENESAS_INTC2EIC373                             INTC2_EIC373
#define RENESAS_INTC2EIC373L                            INTC2_EIC373L
#define RENESAS_INTC2EIC373H                            INTC2_EIC373H
#define RENESAS_INTC2EIC374                             INTC2_EIC374
#define RENESAS_INTC2EIC374L                            INTC2_EIC374L
#define RENESAS_INTC2EIC374H                            INTC2_EIC374H
#define RENESAS_INTC2EIC375                             INTC2_EIC375
#define RENESAS_INTC2EIC375L                            INTC2_EIC375L
#define RENESAS_INTC2EIC375H                            INTC2_EIC375H
#define RENESAS_INTC2EIC376                             INTC2_EIC376
#define RENESAS_INTC2EIC376L                            INTC2_EIC376L
#define RENESAS_INTC2EIC376H                            INTC2_EIC376H
#define RENESAS_INTC2EIC377                             INTC2_EIC377
#define RENESAS_INTC2EIC377L                            INTC2_EIC377L
#define RENESAS_INTC2EIC377H                            INTC2_EIC377H
#define RENESAS_INTC2EIC378                             INTC2_EIC378
#define RENESAS_INTC2EIC378L                            INTC2_EIC378L
#define RENESAS_INTC2EIC378H                            INTC2_EIC378H
#define RENESAS_INTC2EIC379                             INTC2_EIC379
#define RENESAS_INTC2EIC379L                            INTC2_EIC379L
#define RENESAS_INTC2EIC379H                            INTC2_EIC379H
#define RENESAS_INTC2EIC380                             INTC2_EIC380
#define RENESAS_INTC2EIC380L                            INTC2_EIC380L
#define RENESAS_INTC2EIC380H                            INTC2_EIC380H
#define RENESAS_INTC2EIC381                             INTC2_EIC381
#define RENESAS_INTC2EIC381L                            INTC2_EIC381L
#define RENESAS_INTC2EIC381H                            INTC2_EIC381H
#define RENESAS_INTC2EIC382                             INTC2_EIC382
#define RENESAS_INTC2EIC382L                            INTC2_EIC382L
#define RENESAS_INTC2EIC382H                            INTC2_EIC382H
#define RENESAS_INTC2EIC383                             INTC2_EIC383
#define RENESAS_INTC2EIC383L                            INTC2_EIC383L
#define RENESAS_INTC2EIC383H                            INTC2_EIC383H
#define RENESAS_INTC2EIC384                             INTC2_EIC384
#define RENESAS_INTC2EIC384L                            INTC2_EIC384L
#define RENESAS_INTC2EIC384H                            INTC2_EIC384H
#define RENESAS_INTC2EIC385                             INTC2_EIC385
#define RENESAS_INTC2EIC385L                            INTC2_EIC385L
#define RENESAS_INTC2EIC385H                            INTC2_EIC385H
#define RENESAS_INTC2EIC386                             INTC2_EIC386
#define RENESAS_INTC2EIC386L                            INTC2_EIC386L
#define RENESAS_INTC2EIC386H                            INTC2_EIC386H
#define RENESAS_INTC2EIC387                             INTC2_EIC387
#define RENESAS_INTC2EIC387L                            INTC2_EIC387L
#define RENESAS_INTC2EIC387H                            INTC2_EIC387H
#define RENESAS_INTC2EIC388                             INTC2_EIC388
#define RENESAS_INTC2EIC388L                            INTC2_EIC388L
#define RENESAS_INTC2EIC388H                            INTC2_EIC388H
#define RENESAS_INTC2EIC389                             INTC2_EIC389
#define RENESAS_INTC2EIC389L                            INTC2_EIC389L
#define RENESAS_INTC2EIC389H                            INTC2_EIC389H
#define RENESAS_INTC2EIC390                             INTC2_EIC390
#define RENESAS_INTC2EIC390L                            INTC2_EIC390L
#define RENESAS_INTC2EIC390H                            INTC2_EIC390H
#define RENESAS_INTC2EIC391                             INTC2_EIC391
#define RENESAS_INTC2EIC391L                            INTC2_EIC391L
#define RENESAS_INTC2EIC391H                            INTC2_EIC391H
#define RENESAS_INTC2EIC392                             INTC2_EIC392
#define RENESAS_INTC2EIC392L                            INTC2_EIC392L
#define RENESAS_INTC2EIC392H                            INTC2_EIC392H
#define RENESAS_INTC2EIC393                             INTC2_EIC393
#define RENESAS_INTC2EIC393L                            INTC2_EIC393L
#define RENESAS_INTC2EIC393H                            INTC2_EIC393H
#define RENESAS_INTC2EIC394                             INTC2_EIC394
#define RENESAS_INTC2EIC394L                            INTC2_EIC394L
#define RENESAS_INTC2EIC394H                            INTC2_EIC394H
#define RENESAS_INTC2EIC395                             INTC2_EIC395
#define RENESAS_INTC2EIC395L                            INTC2_EIC395L
#define RENESAS_INTC2EIC395H                            INTC2_EIC395H
#define RENESAS_INTC2EIC396                             INTC2_EIC396
#define RENESAS_INTC2EIC396L                            INTC2_EIC396L
#define RENESAS_INTC2EIC396H                            INTC2_EIC396H
#define RENESAS_INTC2EIC397                             INTC2_EIC397
#define RENESAS_INTC2EIC397L                            INTC2_EIC397L
#define RENESAS_INTC2EIC397H                            INTC2_EIC397H
#define RENESAS_INTC2EIC398                             INTC2_EIC398
#define RENESAS_INTC2EIC398L                            INTC2_EIC398L
#define RENESAS_INTC2EIC398H                            INTC2_EIC398H
#define RENESAS_INTC2EIC399                             INTC2_EIC399
#define RENESAS_INTC2EIC399L                            INTC2_EIC399L
#define RENESAS_INTC2EIC399H                            INTC2_EIC399H
#define RENESAS_INTC2EIC400                             INTC2_EIC400
#define RENESAS_INTC2EIC400L                            INTC2_EIC400L
#define RENESAS_INTC2EIC400H                            INTC2_EIC400H
#define RENESAS_INTC2EIC401                             INTC2_EIC401
#define RENESAS_INTC2EIC401L                            INTC2_EIC401L
#define RENESAS_INTC2EIC401H                            INTC2_EIC401H
#define RENESAS_INTC2EIC402                             INTC2_EIC402
#define RENESAS_INTC2EIC402L                            INTC2_EIC402L
#define RENESAS_INTC2EIC402H                            INTC2_EIC402H
#define RENESAS_INTC2EIC403                             INTC2_EIC403
#define RENESAS_INTC2EIC403L                            INTC2_EIC403L
#define RENESAS_INTC2EIC403H                            INTC2_EIC403H
#define RENESAS_INTC2EIC404                             INTC2_EIC404
#define RENESAS_INTC2EIC404L                            INTC2_EIC404L
#define RENESAS_INTC2EIC404H                            INTC2_EIC404H
#define RENESAS_INTC2EIC405                             INTC2_EIC405
#define RENESAS_INTC2EIC405L                            INTC2_EIC405L
#define RENESAS_INTC2EIC405H                            INTC2_EIC405H
#define RENESAS_INTC2EIC406                             INTC2_EIC406
#define RENESAS_INTC2EIC406L                            INTC2_EIC406L
#define RENESAS_INTC2EIC406H                            INTC2_EIC406H
#define RENESAS_INTC2EIC407                             INTC2_EIC407
#define RENESAS_INTC2EIC407L                            INTC2_EIC407L
#define RENESAS_INTC2EIC407H                            INTC2_EIC407H
#define RENESAS_INTC2EIC408                             INTC2_EIC408
#define RENESAS_INTC2EIC408L                            INTC2_EIC408L
#define RENESAS_INTC2EIC408H                            INTC2_EIC408H
#define RENESAS_INTC2EIC409                             INTC2_EIC409
#define RENESAS_INTC2EIC409L                            INTC2_EIC409L
#define RENESAS_INTC2EIC409H                            INTC2_EIC409H
#define RENESAS_INTC2EIC410                             INTC2_EIC410
#define RENESAS_INTC2EIC410L                            INTC2_EIC410L
#define RENESAS_INTC2EIC410H                            INTC2_EIC410H
#define RENESAS_INTC2EIC411                             INTC2_EIC411
#define RENESAS_INTC2EIC411L                            INTC2_EIC411L
#define RENESAS_INTC2EIC411H                            INTC2_EIC411H
#define RENESAS_INTC2EIC412                             INTC2_EIC412
#define RENESAS_INTC2EIC412L                            INTC2_EIC412L
#define RENESAS_INTC2EIC412H                            INTC2_EIC412H
#define RENESAS_INTC2EIC413                             INTC2_EIC413
#define RENESAS_INTC2EIC413L                            INTC2_EIC413L
#define RENESAS_INTC2EIC413H                            INTC2_EIC413H
#define RENESAS_INTC2EIC414                             INTC2_EIC414
#define RENESAS_INTC2EIC414L                            INTC2_EIC414L
#define RENESAS_INTC2EIC414H                            INTC2_EIC414H
#define RENESAS_INTC2EIC415                             INTC2_EIC415
#define RENESAS_INTC2EIC415L                            INTC2_EIC415L
#define RENESAS_INTC2EIC415H                            INTC2_EIC415H
#define RENESAS_INTC2EIC416                             INTC2_EIC416
#define RENESAS_INTC2EIC416L                            INTC2_EIC416L
#define RENESAS_INTC2EIC416H                            INTC2_EIC416H
#define RENESAS_INTC2EIC417                             INTC2_EIC417
#define RENESAS_INTC2EIC417L                            INTC2_EIC417L
#define RENESAS_INTC2EIC417H                            INTC2_EIC417H
#define RENESAS_INTC2EIC418                             INTC2_EIC418
#define RENESAS_INTC2EIC418L                            INTC2_EIC418L
#define RENESAS_INTC2EIC418H                            INTC2_EIC418H
#define RENESAS_INTC2EIC419                             INTC2_EIC419
#define RENESAS_INTC2EIC419L                            INTC2_EIC419L
#define RENESAS_INTC2EIC419H                            INTC2_EIC419H
#define RENESAS_INTC2EIC420                             INTC2_EIC420
#define RENESAS_INTC2EIC420L                            INTC2_EIC420L
#define RENESAS_INTC2EIC420H                            INTC2_EIC420H
#define RENESAS_INTC2EIC421                             INTC2_EIC421
#define RENESAS_INTC2EIC421L                            INTC2_EIC421L
#define RENESAS_INTC2EIC421H                            INTC2_EIC421H
#define RENESAS_INTC2EIC422                             INTC2_EIC422
#define RENESAS_INTC2EIC422L                            INTC2_EIC422L
#define RENESAS_INTC2EIC422H                            INTC2_EIC422H
#define RENESAS_INTC2EIC423                             INTC2_EIC423
#define RENESAS_INTC2EIC423L                            INTC2_EIC423L
#define RENESAS_INTC2EIC423H                            INTC2_EIC423H
#define RENESAS_INTC2EIC424                             INTC2_EIC424
#define RENESAS_INTC2EIC424L                            INTC2_EIC424L
#define RENESAS_INTC2EIC424H                            INTC2_EIC424H
#define RENESAS_INTC2EIC425                             INTC2_EIC425
#define RENESAS_INTC2EIC425L                            INTC2_EIC425L
#define RENESAS_INTC2EIC425H                            INTC2_EIC425H
#define RENESAS_INTC2EIC426                             INTC2_EIC426
#define RENESAS_INTC2EIC426L                            INTC2_EIC426L
#define RENESAS_INTC2EIC426H                            INTC2_EIC426H
#define RENESAS_INTC2EIC427                             INTC2_EIC427
#define RENESAS_INTC2EIC427L                            INTC2_EIC427L
#define RENESAS_INTC2EIC427H                            INTC2_EIC427H
#define RENESAS_INTC2EIC428                             INTC2_EIC428
#define RENESAS_INTC2EIC428L                            INTC2_EIC428L
#define RENESAS_INTC2EIC428H                            INTC2_EIC428H
#define RENESAS_INTC2EIC429                             INTC2_EIC429
#define RENESAS_INTC2EIC429L                            INTC2_EIC429L
#define RENESAS_INTC2EIC429H                            INTC2_EIC429H
#define RENESAS_INTC2EIC430                             INTC2_EIC430
#define RENESAS_INTC2EIC430L                            INTC2_EIC430L
#define RENESAS_INTC2EIC430H                            INTC2_EIC430H
#define RENESAS_INTC2EIC431                             INTC2_EIC431
#define RENESAS_INTC2EIC431L                            INTC2_EIC431L
#define RENESAS_INTC2EIC431H                            INTC2_EIC431H
#define RENESAS_INTC2EIC432                             INTC2_EIC432
#define RENESAS_INTC2EIC432L                            INTC2_EIC432L
#define RENESAS_INTC2EIC432H                            INTC2_EIC432H
#define RENESAS_INTC2EIC433                             INTC2_EIC433
#define RENESAS_INTC2EIC433L                            INTC2_EIC433L
#define RENESAS_INTC2EIC433H                            INTC2_EIC433H
#define RENESAS_INTC2EIC434                             INTC2_EIC434
#define RENESAS_INTC2EIC434L                            INTC2_EIC434L
#define RENESAS_INTC2EIC434H                            INTC2_EIC434H
#define RENESAS_INTC2EIC435                             INTC2_EIC435
#define RENESAS_INTC2EIC435L                            INTC2_EIC435L
#define RENESAS_INTC2EIC435H                            INTC2_EIC435H
#define RENESAS_INTC2EIC436                             INTC2_EIC436
#define RENESAS_INTC2EIC436L                            INTC2_EIC436L
#define RENESAS_INTC2EIC436H                            INTC2_EIC436H
#define RENESAS_INTC2EIC437                             INTC2_EIC437
#define RENESAS_INTC2EIC437L                            INTC2_EIC437L
#define RENESAS_INTC2EIC437H                            INTC2_EIC437H
#define RENESAS_INTC2EIC438                             INTC2_EIC438
#define RENESAS_INTC2EIC438L                            INTC2_EIC438L
#define RENESAS_INTC2EIC438H                            INTC2_EIC438H
#define RENESAS_INTC2EIC439                             INTC2_EIC439
#define RENESAS_INTC2EIC439L                            INTC2_EIC439L
#define RENESAS_INTC2EIC439H                            INTC2_EIC439H
#define RENESAS_INTC2EIC440                             INTC2_EIC440
#define RENESAS_INTC2EIC440L                            INTC2_EIC440L
#define RENESAS_INTC2EIC440H                            INTC2_EIC440H
#define RENESAS_INTC2EIC441                             INTC2_EIC441
#define RENESAS_INTC2EIC441L                            INTC2_EIC441L
#define RENESAS_INTC2EIC441H                            INTC2_EIC441H
#define RENESAS_INTC2EIC442                             INTC2_EIC442
#define RENESAS_INTC2EIC442L                            INTC2_EIC442L
#define RENESAS_INTC2EIC442H                            INTC2_EIC442H
#define RENESAS_INTC2EIC443                             INTC2_EIC443
#define RENESAS_INTC2EIC443L                            INTC2_EIC443L
#define RENESAS_INTC2EIC443H                            INTC2_EIC443H
#define RENESAS_INTC2EIC444                             INTC2_EIC444
#define RENESAS_INTC2EIC444L                            INTC2_EIC444L
#define RENESAS_INTC2EIC444H                            INTC2_EIC444H
#define RENESAS_INTC2EIC445                             INTC2_EIC445
#define RENESAS_INTC2EIC445L                            INTC2_EIC445L
#define RENESAS_INTC2EIC445H                            INTC2_EIC445H
#define RENESAS_INTC2EIC446                             INTC2_EIC446
#define RENESAS_INTC2EIC446L                            INTC2_EIC446L
#define RENESAS_INTC2EIC446H                            INTC2_EIC446H
#define RENESAS_INTC2EIC447                             INTC2_EIC447
#define RENESAS_INTC2EIC447L                            INTC2_EIC447L
#define RENESAS_INTC2EIC447H                            INTC2_EIC447H
#define RENESAS_INTC2EIC448                             INTC2_EIC448
#define RENESAS_INTC2EIC448L                            INTC2_EIC448L
#define RENESAS_INTC2EIC448H                            INTC2_EIC448H
#define RENESAS_INTC2EIC449                             INTC2_EIC449
#define RENESAS_INTC2EIC449L                            INTC2_EIC449L
#define RENESAS_INTC2EIC449H                            INTC2_EIC449H
#define RENESAS_INTC2EIC450                             INTC2_EIC450
#define RENESAS_INTC2EIC450L                            INTC2_EIC450L
#define RENESAS_INTC2EIC450H                            INTC2_EIC450H
#define RENESAS_INTC2EIC451                             INTC2_EIC451
#define RENESAS_INTC2EIC451L                            INTC2_EIC451L
#define RENESAS_INTC2EIC451H                            INTC2_EIC451H
#define RENESAS_INTC2EIC452                             INTC2_EIC452
#define RENESAS_INTC2EIC452L                            INTC2_EIC452L
#define RENESAS_INTC2EIC452H                            INTC2_EIC452H
#define RENESAS_INTC2EIC453                             INTC2_EIC453
#define RENESAS_INTC2EIC453L                            INTC2_EIC453L
#define RENESAS_INTC2EIC453H                            INTC2_EIC453H
#define RENESAS_INTC2EIC454                             INTC2_EIC454
#define RENESAS_INTC2EIC454L                            INTC2_EIC454L
#define RENESAS_INTC2EIC454H                            INTC2_EIC454H
#define RENESAS_INTC2EIC455                             INTC2_EIC455
#define RENESAS_INTC2EIC455L                            INTC2_EIC455L
#define RENESAS_INTC2EIC455H                            INTC2_EIC455H
#define RENESAS_INTC2EIC456                             INTC2_EIC456
#define RENESAS_INTC2EIC456L                            INTC2_EIC456L
#define RENESAS_INTC2EIC456H                            INTC2_EIC456H
#define RENESAS_INTC2EIC457                             INTC2_EIC457
#define RENESAS_INTC2EIC457L                            INTC2_EIC457L
#define RENESAS_INTC2EIC457H                            INTC2_EIC457H
#define RENESAS_INTC2EIC458                             INTC2_EIC458
#define RENESAS_INTC2EIC458L                            INTC2_EIC458L
#define RENESAS_INTC2EIC458H                            INTC2_EIC458H
#define RENESAS_INTC2EIC459                             INTC2_EIC459
#define RENESAS_INTC2EIC459L                            INTC2_EIC459L
#define RENESAS_INTC2EIC459H                            INTC2_EIC459H
#define RENESAS_INTC2EIC460                             INTC2_EIC460
#define RENESAS_INTC2EIC460L                            INTC2_EIC460L
#define RENESAS_INTC2EIC460H                            INTC2_EIC460H
#define RENESAS_INTC2EIC461                             INTC2_EIC461
#define RENESAS_INTC2EIC461L                            INTC2_EIC461L
#define RENESAS_INTC2EIC461H                            INTC2_EIC461H
#define RENESAS_INTC2EIC462                             INTC2_EIC462
#define RENESAS_INTC2EIC462L                            INTC2_EIC462L
#define RENESAS_INTC2EIC462H                            INTC2_EIC462H
#define RENESAS_INTC2EIC463                             INTC2_EIC463
#define RENESAS_INTC2EIC463L                            INTC2_EIC463L
#define RENESAS_INTC2EIC463H                            INTC2_EIC463H
#define RENESAS_INTC2EIC464                             INTC2_EIC464
#define RENESAS_INTC2EIC464L                            INTC2_EIC464L
#define RENESAS_INTC2EIC464H                            INTC2_EIC464H
#define RENESAS_INTC2EIC465                             INTC2_EIC465
#define RENESAS_INTC2EIC465L                            INTC2_EIC465L
#define RENESAS_INTC2EIC465H                            INTC2_EIC465H
#define RENESAS_INTC2EIC466                             INTC2_EIC466
#define RENESAS_INTC2EIC466L                            INTC2_EIC466L
#define RENESAS_INTC2EIC466H                            INTC2_EIC466H
#define RENESAS_INTC2EIC467                             INTC2_EIC467
#define RENESAS_INTC2EIC467L                            INTC2_EIC467L
#define RENESAS_INTC2EIC467H                            INTC2_EIC467H
#define RENESAS_INTC2EIC468                             INTC2_EIC468
#define RENESAS_INTC2EIC468L                            INTC2_EIC468L
#define RENESAS_INTC2EIC468H                            INTC2_EIC468H
#define RENESAS_INTC2EIC469                             INTC2_EIC469
#define RENESAS_INTC2EIC469L                            INTC2_EIC469L
#define RENESAS_INTC2EIC469H                            INTC2_EIC469H
#define RENESAS_INTC2EIC470                             INTC2_EIC470
#define RENESAS_INTC2EIC470L                            INTC2_EIC470L
#define RENESAS_INTC2EIC470H                            INTC2_EIC470H
#define RENESAS_INTC2EIC471                             INTC2_EIC471
#define RENESAS_INTC2EIC471L                            INTC2_EIC471L
#define RENESAS_INTC2EIC471H                            INTC2_EIC471H
#define RENESAS_INTC2EIC472                             INTC2_EIC472
#define RENESAS_INTC2EIC472L                            INTC2_EIC472L
#define RENESAS_INTC2EIC472H                            INTC2_EIC472H
#define RENESAS_INTC2EIC473                             INTC2_EIC473
#define RENESAS_INTC2EIC473L                            INTC2_EIC473L
#define RENESAS_INTC2EIC473H                            INTC2_EIC473H
#define RENESAS_INTC2EIC474                             INTC2_EIC474
#define RENESAS_INTC2EIC474L                            INTC2_EIC474L
#define RENESAS_INTC2EIC474H                            INTC2_EIC474H
#define RENESAS_INTC2EIC475                             INTC2_EIC475
#define RENESAS_INTC2EIC475L                            INTC2_EIC475L
#define RENESAS_INTC2EIC475H                            INTC2_EIC475H
#define RENESAS_INTC2EIC476                             INTC2_EIC476
#define RENESAS_INTC2EIC476L                            INTC2_EIC476L
#define RENESAS_INTC2EIC476H                            INTC2_EIC476H
#define RENESAS_INTC2EIC477                             INTC2_EIC477
#define RENESAS_INTC2EIC477L                            INTC2_EIC477L
#define RENESAS_INTC2EIC477H                            INTC2_EIC477H
#define RENESAS_INTC2EIC478                             INTC2_EIC478
#define RENESAS_INTC2EIC478L                            INTC2_EIC478L
#define RENESAS_INTC2EIC478H                            INTC2_EIC478H
#define RENESAS_INTC2EIC479                             INTC2_EIC479
#define RENESAS_INTC2EIC479L                            INTC2_EIC479L
#define RENESAS_INTC2EIC479H                            INTC2_EIC479H
#define RENESAS_INTC2EIC480                             INTC2_EIC480
#define RENESAS_INTC2EIC480L                            INTC2_EIC480L
#define RENESAS_INTC2EIC480H                            INTC2_EIC480H
#define RENESAS_INTC2EIC481                             INTC2_EIC481
#define RENESAS_INTC2EIC481L                            INTC2_EIC481L
#define RENESAS_INTC2EIC481H                            INTC2_EIC481H
#define RENESAS_INTC2EIC482                             INTC2_EIC482
#define RENESAS_INTC2EIC482L                            INTC2_EIC482L
#define RENESAS_INTC2EIC482H                            INTC2_EIC482H
#define RENESAS_INTC2EIC483                             INTC2_EIC483
#define RENESAS_INTC2EIC483L                            INTC2_EIC483L
#define RENESAS_INTC2EIC483H                            INTC2_EIC483H
#define RENESAS_INTC2EIC484                             INTC2_EIC484
#define RENESAS_INTC2EIC484L                            INTC2_EIC484L
#define RENESAS_INTC2EIC484H                            INTC2_EIC484H
#define RENESAS_INTC2EIC485                             INTC2_EIC485
#define RENESAS_INTC2EIC485L                            INTC2_EIC485L
#define RENESAS_INTC2EIC485H                            INTC2_EIC485H
#define RENESAS_INTC2EIC486                             INTC2_EIC486
#define RENESAS_INTC2EIC486L                            INTC2_EIC486L
#define RENESAS_INTC2EIC486H                            INTC2_EIC486H
#define RENESAS_INTC2EIC487                             INTC2_EIC487
#define RENESAS_INTC2EIC487L                            INTC2_EIC487L
#define RENESAS_INTC2EIC487H                            INTC2_EIC487H
#define RENESAS_INTC2EIC488                             INTC2_EIC488
#define RENESAS_INTC2EIC488L                            INTC2_EIC488L
#define RENESAS_INTC2EIC488H                            INTC2_EIC488H
#define RENESAS_INTC2EIC489                             INTC2_EIC489
#define RENESAS_INTC2EIC489L                            INTC2_EIC489L
#define RENESAS_INTC2EIC489H                            INTC2_EIC489H
#define RENESAS_INTC2EIC490                             INTC2_EIC490
#define RENESAS_INTC2EIC490L                            INTC2_EIC490L
#define RENESAS_INTC2EIC490H                            INTC2_EIC490H
#define RENESAS_INTC2EIC491                             INTC2_EIC491
#define RENESAS_INTC2EIC491L                            INTC2_EIC491L
#define RENESAS_INTC2EIC491H                            INTC2_EIC491H
#define RENESAS_INTC2EIC492                             INTC2_EIC492
#define RENESAS_INTC2EIC492L                            INTC2_EIC492L
#define RENESAS_INTC2EIC492H                            INTC2_EIC492H
#define RENESAS_INTC2EIC493                             INTC2_EIC493
#define RENESAS_INTC2EIC493L                            INTC2_EIC493L
#define RENESAS_INTC2EIC493H                            INTC2_EIC493H
#define RENESAS_INTC2EIC494                             INTC2_EIC494
#define RENESAS_INTC2EIC494L                            INTC2_EIC494L
#define RENESAS_INTC2EIC494H                            INTC2_EIC494H
#define RENESAS_INTC2EIC495                             INTC2_EIC495
#define RENESAS_INTC2EIC495L                            INTC2_EIC495L
#define RENESAS_INTC2EIC495H                            INTC2_EIC495H
#define RENESAS_INTC2EIC496                             INTC2_EIC496
#define RENESAS_INTC2EIC496L                            INTC2_EIC496L
#define RENESAS_INTC2EIC496H                            INTC2_EIC496H
#define RENESAS_INTC2EIC497                             INTC2_EIC497
#define RENESAS_INTC2EIC497L                            INTC2_EIC497L
#define RENESAS_INTC2EIC497H                            INTC2_EIC497H
#define RENESAS_INTC2EIC498                             INTC2_EIC498
#define RENESAS_INTC2EIC498L                            INTC2_EIC498L
#define RENESAS_INTC2EIC498H                            INTC2_EIC498H
#define RENESAS_INTC2EIC499                             INTC2_EIC499
#define RENESAS_INTC2EIC499L                            INTC2_EIC499L
#define RENESAS_INTC2EIC499H                            INTC2_EIC499H
#define RENESAS_INTC2EIC500                             INTC2_EIC500
#define RENESAS_INTC2EIC500L                            INTC2_EIC500L
#define RENESAS_INTC2EIC500H                            INTC2_EIC500H
#define RENESAS_INTC2EIC501                             INTC2_EIC501
#define RENESAS_INTC2EIC501L                            INTC2_EIC501L
#define RENESAS_INTC2EIC501H                            INTC2_EIC501H
#define RENESAS_INTC2EIC502                             INTC2_EIC502
#define RENESAS_INTC2EIC502L                            INTC2_EIC502L
#define RENESAS_INTC2EIC502H                            INTC2_EIC502H
#define RENESAS_INTC2EIC503                             INTC2_EIC503
#define RENESAS_INTC2EIC503L                            INTC2_EIC503L
#define RENESAS_INTC2EIC503H                            INTC2_EIC503H
#define RENESAS_INTC2EIC504                             INTC2_EIC504
#define RENESAS_INTC2EIC504L                            INTC2_EIC504L
#define RENESAS_INTC2EIC504H                            INTC2_EIC504H
#define RENESAS_INTC2EIC505                             INTC2_EIC505
#define RENESAS_INTC2EIC505L                            INTC2_EIC505L
#define RENESAS_INTC2EIC505H                            INTC2_EIC505H
#define RENESAS_INTC2EIC506                             INTC2_EIC506
#define RENESAS_INTC2EIC506L                            INTC2_EIC506L
#define RENESAS_INTC2EIC506H                            INTC2_EIC506H
#define RENESAS_INTC2EIC507                             INTC2_EIC507
#define RENESAS_INTC2EIC507L                            INTC2_EIC507L
#define RENESAS_INTC2EIC507H                            INTC2_EIC507H
#define RENESAS_INTC2EIC508                             INTC2_EIC508
#define RENESAS_INTC2EIC508L                            INTC2_EIC508L
#define RENESAS_INTC2EIC508H                            INTC2_EIC508H
#define RENESAS_INTC2EIC509                             INTC2_EIC509
#define RENESAS_INTC2EIC509L                            INTC2_EIC509L
#define RENESAS_INTC2EIC509H                            INTC2_EIC509H
#define RENESAS_INTC2EIC510                             INTC2_EIC510
#define RENESAS_INTC2EIC510L                            INTC2_EIC510L
#define RENESAS_INTC2EIC510H                            INTC2_EIC510H
#define RENESAS_INTC2EIC511                             INTC2_EIC511
#define RENESAS_INTC2EIC511L                            INTC2_EIC511L
#define RENESAS_INTC2EIC511H                            INTC2_EIC511H


#define RENESAS_INTC2IMR1                               INTC2_IMR1
#define RENESAS_INTC2IMR2                               INTC2_IMR2
#define RENESAS_INTC2IMR3                               INTC2_IMR3
#define RENESAS_INTC2IMR4                               INTC2_IMR4
#define RENESAS_INTC2IMR5                               INTC2_IMR5
#define RENESAS_INTC2IMR6                               INTC2_IMR6
#define RENESAS_INTC2IMR7                               INTC2_IMR7
#define RENESAS_INTC2IMR8                               INTC2_IMR8
#define RENESAS_INTC2IMR9                               INTC2_IMR9

/*******************************************************************************
**                         Macros for PWM ATU Driver                          **
*******************************************************************************/

/*******************************************************************************
**                 Macros for IMR Register                                    **
*******************************************************************************/
#define RENESAS_IMR0CPU0                                INTC1_PE0_IMR0
#define RENESAS_IMR0CPU1                                INTC1_PE1_IMR0
#define RENESAS_IMR0                                    INTC1_SELF_IMR0
#define RENESAS_IMR1                                    INTC2_IMR1
#define RENESAS_IMR2                                    INTC2_IMR2
#define RENESAS_IMR3                                    INTC2_IMR3
#define RENESAS_IMR4                                    INTC2_IMR4
#define RENESAS_IMR5                                    INTC2_IMR5
#define RENESAS_IMR6                                    INTC2_IMR6
#define RENESAS_IMR7                                    INTC2_IMR7
#define RENESAS_IMR8                                    INTC2_IMR8
#define RENESAS_IMR9                                    INTC2_IMR9
#define RENESAS_IMR10                                   INTC2_IMR10
#define RENESAS_IMR11                                   INTC2_IMR11
#define RENESAS_IMR12                                   INTC2_IMR12
#define RENESAS_IMR13                                   INTC2_IMR13
#define RENESAS_IMR14                                   INTC2_IMR14
#define RENESAS_IMR15                                   INTC2_IMR15


/*******************************************************************************
**                 Macros for SPI Driver                                     **
*******************************************************************************/
/* U2A add start */
#define RENESAS_MSPI0CTL0                               MSPI0_CTL0
#define RENESAS_MSPI0INTF0                              MSPI0_INTF_MSPI0INTF0
#define RENESAS_MSPI0TGCTL0                             MSPITG_CTL0
#define RENESAS_MSPI0TX                                 INTC2_EIC250
#define RENESAS_MSPI0RX                                 INTC2_EIC251
#define RENESAS_MSPI0FE                                 INTC2_EIC252
#define RENESAS_MSPI0ERR                                INTC2_EIC253
#define RENESAS_MSPI0TXDA00                             MSPI0_TXDA00
#define RENESAS_MSPI0RXDA00                             MSPI0_RXDA00
#define RENESAS_MSPI0TXDA10                             MSPI0_TXDA10
#define RENESAS_MSPI0RXDA10                             MSPI0_RXDA10
#define RENESAS_MSPI0TXDA20                             MSPI0_TXDA20
#define RENESAS_MSPI0RXDA20                             MSPI0_RXDA20
#define RENESAS_MSPI0TXDA30                             MSPI0_TXDA30
#define RENESAS_MSPI0RXDA30                             MSPI0_RXDA30
#define RENESAS_MSPI0TXDA40                             MSPI0_TXDA40
#define RENESAS_MSPI0RXDA40                             MSPI0_RXDA40
#define RENESAS_MSPI0TXDA50                             MSPI0_TXDA50
#define RENESAS_MSPI0RXDA50                             MSPI0_RXDA50
#define RENESAS_MSPI0TXDA60                             MSPI0_TXDA60
#define RENESAS_MSPI0RXDA60                             MSPI0_RXDA60
#define RENESAS_MSPI0TXDA70                             MSPI0_TXDA70
#define RENESAS_MSPI0RXDA70                             MSPI0_RXDA70
#define RENESAS_MSPI1CTL0                               MSPI1_CTL0
#define RENESAS_MSPI1INTF0                              MSPI1_INTF_MSPI1INTF0
#define RENESAS_MSPI1TGCTL0                             MSPITG_CTL0
#define RENESAS_MSPI1TX                                 INTC2_EIC260
#define RENESAS_MSPI1RX                                 INTC2_EIC261
#define RENESAS_MSPI1FE                                 INTC2_EIC262
#define RENESAS_MSPI1ERR                                INTC2_EIC263
#define RENESAS_MSPI1TXDA00                             MSPI1_TXDA00
#define RENESAS_MSPI1RXDA00                             MSPI1_RXDA00
#define RENESAS_MSPI1TXDA10                             MSPI1_TXDA10
#define RENESAS_MSPI1RXDA10                             MSPI1_RXDA10
#define RENESAS_MSPI1TXDA20                             MSPI1_TXDA20
#define RENESAS_MSPI1RXDA20                             MSPI1_RXDA20
#define RENESAS_MSPI1TXDA30                             MSPI1_TXDA30
#define RENESAS_MSPI1RXDA30                             MSPI1_RXDA30
#define RENESAS_MSPI1TXDA40                             MSPI1_TXDA40
#define RENESAS_MSPI1RXDA40                             MSPI1_RXDA40
#define RENESAS_MSPI1TXDA50                             MSPI1_TXDA50
#define RENESAS_MSPI1RXDA50                             MSPI1_RXDA50
#define RENESAS_MSPI1TXDA60                             MSPI1_TXDA60
#define RENESAS_MSPI1RXDA60                             MSPI1_RXDA60
#define RENESAS_MSPI1TXDA70                             MSPI1_TXDA70
#define RENESAS_MSPI1RXDA70                             MSPI1_RXDA70
#define RENESAS_MSPI2CTL0                               MSPI2_CTL0
#define RENESAS_MSPI2INTF0                              MSPI2_INTF_MSPI2INTF0
#define RENESAS_MSPI2TGCTL0                             MSPITG_CTL0
#define RENESAS_MSPI2TX                                 INTC2_EIC264
#define RENESAS_MSPI2RX                                 INTC2_EIC265
#define RENESAS_MSPI2FE                                 INTC2_EIC266
#define RENESAS_MSPI2ERR                                INTC2_EIC267
#define RENESAS_MSPI2TXDA00                             MSPI2_TXDA00
#define RENESAS_MSPI2RXDA00                             MSPI2_RXDA00
#define RENESAS_MSPI2TXDA10                             MSPI2_TXDA10
#define RENESAS_MSPI2RXDA10                             MSPI2_RXDA10
#define RENESAS_MSPI2TXDA20                             MSPI2_TXDA20
#define RENESAS_MSPI2RXDA20                             MSPI2_RXDA20
#define RENESAS_MSPI2TXDA30                             MSPI2_TXDA30
#define RENESAS_MSPI2RXDA30                             MSPI2_RXDA30
#define RENESAS_MSPI2TXDA40                             MSPI2_TXDA40
#define RENESAS_MSPI2RXDA40                             MSPI2_RXDA40
#define RENESAS_MSPI2TXDA50                             MSPI2_TXDA50
#define RENESAS_MSPI2RXDA50                             MSPI2_RXDA50
#define RENESAS_MSPI2TXDA60                             MSPI2_TXDA60
#define RENESAS_MSPI2RXDA60                             MSPI2_RXDA60
#define RENESAS_MSPI2TXDA70                             MSPI2_TXDA70
#define RENESAS_MSPI2RXDA70                             MSPI2_RXDA70
#define RENESAS_MSPI3CTL0                               MSPI3_CTL0
#define RENESAS_MSPI3INTF0                              MSPI3_INTF_MSPI3INTF0
#define RENESAS_MSPI3TGCTL0                             MSPITG_CTL0
#define RENESAS_MSPI3TX                                 INTC2_EIC268
#define RENESAS_MSPI3RX                                 INTC2_EIC269
#define RENESAS_MSPI3FE                                 INTC2_EIC270
#define RENESAS_MSPI3ERR                                INTC2_EIC271
#define RENESAS_MSPI3TXDA00                             MSPI3_TXDA00
#define RENESAS_MSPI3RXDA00                             MSPI3_RXDA00
#define RENESAS_MSPI3TXDA10                             MSPI3_TXDA10
#define RENESAS_MSPI3RXDA10                             MSPI3_RXDA10
#define RENESAS_MSPI3TXDA20                             MSPI3_TXDA20
#define RENESAS_MSPI3RXDA20                             MSPI3_RXDA20
#define RENESAS_MSPI3TXDA30                             MSPI3_TXDA30
#define RENESAS_MSPI3RXDA30                             MSPI3_RXDA30
#define RENESAS_MSPI3TXDA40                             MSPI3_TXDA40
#define RENESAS_MSPI3RXDA40                             MSPI3_RXDA40
#define RENESAS_MSPI3TXDA50                             MSPI3_TXDA50
#define RENESAS_MSPI3RXDA50                             MSPI3_RXDA50
#define RENESAS_MSPI3TXDA60                             MSPI3_TXDA60
#define RENESAS_MSPI3RXDA60                             MSPI3_RXDA60
#define RENESAS_MSPI3TXDA70                             MSPI3_TXDA70
#define RENESAS_MSPI3RXDA70                             MSPI3_RXDA70
#define RENESAS_MSPI4CTL0                               MSPI4_CTL0
#define RENESAS_MSPI4INTF0                              MSPI4_INTF_MSPI4INTF0
#define RENESAS_MSPI4TGCTL0                             MSPITG_CTL0
#define RENESAS_MSPI4TX                                 INTC2_EIC272
#define RENESAS_MSPI4RX                                 INTC2_EIC273
#define RENESAS_MSPI4FE                                 INTC2_EIC274
#define RENESAS_MSPI4ERR                                INTC2_EIC275
#define RENESAS_MSPI4TXDA00                             MSPI4_TXDA00
#define RENESAS_MSPI4RXDA00                             MSPI4_RXDA00
#define RENESAS_MSPI4TXDA10                             MSPI4_TXDA10
#define RENESAS_MSPI4RXDA10                             MSPI4_RXDA10
#define RENESAS_MSPI4TXDA20                             MSPI4_TXDA20
#define RENESAS_MSPI4RXDA20                             MSPI4_RXDA20
#define RENESAS_MSPI4TXDA30                             MSPI4_TXDA30
#define RENESAS_MSPI4RXDA30                             MSPI4_RXDA30
#define RENESAS_MSPI4TXDA40                             MSPI4_TXDA40
#define RENESAS_MSPI4RXDA40                             MSPI4_RXDA40
#define RENESAS_MSPI4TXDA50                             MSPI4_TXDA50
#define RENESAS_MSPI4RXDA50                             MSPI4_RXDA50
#define RENESAS_MSPI4TXDA60                             MSPI4_TXDA60
#define RENESAS_MSPI4RXDA60                             MSPI4_RXDA60
#define RENESAS_MSPI4TXDA70                             MSPI4_TXDA70
#define RENESAS_MSPI4RXDA70                             MSPI4_RXDA70
#define RENESAS_MSPI5CTL0                               MSPI5_CTL0
#define RENESAS_MSPI5INTF0                              MSPI5_INTF_MSPI5INTF0
#define RENESAS_MSPI5TGCTL0                             MSPITG_CTL0
#define RENESAS_MSPI5TX                                 INTC2_EIC276
#define RENESAS_MSPI5RX                                 INTC2_EIC277
#define RENESAS_MSPI5FE                                 INTC2_EIC278
#define RENESAS_MSPI5ERR                                INTC2_EIC279
#define RENESAS_MSPI5TXDA00                             MSPI5_TXDA00
#define RENESAS_MSPI5RXDA00                             MSPI5_RXDA00
#define RENESAS_MSPI5TXDA10                             MSPI5_TXDA10
#define RENESAS_MSPI5RXDA10                             MSPI5_RXDA10
#define RENESAS_MSPI5TXDA20                             MSPI5_TXDA20
#define RENESAS_MSPI5RXDA20                             MSPI5_RXDA20
#define RENESAS_MSPI5TXDA30                             MSPI5_TXDA30
#define RENESAS_MSPI5RXDA30                             MSPI5_RXDA30
#define RENESAS_MSPI5TXDA40                             MSPI5_TXDA40
#define RENESAS_MSPI5RXDA40                             MSPI5_RXDA40
#define RENESAS_MSPI5TXDA50                             MSPI5_TXDA50
#define RENESAS_MSPI5RXDA50                             MSPI5_RXDA50
#define RENESAS_MSPI5TXDA60                             MSPI5_TXDA60
#define RENESAS_MSPI5RXDA60                             MSPI5_RXDA60
#define RENESAS_MSPI5TXDA70                             MSPI5_TXDA70
#define RENESAS_MSPI5RXDA70                             MSPI5_RXDA70
#define RENESAS_MSPI6CTL0                               MSPI6_CTL0
#define RENESAS_MSPI6INTF0                              MSPI6_INTF_MSPI6INTF0
#define RENESAS_MSPI6TGCTL0                             MSPITG_CTL0
#define RENESAS_MSPI6TX                                 INTC2_EIC280
#define RENESAS_MSPI6RX                                 INTC2_EIC281
#define RENESAS_MSPI6FE                                 INTC2_EIC282
#define RENESAS_MSPI6ERR                                INTC2_EIC283
#define RENESAS_MSPI6TXDA00                             MSPI6_TXDA00
#define RENESAS_MSPI6RXDA00                             MSPI6_RXDA00
#define RENESAS_MSPI6TXDA10                             MSPI6_TXDA10
#define RENESAS_MSPI6RXDA10                             MSPI6_RXDA10
#define RENESAS_MSPI6TXDA20                             MSPI6_TXDA20
#define RENESAS_MSPI6RXDA20                             MSPI6_RXDA20
#define RENESAS_MSPI6TXDA30                             MSPI6_TXDA30
#define RENESAS_MSPI6RXDA30                             MSPI6_RXDA30
#define RENESAS_MSPI6TXDA40                             MSPI6_TXDA40
#define RENESAS_MSPI6RXDA40                             MSPI6_RXDA40
#define RENESAS_MSPI6TXDA50                             MSPI6_TXDA50
#define RENESAS_MSPI6RXDA50                             MSPI6_RXDA50
#define RENESAS_MSPI6TXDA60                             MSPI6_TXDA60
#define RENESAS_MSPI6RXDA60                             MSPI6_RXDA60
#define RENESAS_MSPI6TXDA70                             MSPI6_TXDA70
#define RENESAS_MSPI6RXDA70                             MSPI6_RXDA70
#define RENESAS_MSPI7CTL0                               MSPI7_CTL0
#define RENESAS_MSPI7INTF0                              MSPI7_INTF_MSPI7INTF0
#define RENESAS_MSPI7TGCTL0                             MSPITG_CTL0
#define RENESAS_MSPI7TX                                 INTC2_EIC284
#define RENESAS_MSPI7RX                                 INTC2_EIC285
#define RENESAS_MSPI7FE                                 INTC2_EIC286
#define RENESAS_MSPI7ERR                                INTC2_EIC287
#define RENESAS_MSPI7TXDA00                             MSPI7_TXDA00
#define RENESAS_MSPI7RXDA00                             MSPI7_RXDA00
#define RENESAS_MSPI7TXDA10                             MSPI7_TXDA10
#define RENESAS_MSPI7RXDA10                             MSPI7_RXDA10
#define RENESAS_MSPI7TXDA20                             MSPI7_TXDA20
#define RENESAS_MSPI7RXDA20                             MSPI7_RXDA20
#define RENESAS_MSPI7TXDA30                             MSPI7_TXDA30
#define RENESAS_MSPI7RXDA30                             MSPI7_RXDA30
#define RENESAS_MSPI7TXDA40                             MSPI7_TXDA40
#define RENESAS_MSPI7RXDA40                             MSPI7_RXDA40
#define RENESAS_MSPI7TXDA50                             MSPI7_TXDA50
#define RENESAS_MSPI7RXDA50                             MSPI7_RXDA50
#define RENESAS_MSPI7TXDA60                             MSPI7_TXDA60
#define RENESAS_MSPI7RXDA60                             MSPI7_RXDA60
#define RENESAS_MSPI7TXDA70                             MSPI7_TXDA70
#define RENESAS_MSPI7RXDA70                             MSPI7_RXDA70
#define RENESAS_MSPI8CTL0                               MSPI8_CTL0
#define RENESAS_MSPI8INTF0                              MSPI8_INTF_MSPI8INTF0
#define RENESAS_MSPI8TGCTL0                             MSPITG_CTL0
#define RENESAS_MSPI8TX                                 INTC2_EIC288
#define RENESAS_MSPI8RX                                 INTC2_EIC289
#define RENESAS_MSPI8FE                                 INTC2_EIC290
#define RENESAS_MSPI8ERR                                INTC2_EIC291
#define RENESAS_MSPI8TXDA00                             MSPI8_TXDA00
#define RENESAS_MSPI8RXDA00                             MSPI8_RXDA00
#define RENESAS_MSPI8TXDA10                             MSPI8_TXDA10
#define RENESAS_MSPI8RXDA10                             MSPI8_RXDA10
#define RENESAS_MSPI8TXDA20                             MSPI8_TXDA20
#define RENESAS_MSPI8RXDA20                             MSPI8_RXDA20
#define RENESAS_MSPI8TXDA30                             MSPI8_TXDA30
#define RENESAS_MSPI8RXDA30                             MSPI8_RXDA30
#define RENESAS_MSPI8TXDA40                             MSPI8_TXDA40
#define RENESAS_MSPI8RXDA40                             MSPI8_RXDA40
#define RENESAS_MSPI8TXDA50                             MSPI8_TXDA50
#define RENESAS_MSPI8RXDA50                             MSPI8_RXDA50
#define RENESAS_MSPI8TXDA60                             MSPI8_TXDA60
#define RENESAS_MSPI8RXDA60                             MSPI8_RXDA60
#define RENESAS_MSPI8TXDA70                             MSPI8_TXDA70
#define RENESAS_MSPI8RXDA70                             MSPI8_RXDA70
#define RENESAS_MSPI9TGCTL0                             MSPITG_CTL0
#define RENESAS_MSPI9TX                                 INTC2_EIC292
#define RENESAS_MSPI9RX                                 INTC2_EIC293
#define RENESAS_MSPI9FE                                 INTC2_EIC294
#define RENESAS_MSPI9ERR                                INTC2_EIC295
/* U2A add end */
#define RENESAS_MCUREF                                  McuPeripheralClock

/*****************************************************************************
**                         Macros for CAN Driver                            **
******************************************************************************/

/* Macros for CAN MCUCLOCK Software Implementation */
#define RENESAS_CANMCUPPLCLOCK                          McuPeripheralClock
#define RENESAS_CANMCUPCLKCLOCK                         McuPeripheralClock
#define RENESAS_CANMCURCANCLOCK                         McuPeripheralClock

/* Global register */
#define RENESAS_RSCFD0CFDC0NCFG                         RSCFD0_CFDC0NCFG

/* Receive filter register */
#define RENESAS_RSCFD0CFDGAFLID0                        RSCFD0_CFDGAFLID0

/* Global interrupt register */
#define RENESAS_RCANGRECC0_EIC                          INTC2_EIC297


/* Channel interrupt register */
#define RENESAS_RSCANFD00ERR_EIC                        INTC2_EIC298
#define RENESAS_RSCANFD01ERR_EIC                        INTC2_EIC301
#define RENESAS_RSCANFD02ERR_EIC                        INTC2_EIC304
#define RENESAS_RSCANFD03ERR_EIC                        INTC2_EIC307
#define RENESAS_RSCANFD04ERR_EIC                        INTC2_EIC310

#define RENESAS_RSCANFD00REC_EIC                        INTC2_EIC299
#define RENESAS_RSCANFD01REC_EIC                        INTC2_EIC302
#define RENESAS_RSCANFD02REC_EIC                        INTC2_EIC305
#define RENESAS_RSCANFD03REC_EIC                        INTC2_EIC308
#define RENESAS_RSCANFD04REC_EIC                        INTC2_EIC311

#define RENESAS_RSCANFD00TRX_EIC                        INTC2_EIC300
#define RENESAS_RSCANFD01TRX_EIC                        INTC2_EIC303
#define RENESAS_RSCANFD02TRX_EIC                        INTC2_EIC306
#define RENESAS_RSCANFD03TRX_EIC                        INTC2_EIC309
#define RENESAS_RSCANFD04TRX_EIC                        INTC2_EIC312

/* U2A add start */
#define RENESAS_RSCFD1CFDC0NCFG                         RSCFD1_CFDC0NCFG
#define RENESAS_RSCFD1CFDGAFLID0                        RSCFD1_CFDGAFLID0
#define RENESAS_RSCFD0CFDC0DCFG                         RSCFD0_CFDC0DCFG
#define RENESAS_RSCFD1CFDC0DCFG                         RSCFD1_CFDC0DCFG

/* TX Message Buffer ID Registers */
#define RENESAS_RSCFD0CFDTMID0                          RSCFD0_CFDTMID0
#define RENESAS_RSCFD1CFDTMID0                          RSCFD1_CFDTMID0

#define RENESAS_RCANGRECC1_EIC                          INTC2_EIC323

#define RENESAS_RSCANFD05ERR_EIC                        INTC2_EIC313
#define RENESAS_RSCANFD06ERR_EIC                        INTC2_EIC316
#define RENESAS_RSCANFD07ERR_EIC                        INTC2_EIC319
#define RENESAS_RSCANFD10ERR_EIC                        INTC2_EIC324
#define RENESAS_RSCANFD11ERR_EIC                        INTC2_EIC327
#define RENESAS_RSCANFD12ERR_EIC                        INTC2_EIC330
#define RENESAS_RSCANFD13ERR_EIC                        INTC2_EIC333
#define RENESAS_RSCANFD14ERR_EIC                        INTC2_EIC336
#define RENESAS_RSCANFD15ERR_EIC                        INTC2_EIC339
#define RENESAS_RSCANFD16ERR_EIC                        INTC2_EIC342
#define RENESAS_RSCANFD17ERR_EIC                        INTC2_EIC345

#define RENESAS_RSCANFD05REC_EIC                        INTC2_EIC314
#define RENESAS_RSCANFD06REC_EIC                        INTC2_EIC317
#define RENESAS_RSCANFD07REC_EIC                        INTC2_EIC320
#define RENESAS_RSCANFD10REC_EIC                        INTC2_EIC325
#define RENESAS_RSCANFD11REC_EIC                        INTC2_EIC328
#define RENESAS_RSCANFD12REC_EIC                        INTC2_EIC331
#define RENESAS_RSCANFD13REC_EIC                        INTC2_EIC334
#define RENESAS_RSCANFD14REC_EIC                        INTC2_EIC337
#define RENESAS_RSCANFD15REC_EIC                        INTC2_EIC340
#define RENESAS_RSCANFD16REC_EIC                        INTC2_EIC343
#define RENESAS_RSCANFD17REC_EIC                        INTC2_EIC346

#define RENESAS_RSCANFD05TRX_EIC                        INTC2_EIC315
#define RENESAS_RSCANFD06TRX_EIC                        INTC2_EIC318
#define RENESAS_RSCANFD07TRX_EIC                        INTC2_EIC321
#define RENESAS_RSCANFD10TRX_EIC                        INTC2_EIC326
#define RENESAS_RSCANFD11TRX_EIC                        INTC2_EIC329
#define RENESAS_RSCANFD12TRX_EIC                        INTC2_EIC332
#define RENESAS_RSCANFD13TRX_EIC                        INTC2_EIC335
#define RENESAS_RSCANFD14TRX_EIC                        INTC2_EIC338
#define RENESAS_RSCANFD15TRX_EIC                        INTC2_EIC341
#define RENESAS_RSCANFD16TRX_EIC                        INTC2_EIC344
#define RENESAS_RSCANFD17TRX_EIC                        INTC2_EIC347

/* CAN wakeup interrupt register */
#define RENESAS_RSCANFD00WUP_EIC                        INTC2_EIC544
#define RENESAS_RSCANFD01WUP_EIC                        INTC2_EIC545
#define RENESAS_RSCANFD02WUP_EIC                        INTC2_EIC546
#define RENESAS_RSCANFD03WUP_EIC                        INTC2_EIC547
#define RENESAS_RSCANFD04WUP_EIC                        INTC2_EIC548
#define RENESAS_RSCANFD05WUP_EIC                        INTC2_EIC549
#define RENESAS_RSCANFD06WUP_EIC                        INTC2_EIC550
#define RENESAS_RSCANFD07WUP_EIC                        INTC2_EIC551
#define RENESAS_RSCANFD10WUP_EIC                        INTC2_EIC552
#define RENESAS_RSCANFD11WUP_EIC                        INTC2_EIC553
#define RENESAS_RSCANFD12WUP_EIC                        INTC2_EIC554
#define RENESAS_RSCANFD13WUP_EIC                        INTC2_EIC555
#define RENESAS_RSCANFD14WUP_EIC                        INTC2_EIC556
#define RENESAS_RSCANFD15WUP_EIC                        INTC2_EIC557
#define RENESAS_RSCANFD16WUP_EIC                        INTC2_EIC558
#define RENESAS_RSCANFD17WUP_EIC                        INTC2_EIC559

/* Wakeup Factor Clear registers*/
#define RENESAS_WUF0_I0                                 SYSCTRL_WUF0_I0
#define RENESAS_WUFMSK0_I0                              SYSCTRL_WUFMSK0_I0
#define RENESAS_WUFC0_I0                                SYSCTRL_WUFC0_I0

/*******************************************************************************
**                        Macros for CAN QUEUE Implementation                 **
*******************************************************************************/


/*******************************************************************************
**                 Macros for LIN Driver                                      **
*******************************************************************************/
#define RENESAS_RLIN30LWBR                              RLIN30_LWBR
#define RENESAS_RLIN31LWBR                              RLIN31_LWBR
#define RENESAS_RLIN32LWBR                              RLIN32_LWBR
#define RENESAS_RLIN33LWBR                              RLIN33_LWBR
#define RENESAS_RLIN34LWBR                              RLIN34_LWBR
#define RENESAS_RLIN35LWBR                              RLIN35_LWBR
#define RENESAS_RLIN36LWBR                              RLIN36_LWBR
#define RENESAS_RLIN37LWBR                              RLIN37_LWBR
#define RENESAS_RLIN38LWBR                              RLIN38_LWBR
#define RENESAS_RLIN39LWBR                              RLIN39_LWBR
#define RENESAS_RLIN310LWBR                             RLIN310_LWBR
#define RENESAS_RLIN311LWBR                             RLIN311_LWBR
#define RENESAS_RLIN312LWBR                             RLIN312_LWBR
#define RENESAS_RLIN313LWBR                             RLIN313_LWBR
#define RENESAS_RLIN314LWBR                             RLIN314_LWBR
#define RENESAS_RLIN315LWBR                             RLIN315_LWBR
#define RENESAS_RLIN316LWBR                             RLIN316_LWBR
#define RENESAS_RLIN317LWBR                             RLIN317_LWBR
#define RENESAS_RLIN318LWBR                             RLIN318_LWBR
#define RENESAS_RLIN319LWBR                             RLIN319_LWBR
#define RENESAS_RLIN320LWBR                             RLIN320_LWBR
#define RENESAS_RLIN321LWBR                             RLIN321_LWBR
#define RENESAS_RLIN322LWBR                             RLIN322_LWBR
#define RENESAS_RLIN323LWBR                             RLIN323_LWBR

#define RENESAS_ICRLIN30UR0                             INTC2_EIC417
#define RENESAS_ICRLIN30UR1                             INTC2_EIC418
#define RENESAS_ICRLIN30UR2                             INTC2_EIC419

#define RENESAS_ICRLIN31UR0                             INTC2_EIC421
#define RENESAS_ICRLIN31UR1                             INTC2_EIC422
#define RENESAS_ICRLIN31UR2                             INTC2_EIC423

#define RENESAS_ICRLIN32UR0                             INTC2_EIC425
#define RENESAS_ICRLIN32UR1                             INTC2_EIC426
#define RENESAS_ICRLIN32UR2                             INTC2_EIC427

#define RENESAS_ICRLIN33UR0                             INTC2_EIC429
#define RENESAS_ICRLIN33UR1                             INTC2_EIC430
#define RENESAS_ICRLIN33UR2                             INTC2_EIC431

#define RENESAS_ICRLIN34UR0                             INTC2_EIC433
#define RENESAS_ICRLIN34UR1                             INTC2_EIC434
#define RENESAS_ICRLIN34UR2                             INTC2_EIC435

#define RENESAS_ICRLIN35UR0                             INTC2_EIC437
#define RENESAS_ICRLIN35UR1                             INTC2_EIC438
#define RENESAS_ICRLIN35UR2                             INTC2_EIC439

#define RENESAS_ICRLIN36UR0                             INTC2_EIC441
#define RENESAS_ICRLIN36UR1                             INTC2_EIC442
#define RENESAS_ICRLIN36UR2                             INTC2_EIC443

#define RENESAS_ICRLIN37UR0                             INTC2_EIC445
#define RENESAS_ICRLIN37UR1                             INTC2_EIC446
#define RENESAS_ICRLIN37UR2                             INTC2_EIC447

#define RENESAS_ICRLIN38UR0                             INTC2_EIC449
#define RENESAS_ICRLIN38UR1                             INTC2_EIC450
#define RENESAS_ICRLIN38UR2                             INTC2_EIC451

#define RENESAS_ICRLIN39UR0                             INTC2_EIC453
#define RENESAS_ICRLIN39UR1                             INTC2_EIC454
#define RENESAS_ICRLIN39UR2                             INTC2_EIC455

#define RENESAS_ICRLIN310UR0                            INTC2_EIC457
#define RENESAS_ICRLIN310UR1                            INTC2_EIC458
#define RENESAS_ICRLIN310UR2                            INTC2_EIC459

#define RENESAS_ICRLIN311UR0                            INTC2_EIC461
#define RENESAS_ICRLIN311UR1                            INTC2_EIC462
#define RENESAS_ICRLIN311UR2                            INTC2_EIC463

#define RENESAS_ICRLIN312UR0                            INTC2_EIC465
#define RENESAS_ICRLIN312UR1                            INTC2_EIC466
#define RENESAS_ICRLIN312UR2                            INTC2_EIC467

#define RENESAS_ICRLIN313UR0                            INTC2_EIC469
#define RENESAS_ICRLIN313UR1                            INTC2_EIC470
#define RENESAS_ICRLIN313UR2                            INTC2_EIC471

#define RENESAS_ICRLIN314UR0                            INTC2_EIC473
#define RENESAS_ICRLIN314UR1                            INTC2_EIC474
#define RENESAS_ICRLIN314UR2                            INTC2_EIC475

#define RENESAS_ICRLIN315UR0                            INTC2_EIC477
#define RENESAS_ICRLIN315UR1                            INTC2_EIC478
#define RENESAS_ICRLIN315UR2                            INTC2_EIC479

#define RENESAS_ICRLIN316UR0                            INTC2_EIC481
#define RENESAS_ICRLIN316UR1                            INTC2_EIC482
#define RENESAS_ICRLIN316UR2                            INTC2_EIC483

#define RENESAS_ICRLIN317UR0                            INTC2_EIC485
#define RENESAS_ICRLIN317UR1                            INTC2_EIC486
#define RENESAS_ICRLIN317UR2                            INTC2_EIC487

#define RENESAS_ICRLIN318UR0                            INTC2_EIC489
#define RENESAS_ICRLIN318UR1                            INTC2_EIC490
#define RENESAS_ICRLIN318UR2                            INTC2_EIC491

#define RENESAS_ICRLIN319UR0                            INTC2_EIC493
#define RENESAS_ICRLIN319UR1                            INTC2_EIC494
#define RENESAS_ICRLIN319UR2                            INTC2_EIC495

#define RENESAS_ICRLIN320UR0                            INTC2_EIC497
#define RENESAS_ICRLIN320UR1                            INTC2_EIC498
#define RENESAS_ICRLIN320UR2                            INTC2_EIC499

#define RENESAS_ICRLIN321UR0                            INTC2_EIC501
#define RENESAS_ICRLIN321UR1                            INTC2_EIC502
#define RENESAS_ICRLIN321UR2                            INTC2_EIC503

#define RENESAS_ICRLIN322UR0                            INTC2_EIC505
#define RENESAS_ICRLIN322UR1                            INTC2_EIC506
#define RENESAS_ICRLIN322UR2                            INTC2_EIC507

#define RENESAS_ICRLIN323UR0                            INTC2_EIC509
#define RENESAS_ICRLIN323UR1                            INTC2_EIC510
#define RENESAS_ICRLIN323UR2                            INTC2_EIC511

/* Macros for MCU clock reference */
#define RENESAS_LINMCUREFCLOCK                          McuPeripheralClock

/*******************************************************************************
**                 Macros for FLS Software Component                          **
*******************************************************************************/
#define RENESAS_FHVE3_0                                 FHVE3_FP0
#define RENESAS_FHVE15_0                                FHVE15_FP0
#define RENESAS_FHVE3_1                                 FHVE3_FP1
#define RENESAS_FHVE15_1                                FHVE15_FP1
#define RENESAS_ECC                                     ECCDF_DFECCCTL

/* not exist device header file( E1.00i) */
#define RENESAS_FACI0                                   0xFFA10000UL
#define RENESAS_FACI1                                   0xFFA14000UL
#define RENESAS_DFIDIN0                                 0xFFA08020
#define RENESAS_IDST                                    0xFFA081FC
#define RENESAS_S_OPBT4                                 0xFF300090
/* MCU reference*/
#define RENESAS_FLS_MCUREF_PARAM                        McuCpuMainSysClk

#define RENESAS_ICFLENDNM0_IMR                          34
#define RENESAS_ICFLENDNM1_IMR                          36
#define RENESAS_ICFLENDNM0L_ADDR                        INTC2_EIC34L
#define RENESAS_ICFLENDNM0H_ADDR                        INTC2_EIC34H

#define RENESAS_ICFLENDNM1L_ADDR                        INTC2_EIC36L
#define RENESAS_ICFLENDNM1H_ADDR                        INTC2_EIC36H

#define RENESAS_RFD_SUPPORT                             0x1

#define RENESAS_CMDAREA_FACI0                           0xFFA20000UL
#define RENESAS_CMDAREA_FACI1                           0xFFA30000UL

/*******************************************************************************
**                 Macros for RAMTST Software Component                      **
*******************************************************************************/
#define RENESAS_LRECCCTL_PE0                            ECCCNT_LR_PE0CL0_LRECCCTL
#define RENESAS_LRECCCTL_PE1                            ECCCNT_LR_PE1CL0_LRECCCTL
#define RENESAS_LRECCCTL_PE2                            ECCCNT_LR_PE2CL1_LRECCCTL
#define RENESAS_LRECCCTL_PE3                            ECCCNT_LR_PE3CL1_LRECCCTL

#define RENESAS_LR0_ERRINT_PE0                          MECCCAP_LR_PE0CL0_LR0_ERRINT
#define RENESAS_LR0_ERRINT_PE1                          MECCCAP_LR_PE1CL0_LR0_ERRINT
#define RENESAS_LR0_ERRINT_PE2                          MECCCAP_LR_PE2CL1_LR0_ERRINT
#define RENESAS_LR0_ERRINT_PE3                          MECCCAP_LR_PE3CL1_LR0_ERRINT
#define RENESAS_LR1_ERRINT                              MECCCAP_LRA_LR1_ERRINT


/*******************************************************************************

/*******************************************************************************
**                     Macros for Flexray Drivers                             **
*******************************************************************************/
#define RENESAS_FLXA0FROC                               FLXA0_FROC
#define RENESAS_FLXA0FROS                               FLXA0_FROS
#define RENESAS_FLXA0FRLCK                              FLXA0_FRLCK
#define RENESAS_FLXA0FREIR                              FLXA0_FREIR
#define RENESAS_FLXA0FRSIR                              FLXA0_FRSIR
#define RENESAS_FLXA0FREILS                             FLXA0_FREILS
#define RENESAS_FLXA0FRSILS                             FLXA0_FRSILS
#define RENESAS_FLXA0FREIES                             FLXA0_FREIES
#define RENESAS_FLXA0FREIER                             FLXA0_FREIER
#define RENESAS_FLXA0FRSIES                             FLXA0_FRSIES
#define RENESAS_FLXA0FRSIER                             FLXA0_FRSIER
#define RENESAS_FLXA0FRILE                              FLXA0_FRILE
#define RENESAS_FLXA0FRT0C                              FLXA0_FRT0C
#define RENESAS_FLXA0FRT1C                              FLXA0_FRT1C
#define RENESAS_FLXA0FRSTPW1                            FLXA0_FRSTPW1
#define RENESAS_FLXA0FRSTPW2                            FLXA0_FRSTPW2
#define RENESAS_FLXA0FRSUCC1                            FLXA0_FRSUCC1
#define RENESAS_FLXA0FRSUCC2                            FLXA0_FRSUCC2
#define RENESAS_FLXA0FRSUCC3                            FLXA0_FRSUCC3
#define RENESAS_FLXA0FRNEMC                             FLXA0_FRNEMC
#define RENESAS_FLXA0FRPRTC1                            FLXA0_FRPRTC1
#define RENESAS_FLXA0FRPRTC2                            FLXA0_FRPRTC2
#define RENESAS_FLXA0FRMHDC                             FLXA0_FRMHDC
#define RENESAS_FLXA0FRGTUC1                            FLXA0_FRGTUC1
#define RENESAS_FLXA0FRGTUC2                            FLXA0_FRGTUC2
#define RENESAS_FLXA0FRGTUC3                            FLXA0_FRGTUC3
#define RENESAS_FLXA0FRGTUC4                            FLXA0_FRGTUC4
#define RENESAS_FLXA0FRGTUC5                            FLXA0_FRGTUC5
#define RENESAS_FLXA0FRGTUC6                            FLXA0_FRGTUC6
#define RENESAS_FLXA0FRGTUC7                            FLXA0_FRGTUC7
#define RENESAS_FLXA0FRGTUC8                            FLXA0_FRGTUC8
#define RENESAS_FLXA0FRGTUC9                            FLXA0_FRGTUC9
#define RENESAS_FLXA0FRGTUC10                           FLXA0_FRGTUC10
#define RENESAS_FLXA0FRGTUC11                           FLXA0_FRGTUC11
#define RENESAS_FLXA0FRCCSV                             FLXA0_FRCCSV
#define RENESAS_FLXA0FRCCEV                             FLXA0_FRCCEV
#define RENESAS_FLXA0FRSCV                              FLXA0_FRSCV
#define RENESAS_FLXA0FRMTCCV                            FLXA0_FRMTCCV
#define RENESAS_FLXA0FRRCV                              FLXA0_FRRCV
#define RENESAS_FLXA0FROCV                              FLXA0_FROCV
#define RENESAS_FLXA0FRSFS                              FLXA0_FRSFS
#define RENESAS_FLXA0FRSWNIT                            FLXA0_FRSWNIT
#define RENESAS_FLXA0FRACS                              FLXA0_FRACS
#define RENESAS_FLXA0FRESID1                            FLXA0_FRESID1
#define RENESAS_FLXA0FRESID2                            FLXA0_FRESID2
#define RENESAS_FLXA0FRESID3                            FLXA0_FRESID3
#define RENESAS_FLXA0FRESID4                            FLXA0_FRESID4
#define RENESAS_FLXA0FRESID5                            FLXA0_FRESID5
#define RENESAS_FLXA0FRESID6                            FLXA0_FRESID6
#define RENESAS_FLXA0FRESID7                            FLXA0_FRESID7
#define RENESAS_FLXA0FRESID8                            FLXA0_FRESID8
#define RENESAS_FLXA0FRESID9                            FLXA0_FRESID9
#define RENESAS_FLXA0FRESID10                           FLXA0_FRESID10
#define RENESAS_FLXA0FRESID11                           FLXA0_FRESID11
#define RENESAS_FLXA0FRESID12                           FLXA0_FRESID12
#define RENESAS_FLXA0FRESID13                           FLXA0_FRESID13
#define RENESAS_FLXA0FRESID14                           FLXA0_FRESID14
#define RENESAS_FLXA0FRESID15                           FLXA0_FRESID15
#define RENESAS_FLXA0FROSID1                            FLXA0_FROSID1
#define RENESAS_FLXA0FROSID2                            FLXA0_FROSID2
#define RENESAS_FLXA0FROSID3                            FLXA0_FROSID3
#define RENESAS_FLXA0FROSID4                            FLXA0_FROSID4
#define RENESAS_FLXA0FROSID5                            FLXA0_FROSID5
#define RENESAS_FLXA0FROSID6                            FLXA0_FROSID6
#define RENESAS_FLXA0FROSID7                            FLXA0_FROSID7
#define RENESAS_FLXA0FROSID8                            FLXA0_FROSID8
#define RENESAS_FLXA0FROSID9                            FLXA0_FROSID9
#define RENESAS_FLXA0FROSID10                           FLXA0_FROSID10
#define RENESAS_FLXA0FROSID11                           FLXA0_FROSID11
#define RENESAS_FLXA0FROSID12                           FLXA0_FROSID12
#define RENESAS_FLXA0FROSID13                           FLXA0_FROSID13
#define RENESAS_FLXA0FROSID14                           FLXA0_FROSID14
#define RENESAS_FLXA0FROSID15                           FLXA0_FROSID15
#define RENESAS_FLXA0FRNMV1                             FLXA0_FRNMV1
#define RENESAS_FLXA0FRNMV2                             FLXA0_FRNMV2
#define RENESAS_FLXA0FRNMV3                             FLXA0_FRNMV3
#define RENESAS_FLXA0FRMRC                              FLXA0_FRMRC
#define RENESAS_FLXA0FRFRF                              FLXA0_FRFRF
#define RENESAS_FLXA0FRFRFM                             FLXA0_FRFRFM
#define RENESAS_FLXA0FRFCL                              FLXA0_FRFCL
#define RENESAS_FLXA0FRMHDS                             FLXA0_FRMHDS
#define RENESAS_FLXA0FRLDTS                             FLXA0_FRLDTS
#define RENESAS_FLXA0FRFSR                              FLXA0_FRFSR
#define RENESAS_FLXA0FRMHDF                             FLXA0_FRMHDF
#define RENESAS_FLXA0FRTXRQ1                            FLXA0_FRTXRQ1
#define RENESAS_FLXA0FRTXRQ2                            FLXA0_FRTXRQ2
#define RENESAS_FLXA0FRTXRQ3                            FLXA0_FRTXRQ3
#define RENESAS_FLXA0FRTXRQ4                            FLXA0_FRTXRQ4
#define RENESAS_FLXA0FRNDAT1                            FLXA0_FRNDAT1
#define RENESAS_FLXA0FRNDAT2                            FLXA0_FRNDAT2
#define RENESAS_FLXA0FRNDAT3                            FLXA0_FRNDAT3
#define RENESAS_FLXA0FRNDAT4                            FLXA0_FRNDAT4
#define RENESAS_FLXA0FRMBSC1                            FLXA0_FRMBSC1
#define RENESAS_FLXA0FRMBSC2                            FLXA0_FRMBSC2
#define RENESAS_FLXA0FRMBSC3                            FLXA0_FRMBSC3
#define RENESAS_FLXA0FRMBSC4                            FLXA0_FRMBSC4
#define RENESAS_FLXA0FRWRDS1                            FLXA0_FRWRDS1
#define RENESAS_FLXA0FRWRDS2                            FLXA0_FRWRDS2
#define RENESAS_FLXA0FRWRDS3                            FLXA0_FRWRDS3
#define RENESAS_FLXA0FRWRDS4                            FLXA0_FRWRDS4
#define RENESAS_FLXA0FRWRDS5                            FLXA0_FRWRDS5
#define RENESAS_FLXA0FRWRDS6                            FLXA0_FRWRDS6
#define RENESAS_FLXA0FRWRDS7                            FLXA0_FRWRDS7
#define RENESAS_FLXA0FRWRDS8                            FLXA0_FRWRDS8
#define RENESAS_FLXA0FRWRDS9                            FLXA0_FRWRDS9
#define RENESAS_FLXA0FRWRDS10                           FLXA0_FRWRDS10
#define RENESAS_FLXA0FRWRDS11                           FLXA0_FRWRDS11
#define RENESAS_FLXA0FRWRDS12                           FLXA0_FRWRDS12
#define RENESAS_FLXA0FRWRDS13                           FLXA0_FRWRDS13
#define RENESAS_FLXA0FRWRDS14                           FLXA0_FRWRDS14
#define RENESAS_FLXA0FRWRDS15                           FLXA0_FRWRDS15
#define RENESAS_FLXA0FRWRDS16                           FLXA0_FRWRDS16
#define RENESAS_FLXA0FRWRDS17                           FLXA0_FRWRDS17
#define RENESAS_FLXA0FRWRDS18                           FLXA0_FRWRDS18
#define RENESAS_FLXA0FRWRDS19                           FLXA0_FRWRDS19
#define RENESAS_FLXA0FRWRDS20                           FLXA0_FRWRDS20
#define RENESAS_FLXA0FRWRDS21                           FLXA0_FRWRDS21
#define RENESAS_FLXA0FRWRDS22                           FLXA0_FRWRDS22
#define RENESAS_FLXA0FRWRDS23                           FLXA0_FRWRDS23
#define RENESAS_FLXA0FRWRDS24                           FLXA0_FRWRDS24
#define RENESAS_FLXA0FRWRDS25                           FLXA0_FRWRDS25
#define RENESAS_FLXA0FRWRDS26                           FLXA0_FRWRDS26
#define RENESAS_FLXA0FRWRDS27                           FLXA0_FRWRDS27
#define RENESAS_FLXA0FRWRDS28                           FLXA0_FRWRDS28
#define RENESAS_FLXA0FRWRDS29                           FLXA0_FRWRDS29
#define RENESAS_FLXA0FRWRDS30                           FLXA0_FRWRDS30
#define RENESAS_FLXA0FRWRDS31                           FLXA0_FRWRDS31
#define RENESAS_FLXA0FRWRDS32                           FLXA0_FRWRDS32
#define RENESAS_FLXA0FRWRDS33                           FLXA0_FRWRDS33
#define RENESAS_FLXA0FRWRDS34                           FLXA0_FRWRDS34
#define RENESAS_FLXA0FRWRDS35                           FLXA0_FRWRDS35
#define RENESAS_FLXA0FRWRDS36                           FLXA0_FRWRDS36
#define RENESAS_FLXA0FRWRDS37                           FLXA0_FRWRDS37
#define RENESAS_FLXA0FRWRDS38                           FLXA0_FRWRDS38
#define RENESAS_FLXA0FRWRDS39                           FLXA0_FRWRDS39
#define RENESAS_FLXA0FRWRDS40                           FLXA0_FRWRDS40
#define RENESAS_FLXA0FRWRDS41                           FLXA0_FRWRDS41
#define RENESAS_FLXA0FRWRDS42                           FLXA0_FRWRDS42
#define RENESAS_FLXA0FRWRDS43                           FLXA0_FRWRDS43
#define RENESAS_FLXA0FRWRDS44                           FLXA0_FRWRDS44
#define RENESAS_FLXA0FRWRDS45                           FLXA0_FRWRDS45
#define RENESAS_FLXA0FRWRDS46                           FLXA0_FRWRDS46
#define RENESAS_FLXA0FRWRDS47                           FLXA0_FRWRDS47
#define RENESAS_FLXA0FRWRDS48                           FLXA0_FRWRDS48
#define RENESAS_FLXA0FRWRDS49                           FLXA0_FRWRDS49
#define RENESAS_FLXA0FRWRDS50                           FLXA0_FRWRDS50
#define RENESAS_FLXA0FRWRDS51                           FLXA0_FRWRDS51
#define RENESAS_FLXA0FRWRDS52                           FLXA0_FRWRDS52
#define RENESAS_FLXA0FRWRDS53                           FLXA0_FRWRDS53
#define RENESAS_FLXA0FRWRDS54                           FLXA0_FRWRDS54
#define RENESAS_FLXA0FRWRDS55                           FLXA0_FRWRDS55
#define RENESAS_FLXA0FRWRDS56                           FLXA0_FRWRDS56
#define RENESAS_FLXA0FRWRDS57                           FLXA0_FRWRDS57
#define RENESAS_FLXA0FRWRDS58                           FLXA0_FRWRDS58
#define RENESAS_FLXA0FRWRDS59                           FLXA0_FRWRDS59
#define RENESAS_FLXA0FRWRDS60                           FLXA0_FRWRDS60
#define RENESAS_FLXA0FRWRDS61                           FLXA0_FRWRDS61
#define RENESAS_FLXA0FRWRDS62                           FLXA0_FRWRDS62
#define RENESAS_FLXA0FRWRDS63                           FLXA0_FRWRDS63
#define RENESAS_FLXA0FRWRDS64                           FLXA0_FRWRDS64
#define RENESAS_FLXA0FRWRHS1                            FLXA0_FRWRHS1
#define RENESAS_FLXA0FRWRHS2                            FLXA0_FRWRHS2
#define RENESAS_FLXA0FRIBCM                             FLXA0_FRIBCM
#define RENESAS_FLXA0FRIBCR                             FLXA0_FRIBCR
#define RENESAS_FLXA0FRRDDS1                            FLXA0_FRRDDS1
#define RENESAS_FLXA0FRRDDS2                            FLXA0_FRRDDS2
#define RENESAS_FLXA0FRRDDS3                            FLXA0_FRRDDS3
#define RENESAS_FLXA0FRRDDS4                            FLXA0_FRRDDS4
#define RENESAS_FLXA0FRRDDS5                            FLXA0_FRRDDS5
#define RENESAS_FLXA0FRRDDS6                            FLXA0_FRRDDS6
#define RENESAS_FLXA0FRRDDS7                            FLXA0_FRRDDS7
#define RENESAS_FLXA0FRRDDS8                            FLXA0_FRRDDS8
#define RENESAS_FLXA0FRRDDS9                            FLXA0_FRRDDS9
#define RENESAS_FLXA0FRRDDS10                           FLXA0_FRRDDS10
#define RENESAS_FLXA0FRRDDS11                           FLXA0_FRRDDS11
#define RENESAS_FLXA0FRRDDS12                           FLXA0_FRRDDS12
#define RENESAS_FLXA0FRRDDS13                           FLXA0_FRRDDS13
#define RENESAS_FLXA0FRRDDS14                           FLXA0_FRRDDS14
#define RENESAS_FLXA0FRRDDS15                           FLXA0_FRRDDS15
#define RENESAS_FLXA0FRRDDS16                           FLXA0_FRRDDS16
#define RENESAS_FLXA0FRRDDS17                           FLXA0_FRRDDS17
#define RENESAS_FLXA0FRRDDS18                           FLXA0_FRRDDS18
#define RENESAS_FLXA0FRRDDS19                           FLXA0_FRRDDS19
#define RENESAS_FLXA0FRRDDS20                           FLXA0_FRRDDS20
#define RENESAS_FLXA0FRRDDS21                           FLXA0_FRRDDS21
#define RENESAS_FLXA0FRRDDS22                           FLXA0_FRRDDS22
#define RENESAS_FLXA0FRRDDS23                           FLXA0_FRRDDS23
#define RENESAS_FLXA0FRRDDS24                           FLXA0_FRRDDS24
#define RENESAS_FLXA0FRRDDS25                           FLXA0_FRRDDS25
#define RENESAS_FLXA0FRRDDS26                           FLXA0_FRRDDS26
#define RENESAS_FLXA0FRRDDS27                           FLXA0_FRRDDS27
#define RENESAS_FLXA0FRRDDS28                           FLXA0_FRRDDS28
#define RENESAS_FLXA0FRRDDS29                           FLXA0_FRRDDS29
#define RENESAS_FLXA0FRRDDS30                           FLXA0_FRRDDS30
#define RENESAS_FLXA0FRRDDS31                           FLXA0_FRRDDS31
#define RENESAS_FLXA0FRRDDS32                           FLXA0_FRRDDS32
#define RENESAS_FLXA0FRRDDS33                           FLXA0_FRRDDS33
#define RENESAS_FLXA0FRRDDS34                           FLXA0_FRRDDS34
#define RENESAS_FLXA0FRRDDS35                           FLXA0_FRRDDS35
#define RENESAS_FLXA0FRRDDS36                           FLXA0_FRRDDS36
#define RENESAS_FLXA0FRRDDS37                           FLXA0_FRRDDS37
#define RENESAS_FLXA0FRRDDS38                           FLXA0_FRRDDS38
#define RENESAS_FLXA0FRRDDS39                           FLXA0_FRRDDS39
#define RENESAS_FLXA0FRRDDS40                           FLXA0_FRRDDS40
#define RENESAS_FLXA0FRRDDS41                           FLXA0_FRRDDS41
#define RENESAS_FLXA0FRRDDS42                           FLXA0_FRRDDS42
#define RENESAS_FLXA0FRRDDS43                           FLXA0_FRRDDS43
#define RENESAS_FLXA0FRRDDS44                           FLXA0_FRRDDS44
#define RENESAS_FLXA0FRRDDS45                           FLXA0_FRRDDS45
#define RENESAS_FLXA0FRRDDS46                           FLXA0_FRRDDS46
#define RENESAS_FLXA0FRRDDS47                           FLXA0_FRRDDS47
#define RENESAS_FLXA0FRRDDS48                           FLXA0_FRRDDS48
#define RENESAS_FLXA0FRRDDS49                           FLXA0_FRRDDS49
#define RENESAS_FLXA0FRRDDS50                           FLXA0_FRRDDS50
#define RENESAS_FLXA0FRRDDS51                           FLXA0_FRRDDS51
#define RENESAS_FLXA0FRRDDS52                           FLXA0_FRRDDS52
#define RENESAS_FLXA0FRRDDS53                           FLXA0_FRRDDS53
#define RENESAS_FLXA0FRRDDS54                           FLXA0_FRRDDS54
#define RENESAS_FLXA0FRRDDS55                           FLXA0_FRRDDS55
#define RENESAS_FLXA0FRRDDS56                           FLXA0_FRRDDS56
#define RENESAS_FLXA0FRRDDS57                           FLXA0_FRRDDS57
#define RENESAS_FLXA0FRRDDS58                           FLXA0_FRRDDS58
#define RENESAS_FLXA0FRRDDS59                           FLXA0_FRRDDS59
#define RENESAS_FLXA0FRRDDS60                           FLXA0_FRRDDS60
#define RENESAS_FLXA0FRRDDS61                           FLXA0_FRRDDS61
#define RENESAS_FLXA0FRRDDS62                           FLXA0_FRRDDS62
#define RENESAS_FLXA0FRRDDS63                           FLXA0_FRRDDS63
#define RENESAS_FLXA0FRRDDS64                           FLXA0_FRRDDS64
#define RENESAS_FLXA0FRRDHS1                            FLXA0_FRRDHS1
#define RENESAS_FLXA0FRRDHS2                            FLXA0_FRRDHS2
#define RENESAS_FLXA0FRMBS                              FLXA0_FRMBS
#define RENESAS_FLXA0FROBCM                             FLXA0_FROBCM
#define RENESAS_FLXA0FROBCR                             FLXA0_FROBCR
#define RENESAS_FLXA0FRITC                              FLXA0_FRITC
#define RENESAS_FLXA0FROTC                              FLXA0_FROTC
#define RENESAS_FLXA0FRAES                              FLXA0_FRAES
#define RENESAS_FLXA0FRIQC                              FLXA0_FRIQC
#define RENESAS_FLXA0FRITS                              FLXA0_FRITS

#define RENESAS_FLXA0FROTS                              FLXA0_FROTS
#define RENESAS_FLXA0FRUIR                              FLXA0_FRUIR
#define RENESAS_FLXA0FRUOR                              FLXA0_FRUOR
#define RENESAS_FLXA0FRT2C                              FLXA0_FRT2C

#define RENESAS_FLXA1FROC                               FLXA1_FROC
#define RENESAS_FLXA1FROS                               FLXA1_FROS
#define RENESAS_FLXA1FRLCK                              FLXA1_FRLCK
#define RENESAS_FLXA1FREIR                              FLXA1_FREIR
#define RENESAS_FLXA1FRSIR                              FLXA1_FRSIR
#define RENESAS_FLXA1FREILS                             FLXA1_FREILS
#define RENESAS_FLXA1FRSILS                             FLXA1_FRSILS
#define RENESAS_FLXA1FREIES                             FLXA1_FREIES
#define RENESAS_FLXA1FREIER                             FLXA1_FREIER
#define RENESAS_FLXA1FRSIES                             FLXA1_FRSIES
#define RENESAS_FLXA1FRSIER                             FLXA1_FRSIER
#define RENESAS_FLXA1FRILE                              FLXA1_FRILE
#define RENESAS_FLXA1FRT0C                              FLXA1_FRT0C
#define RENESAS_FLXA1FRT1C                              FLXA1_FRT1C
#define RENESAS_FLXA1FRSTPW1                            FLXA1_FRSTPW1
#define RENESAS_FLXA1FRSTPW2                            FLXA1_FRSTPW2
#define RENESAS_FLXA1FRSUCC1                            FLXA1_FRSUCC1
#define RENESAS_FLXA1FRSUCC2                            FLXA1_FRSUCC2
#define RENESAS_FLXA1FRSUCC3                            FLXA1_FRSUCC3
#define RENESAS_FLXA1FRNEMC                             FLXA1_FRNEMC
#define RENESAS_FLXA1FRPRTC1                            FLXA1_FRPRTC1
#define RENESAS_FLXA1FRPRTC2                            FLXA1_FRPRTC2
#define RENESAS_FLXA1FRMHDC                             FLXA1_FRMHDC
#define RENESAS_FLXA1FRGTUC1                            FLXA1_FRGTUC1
#define RENESAS_FLXA1FRGTUC2                            FLXA1_FRGTUC2
#define RENESAS_FLXA1FRGTUC3                            FLXA1_FRGTUC3
#define RENESAS_FLXA1FRGTUC4                            FLXA1_FRGTUC4
#define RENESAS_FLXA1FRGTUC5                            FLXA1_FRGTUC5
#define RENESAS_FLXA1FRGTUC6                            FLXA1_FRGTUC6
#define RENESAS_FLXA1FRGTUC7                            FLXA1_FRGTUC7
#define RENESAS_FLXA1FRGTUC8                            FLXA1_FRGTUC8
#define RENESAS_FLXA1FRGTUC9                            FLXA1_FRGTUC9
#define RENESAS_FLXA1FRGTUC10                           FLXA1_FRGTUC10
#define RENESAS_FLXA1FRGTUC11                           FLXA1_FRGTUC11
#define RENESAS_FLXA1FRCCSV                             FLXA1_FRCCSV
#define RENESAS_FLXA1FRCCEV                             FLXA1_FRCCEV
#define RENESAS_FLXA1FRSCV                              FLXA1_FRSCV
#define RENESAS_FLXA1FRMTCCV                            FLXA1_FRMTCCV
#define RENESAS_FLXA1FRRCV                              FLXA1_FRRCV
#define RENESAS_FLXA1FROCV                              FLXA1_FROCV
#define RENESAS_FLXA1FRSFS                              FLXA1_FRSFS
#define RENESAS_FLXA1FRSWNIT                            FLXA1_FRSWNIT
#define RENESAS_FLXA1FRACS                              FLXA1_FRACS
#define RENESAS_FLXA1FRESID1                            FLXA1_FRESID1
#define RENESAS_FLXA1FRESID2                            FLXA1_FRESID2
#define RENESAS_FLXA1FRESID3                            FLXA1_FRESID3
#define RENESAS_FLXA1FRESID4                            FLXA1_FRESID4
#define RENESAS_FLXA1FRESID5                            FLXA1_FRESID5
#define RENESAS_FLXA1FRESID6                            FLXA1_FRESID6
#define RENESAS_FLXA1FRESID7                            FLXA1_FRESID7
#define RENESAS_FLXA1FRESID8                            FLXA1_FRESID8
#define RENESAS_FLXA1FRESID9                            FLXA1_FRESID9
#define RENESAS_FLXA1FRESID10                           FLXA1_FRESID10
#define RENESAS_FLXA1FRESID11                           FLXA1_FRESID11
#define RENESAS_FLXA1FRESID12                           FLXA1_FRESID12
#define RENESAS_FLXA1FRESID13                           FLXA1_FRESID13
#define RENESAS_FLXA1FRESID14                           FLXA1_FRESID14
#define RENESAS_FLXA1FRESID15                           FLXA1_FRESID15
#define RENESAS_FLXA1FROSID1                            FLXA1_FROSID1
#define RENESAS_FLXA1FROSID2                            FLXA1_FROSID2
#define RENESAS_FLXA1FROSID3                            FLXA1_FROSID3
#define RENESAS_FLXA1FROSID4                            FLXA1_FROSID4
#define RENESAS_FLXA1FROSID5                            FLXA1_FROSID5
#define RENESAS_FLXA1FROSID6                            FLXA1_FROSID6
#define RENESAS_FLXA1FROSID7                            FLXA1_FROSID7
#define RENESAS_FLXA1FROSID8                            FLXA1_FROSID8
#define RENESAS_FLXA1FROSID9                            FLXA1_FROSID9
#define RENESAS_FLXA1FROSID10                           FLXA1_FROSID10
#define RENESAS_FLXA1FROSID11                           FLXA1_FROSID11
#define RENESAS_FLXA1FROSID12                           FLXA1_FROSID12
#define RENESAS_FLXA1FROSID13                           FLXA1_FROSID13
#define RENESAS_FLXA1FROSID14                           FLXA1_FROSID14
#define RENESAS_FLXA1FROSID15                           FLXA1_FROSID15
#define RENESAS_FLXA1FRNMV1                             FLXA1_FRNMV1
#define RENESAS_FLXA1FRNMV2                             FLXA1_FRNMV2
#define RENESAS_FLXA1FRNMV3                             FLXA1_FRNMV3
#define RENESAS_FLXA1FRMRC                              FLXA1_FRMRC
#define RENESAS_FLXA1FRFRF                              FLXA1_FRFRF
#define RENESAS_FLXA1FRFRFM                             FLXA1_FRFRFM
#define RENESAS_FLXA1FRFCL                              FLXA1_FRFCL
#define RENESAS_FLXA1FRMHDS                             FLXA1_FRMHDS
#define RENESAS_FLXA1FRLDTS                             FLXA1_FRLDTS
#define RENESAS_FLXA1FRFSR                              FLXA1_FRFSR
#define RENESAS_FLXA1FRMHDF                             FLXA1_FRMHDF
#define RENESAS_FLXA1FRTXRQ1                            FLXA1_FRTXRQ1
#define RENESAS_FLXA1FRTXRQ2                            FLXA1_FRTXRQ2
#define RENESAS_FLXA1FRTXRQ3                            FLXA1_FRTXRQ3
#define RENESAS_FLXA1FRTXRQ4                            FLXA1_FRTXRQ4
#define RENESAS_FLXA1FRNDAT1                            FLXA1_FRNDAT1
#define RENESAS_FLXA1FRNDAT2                            FLXA1_FRNDAT2
#define RENESAS_FLXA1FRNDAT3                            FLXA1_FRNDAT3
#define RENESAS_FLXA1FRNDAT4                            FLXA1_FRNDAT4
#define RENESAS_FLXA1FRMBSC1                            FLXA1_FRMBSC1
#define RENESAS_FLXA1FRMBSC2                            FLXA1_FRMBSC2
#define RENESAS_FLXA1FRMBSC3                            FLXA1_FRMBSC3
#define RENESAS_FLXA1FRMBSC4                            FLXA1_FRMBSC4
#define RENESAS_FLXA1FRWRDS1                            FLXA1_FRWRDS1
#define RENESAS_FLXA1FRWRDS2                            FLXA1_FRWRDS2
#define RENESAS_FLXA1FRWRDS3                            FLXA1_FRWRDS3
#define RENESAS_FLXA1FRWRDS4                            FLXA1_FRWRDS4
#define RENESAS_FLXA1FRWRDS5                            FLXA1_FRWRDS5
#define RENESAS_FLXA1FRWRDS6                            FLXA1_FRWRDS6
#define RENESAS_FLXA1FRWRDS7                            FLXA1_FRWRDS7
#define RENESAS_FLXA1FRWRDS8                            FLXA1_FRWRDS8
#define RENESAS_FLXA1FRWRDS9                            FLXA1_FRWRDS9
#define RENESAS_FLXA1FRWRDS10                           FLXA1_FRWRDS10
#define RENESAS_FLXA1FRWRDS11                           FLXA1_FRWRDS11
#define RENESAS_FLXA1FRWRDS12                           FLXA1_FRWRDS12
#define RENESAS_FLXA1FRWRDS13                           FLXA1_FRWRDS13
#define RENESAS_FLXA1FRWRDS14                           FLXA1_FRWRDS14
#define RENESAS_FLXA1FRWRDS15                           FLXA1_FRWRDS15
#define RENESAS_FLXA1FRWRDS16                           FLXA1_FRWRDS16
#define RENESAS_FLXA1FRWRDS17                           FLXA1_FRWRDS17
#define RENESAS_FLXA1FRWRDS18                           FLXA1_FRWRDS18
#define RENESAS_FLXA1FRWRDS19                           FLXA1_FRWRDS19
#define RENESAS_FLXA1FRWRDS20                           FLXA1_FRWRDS20
#define RENESAS_FLXA1FRWRDS21                           FLXA1_FRWRDS21
#define RENESAS_FLXA1FRWRDS22                           FLXA1_FRWRDS22
#define RENESAS_FLXA1FRWRDS23                           FLXA1_FRWRDS23
#define RENESAS_FLXA1FRWRDS24                           FLXA1_FRWRDS24
#define RENESAS_FLXA1FRWRDS25                           FLXA1_FRWRDS25
#define RENESAS_FLXA1FRWRDS26                           FLXA1_FRWRDS26
#define RENESAS_FLXA1FRWRDS27                           FLXA1_FRWRDS27
#define RENESAS_FLXA1FRWRDS28                           FLXA1_FRWRDS28
#define RENESAS_FLXA1FRWRDS29                           FLXA1_FRWRDS29
#define RENESAS_FLXA1FRWRDS30                           FLXA1_FRWRDS30
#define RENESAS_FLXA1FRWRDS31                           FLXA1_FRWRDS31
#define RENESAS_FLXA1FRWRDS32                           FLXA1_FRWRDS32
#define RENESAS_FLXA1FRWRDS33                           FLXA1_FRWRDS33
#define RENESAS_FLXA1FRWRDS34                           FLXA1_FRWRDS34
#define RENESAS_FLXA1FRWRDS35                           FLXA1_FRWRDS35
#define RENESAS_FLXA1FRWRDS36                           FLXA1_FRWRDS36
#define RENESAS_FLXA1FRWRDS37                           FLXA1_FRWRDS37
#define RENESAS_FLXA1FRWRDS38                           FLXA1_FRWRDS38
#define RENESAS_FLXA1FRWRDS39                           FLXA1_FRWRDS39
#define RENESAS_FLXA1FRWRDS40                           FLXA1_FRWRDS40
#define RENESAS_FLXA1FRWRDS41                           FLXA1_FRWRDS41
#define RENESAS_FLXA1FRWRDS42                           FLXA1_FRWRDS42
#define RENESAS_FLXA1FRWRDS43                           FLXA1_FRWRDS43
#define RENESAS_FLXA1FRWRDS44                           FLXA1_FRWRDS44
#define RENESAS_FLXA1FRWRDS45                           FLXA1_FRWRDS45
#define RENESAS_FLXA1FRWRDS46                           FLXA1_FRWRDS46
#define RENESAS_FLXA1FRWRDS47                           FLXA1_FRWRDS47
#define RENESAS_FLXA1FRWRDS48                           FLXA1_FRWRDS48
#define RENESAS_FLXA1FRWRDS49                           FLXA1_FRWRDS49
#define RENESAS_FLXA1FRWRDS50                           FLXA1_FRWRDS50
#define RENESAS_FLXA1FRWRDS51                           FLXA1_FRWRDS51
#define RENESAS_FLXA1FRWRDS52                           FLXA1_FRWRDS52
#define RENESAS_FLXA1FRWRDS53                           FLXA1_FRWRDS53
#define RENESAS_FLXA1FRWRDS54                           FLXA1_FRWRDS54
#define RENESAS_FLXA1FRWRDS55                           FLXA1_FRWRDS55
#define RENESAS_FLXA1FRWRDS56                           FLXA1_FRWRDS56
#define RENESAS_FLXA1FRWRDS57                           FLXA1_FRWRDS57
#define RENESAS_FLXA1FRWRDS58                           FLXA1_FRWRDS58
#define RENESAS_FLXA1FRWRDS59                           FLXA1_FRWRDS59
#define RENESAS_FLXA1FRWRDS60                           FLXA1_FRWRDS60
#define RENESAS_FLXA1FRWRDS61                           FLXA1_FRWRDS61
#define RENESAS_FLXA1FRWRDS62                           FLXA1_FRWRDS62
#define RENESAS_FLXA1FRWRDS63                           FLXA1_FRWRDS63
#define RENESAS_FLXA1FRWRDS64                           FLXA1_FRWRDS64
#define RENESAS_FLXA1FRWRHS1                            FLXA1_FRWRHS1
#define RENESAS_FLXA1FRWRHS2                            FLXA1_FRWRHS2
#define RENESAS_FLXA1FRIBCM                             FLXA1_FRIBCM
#define RENESAS_FLXA1FRIBCR                             FLXA1_FRIBCR
#define RENESAS_FLXA1FRRDDS1                            FLXA1_FRRDDS1
#define RENESAS_FLXA1FRRDDS2                            FLXA1_FRRDDS2
#define RENESAS_FLXA1FRRDDS3                            FLXA1_FRRDDS3
#define RENESAS_FLXA1FRRDDS4                            FLXA1_FRRDDS4
#define RENESAS_FLXA1FRRDDS5                            FLXA1_FRRDDS5
#define RENESAS_FLXA1FRRDDS6                            FLXA1_FRRDDS6
#define RENESAS_FLXA1FRRDDS7                            FLXA1_FRRDDS7
#define RENESAS_FLXA1FRRDDS8                            FLXA1_FRRDDS8
#define RENESAS_FLXA1FRRDDS9                            FLXA1_FRRDDS9
#define RENESAS_FLXA1FRRDDS10                           FLXA1_FRRDDS10
#define RENESAS_FLXA1FRRDDS11                           FLXA1_FRRDDS11
#define RENESAS_FLXA1FRRDDS12                           FLXA1_FRRDDS12
#define RENESAS_FLXA1FRRDDS13                           FLXA1_FRRDDS13
#define RENESAS_FLXA1FRRDDS14                           FLXA1_FRRDDS14
#define RENESAS_FLXA1FRRDDS15                           FLXA1_FRRDDS15
#define RENESAS_FLXA1FRRDDS16                           FLXA1_FRRDDS16
#define RENESAS_FLXA1FRRDDS17                           FLXA1_FRRDDS17
#define RENESAS_FLXA1FRRDDS18                           FLXA1_FRRDDS18
#define RENESAS_FLXA1FRRDDS19                           FLXA1_FRRDDS19
#define RENESAS_FLXA1FRRDDS20                           FLXA1_FRRDDS20
#define RENESAS_FLXA1FRRDDS21                           FLXA1_FRRDDS21
#define RENESAS_FLXA1FRRDDS22                           FLXA1_FRRDDS22
#define RENESAS_FLXA1FRRDDS23                           FLXA1_FRRDDS23
#define RENESAS_FLXA1FRRDDS24                           FLXA1_FRRDDS24
#define RENESAS_FLXA1FRRDDS25                           FLXA1_FRRDDS25
#define RENESAS_FLXA1FRRDDS26                           FLXA1_FRRDDS26
#define RENESAS_FLXA1FRRDDS27                           FLXA1_FRRDDS27
#define RENESAS_FLXA1FRRDDS28                           FLXA1_FRRDDS28
#define RENESAS_FLXA1FRRDDS29                           FLXA1_FRRDDS29
#define RENESAS_FLXA1FRRDDS30                           FLXA1_FRRDDS30
#define RENESAS_FLXA1FRRDDS31                           FLXA1_FRRDDS31
#define RENESAS_FLXA1FRRDDS32                           FLXA1_FRRDDS32
#define RENESAS_FLXA1FRRDDS33                           FLXA1_FRRDDS33
#define RENESAS_FLXA1FRRDDS34                           FLXA1_FRRDDS34
#define RENESAS_FLXA1FRRDDS35                           FLXA1_FRRDDS35
#define RENESAS_FLXA1FRRDDS36                           FLXA1_FRRDDS36
#define RENESAS_FLXA1FRRDDS37                           FLXA1_FRRDDS37
#define RENESAS_FLXA1FRRDDS38                           FLXA1_FRRDDS38
#define RENESAS_FLXA1FRRDDS39                           FLXA1_FRRDDS39
#define RENESAS_FLXA1FRRDDS40                           FLXA1_FRRDDS40
#define RENESAS_FLXA1FRRDDS41                           FLXA1_FRRDDS41
#define RENESAS_FLXA1FRRDDS42                           FLXA1_FRRDDS42
#define RENESAS_FLXA1FRRDDS43                           FLXA1_FRRDDS43
#define RENESAS_FLXA1FRRDDS44                           FLXA1_FRRDDS44
#define RENESAS_FLXA1FRRDDS45                           FLXA1_FRRDDS45
#define RENESAS_FLXA1FRRDDS46                           FLXA1_FRRDDS46
#define RENESAS_FLXA1FRRDDS47                           FLXA1_FRRDDS47
#define RENESAS_FLXA1FRRDDS48                           FLXA1_FRRDDS48
#define RENESAS_FLXA1FRRDDS49                           FLXA1_FRRDDS49
#define RENESAS_FLXA1FRRDDS50                           FLXA1_FRRDDS50
#define RENESAS_FLXA1FRRDDS51                           FLXA1_FRRDDS51
#define RENESAS_FLXA1FRRDDS52                           FLXA1_FRRDDS52
#define RENESAS_FLXA1FRRDDS53                           FLXA1_FRRDDS53
#define RENESAS_FLXA1FRRDDS54                           FLXA1_FRRDDS54
#define RENESAS_FLXA1FRRDDS55                           FLXA1_FRRDDS55
#define RENESAS_FLXA1FRRDDS56                           FLXA1_FRRDDS56
#define RENESAS_FLXA1FRRDDS57                           FLXA1_FRRDDS57
#define RENESAS_FLXA1FRRDDS58                           FLXA1_FRRDDS58
#define RENESAS_FLXA1FRRDDS59                           FLXA1_FRRDDS59
#define RENESAS_FLXA1FRRDDS60                           FLXA1_FRRDDS60
#define RENESAS_FLXA1FRRDDS61                           FLXA1_FRRDDS61
#define RENESAS_FLXA1FRRDDS62                           FLXA1_FRRDDS62
#define RENESAS_FLXA1FRRDDS63                           FLXA1_FRRDDS63
#define RENESAS_FLXA1FRRDDS64                           FLXA1_FRRDDS64
#define RENESAS_FLXA1FRRDHS1                            FLXA1_FRRDHS1
#define RENESAS_FLXA1FRRDHS2                            FLXA1_FRRDHS2
#define RENESAS_FLXA1FRMBS                              FLXA1_FRMBS
#define RENESAS_FLXA1FROBCM                             FLXA1_FROBCM
#define RENESAS_FLXA1FROBCR                             FLXA1_FROBCR
#define RENESAS_FLXA1FRITC                              FLXA1_FRITC
#define RENESAS_FLXA1FROTC                              FLXA1_FROTC
#define RENESAS_FLXA1FRAES                              FLXA1_FRAES
#define RENESAS_FLXA1FRIQC                              FLXA1_FRIQC
#define RENESAS_FLXA1FRITS                              FLXA1_FRITS

#define RENESAS_FLXA1FROTS                              FLXA1_FROTS
#define RENESAS_FLXA1FRUIR                              FLXA1_FRUIR
#define RENESAS_FLXA1FRUOR                              FLXA1_FRUOR
#define RENESAS_FLXA1FRT2C                              FLXA1_FRT2C

/*******************************************************************************
**                 Macros for ETH  Driver                                     **
*******************************************************************************/
/* U2A add start */
#define RENESAS_ETNB0CCC                                ETNB0_CCC
#define RENESAS_ETNB0ICDATA                             INTC2_EIC645
#define RENESAS_ETNB0ICERR                              INTC2_EIC646
#define RENESAS_ETNB0ICMNG                              INTC2_EIC647
#define RENESAS_ETNB0ICMACA                             INTC2_EIC648
#define RENESAS_ETNB1CCC                                ETNB1_CCC
#define RENESAS_ETNB1ICDATA                             INTC2_EIC649
#define RENESAS_ETNB1ICERR                              INTC2_EIC650
#define RENESAS_ETNB1ICMNG                              INTC2_EIC651
#define RENESAS_ETNB1ICMACA                             INTC2_EIC652
#define RENESAS_ETNB1ICSTA                              INTC2_EIC653
/* U2A add end */

/*******************************************************************************
**                      Function Prototypes                                   **
*******************************************************************************/

/*******************************************************************************
**                          End Of File                                       **
*******************************************************************************/
