#ifndef CAN_CH0_CAN_COMMUNICATION_MATRIX_H_
#define CAN_CH0_CAN_COMMUNICATION_MATRIX_H_

#include "TYW_stdint.h"
#include "CAN_Lib.h"

extern st_CanMsgOp CAN_CH0_CanMsgOp;

extern st_CanMsgTxOp CAN_CH0_CanMsgTxOp;

typedef enum
{
    CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count,
    CAN_CH0_ID_ID_ACC_XVV_IHM_ETAT_Msg_Count,
    CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count,
    CAN_CH0_ID_ID_ACK_EXPORT_AUDIO_Msg_Count,
    CAN_CH0_ID_ID_ACK_EXPORT_NAV_Msg_Count,
    CAN_CH0_ID_ID_BSI_CDE_PTR_MESSAGE_Msg_Count,
    CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count,
    CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count,
    CAN_CH0_ID_ID_CDE_PACK_DYN_Msg_Count,
    CAN_CH0_ID_ID_ACK_EVT_DEF_Msg_Count,
    CAN_CH0_ID_ID_CDE_PACK_DYN_2_Msg_Count,
    CAN_CH0_ID_ID_CDE_PRECOND_ET_XVV_Msg_Count,
    CAN_CH0_ID_ID_COMMANDES_BSI_Msg_Count,
    CAN_CH0_ID_ID_DIAG_UDS_ON_CAN_Msg_Count,
    CAN_CH0_ID_ID_DMD_MAJ_DATE_HEURE_Msg_Count,
    CAN_CH0_ID_ID_DONNEES_AAS_Msg_Count,
    CAN_CH0_ID_ID_ETAT_ARTIV_ET_HY_Msg_Count,
    CAN_CH0_ID_ID_ETAT_PRECOND_ET_XVV_Msg_Count,
    CAN_CH0_ID_ID_DONNEES_BSI_LENTES_3_Msg_Count,
    CAN_CH0_ID_ID_DONNEES_BSI_RAPIDES_Msg_Count,
    CAN_CH0_ID_ID_TCFG_DMD_Msg_Count,
    CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count,
    CAN_CH0_ID_ID_DONNEES_BSI_LENTES_Msg_Count,
    CAN_CH0_ID_ID_DONNEES_BSI_LENTES_2_Msg_Count,
    CAN_CH0_ID_ID_DONNEES_ETAT_ROUES_Msg_Count,
    CAN_CH0_ID_ID_ETAT_BSI_TEMP_NIVEAU_Msg_Count,
    CAN_CH0_ID_ID_ETAT_COMBINE_Msg_Count,
    CAN_CH0_ID_ID_ETAT_VTH_Msg_Count,
    CAN_CH0_ID_ID_EVT_DEFAUT_MATT_Msg_Count,
    CAN_CH0_ID_ID_EXPORT_AUDIO_CF_Msg_Count,
    CAN_CH0_ID_ID_EXPORT_AUDIO_FC_Msg_Count,
    CAN_CH0_ID_ID_EXPORT_NAV_CF_Msg_Count,
    CAN_CH0_ID_ID_EXPORT_NAV_FC_Msg_Count,
    CAN_CH0_ID_ID_GESTION_VITESSE_Msg_Count,
    CAN_CH0_ID_ID_INFOS_GEN_ODB_Msg_Count,
    CAN_CH0_ID_ID_INFOS_HYBRIDE_Msg_Count,
    CAN_CH0_ID_ID_INFOS_MAINTENANCE_EV_Msg_Count,
    CAN_CH0_ID_ID_INFOS_STT_ET_HY_Msg_Count,
    CAN_CH0_ID_ID_INFOS_TRAJET1_ODB_Msg_Count,
    CAN_CH0_ID_ID_INFOS_TRAJET2_ODB_Msg_Count,
    CAN_CH0_ID_ID_INFO_NAV_Msg_Count,
    CAN_CH0_ID_ID_INFO_NAV_2_Msg_Count,
    CAN_CH0_ID_ID_REP_DIAG_MATT_Msg_Count,
    CAN_CH0_ID_ID_REQ_DIAG_MATT_Msg_Count,
    CAN_CH0_ID_ID_SUPERVISION_MATT_Msg_Count,
    CAN_CH0_ID_ID_VERSION_MATT_Msg_Count,
    CAN_CH0_ID_ID_VMF_DSGN_Msg_Count,
    CAN_CH0_ID_ID_CDE_LED_PUSH_Msg_Count,
    CAN_CH0_ID_ID_CMB_CFG_VOY_Msg_Count,
    CAN_CH0_ID_ID_EVT_DEFAUT_CMB_Msg_Count,
    CAN_CH0_ID_ID_IS_DAT_ABR_Msg_Count,
    CAN_CH0_ID_ID_KM_SAUV_CMB_Msg_Count,
    CAN_CH0_ID_ID_REP_DIAG_CMB_Msg_Count,
    CAN_CH0_ID_ID_REQ_DIAG_CMB_Msg_Count,
    CAN_CH0_ID_ID_SUPERVISION_CMB_Msg_Count,
    CAN_CH0_ID_ID_VERSION_CMB_Msg_Count,
    CAN_CH0_ID_ID_EDR_Msg_Count,
    CAN_CH0_ID_EGS_Msg_Count,
    CAN_CH0_ID_ID_CDE_IHM_CLIM_Msg_Count,
    CAN_CH0_ID_350_Msg_Count,
    CAN_CH0_ID_ID294_REMOTE_ACTION_REP_Msg_Count,
    
    CAN_CH0_ID_TOTAL_MAX,
} CAN_CH0_CAN_MSG_ID_t;

typedef enum
{
    CAN_CH0_MSGID_217,
    CAN_CH0_MSGID_317,
    CAN_CH0_MSGID_31C,
    CAN_CH0_MSGID_257,
    CAN_CH0_MSGID_43C,
    CAN_CH0_MSGID_254,
    CAN_CH0_ID_SEND_TOTAL,

} CAN_CH0_CAN_MSG_SEND_ID_t;

extern const st_CANMsgAttribute CAN_CH0_CAN_MSG_CONST_ARRAY[CAN_CH0_ID_TOTAL_MAX] ;
extern const st_CAN_SendAttribute    CAN_CH0_CANSendAttr[CAN_CH0_ID_SEND_TOTAL] ;

#define  CAN_CH0_ID_ID_BSI_INF_CFG_Msg              0x361ul
#define  CAN_CH0_ID_ID_ACC_XVV_IHM_ETAT_Msg         0x228ul
#define  CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg          0x260ul
#define  CAN_CH0_ID_ID_ACK_EXPORT_AUDIO_Msg         0x39Cul
#define  CAN_CH0_ID_ID_ACK_EXPORT_NAV_Msg           0x3E9ul
#define  CAN_CH0_ID_ID_BSI_CDE_PTR_MESSAGE_Msg      0x1A1ul
#define  CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg    0x128ul
#define  CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg      0x168ul
#define  CAN_CH0_ID_ID_CDE_PACK_DYN_Msg             0x0E8ul
#define  CAN_CH0_ID_ID_ACK_EVT_DEF_Msg              0x476ul
#define  CAN_CH0_ID_ID_CDE_PACK_DYN_2_Msg           0x0A8ul
#define  CAN_CH0_ID_ID_CDE_PRECOND_ET_XVV_Msg       0x01Cul
#define  CAN_CH0_ID_ID_COMMANDES_BSI_Msg            0x036ul
#define  CAN_CH0_ID_ID_DIAG_UDS_ON_CAN_Msg          0x7FFul
#define  CAN_CH0_ID_ID_DMD_MAJ_DATE_HEURE_Msg       0x39Bul
#define  CAN_CH0_ID_ID_DONNEES_AAS_Msg              0x0E1ul
#define  CAN_CH0_ID_ID_ETAT_ARTIV_ET_HY_Msg         0x1E7ul
#define  CAN_CH0_ID_ID_ETAT_PRECOND_ET_XVV_Msg      0x1E8ul
#define  CAN_CH0_ID_ID_DONNEES_BSI_LENTES_3_Msg     0x276ul
#define  CAN_CH0_ID_ID_DONNEES_BSI_RAPIDES_Msg      0x0B6ul
#define  CAN_CH0_ID_ID_TCFG_DMD_Msg                 0x2A0ul
#define  CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg       0x15Bul
#define  CAN_CH0_ID_ID_DONNEES_BSI_LENTES_Msg       0x0F6ul
#define  CAN_CH0_ID_ID_DONNEES_BSI_LENTES_2_Msg     0x236ul
#define  CAN_CH0_ID_ID_DONNEES_ETAT_ROUES_Msg       0x1E1ul
#define  CAN_CH0_ID_ID_ETAT_BSI_TEMP_NIVEAU_Msg     0x161ul
#define  CAN_CH0_ID_ID_ETAT_COMBINE_Msg             0x217ul
#define  CAN_CH0_ID_ID_ETAT_VTH_Msg                 0x297ul
#define  CAN_CH0_ID_ID_EVT_DEFAUT_MATT_Msg          0x4B2ul
#define  CAN_CH0_ID_ID_EXPORT_AUDIO_CF_Msg          0x328ul
#define  CAN_CH0_ID_ID_EXPORT_AUDIO_FC_Msg          0x2DCul
#define  CAN_CH0_ID_ID_EXPORT_NAV_CF_Msg            0x229ul
#define  CAN_CH0_ID_ID_EXPORT_NAV_FC_Msg            0x269ul
#define  CAN_CH0_ID_ID_GESTION_VITESSE_Msg          0x1A8ul
#define  CAN_CH0_ID_ID_INFOS_GEN_ODB_Msg            0x221ul
#define  CAN_CH0_ID_ID_INFOS_HYBRIDE_Msg            0x3E0ul
#define  CAN_CH0_ID_ID_INFOS_MAINTENANCE_EV_Msg     0x3E7ul
#define  CAN_CH0_ID_ID_INFOS_STT_ET_HY_Msg          0x3E1ul
#define  CAN_CH0_ID_ID_INFOS_TRAJET1_ODB_Msg        0x2A1ul
#define  CAN_CH0_ID_ID_INFOS_TRAJET2_ODB_Msg        0x261ul
#define  CAN_CH0_ID_ID_INFO_NAV_Msg                 0x169ul
#define  CAN_CH0_ID_ID_INFO_NAV_2_Msg               0x1E9ul
#define  CAN_CH0_ID_ID_REP_DIAG_MATT_Msg            0x672ul
#define  CAN_CH0_ID_ID_REQ_DIAG_MATT_Msg            0x772ul
#define  CAN_CH0_ID_ID_SUPERVISION_MATT_Msg         0x532ul
#define  CAN_CH0_ID_ID_VERSION_MATT_Msg             0x5F2ul
#define  CAN_CH0_ID_ID_VMF_DSGN_Msg                 0x0A2ul
#define  CAN_CH0_ID_ID_CDE_LED_PUSH_Msg             0x227ul
#define  CAN_CH0_ID_ID_CMB_CFG_VOY_Msg              0x317ul
#define  CAN_CH0_ID_ID_EVT_DEFAUT_CMB_Msg           0x49Ful
#define  CAN_CH0_ID_ID_IS_DAT_ABR_Msg               0x0E6ul
#define  CAN_CH0_ID_ID_KM_SAUV_CMB_Msg              0x257ul
#define  CAN_CH0_ID_ID_REP_DIAG_CMB_Msg             0x65Ful
#define  CAN_CH0_ID_ID_REQ_DIAG_CMB_Msg             0x75Ful
#define  CAN_CH0_ID_ID_SUPERVISION_CMB_Msg          0x51Ful
#define  CAN_CH0_ID_ID_VERSION_CMB_Msg              0x5DFul
#define  CAN_CH0_ID_ID_EDR_Msg                      0x5E0ul
#define  CAN_CH0_ID_EGS_Msg                         0x137ul
#define  CAN_CH0_ID_ID_CDE_IHM_CLIM_Msg             0x2ADul
#define  CAN_CH0_ID_350_Msg                         0x350ul
#define  CAN_CH0_ID_ID294_REMOTE_ACTION_REP_Msg     0x294ul

extern uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_DSG_IND(void);
extern uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_IRC(void);
extern uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_DSG(void);
extern uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_XVV(void);
extern uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_TCFG(void);
extern uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_SER_FSE_AUTO(void);
extern uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_HARMONIE_SON(void);
extern uint8_t  Get_CAN_CH0_ID_361_Sig_AAS_INHIB(void);
extern uint8_t  Get_CAN_CH0_ID_361_Sig_ESSUI_MAR(void);
extern uint8_t  Get_CAN_CH0_ID_361_Sig_FOLLOW(void);
extern uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_ACCUEIL(void);
extern uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_MOT_VOL(void);
extern uint8_t  Get_CAN_CH0_ID_361_Sig_SELEC_OUV_AR(void);
extern uint8_t  Get_CAN_CH0_ID_361_Sig_SELEC_OUV_CLE(void);
extern uint8_t  Get_CAN_CH0_ID_361_Sig_SELEC_OUV_CAB(void);
extern uint8_t  Get_CAN_CH0_ID_361_Sig_DISPO_INFO_MENU(void);
extern uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_AUTOROUTE(void);
extern uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_ECL_DECONDA(void);
extern uint8_t  Get_CAN_CH0_ID_361_Sig_ECL_ADAPT_O(void);
extern uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_SAM(void);
extern uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_AMBIANCE(void);
extern uint8_t  Get_CAN_CH0_ID_361_Sig_PHARE_AUTO(void);
extern uint8_t  Get_CAN_CH0_ID_361_Sig_FEUX_DIURN_O(void);
extern uint8_t  Get_CAN_CH0_ID_228_Sig_TENT_ACT_LVV_RVV(void);
extern uint8_t  Get_CAN_CH0_ID_228_Sig_XVV_DISPONIBLE(void);
extern uint8_t  Get_CAN_CH0_ID_228_Sig_XVV_REGL_CONS_VIT(void);
extern uint16_t Get_CAN_CH0_ID_228_Sig_VIT_CONS_LVV_RVV(void);
extern uint8_t  Get_CAN_CH0_ID_228_Sig_ETAT_FONCT_LVV_RVV(void);
extern uint8_t  Get_CAN_CH0_ID_228_Sig_FONCT_ACT_LVV_RVV(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_REINIT_DSG_STATUS(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_AAS_STATUS(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_SAM_STATUS(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_ESSUI_VIT_MAR(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_FCT_MOT_VOL_AR(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_FCT_TCFG(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_ECLAIRAGE_ACCOM(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_TEMPO_EXT_PHARE(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_ECL_AUTOROUTE(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_ECL_DECONDA(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_TEMPO_ECL_DECONDA(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_ECLAIRAGE_AUTO(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_SER_FSE_AUTO(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_SELEC_OUV_PLIP(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_SELEC_CABINE(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_SELEC_ARRIERE(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_ACCUEIL_COND(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_ECL_ADAPT(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_FCT_FEUX_DIURN_O(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_ECLAI_AMBI(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_UNITE_VOLUME(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_UNITE_TEMPERATURE(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_DISPO_PARAM(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_HARMONIE_SON(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_DISPO_UNITES_LANGUE(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_LANGUE_VHL(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_UNITE_DISTANCE(void);
extern uint8_t  Get_CAN_CH0_ID_260_Sig_UNITE_CONSO(void);
extern uint8_t  Get_CAN_CH0_ID_39C_Sig_ACK_SEGMENTATION(void);
extern uint8_t  Get_CAN_CH0_ID_3E9_Sig_ACK_SEGMENTATION(void);
extern uint16_t Get_CAN_CH0_ID_1A1_Sig_PARAM_PTR(void);
extern uint8_t  Get_CAN_CH0_ID_1A1_Sig_MEDIA1(void);
extern uint8_t  Get_CAN_CH0_ID_1A1_Sig_INTERD_PHASE_DEM(void);
extern uint8_t  Get_CAN_CH0_ID_1A1_Sig_CHECK_COURS(void);
extern uint8_t  Get_CAN_CH0_ID_1A1_Sig_PRIORITE(void);
extern uint16_t Get_CAN_CH0_ID_1A1_Sig_POINT_MESS(void);
extern uint8_t  Get_CAN_CH0_ID_1A1_Sig_NOUV_MESS(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_PIED_EMBR(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_MINC_CLIG(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_READY_HY(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_OUCARG_CLIG(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_OUCARM(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_OUCARM_CLIG(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_OUCARD(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_OUCARD_CLIG(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_ON_CMB(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_MINC(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_OUCC(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_OUCC_CLIG(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_OUCP(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_OUCP_CLIG(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_DMD_ALLUM_SCR(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_OUCARG(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_PRE_CHAUFF(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_OUVRANT_OUVERT(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_ESPI(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_ESPACT(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_SERVICE(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_STOP(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_ABPI(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_PIED_FREIN(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_FRPK(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_FSE_INHIB(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_FEUX_POS(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_FEUX_CROIS(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_FEUX_ROUTE(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_FEUX_ABAV(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_FEUX_ABAR(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_CLIGNO_D(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_CLIGNO_G(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_TYPE_ALLUM_FLECHE(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_MODE_BVA_BVMP(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_ALLUM_FLECHE(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_SEL_BVA_BVM_BVMP(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_RAP_AFF_CMB(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_RAP_AFF_DRIVE(void);
extern uint8_t  Get_CAN_CH0_ID_128_Sig_AFF_RAP_CLIGN(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_ASS_DIR_DEF(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_DMD_ALLUMAGE_FA(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_DA_DEF_1(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_UB_DA_DEF_1(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_DA_DEF_2(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_UB_DA_DEF_2(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_CODE_VIR_DEF(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_SEC_PASS_DEF(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_DMD_ALLUM_STT(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_FSE_SYST_DEF(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_FSE_SER_DEF(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_ABS_DEF(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_ASR_DEF(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_BV_DEF(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_EOBD_DEF(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_REF_DEF(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_CBAT_DEF(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_GENE_DEF(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_SOUG_AL(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_POLL_DEF(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_ESSUI_AUTO(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_VOY_PLUS_START(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_ALERTE_T_EAU(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_PHUI_AL(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_NIVL_AL(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_DSG_DEF(void);
extern uint8_t  Get_CAN_CH0_ID_168_Sig_NIVH_AL(void);
extern uint16_t Get_CAN_CH0_ID_0E8_Sig_GMP_TORQUE_INST(void);
extern uint8_t  Get_CAN_CH0_ID_0E8_Sig_GMP_TORQUE_PCT(void);
extern uint8_t  Get_CAN_CH0_ID_0E8_Sig_GMP_BOOST_PCT(void);
extern uint8_t  Get_CAN_CH0_ID_0E8_Sig_GMP_BOOST_INST(void);
extern uint16_t Get_CAN_CH0_ID_0E8_Sig_GMP_POWER_INST(void);
extern uint8_t  Get_CAN_CH0_ID_0E8_Sig_GMP_POWER_PCT(void);
extern uint8_t  Get_CAN_CH0_ID_476_Sig_REP_UCE(void);
extern uint8_t  Get_CAN_CH0_ID_0A8_Sig_GMP_ACCEL_LONG_INST(void);
extern uint8_t  Get_CAN_CH0_ID_0A8_Sig_GMP_ACCEL_LAT_PCT(void);
extern uint8_t  Get_CAN_CH0_ID_0A8_Sig_GMP_ACCEL_LONG_PCT(void);
extern uint8_t  Get_CAN_CH0_ID_0A8_Sig_GMP_DMD_PG_TELE(void);
extern uint8_t  Get_CAN_CH0_ID_0A8_Sig_GMP_ACCEL_LAT_INST(void);
extern uint8_t  Get_CAN_CH0_ID_01C_Sig_VITESSE_5(void);
extern uint8_t  Get_CAN_CH0_ID_01C_Sig_VITESSE_4(void);
extern uint8_t  Get_CAN_CH0_ID_01C_Sig_VITESSE_3(void);
extern uint8_t  Get_CAN_CH0_ID_01C_Sig_VITESSE_2(void);
extern uint8_t  Get_CAN_CH0_ID_01C_Sig_VITESSE_1(void);
extern uint8_t  Get_CAN_CH0_ID_01C_Sig_DISPO_INFO_XVV(void);
extern uint8_t  Get_CAN_CH0_ID_01C_Sig_MENU_XVV(void);
extern uint8_t  Get_CAN_CH0_ID_01C_Sig_BUTEE_1(void);
extern uint8_t  Get_CAN_CH0_ID_01C_Sig_BUTEE_2(void);
extern uint8_t  Get_CAN_CH0_ID_01C_Sig_BUTEE_3(void);
extern uint8_t  Get_CAN_CH0_ID_01C_Sig_BUTEE_4(void);
extern uint8_t  Get_CAN_CH0_ID_01C_Sig_BUTEE_5(void);
extern uint16_t Get_CAN_CH0_ID_01C_Sig_SEL_HOR_PRECOND(void);
extern uint8_t  Get_CAN_CH0_ID_01C_Sig_DISPO_PRECOND(void);
extern uint8_t  Get_CAN_CH0_ID_01C_Sig_DMD_TYPE_PRECOND(void);
extern uint8_t  Get_CAN_CH0_ID_01C_Sig_DMD_ACTIV_PRECOND(void);
extern uint8_t  Get_CAN_CH0_ID_036_Sig_RESYNC(void);
extern uint8_t  Get_CAN_CH0_ID_036_Sig_SECU_ETAT_SEV(void);
extern uint8_t  Get_CAN_CH0_ID_036_Sig_PRES_MENU_PRECOND(void);
extern uint8_t  Get_CAN_CH0_ID_036_Sig_MODE_HY(void);
extern uint8_t  Get_CAN_CH0_ID_036_Sig_DEM_EFFAC_DEF(void);
extern uint8_t  Get_CAN_CH0_ID_036_Sig_DIAG_MUX_ON(void);
extern uint8_t  Get_CAN_CH0_ID_036_Sig_INTERD_MEMO_DEF(void);
extern uint8_t  Get_CAN_CH0_ID_036_Sig_PHASE_VIE(void);
extern uint8_t  Get_CAN_CH0_ID_036_Sig_TYPE_RHEOS(void);
extern uint8_t  Get_CAN_CH0_ID_036_Sig_ETAT_JN(void);
extern uint8_t  Get_CAN_CH0_ID_036_Sig_BCK_PNL(void);
extern uint8_t  Get_CAN_CH0_ID_036_Sig_LUMINOSITE(void);
extern uint64_t Get_CAN_CH0_ID_7FF_Sig_BLOC_UDS(void);
extern uint8_t  Get_CAN_CH0_ID_39B_Sig_MINUTE_HORLOGE(void);
extern uint8_t  Get_CAN_CH0_ID_39B_Sig_HEURE_HORLOGE(void);
extern uint8_t  Get_CAN_CH0_ID_39B_Sig_JOUR_HORLOGE(void);
extern uint8_t  Get_CAN_CH0_ID_39B_Sig_MOIS_HORLOGE(void);
extern uint8_t  Get_CAN_CH0_ID_39B_Sig_MODE_HEURE_CLIENT(void);
extern uint8_t  Get_CAN_CH0_ID_39B_Sig_ANNEE_HORLOGE(void);
extern uint8_t  Get_CAN_CH0_ID_0E1_Sig_RETOUR_ETAT_SCP(void);
extern uint8_t  Get_CAN_CH0_ID_0E1_Sig_DIST_AVM(void);
extern uint8_t  Get_CAN_CH0_ID_0E1_Sig_DIST_AVD(void);
extern uint8_t  Get_CAN_CH0_ID_0E1_Sig_DMDE_AFFICHAGE(void);
extern uint8_t  Get_CAN_CH0_ID_0E1_Sig_DIST_ARD(void);
extern uint8_t  Get_CAN_CH0_ID_0E1_Sig_DIST_AVG(void);
extern uint8_t  Get_CAN_CH0_ID_0E1_Sig_DIST_ARG(void);
extern uint8_t  Get_CAN_CH0_ID_0E1_Sig_DIST_ARM(void);
extern uint16_t Get_CAN_CH0_ID_1E7_Sig_PUISS_PTRAC(void);
extern uint8_t  Get_CAN_CH0_ID_1E7_Sig_TIV_CIBLE(void);
extern uint8_t  Get_CAN_CH0_ID_1E7_Sig_TIV_CONSIGNE(void);
extern uint8_t  Get_CAN_CH0_ID_1E7_Sig_ETAT_SELEC_ARTIV(void);
extern uint8_t  Get_CAN_CH0_ID_1E7_Sig_ETAT_IHM_ARTIV(void);
extern uint8_t  Get_CAN_CH0_ID_1E7_Sig_ALRT_ARTIV(void);
extern uint8_t  Get_CAN_CH0_ID_1E7_Sig_REGL_ALRT_ARTIV(void);
extern uint8_t  Get_CAN_CH0_ID_1E7_Sig_CIBLE_DETECTEE_ARTIV(void);
extern uint8_t  Get_CAN_CH0_ID_1E8_Sig_VITESSE_5(void);
extern uint8_t  Get_CAN_CH0_ID_1E8_Sig_VITESSE_4(void);
extern uint8_t  Get_CAN_CH0_ID_1E8_Sig_VITESSE_3(void);
extern uint8_t  Get_CAN_CH0_ID_1E8_Sig_VITESSE_2(void);
extern uint8_t  Get_CAN_CH0_ID_1E8_Sig_VITESSE_1(void);
extern uint8_t  Get_CAN_CH0_ID_1E8_Sig_DISPO_INFO_XVV(void);
extern uint8_t  Get_CAN_CH0_ID_1E8_Sig_MENU_XV(void);
extern uint8_t  Get_CAN_CH0_ID_1E8_Sig_DMD_RAPPEL_XVV_PROG(void);
extern uint8_t  Get_CAN_CH0_ID_1E8_Sig_BUTEE_1(void);
extern uint8_t  Get_CAN_CH0_ID_1E8_Sig_BUTEE_2(void);
extern uint8_t  Get_CAN_CH0_ID_1E8_Sig_BUTEE_3(void);
extern uint8_t  Get_CAN_CH0_ID_1E8_Sig_BUTEE_4(void);
extern uint8_t  Get_CAN_CH0_ID_1E8_Sig_BUTEE_5(void);
extern uint16_t Get_CAN_CH0_ID_1E8_Sig_HOR_PRECOND(void);
extern uint8_t  Get_CAN_CH0_ID_1E8_Sig_TYPE_PRECOND(void);
extern uint8_t  Get_CAN_CH0_ID_1E8_Sig_ACTIV_PRECOND(void);
extern uint16_t Get_CAN_CH0_ID_276_Sig_AUTONOMIE_UREE(void);
extern uint8_t  Get_CAN_CH0_ID_276_Sig_MINUTE_HORLOGE(void);
extern uint8_t  Get_CAN_CH0_ID_276_Sig_HEURE_HORLOGE(void);
extern uint8_t  Get_CAN_CH0_ID_276_Sig_JOUR_HORLOGE(void);
extern uint8_t  Get_CAN_CH0_ID_276_Sig_AFFICHAGE_HORLOGE(void);
extern uint8_t  Get_CAN_CH0_ID_276_Sig_MOIS_HORLOGE(void);
extern uint8_t  Get_CAN_CH0_ID_276_Sig_MODE_HEURE_CLIENT(void);
extern uint8_t  Get_CAN_CH0_ID_276_Sig_ANNEE_HORLOGE(void);
extern uint16_t Get_CAN_CH0_ID_0B6_Sig_VITM(void);
extern uint8_t  Get_CAN_CH0_ID_0B6_Sig_SECU_VITESSE(void);
extern uint16_t Get_CAN_CH0_ID_0B6_Sig_VITV(void);
extern uint8_t  Get_CAN_CH0_ID_2A0_Sig_DMD_PROG_TCFG(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_DMD_INIT_DSG(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_AAS_STATUS(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_SAM_STATUS(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_ESSUI_VIT_MAR(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_FCT_MOT_VOL_AR(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_FCT_TCFG(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_ECLAIRAGE_ACCOM(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_TEMPO_EXT_PHARE(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_ECL_AUTOROUTE(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_ECL_DECONDA(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_TEMPO_ECL_DECONDA(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_ECLAIRAGE_AUTO(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_SER_FSE_AUTO(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_SELEC_OUV_PLIP(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_SELEC_CABINE(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_SELEC_ARRIERE(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_ACCUEIL_COND(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_ECL_ADAPT(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_FCT_FEUX_DIURN_O(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_ECLAI_AMBI(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_UNITE_VOLUME(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_UNITE_TEMPERATURE(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_DISPO_PARAM(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_HARMONIE_SON(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_DISPO_UNITES_LANGUE(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_LANGUE_VHL(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_UNITE_DISTANCE(void);
extern uint8_t  Get_CAN_CH0_ID_15B_Sig_UNITE_CONSO(void);
extern uint8_t  Get_CAN_CH0_ID_0F6_Sig_TEAU(void);
extern uint8_t  Get_CAN_CH0_ID_0F6_Sig_T_EXT_FILT(void);
extern uint32_t Get_CAN_CH0_ID_0F6_Sig_KM_TOTAL(void);
extern uint8_t  Get_CAN_CH0_ID_0F6_Sig_ETAT_PRINCIP_SEV(void);
extern uint8_t  Get_CAN_CH0_ID_0F6_Sig_ETAT_GMP(void);
extern uint8_t  Get_CAN_CH0_ID_236_Sig_COMPTEUR_RAZ_GCT(void);
extern uint8_t  Get_CAN_CH0_ID_236_Sig_CTX_JDD(void);
extern uint32_t Get_CAN_CH0_ID_236_Sig_CPT_TEMPOREL(void);
extern uint8_t  Get_CAN_CH0_ID_236_Sig_ETAT_RESEAU_ELEC(void);
extern uint8_t  Get_CAN_CH0_ID_236_Sig_MODE_CONFIG_VHL(void);
extern uint8_t  Get_CAN_CH0_ID_1E1_Sig_ETAT_ROUE_ARD(void);
extern uint8_t  Get_CAN_CH0_ID_1E1_Sig_ETAT_DSG_GENERAL(void);
extern uint8_t  Get_CAN_CH0_ID_1E1_Sig_ETAT_ROUE_ARG(void);
extern uint8_t  Get_CAN_CH0_ID_1E1_Sig_ETAT_ROUE_AVD(void);
extern uint8_t  Get_CAN_CH0_ID_1E1_Sig_ETAT_ROUE_AVG(void);
extern uint8_t  Get_CAN_CH0_ID_161_Sig_NIV_CRB(void);
extern uint8_t  Get_CAN_CH0_ID_161_Sig_NIV_HUILE(void);
extern uint8_t  Get_CAN_CH0_ID_161_Sig_T_HUILE(void);
extern uint8_t  Get_CAN_CH0_ID_217_Sig_SIGNAL_DEF_AIRBAG(void);
extern uint8_t  Get_CAN_CH0_ID_217_Sig_ENT_PUSH_DYN(void);
extern uint8_t  Get_CAN_CH0_ID_217_Sig_DEFAUT_AFFICHEUR(void);
extern uint8_t  Get_CAN_CH0_ID_217_Sig_DMD_CHGMT_ETAT_SCP(void);
extern uint8_t  Get_CAN_CH0_ID_217_Sig_ENT_PUSH_DSGI(void);
extern uint8_t  Get_CAN_CH0_ID_217_Sig_ENT_PUSH_AAS(void);
extern uint8_t  Get_CAN_CH0_ID_217_Sig_ENT_PUSH_ESP(void);
extern uint8_t  Get_CAN_CH0_ID_217_Sig_RAZ_ODO_PARTIEL(void);
extern uint8_t  Get_CAN_CH0_ID_217_Sig_NIV_LUM(void);
extern uint8_t  Get_CAN_CH0_ID_217_Sig_RAZM(void);
extern uint8_t  Get_CAN_CH0_ID_217_Sig_IHM_INHIB(void);
extern uint8_t  Get_CAN_CH0_ID_217_Sig_VITESSE_AFF_CMB(void);
extern uint8_t  Get_CAN_CH0_ID_217_Sig_DMD_RAZM_MATT(void);
extern uint8_t  Get_CAN_CH0_ID_217_Sig_DMD_CHECK_MAT(void);
extern uint8_t  Get_CAN_CH0_ID_217_Sig_ENT_PUSH_ODO_FILTRE(void);
extern uint8_t  Get_CAN_CH0_ID_217_Sig_UNIT_DIST_CMB(void);
extern uint8_t  Get_CAN_CH0_ID_297_Sig_ACTIV_VTH(void);
extern uint64_t Get_CAN_CH0_ID_4B2_Sig_BLOC_DIAG(void);
extern uint8_t  Get_CAN_CH0_ID_4B2_Sig_NB_TRAME(void);
extern uint8_t  Get_CAN_CH0_ID_4B2_Sig_NUM_TRAME(void);
extern uint64_t Get_CAN_CH0_ID_328_Sig_DATA_CF_EXPORT_AUDIO(void);
extern uint8_t  Get_CAN_CH0_ID_328_Sig_NPCI_HEADER(void);
extern uint8_t  Get_CAN_CH0_ID_328_Sig_SN(void);
extern uint8_t  Get_CAN_CH0_ID_2DC_Sig_STMIN(void);
extern uint8_t  Get_CAN_CH0_ID_2DC_Sig_BS(void);
extern uint8_t  Get_CAN_CH0_ID_2DC_Sig_NPCI_HEADER(void);
extern uint8_t  Get_CAN_CH0_ID_2DC_Sig_FS(void);
extern uint64_t Get_CAN_CH0_ID_229_Sig_DATA_CF_EXPORT_NAV(void);
extern uint8_t  Get_CAN_CH0_ID_229_Sig_NPCI_HEADER(void);
extern uint8_t  Get_CAN_CH0_ID_229_Sig_SN(void);
extern uint8_t  Get_CAN_CH0_ID_269_Sig_STMIN(void);
extern uint8_t  Get_CAN_CH0_ID_269_Sig_BS(void);
extern uint8_t  Get_CAN_CH0_ID_269_Sig_NPCI_HEADER(void);
extern uint8_t  Get_CAN_CH0_ID_269_Sig_FS(void);
extern uint32_t Get_CAN_CH0_ID_1A8_Sig_ODO_PARTIEL(void);
extern uint16_t Get_CAN_CH0_ID_1A8_Sig_XVV_BUTEE_SUP(void);
extern uint16_t Get_CAN_CH0_ID_1A8_Sig_XVV_BUTEE_INF(void);
extern uint8_t  Get_CAN_CH0_ID_1A8_Sig_XVV_PREPROG_ACTIF(void);
extern uint8_t  Get_CAN_CH0_ID_1A8_Sig_XVV_BUTEE_ATTEINTE(void);
extern uint16_t Get_CAN_CH0_ID_221_Sig_AUTONOMIE(void);
extern uint16_t Get_CAN_CH0_ID_221_Sig_CONSO_INSTANTANEE(void);
extern uint8_t  Get_CAN_CH0_ID_221_Sig_CONSO_ODB(void);
extern uint8_t  Get_CAN_CH0_ID_221_Sig_AUTON_ODB(void);
extern uint8_t  Get_CAN_CH0_ID_221_Sig_POUSSOIR_ODB(void);
extern uint8_t  Get_CAN_CH0_ID_3E0_Sig_SOC_BATT(void);
extern uint8_t  Get_CAN_CH0_ID_3E7_Sig_AFF_MAINT(void);
extern uint16_t Get_CAN_CH0_ID_3E7_Sig_K_MAINT(void);
extern uint16_t Get_CAN_CH0_ID_3E7_Sig_NB_JOUR_MAINTENANCE(void);
extern uint8_t  Get_CAN_CH0_ID_3E7_Sig_PICTO_CLE(void);
extern uint8_t  Get_CAN_CH0_ID_3E7_Sig_SIGN_MAINT(void);
extern uint8_t  Get_CAN_CH0_ID_3E7_Sig_SIGN_ECHEANCE(void);
extern uint8_t  Get_CAN_CH0_ID_3E1_Sig_RECHARGE(void);
extern uint8_t  Get_CAN_CH0_ID_3E1_Sig_DISPO_FCT_STT_HY(void);
extern uint8_t  Get_CAN_CH0_ID_3E1_Sig_DMD_ZERO_EMISSION(void);
extern uint8_t  Get_CAN_CH0_ID_3E1_Sig_ETAT_MTH(void);
extern uint8_t  Get_CAN_CH0_ID_3E1_Sig_ETAT_ME(void);
extern uint8_t  Get_CAN_CH0_ID_3E1_Sig_CPT_STOP_HEURE(void);
extern uint8_t  Get_CAN_CH0_ID_3E1_Sig_CPT_STOP_MINUTE(void);
extern uint16_t Get_CAN_CH0_ID_2A1_Sig_CONSO_TRAJET1(void);
extern uint16_t Get_CAN_CH0_ID_2A1_Sig_DISTANCE_TRAJET1(void);
extern uint8_t  Get_CAN_CH0_ID_2A1_Sig_VITESSE_MOYENNE_T1(void);
extern uint16_t Get_CAN_CH0_ID_261_Sig_CONSO_TRAJET2(void);
extern uint16_t Get_CAN_CH0_ID_261_Sig_DISTANCE_TRAJET2(void);
extern uint8_t  Get_CAN_CH0_ID_261_Sig_VITESSE_MOYENNE_T2(void);
extern uint16_t Get_CAN_CH0_ID_169_Sig_DISTANCE_PRECONS(void);
extern uint8_t  Get_CAN_CH0_ID_169_Sig_ETAT_NAV(void);
extern uint8_t  Get_CAN_CH0_ID_169_Sig_ETAT_CALCUL(void);
extern uint8_t  Get_CAN_CH0_ID_169_Sig_NUM_PICTO_PRECONS(void);
extern uint8_t  Get_CAN_CH0_ID_1E9_Sig_PICTO_POI_RADAR(void);
extern uint8_t  Get_CAN_CH0_ID_1E9_Sig_DISPO_AFF_VIT(void);
extern uint8_t  Get_CAN_CH0_ID_1E9_Sig_VITESSE_CONSEIL(void);
extern uint8_t  Get_CAN_CH0_ID_1E9_Sig_VITESSE_LIMITE(void);
extern uint64_t Get_CAN_CH0_ID_672_Sig_DATA_DIAG(void);
extern uint64_t Get_CAN_CH0_ID_772_Sig_DATA_DIAG(void);
extern uint8_t  Get_CAN_CH0_ID_532_Sig_UCE_ABS_MATT(void);
extern uint8_t  Get_CAN_CH0_ID_532_Sig_C_DEFAUT_PERTE_COM(void);
extern uint8_t  Get_CAN_CH0_ID_532_Sig_C_DEFAUT_BUSOFF(void);
extern uint8_t  Get_CAN_CH0_ID_532_Sig_C_DEFAUT_N_AS(void);
extern uint8_t  Get_CAN_CH0_ID_532_Sig_C_DEFAUT_NERR(void);
extern uint8_t  Get_CAN_CH0_ID_532_Sig_PERTE_COM(void);
extern uint8_t  Get_CAN_CH0_ID_532_Sig_BIT_NERR(void);
extern uint8_t  Get_CAN_CH0_ID_532_Sig_ETAT_NM(void);
extern uint8_t  Get_CAN_CH0_ID_5F2_Sig_NUM_EDITION(void);
extern uint8_t  Get_CAN_CH0_ID_5F2_Sig_DIGIT_1(void);
extern uint16_t Get_CAN_CH0_ID_5F2_Sig_IDENT_LOGIC(void);
extern uint8_t  Get_CAN_CH0_ID_5F2_Sig_VER_LOG_ANNEE(void);
extern uint8_t  Get_CAN_CH0_ID_5F2_Sig_VER_LOG_MOIS(void);
extern uint8_t  Get_CAN_CH0_ID_5F2_Sig_VER_LOG_JOUR(void);
extern uint8_t  Get_CAN_CH0_ID_5F2_Sig_NUM_UCE(void);
extern uint8_t  Get_CAN_CH0_ID_0A2_Sig_OVF_NAV_SUP_ET_CMB(void);
extern uint8_t  Get_CAN_CH0_ID_0A2_Sig_OVF_NAV_INF_ET_CMB(void);
extern uint8_t  Get_CAN_CH0_ID_0A2_Sig_VALID_ET_CMB(void);
extern uint8_t  Get_CAN_CH0_ID_0A2_Sig_ESCAPE_ET_CMB(void);
extern uint8_t  Get_CAN_CH0_ID_0A2_Sig_CMPT_NAV_MENU_CMB(void);
extern uint8_t  Get_CAN_CH0_ID_227_Sig_SORTIE_PUSH_SAM(void);
extern uint8_t  Get_CAN_CH0_ID_227_Sig_SORTIE_LED_DYN(void);
extern uint8_t  Get_CAN_CH0_ID_227_Sig_SORTIE_PUSH_FREIN_SEC_ELE(void);
extern uint8_t  Get_CAN_CH0_ID_227_Sig_SORTIE_PUSH_AAS(void);
extern uint8_t  Get_CAN_CH0_ID_227_Sig_SORTIE_PUSH_ESP(void);
extern uint8_t  Get_CAN_CH0_ID_317_Sig_SEC_PASS_DEF_VOY(void);
extern uint8_t  Get_CAN_CH0_ID_317_Sig_CBAT_DEF_VOY(void);
extern uint8_t  Get_CAN_CH0_ID_317_Sig_ABS_DEF_VOY(void);
extern uint8_t  Get_CAN_CH0_ID_317_Sig_ASR_DEF_VOY(void);
extern uint8_t  Get_CAN_CH0_ID_317_Sig_PLUS_START_VOY(void);
extern uint8_t  Get_CAN_CH0_ID_317_Sig_FSE_SYST_DEF_VOY(void);
extern uint8_t  Get_CAN_CH0_ID_317_Sig_FSE_SER_DEF_VOY(void);
extern uint8_t  Get_CAN_CH0_ID_317_Sig_PIED_FREIN_VOY(void);
extern uint8_t  Get_CAN_CH0_ID_317_Sig_NIVL_VOY(void);
extern uint8_t  Get_CAN_CH0_ID_317_Sig_SOUG_VOY(void);
extern uint8_t  Get_CAN_CH0_ID_317_Sig_REF_DEF_VOY(void);
extern uint8_t  Get_CAN_CH0_ID_317_Sig_PORT_OUV_VOY(void);
extern uint8_t  Get_CAN_CH0_ID_317_Sig_GENE_DEF_VOY(void);
extern uint8_t  Get_CAN_CH0_ID_317_Sig_T_EAU_VOY(void);
extern uint8_t  Get_CAN_CH0_ID_317_Sig_T_HUIL_VOY(void);
extern uint8_t  Get_CAN_CH0_ID_317_Sig_ABPI_VOY(void);
extern uint8_t  Get_CAN_CH0_ID_317_Sig_MINC_VOY(void);
extern uint8_t  Get_CAN_CH0_ID_317_Sig_SERVICE_VOY(void);
extern uint8_t  Get_CAN_CH0_ID_317_Sig_STOP_VOY(void);
extern uint64_t Get_CAN_CH0_ID_49F_Sig_BLOC_DIAG(void);
extern uint8_t  Get_CAN_CH0_ID_49F_Sig_NB_TRAME(void);
extern uint8_t  Get_CAN_CH0_ID_49F_Sig_NUM_TRAME(void);
extern uint8_t  Get_CAN_CH0_ID_0E6_Sig_CPT_PROCESS_4B_UC_FREIN(void);
extern uint8_t  Get_CAN_CH0_ID_0E6_Sig_CHKSUM_TRME_DAT_UC_FREIN(void);
extern uint8_t  Get_CAN_CH0_ID_0E6_Sig_FNCT_SFU_UC_FREIN(void);
extern uint8_t  Get_CAN_CH0_ID_0E6_Sig_DEFAUT_GEE_UCFREIN(void);
extern uint8_t  Get_CAN_CH0_ID_0E6_Sig_BES_FREIN_STT(void);
extern uint8_t  Get_CAN_CH0_ID_0E6_Sig_TENSION_BATTERIE_UCFREIN(void);
extern uint16_t Get_CAN_CH0_ID_0E6_Sig_CPT_TOP_ARD(void);
extern uint8_t  Get_CAN_CH0_ID_0E6_Sig_DEFAUT_CMPT_TOPS_ARD(void);
extern uint16_t Get_CAN_CH0_ID_0E6_Sig_CPT_TOP_ARG(void);
extern uint8_t  Get_CAN_CH0_ID_0E6_Sig_DEFAUT_CMPT_TOPS_ARG(void);
extern uint8_t  Get_CAN_CH0_ID_0E6_Sig_REQ_LAMPE_DEF_REF(void);
extern uint8_t  Get_CAN_CH0_ID_0E6_Sig_REGUL_ABR(void);
extern uint8_t  Get_CAN_CH0_ID_0E6_Sig_FNCT_AAFD_UC_FREIN(void);
extern uint8_t  Get_CAN_CH0_ID_0E6_Sig_REGUL_REF(void);
extern uint8_t  Get_CAN_CH0_ID_0E6_Sig_USURE_PLAQ_FREIN(void);
extern uint8_t  Get_CAN_CH0_ID_0E6_Sig_ALRT_LIQU_FREIN(void);
extern uint8_t  Get_CAN_CH0_ID_0E6_Sig_REQ_LAMPE_DEF_ABR(void);
extern uint32_t Get_CAN_CH0_ID_257_Sig_SECURE(void);
extern uint32_t Get_CAN_CH0_ID_257_Sig_KM_SAUV(void);
extern uint64_t Get_CAN_CH0_ID_65F_Sig_DATA_DIAG(void);
extern uint64_t Get_CAN_CH0_ID_75F_Sig_DATA_DIAG(void);
extern uint8_t  Get_CAN_CH0_ID_51F_Sig_UCE_ABS_CMB_3(void);
extern uint8_t  Get_CAN_CH0_ID_51F_Sig_UCE_ABS_CMB_2(void);
extern uint8_t  Get_CAN_CH0_ID_51F_Sig_UCE_ABS_CMB_1(void);
extern uint8_t  Get_CAN_CH0_ID_51F_Sig_C_DEFAUT_PERTE_COM(void);
extern uint8_t  Get_CAN_CH0_ID_51F_Sig_C_DEFAUT_BUSOFF(void);
extern uint8_t  Get_CAN_CH0_ID_51F_Sig_C_DEFAUT_N_AS(void);
extern uint8_t  Get_CAN_CH0_ID_51F_Sig_C_DEFAUT_NERR(void);
extern uint8_t  Get_CAN_CH0_ID_51F_Sig_PERTE_COM(void);
extern uint8_t  Get_CAN_CH0_ID_51F_Sig_BIT_NERR(void);
extern uint8_t  Get_CAN_CH0_ID_51F_Sig_ETAT_NM(void);
extern uint8_t  Get_CAN_CH0_ID_5DF_Sig_NUM_EDITION(void);
extern uint8_t  Get_CAN_CH0_ID_5DF_Sig_DIGIT_1(void);
extern uint8_t  Get_CAN_CH0_ID_5DF_Sig_DIGIT_2(void);
extern uint16_t Get_CAN_CH0_ID_5DF_Sig_IDENT_LOGIC(void);
extern uint8_t  Get_CAN_CH0_ID_5DF_Sig_VER_LOG_ANNEE(void);
extern uint8_t  Get_CAN_CH0_ID_5DF_Sig_VER_LOG_MOIS(void);
extern uint8_t  Get_CAN_CH0_ID_5DF_Sig_VER_LOG_JOUR(void);
extern uint8_t  Get_CAN_CH0_ID_5DF_Sig_NUM_UCE(void);
extern uint8_t  Get_CAN_CH0_ID_5E0_Sig_EDR_Full(void);
extern uint8_t  Get_CAN_CH0_ID_5E0_Sig_EDR_Fault(void);
extern uint8_t  Get_CAN_CH0_ID_137_Sig_EGS_Fault(void);
extern uint8_t  Get_CAN_CH0_ID_2AD_Sig_EXTINCTION_LCD_CONDA(void);
extern uint8_t  Get_CAN_CH0_ID_350_Sig_DISTRIBUTION_AVG(void);
extern uint8_t  Get_CAN_CH0_ID_350_Sig_DISTRIBUTION_AVD(void);
extern uint8_t  Get_CAN_CH0_ID_350_Sig_ENTREE_AIR(void);
extern uint8_t  Get_CAN_CH0_ID_350_Sig_PULS_AV(void);
extern uint8_t  Get_CAN_CH0_ID_350_Sig_VAL_CONS_TEMP_AVD(void);
extern uint8_t  Get_CAN_CH0_ID_350_Sig_VAL_CONS_TEMP_AVG(void);
extern uint8_t  Get_CAN_CH0_ID_350_Sig_DMD_VISI(void);
extern uint8_t  Get_CAN_CH0_ID_350_Sig_DMD_AC(void);
extern uint8_t  Get_CAN_CH0_ID_350_Sig_TYPAGE(void);
extern uint8_t  Get_CAN_CH0_ID_294_Sig_TURN_LIGHTS_STATUS(void);
extern uint8_t  Get_CAN_CH0_ID_294_Sig_HORN_STATUS(void);
extern uint8_t  Get_CAN_CH0_ID_294_Sig_REMOTE_LOCK_UNLOCK_STAT(void);

extern uint8_t  Co_Can_ConvertSubID_CAN_CH0(uint32_t MsgID);
extern uint8_t  CAN_CH0_SendID_Convert(uint32_t MsgID);
#endif
