#include  "CAN_CH1_CAN_Communication_Matrix.h"
#include "TYW_stdint.h"
#include "CAN_CH1_APP.h"
#include "RTE_CAN.h"
/* 2023/02/14 13:56:02 */
st_CanMsgOp CAN_CH1_CanMsgOp;
st_CanMsgTxOp CAN_CH1_CanMsgTxOp;
#define CAN_CH1 &CAN_CH1_CanMsgOp

const st_CAN_SendAttribute    CAN_CH1_CANSendAttr[CAN_CH1_ID_SEND_TOTAL] =
{
    {0x276ul,  500ul * 1000ul, 0ul, 0u,MSG_STD, 4u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_276, (void *)0u},
    {0x350ul,  500ul * 1000ul, 0ul, 0u,MSG_STD, 6u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_350, (void *)0u},
    {0x190ul,  200ul * 1000ul, 0ul, 0u,MSG_STD, 5u, 5u, CAN_MSG_TX_CYCLE, Can_Set_Buff_190, (void *)0u},
    {0x128ul,  200ul * 1000ul, 0ul, 0u,MSG_STD, 7u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_128, (void *)0u},
    {0x0F6ul,  500ul * 1000ul, 0ul, 0u,MSG_STD, 8u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_0F6, (void *)0u},
    {0x3F1ul,  100ul * 1000ul, 0ul, 0u,MSG_STD, 9u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_3F1, (void *)0u},
    {0x036ul,    0ul * 1000ul, 0ul, 0u,MSG_STD, 10u, 8u, CAN_MSG_TX_CYCKE_EVENT, Can_Set_Buff_036, (void *)0u}, 
    {0x294ul,    0ul * 1000ul, 0ul, 0u,MSG_STD, 11u, 2u, CAN_MSG_TX_CYCKE_EVENT, Can_Set_Buff_294, (void *)0u}, 
};

const st_CANMsgAttribute CAN_CH1_CAN_MSG_CONST_ARRAY[CAN_CH1_ID_TOTAL_MAX] =
{
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x131ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x3F1ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x139ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x153ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x152ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x320ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x24Aul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x211ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x35Aul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x2E1ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x389ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x135ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x366ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x521ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x341ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x431ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x123ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x137ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x190ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x276ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x350ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0xF6ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x128ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x5E0ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
   
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x302ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x442ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x342ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x214ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x222ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x254ul,
        (( void * )0),
        (CAN_CH1_254_Update),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x43Cul,
        (( void * )0),
        (CAN_CH1_43C_Update),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x334ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x306ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x304ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x364ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    
};

uint8_t  Get_CAN_CH1_ID_131_Sig_MCU_FaultLevel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID131_MCU1_Msg_Count, 5u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_131_Sig_MCU_Motorspd_Status(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID131_MCU1_Msg_Count, 5u) >> 0u) & 0x01u));
}

uint16_t Get_CAN_CH1_ID_131_Sig_MCU_Motorspd(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID131_MCU1_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID131_MCU1_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH1_ID_3F1_Sig_DISTANCE_TRAJET2(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID3F1_IC1_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID3F1_IC1_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH1_ID_3F1_Sig_DISTANCE_TRAJET1(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID3F1_IC1_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID3F1_IC1_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH1_ID_3F1_Sig_REO_REGEN_LEVEL(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID3F1_IC1_Msg_Count, 1u) >> 0u) & 0x07u));
}

uint8_t  Get_CAN_CH1_ID_3F1_Sig_Charge_plug_unlock_req(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID3F1_IC1_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_3F1_Sig_ABAV_Req(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID3F1_IC1_Msg_Count, 0u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH1_ID_3F1_Sig_IC_Mileage2restart(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID3F1_IC1_Msg_Count, 0u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH1_ID_3F1_Sig_IC_Mileage1restart(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID3F1_IC1_Msg_Count, 0u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH1_ID_139_Sig_VCM_PowerStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID139_VCM2_Msg_Count, 5u) >> 5u) & 0x07u));
}

uint8_t  Get_CAN_CH1_ID_139_Sig_VCM_FaultLevel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID139_VCM2_Msg_Count, 7u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_139_Sig_VCM_BrakePedalStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID139_VCM2_Msg_Count, 7u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_153_Sig_ChargingStop(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID153_BMS2_Msg_Count, 2u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_153_Sig_BMS_Battery_changeSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID153_BMS2_Msg_Count, 6u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH1_ID_153_Sig_BMS_SWAP_Status(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID153_BMS2_Msg_Count, 3u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_153_Sig_BMS_Thermal_runaway_alarm_Sts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID153_BMS2_Msg_Count, 3u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH1_ID_153_Sig_BMS_StatusTempHigh_Fault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID153_BMS2_Msg_Count, 5u) >> 7u) & 0x01u));
}

uint16_t Get_CAN_CH1_ID_153_Sig_BMS_SOC(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID153_BMS2_Msg_Count, 0u) >> 0u) & 0xFFu) << 2u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID153_BMS2_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_153_Sig_BMS_SOCLow(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID153_BMS2_Msg_Count, 6u) >> 4u) & 0x01u));
}

uint16_t Get_CAN_CH1_ID_152_Sig_BMS_BatteryCurrent(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID152_BMS3_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID152_BMS3_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH1_ID_320_Sig_BMS_DCLinkVoltage(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID320_BMS5_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID320_BMS5_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH1_ID_24A_Sig_BMS_FaultLevel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID24A_BMS6_Msg_Count, 4u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_24A_Sig_BMS_WorkMode(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID24A_BMS6_Msg_Count, 4u) >> 2u) & 0x0Fu));
}

uint8_t  Get_CAN_CH1_ID_211_Sig_VCM_PluginRemind(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID211_VCM5_Msg_Count, 2u) >> 7u) & 0x01u));
}

uint16_t Get_CAN_CH1_ID_211_Sig_VCM_EstimateMileage(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID211_VCM5_Msg_Count, 4u) >> 0u) & 0x03u) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID211_VCM5_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH1_ID_35A_Sig_STATE_ECO_LEVEL(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID35A_VCM9_Msg_Count, 2u) >> 3u) & 0x03u));
}
uint8_t  Get_CAN_CH1_ID_35A_Sig_STATE_REGEN_LEVEL(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID35A_VCM9_Msg_Count, 2u) >> 0u) & 0x07u));
}

uint8_t  Get_CAN_CH1_ID_35A_Sig_VCM_stDrvReqWrgOptInfo(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID35A_VCM9_Msg_Count, 6u) >> 5u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_35A_Sig_VCM_Driving_HillHoldRemind(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID35A_VCM9_Msg_Count, 6u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH1_ID_35A_Sig_VCM_Driving_GearPosRemind(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID35A_VCM9_Msg_Count, 6u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH1_ID_35A_Sig_VCM_Cranking_GearPosRemind(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID35A_VCM9_Msg_Count, 6u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH1_ID_35A_Sig_VCM_HighVolConnect(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID35A_VCM9_Msg_Count, 6u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH1_ID_35A_Sig_VCM_Mileage2Average_EnergyConsum(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID35A_VCM9_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH1_ID_35A_Sig_VCM_Mileage1Average_EnergyConsum(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID35A_VCM9_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH1_ID_35A_Sig_VCM_Instant_EnergyConsum(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID35A_VCM9_Msg_Count, 3u) >> 0u) & 0xFFu) << 2u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID35A_VCM9_Msg_Count, 4u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_35A_Sig_VCM_Average_EnergyConsum(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID35A_VCM9_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH1_ID_2E1_Sig_OBC_FaultLevel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID2E1_OBC2_Msg_Count, 1u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_2E1_Sig_OBC_CCStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID2E1_OBC2_Msg_Count, 1u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_389_Sig_RB_TirePressure(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID389_TPMS_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH1_ID_389_Sig_LB_TirePressure(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID389_TPMS_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH1_ID_389_Sig_RF_TirePressure(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID389_TPMS_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH1_ID_389_Sig_LF_TirePressure(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID389_TPMS_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH1_ID_389_Sig_TirePre_FaultVoice_St(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID389_TPMS_Msg_Count, 2u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH1_ID_389_Sig_TirePre_FaultLight_St(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID389_TPMS_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_389_Sig_RB_TirePressure_Warning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID389_TPMS_Msg_Count, 1u) >> 3u) & 0x07u));
}

uint8_t  Get_CAN_CH1_ID_389_Sig_LB_TirePressure_Warning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID389_TPMS_Msg_Count, 1u) >> 0u) & 0x07u));
}

uint8_t  Get_CAN_CH1_ID_389_Sig_TirePosition(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID389_TPMS_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_389_Sig_RF_TirePressure_Warning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID389_TPMS_Msg_Count, 0u) >> 3u) & 0x07u));
}

uint8_t  Get_CAN_CH1_ID_389_Sig_LF_TirePressure_Warning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID389_TPMS_Msg_Count, 0u) >> 0u) & 0x07u));
}

uint8_t  Get_CAN_CH1_ID_135_Sig_VCM_ShiftLeverPosition(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID135_VCM3_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH1_ID_366_Sig_CHM_AC_SOCRemind(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID366_CHM1_Msg_Count, 2u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_521_Sig_Vehicle_Status(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID521_VCMTBOX1_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH1_ID_341_Sig_BMS_CC2Status(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID341_BMS7_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_431_Sig_VCM_Wakeup_Signal(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID431_VCM_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_123_Sig_VCM_ShiftLeverPosition(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID123_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH1_ID_137_Sig_Fault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID137_EGS_Fault_Msg_Count, 0u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH1_ID_190_Sig_BSI_TEMP_SONDE_EVAPOH(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_Send_190_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH1_ID_190_Sig_BSI_TEMP_SONDE_EVAPOL(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_Send_190_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH1_ID_276_Sig_BSI_ANNEE_HORLOGE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_Send_276_Msg_Count, 0u) >> 0u) & 0x7Fu));
}

uint8_t  Get_CAN_CH1_ID_350_Sig_BSI_TYPAGE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_Send_350_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_0F6_Sig_BSI_T_EXT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_Send_0f6_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH1_ID_128_Sig_BSI_OUCP(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_Send_128_Msg_Count, 5u) >> 4u) & 0x01u));
}
uint8_t  Get_CAN_CH1_ID_5E0_Sig_EDR_Full(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_5E0_EDR_Msg_Count, 0u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH1_ID_5E0_Sig_EDR_Fault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_5E0_EDR_Msg_Count, 0u) >> 0u) & 0x01u));
}
uint8_t  Get_CAN_CH1_ID_302_Sig_PWT_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID_302_VCU01_Msg_Count, 4u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH1_ID_302_Sig_PWT_Fault_Level(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID_302_VCU01_Msg_Count, 3u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH1_ID_302_Sig_VCU_Fault_Level(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID_302_VCU01_Msg_Count, 3u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH1_ID_302_Sig_PWT_ModeRequest(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID_302_VCU01_Msg_Count, 2u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH1_ID_302_Sig_PWT_NetWork_Request(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID_302_VCU01_Msg_Count, 2u) >> 0u) & 0x07u));
}

uint16_t Get_CAN_CH1_ID_442_Sig_ChgPower_HMI(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID442_VCU_HMI1_Msg_Count, 5u) >> 0u) & 0x0Fu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID442_VCU_HMI1_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH1_ID_442_Sig_ChargeConnection_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID442_VCU_HMI1_Msg_Count, 4u) >> 0u) & 0x03u));
}

uint16_t Get_CAN_CH1_ID_442_Sig_VCM_Instant_EnergyConsum(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID442_VCU_HMI1_Msg_Count, 2u) >> 0u) & 0x03u) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID442_VCU_HMI1_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH1_ID_442_Sig_DrvPower_HMI(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID442_VCU_HMI1_Msg_Count, 0u) >> 0u) & 0x0Fu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID442_VCU_HMI1_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH1_ID_342_Sig_VCM_EstimateMileage(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID342_VCU_HMI2_Msg_Count, 6u) >> 0u) & 0x03u) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID342_VCU_HMI2_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH1_ID_342_Sig_VCM_Mileage2Average_EnergyConsum(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID342_VCU_HMI2_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH1_ID_342_Sig_VCM_Mileage1Average_EnergyConsum(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID342_VCU_HMI2_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH1_ID_342_Sig_VCM_Average_EnergyConsum(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID342_VCU_HMI2_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH1_ID_342_Sig_Matching_state(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID342_VCU_HMI2_Msg_Count, 2u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_342_Sig_VCM_stDrvReqWrgOptInfo(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID342_VCU_HMI2_Msg_Count, 2u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH1_ID_342_Sig_Remote_GeoFenceHMI(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID342_VCU_HMI2_Msg_Count, 0u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH1_ID_342_Sig_Remote_GeoFenceSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID342_VCU_HMI2_Msg_Count, 0u) >> 0u) & 0x0Fu));
}

uint16_t Get_CAN_CH1_ID_214_Sig_BMS_faultcode(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID214_BMS02_Msg_Count, 3u) >> 0u) & 0xFFu) << 1u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID214_BMS02_Msg_Count, 4u) >> 7u) & 0x01u));
}

uint16_t Get_CAN_CH1_ID_214_Sig_BMS_SOE(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID214_BMS02_Msg_Count, 0u) >> 0u) & 0x7Fu) << 5u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID214_BMS02_Msg_Count, 1u) >> 3u) & 0x1Fu));
}

uint8_t  Get_CAN_CH1_ID_214_Sig_BMS_PositiveQickChargeRelay(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID214_BMS02_Msg_Count, 4u) >> 3u) & 0x07u));
}

uint8_t  Get_CAN_CH1_ID_214_Sig_BMS_NegetiveQickChargeRelaySts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID214_BMS02_Msg_Count, 4u) >> 0u) & 0x07u));
}

uint8_t  Get_CAN_CH1_ID_214_Sig_BMS_Safety_IR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID214_BMS02_Msg_Count, 2u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_214_Sig_BMS_TI_Alert(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID214_BMS02_Msg_Count, 2u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_214_Sig_BMS_Crash_Fault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID214_BMS02_Msg_Count, 2u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_214_Sig_BMS_Safety_Fault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID214_BMS02_Msg_Count, 2u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_222_Sig_GeneMode_State_HMI(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID222_VCU06_Msg_Count, 4u) >> 3u) & 0x07u));
}

uint8_t  Get_CAN_CH1_ID_222_Sig_DriveMode_State_HMI(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID222_VCU06_Msg_Count, 4u) >> 0u) & 0x07u));
}

uint16_t Get_CAN_CH1_ID_222_Sig_VCU_VehicleSpeed_Lmt(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID222_VCU06_Msg_Count, 2u) >> 0u) & 0x0Fu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID222_VCU06_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH1_ID_222_Sig_VCU_AccelPedal_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID222_VCU06_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH1_ID_222_Sig_VCU_BrakePedal_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID222_VCU06_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_222_Sig_VCU_ShiftLeverPosition(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID222_VCU06_Msg_Count, 0u) >> 0u) & 0x0Fu));
}
uint8_t  Get_CAN_CH1_ID_254_Sig_REMOTE_TURN_LIGHTS_REQ(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID254_REMOTE_ACTION_REQ_Msg_Count, 7u) >> 5u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_254_Sig_REMOTE_HORN_REQUEST(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID254_REMOTE_ACTION_REQ_Msg_Count, 7u) >> 3u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_254_Sig_REMOTE_LOCK_UNLOCK_REQ(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID254_REMOTE_ACTION_REQ_Msg_Count, 7u) >> 0u) & 0x07u));
}

uint8_t  Get_CAN_CH1_ID_43C_Sig_CAUSE_1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID43C_REVEIL_MDS_Msg_Count, 1u) >> 7u) & 0x01u));
}

uint16_t Get_CAN_CH1_ID_334_Sig_BMS_PackVoltage(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID334_BMS_05_Msg_Count, 6u) >> 0u) & 0x3Fu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID334_BMS_05_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH1_ID_334_Sig_BMS_MainCurrent(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID334_BMS_05_Msg_Count, 4u) >> 0u) & 0x3Fu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID334_BMS_05_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH1_ID_334_Sig_BMS_SOH(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID334_BMS_05_Msg_Count, 2u) >> 0u) & 0x03u) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID334_BMS_05_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH1_ID_334_Sig_BMS_USOC(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID334_BMS_05_Msg_Count, 0u) >> 0u) & 0x03u) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID334_BMS_05_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH1_ID_306_Sig_MCU_ASC_Sts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID306_MCU_01_Msg_Count, 3u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_306_Sig_MCU_Ready(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID306_MCU_01_Msg_Count, 3u) >> 3u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_306_Sig_ActiveDischarge_Sts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID306_MCU_01_Msg_Count, 3u) >> 0u) & 0x07u));
}

uint8_t  Get_CAN_CH1_ID_306_Sig_MCU_Fault_Level(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID306_MCU_01_Msg_Count, 2u) >> 3u) & 0x0Fu));
}

uint8_t  Get_CAN_CH1_ID_306_Sig_MCU_Wakeup_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID306_MCU_01_Msg_Count, 2u) >> 0u) & 0x07u));
}

uint8_t  Get_CAN_CH1_ID_304_Sig_BMS_CCEStop_Req(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID304_BMS_01_Msg_Count, 5u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_304_Sig_Rcd_BMS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID304_BMS_01_Msg_Count, 4u) >> 5u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_304_Sig_DCCharge_Relay_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID304_BMS_01_Msg_Count, 4u) >> 2u) & 0x07u));
}

uint8_t  Get_CAN_CH1_ID_304_Sig_DCCharge_Relay_cmd(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID304_BMS_01_Msg_Count, 4u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_304_Sig_BMS_PowerRelay_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID304_BMS_01_Msg_Count, 3u) >> 5u) & 0x07u));
}

uint8_t  Get_CAN_CH1_ID_304_Sig_BMS_DCChg_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID304_BMS_01_Msg_Count, 3u) >> 2u) & 0x07u));
}

uint8_t  Get_CAN_CH1_ID_304_Sig_BMS_EndofCharge_Req(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID304_BMS_01_Msg_Count, 3u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH1_ID_304_Sig_BMS_Fault_Level(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID304_BMS_01_Msg_Count, 2u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH1_ID_304_Sig_BMS_Wakeup_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_ID304_BMS_01_Msg_Count, 2u) >> 0u) & 0x07u));
}
uint16_t Get_CAN_CH1_ID_364_Sig_BMS_Charger_OutputCurrent(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_BMS_07_Msg_Count, 6u) >> 0u) & 0x3Fu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_BMS_07_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH1_ID_364_Sig_BMS_ChargeCurrentRequest(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_BMS_07_Msg_Count, 0u) >> 0u) & 0x3Fu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH1,CAN_CH1_ID_BMS_07_Msg_Count, 1u) >> 0u) & 0xFFu));
}
uint8_t  Co_Can_ConvertSubID_CAN_CH1(uint32_t MsgID)
{
    uint8_t u8Result = CAN_CH1_ID_TOTAL_MAX;
    switch (MsgID)
    {
    case CAN_CH1_ID_ID131_MCU1_Msg:
        u8Result = CAN_CH1_ID_ID131_MCU1_Msg_Count;
        break;
    case CAN_CH1_ID_ID3F1_IC1_Msg:
        u8Result = CAN_CH1_ID_ID3F1_IC1_Msg_Count;
        break;
    case CAN_CH1_ID_ID139_VCM2_Msg:
        u8Result = CAN_CH1_ID_ID139_VCM2_Msg_Count;
        break;
    case CAN_CH1_ID_ID153_BMS2_Msg:
        u8Result = CAN_CH1_ID_ID153_BMS2_Msg_Count;
        break;
    case CAN_CH1_ID_ID152_BMS3_Msg:
        u8Result = CAN_CH1_ID_ID152_BMS3_Msg_Count;
        break;
    case CAN_CH1_ID_ID320_BMS5_Msg:
        u8Result = CAN_CH1_ID_ID320_BMS5_Msg_Count;
        break;
    case CAN_CH1_ID_ID24A_BMS6_Msg:
        u8Result = CAN_CH1_ID_ID24A_BMS6_Msg_Count;
        break;
    case CAN_CH1_ID_ID211_VCM5_Msg:
        u8Result = CAN_CH1_ID_ID211_VCM5_Msg_Count;
        break;
    case CAN_CH1_ID_ID35A_VCM9_Msg:
        u8Result = CAN_CH1_ID_ID35A_VCM9_Msg_Count;
        break;
    case CAN_CH1_ID_ID2E1_OBC2_Msg:
        u8Result = CAN_CH1_ID_ID2E1_OBC2_Msg_Count;
        break;
    case CAN_CH1_ID_ID389_TPMS_Msg:
        u8Result = CAN_CH1_ID_ID389_TPMS_Msg_Count;
        break;
    case CAN_CH1_ID_ID135_VCM3_Msg:
        u8Result = CAN_CH1_ID_ID135_VCM3_Msg_Count;
        break;
    case CAN_CH1_ID_ID366_CHM1_Msg:
        u8Result = CAN_CH1_ID_ID366_CHM1_Msg_Count;
        break;
    case CAN_CH1_ID_ID521_VCMTBOX1_Msg:
        u8Result = CAN_CH1_ID_ID521_VCMTBOX1_Msg_Count;
        break;
    case CAN_CH1_ID_ID341_BMS7_Msg:
        u8Result = CAN_CH1_ID_ID341_BMS7_Msg_Count;
        break;
    case CAN_CH1_ID_ID431_VCM_Msg:
        u8Result = CAN_CH1_ID_ID431_VCM_Msg_Count;
        break;
    case CAN_CH1_ID_ID123_Msg:
        u8Result = CAN_CH1_ID_ID123_Msg_Count;
        break;
    case CAN_CH1_ID_ID137_EGS_Fault_Msg:
        u8Result = CAN_CH1_ID_ID137_EGS_Fault_Msg_Count;
        break;
    case CAN_CH1_ID_Send_190_Msg:
        u8Result = CAN_CH1_ID_Send_190_Msg_Count;
        break;
    case CAN_CH1_ID_Send_276_Msg:
        u8Result = CAN_CH1_ID_Send_276_Msg_Count;
        break;
    case CAN_CH1_ID_Send_350_Msg:
        u8Result = CAN_CH1_ID_Send_350_Msg_Count;
        break;
    case CAN_CH1_ID_Send_0f6_Msg:
        u8Result = CAN_CH1_ID_Send_0f6_Msg_Count;
        break;
    case CAN_CH1_ID_Send_128_Msg:
        u8Result = CAN_CH1_ID_Send_128_Msg_Count;
        break;
    case CAN_CH1_ID_5E0_EDR_Msg:
        u8Result = CAN_CH1_ID_5E0_EDR_Msg_Count;
        break;
    case CAN_CH1_ID_ID_302_VCU01_Msg:
        u8Result = CAN_CH1_ID_ID_302_VCU01_Msg_Count;
        break;
    case CAN_CH1_ID_ID442_VCU_HMI1_Msg:
        u8Result = CAN_CH1_ID_ID442_VCU_HMI1_Msg_Count;
        break;
    case CAN_CH1_ID_ID342_VCU_HMI2_Msg:
        u8Result = CAN_CH1_ID_ID342_VCU_HMI2_Msg_Count;
        break;
    case CAN_CH1_ID_ID214_BMS02_Msg:
        u8Result = CAN_CH1_ID_ID214_BMS02_Msg_Count;
        break;
    case CAN_CH1_ID_ID222_VCU06_Msg:
        u8Result = CAN_CH1_ID_ID222_VCU06_Msg_Count;
        break;
    case CAN_CH1_ID_ID254_REMOTE_ACTION_REQ_Msg:
        u8Result = CAN_CH1_ID_ID254_REMOTE_ACTION_REQ_Msg_Count;
        break;
    case CAN_CH1_ID_ID43C_REVEIL_MDS_Msg:
        u8Result = CAN_CH1_ID_ID43C_REVEIL_MDS_Msg_Count;
        break;
    case CAN_CH1_ID_ID334_BMS_05_Msg:
        u8Result = CAN_CH1_ID_ID334_BMS_05_Msg_Count;
        break;
    case CAN_CH1_ID_ID306_MCU_01_Msg:
        u8Result = CAN_CH1_ID_ID306_MCU_01_Msg_Count;
        break;
    case CAN_CH1_ID_ID304_BMS_01_Msg:
        u8Result = CAN_CH1_ID_ID304_BMS_01_Msg_Count;
        break;
    case CAN_CH1_ID_BMS_07_Msg:
        u8Result = CAN_CH1_ID_BMS_07_Msg_Count;
        break;
    default :
        u8Result = CAN_CH1_ID_TOTAL_MAX;
        break;
    }
    return u8Result;
}

void Test_send_cycle(uint16_t u16ID)
{
    _CAN_Msg pMsg;

    pMsg.MsgID = u16ID;
    pMsg.MsgDLC = 8;
    pMsg.MsgPro = 0u;
    pMsg.MsgRTR = 0;
    pMsg.MsgStd = 0;
    pMsg.Msg[0] = 01;
    pMsg.Msg[1] = 01;
    pMsg.Msg[2] = 01;
    pMsg.Msg[3] = 01;
    pMsg.Msg[4] = 01;
    pMsg.Msg[5] = 01;
    pMsg.Msg[6] = 01;
    pMsg.Msg[7] = 01;

    Can_CH2_Write(&pMsg);
}


uint8_t  CAN_CH1_SendID_Convert(uint32_t MsgID)
{
    uint8_t u8Result = CAN_CH1_ID_SEND_TOTAL;
      
    switch (MsgID)
    {
        case 0x276:
            u8Result = CAN_CH1_MSGID_276;
        break;
        case 0x350:
            u8Result = CAN_CH1_MSGID_350;
        break;
        case 0x190:
            u8Result = CAN_CH1_MSGID_190;
        break;
        case 0x128:
            u8Result = CAN_CH1_MSGID_128;
        break;
        case 0x0F6:
            u8Result = CAN_CH1_MSGID_0F6;
        break;
        case 0x3F1:
            u8Result = CAN_CH1_MSGID_3F1;
        break;
        case 0x036:
            u8Result = CAN_CH1_MSGID_036;
        break;
        case 0x294:
            u8Result = CAN_CH1_MSGID_294;
        break;
        default :
            u8Result = CAN_CH1_ID_SEND_TOTAL;
        break;
        
    }

    return u8Result;
    
}